/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  cellrenderer.cc - GtkCellRenderer C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "cellrenderer.h"
#include "private/cellrenderer_p.h"
#include "celleditable.h"
#include "widget.h"
#include "../gdk/color.h"
#include "../gdk/events.h"
#include "../gdk/types.h"
#include "../gdk/window.h"
#include "../gdk-pixbuf/pixbuf.h"
#include "../pango/font.h"
#include "../pango/attributes.h"

using namespace Inti;

/*  Gtk::CellRenderer
 */

Gtk::CellRenderer::CellRenderer(GtkCellRenderer *cell, bool reference)
: Object((GtkObject*)cell, reference)
{
}
	
Gtk::CellRenderer::~CellRenderer() 
{
}
	
GtkCellRendererClass* 
Gtk::CellRenderer::gtk_cell_renderer_class() const 
{ 
	return get_class<GtkCellRendererClass>();
}

Gtk::CellRenderer::operator GtkCellRenderer* () const 
{ 
	return this ? gtk_cell_renderer() : 0; 
}

void
Gtk::CellRenderer::get_fixed_size(int *width, int *height)
{
	gtk_cell_renderer_get_fixed_size(gtk_cell_renderer(), width, height);
}

void
Gtk::CellRenderer::get_size(const Widget& widget, const Gdk::Rectangle *cell_area,
                            int *x_offset, int *y_offset, int *width, int *height) const
{
	gtk_cell_renderer_get_size(gtk_cell_renderer(), widget.gtk_widget(), *cell_area, x_offset, y_offset, width, height);
}

void
Gtk::CellRenderer::render(Gdk::Window& window, Widget& widget, const Gdk::Rectangle *background_area,
                          const Gdk::Rectangle *cell_area, const Gdk::Rectangle *expose_area,
                          CellRendererStateField flags)
{
	gtk_cell_renderer_render(gtk_cell_renderer(), window.gdk_window(), widget.gtk_widget(), *background_area,
	                         *cell_area, *expose_area, (GtkCellRendererState)flags);
}

bool
Gtk::CellRenderer::activate(const Gdk::Event *event, Widget *widget, const String& path,
                            const Gdk::Rectangle *background_area, const Gdk::Rectangle *cell_area,
							CellRendererStateField flags)
{
	return gtk_cell_renderer_activate(gtk_cell_renderer(), *event, *widget, path.c_str(), *background_area, *cell_area,
	                                  (GtkCellRendererState)flags);
}

Pointer<Gtk::CellEditable>
Gtk::CellRenderer::start_editing(const Gdk::Event *event, Widget *widget, const String& path,
                                 const Gdk::Rectangle *background_area, const Gdk::Rectangle *cell_area,
                                 CellRendererStateField flags)
{
	GtkCellEditable *cell_editable = gtk_cell_renderer_start_editing(gtk_cell_renderer(), *event, *widget, path.c_str(),
	                                                                 *background_area, *cell_area, (GtkCellRendererState)flags);
	Widget *tmp_widget = G::Object::wrap<Widget>(GTK_WIDGET(cell_editable));
	return tmp_widget ? dynamic_cast<CellEditable*>(tmp_widget) : 0;
}

void
Gtk::CellRenderer::set_fixed_size(int width, int height)
{
	gtk_cell_renderer_set_fixed_size(gtk_cell_renderer(), width, height);
}

/*  Gtk::CellRendererClass
 */

void
Gtk::CellRendererClass::init(GtkCellRendererClass *g_class)
{
	ObjectClass::init((GtkObjectClass*)g_class);
	g_class->get_size = &get_size_proxy;
	g_class->render = &render_proxy;
	g_class->activate = &activate_proxy;
	g_class->start_editing = &start_editing_proxy;
}

GType
Gtk::CellRendererClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_CELL_RENDERER, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::CellRendererClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::CellRendererClass::get_size_proxy(GtkCellRenderer *cell, GtkWidget *widget, GdkRectangle *cell_area,
                                       gint *x_offset, gint *y_offset, gint *width,  gint *height)
{
	CellRenderer *tmp_cell = G::Object::pointer<CellRenderer>(cell);
	if (tmp_cell)
		tmp_cell->do_get_size(widget, cell_area, x_offset, y_offset, width, height);
	else
	{
		GtkCellRendererClass *tmp_class = GTK_CELL_RENDERER_GET_CLASS(cell);
		GtkCellRendererClass *g_class = G::TypeInstance::class_peek_parent<GtkCellRendererClass>(tmp_class);
		if (g_class->get_size)
			g_class->get_size(cell, widget, cell_area, x_offset, y_offset, width, height);
	}
}

void
Gtk::CellRendererClass::render_proxy(GtkCellRenderer *cell, GdkWindow *window, GtkWidget *widget, GdkRectangle *background_area,
                                     GdkRectangle *cell_area, GdkRectangle *expose_area, GtkCellRendererState flags)
{
	CellRenderer *tmp_cell = G::Object::pointer<CellRenderer>(cell);
	if (tmp_cell)
		tmp_cell->do_render(window, widget, background_area, cell_area, expose_area, flags);
	else
	{
		GtkCellRendererClass *tmp_class = GTK_CELL_RENDERER_GET_CLASS(cell);
		GtkCellRendererClass *g_class = G::TypeInstance::class_peek_parent<GtkCellRendererClass>(tmp_class);
		if (g_class->render)
			g_class->render(cell, window, widget, background_area, cell_area, expose_area, flags);
	}
}

gboolean
Gtk::CellRendererClass::activate_proxy(GtkCellRenderer *cell, GdkEvent *event, GtkWidget *widget, const gchar *path,
                                       GdkRectangle *background_area, GdkRectangle *cell_area, GtkCellRendererState flags)
{
	gboolean result = FALSE;
	CellRenderer *tmp_cell = G::Object::pointer<CellRenderer>(cell);
	if (tmp_cell)
		result = tmp_cell->do_activate(event, widget, path, background_area, cell_area, flags);
	else
	{
		GtkCellRendererClass *tmp_class = GTK_CELL_RENDERER_GET_CLASS(cell);
		GtkCellRendererClass *g_class = G::TypeInstance::class_peek_parent<GtkCellRendererClass>(tmp_class);
		if (g_class->activate)
			result = g_class->activate(cell, event, widget, path, background_area, cell_area, flags);
	}
	return result;
}

GtkCellEditable*
Gtk::CellRendererClass::start_editing_proxy(GtkCellRenderer *cell, GdkEvent *event, GtkWidget *widget, const gchar *path,
                                            GdkRectangle *background_area, GdkRectangle *cell_area, GtkCellRendererState flags)
{
	GtkCellEditable *editable = 0;
	CellRenderer *tmp_cell = G::Object::pointer<CellRenderer>(cell);
	if (tmp_cell)
		editable = tmp_cell->do_start_editing(event, widget, path, background_area, cell_area, flags);
	else
	{
		GtkCellRendererClass *tmp_class = GTK_CELL_RENDERER_GET_CLASS(cell);
		GtkCellRendererClass *g_class = G::TypeInstance::class_peek_parent<GtkCellRendererClass>(tmp_class);
		if (g_class->start_editing)
			editable = g_class->start_editing(cell, event, widget, path, background_area, cell_area, flags);
	}
	return editable;
}

/*  Overridable GtkCellRenderer methods
 */

void
Gtk::CellRenderer::do_get_size(GtkWidget *widget, GdkRectangle *cell_area, int *x_offset, int *y_offset, int *width, int *height)
{
	GtkCellRendererClass *g_class = class_peek_parent<GtkCellRendererClass>(gtk_cell_renderer_class());
	if (g_class->get_size)
		g_class->get_size(gtk_cell_renderer(), widget, cell_area, x_offset, y_offset, width, height);
}

void
Gtk::CellRenderer::do_render(GdkWindow *window, GtkWidget *widget, GdkRectangle *background_area, GdkRectangle *cell_area,
                             GdkRectangle *expose_area, GtkCellRendererState flags)
{
	GtkCellRendererClass *g_class = class_peek_parent<GtkCellRendererClass>(gtk_cell_renderer_class());
	if (g_class->render)
		g_class->render(gtk_cell_renderer(), window, widget, background_area, cell_area, expose_area, flags);
}

bool
Gtk::CellRenderer::do_activate(GdkEvent *event, GtkWidget *widget, const char *path, GdkRectangle *background_area,
                               GdkRectangle *cell_area, GtkCellRendererState flags)
{
	bool result = false;
	GtkCellRendererClass *g_class = class_peek_parent<GtkCellRendererClass>(gtk_cell_renderer_class());
	if (g_class->activate)
		result = g_class->activate(gtk_cell_renderer(), event, widget, path, background_area, cell_area, flags);
	return result;
}

GtkCellEditable*
Gtk::CellRenderer::do_start_editing(GdkEvent *event, GtkWidget *widget, const char *path, GdkRectangle *background_area,
                                    GdkRectangle *cell_area, GtkCellRendererState flags)
{
	GtkCellEditable *editable = 0;
	GtkCellRendererClass *g_class = class_peek_parent<GtkCellRendererClass>(gtk_cell_renderer_class());
	if (g_class->start_editing)
		editable = g_class->start_editing(gtk_cell_renderer(), event, widget, path, background_area, cell_area, flags);
	return editable;
}

/*  Gtk::CellRenderer properties
 */

const Gtk::CellRenderer::ModePropertyType Gtk::CellRenderer::mode_property("mode");

const Gtk::CellRenderer::VisiblePropertyType Gtk::CellRenderer::visible_property("visible");

const Gtk::CellRenderer::XAlignPropertyType Gtk::CellRenderer::xalign_property("xalign");

const Gtk::CellRenderer::YAlignPropertyType Gtk::CellRenderer::yalign_property("yalign");

const Gtk::CellRenderer::XPadPropertyType Gtk::CellRenderer::xpad_property("xpad");

const Gtk::CellRenderer::YPadPropertyType Gtk::CellRenderer::ypad_property("ypad");

const Gtk::CellRenderer::WidthPropertyType Gtk::CellRenderer::width_property("width");

const Gtk::CellRenderer::HeightPropertyType Gtk::CellRenderer::height_property("height");

const Gtk::CellRenderer::IsExpanderPropertyType Gtk::CellRenderer::is_expander_property("is_expander");

const Gtk::CellRenderer::IsExpandedPropertyType Gtk::CellRenderer::is_expanded_property("is_expanded");

const Gtk::CellRenderer::CellBackgroundPropertyType Gtk::CellRenderer::cell_background_property("cell_background");

const Gtk::CellRenderer::CellBackgroundGdkPropertyType Gtk::CellRenderer::cell_background_gdk_property("cell_background_gdk");

const Gtk::CellRenderer::CellBackgroundSetPropertyType Gtk::CellRenderer::cell_background_set_property("cell_background_set");

/*  Gtk::CellRendererPixbuf
 */

Gtk::CellRendererPixbuf::CellRendererPixbuf(GtkCellRendererPixbuf *cell, bool reference)
: CellRenderer((GtkCellRenderer*)cell, reference)
{
}

Gtk::CellRendererPixbuf::CellRendererPixbuf()
: CellRenderer((GtkCellRenderer*)CellRendererPixbufClass::create())
{
}

Gtk::CellRendererPixbuf::~CellRendererPixbuf()
{
}

GtkCellRendererPixbufClass*
Gtk::CellRendererPixbuf::gtk_cell_renderer_pixbuf_class() const
{
	return get_class<GtkCellRendererPixbufClass>();
}

Gtk::CellRendererPixbuf::operator GtkCellRendererPixbuf* () const
{
	return this ? gtk_cell_renderer_pixbuf() : 0;
}

/*  Gtk::CellRendererPixbufClass
 */

void
Gtk::CellRendererPixbufClass::init(GtkCellRendererPixbufClass *g_class)
{
	CellRendererClass::init((GtkCellRendererClass*)g_class);
}

GType
Gtk::CellRendererPixbufClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_CELL_RENDERER_PIXBUF, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::CellRendererPixbufClass::create()
{
	return g_object_new(get_type(), 0);
}

/*  Gtk::CellRendererPixbuf properties
 */

const Gtk::CellRendererPixbuf::PixbufPropertyType Gtk::CellRendererPixbuf::pixbuf_property("pixbuf");

const Gtk::CellRendererPixbuf::PixbufExpanderOpenPropertyType Gtk::CellRendererPixbuf::pixbuf_expander_open_property("pixbuf_expander_open");

const Gtk::CellRendererPixbuf::PixbufExpanderClosedPropertyType Gtk::CellRendererPixbuf::pixbuf_expander_closed_property("pixbuf_expander_closed");

const Gtk::CellRendererPixbuf::StockIdPropertyType Gtk::CellRendererPixbuf::stock_id_property("stock_id");

const Gtk::CellRendererPixbuf::StockSizePropertyType Gtk::CellRendererPixbuf::stock_size_property("stock_size");

const Gtk::CellRendererPixbuf::StockDetailPropertyType Gtk::CellRendererPixbuf::stock_detail_property("stock_detail");

/*  Gtk::CellRendererText
 */

Gtk::CellRendererText::CellRendererText(GtkCellRendererText *cell, bool reference)
: CellRenderer((GtkCellRenderer*)cell, reference)
{
}

Gtk::CellRendererText::CellRendererText()
: CellRenderer((GtkCellRenderer*)CellRendererTextClass::create())
{
}

Gtk::CellRendererText::~CellRendererText()
{
}

GtkCellRendererTextClass*
Gtk::CellRendererText::gtk_cell_renderer_text_class() const
{
	return get_class<GtkCellRendererTextClass>();
}

Gtk::CellRendererText::operator GtkCellRendererText* () const
{
	return this ? gtk_cell_renderer_text() : 0;
}

void
Gtk::CellRendererText::set_fixed_height_from_font(int number_of_rows)
{
	gtk_cell_renderer_text_set_fixed_height_from_font(gtk_cell_renderer_text(), number_of_rows);
}

/*  Gtk::CellRendererTextClass
 */

void
Gtk::CellRendererTextClass::init(GtkCellRendererTextClass *g_class)
{
	CellRendererClass::init((GtkCellRendererClass*)g_class);
	g_class->edited = &edited_proxy;
}

GType
Gtk::CellRendererTextClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_CELL_RENDERER_TEXT, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::CellRendererTextClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::CellRendererTextClass::edited_proxy(GtkCellRendererText *cell_renderer_text, const gchar *path, const gchar *new_text)
{
	CellRendererText *tmp_cell_renderer_text = G::Object::pointer<CellRendererText>(cell_renderer_text);
	if (tmp_cell_renderer_text)
	{
		std::string tmp_path(path);
		std::string tmp_new_text(new_text);
		tmp_cell_renderer_text->on_edited(tmp_path, tmp_new_text);
	}
	else
	{
		GtkCellRendererTextClass *tmp_class = GTK_CELL_RENDERER_TEXT_GET_CLASS(cell_renderer_text);
		GtkCellRendererTextClass *g_class = G::TypeInstance::class_peek_parent<GtkCellRendererTextClass>(tmp_class);
		if (g_class->edited)
			g_class->edited(cell_renderer_text, path, new_text);
	}
}

/*  Gtk::CellRendererText signal handlers
 */

void
Gtk::CellRendererText::on_edited(const String& path, const String& new_text)
{
	GtkCellRendererTextClass *g_class = class_peek_parent<GtkCellRendererTextClass>(gtk_cell_renderer_text_class());
	if (g_class->edited)
		g_class->edited(gtk_cell_renderer_text(), path.c_str(), new_text.c_str());
}

/*  Gtk::CellRendererText properties
 */

const Gtk::CellRendererText::TextPropertyType Gtk::CellRendererText::text_property("text");

const Gtk::CellRendererText::MarkupPropertyType Gtk::CellRendererText::markup_property("markup");

const Gtk::CellRendererText::AttributePropertyType Gtk::CellRendererText::attribute_property("attribute");

const Gtk::CellRendererText::BackgroundPropertyType Gtk::CellRendererText::background_property("background");

const Gtk::CellRendererText::BackgroundGdkPropertyType Gtk::CellRendererText::background_gdk_property("background_gdk");

const Gtk::CellRendererText::ForegroundPropertyType Gtk::CellRendererText::foreground_property("foreground");

const Gtk::CellRendererText::ForegroundGdkPropertyType Gtk::CellRendererText::foreground_gdk_property("foreground_gdk");

const Gtk::CellRendererText::EditablePropertyType Gtk::CellRendererText::editable_property("editable");

const Gtk::CellRendererText::FontPropertyType Gtk::CellRendererText::font_property("font");

const Gtk::CellRendererText::FontDescPropertyType Gtk::CellRendererText::font_desc_property("font_desc");

const Gtk::CellRendererText::FamilyPropertyType Gtk::CellRendererText::family_property("family");

const Gtk::CellRendererText::StylePropertyType Gtk::CellRendererText::style_property("style");

const Gtk::CellRendererText::VariantPropertyType Gtk::CellRendererText::variant_property("variant");

const Gtk::CellRendererText::WeightPropertyType Gtk::CellRendererText::weight_property("weight");

const Gtk::CellRendererText::StretchPropertyType Gtk::CellRendererText::stretch_property("stretch");

const Gtk::CellRendererText::SizePropertyType Gtk::CellRendererText::size_property("size");

const Gtk::CellRendererText::SizePointsPropertyType Gtk::CellRendererText::size_points_property("size_points");

const Gtk::CellRendererText::ScalePropertyType Gtk::CellRendererText::scale_property("scale");

const Gtk::CellRendererText::RisePropertyType Gtk::CellRendererText::rise_property("rise");

const Gtk::CellRendererText::StrikethroughPropertyType Gtk::CellRendererText::strikethrough_property("strikethrough");

const Gtk::CellRendererText::UnderlinePropertyType Gtk::CellRendererText::underline_property("underline");

const Gtk::CellRendererText::BackgroundSetPropertyType Gtk::CellRendererText::background_set_property("background_set");

const Gtk::CellRendererText::ForegroundSetPropertyType Gtk::CellRendererText::foreground_set_property("foreground_set");

const Gtk::CellRendererText::EditableSetPropertyType Gtk::CellRendererText::editable_set_property("editable_set");

const Gtk::CellRendererText::FamilySetPropertyType Gtk::CellRendererText::family_set_property("family_set");

const Gtk::CellRendererText::StyleSetPropertyType Gtk::CellRendererText::style_set_property("style_set");

const Gtk::CellRendererText::VariantSetPropertyType Gtk::CellRendererText::variant_set_property("variant_set");

const Gtk::CellRendererText::WeightSetPropertyType Gtk::CellRendererText::weight_set_property("weight_set");

const Gtk::CellRendererText::StretchSetPropertyType Gtk::CellRendererText::stretch_set_property("stretch_set");

const Gtk::CellRendererText::SizeSetPropertyType Gtk::CellRendererText::size_set_property("size_set");

const Gtk::CellRendererText::ScaleSetPropertyType Gtk::CellRendererText::scale_set_property("scale_set");

const Gtk::CellRendererText::RiseSetPropertyType Gtk::CellRendererText::rise_set_property("rise_set");

const Gtk::CellRendererText::StrikethroughSetPropertyType Gtk::CellRendererText::strikethrough_set_property("strikethrough_set");

const Gtk::CellRendererText::UnderlineSetPropertyType Gtk::CellRendererText::underline_set_property("underline_set");

/*  Gtk::CellRendererText signals
 */

const Gtk::CellRendererText::EditedSignalType Gtk::CellRendererText::edited_signal("edited");

/*  Gtk::CellRendererToggle
 */

Gtk::CellRendererToggle::CellRendererToggle(GtkCellRendererToggle *cell, bool reference)
: CellRenderer((GtkCellRenderer*)cell, reference)
{
}

Gtk::CellRendererToggle::CellRendererToggle()
: CellRenderer((GtkCellRenderer*)CellRendererToggleClass::create())
{
}

Gtk::CellRendererToggle::~CellRendererToggle()
{
}

GtkCellRendererToggleClass*
Gtk::CellRendererToggle::gtk_cell_renderer_toggle_class() const
{
	return get_class<GtkCellRendererToggleClass>();
}


Gtk::CellRendererToggle::operator GtkCellRendererToggle* () const
{
	return this ? gtk_cell_renderer_toggle() : 0;
}

bool
Gtk::CellRendererToggle::get_active() const
{
	return gtk_cell_renderer_toggle_get_active(gtk_cell_renderer_toggle());
}

bool
Gtk::CellRendererToggle::get_radio() const
{
	return gtk_cell_renderer_toggle_get_radio(gtk_cell_renderer_toggle());
}

void
Gtk::CellRendererToggle::set_active(bool setting)
{
	gtk_cell_renderer_toggle_set_active(gtk_cell_renderer_toggle(), setting);
}

void
Gtk::CellRendererToggle::set_radio(bool radio)
{
	gtk_cell_renderer_toggle_set_radio(gtk_cell_renderer_toggle(), radio);
}

/*  Gtk::CellRendererToggleClass
 */

void
Gtk::CellRendererToggleClass::init(GtkCellRendererToggleClass *g_class)
{
	CellRendererClass::init((GtkCellRendererClass*)g_class);
	g_class->toggled = &toggled_proxy;
}

GType
Gtk::CellRendererToggleClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_CELL_RENDERER_TOGGLE, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::CellRendererToggleClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::CellRendererToggleClass::toggled_proxy(GtkCellRendererToggle *cell_renderer_toggle, const gchar *path)
{
	CellRendererToggle *tmp_cell_renderer_toggle = G::Object::pointer<CellRendererToggle>(cell_renderer_toggle);
	if (tmp_cell_renderer_toggle)
	{
		std::string tmp_path(path);
		tmp_cell_renderer_toggle->on_toggled(tmp_path);
	}
	else
	{
		GtkCellRendererToggleClass *tmp_class = GTK_CELL_RENDERER_TOGGLE_GET_CLASS(cell_renderer_toggle);
		GtkCellRendererToggleClass *g_class = G::TypeInstance::class_peek_parent<GtkCellRendererToggleClass>(tmp_class);
		if (g_class->toggled)
			g_class->toggled(cell_renderer_toggle, path);
	}
}

/*  Gtk::CellRendererToggle signal handlers
 */

void
Gtk::CellRendererToggle::on_toggled(const String& path)
{
	GtkCellRendererToggleClass *g_class = class_peek_parent<GtkCellRendererToggleClass>(gtk_cell_renderer_toggle_class());
	if (g_class->toggled)
		g_class->toggled(gtk_cell_renderer_toggle(), path.c_str());
}

/* Gtk::CellRendererToggle properties
 */

const Gtk::CellRendererToggle::ActivePropertyType Gtk::CellRendererToggle::active_property("active");

const Gtk::CellRendererToggle::ActivatablePropertyType Gtk::CellRendererToggle::activatable_property("activatable");

const Gtk::CellRendererToggle::RadioPropertyType Gtk::CellRendererToggle::radio_property("radio");

const Gtk::CellRendererToggle::InconsistentPropertyType Gtk::CellRendererToggle::inconsistent_property("inconsistent");

/*  Gtk::CellRendererToggle signals
 */

const Gtk::CellRendererToggle::ToggledSignalType Gtk::CellRendererToggle::toggled_signal("toggled");

