/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  bin.cc - GtkBin C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "bin.h"
#include "private/bin_p.h"

using namespace Inti;

Gtk::Bin::Bin(GtkBin *bin, bool reference)
: Container((GtkContainer*)bin, reference)
{
}

Gtk::Bin::Bin()
: Container((GtkContainer*)BinClass::create())
{
}

Gtk::Bin::~Bin()
{
}

GtkBinClass*
Gtk::Bin::gtk_bin_class() const 
{ 
	return get_class<GtkBinClass>(); 
}
	
Gtk::Bin::operator GtkBin* () const 
{ 
	return this ? gtk_bin() : 0; 
}
	
Gtk::Widget*
Gtk::Bin::get_child() const
{
	return G::Object::wrap<Widget>(gtk_bin_get_child(gtk_bin()));
}

/*  Gtk::BinClass
 */

void
Gtk::BinClass::init(GtkBinClass *g_class)
{
	ContainerClass::init((GtkContainerClass*)g_class);
}

GType
Gtk::BinClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_BIN, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::BinClass::create()
{
	return g_object_new(get_type(), 0);
}

