/***************************************************************************
 *   Copyright (C) 2006 by Bram Biesbrouck                                 *
 *   b@beligum.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 *
 *   In addition, as a special exception, the copyright holders give	   *
 *   permission to link the code of portions of this program with the	   *
 *   OpenSSL library under certain conditions as described in each	   *
 *   individual source file, and distribute linked combinations		   *
 *   including the two.							   *
 *   You must obey the GNU General Public License in all respects	   *
 *   for all of the code used other than OpenSSL.  If you modify	   *
 *   file(s) with this exception, you may extend this exception to your	   *
 *   version of the file(s), but you are not obligated to do so.  If you   *
 *   do not wish to do so, delete this exception statement from your	   *
 *   version.  If you delete this exception statement from all source	   *
 *   files in the program, then also delete it here.			   *
 ***************************************************************************/

#ifndef ISDFFMPEGEXPORTER_H
#define ISDFFMPEGEXPORTER_H

/**
 * Class implements various export formats.
 * Actually, nearly all formats supported by the FFmpeg library.
 * The format is chosen, based on the extension.
 *
 * @author Bram Biesbrouck <b@beligum.org>
 */

#include <string>
#include <glibmm/ustring.h>

#include <libinstrudeo/isdexporter.h>

#include <ffmpeg/avcodec.h>
#include <ffmpeg/avformat.h>

using namespace std;

#define DEFAULT_FFMPEG_EXPORT_FORMAT "mpeg"

//defines how many numbers after the comma are taken into account (1000=3)
#define FFMPEG_FRAMERATE_PRECISION 1000
#define FFMPEG_STREAM_PIX_FMT PIX_FMT_YUV420P
//GOP value for video output
#define FFMPEG_GOP_VALUE 12;
//size of video output buffer
#define FFMPEG_VIDEO_OUTBUF_SIZE 200000

class ISDProgressCallback;

class ISDFFmpegExporter : public ISDExporter
{
 public:
    ISDFFmpegExporter(string outFileName, ISDRecording* rec,
		      Glib::ustring* lang, ISDProgressCallback* callbackClass,
		      int quality = EXPORT_DEFAULT_QUALITY, float framerate = EXPORT_DEFAULT_FRAMERATE);

    virtual ~ISDFFmpegExporter();

    //-----OVERLOADED METHODS-----
    virtual ISDErrorCode doExport(char* pixelBuffer);

 protected:
    //-----OVERLOADED METHODS-----
    virtual void cleanup();

    //-----METHODS-----
    void abortCleanup();
    ISDErrorCode initializeEncoder();
    ISDErrorCode addVideoStream(CodecID codecId);
    ISDErrorCode allocInputPicture();
    ISDErrorCode openVideo();

    //-----VARIABLES-----
    AVCodec* codec;
    AVCodecContext* codecContext;
    /**
     * Wrapper around the original image data
     */
    AVPicture inputPicture;
    /**
     * Wrapper around the image converted to yuv420p
     */
    AVPicture yuvInputPicture;
    /**
     * The encoder takes a frame for its input,
     * so convert yuv_input_picture to AVFrame
     */
    AVFrame* inputFrame;
    /**
     * Input buffer for yuv_inputPicture and inputFrame
     */
    uint8_t* inputBuf;
    /**
     * Output buffer for encoded frame
     */
    uint8_t* outputBuf;
    AVFormatContext* outputContext;
    AVOutputFormat* outputFormat;
    AVStream *videoStream;
    /**
     * Size of yuv image
     */
    int outputBufSize;
    /**
     * Pix_fmt of original image
     */
    int inputPixFmt;
};

#endif
