#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.19';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFConfig',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CNTH',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo750D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfo80D',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoUnknown',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCalib2',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorCoefs2',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData10',
	'Image::ExifTool::Canon::ColorData11',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorData8',
	'Image::ExifTool::Canon::ColorData9',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::HDRInfo',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::LogInfo',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MultiExp',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::RawBurstInfo',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::Canon::WBInfo',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::CropInfo',
	'Image::ExifTool::CanonVRD::DLOInfo',
	'Image::ExifTool::CanonVRD::DR4',
	'Image::ExifTool::CanonVRD::DR4Header',
	'Image::ExifTool::CanonVRD::GammaInfo',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::ToneCurve',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DJI::Main',
	'Image::ExifTool::DJI::XMP',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::AFCSettings',
	'Image::ExifTool::FujiFilm::DriveSettings',
	'Image::ExifTool::FujiFilm::FocusSettings',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::FujiFilm::PrioritySettings',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::ColorSpec',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type5',
	'Image::ExifTool::Kodak::Type6',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::MacOS::MDItem',
	'Image::ExifTool::MacOS::XAttr',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Microsoft::Xtra',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Motorola::Main',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFInfo2V0400',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::AutoCaptureInfo',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::BracketingInfoD500',
	'Image::ExifTool::Nikon::BracketingInfoD810',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceB',
	'Image::ExifTool::Nikon::ColorBalanceC',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::FlashInfo0106',
	'Image::ExifTool::Nikon::FlashInfo0107',
	'Image::ExifTool::Nikon::FlashInfo0300',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::HDRInfo2',
	'Image::ExifTool::Nikon::ISOAutoInfoD810',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::IntervalInfoD6',
	'Image::ExifTool::Nikon::IntervalInfoZ7II',
	'Image::ExifTool::Nikon::JPGInfoD500',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LensData0402',
	'Image::ExifTool::Nikon::LensData0403',
	'Image::ExifTool::Nikon::LensData0800',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MakerNotes0x51',
	'Image::ExifTool::Nikon::MakerNotes0x56',
	'Image::ExifTool::Nikon::MenuSettingsD850',
	'Image::ExifTool::Nikon::MenuSettingsZ7II',
	'Image::ExifTool::Nikon::MenuSettingsZ8',
	'Image::ExifTool::Nikon::MenuSettingsZ9',
	'Image::ExifTool::Nikon::MenuSettingsZ9v3',
	'Image::ExifTool::Nikon::MenuSettingsZ9v4',
	'Image::ExifTool::Nikon::MoreSettingsD850',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::MultiExposure2',
	'Image::ExifTool::Nikon::Offset13InfoZ9',
	'Image::ExifTool::Nikon::OrientationInfo',
	'Image::ExifTool::Nikon::OtherInfoD500',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PictureControl2',
	'Image::ExifTool::Nikon::PictureControl3',
	'Image::ExifTool::Nikon::PortraitInfoZ7II',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::RetouchInfo',
	'Image::ExifTool::Nikon::RotationInfoD500',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::SeqInfoD6',
	'Image::ExifTool::Nikon::SeqInfoZ9',
	'Image::ExifTool::Nikon::SettingsInfoD810',
	'Image::ExifTool::Nikon::ShootingMenuD500',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD4S',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD4',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5',
	'Image::ExifTool::NikonCustom::SettingsD500',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD610',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD810',
	'Image::ExifTool::NikonCustom::SettingsD850',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::NikonCustom::SettingsZ8',
	'Image::ExifTool::NikonCustom::SettingsZ9',
	'Image::ExifTool::NikonCustom::SettingsZ9v4',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PLUS::XMP',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::PhysicalPixel',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::FocusInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Leica9',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::Panasonic::TimeInfo',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::PanasonicRaw::WBInfo',
	'Image::ExifTool::PanasonicRaw::WBInfo2',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AFPointInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::PixelShiftInfo',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhaseOne::Main',
	'Image::ExifTool::PhaseOne::SensorCalibration',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::ItemList',
	'Image::ExifTool::QuickTime::ItemPropCont',
	'Image::ExifTool::QuickTime::Keys',
	'Image::ExifTool::QuickTime::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::QuickTime::UserData',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Reconyx::Type2',
	'Image::ExifTool::Reconyx::Type3',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::OrientationInfo',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sigma::WBSettings',
	'Image::ExifTool::Sigma::WBSettings2',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFStatus15',
	'Image::ExifTool::Sony::AFStatus19',
	'Image::ExifTool::Sony::AFStatus79',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraInfo3',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::ISOInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MeterInfo9',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::SR2SubIFD',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag2010h',
	'Image::ExifTool::Sony::Tag2010i',
	'Image::ExifTool::Sony::Tag202a',
	'Image::ExifTool::Sony::Tag9050a',
	'Image::ExifTool::Sony::Tag9050b',
	'Image::ExifTool::Sony::Tag9050c',
	'Image::ExifTool::Sony::Tag9050d',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9404a',
	'Image::ExifTool::Sony::Tag9404b',
	'Image::ExifTool::Sony::Tag9404c',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::Device',
	'Image::ExifTool::XMP::ExifTool',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GAudio',
	'Image::ExifTool::XMP::GCamera',
	'Image::ExifTool::XMP::GCreations',
	'Image::ExifTool::XMP::GDepth',
	'Image::ExifTool::XMP::GFocus',
	'Image::ExifTool::XMP::GImage',
	'Image::ExifTool::XMP::GPano',
	'Image::ExifTool::XMP::GSpherical',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::LImage',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::crd',
	'Image::ExifTool::XMP::creatorAtom',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::hdr',
	'Image::ExifTool::XMP::hdrgm',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::panorama',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::pmi',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::prm',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 109 => 0x69 },
	'about' => { 523 => 'about' },
	'aboutcvterm' => { 514 => 'AboutCvTerm' },
	'aboutcvtermcvid' => { 514 => [\'AboutCvTerm','AboutCvTermCvId'] },
	'aboutcvtermid' => { 514 => [\'AboutCvTerm','AboutCvTermCvTermId'] },
	'aboutcvtermname' => { 514 => [\'AboutCvTerm','AboutCvTermCvTermName'] },
	'aboutcvtermrefinedabout' => { 514 => [\'AboutCvTerm','AboutCvTermCvTermRefinedAbout'] },
	'absolutealtitude' => { 116 => 'AbsoluteAltitude' },
	'abspeakaudiofilepath' => { 529 => 'absPeakAudioFilePath' },
	'academicfield' => { 519 => 'academicField' },
	'acceleration' => { 119 => 0x9404, 507 => 'Acceleration' },
	'accelerationtracking' => { 84 => 0x518 },
	'accelerationvector' => { 1 => 0x8 },
	'accelerometer' => { 410 => 0x3 },
	'accelerometerdata' => { 400 => 'vrot' },
	'accelerometerx' => { 340 => 0x8d },
	'accelerometery' => { 340 => 0x8e },
	'accelerometerz' => { 340 => 0x8c },
	'accessoryserialnumber' => { 340 => 0x54 },
	'accessorytype' => { 340 => 0x53 },
	'actionadvised' => { 131 => 0x2a },
	'activearea' => { 119 => 0xc68d },
	'actived-lighting' => { 234 => 0x22, 288 => 0x24 },
	'actived-lightingmode' => { 288 => 0x25 },
	'adaptervoltage' => { 138 => 0x407 },
	'addaspectratioinfo' => { 84 => 0x80e },
	'addiptcinformation' => { 84 => 0x815 },
	'additionalmodelinformation' => { 514 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 84 => 0x80f, 85 => 0x11, 86 => 0x13, 89 => 0x14 },
	'address' => { 161 => 'Address' },
	'adjustmentmode' => { 417 => 0x15 },
	'adlbracketingstep' => { 198 => 0x17 },
	'adlbracketingtype' => { 198 => 0x18 },
	'adobe' => { 120 => 'Adobe' },
	'adultcontentwarning' => { 327 => 'AdultContentWarning', 522 => 'adultContentWarning' },
	'advancedfilter' => { 127 => 0x1201 },
	'advancedraw' => { 290 => 0x76a43203 },
	'advancedscenetype' => { 340 => 0x3d },
	'advisory' => { 527 => 'Advisory' },
	'ae_iso' => { 348 => 0x2, 349 => 0x4, 350 => 0x12 },
	'aeaperture' => { 348 => 0x1, 349 => 0x3, 350 => 0x11 },
	'aeaperturesteps' => { 348 => 0x8, 349 => 0xb },
	'aeaverage' => { 1 => 0x6 },
	'aebautocancel' => { 84 => 0x104 },
	'aebbracketvalue' => { 77 => 0x11 },
	'aebracketingsteps' => { 198 => 0xf, 199 => 0xf, 271 => 0x174c },
	'aebsequence' => { 84 => 0x105 },
	'aebsequenceautocancel' => { 82 => 0x9, 83 => 0x9, 85 => 0x8, 86 => 0x9, 89 => 0x9, 90 => 0x7 },
	'aebshotcount' => { 84 => 0x106 },
	'aebxv' => { 348 => 0x4, 349 => 0x6 },
	'aeerror' => { 349 => 0x8 },
	'aeexposuretime' => { 348 => 0x0, 349 => 0x2, 350 => 0x10 },
	'aelbutton' => { 184 => 0x45 },
	'aelexposureindicator' => { 184 => 0x51 },
	'aelock' => { 184 => 0x5b, 299 => '4.2', 308 => '4.2', 317 => 0x201, 375 => 0x48, 427 => 0x40, 428 => 0x40, 429 => [0x86,0x286] },
	'aelockbutton' => { 297 => '16.1', 299 => '4.1', 302 => '15.1', 303 => '16.1', 304 => '16.1', 306 => '30.1', 307 => '16.1', 308 => '4.1', 310 => '17.1', 312 => '17.1' },
	'aelockbuttonplusdials' => { 297 => '16.2', 306 => '32.1', 310 => '44.1' },
	'aelockformb-d80' => { 312 => '3.1' },
	'aelockmetermodeafterfocus' => { 84 => 0x114 },
	'aematrix' => { 1 => 0x2 },
	'aemaxaperture' => { 348 => 0x9, 349 => 0x10, 350 => 0x1c },
	'aemaxaperture2' => { 348 => 0xa, 349 => 0x11, 350 => 0x1d },
	'aemeteringmode' => { 348 => 0xc },
	'aemeteringmode2' => { 348 => '13.1' },
	'aemeteringsegments' => { 187 => 0x628, 375 => 0x209 },
	'aemicroadjustment' => { 84 => 0x110 },
	'aeminaperture' => { 348 => 0xb, 349 => 0x12, 350 => 0x1e },
	'aeminexposuretime' => { 348 => 0x5, 349 => 0x13, 350 => 0x1f },
	'aeprogrammode' => { 348 => 0x6 },
	'aeprojectlink' => { 501 => 'aeProjectLink' },
	'aeprojectlinkcompositionid' => { 501 => [\'aeProjectLink','aeProjectLinkCompositionID'] },
	'aeprojectlinkfullpath' => { 501 => [\'aeProjectLink','aeProjectLinkFullPath'] },
	'aeprojectlinkrenderoutputmoduleindex' => { 501 => [\'aeProjectLink','aeProjectLinkRenderOutputModuleIndex'] },
	'aeprojectlinkrenderqueueitemid' => { 501 => [\'aeProjectLink','aeProjectLinkRenderQueueItemID'] },
	'aeprojectlinkrendertimestamp' => { 501 => [\'aeProjectLink','aeProjectLinkRenderTimeStamp'] },
	'aesetting' => { 34 => 0x21 },
	'aestable' => { 1 => 0x4 },
	'aetarget' => { 1 => 0x5 },
	'aewhitebalance' => { 348 => 0xd },
	'aexv' => { 348 => 0x3, 349 => 0x5 },
	'af-assistilluminator' => { 313 => 0x19, 314 => 0x19, 315 => 0x19 },
	'af-cfocusdisplay' => { 313 => 0x234, 314 => 0x234, 315 => 0x24c },
	'af-cpriority' => { 128 => '0.2' },
	'af-cpriorityselection' => { 297 => '1.1', 298 => '1.1', 300 => '1.1', 301 => '1.1', 303 => '0.1', 304 => '0.1', 305 => '0.1', 306 => '1.1', 307 => '0.1', 310 => '1.1', 311 => '1.1', 313 => 0x3, 314 => 0x3, 315 => 0x3 },
	'af-csetting' => { 124 => 0x0 },
	'af-cspeedtrackingsensitivity' => { 124 => '0.2' },
	'af-ctrackingsensitivity' => { 124 => '0.1' },
	'af-czoneareaswitching' => { 124 => '0.3' },
	'af-onbutton' => { 300 => '70.1', 301 => '70.1', 311 => '70.1' },
	'af-onformb-d10' => { 297 => '3.3', 306 => '3.2' },
	'af-onformb-d11' => { 307 => '2.2' },
	'af-onformb-d12' => { 310 => '50.1' },
	'af-onoutoffocusrelease' => { 313 => 0x10, 314 => 0x10, 315 => 0x10 },
	'af-spriority' => { 128 => '0.1' },
	'af-spriorityselection' => { 297 => '1.2', 298 => '1.2', 300 => '1.2', 301 => '1.2', 305 => '0.2', 306 => '1.2', 307 => '0.2', 310 => '1.2', 311 => '1.2', 313 => 0x5, 314 => 0x5, 315 => 0x5 },
	'afacceldeceltracking' => { 2 => 0x3 },
	'afactivation' => { 297 => '2.1', 298 => '2.1', 300 => '78.3', 301 => '78.3', 306 => '2.1', 310 => '2.1', 311 => '78.3', 313 => 0xf, 314 => 0xf, 315 => 0xf },
	'afadjustment' => { 375 => 0x72, 384 => 0x267 },
	'afandmeteringbuttons' => { 84 => 0x701 },
	'afaperture' => { 227 => 0x5, 228 => 0x5, 232 => 0x5 },
	'afareaheight' => { 193 => [0x1a,0x34,0x50], 194 => 0x48 },
	'afareaillumination' => { 184 => 0x4b, 308 => '15.3' },
	'afareainitialheight' => { 246 => 0xbeb },
	'afareainitialwidth' => { 246 => 0xbea },
	'afareainitialxposition' => { 246 => 0xbe8 },
	'afareainitialyposition' => { 246 => 0xbe9 },
	'afareamode' => { 126 => '0.3', 180 => 0x33, 184 => 0xe, 192 => 0x0, 193 => 0x5, 194 => 0x5, 239 => 0x224, 240 => 0x210, 241 => 0x224, 242 => 0x224, 340 => 0xf, 407 => 0x1205, 420 => [0xa,0x3a], 427 => 0x11, 428 => 0x10, 429 => 0x24, 440 => 0xb043, 466 => 0x17 },
	'afareamodesetting' => { 299 => '11.1', 302 => '0.1', 308 => '16.1', 312 => '2.1', 440 => 0x201c },
	'afareapointsize' => { 126 => '0.4' },
	'afareas' => { 317 => 0x304 },
	'afareaselectionmethod' => { 2 => 0xd },
	'afareaselectmethod' => { 84 => 0x51b },
	'afareawidth' => { 193 => [0x18,0x32,0x4e], 194 => 0x46 },
	'afareaxposition' => { 193 => [0x14,0x2e,0x4a], 194 => 0x42, 407 => 0x1203 },
	'afareaxposition1' => { 407 => 0x1201 },
	'afareayposition' => { 193 => [0x16,0x30,0x4c], 194 => 0x44, 407 => 0x1204 },
	'afareayposition1' => { 407 => 0x1202 },
	'afareazonesize' => { 126 => '0.5' },
	'afassist' => { 82 => 0x5, 90 => 0x5, 184 => 0x48, 297 => '2.5', 299 => '0.2', 302 => '0.2', 303 => '1.1', 304 => '1.1', 305 => '1.3', 306 => '2.4', 307 => '1.3', 308 => '0.2', 310 => '2.4', 312 => '2.3' },
	'afassistbeam' => { 2 => 0x8, 84 => 0x50e, 85 => 0x4, 86 => 0x5, 87 => 0x4, 88 => 0x4, 89 => 0x5 },
	'afassistlamp' => { 340 => 0x31 },
	'afbuttonpressed' => { 429 => [0x83,0x283] },
	'afconfidence' => { 1 => 0x3d },
	'afconfigtool' => { 2 => 0x1 },
	'afdefocus' => { 351 => 0x6 },
	'afduringliveview' => { 84 => 0x511 },
	'affinea' => { 494 => 'AffineA' },
	'affineb' => { 494 => 'AffineB' },
	'affinec' => { 494 => 'AffineC' },
	'affined' => { 494 => 'AffineD' },
	'affinetune' => { 195 => 0x0, 239 => 0x6b0, 240 => 0x5b0, 241 => 0x5e0, 242 => 0x5f8, 317 => 0x306 },
	'affinetuneadj' => { 195 => 0x2, 264 => 0x2d1, 265 => 0x2dc, 317 => 0x307 },
	'affinetuneadjtele' => { 195 => 0x3 },
	'affinetuneindex' => { 195 => 0x1 },
	'affinex' => { 494 => 'AffineX' },
	'affiney' => { 494 => 'AffineY' },
	'afhold' => { 351 => 0x1fd },
	'afilluminator' => { 427 => 0x29, 440 => 0xb044 },
	'afimageheight' => { 193 => [0x12,0x2c,0x48], 194 => 0x40 },
	'afimagewidth' => { 193 => [0x10,0x2a,0x46], 194 => 0x3e },
	'afintegrationtime' => { 351 => 0x7 },
	'afmeasureddepth' => { 1 => 0x38 },
	'afmicroadj' => { 420 => [0x17d,0x50] },
	'afmicroadjmode' => { 3 => 0x1, 424 => 0x131 },
	'afmicroadjregisteredlenses' => { 424 => '305.1' },
	'afmicroadjustment' => { 84 => 0x507 },
	'afmicroadjvalue' => { 3 => 0x2, 424 => 0x130 },
	'afmode' => { 113 => 0x3009, 127 => 0x1022, 180 => 0x16, 417 => 0x5 },
	'afmoderestrictions' => { 298 => '50.3', 300 => '48.3', 301 => '48.3', 310 => '48.3', 311 => '48.3' },
	'afonaelockbuttonswitch' => { 84 => 0x702 },
	'afonbutton' => { 297 => '3.1', 298 => '47.1', 313 => 0x83, 314 => 0x83, 315 => 0x83 },
	'afpoint' => { 34 => 0x13, 112 => 0x18, 180 => 0x15, 192 => 0x1, 320 => 0x308, 417 => 0x1f, 420 => [0x37,0x7], 424 => 0x19, 425 => 0x18, 426 => [0x18,0x20] },
	'afpointactivationarea' => { 83 => 0x11, 89 => 0x11 },
	'afpointareaexpansion' => { 84 => 0x508 },
	'afpointatshutterrelease' => { 420 => [0x39,0x9] },
	'afpointautoselection' => { 84 => 0x50b },
	'afpointbrightness' => { 84 => 0x50d, 297 => '2.4', 298 => '46.5', 300 => '2.2', 301 => '2.2', 310 => '2.3', 311 => '2.2' },
	'afpointdetails' => { 320 => 0x31b },
	'afpointdisplayduringfocus' => { 2 => 0x10, 84 => 0x50c },
	'afpointillumination' => { 83 => 0xa, 297 => '2.3', 298 => '46.2', 300 => '47.2', 301 => '47.2', 305 => '1.2', 306 => '2.3', 307 => '1.2', 310 => '47.2', 311 => '47.2', 312 => '2.4' },
	'afpointinfocus' => { 420 => [0x38,0x8] },
	'afpointmode' => { 356 => 0x3 },
	'afpointposition' => { 113 => 0x2021, 340 => 0x4d },
	'afpointregistration' => { 82 => 0x7 },
	'afpoints' => { 183 => 0x10 },
	'afpointsel' => { 313 => 0xb, 314 => 0xb, 315 => 0xb },
	'afpointselected' => { 184 => 0xd, 317 => 0x305, 375 => 0xe, 424 => 0x15, 425 => 0x14, 426 => [0x14,0x1c], 440 => 0x201e },
	'afpointselected2' => { 356 => 0x4 },
	'afpointselection' => { 83 => 0xb, 297 => '1.3', 298 => '1.3', 306 => '1.3', 310 => '1.3', 311 => '1.3' },
	'afpointselectionmethod' => { 84 => 0x50f, 85 => 0xc, 86 => 0xd, 89 => 0xd },
	'afpointsetting' => { 427 => 0x12, 428 => 0x11 },
	'afpointsinfocus' => { 77 => 0xe, 192 => 0x2, 193 => 0x30, 351 => 0xb, 352 => 0x4, 375 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 19 => 0x38 },
	'afpointspotmetering' => { 83 => 0xd },
	'afpointsselected' => { 193 => 0x1c, 352 => '4.1', 474 => 0x4 },
	'afpointsspecial' => { 352 => '4.2' },
	'afpointsunknown1' => { 351 => 0x0 },
	'afpointsunknown2' => { 351 => 0x2 },
	'afpointsused' => { 193 => [0xa,0x8], 194 => 0xa, 420 => [0x10,0x16e] },
	'afpointswitching' => { 2 => 0x4 },
	'afpredictor' => { 351 => 0x4 },
	'afresponse' => { 234 => 0xad },
	'afresult' => { 322 => 0x1038 },
	'afsearch' => { 317 => 0x303 },
	'afsensoractive' => { 180 => 0x1 },
	'afstable' => { 1 => 0x7 },
	'afstatus' => { 407 => 0x1200 },
	'afstatus_00_b4' => { 423 => 0x0 },
	'afstatus_01_c4' => { 423 => 0x2 },
	'afstatus_02_d4' => { 423 => 0x4 },
	'afstatus_03_e4' => { 423 => 0x6 },
	'afstatus_04_f4' => { 423 => 0x8 },
	'afstatus_05_g4' => { 423 => 0xa },
	'afstatus_06_h4' => { 423 => 0xc },
	'afstatus_07_b3' => { 423 => 0xe },
	'afstatus_08_c3' => { 423 => 0x10 },
	'afstatus_09_d3' => { 423 => 0x12 },
	'afstatus_10_e3' => { 423 => 0x14 },
	'afstatus_11_f3' => { 423 => 0x16 },
	'afstatus_12_g3' => { 423 => 0x18 },
	'afstatus_13_h3' => { 423 => 0x1a },
	'afstatus_14_b2' => { 423 => 0x1c },
	'afstatus_15_c2' => { 423 => 0x1e },
	'afstatus_16_d2' => { 423 => 0x20 },
	'afstatus_17_e2' => { 423 => 0x22 },
	'afstatus_18_f2' => { 423 => 0x24 },
	'afstatus_19_g2' => { 423 => 0x26 },
	'afstatus_20_h2' => { 423 => 0x28 },
	'afstatus_21_c1' => { 423 => 0x2a },
	'afstatus_22_d1' => { 423 => 0x2c },
	'afstatus_23_e1' => { 423 => 0x2e },
	'afstatus_24_f1' => { 423 => 0x30 },
	'afstatus_25_g1' => { 423 => 0x32 },
	'afstatus_26_a7_vertical' => { 423 => 0x34 },
	'afstatus_27_a6_vertical' => { 423 => 0x36 },
	'afstatus_28_a5_vertical' => { 423 => 0x38 },
	'afstatus_29_c7_vertical' => { 423 => 0x3a },
	'afstatus_30_c6_vertical' => { 423 => 0x3c },
	'afstatus_31_c5_vertical' => { 423 => 0x3e },
	'afstatus_32_e7_vertical' => { 423 => 0x40 },
	'afstatus_33_e6_center_vertical' => { 423 => 0x42 },
	'afstatus_34_e5_vertical' => { 423 => 0x44 },
	'afstatus_35_g7_vertical' => { 423 => 0x46 },
	'afstatus_36_g6_vertical' => { 423 => 0x48 },
	'afstatus_37_g5_vertical' => { 423 => 0x4a },
	'afstatus_38_i7_vertical' => { 423 => 0x4c },
	'afstatus_39_i6_vertical' => { 423 => 0x4e },
	'afstatus_40_i5_vertical' => { 423 => 0x50 },
	'afstatus_41_a7' => { 423 => 0x52 },
	'afstatus_42_b7' => { 423 => 0x54 },
	'afstatus_43_c7' => { 423 => 0x56 },
	'afstatus_44_d7' => { 423 => 0x58 },
	'afstatus_45_e7' => { 423 => 0x5a },
	'afstatus_46_f7' => { 423 => 0x5c },
	'afstatus_47_g7' => { 423 => 0x5e },
	'afstatus_48_h7' => { 423 => 0x60 },
	'afstatus_49_i7' => { 423 => 0x62 },
	'afstatus_50_a6' => { 423 => 0x64 },
	'afstatus_51_b6' => { 423 => 0x66 },
	'afstatus_52_c6' => { 423 => 0x68 },
	'afstatus_53_d6' => { 423 => 0x6a },
	'afstatus_54_e6_center' => { 423 => 0x6c },
	'afstatus_55_f6' => { 423 => 0x6e },
	'afstatus_56_g6' => { 423 => 0x70 },
	'afstatus_57_h6' => { 423 => 0x72 },
	'afstatus_58_i6' => { 423 => 0x74 },
	'afstatus_59_a5' => { 423 => 0x76 },
	'afstatus_60_b5' => { 423 => 0x78 },
	'afstatus_61_c5' => { 423 => 0x7a },
	'afstatus_62_d5' => { 423 => 0x7c },
	'afstatus_63_e5' => { 423 => 0x7e },
	'afstatus_64_f5' => { 423 => 0x80 },
	'afstatus_65_g5' => { 423 => 0x82 },
	'afstatus_66_h5' => { 423 => 0x84 },
	'afstatus_67_i5' => { 423 => 0x86 },
	'afstatus_68_c11' => { 423 => 0x88 },
	'afstatus_69_d11' => { 423 => 0x8a },
	'afstatus_70_e11' => { 423 => 0x8c },
	'afstatus_71_f11' => { 423 => 0x8e },
	'afstatus_72_g11' => { 423 => 0x90 },
	'afstatus_73_b10' => { 423 => 0x92 },
	'afstatus_74_c10' => { 423 => 0x94 },
	'afstatus_75_d10' => { 423 => 0x96 },
	'afstatus_76_e10' => { 423 => 0x98 },
	'afstatus_77_f10' => { 423 => 0x9a },
	'afstatus_78_g10' => { 423 => 0x9c },
	'afstatus_79_h10' => { 423 => 0x9e },
	'afstatus_80_b9' => { 423 => 0xa0 },
	'afstatus_81_c9' => { 423 => 0xa2 },
	'afstatus_82_d9' => { 423 => 0xa4 },
	'afstatus_83_e9' => { 423 => 0xa6 },
	'afstatus_84_f9' => { 423 => 0xa8 },
	'afstatus_85_g9' => { 423 => 0xaa },
	'afstatus_86_h9' => { 423 => 0xac },
	'afstatus_87_b8' => { 423 => 0xae },
	'afstatus_88_c8' => { 423 => 0xb0 },
	'afstatus_89_d8' => { 423 => 0xb2 },
	'afstatus_90_e8' => { 423 => 0xb4 },
	'afstatus_91_f8' => { 423 => 0xb6 },
	'afstatus_92_g8' => { 423 => 0xb8 },
	'afstatus_93_h8' => { 423 => 0xba },
	'afstatus_94_e6_center_f2-8' => { 423 => 0xbc },
	'afstatusactivesensor' => { 180 => 0x2, 420 => [0x4,0x3b], 424 => 0x1e, 425 => 0x1b, 426 => [0x1b,0x21] },
	'afstatusbottom' => { 180 => 0x8, 424 => 0x2a, 425 => 0x21, 426 => 0x21 },
	'afstatusbottom-left' => { 180 => 0x12, 425 => 0x2b, 426 => 0x2b },
	'afstatusbottom-right' => { 180 => 0x6, 425 => 0x1f, 426 => 0x1f },
	'afstatusbottomassist-left' => { 424 => 0x28 },
	'afstatusbottomassist-right' => { 424 => 0x2c },
	'afstatusbottomhorizontal' => { 421 => 0x10, 422 => 0x1c },
	'afstatusbottomvertical' => { 421 => 0x16, 422 => 0x26 },
	'afstatuscenter-10' => { 424 => 0x34 },
	'afstatuscenter-11' => { 424 => 0x36 },
	'afstatuscenter-12' => { 424 => 0x38 },
	'afstatuscenter-14' => { 424 => 0x3c },
	'afstatuscenter-7' => { 424 => 0x2e },
	'afstatuscenter-9' => { 424 => 0x32 },
	'afstatuscenter-horizontal' => { 424 => 0x30 },
	'afstatuscenter-vertical' => { 424 => 0x3a },
	'afstatuscenterf2-8' => { 424 => 0x4c },
	'afstatuscenterhorizontal' => { 180 => 0x2f, 421 => 0xc, 422 => 0x18, 425 => 0x2f, 426 => 0x2f },
	'afstatuscentervertical' => { 180 => 0xc, 421 => 0x14, 422 => 0x22, 425 => 0x25, 426 => 0x25 },
	'afstatusfarleft' => { 421 => 0x6, 424 => 0x26 },
	'afstatusfarlefthorizontal' => { 422 => 0x4 },
	'afstatusfarleftvertical' => { 422 => 0x12 },
	'afstatusfarright' => { 421 => 0x18, 424 => 0x44 },
	'afstatusfarrighthorizontal' => { 422 => 0x2c },
	'afstatusfarrightvertical' => { 422 => 0x34 },
	'afstatusleft' => { 180 => 0x2d, 421 => 0x2, 424 => 0x22, 425 => 0x2d, 426 => 0x2d },
	'afstatuslefthorizontal' => { 422 => 0x6 },
	'afstatusleftvertical' => { 422 => 0xe },
	'afstatuslower-left' => { 421 => 0x4, 424 => 0x24 },
	'afstatuslower-lefthorizontal' => { 422 => 0xa },
	'afstatuslower-leftvertical' => { 422 => 0x10 },
	'afstatuslower-middle' => { 421 => 0x22, 422 => 0x24 },
	'afstatuslower-right' => { 421 => 0x1e, 424 => 0x4a },
	'afstatuslower-righthorizontal' => { 422 => 0x32 },
	'afstatuslower-rightvertical' => { 422 => 0x3a },
	'afstatuslowerfarleft' => { 422 => 0x8 },
	'afstatuslowerfarright' => { 422 => 0x30 },
	'afstatusmiddlehorizontal' => { 180 => 0xa, 425 => 0x23, 426 => 0x23 },
	'afstatusnearleft' => { 421 => 0xe, 422 => 0x1a },
	'afstatusnearright' => { 421 => 0xa, 422 => 0x16 },
	'afstatusright' => { 180 => 0x31, 421 => 0x1c, 424 => 0x48, 425 => 0x31, 426 => 0x31 },
	'afstatusrighthorizontal' => { 422 => 0x2e },
	'afstatusrightvertical' => { 422 => 0x38 },
	'afstatustop' => { 180 => 0xe, 424 => 0x40, 425 => 0x27, 426 => 0x27 },
	'afstatustop-left' => { 180 => 0x10, 425 => 0x29, 426 => 0x29 },
	'afstatustop-right' => { 180 => 0x4, 425 => 0x1d, 426 => 0x1d },
	'afstatustopassist-left' => { 424 => 0x3e },
	'afstatustopassist-right' => { 424 => 0x42 },
	'afstatustophorizontal' => { 421 => 0x8, 422 => 0x14 },
	'afstatustopvertical' => { 421 => 0x12, 422 => 0x1e },
	'afstatusupper-left' => { 421 => 0x0, 424 => 0x20 },
	'afstatusupper-lefthorizontal' => { 422 => 0x2 },
	'afstatusupper-leftvertical' => { 422 => 0xc },
	'afstatusupper-middle' => { 421 => 0x20, 422 => 0x20 },
	'afstatusupper-right' => { 421 => 0x1a, 424 => 0x46 },
	'afstatusupper-righthorizontal' => { 422 => 0x2a },
	'afstatusupper-rightvertical' => { 422 => 0x36 },
	'afstatusupperfarleft' => { 422 => 0x0 },
	'afstatusupperfarright' => { 422 => 0x28 },
	'afstatusviewfinder' => { 2 => 0x12 },
	'aftracking' => { 440 => 0x2021 },
	'aftrackingsensitivity' => { 2 => 0x2 },
	'aftype' => { 420 => 0x2 },
	'afwithshutter' => { 427 => 0x2a },
	'aggregateissuenumber' => { 519 => 'aggregateIssueNumber' },
	'aggregationtype' => { 519 => 'aggregationType' },
	'agreement' => { 522 => 'agreement' },
	'ah2greeninterpolationthreshold' => { 138 => 0xe4e },
	'airplanemode' => { 239 => 0x722, 240 => 0x624, 241 => 0x654, 242 => 0x6bc },
	'aiservocontinuousshooting' => { 83 => 0x15 },
	'aiservofirstimage' => { 2 => 0x5 },
	'aiservofirstimagepriority' => { 84 => 0x519 },
	'aiservoimagepriority' => { 84 => 0x503 },
	'aiservosecondimage' => { 2 => 0x6 },
	'aiservosecondimagepriority' => { 84 => 0x51a },
	'aiservotrackingmethod' => { 84 => 0x504 },
	'aiservotrackingsensitivity' => { 83 => 0x14, 84 => 0x502 },
	'aisubjecttrackingmode' => { 317 => 0x309 },
	'album' => { 392 => ['albm',"\xa9alb"], 394 => 'album', 400 => ['albm',"\xa9alb"], 529 => 'album' },
	'albumartist' => { 179 => 'WM/AlbumArtist', 392 => 'aART', 400 => 'albr' },
	'albumcoverurl' => { 179 => 'WM/AlbumCoverURL' },
	'albumid' => { 392 => 'plID' },
	'albumtitle' => { 179 => 'WM/AlbumTitle' },
	'alreadyapplied' => { 500 => 'AlreadyApplied', 502 => 'AlreadyApplied' },
	'alternatetitle' => { 519 => 'alternateTitle' },
	'alternatetitlea-lang' => { 519 => [\'alternateTitle','alternateTitleA-lang'] },
	'alternatetitlea-platform' => { 519 => [\'alternateTitle','alternateTitleA-platform'] },
	'alternatetitletext' => { 519 => [\'alternateTitle','alternateTitleText'] },
	'altitude' => { 197 => 0x6 },
	'alttapename' => { 529 => 'altTapeName' },
	'alttextaccessibility' => { 513 => 'AltTextAccessibility' },
	'alttimecode' => { 529 => 'altTimecode' },
	'alttimecodetimeformat' => { 529 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 529 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 529 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 4 => 0x1 },
	'ambientinfrared' => { 403 => 0x5c },
	'ambientlight' => { 403 => 0x5e },
	'ambienttemperature' => { 119 => 0x9400, 401 => 0x14, 402 => 0x46, 403 => 0x50, 466 => 0x4, 507 => 'Temperature' },
	'ambienttemperaturefahrenheit' => { 401 => 0x13, 402 => 0x44, 403 => 0x4e },
	'analogbalance' => { 119 => 0xc627 },
	'analogcaptureiso' => { 138 => 0x89e },
	'analogisotable' => { 138 => 0x89d },
	'androidversion' => { 394 => 'com.android.version' },
	'angleadj' => { 103 => 0x10003, 109 => 0x8b },
	'angleinforoll' => { 496 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 496 => 'AngleInfoYaw' },
	'anti-blur' => { 440 => 0xb04b },
	'antialiasstrength' => { 119 => 0xc632 },
	'aperturelock' => { 298 => '38.2', 300 => '38.2', 301 => '38.2', 310 => '38.2', 311 => '38.2', 313 => 0xb8, 314 => 0xb8, 315 => 0xb8 },
	'aperturemode' => { 400 => 'apmd' },
	'aperturerange' => { 84 => 0x10d },
	'apertureringuse' => { 356 => '1.4' },
	'aperturesetting' => { 184 => 0x7, 427 => 0x30, 428 => 0x29, 429 => 0x1 },
	'aperturevalue' => { 93 => 0x2, 119 => 0x9202, 322 => 0x1002, 384 => 0x401, 506 => 'ApertureValue' },
	'appinfo' => { 479 => 'AppInfo' },
	'appinfoapplication' => { 479 => [\'AppInfo','AppInfoApplication'] },
	'appinfoitemuri' => { 479 => [\'AppInfo','AppInfoItemURI'] },
	'appinfoversion' => { 479 => [\'AppInfo','AppInfoVersion'] },
	'applekeywords' => { 326 => 'AAPL:Keywords' },
	'applephotosvariationidentifier' => { 394 => 'apple.photos.variation-identifier' },
	'applestoreaccount' => { 392 => 'apID' },
	'applestoreaccounttype' => { 392 => 'akID' },
	'applestorecatalogid' => { 392 => 'cnID' },
	'applestorecountry' => { 392 => 'sfID' },
	'applicationkeystring' => { 138 => 0x400 },
	'applicationnotes' => { 119 => 0x2bc, 345 => 0x2bc },
	'applicationrecordversion' => { 131 => 0x0 },
	'applyshootingmeteringmode' => { 84 => 0x10e },
	'approved' => { 508 => 'Approved' },
	'approvedby' => { 508 => 'ApprovedBy' },
	'approximatefnumber' => { 335 => 0x313, 342 => 0x3406 },
	'approximatefocusdistance' => { 497 => 'ApproximateFocusDistance' },
	'appversion' => { 512 => 'AppVersion' },
	'aps-csizecapture' => { 459 => 0x114, 460 => [0x114,0x1eb,0x1ee,0x21a,0x21c] },
	'aquahsl' => { 103 => 0x20914 },
	'armidentifier' => { 132 => 0x78 },
	'armversion' => { 132 => 0x7a },
	'arranger' => { 392 => "\xa9arg", 400 => "\xa9arg" },
	'arrangerkeywords' => { 400 => "\xa9ark" },
	'artdirector' => { 392 => "\xa9ard" },
	'artfilter' => { 317 => 0x529 },
	'artfiltereffect' => { 317 => 0x52f },
	'artist' => { 119 => 0x13b, 330 => 'Artist', 345 => 0x13b, 375 => 0x22e, 392 => "\xa9ART", 394 => 'artist', 400 => "\xa9ART", 525 => 'Artist', 529 => 'artist' },
	'artistid' => { 392 => 'atID' },
	'artmode' => { 113 => 0x301b },
	'artmodeparameters' => { 113 => 0x310b },
	'artwork' => { 394 => 'artwork' },
	'artworkcircadatecreated' => { 514 => [\'ArtworkOrObject','ArtworkOrObjectAOCircaDateCreated'] },
	'artworkcontentdescription' => { 514 => [\'ArtworkOrObject','ArtworkOrObjectAOContentDescription'] },
	'artworkcontributiondescription' => { 514 => [\'ArtworkOrObject','ArtworkOrObjectAOContributionDescription'] },
	'artworkcopyrightnotice' => { 514 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcopyrightownerid' => { 514 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerId'] },
	'artworkcopyrightownername' => { 514 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerName'] },
	'artworkcreator' => { 514 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkcreatorid' => { 514 => [\'ArtworkOrObject','ArtworkOrObjectAOCreatorId'] },
	'artworkdatecreated' => { 514 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworklicensorid' => { 514 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorId'] },
	'artworklicensorname' => { 514 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorName'] },
	'artworkorobject' => { 514 => 'ArtworkOrObject' },
	'artworkphysicaldescription' => { 514 => [\'ArtworkOrObject','ArtworkOrObjectAOPhysicalDescription'] },
	'artworksource' => { 514 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 514 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworksourceinvurl' => { 514 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvURL'] },
	'artworkstyleperiod' => { 514 => [\'ArtworkOrObject','ArtworkOrObjectAOStylePeriod'] },
	'artworktitle' => { 514 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 321 => 0x1113 },
	'aspectratio' => { 5 => 0x0, 321 => 0x1112, 375 => 0x80, 427 => 0x55, 428 => 0x55, 429 => 0xa, 453 => [0x192c,0x1a88], 454 => 0x192c, 455 => 0x1958, 456 => 0x192c, 457 => 0x188c },
	'assetid' => { 490 => 'AssetID' },
	'asshoticcprofile' => { 119 => 0xc68f },
	'asshotneutral' => { 119 => 0xc628 },
	'asshotpreprofilematrix' => { 119 => 0xc690 },
	'asshotprofilename' => { 119 => 0xc6f6 },
	'asshotwhitexy' => { 119 => 0xc629 },
	'assignbktbutton' => { 297 => '4.2', 298 => '16.1', 300 => '16.1', 301 => '16.1', 310 => '16.1', 311 => '16.1' },
	'assignfuncbutton' => { 84 => 0x70b },
	'assignmb-d17af-onbutton' => { 301 => '79.1' },
	'assignmb-d17funcbutton' => { 301 => '67.1' },
	'assignmb-d17funcbuttonplusdials' => { 301 => '68.1' },
	'assignmb-d18af-onbutton' => { 311 => '79.1' },
	'assignmb-d18funcbutton' => { 311 => '67.1' },
	'assignmb-d18funcbuttonplusdials' => { 311 => '68.1' },
	'assignmoviefunc1buttonplusdials' => { 300 => '75.1', 301 => '75.1', 311 => '75.1' },
	'assignmoviefunc2button' => { 300 => '82.1', 301 => '82.1', 311 => '82.1' },
	'assignmoviepreviewbuttonplusdials' => { 300 => '75.2', 301 => '75.2', 311 => '75.2' },
	'assignmovierecordbutton' => { 298 => '43.2', 310 => '45.1', 313 => 0x9b, 314 => 0x9b, 315 => 0x9b },
	'assignmovierecordbuttonplusdials' => { 300 => '45.1', 301 => '45.1', 311 => '45.1' },
	'assignmoviesubselector' => { 300 => '74.1', 301 => '74.1', 311 => '74.1' },
	'assignmoviesubselectorplusdials' => { 300 => '76.1', 301 => '76.1', 311 => '76.1' },
	'assignremotefnbutton' => { 298 => '54.1', 310 => '51.1' },
	'assistbuttonfunction' => { 82 => 0xd },
	'atcaptureusercrop' => { 138 => 0x943 },
	'attributionname' => { 498 => 'attributionName' },
	'attributionurl' => { 498 => 'attributionURL' },
	'audio' => { 340 => 0x20 },
	'audiobitrate' => { 67 => 0x6c, 514 => 'audioBitRate' },
	'audiobitratemode' => { 514 => 'audioBitRateMode' },
	'audiobitspersample' => { 514 => 'audioBitsPerSample' },
	'audiobutton' => { 314 => 0x17b, 315 => 0x193 },
	'audiobuttonplaybackmode' => { 314 => 0x1b9, 315 => 0x1d1 },
	'audiochannelcount' => { 514 => 'audioChannelCount' },
	'audiochannels' => { 67 => 0x70 },
	'audiochanneltype' => { 529 => 'audioChannelType' },
	'audiocompression' => { 84 => 0x816, 155 => 'Compression' },
	'audiocompressor' => { 529 => 'audioCompressor' },
	'audiodata' => { 482 => 'Data' },
	'audioduration' => { 131 => 0x99 },
	'audiogain' => { 394 => 'player.movie.audio.gain' },
	'audiomimetype' => { 482 => 'Mime' },
	'audiomoddate' => { 529 => 'audioModDate' },
	'audiooutcue' => { 131 => 0x9a },
	'audiosamplerate' => { 67 => 0x6e, 529 => 'audioSampleRate' },
	'audiosampletype' => { 529 => 'audioSampleType' },
	'audiosamplingrate' => { 131 => 0x97 },
	'audiosamplingresolution' => { 131 => 0x98 },
	'audiotype' => { 131 => 0x96 },
	'author' => { 157 => 'Author', 326 => 'Author', 330 => 'Author', 391 => 'Author', 392 => ['auth',"\xa9aut"], 394 => 'author', 400 => 'auth', 495 => 'author', 516 => 'Author', 527 => 'Author' },
	'authorsposition' => { 517 => 'AuthorsPosition' },
	'authorurl' => { 179 => 'WM/AuthorURL' },
	'autoafpointcolortracking' => { 84 => 0x51c },
	'autoafpointseleositraf' => { 2 => 0xa },
	'autoaperture' => { 366 => '0.1' },
	'autobracket' => { 417 => 0x19 },
	'autobracketing' => { 127 => 0x1100, 375 => 0x18, 407 => 0x1007 },
	'autobracketingmode' => { 309 => '12.3' },
	'autobracketingset' => { 309 => '12.1' },
	'autobracketmodem' => { 297 => '21.2', 298 => '13.3', 300 => '13.2', 301 => '13.2', 306 => '26.2', 310 => '13.3', 311 => '13.2', 313 => 0x5f, 314 => 0x5f, 315 => 0x5f },
	'autobracketorder' => { 184 => 0x43, 297 => '21.3', 298 => '13.2', 300 => '13.1', 301 => '13.1', 306 => '26.3', 307 => '12.2', 308 => '2.2', 309 => '12.2', 310 => '13.2', 311 => '13.1', 312 => '13.2', 313 => 0x61, 314 => 0x61, 315 => 0x61 },
	'autobracketset' => { 297 => '21.1', 298 => '13.1', 302 => '11.1', 303 => '12.1', 304 => '12.1', 306 => '26.1', 307 => '12.1', 308 => '2.1', 310 => '13.1', 312 => '13.1' },
	'autobrightness' => { 500 => 'AutoBrightness', 502 => 'AutoBrightness' },
	'autocapturecriteria' => { 196 => 0x1 },
	'autocapturecriteriamotiondirection' => { 196 => 0x5f },
	'autocapturecriteriamotionsize' => { 196 => 0x64 },
	'autocapturecriteriamotionspeed' => { 196 => 0x63 },
	'autocapturecriteriasubjectsize' => { 196 => 0x69 },
	'autocapturecriteriasubjecttype' => { 196 => 0x6a },
	'autocapturedframe' => { 196 => 0x0 },
	'autocapturedistancefar' => { 196 => 0x4a },
	'autocapturedistancenear' => { 196 => 0x4e },
	'autocapturepreset' => { 242 => 0x746 },
	'autocapturerecordingtime' => { 196 => 0x37 },
	'autocapturewaittime' => { 196 => 0x38 },
	'autocontrast' => { 500 => 'AutoContrast', 502 => 'AutoContrast' },
	'autodistortioncontrol' => { 209 => 0x4, 238 => 0x143 },
	'autodynamicrange' => { 127 => 0x140b },
	'autoexposure' => { 500 => 'AutoExposure', 502 => 'AutoExposure' },
	'autoexposurebracketing' => { 77 => 0x10 },
	'autoflashisosensitivity' => { 300 => '38.5', 301 => '38.5', 311 => '38.5', 313 => 0x5b, 314 => 0x5b, 315 => 0x5b },
	'autofocus' => { 320 => 0x209 },
	'autofocusmoderestrictions' => { 313 => 0x107, 314 => 0x107, 315 => 0x11d },
	'autofp' => { 308 => '7.3', 312 => '31.4' },
	'autoiso' => { 77 => 0x1, 113 => 0x3008, 239 => 0x152, 240 => 0x142, 241 => 0x156, 242 => 0x156, 299 => '1.1', 308 => '1.1' },
	'autoisomax' => { 299 => '1.2', 308 => '1.2' },
	'autoisominshutterspeed' => { 299 => '1.3', 308 => '1.3' },
	'autolateralca' => { 500 => 'AutoLateralCA', 502 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 16 => 0xbe, 17 => 0xbf, 20 => 0xbf, 62 => 0x2, 84 => 0x204, 103 => 0x20500, 109 => 0x6f },
	'autolightingoptimizeron' => { 103 => '0x20500.0', 109 => 0x6e },
	'autoportraitframed' => { 440 => 0x2016 },
	'autoredeye' => { 290 => 0xfe28a44f },
	'autorotate' => { 77 => 0x1b },
	'autoshadows' => { 500 => 'AutoShadows', 502 => 'AutoShadows' },
	'autotone' => { 500 => 'AutoTone', 502 => 'AutoTone' },
	'autotonedigest' => { 500 => 'AutoToneDigest', 502 => 'AutoToneDigest' },
	'autotonedigestnosat' => { 500 => 'AutoToneDigestNoSat', 502 => 'AutoToneDigestNoSat' },
	'autowhiteversion' => { 500 => 'AutoWhiteVersion', 502 => 'AutoWhiteVersion' },
	'auxiliarylens' => { 234 => 0x82 },
	'avaperturesetting' => { 356 => 0x13 },
	'averageblacklevel' => { 45 => 0xe7, 47 => 0xfb, 48 => 0x114, 49 => 0x146 },
	'averagelv' => { 187 => 0x38 },
	'avsettingwithoutlens' => { 84 => 0x707 },
	'azimuth' => { 165 => 'Azimuth' },
	'babyage' => { 340 => [0x8010,0x33] },
	'babyname' => { 340 => 0x66 },
	'backgroundalpha' => { 524 => 'bgalpha' },
	'balance' => { 394 => 'player.movie.audio.balance' },
	'baseexposurecompensation' => { 356 => 0x15 },
	'baseiso' => { 77 => 0x2, 97 => 0x101c, 138 => 0x903, 342 => 0x312a, 472 => 0x6 },
	'baseisodaylight' => { 138 => 0x910 },
	'baseisoflash' => { 138 => 0x913 },
	'baseisofluorescent' => { 138 => 0x912 },
	'baseisotungsten' => { 138 => 0x911 },
	'baselineexposure' => { 119 => 0xc62a },
	'baselineexposureoffset' => { 119 => 0xc7a5 },
	'baselinenoise' => { 119 => 0xc62b },
	'baselinesharpness' => { 119 => 0xc62c },
	'baserenditionishdr' => { 511 => 'BaseRenditionIsHDR' },
	'baseurl' => { 527 => 'BaseURL' },
	'bass' => { 394 => 'player.movie.audio.bass' },
	'batterylevel' => { 340 => 0x38, 427 => 0x51, 431 => 0xc, 432 => 0x4, 433 => 0x4, 473 => [0x5,0x7] },
	'batterylevelgrip1' => { 473 => 0x6 },
	'batterylevelgrip2' => { 473 => 0x8 },
	'batteryorder' => { 297 => '12.5', 306 => '13.2', 307 => '2.1', 310 => '3.1' },
	'batterystate' => { 184 => 0x60, 427 => 0x50, 433 => 0x14 },
	'batterytemperature' => { 431 => 0x1, 433 => 0x2, 473 => 0x5 },
	'batterytype' => { 64 => 0x38, 403 => 0x66 },
	'batteryunknown' => { 431 => 0x2, 433 => 0x0 },
	'batteryvoltage' => { 138 => 0x408, 401 => 0x2a, 402 => 0x49, 403 => 0x62, 431 => 0x8 },
	'batteryvoltage1' => { 433 => 0x6 },
	'batteryvoltage2' => { 433 => 0x8 },
	'batteryvoltageavg' => { 403 => 0x64 },
	'bayergreensplit' => { 119 => 0xc62d },
	'bayerpattern' => { 137 => 0xf902, 188 => 0x17 },
	'beatsperminute' => { 392 => 'tmpo' },
	'beatspliceparams' => { 529 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 529 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 529 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 529 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 529 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 529 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 297 => '13.1', 298 => '5.4', 299 => '0.1', 302 => '2.1', 303 => '3.1', 304 => '3.1', 306 => '10.1', 308 => '0.1', 310 => '5.5', 312 => '4.1' },
	'beeppitch' => { 307 => '3.1' },
	'beepvolume' => { 307 => '4.5' },
	'bestqualityscale' => { 119 => 0xc65c },
	'bestshotmode' => { 113 => 0x3007 },
	'bitdepth' => { 162 => 'BitDepth', 188 => 0x11, 257 => 0x41 },
	'bitspercomponent' => { 133 => 0x87 },
	'bitspersample' => { 119 => 0x102, 345 => 0xa, 525 => 'BitsPerSample' },
	'blackacquirerows' => { 138 => 0x18ba },
	'blacklevel' => { 119 => [0x7310,0xc61a], 207 => 0x20, 234 => 0x3d, 322 => [0x401,0x1012], 384 => 0x21d, 447 => [0x7300,0x7310] },
	'blacklevel2' => { 321 => 0x600, 325 => 0x600 },
	'blacklevelblue' => { 345 => 0x1e },
	'blacklevelbottom' => { 138 => 0x3f0 },
	'blackleveldata' => { 384 => 0x223 },
	'blackleveldeltah' => { 119 => 0xc61b },
	'blackleveldeltav' => { 119 => 0xc61c },
	'blacklevelgreen' => { 345 => 0x1d },
	'blacklevelred' => { 345 => 0x1c },
	'blacklevelrepeatdim' => { 119 => 0xc619 },
	'blacklevelrough' => { 138 => 0x40e },
	'blacklevelroughafter' => { 138 => 0x416 },
	'blacklevels' => { 35 => 0x1d },
	'blackleveltop' => { 138 => 0x3ef },
	'blackpoint' => { 375 => 0x200 },
	'blacks2012' => { 500 => 'Blacks2012', 502 => 'Blacks2012' },
	'blacksadj' => { 476 => 0x9018 },
	'bleachbypasstoning' => { 375 => 0x7f },
	'blockshotafresponse' => { 300 => '1.5', 301 => '1.5', 311 => '1.5', 313 => 0x7, 314 => 0x7, 315 => 0x7 },
	'blogtitle' => { 519 => 'blogTitle' },
	'blogurl' => { 519 => 'blogURL' },
	'bluebalance' => { 322 => 0x1018, 345 => 0x12, 375 => 0x1b },
	'bluecurvelimits' => { 108 => 0x1fe },
	'bluecurvepoints' => { 107 => 0x79, 108 => 0x1d4 },
	'bluehsl' => { 103 => 0x20915 },
	'bluehue' => { 500 => 'BlueHue', 502 => 'BlueHue' },
	'bluesaturation' => { 500 => 'BlueSaturation', 502 => 'BlueSaturation' },
	'bluratinfinity' => { 486 => 'BlurAtInfinity' },
	'blurcontrol' => { 375 => 0x82 },
	'blurwarning' => { 127 => 0x1300 },
	'bodybatteryadload' => { 354 => 0x3 },
	'bodybatteryadnoload' => { 354 => 0x2 },
	'bodybatterystate' => { 354 => '1.1' },
	'bodybatteryvoltage1' => { 354 => 0x2 },
	'bodybatteryvoltage2' => { 354 => 0x4 },
	'bodybatteryvoltage3' => { 354 => 0x6 },
	'bodybatteryvoltage4' => { 354 => 0x8 },
	'bodyfirmware' => { 408 => 0x0 },
	'bodyfirmwareversion' => { 318 => 0x104, 319 => 0x100, 322 => 0x104 },
	'bodyserialnumber' => { 408 => 0x10 },
	'bookedition' => { 519 => 'bookEdition' },
	'bootloaderversion' => { 402 => 0x26 },
	'bracketbutton' => { 242 => 0x80c },
	'bracketbuttonplaybackmode' => { 242 => 0x816 },
	'bracketincrement' => { 239 => 0x22e, 240 => 0x21a, 241 => 0x22e, 242 => 0x22e },
	'bracketmode' => { 57 => 0x3 },
	'bracketprogram' => { 239 => 0x22c, 240 => 0x218, 241 => 0x22c, 242 => 0x22c },
	'bracketsequence' => { 113 => 0x301d },
	'bracketset' => { 239 => 0x22a, 240 => 0x216, 241 => 0x22a, 242 => 0x22a },
	'bracketsettings' => { 340 => 0x45 },
	'bracketshotnumber' => { 57 => 0x5, 356 => 0x9, 438 => 0x2b },
	'bracketshotnumber2' => { 438 => 0x2d },
	'bracketstep' => { 181 => 0xe },
	'bracketvalue' => { 57 => 0x4 },
	'brightness' => { 119 => 0xfe53, 156 => 'Brightness', 176 => 'Brightness', 181 => 0x2c, 249 => 0x34, 250 => 0x39, 251 => 0x41, 394 => 'player.movie.visual.brightness', 401 => 0x25, 403 => 0x54, 427 => 0x22, 440 => 0x2007, 500 => 'Brightness', 502 => 'Brightness' },
	'brightnessadj' => { 108 => 0x114, 283 => 0x0, 293 => 0x2d, 476 => 0x8018 },
	'brightnessvalue' => { 119 => 0x9203, 187 => [0x691,0x49c3], 322 => 0x1003, 445 => 0x1e, 449 => 0x1140, 450 => 0x1140, 451 => 0x111c, 452 => 0x1198, 453 => 0x1174, 454 => 0x102c, 455 => 0x224, 456 => 0x224, 457 => 0x219, 506 => 'BrightnessValue' },
	'buildnumber' => { 191 => 0x5500 },
	'bulbduration' => { 77 => 0x18 },
	'burstcount' => { 138 => 0x40d },
	'burstgroupid' => { 236 => 0x4 },
	'burstid' => { 483 => 'BurstID' },
	'burstmode' => { 140 => 0xa, 340 => 0x2a },
	'burstmode2' => { 140 => 0x18 },
	'burstprimary' => { 483 => 'BurstPrimary' },
	'burstshot' => { 417 => 0x34 },
	'burstspeed' => { 340 => 0x77 },
	'burstuuid' => { 1 => 0xb },
	'buttonfunctioncontroloff' => { 84 => 0x70a },
	'bwadjustment' => { 127 => 0x1049 },
	'bwfilter' => { 181 => 0x2a, 189 => 0x39 },
	'bwmagentagreen' => { 127 => 0x104b },
	'bwmode' => { 322 => 0x203 },
	'by-line' => { 131 => 0x50 },
	'by-linetitle' => { 131 => 0x55 },
	'bytecount' => { 519 => 'byteCount' },
	'c14configuration' => { 138 => 0x1964 },
	'cacheversion' => { 119 => 0xc7aa },
	'calibratedfocallength' => { 116 => 'CalibratedFocalLength' },
	'calibratedopticalcenterx' => { 116 => 'CalibratedOpticalCenterX' },
	'calibratedopticalcentery' => { 116 => 'CalibratedOpticalCenterY' },
	'calibration' => { 417 => [0x24,0x30] },
	'calibrationhistory' => { 138 => 0x9c9 },
	'calibrationilluminant1' => { 119 => 0xc65a },
	'calibrationilluminant2' => { 119 => 0xc65b },
	'calibrationilluminant3' => { 119 => 0xcd31 },
	'calibrationversion' => { 138 => 0x9c6 },
	'callforimage' => { 490 => 'CallForImage' },
	'camera' => { 479 => [\'Cameras','CamerasCamera'] },
	'cameraangle' => { 400 => 'angl', 529 => 'cameraAngle' },
	'cameraappinfo' => { 479 => [\'Cameras','CamerasCameraAppInfo'] },
	'cameraappinfoapplication' => { 479 => [\'Cameras','CamerasCameraAppInfoApplication'] },
	'cameraappinfoitemuri' => { 479 => [\'Cameras','CamerasCameraAppInfoItemURI'] },
	'cameraappinfoversion' => { 479 => [\'Cameras','CamerasCameraAppInfoVersion'] },
	'cameraburstid' => { 484 => 'CameraBurstID' },
	'cameracalibration' => { 417 => 0x11f },
	'cameracalibration1' => { 119 => 0xc623 },
	'cameracalibration2' => { 119 => 0xc624 },
	'cameracalibration3' => { 119 => 0xcd32 },
	'cameracalibrationsig' => { 119 => 0xc6f3 },
	'cameracolorcalibration01' => { 36 => 0x0, 37 => 0x0 },
	'cameracolorcalibration02' => { 36 => 0x4, 37 => 0x5 },
	'cameracolorcalibration03' => { 36 => 0x8, 37 => 0xa },
	'cameracolorcalibration04' => { 36 => 0xc, 37 => 0xf },
	'cameracolorcalibration05' => { 36 => 0x10, 37 => 0x14 },
	'cameracolorcalibration06' => { 36 => 0x14, 37 => 0x19 },
	'cameracolorcalibration07' => { 36 => 0x18, 37 => 0x1e },
	'cameracolorcalibration08' => { 36 => 0x1c, 37 => 0x23 },
	'cameracolorcalibration09' => { 36 => 0x20, 37 => 0x28 },
	'cameracolorcalibration10' => { 36 => 0x24, 37 => 0x2d },
	'cameracolorcalibration11' => { 36 => 0x28, 37 => 0x32 },
	'cameracolorcalibration12' => { 36 => 0x2c, 37 => 0x37 },
	'cameracolorcalibration13' => { 36 => 0x30, 37 => 0x3c },
	'cameracolorcalibration14' => { 36 => 0x34, 37 => 0x41 },
	'cameracolorcalibration15' => { 36 => 0x38, 37 => 0x46 },
	'cameradepthmap' => { 479 => [\'Cameras','CamerasCameraDepthMap'] },
	'cameradepthmapconfidenceuri' => { 479 => [\'Cameras','CamerasCameraDepthMapConfidenceURI'] },
	'cameradepthmapdepthuri' => { 479 => [\'Cameras','CamerasCameraDepthMapDepthURI'] },
	'cameradepthmapfar' => { 479 => [\'Cameras','CamerasCameraDepthMapFar'] },
	'cameradepthmapfocaltable' => { 479 => [\'Cameras','CamerasCameraDepthMapFocalTable'] },
	'cameradepthmapfocaltableentrycount' => { 479 => [\'Cameras','CamerasCameraDepthMapFocalTableEntryCount'] },
	'cameradepthmapformat' => { 479 => [\'Cameras','CamerasCameraDepthMapFormat'] },
	'cameradepthmapitemsemantic' => { 479 => [\'Cameras','CamerasCameraDepthMapItemSemantic'] },
	'cameradepthmapmeasuretype' => { 479 => [\'Cameras','CamerasCameraDepthMapMeasureType'] },
	'cameradepthmapnear' => { 479 => [\'Cameras','CamerasCameraDepthMapNear'] },
	'cameradepthmapsoftware' => { 479 => [\'Cameras','CamerasCameraDepthMapSoftware'] },
	'cameradepthmapunits' => { 479 => [\'Cameras','CamerasCameraDepthMapUnits'] },
	'cameradirection' => { 394 => 'direction.facing' },
	'camerae-mountversion' => { 475 => 0xb },
	'cameraelevationangle' => { 119 => 0x9405, 507 => 'CameraElevationAngle' },
	'camerafilename' => { 490 => 'CameraFilename' },
	'camerafirmware' => { 119 => 0xa439 },
	'cameraid' => { 322 => 0x209, 400 => 'cmid', 416 => 0x209 },
	'cameraidentifier' => { 394 => 'camera.identifier' },
	'cameraimage' => { 479 => [\'Cameras','CamerasCameraImage'] },
	'cameraimageitemsemantic' => { 479 => [\'Cameras','CamerasCameraImageItemSemantic'] },
	'cameraimageitemuri' => { 479 => [\'Cameras','CamerasCameraImageItemURI'] },
	'cameraimagingmodel' => { 479 => [\'Cameras','CamerasCameraImagingModel'] },
	'cameraimagingmodeldistortion' => { 479 => [\'Cameras','CamerasCameraImagingModelDistortion'] },
	'cameraimagingmodeldistortioncount' => { 479 => [\'Cameras','CamerasCameraImagingModelDistortionCount'] },
	'cameraimagingmodelfocallengthx' => { 479 => [\'Cameras','CamerasCameraImagingModelFocalLengthX'] },
	'cameraimagingmodelfocallengthy' => { 479 => [\'Cameras','CamerasCameraImagingModelFocalLengthY'] },
	'cameraimagingmodelimageheight' => { 479 => [\'Cameras','CamerasCameraImagingModelImageHeight'] },
	'cameraimagingmodelimagewidth' => { 479 => [\'Cameras','CamerasCameraImagingModelImageWidth'] },
	'cameraimagingmodelpixelaspectratio' => { 479 => [\'Cameras','CamerasCameraImagingModelPixelAspectRatio'] },
	'cameraimagingmodelprincipalpointx' => { 479 => [\'Cameras','CamerasCameraImagingModelPrincipalPointX'] },
	'cameraimagingmodelprincipalpointy' => { 479 => [\'Cameras','CamerasCameraImagingModelPrincipalPointY'] },
	'cameraimagingmodelskew' => { 479 => [\'Cameras','CamerasCameraImagingModelSkew'] },
	'cameraiso' => { 34 => 0x10 },
	'cameralabel' => { 119 => 0xc7a1, 529 => 'cameraLabel' },
	'cameralightestimate' => { 479 => [\'Cameras','CamerasCameraLightEstimate'] },
	'cameralightestimatecolorcorrectionb' => { 479 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionB'] },
	'cameralightestimatecolorcorrectiong' => { 479 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionG'] },
	'cameralightestimatecolorcorrectionr' => { 479 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionR'] },
	'cameralightestimatepixelintensity' => { 479 => [\'Cameras','CamerasCameraLightEstimatePixelIntensity'] },
	'cameramakemodel' => { 490 => 'CameraMakeModel' },
	'cameramodel' => { 384 => 0x410, 529 => 'cameraModel' },
	'cameramodelid' => { 176 => 'CameraModelID' },
	'cameramodelrestriction' => { 500 => 'CameraModelRestriction', 502 => 'CameraModelRestriction' },
	'cameramotion' => { 394 => 'direction.motion' },
	'cameramove' => { 529 => 'cameraMove' },
	'cameraorientation' => { 7 => 0x30, 9 => 0x7d, 11 => 0x30, 13 => 0x35, 14 => 0x30, 15 => 0x30, 16 => 0x31, 17 => 0x31, 18 => 0x35, 19 => 0x27, 20 => 0x31, 21 => 0x7d, 22 => 0x38, 23 => [0x36,0x3a], 24 => 0x7d, 25 => 0x83, 26 => 0x84, 27 => 0x96, 28 => 0x35, 29 => 0x96, 340 => 0x8f, 379 => 0x1, 384 => 0x100, 433 => [0x16,0x18], 463 => 0x28, 464 => 0x24, 465 => 0x29 },
	'cameraowner' => { 141 => 0xc353 },
	'cameraparameters' => { 322 => 0x2050 },
	'camerapicturestyle' => { 28 => 0xaf },
	'camerapitch' => { 115 => 0x9, 400 => "\xa9gpt" },
	'camerapointcloud' => { 479 => [\'Cameras','CamerasCameraPointCloud'] },
	'camerapointcloudmetric' => { 479 => [\'Cameras','CamerasCameraPointCloudMetric'] },
	'camerapointcloudpointcloud' => { 479 => [\'Cameras','CamerasCameraPointCloudPointCloud'] },
	'camerapointcloudpoints' => { 479 => [\'Cameras','CamerasCameraPointCloudPoints'] },
	'camerapose' => { 479 => [\'Cameras','CamerasCameraPose'] },
	'cameraposepositionx' => { 479 => [\'Cameras','CamerasCameraPosePositionX'] },
	'cameraposepositiony' => { 479 => [\'Cameras','CamerasCameraPosePositionY'] },
	'cameraposepositionz' => { 479 => [\'Cameras','CamerasCameraPosePositionZ'] },
	'cameraposerotationw' => { 479 => [\'Cameras','CamerasCameraPoseRotationW'] },
	'cameraposerotationx' => { 479 => [\'Cameras','CamerasCameraPoseRotationX'] },
	'cameraposerotationy' => { 479 => [\'Cameras','CamerasCameraPoseRotationY'] },
	'cameraposerotationz' => { 479 => [\'Cameras','CamerasCameraPoseRotationZ'] },
	'cameraposetimestamp' => { 479 => [\'Cameras','CamerasCameraPoseTimestamp'] },
	'cameraprofile' => { 500 => 'CameraProfile', 502 => 'CameraProfile' },
	'cameraprofiledigest' => { 500 => 'CameraProfileDigest', 502 => 'CameraProfileDigest' },
	'cameraprofiles' => { 517 => 'CameraProfiles' },
	'cameraprofilesaperturevalue' => { 517 => [\'CameraProfiles','CameraProfilesApertureValue'] },
	'cameraprofilesauthor' => { 517 => [\'CameraProfiles','CameraProfilesAuthor'] },
	'cameraprofilesautoscale' => { 517 => [\'CameraProfiles','CameraProfilesAutoScale'] },
	'cameraprofilescameraprettyname' => { 517 => [\'CameraProfiles','CameraProfilesCameraPrettyName'] },
	'cameraprofilescamerarawprofile' => { 517 => [\'CameraProfiles','CameraProfilesCameraRawProfile'] },
	'cameraprofilesfocallength' => { 517 => [\'CameraProfiles','CameraProfilesFocalLength'] },
	'cameraprofilesfocusdistance' => { 517 => [\'CameraProfiles','CameraProfilesFocusDistance'] },
	'cameraprofileslens' => { 517 => [\'CameraProfiles','CameraProfilesLens'] },
	'cameraprofileslensprettyname' => { 517 => [\'CameraProfiles','CameraProfilesLensPrettyName'] },
	'cameraprofilesmake' => { 517 => [\'CameraProfiles','CameraProfilesMake'] },
	'cameraprofilesmodel' => { 517 => [\'CameraProfiles','CameraProfilesModel'] },
	'cameraprofilesperspectivemodel' => { 517 => [\'CameraProfiles','CameraProfilesPerspectiveModel'] },
	'cameraprofilesperspectivemodelimagexcenter' => { 517 => [\'CameraProfiles','CameraProfilesPerspectiveModelImageXCenter'] },
	'cameraprofilesperspectivemodelimageycenter' => { 517 => [\'CameraProfiles','CameraProfilesPerspectiveModelImageYCenter'] },
	'cameraprofilesperspectivemodelradialdistortparam1' => { 517 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam1'] },
	'cameraprofilesperspectivemodelradialdistortparam2' => { 517 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam2'] },
	'cameraprofilesperspectivemodelradialdistortparam3' => { 517 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam3'] },
	'cameraprofilesperspectivemodelscalefactor' => { 517 => [\'CameraProfiles','CameraProfilesPerspectiveModelScaleFactor'] },
	'cameraprofilesperspectivemodelversion' => { 517 => [\'CameraProfiles','CameraProfilesPerspectiveModelVersion'] },
	'cameraprofilesprofilename' => { 517 => [\'CameraProfiles','CameraProfilesProfileName'] },
	'cameraprofilessensorformatfactor' => { 517 => [\'CameraProfiles','CameraProfilesSensorFormatFactor'] },
	'cameraprofilesuniquecameramodel' => { 517 => [\'CameraProfiles','CameraProfilesUniqueCameraModel'] },
	'camerarawcolortone' => { 109 => 0xe1 },
	'camerarawcontrast' => { 109 => 0xe3 },
	'camerarawhighlightpoint' => { 109 => 0xe6 },
	'camerarawlinear' => { 109 => 0xe4 },
	'camerarawoutputhighlightpoint' => { 109 => 0xe8 },
	'camerarawoutputshadowpoint' => { 109 => 0xe9 },
	'camerarawsaturation' => { 109 => 0xe2 },
	'camerarawshadowpoint' => { 109 => 0xe7 },
	'camerarawsharpness' => { 109 => 0xe5 },
	'cameraroll' => { 115 => 0xb, 400 => "\xa9grl" },
	'cameras' => { 479 => 'Cameras' },
	'cameraserialnumber' => { 119 => 0xc62f, 178 => 'CameraSerialNumber', 490 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 317 => 0x0 },
	'cameratemperature' => { 7 => 0x18, 9 => 0x1b, 11 => 0x18, 13 => 0x19, 14 => 0x18, 15 => 0x18, 16 => 0x19, 17 => 0x19, 18 => 0x19, 19 => 0x17, 20 => 0x19, 21 => 0x1b, 22 => 0x19, 23 => 0x19, 24 => 0x1b, 25 => 0x1b, 26 => 0x1b, 27 => 0x1b, 28 => 0x19, 29 => 0x1b, 30 => [0x87,0x91], 31 => [0x99,0x9f,0xa4,0xa8,0x105], 33 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 77 => 0xc, 138 => 0x406, 321 => 0x1306, 335 => 0x320, 342 => 0x3402, 375 => 0x47, 414 => 0x43, 467 => 0x5 },
	'cameratemperature4' => { 380 => 0x14 },
	'cameratemperature5' => { 380 => 0x16 },
	'cameratemperaturerangemax' => { 121 => 0x5 },
	'cameratemperaturerangemin' => { 121 => 0x6 },
	'cameratrait' => { 479 => [\'Cameras','CamerasCameraTrait'] },
	'cameratype' => { 77 => 0x1a, 322 => 0x207 },
	'cameratype2' => { 318 => 0x100 },
	'cameravendorinfo' => { 479 => [\'Cameras','CamerasCameraVendorInfo'] },
	'cameravendorinfomanufacturer' => { 479 => [\'Cameras','CamerasCameraVendorInfoManufacturer'] },
	'cameravendorinfomodel' => { 479 => [\'Cameras','CamerasCameraVendorInfoModel'] },
	'cameravendorinfonotes' => { 479 => [\'Cameras','CamerasCameraVendorInfoNotes'] },
	'camerayaw' => { 115 => 0xa, 400 => "\xa9gyw" },
	'camreverse' => { 116 => 'CamReverse' },
	'canondr4' => { 120 => 'CanonDR4' },
	'canonexposuremode' => { 34 => 0x14 },
	'canonfiledescription' => { 97 => 0x805 },
	'canonfilelength' => { 64 => 0xe },
	'canonfirmwareversion' => { 64 => 0x7, 97 => 0x80b },
	'canonflashinfo' => { 97 => 0x1028 },
	'canonflashmode' => { 34 => 0x4 },
	'canonimagesize' => { 10 => 0x39, 34 => 0xa },
	'canonimagetype' => { 64 => 0x6, 97 => 0x815 },
	'canonlogversion' => { 63 => 0xb },
	'canonmodelid' => { 64 => 0x10, 97 => 0x1834 },
	'canonvrd' => { 120 => 'CanonVRD' },
	'caption' => { 495 => 'caption' },
	'caption-abstract' => { 131 => 0x78 },
	'captionsauthornames' => { 505 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 505 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 517 => 'CaptionWriter' },
	'captureframerate' => { 113 => 0x4001 },
	'captureheightnormal' => { 138 => 0x1839 },
	'capturelook' => { 138 => 0xc48 },
	'capturemode' => { 394 => 'com.apple.photos.captureMode' },
	'capturesoftware' => { 488 => 'CaptureSoftware' },
	'capturewidthnormal' => { 138 => 0x1838 },
	'capturewidthtest' => { 138 => 0x1842 },
	'cardshutterlock' => { 184 => 0x49 },
	'casioimagesize' => { 113 => 0x9 },
	'catalogsets' => { 131 => 0xff, 481 => 'CatalogSets', 493 => 'CatalogSets' },
	'categories' => { 64 => 0x23, 495 => 'categories' },
	'category' => { 131 => 0xf, 179 => 'WM/Category', 316 => 0x30, 392 => 'catg', 517 => 'Category' },
	'cbcrgain' => { 414 => 0xa036 },
	'cbcrgaindefault' => { 414 => 0xa035 },
	'cbcrmatrix' => { 414 => 0xa034 },
	'cbcrmatrixdefault' => { 414 => 0xa033 },
	'ccdboardversion' => { 335 => 0x331 },
	'ccdscanmode' => { 322 => 0x1039 },
	'ccdsensitivity' => { 280 => 0x6 },
	'ccdversion' => { 335 => 0x330 },
	'ccvavgluminancenits' => { 510 => 'ccv_avg_luminance_nits' },
	'ccvmaxluminancenits' => { 510 => 'ccv_max_luminance_nits' },
	'ccvminluminancenits' => { 510 => 'ccv_min_luminance_nits' },
	'ccvprimariesxy' => { 510 => 'ccv_primaries_xy' },
	'ccvwhitexy' => { 510 => 'ccv_white_xy' },
	'cellglobalid' => { 499 => 'cgi' },
	'celllength' => { 119 => 0x109 },
	'cellr' => { 499 => 'r' },
	'celltowerid' => { 499 => 'cellid' },
	'cellwidth' => { 119 => 0x108 },
	'centerafarea' => { 308 => '15.1' },
	'centerfocuspoint' => { 312 => '2.2' },
	'centerpixel' => { 138 => 0x40c },
	'centerweightedareasize' => { 297 => '7.1', 298 => '8.1', 300 => '8.1', 301 => '8.1', 305 => '7.1', 306 => '5.1', 307 => '7.1', 308 => '6.3', 310 => '8.1', 311 => '8.1', 312 => '8.1', 313 => 0x1f, 314 => 0x1f, 315 => 0x1f },
	'certificate' => { 533 => 'Certificate' },
	'cfainterpolationalgorithm' => { 138 => 0xe60 },
	'cfainterpolationmetric' => { 138 => 0xe61 },
	'cfaoffsetcols' => { 138 => 0xc71 },
	'cfaoffsetrows' => { 138 => 0xc6f },
	'cfapattern' => { 119 => 0xa302, 345 => 0x9, 506 => 'CFAPattern' },
	'cfapattern2' => { 119 => 0x828e },
	'cfapatterncolumns' => { 506 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 506 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 506 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 119 => 0x828d },
	'cfazipperfixthreshold' => { 138 => 0xe62 },
	'channel' => { 519 => 'channel' },
	'channela-lang' => { 519 => [\'channel','channelA-lang'] },
	'channelchannel' => { 519 => [\'channel','channelChannel'] },
	'channels' => { 155 => 'Channels' },
	'channelsubchannel1' => { 519 => [\'channel','channelSubchannel1'] },
	'channelsubchannel2' => { 519 => [\'channel','channelSubchannel2'] },
	'channelsubchannel3' => { 519 => [\'channel','channelSubchannel3'] },
	'channelsubchannel4' => { 519 => [\'channel','channelSubchannel4'] },
	'chapterlist' => { 400 => 'chpl' },
	'checkmark' => { 103 => 0x10101, 108 => 0x26a },
	'checkmark2' => { 109 => 0x8e },
	'childfontfiles' => { 534 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 297 => '10.3', 298 => '11.2', 313 => 0x10b, 314 => 0x10b, 315 => 0x121 },
	'chromablurradius' => { 119 => 0xc631 },
	'chromanoisecolorspace' => { 138 => 0xe6d },
	'chromanoiseedgemapthresh' => { 138 => 0xe6c },
	'chromanoisehighfthresh' => { 138 => 0xe6a },
	'chromanoiselowfthresh' => { 138 => 0xe6b },
	'chromaticaberration' => { 103 => 0x20703, 109 => 0x66, 414 => 0xa051 },
	'chromaticaberrationb' => { 500 => 'ChromaticAberrationB', 502 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 103 => 0x20708, 109 => 0x6b },
	'chromaticaberrationcorr' => { 79 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 119 => 0x7034, 365 => 0x1, 476 => 0x900d },
	'chromaticaberrationcorrparams' => { 119 => 0x7035, 471 => 0x66a, 472 => [0x37c,0x384,0x39c,0x3b0,0x3b8] },
	'chromaticaberrationon' => { 103 => '0x20703.0', 109 => 0x62 },
	'chromaticaberrationr' => { 500 => 'ChromaticAberrationR', 502 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 103 => 0x20707, 109 => 0x6a },
	'chromaticaberrationsetting' => { 80 => 0x6 },
	'chrominancenoisereduction' => { 103 => 0x20601, 109 => 0x5e, 417 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 109 => 0x60 },
	'circadatecreated' => { 514 => 'CircaDateCreated' },
	'circgradbasedcorractive' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrblacks2012' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBlacks2012'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBlacks2012'] },
	'circgradbasedcorrbrightness' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrcorrectionname' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionName'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionName'] },
	'circgradbasedcorrcorrectionsyncid' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionSyncID'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionSyncID'] },
	'circgradbasedcorrdefringe' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrdehaze' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDehaze'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDehaze'] },
	'circgradbasedcorrexposure' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHue'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHue'] },
	'circgradbasedcorrluminancenoise' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskinputdigest' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksInputDigest'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksInputDigest'] },
	'circgradbasedcorrmaskleft' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmaskactive' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskActive'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskActive'] },
	'circgradbasedcorrmaskmaskblendmode' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskBlendMode'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'circgradbasedcorrmaskmaskdigest' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskDigest'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskDigest'] },
	'circgradbasedcorrmaskmaskinverted' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskInverted'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskInverted'] },
	'circgradbasedcorrmaskmaskname' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskName'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskName'] },
	'circgradbasedcorrmaskmasks' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasks'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasks'] },
	'circgradbasedcorrmaskmasksalpha' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAlpha'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'circgradbasedcorrmaskmasksangle' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAngle'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAngle'] },
	'circgradbasedcorrmaskmasksbottom' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksBottom'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksBottom'] },
	'circgradbasedcorrmaskmaskscentervalue' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterValue'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'circgradbasedcorrmaskmaskscenterweight' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterWeight'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'circgradbasedcorrmaskmasksdabs' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksDabs'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksDabs'] },
	'circgradbasedcorrmaskmasksfeather' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFeather'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFeather'] },
	'circgradbasedcorrmaskmasksflipped' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlipped'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'circgradbasedcorrmaskmasksflow' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlow'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlow'] },
	'circgradbasedcorrmaskmasksfullx' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullX'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullX'] },
	'circgradbasedcorrmaskmasksfully' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullY'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullY'] },
	'circgradbasedcorrmaskmasksinputdigest' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksInputDigest'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'circgradbasedcorrmaskmasksleft' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksLeft'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksLeft'] },
	'circgradbasedcorrmaskmasksmaskactive' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskActive'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'circgradbasedcorrmaskmasksmaskblendmode' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'circgradbasedcorrmaskmasksmaskdigest' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskDigest'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'circgradbasedcorrmaskmasksmaskinverted' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskInverted'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'circgradbasedcorrmaskmasksmaskname' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskName'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'circgradbasedcorrmaskmasksmasksubtype' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSubType'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'circgradbasedcorrmaskmasksmasksyncid' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'circgradbasedcorrmaskmasksmaskversion' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskVersion'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'circgradbasedcorrmaskmasksmidpoint' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMidpoint'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'circgradbasedcorrmaskmasksorigin' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksOrigin'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'circgradbasedcorrmaskmasksperimetervalue' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'circgradbasedcorrmaskmasksradius' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRadius'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRadius'] },
	'circgradbasedcorrmaskmasksreferencepoint' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksReferencePoint'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'circgradbasedcorrmaskmasksright' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRight'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRight'] },
	'circgradbasedcorrmaskmasksroundness' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRoundness'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'circgradbasedcorrmaskmaskssizex' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeX'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'circgradbasedcorrmaskmaskssizey' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeY'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'circgradbasedcorrmaskmaskstop' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksTop'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksTop'] },
	'circgradbasedcorrmaskmasksubtype' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSubType'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSubType'] },
	'circgradbasedcorrmaskmasksvalue' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskValue'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'circgradbasedcorrmaskmasksversion' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksVersion'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksVersion'] },
	'circgradbasedcorrmaskmaskswhat' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWhat'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWhat'] },
	'circgradbasedcorrmaskmaskswholeimagearea' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'circgradbasedcorrmaskmasksx' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksX'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksX'] },
	'circgradbasedcorrmaskmasksy' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksY'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksY'] },
	'circgradbasedcorrmaskmasksyncid' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSyncID'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'circgradbasedcorrmaskmaskszerox' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroX'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'circgradbasedcorrmaskmaskszeroy' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroY'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'circgradbasedcorrmaskmaskversion' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskVersion'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskVersion'] },
	'circgradbasedcorrmaskmidpoint' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskorigin' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksOrigin'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksOrigin'] },
	'circgradbasedcorrmaskperimetervalue' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskrange' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'circgradbasedcorrmaskrangeareamodels' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'circgradbasedcorrmaskrangeareamodelscolorsampleinfo' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'circgradbasedcorrmaskrangeareamodelscomponents' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'circgradbasedcorrmaskrangecoloramount' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'circgradbasedcorrmaskrangedepthfeather' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'circgradbasedcorrmaskrangedepthmax' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'circgradbasedcorrmaskrangedepthmin' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'circgradbasedcorrmaskrangeinvert' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'circgradbasedcorrmaskrangelumfeather' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'circgradbasedcorrmaskrangeluminancedepthsampleinfo' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'circgradbasedcorrmaskrangelummax' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'circgradbasedcorrmaskrangelummin' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'circgradbasedcorrmaskrangelumrange' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'circgradbasedcorrmaskrangesampletype' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'circgradbasedcorrmaskrangetype' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'circgradbasedcorrmaskrangeversion' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'circgradbasedcorrmaskreferencepoint' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksReferencePoint'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksReferencePoint'] },
	'circgradbasedcorrmaskright' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskwholeimagearea' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWholeImageArea'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'circgradbasedcorrmaskx' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrrangemask' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMask'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMask'] },
	'circgradbasedcorrrangemaskareamodels' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModels'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'circgradbasedcorrrangemaskareamodelscolorsampleinfo' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'circgradbasedcorrrangemaskareamodelscomponents' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'circgradbasedcorrrangemaskcoloramount' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskColorAmount'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'circgradbasedcorrrangemaskdepthfeather' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthFeather'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'circgradbasedcorrrangemaskdepthmax' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMax'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'circgradbasedcorrrangemaskdepthmin' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMin'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'circgradbasedcorrrangemaskinvert' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskInvert'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskInvert'] },
	'circgradbasedcorrrangemasklumfeather' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumFeather'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'circgradbasedcorrrangemaskluminancedepthsampleinfo' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'circgradbasedcorrrangemasklummax' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMax'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'circgradbasedcorrrangemasklummin' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMin'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'circgradbasedcorrrangemasklumrange' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumRange'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'circgradbasedcorrrangemasksampletype' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskSampleType'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'circgradbasedcorrrangemasktype' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskType'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskType'] },
	'circgradbasedcorrrangemaskversion' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskVersion'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskVersion'] },
	'circgradbasedcorrsaturation' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation'] },
	'circgradbasedcorrshadows2012' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtexture' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTexture'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTexture'] },
	'circgradbasedcorrtint' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrtoninghue' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrtoningsaturation' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningSaturation'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrwhat' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circgradbasedcorrwhites2012' => { 500 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalWhites2012'], 502 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalWhites2012'] },
	'circulargradientbasedcorrections' => { 500 => 'CircularGradientBasedCorrections', 502 => 'CircularGradientBasedCorrections' },
	'city' => { 131 => 0x5a, 161 => 'City', 340 => 0x6d, 517 => 'City' },
	'city2' => { 340 => 0x80 },
	'clarity' => { 127 => 0x100f, 250 => 0x35, 251 => 0x3d, 440 => 0x2036, 500 => 'Clarity', 502 => 'Clarity' },
	'clarity2012' => { 500 => 'Clarity2012', 502 => 'Clarity2012' },
	'claritycontrol' => { 375 => 0x96 },
	'classification' => { 400 => 'clsf' },
	'classifystate' => { 131 => 0xe1 },
	'clearretouch' => { 340 => 0x7c },
	'clearretouchvalue' => { 340 => 0xa3 },
	'client' => { 529 => 'client' },
	'clientname' => { 508 => 'ClientName' },
	'clipboardaspectratio' => { 500 => 'ClipboardAspectRatio', 502 => 'ClipboardAspectRatio' },
	'clipboardorientation' => { 500 => 'ClipboardOrientation', 502 => 'ClipboardOrientation' },
	'clipfilename' => { 400 => 'clfn' },
	'clipid' => { 400 => 'clid' },
	'clmodeshootingspeed' => { 297 => '10.2', 298 => '11.3', 300 => '11.2', 301 => '11.2', 306 => '11.2', 307 => '10.2', 310 => '11.2', 311 => '11.2', 312 => '11.1', 313 => 0x3b, 314 => 0x3b, 315 => 0x3b },
	'cluster' => { 500 => 'Cluster', 502 => 'Cluster' },
	'cmcontrast' => { 325 => 0x2022 },
	'cmddialsreverserotation' => { 313 => 0xba, 314 => 0xba, 315 => 0xba },
	'cmexposurecompensation' => { 325 => 0x2000 },
	'cmhue' => { 325 => 0x2021 },
	'cmsaturation' => { 325 => 0x2020 },
	'cmsharpness' => { 325 => 0x2023 },
	'cmwhitebalance' => { 325 => 0x2001 },
	'cmwhitebalancecomp' => { 325 => 0x2002 },
	'cmwhitebalancegraypoint' => { 325 => 0x2010 },
	'codec' => { 169 => 'Codec' },
	'codedcharacterset' => { 132 => 0x5a },
	'codeversion' => { 400 => 'cver' },
	'collection' => { 330 => 'Collection' },
	'collectionname' => { 170 => [\'Collections','CollectionsCollectionName'], 400 => 'coll' },
	'collections' => { 170 => 'Collections', 495 => 'collections' },
	'collectionuri' => { 170 => [\'Collections','CollectionsCollectionURI'] },
	'color' => { 394 => 'player.movie.visual.color', 518 => 'color' },
	'coloraberrationcontrol' => { 290 => 0xc89224b },
	'coloradjustment' => { 417 => 0x14 },
	'coloradjustmentmode' => { 416 => 0x210 },
	'coloranta' => { 534 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 534 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 534 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 534 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 534 => [\'Colorants','ColorantsCyan'] },
	'colorantgray' => { 534 => [\'Colorants','ColorantsGray'] },
	'colorantgreen' => { 534 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 534 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 534 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 534 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 534 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 534 => 'Colorants' },
	'colorantswatchname' => { 534 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 534 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 534 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 534 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 156 => 'ColorBalance' },
	'colorbalanceadj' => { 290 => 0x76a43202 },
	'colorbalanceblue' => { 181 => 0x1e },
	'colorbalancegreen' => { 181 => 0x1d },
	'colorbalancered' => { 181 => 0x1c },
	'colorbalanceversion' => { 206 => 0x4, 207 => 0x4, 208 => 0x0 },
	'colorblur' => { 109 => 0x65 },
	'colorbluron' => { 103 => 0x20704 },
	'colorbooster' => { 290 => 0x5f0e7d23 },
	'colorboostlevel' => { 284 => 0x1 },
	'colorboosttype' => { 284 => 0x0 },
	'colorchromeeffect' => { 127 => 0x1048 },
	'colorchromefxblue' => { 127 => 0x104e },
	'colorclass' => { 386 => 0xde, 387 => 'ColorClass' },
	'colorcompensationfilter' => { 184 => [0x3a,0x5f], 186 => 0x111, 440 => 0xb022 },
	'colorcompensationfiltercustom' => { 427 => 0xd, 428 => 0xc },
	'colorcompensationfilterset' => { 427 => 0x8, 428 => 0x7, 429 => 0x18, 445 => 0xf },
	'colorcontrol' => { 322 => 0x102b },
	'colorcorrection' => { 476 => 0x8015 },
	'colorcorrectionmatrix' => { 1 => 0x3e },
	'colorcreatoreffect' => { 317 => 0x532 },
	'colordataversion' => { 41 => 0x0, 42 => 0x0, 44 => 0x0, 45 => 0x0, 46 => 0x0, 47 => 0x0, 48 => 0x0, 49 => 0x0, 50 => 0x0 },
	'coloreffect' => { 340 => 0x28 },
	'colorfilter' => { 112 => 0x17, 113 => 0x3017, 181 => 0x29, 189 => [0x38,0x4d,0x4f], 382 => 0x17 },
	'colorgain' => { 257 => 0x51 },
	'colorgradeblending' => { 500 => 'ColorGradeBlending', 502 => 'ColorGradeBlending' },
	'colorgradeglobalhue' => { 500 => 'ColorGradeGlobalHue', 502 => 'ColorGradeGlobalHue' },
	'colorgradegloballum' => { 500 => 'ColorGradeGlobalLum', 502 => 'ColorGradeGlobalLum' },
	'colorgradeglobalsat' => { 500 => 'ColorGradeGlobalSat', 502 => 'ColorGradeGlobalSat' },
	'colorgradehighlightlum' => { 500 => 'ColorGradeHighlightLum', 502 => 'ColorGradeHighlightLum' },
	'colorgrademidtonehue' => { 500 => 'ColorGradeMidtoneHue', 502 => 'ColorGradeMidtoneHue' },
	'colorgrademidtonelum' => { 500 => 'ColorGradeMidtoneLum', 502 => 'ColorGradeMidtoneLum' },
	'colorgrademidtonesat' => { 500 => 'ColorGradeMidtoneSat', 502 => 'ColorGradeMidtoneSat' },
	'colorgradeshadowlum' => { 500 => 'ColorGradeShadowLum', 502 => 'ColorGradeShadowLum' },
	'colorhue' => { 103 => 0x20900, 234 => 0x8d },
	'colorimetricreference' => { 119 => 0xc6bf },
	'colorlabel' => { 505 => 'ColorLabel' },
	'colormatrix' => { 63 => 0xa, 321 => 0x200, 322 => 0x1011, 414 => 0xa030 },
	'colormatrix1' => { 119 => 0xc621, 384 => 0x106 },
	'colormatrix2' => { 119 => 0xc622, 325 => 0x200, 384 => 0x226 },
	'colormatrix3' => { 119 => 0xcd33 },
	'colormatrixa' => { 375 => 0x203 },
	'colormatrixa2' => { 375 => 0x21c },
	'colormatrixadobergb' => { 414 => 0xa032 },
	'colormatrixb' => { 375 => 0x204 },
	'colormatrixb2' => { 375 => 0x21d },
	'colormatrixnumber' => { 322 => 0x1019 },
	'colormatrixsrgb' => { 414 => 0xa031 },
	'colormode' => { 113 => 0x3015, 127 => 0x1210, 140 => 0x66, 181 => 0x28, 184 => 0x16, 186 => 0x101, 187 => 0x36, 189 => 0x7, 234 => 0x3, 280 => 0x4, 340 => 0x32, 417 => 0x2c, 440 => 0xb029, 517 => 'ColorMode' },
	'colormoirereduction' => { 103 => 0x20670, 291 => 0x15 },
	'colormoirereductionmode' => { 291 => 0x5 },
	'colormoirereductionon' => { 103 => '0x20670.0' },
	'colornoisereduction' => { 476 => 0x8029, 500 => 'ColorNoiseReduction', 502 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 500 => 'ColorNoiseReductionDetail', 502 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 291 => 0x18 },
	'colornoisereductionsharpness' => { 291 => 0x1c },
	'colornoisereductionsmoothness' => { 500 => 'ColorNoiseReductionSmoothness', 502 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 123 => 0x2 },
	'colorprofile' => { 181 => 0x33 },
	'colorprofilesettings' => { 317 => 0x539 },
	'colorrepresentation' => { 133 => 0x3c },
	'colorsaturationadj' => { 103 => 0x20305 },
	'colorsequence' => { 133 => 0x41 },
	'colorspace' => { 51 => 0x3, 64 => 0xb4, 97 => 0x10b4, 119 => 0xa001, 135 => 0x3, 162 => 'ColorSpace', 182 => 0x2f, 183 => 0x25, 184 => 0x17, 234 => 0x1e, 317 => 0x507, 375 => 0x37, 414 => 0xa011, 417 => 0xb, 427 => 0x1b, 428 => 0x83, 429 => 0xe, 445 => 0x6, 506 => 'ColorSpace' },
	'colorspace2' => { 63 => 0x9 },
	'colorspecapproximation' => { 135 => 0x2 },
	'colorspecdata' => { 135 => 0x3 },
	'colorspecmethod' => { 135 => 0x0 },
	'colorspecprecedence' => { 135 => 0x1 },
	'colortempasshot' => { 38 => 0x4, 39 => 0x7, 40 => 0x1d, 41 => 0x59, 42 => 0x6d, 43 => 0x26, 44 => 0x43, 47 => 0x43, 48 => 0x43, 49 => 0x43, 50 => 0x4b },
	'colortempauto' => { 38 => 0x9, 39 => 0xf, 40 => 0x22, 41 => 0x5e, 42 => 0x72, 43 => 0x1c, 44 => 0x48, 47 => 0x48, 48 => 0x48, 49 => 0x48, 50 => 0x50 },
	'colortempcloudy' => { 38 => 0x22, 39 => 0x37, 40 => 0x31, 41 => 0xa4, 42 => 0xdb, 43 => 0x35, 44 => 0x5c, 47 => 0x75, 48 => 0x8e, 49 => 0x93, 50 => 0x96, 375 => 0x55 },
	'colortempcustom' => { 44 => 0x84 },
	'colortempcustom1' => { 40 => 0x45 },
	'colortempcustom2' => { 40 => 0x4a },
	'colortempdaylight' => { 38 => 0x18, 39 => 0x27, 40 => 0x27, 41 => 0x9a, 42 => 0xd1, 43 => 0x2b, 44 => 0x52, 47 => 0x6b, 48 => 0x84, 49 => 0x89, 50 => 0x8c, 375 => 0x53 },
	'colortemperature' => { 7 => 0x73, 8 => [0x48,0x4e], 9 => 0xc0, 10 => 0x37, 11 => 0x62, 12 => 0x37, 13 => 0x7c, 14 => 0x73, 15 => 0x73, 16 => 0x77, 17 => 0x73, 18 => 0x7c, 19 => 0x58, 20 => 0x73, 21 => 0xc0, 22 => 0x7f, 23 => 0x7d, 24 => 0xc0, 25 => 0xc6, 26 => 0xc7, 27 => 0x135, 28 => 0x7b, 29 => 0x13a, 64 => 0xae, 74 => 0x9, 97 => 0x10ae, 127 => 0x1005, 138 => 0x846, 156 => 'ColorTemperature', 182 => [0x6e,0x49], 183 => 0x3f, 184 => [0x39,0x5e], 186 => 0x10b, 189 => [0x3c,0x4c,0x4e], 335 => 0x321, 375 => 0x50, 407 => 0x1308, 440 => 0xb021, 500 => 'Temperature', 502 => 'Temperature' },
	'colortemperatureadj' => { 476 => 0x8013 },
	'colortemperatureauto' => { 234 => 0x4f },
	'colortemperaturebg' => { 322 => 0x1013 },
	'colortemperaturecustom' => { 427 => 0xc, 428 => 0xb },
	'colortemperaturerg' => { 322 => 0x1014 },
	'colortemperatureset' => { 427 => 0x7, 428 => 0x6 },
	'colortemperaturesetting' => { 184 => 0x25, 429 => 0x17, 445 => 0xe },
	'colortempflash' => { 38 => 0x36, 39 => 0x57, 40 => 0x40, 41 => 0xb8, 42 => 0xef, 43 => 0x49, 44 => 0x70, 47 => 0x89, 48 => 0xa2, 49 => 0xa7, 50 => 0xaa, 375 => 0x5a },
	'colortempflashdata' => { 44 => 0x24a },
	'colortempfluorescent' => { 38 => 0x2c, 39 => 0x47, 40 => 0x3b, 41 => 0xae, 42 => 0xe5, 43 => 0x3f, 44 => 0x66, 47 => 0x7f, 48 => 0x98, 49 => 0x9d, 50 => 0xa0 },
	'colortempfluorescentd' => { 375 => 0x57 },
	'colortempfluorescentn' => { 375 => 0x58 },
	'colortempfluorescentw' => { 375 => 0x59 },
	'colortempkelvin' => { 38 => 0x31, 39 => 0x4f, 41 => 0xb3, 42 => 0xea, 43 => 0x44, 44 => 0x6b, 47 => 0x84, 48 => 0x9d, 49 => 0xa2, 50 => 0xa5, 340 => 0x44, 407 => 0x1307 },
	'colortempmeasured' => { 38 => 0xe, 39 => 0x17, 41 => 0x63, 42 => 0x77, 44 => 0x4d, 47 => 0x4d, 48 => 0x4d, 49 => 0x4d, 50 => 0x55 },
	'colortemppc1' => { 43 => 0x94, 44 => 0x75 },
	'colortemppc2' => { 43 => 0x99, 44 => 0x7a },
	'colortemppc3' => { 43 => 0x9e, 44 => 0x7f },
	'colortempshade' => { 38 => 0x1d, 39 => 0x2f, 40 => 0x2c, 41 => 0x9f, 42 => 0xd6, 43 => 0x30, 44 => 0x57, 47 => 0x70, 48 => 0x89, 49 => 0x8e, 50 => 0x91, 375 => 0x54 },
	'colortemptungsten' => { 38 => 0x27, 39 => 0x3f, 40 => 0x36, 41 => 0xa9, 42 => 0xe0, 43 => 0x3a, 44 => 0x61, 47 => 0x7a, 48 => 0x93, 49 => 0x98, 50 => 0x9b, 375 => 0x56 },
	'colortempunknown' => { 38 => 0x13, 39 => 0x1f, 41 => 0x68, 42 => 0x7c, 43 => 0x21, 47 => 0x52, 48 => 0x52, 49 => 0x52, 50 => 0x5a },
	'colortempunknown10' => { 38 => 0x63, 39 => 0x9f, 41 => 0x95, 42 => 0xa9, 43 => 0x76, 47 => 0xa2, 48 => 0x7f, 49 => 0x7f, 50 => 0x87 },
	'colortempunknown11' => { 38 => 0x68, 39 => 0xa7, 41 => 0xbd, 42 => [0xae,0xb3], 43 => 0x7b, 47 => 0xa7, 48 => 0xa7, 49 => 0x84, 50 => 0xaf },
	'colortempunknown12' => { 38 => 0x6d, 39 => 0xaf, 41 => 0xc2, 42 => 0xb8, 43 => 0x80, 47 => 0xac, 48 => 0xac, 49 => 0xac, 50 => 0xb4 },
	'colortempunknown13' => { 38 => 0x72, 39 => 0xb7, 41 => 0xc7, 42 => 0xbd, 43 => 0x85, 47 => 0xb1, 48 => 0xb1, 49 => 0xb1, 50 => 0xb9 },
	'colortempunknown14' => { 41 => 0xcc, 42 => 0xc2, 43 => 0x8a, 47 => 0xb6, 48 => 0xb6, 49 => 0xb6, 50 => 0xbe },
	'colortempunknown15' => { 41 => 0xd1, 42 => 0xc7, 43 => 0x8f, 47 => 0xbb, 48 => 0xbb, 49 => 0xbb, 50 => 0xc3 },
	'colortempunknown16' => { 41 => 0xd6, 42 => 0xcc, 43 => 0xa3, 48 => 0xc0, 49 => 0xc0, 50 => 0xc8 },
	'colortempunknown17' => { 41 => 0xdb, 42 => 0xf4, 48 => 0xc5, 49 => 0xc5, 50 => 0xcd },
	'colortempunknown18' => { 41 => 0xe0, 42 => 0xf9, 48 => 0xca, 49 => 0xca, 50 => 0xd2 },
	'colortempunknown19' => { 41 => 0xe5, 42 => 0xfe, 48 => 0xcf, 49 => 0xcf, 50 => 0xd7 },
	'colortempunknown2' => { 38 => 0x3b, 39 => 0x5f, 41 => 0x6d, 42 => 0x81, 43 => 0x4e, 47 => 0x57, 48 => 0x57, 49 => 0x57, 50 => 0x5f },
	'colortempunknown20' => { 41 => 0xea, 42 => 0x103, 48 => 0xd4, 49 => 0xd4, 50 => 0xdc },
	'colortempunknown21' => { 41 => 0xef, 42 => 0x108, 49 => 0xd9, 50 => 0xe1 },
	'colortempunknown22' => { 41 => 0xf4, 42 => 0x10d, 49 => 0xde, 50 => 0xe6 },
	'colortempunknown23' => { 41 => 0xf9, 42 => 0x112, 49 => 0xe3, 50 => 0xeb },
	'colortempunknown24' => { 41 => 0xfe, 42 => 0x117, 49 => 0xe8, 50 => 0xf0 },
	'colortempunknown25' => { 41 => 0x103, 42 => 0x11c, 49 => 0xed, 50 => 0xf5 },
	'colortempunknown26' => { 41 => 0x108, 42 => 0x121, 49 => 0xf2, 50 => 0xfa },
	'colortempunknown27' => { 41 => 0x10d, 42 => 0x126, 49 => 0xf7, 50 => 0xff },
	'colortempunknown28' => { 41 => 0x112, 49 => 0xfc, 50 => 0x104 },
	'colortempunknown29' => { 41 => 0x117, 49 => 0x101, 50 => 0x109 },
	'colortempunknown3' => { 38 => 0x40, 39 => 0x67, 41 => 0x72, 42 => 0x86, 43 => 0x53, 47 => 0x5c, 48 => 0x5c, 49 => 0x5c, 50 => 0x64 },
	'colortempunknown30' => { 49 => 0x106 },
	'colortempunknown4' => { 38 => 0x45, 39 => 0x6f, 41 => 0x77, 42 => 0x8b, 43 => 0x58, 47 => 0x61, 48 => 0x61, 49 => 0x61, 50 => 0x69 },
	'colortempunknown5' => { 38 => 0x4a, 39 => 0x77, 41 => 0x7c, 42 => 0x90, 43 => 0x5d, 47 => 0x66, 48 => 0x66, 49 => 0x66, 50 => 0x6e },
	'colortempunknown6' => { 38 => 0x4f, 39 => 0x7f, 41 => 0x81, 42 => 0x95, 43 => 0x62, 47 => 0x8e, 48 => 0x6b, 49 => 0x6b, 50 => 0x73 },
	'colortempunknown7' => { 38 => 0x54, 39 => 0x87, 41 => 0x86, 42 => 0x9a, 43 => 0x67, 47 => 0x93, 48 => 0x70, 49 => 0x70, 50 => 0x78 },
	'colortempunknown8' => { 38 => 0x59, 39 => 0x8f, 41 => 0x8b, 42 => 0x9f, 43 => 0x6c, 47 => 0x98, 48 => 0x75, 49 => 0x75, 50 => 0x7d },
	'colortempunknown9' => { 38 => 0x5e, 39 => 0x97, 41 => 0x90, 42 => 0xa4, 43 => 0x71, 47 => 0x9d, 48 => 0x7a, 49 => 0x7a, 50 => 0x82 },
	'colortint' => { 339 => 0x35c },
	'colortone' => { 10 => 0x6f, 12 => 0x77, 34 => 0x2a, 51 => 0x2, 63 => 0x8 },
	'colortoneadj' => { 103 => 0x20304, 108 => 0x11e },
	'colortoneauto' => { 71 => 0x9c },
	'colortonefaithful' => { 19 => 0x107, 70 => 0x6c, 71 => 0x6c },
	'colortonelandscape' => { 19 => 0x105, 70 => 0x3c, 71 => 0x3c },
	'colortonemonochrome' => { 70 => 0x84, 71 => 0x84 },
	'colortoneneutral' => { 19 => 0x106, 70 => 0x54, 71 => 0x54 },
	'colortoneportrait' => { 19 => 0x104, 70 => 0x24, 71 => 0x24 },
	'colortonestandard' => { 19 => 0x103, 70 => 0xc, 71 => 0xc },
	'colortoneuserdef1' => { 19 => 0x109, 70 => 0x9c, 71 => 0xb4 },
	'colortoneuserdef2' => { 19 => 0x10a, 70 => 0xb4, 71 => 0xcc },
	'colortoneuserdef3' => { 19 => 0x10b, 70 => 0xcc, 71 => 0xe4 },
	'comlenblksize' => { 138 => 0xfde8 },
	'commanddialplaybackmode' => { 313 => 0x1cb, 314 => 0x1cb, 315 => 0x1e3 },
	'commanddials' => { 308 => '5.1' },
	'commanddialsaperturesetting' => { 297 => '17.3', 298 => '18.3', 300 => '18.3', 301 => '18.3', 306 => '33.3', 307 => '17.3', 310 => '18.3', 311 => '18.3' },
	'commanddialschangemainsub' => { 297 => '17.2', 298 => '18.1', 300 => '18.1', 301 => '18.1', 306 => '33.2', 307 => '17.2', 310 => '18.1', 311 => '18.1' },
	'commanddialsmenuandplayback' => { 297 => '17.4', 298 => '18.2', 300 => '18.2', 301 => '18.2', 306 => '33.4', 307 => '17.4', 310 => '18.2', 311 => '18.2' },
	'commanddialsreverserotation' => { 297 => '17.1', 298 => '6.4', 300 => '6.2', 301 => '6.2', 302 => '16.2', 303 => '17.2', 306 => '33.1', 307 => '17.1', 310 => '6.2', 311 => '6.2', 312 => '18.1' },
	'commanderchannel' => { 308 => '10.2', 309 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 308 => '13.1', 309 => '31.1' },
	'commandergroupa_ttlcomp' => { 312 => '32.1' },
	'commandergroupamanualoutput' => { 308 => '13.2', 309 => '28.2' },
	'commandergroupamode' => { 308 => '11.2', 309 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 308 => '14.1', 309 => '32.1' },
	'commandergroupb_ttlcomp' => { 312 => '33.1' },
	'commandergroupbmanualoutput' => { 308 => '14.2', 309 => '29.2' },
	'commandergroupbmode' => { 308 => '11.3', 309 => '29.1' },
	'commanderinternalflash' => { 308 => '11.1', 309 => '27.1' },
	'commanderinternalmanualoutput' => { 308 => '12.2', 309 => '27.2' },
	'commanderinternalttlchannel' => { 306 => '18.2' },
	'commanderinternalttlcomp' => { 308 => '12.1', 309 => '30.2', 312 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 306 => '20.1', 307 => '26.1' },
	'commanderinternalttlcompgroupa' => { 306 => '21.1', 307 => '27.1' },
	'commanderinternalttlcompgroupb' => { 306 => '22.1', 307 => '28.1' },
	'comment' => { 0 => 0x2, 120 => 'Comment', 157 => 'Comment', 330 => 'Comment', 392 => "\xa9cmt", 394 => 'comment', 400 => "\xa9cmt" },
	'compass' => { 410 => 0x4 },
	'compatibleversion' => { 500 => 'CompatibleVersion', 502 => 'CompatibleVersion' },
	'compilation' => { 392 => 'cpil' },
	'compimageimagespersequence' => { 507 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesNumberOfImagesInSequences'] },
	'compimagemaxexposureall' => { 507 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMaxExposureTimesOfAll'] },
	'compimagemaxexposureused' => { 507 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMaxExposureTimesOfUsed'] },
	'compimageminexposureall' => { 507 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMinExposureTimesOfAll'] },
	'compimageminexposureused' => { 507 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMinExposureTimesOfUsed'] },
	'compimagenumsequences' => { 507 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesNumberOfSequences'] },
	'compimagesumexposureall' => { 507 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesSumOfExposureTimesOfAll'] },
	'compimagesumexposureused' => { 507 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesSumOfExposureTimesOfUsed'] },
	'compimagetotalexposureperiod' => { 507 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesTotalExposurePeriod'] },
	'compimagevalues' => { 507 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesValues'] },
	'complianceprofile' => { 519 => 'complianceProfile' },
	'componentsconfiguration' => { 119 => 0x9101, 162 => 'Components', 506 => 'ComponentsConfiguration' },
	'componentversion' => { 97 => 0x80c },
	'composer' => { 179 => 'WM/Composer', 392 => ["\xa9com","\xa9wrt"], 400 => ["\xa9com","\xa9wrt"], 529 => 'composer' },
	'composerid' => { 392 => 'cmID' },
	'composerkeywords' => { 400 => "\xa9cok" },
	'compositeimage' => { 119 => 0xa460, 507 => 'CompositeImage' },
	'compositeimagecount' => { 119 => 0xa461, 507 => 'CompositeImageCount' },
	'compositeimageexposuretimes' => { 119 => 0xa462, 507 => 'CompositeImageExposureTimes' },
	'composition' => { 490 => 'Composition' },
	'compositionadjust' => { 374 => '0.1' },
	'compositionadjustrotation' => { 374 => 0x7 },
	'compositionadjustx' => { 374 => 0x5 },
	'compositionadjusty' => { 374 => 0x6 },
	'compressedbitsperpixel' => { 119 => 0x9102, 506 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 186 => 0x40, 322 => 0x40 },
	'compression' => { 119 => 0x103, 345 => 0xb, 525 => 'Compression' },
	'compressionfactor' => { 317 => 0x50d },
	'compressionformat' => { 63 => 0x4 },
	'compressionratio' => { 162 => 'Compression', 322 => 0x1034 },
	'compressorversion' => { 400 => 'CNCV' },
	'condadobvfactor' => { 138 => 0xf3e },
	'condadodaybvthresh' => { 138 => 0xf3c },
	'condadodayoffsets' => { 138 => 0xf42 },
	'condadofluoffsets' => { 138 => 0xf44 },
	'condadofluthresh' => { 138 => 0xf41 },
	'condadoillfactor' => { 138 => 0xf3f },
	'condadoneurange' => { 138 => 0xf3d },
	'condadotunoffsets' => { 138 => 0xf43 },
	'condadotunthresh' => { 138 => 0xf40 },
	'conductor' => { 179 => 'WM/Conductor', 392 => "\xa9con" },
	'confidence' => { 485 => 'Confidence' },
	'confidencelevel' => { 496 => 'ConfidenceLevel' },
	'confidencemime' => { 485 => 'ConfidenceMime' },
	'constrainedcropheight' => { 108 => 0x266, 386 => 0xd6 },
	'constrainedcropwidth' => { 108 => 0x262, 386 => 0xd5 },
	'contact' => { 131 => 0x76 },
	'contactinfo' => { 500 => 'ContactInfo', 502 => 'ContactInfo', 518 => 'contactInfo' },
	'container' => { 479 => 'Container' },
	'containerdirectory' => { 479 => [\'Container','ContainerDirectory'] },
	'containerdirectoryitem' => { 479 => [\'Container','ContainerDirectoryItem'] },
	'containerdirectoryitemdatauri' => { 479 => [\'Container','ContainerDirectoryItemDataURI'] },
	'containerdirectoryitemlength' => { 479 => [\'Container','ContainerDirectoryItemLength'] },
	'containerdirectoryitemmime' => { 479 => [\'Container','ContainerDirectoryItemMime'] },
	'containerdirectoryitempadding' => { 479 => [\'Container','ContainerDirectoryItemPadding'] },
	'containerformat' => { 514 => 'ContainerFormat' },
	'containerformatidentifier' => { 514 => [\'ContainerFormat','ContainerFormatIdentifier'] },
	'containerformatname' => { 514 => [\'ContainerFormat','ContainerFormatName'] },
	'contentcreatedate' => { 392 => "\xa9day", 400 => ['@day',"\xa9day"] },
	'contentdistributor' => { 179 => 'WM/ContentDistributor' },
	'contentdistributorid' => { 400 => 'cdis' },
	'contentid' => { 400 => 'ccid' },
	'contentidentifier' => { 1 => 0x11, 394 => 'content.identifier' },
	'contentlocationcode' => { 131 => 0x1a },
	'contentlocationname' => { 131 => 0x1b },
	'contenttype' => { 519 => 'contentType' },
	'continuousbracketing' => { 184 => 0x20 },
	'continuousdrive' => { 34 => 0x5 },
	'continuousmodedisplay' => { 313 => 0x51, 314 => 0x51, 315 => 0x51 },
	'continuousmodeliveview' => { 311 => '77.2' },
	'continuousshootingspeed' => { 84 => 0x610 },
	'continuousshotlimit' => { 84 => 0x611 },
	'contrast' => { 10 => 0x73, 12 => 0x75, 34 => 0xd, 112 => 0xc, 113 => [0x3012,0x20], 119 => [0xa408,0xfe54], 127 => [0x1004,0x1006], 156 => 'Contrast', 176 => 'Contrast', 181 => 0x20, 182 => 0x31, 183 => 0x27, 184 => 0x19, 189 => 0x2, 249 => 0x33, 250 => 0x37, 251 => 0x3f, 322 => 0x1029, 340 => 0x39, 342 => 0x300a, 375 => 0x20, 382 => 0xc, 394 => 'player.movie.visual.contrast', 401 => 0x24, 403 => 0x52, 407 => 0x1012, 417 => 0xd, 427 => 0x1d, 428 => 0x1a, 440 => 0x2004, 500 => 'Contrast', 502 => 'Contrast', 506 => 'Contrast' },
	'contrast2012' => { 500 => 'Contrast2012', 502 => 'Contrast2012' },
	'contrastadj' => { 103 => 0x20303, 108 => 0x115, 293 => 0x2c, 476 => 0x8017 },
	'contrastauto' => { 71 => 0x90 },
	'contrastcurve' => { 234 => 0x8c },
	'contrastdetectaf' => { 193 => 0x4 },
	'contrastdetectafarea' => { 375 => 0x231 },
	'contrastdetectafinfocus' => { 193 => [0x1c,0x52] },
	'contrastfaithful' => { 19 => 0xec, 70 => 0x60, 71 => 0x60 },
	'contrasthighlight' => { 375 => 0x6d },
	'contrasthighlightshadowadj' => { 375 => 0x6f },
	'contrastlandscape' => { 19 => 0xea, 70 => 0x30, 71 => 0x30 },
	'contrastmode' => { 340 => 0x2c },
	'contrastmonochrome' => { 19 => 0xed, 70 => 0x78, 71 => 0x78 },
	'contrastneutral' => { 19 => 0xeb, 70 => 0x48, 71 => 0x48 },
	'contrastportrait' => { 19 => 0xe9, 70 => 0x18, 71 => 0x18 },
	'contrastsetting' => { 317 => 0x505, 325 => 0x1012, 429 => 0x10, 445 => 0x8 },
	'contrastshadow' => { 375 => 0x6e },
	'contraststandard' => { 19 => 0xe8, 70 => 0x0, 71 => 0x0 },
	'contrastuserdef1' => { 19 => 0xee, 70 => 0x90, 71 => 0xa8 },
	'contrastuserdef2' => { 19 => 0xef, 70 => 0xa8, 71 => 0xc0 },
	'contrastuserdef3' => { 19 => 0xf0, 70 => 0xc0, 71 => 0xd8 },
	'contributedmedia' => { 529 => 'contributedMedia' },
	'contributedmediaduration' => { 529 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 529 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 529 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 529 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 529 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 529 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 529 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 529 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 529 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 529 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 503 => 'contributor', 514 => 'Contributor' },
	'contributoridentifier' => { 514 => [\'Contributor','ContributorIdentifier'] },
	'contributorname' => { 514 => [\'Contributor','ContributorName'] },
	'contributorrole' => { 514 => [\'Contributor','ContributorRole'] },
	'contributors' => { 157 => 'Contributors' },
	'controldialset' => { 184 => 0x46 },
	'controlledvocabularyterm' => { 514 => 'CVterm' },
	'controllerboardversion' => { 335 => 0x332 },
	'controlmode' => { 77 => 0x12 },
	'controlringresponse' => { 313 => 0x1d5, 314 => 0x1d5, 315 => 0x1ed },
	'controlringrotation' => { 84 => 0x712 },
	'conversionlens' => { 318 => 0x403, 340 => 0x35 },
	'converter' => { 119 => 0xfe4d, 280 => 0xb, 500 => 'Converter', 502 => 'Converter' },
	'converttograyscale' => { 500 => 'ConvertToGrayscale', 502 => 'ConvertToGrayscale' },
	'cookingequipment' => { 521 => 'cookingEquipment' },
	'cookingmethod' => { 521 => 'cookingMethod' },
	'copyright' => { 0 => 0x3, 119 => 0x8298, 157 => 'Copyright', 330 => 'Copyright', 345 => 0x8298, 375 => 0x22f, 391 => 'Copyright', 392 => ['cprt',"\xa9cpy"], 394 => 'copyright', 400 => ['cprt',"\xa9cpy"], 500 => 'Copyright', 502 => 'Copyright', 516 => 'Copyright', 522 => 'copyright', 525 => 'Copyright', 529 => 'copyright' },
	'copyrightflag' => { 389 => 0x40a },
	'copyrightnotice' => { 131 => 0x74 },
	'copyrightowner' => { 327 => 'CopyrightOwner' },
	'copyrightownerid' => { 327 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 327 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 327 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 327 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 327 => 'CopyrightStatus' },
	'copyrightyear' => { 514 => 'CopyrightYear', 519 => 'copyrightYear' },
	'coringfilter' => { 321 => 0x310, 322 => 0x102d, 325 => 0x310 },
	'coringvalues' => { 321 => 0x311, 325 => 0x311 },
	'corporateentity' => { 519 => 'corporateEntity' },
	'correlatedcolortemp' => { 339 => 0x35b },
	'country' => { 161 => 'Country', 340 => 0x69, 517 => 'Country' },
	'country-primarylocationcode' => { 131 => 0x64 },
	'country-primarylocationname' => { 131 => 0x65 },
	'countrycode' => { 233 => 0x5, 387 => 'CountryCode', 513 => 'CountryCode' },
	'course' => { 521 => 'course' },
	'coverage' => { 503 => 'coverage' },
	'coverart' => { 392 => 'covr' },
	'coverdate' => { 519 => 'coverDate' },
	'coverdisplaydate' => { 519 => 'coverDisplayDate' },
	'coveruri' => { 400 => 'cvru' },
	'cpufirmwareversion' => { 375 => 0x28 },
	'crc32' => { 504 => 'crc32' },
	'createdate' => { 119 => 0x9004, 157 => 'CreateDate', 326 => 'CreationDate', 330 => 'create-date', 391 => 'CreationDate', 397 => 0x1, 527 => 'CreateDate' },
	'creationdate' => { 394 => 'creationdate', 516 => 'CreationDate', 519 => 'creationDate' },
	'creationtime' => { 330 => 'Creation Time' },
	'creativestyle' => { 427 => 0x1a, 428 => 0x18, 438 => 0x41, 440 => 0xb020, 472 => 0x4a },
	'creativestylesetting' => { 429 => 0xf, 445 => 0x7 },
	'creativestylewaschanged' => { 476 => 0x8001 },
	'creator' => { 326 => 'Creator', 391 => 'Creator', 503 => 'creator', 514 => 'Creator', 516 => 'Creator' },
	'creatoraddress' => { 513 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorappid' => { 178 => 'CreatorAppId' },
	'creatorcity' => { 513 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 513 => 'CreatorContactInfo' },
	'creatorcountry' => { 513 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatoridentifier' => { 514 => [\'Creator','CreatorIdentifier'] },
	'creatorname' => { 514 => [\'Creator','CreatorName'] },
	'creatoropenwithuioptions' => { 178 => 'CreatorOpenWithUIOptions' },
	'creatorpostalcode' => { 513 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 513 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatorrole' => { 514 => [\'Creator','CreatorRole'] },
	'creatortool' => { 527 => 'CreatorTool' },
	'creatorworkemail' => { 513 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 513 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 513 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 131 => 0x6e, 517 => 'Credit' },
	'creditline' => { 522 => 'creditLine' },
	'creditlinereq' => { 532 => 'CreditLineReq' },
	'creditlinerequired' => { 327 => 'CreditLineRequired' },
	'cropactive' => { 101 => 0x0, 108 => 0x244 },
	'cropangle' => { 500 => 'CropAngle', 502 => 'CropAngle' },
	'croparea' => { 234 => 0x45, 476 => 0x9011 },
	'cropaspectratio' => { 103 => 0x30101, 108 => 0x260 },
	'cropaspectratiocustom' => { 103 => 0x30102 },
	'cropbottom' => { 123 => 0x9, 285 => 0x36, 345 => 0x31, 386 => 0xdc, 500 => 'CropBottom', 502 => 'CropBottom' },
	'cropbottommargin' => { 53 => 0x3 },
	'cropcircleactive' => { 109 => 0xd6 },
	'cropcircleradius' => { 109 => 0xd9 },
	'cropcirclex' => { 109 => 0xd7 },
	'cropcircley' => { 109 => 0xd8 },
	'cropconstraintowarp' => { 500 => 'CropConstrainToWarp', 502 => 'CropConstrainToWarp' },
	'croph' => { 494 => 'CropH' },
	'cropheight' => { 101 => 0x6, 108 => 0x24c, 321 => 0x615, 325 => 0x615, 500 => 'CropHeight', 502 => 'CropHeight' },
	'crophispeed' => { 234 => 0x1b },
	'cropleft' => { 108 => 0x246, 123 => 0x6, 285 => 0x1e, 321 => 0x612, 325 => 0x612, 345 => 0x30, 386 => 0xd9, 500 => 'CropLeft', 502 => 'CropLeft' },
	'cropleftmargin' => { 53 => 0x0 },
	'cropmode' => { 127 => 0x104d, 407 => 0x1018 },
	'croporiginalheight' => { 101 => 0xb },
	'croporiginalwidth' => { 101 => 0xa },
	'cropoutputheight' => { 285 => 0xce },
	'cropoutputheightinches' => { 285 => 0x96 },
	'cropoutputpixels' => { 285 => 0xd6 },
	'cropoutputresolution' => { 285 => 0xb6 },
	'cropoutputscale' => { 285 => 0xbe },
	'cropoutputwidth' => { 285 => 0xc6 },
	'cropoutputwidthinches' => { 285 => 0x8e },
	'croppedareaimageheightpixels' => { 488 => 'CroppedAreaImageHeightPixels', 489 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 488 => 'CroppedAreaImageWidthPixels', 489 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 488 => 'CroppedAreaLeftPixels', 489 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 488 => 'CroppedAreaTopPixels', 489 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 5 => 0x2, 407 => 0x1604 },
	'croppedimageleft' => { 5 => 0x3 },
	'croppedimagetop' => { 5 => 0x4 },
	'croppedimagewidth' => { 5 => 0x1, 407 => 0x1603 },
	'cropping' => { 476 => 0x9010 },
	'cropright' => { 123 => 0x8, 285 => 0x2e, 345 => 0x32, 386 => 0xdb, 500 => 'CropRight', 502 => 'CropRight' },
	'croprightmargin' => { 53 => 0x1 },
	'croprotatedoriginalheight' => { 101 => 0x2 },
	'croprotatedoriginalwidth' => { 101 => 0x1 },
	'croprotation' => { 101 => 0x8, 123 => 0xb },
	'cropscaledresolution' => { 285 => 0x9e },
	'cropsourceresolution' => { 285 => 0xae },
	'croptop' => { 108 => 0x248, 123 => 0x7, 285 => 0x26, 321 => 0x613, 325 => 0x613, 345 => 0x2f, 386 => 0xda, 500 => 'CropTop', 502 => 'CropTop' },
	'croptopmargin' => { 53 => 0x2 },
	'cropunit' => { 500 => 'CropUnit', 502 => 'CropUnit' },
	'cropunits' => { 500 => 'CropUnits', 502 => 'CropUnits' },
	'cropw' => { 494 => 'CropW' },
	'cropwidth' => { 101 => 0x5, 108 => 0x24a, 321 => 0x614, 325 => 0x614, 500 => 'CropWidth', 502 => 'CropWidth' },
	'cropx' => { 101 => 0x3, 494 => 'CropX' },
	'cropy' => { 101 => 0x4, 494 => 'CropY' },
	'crossprocess' => { 375 => 0x7b },
	'crossprocessparams' => { 375 => 0x235 },
	'cuisine' => { 521 => 'cuisine' },
	'currenticcprofile' => { 119 => 0xc691 },
	'currentpreprofilematrix' => { 119 => 0xc692 },
	'currentversion' => { 476 => 0xd000 },
	'curve0x' => { 494 => 'Curve0x' },
	'curve0y' => { 494 => 'Curve0y' },
	'curve1x' => { 494 => 'Curve1x' },
	'curve1y' => { 494 => 'Curve1y' },
	'curve2x' => { 494 => 'Curve2x' },
	'curve2y' => { 494 => 'Curve2y' },
	'curve3x' => { 494 => 'Curve3x' },
	'curve3y' => { 494 => 'Curve3y' },
	'curve4x' => { 494 => 'Curve4x' },
	'curve4y' => { 494 => 'Curve4y' },
	'curves' => { 290 => 0x76a43201 },
	'custom1' => { 327 => 'Custom1' },
	'custom10' => { 327 => 'Custom10' },
	'custom2' => { 327 => 'Custom2' },
	'custom3' => { 327 => 'Custom3' },
	'custom4' => { 327 => 'Custom4' },
	'custom5' => { 327 => 'Custom5' },
	'custom6' => { 327 => 'Custom6' },
	'custom7' => { 327 => 'Custom7' },
	'custom8' => { 327 => 'Custom8' },
	'custom9' => { 327 => 'Custom9' },
	'customcolortone' => { 109 => 0x4c },
	'customcontrast' => { 109 => 0x4e },
	'customcontrols' => { 84 => 0x70c },
	'customdefaultunsharpfineness' => { 109 => 0xbe },
	'customdefaultunsharpstrength' => { 109 => 0xbc },
	'customdefaultunsharpthreshold' => { 109 => 0xc0 },
	'customilluminant' => { 138 => 0x405 },
	'customizedials' => { 84 => 0x715 },
	'customlinear' => { 109 => 0x4f },
	'customoutputhighlightpoint' => { 109 => 0x53 },
	'customoutputshadowpoint' => { 109 => 0x54 },
	'custompicturestyle' => { 103 => 0x10021 },
	'custompicturestyledata' => { 103 => 0xf0500 },
	'custompicturestylefilename' => { 64 => 0x4010 },
	'customrawhighlight' => { 109 => 0x7c },
	'customrawhighlightpoint' => { 109 => 0x51 },
	'customrawshadow' => { 109 => 0x85 },
	'customrawshadowpoint' => { 109 => 0x52 },
	'customrendered' => { 119 => 0xa401, 191 => 0x6420, 506 => 'CustomRendered' },
	'customsaturation' => { 109 => 0x4d, 317 => 0x503 },
	'customsettingsalldefault' => { 297 => '0.2', 306 => '0.2' },
	'customsettingsbank' => { 297 => '0.1', 298 => '0.1', 300 => '0.1', 301 => '0.1', 306 => '0.1', 310 => '0.2', 311 => '0.2', 313 => 0x1, 314 => 0x1, 315 => 0x1 },
	'customsharpness' => { 109 => 0x50 },
	'customunsharpmaskfineness' => { 109 => 0xb8 },
	'customunsharpmaskstrength' => { 109 => 0xb6 },
	'customunsharpmaskthreshold' => { 109 => 0xba },
	'customwb_rblevels' => { 445 => 0x1a },
	'customwb_rgblevels' => { 428 => 0x8, 429 => 0x19 },
	'customwbbluelevel' => { 184 => 0x36 },
	'customwberror' => { 184 => 0x37 },
	'customwbgreenlevel' => { 184 => 0x35 },
	'customwbredlevel' => { 184 => 0x34 },
	'customwbsetting' => { 184 => 0x26 },
	'cx' => { 400 => '_cx_' },
	'cy' => { 400 => '_cy_' },
	'd-lightinghq' => { 290 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 286 => 0x2 },
	'd-lightinghqhighlight' => { 286 => 0x1 },
	'd-lightinghqselected' => { 290 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 286 => 0x0 },
	'd-lightinghs' => { 290 => 0xce5554aa },
	'd-lightinghsadjustment' => { 287 => 0x0 },
	'd-lightinghscolorboost' => { 287 => 0x1 },
	'd-rangeoptimizerhighlight' => { 476 => 0x8024 },
	'd-rangeoptimizermode' => { 476 => 0x8022 },
	'd-rangeoptimizershadow' => { 476 => 0x802d },
	'd-rangeoptimizervalue' => { 476 => 0x8023 },
	'darkblacksegrows' => { 138 => 0x18d8 },
	'darkfocusenvironment' => { 340 => 0x8003 },
	'darkframecountfactor' => { 138 => 0xc85 },
	'darkframelongexposure' => { 138 => 0xc84 },
	'darkframeshortexposure' => { 138 => 0xc83 },
	'darkpedestal' => { 138 => 0xc7f },
	'datacompressionmethod' => { 133 => 0x6e },
	'dataimprint' => { 181 => 0x34 },
	'dataonscreen' => { 514 => 'DataOnScreen' },
	'dataonscreenregion' => { 514 => [\'DataOnScreen','DataOnScreenRegion'] },
	'dataonscreenregiond' => { 514 => [\'DataOnScreen','DataOnScreenRegionD'] },
	'dataonscreenregionh' => { 514 => [\'DataOnScreen','DataOnScreenRegionH'] },
	'dataonscreenregiontext' => { 514 => [\'DataOnScreen','DataOnScreenRegionText'] },
	'dataonscreenregionunit' => { 514 => [\'DataOnScreen','DataOnScreenRegionUnit'] },
	'dataonscreenregionw' => { 514 => [\'DataOnScreen','DataOnScreenRegionW'] },
	'dataonscreenregionx' => { 514 => [\'DataOnScreen','DataOnScreenRegionX'] },
	'dataonscreenregiony' => { 514 => [\'DataOnScreen','DataOnScreenRegionY'] },
	'datascaling' => { 375 => 0x3d },
	'date' => { 375 => 0x6, 503 => 'date' },
	'dateacquired' => { 178 => 'DateAcquired', 179 => '{2CBAA8F5-D81F-47CA-B17A-F8D822300131} 100' },
	'datecreated' => { 131 => 0x37, 517 => 'DateCreated' },
	'datedisplayformat' => { 282 => 0x3 },
	'dateidentified' => { 118 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 302 => '4.2' },
	'daterecieved' => { 519 => 'dateRecieved' },
	'datesent' => { 132 => 0x46 },
	'datestampmode' => { 64 => 0x1c, 234 => 0x9d },
	'datetime' => { 495 => 'datetime', 525 => 'DateTime' },
	'datetimedigitized' => { 506 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 100 => 0x0, 119 => 0x9003, 154 => 0x14, 157 => 'OriginalDate', 395 => 'IDIT', 400 => 'date', 401 => 0xb, 402 => 0x3b, 403 => 0x3e, 506 => 'DateTimeOriginal' },
	'datetimestamp' => { 140 => 0x64 },
	'datetimeutc' => { 317 => 0x908 },
	'daylightsavings' => { 78 => 0x3, 282 => 0x2 },
	'dayofweek' => { 402 => 0x42, 403 => 0x4a },
	'dccontinent' => { 118 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 118 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 118 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 118 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 118 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 118 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 118 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 118 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 118 => 'Event' },
	'dcfootprintspatialfit' => { 118 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 118 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 118 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 118 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 118 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 118 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 118 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 118 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 118 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 118 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 118 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 118 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 118 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 118 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 118 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 118 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 118 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 118 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 118 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 118 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 118 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 118 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 118 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 118 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 118 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 118 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 118 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 118 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 118 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcverticaldatum' => { 118 => [\'dctermsLocation','dctermsLocationVerticalDatum'] },
	'dcwaterbody' => { 118 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 165 => 'Declination' },
	'decposition' => { 181 => 0x32 },
	'defaultautogray' => { 500 => 'DefaultAutoGray', 502 => 'DefaultAutoGray' },
	'defaultautotone' => { 500 => 'DefaultAutoTone', 502 => 'DefaultAutoTone' },
	'defaultblackrender' => { 119 => 0xc7a6 },
	'defaultcroporigin' => { 119 => 0xc61f },
	'defaultcropsize' => { 119 => 0xc620 },
	'defaulteraseoption' => { 84 => 0x813 },
	'defaultscale' => { 119 => 0xc61e },
	'defaultsspecifictoiso' => { 500 => 'DefaultsSpecificToISO', 502 => 'DefaultsSpecificToISO' },
	'defaultsspecifictoserial' => { 500 => 'DefaultsSpecificToSerial', 502 => 'DefaultsSpecificToSerial' },
	'defaultusercrop' => { 119 => 0xc7b5 },
	'defectisocode' => { 138 => 0x90f },
	'defringe' => { 500 => 'Defringe', 502 => 'Defringe' },
	'defringegreenamount' => { 500 => 'DefringeGreenAmount', 502 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 500 => 'DefringeGreenHueHi', 502 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 500 => 'DefringeGreenHueLo', 502 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 500 => 'DefringePurpleAmount', 502 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 500 => 'DefringePurpleHueHi', 502 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 500 => 'DefringePurpleHueLo', 502 => 'DefringePurpleHueLo' },
	'dehaze' => { 500 => 'Dehaze', 502 => 'Dehaze' },
	'deletedimagecount' => { 234 => 0xa6, 262 => 0x6e },
	'deprecatedon' => { 498 => 'deprecatedOn' },
	'depthfar' => { 119 => 0xc7eb },
	'depthformat' => { 119 => 0xc7e9 },
	'depthimage' => { 485 => 'Data' },
	'depthmeasuretype' => { 119 => 0xc7ed },
	'depthnear' => { 119 => 0xc7ea },
	'depthunits' => { 119 => 0xc7ec },
	'derivedfrom' => { 530 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 530 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 530 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 530 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 530 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 530 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 530 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfromlasturl' => { 530 => [\'DerivedFrom','DerivedFromLastURL'] },
	'derivedfromlinkcategory' => { 530 => [\'DerivedFrom','DerivedFromLinkCategory'] },
	'derivedfromlinkform' => { 530 => [\'DerivedFrom','DerivedFromLinkForm'] },
	'derivedfrommanager' => { 530 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 530 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 530 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 530 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 530 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 530 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 530 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromplacedresolutionunit' => { 530 => [\'DerivedFrom','DerivedFromPlacedResolutionUnit'] },
	'derivedfromplacedxresolution' => { 530 => [\'DerivedFrom','DerivedFromPlacedXResolution'] },
	'derivedfromplacedyresolution' => { 530 => [\'DerivedFrom','DerivedFromPlacedYResolution'] },
	'derivedfromrenditionclass' => { 530 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 530 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 530 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 530 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 330 => 'Description', 392 => ['desc','dscp',"\xa9des"], 394 => 'description', 400 => 'dscp', 500 => 'Description', 502 => 'Description', 503 => 'description', 527 => 'Description' },
	'destination' => { 132 => 0x5 },
	'destinationcity' => { 375 => 0x24, 381 => 0x3 },
	'destinationcitycode' => { 382 => 0x1001 },
	'destinationdst' => { 375 => 0x26, 381 => '0.3' },
	'developmentdynamicrange' => { 127 => 0x1403 },
	'deviantmatrixcustom' => { 138 => 0x7de },
	'deviantmatrixdaylight' => { 138 => 0x7da },
	'deviantmatrixflash' => { 138 => 0x7dd },
	'deviantmatrixfluorescent' => { 138 => 0x7dc },
	'deviantmatrixtungsten' => { 138 => 0x7db },
	'deviantwhitecustom' => { 138 => 0x842 },
	'deviantwhitedaylight' => { 138 => 0x83e },
	'deviantwhiteflash' => { 138 => 0x841 },
	'deviantwhitefluorescent' => { 138 => 0x840 },
	'deviantwhitetungsten' => { 138 => 0x83f },
	'device' => { 519 => 'device' },
	'devicesettingdescription' => { 506 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 506 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 506 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 506 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'devicetype' => { 414 => 0x2 },
	'dewarpdata' => { 116 => 'DewarpData' },
	'dewarpflag' => { 116 => 'DewarpFlag' },
	'dialdirectiontvav' => { 84 => 0x706 },
	'dietaryneeds' => { 521 => 'dietaryNeeds' },
	'diffractioncompensation' => { 223 => 0x20e, 238 => 0x142, 239 => 0x1b2, 240 => 0x1a2, 241 => 0x1b6, 242 => 0x1b6 },
	'diffractioncorrection' => { 340 => 0xbc, 365 => 0x3 },
	'diffractioncorrectionon' => { 103 => 0x2070b },
	'digitalcreationdate' => { 131 => 0x3e },
	'digitalcreationtime' => { 131 => 0x3f },
	'digitaldeehighlightadj' => { 257 => 0x202 },
	'digitaldeeshadowadj' => { 257 => 0x200 },
	'digitaldeethreshold' => { 257 => 0x201 },
	'digitalfilter' => { 417 => 0x59 },
	'digitalfilter01' => { 362 => 0x5 },
	'digitalfilter02' => { 362 => 0x16 },
	'digitalfilter03' => { 362 => 0x27 },
	'digitalfilter04' => { 362 => 0x38 },
	'digitalfilter05' => { 362 => 0x49 },
	'digitalfilter06' => { 362 => 0x5a },
	'digitalfilter07' => { 362 => 0x6b },
	'digitalfilter08' => { 362 => 0x7c },
	'digitalfilter09' => { 362 => 0x8d },
	'digitalfilter10' => { 362 => 0x9e },
	'digitalfilter11' => { 362 => 0xaf },
	'digitalfilter12' => { 362 => 0xc0 },
	'digitalfilter13' => { 362 => 0xd1 },
	'digitalfilter14' => { 362 => 0xe2 },
	'digitalfilter15' => { 362 => 0xf3 },
	'digitalfilter16' => { 362 => 0x104 },
	'digitalfilter17' => { 362 => 0x115 },
	'digitalfilter18' => { 362 => 0x126 },
	'digitalfilter19' => { 362 => 0x137 },
	'digitalfilter20' => { 362 => 0x148 },
	'digitalgain' => { 74 => 0xb },
	'digitalgem' => { 218 => 0x0 },
	'digitalice' => { 257 => 0x100 },
	'digitalimageguid' => { 514 => 'DigImageGUID' },
	'digitallensoptimizer' => { 62 => 0xa },
	'digitallensoptimizersetting' => { 80 => 0x9 },
	'digitalroc' => { 254 => 0x0 },
	'digitalsourcefiletype' => { 514 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 514 => 'DigitalSourceType' },
	'digitalzoom' => { 34 => 0xc, 112 => 0xa, 127 => 0x1044, 140 => 0x68, 151 => 0x22, 152 => 0x1e, 156 => 'DigitalZoom', 181 => 0xc, 234 => 0x86, 280 => 0xa, 322 => 0x204, 375 => 0x1e, 382 => 0xa, 416 => 0x204, 463 => 0x12, 464 => 0x12 },
	'digitalzoomon' => { 416 => 0x21b },
	'digitalzoomratio' => { 119 => 0xa404, 451 => 0x200, 453 => 0x21c, 506 => 'DigitalZoomRatio' },
	'director' => { 179 => 'WM/Director', 392 => "\xa9dir", 394 => 'director', 400 => "\xa9dir", 529 => 'director' },
	'directorphotography' => { 529 => 'directorPhotography' },
	'directory' => { 120 => 'Directory' },
	'directoryindex' => { 7 => 0x137, 9 => 0x2dc, 11 => 0x17e, 13 => 0x238, 14 => 0x13f, 15 => 0x133, 16 => 0x1df, 17 => 0x1a7, 18 => 0x1f0, 19 => 0xcc, 20 => 0x1c7, 21 => 0x298, 22 => 0x1e7, 23 => 0x1e5, 24 => [0x27c,0x280], 25 => 0x2b6, 26 => 0x2bf, 28 => 0x1f7, 29 => 0x4ba },
	'directoryindex2' => { 21 => 0x29c },
	'directorynumber' => { 211 => 0x3, 403 => 0x12 },
	'disableautocreation' => { 483 => 'DisableAutoCreation' },
	'disclaimer' => { 330 => 'Disclaimer' },
	'discnumber' => { 529 => 'discNumber' },
	'dishtype' => { 521 => 'dishType' },
	'disknumber' => { 392 => 'disk' },
	'dispbutton' => { 242 => 0x7d4, 313 => 0x2ab },
	'displayallafpoints' => { 84 => 0x514 },
	'displayaperture' => { 34 => 0x23 },
	'displayedunitsx' => { 390 => 0x2 },
	'displayedunitsy' => { 390 => 0x6 },
	'displayname' => { 394 => 'displayname', 518 => 'displayName' },
	'distance1' => { 140 => 0x28 },
	'distance2' => { 140 => 0x2c },
	'distance3' => { 140 => 0x30 },
	'distance4' => { 140 => 0x34 },
	'distortion' => { 414 => 0xa050 },
	'distortioncompensation' => { 476 => 0x8040 },
	'distortioncontrol' => { 262 => 0x10 },
	'distortioncorrection' => { 79 => 0x3, 103 => 0x20705, 109 => 0x67, 119 => 0x7036, 317 => 0x50b, 344 => '7.1', 365 => 0x0, 471 => 0x601, 472 => 0x5b },
	'distortioncorrection2' => { 321 => 0x1011 },
	'distortioncorrectionalreadyapplied' => { 497 => 'DistortionCorrectionAlreadyApplied' },
	'distortioncorrectionon' => { 103 => '0x20705.0', 109 => 0x63 },
	'distortioncorrectionsetting' => { 80 => 0x7, 440 => 0x2013 },
	'distortioncorrectionvalue' => { 79 => 0x9 },
	'distortioncorrparams' => { 119 => 0x7037, 450 => 0x1a23, 453 => 0x1870, 455 => 0x189c, 456 => 0x18cc, 457 => 0x17d0, 471 => 0x6ca, 472 => 0x64 },
	'distortioncorrparamsnumber' => { 453 => 0x1899, 455 => 0x18c5, 456 => 0x18f5, 457 => 0x17f9 },
	'distortioncorrparamspresent' => { 453 => 0x1898, 455 => 0x18c4, 456 => 0x18f4, 457 => 0x17f8, 459 => 0x10b, 460 => 0x10b, 471 => 0x600, 472 => 0x5a },
	'distortioneffect' => { 103 => 0x20709 },
	'distortionn' => { 344 => 0xc },
	'distortionparam02' => { 344 => 0x2 },
	'distortionparam04' => { 344 => 0x4 },
	'distortionparam08' => { 344 => 0x8 },
	'distortionparam09' => { 344 => 0x9 },
	'distortionparam11' => { 344 => 0xb },
	'distortionscale' => { 344 => 0x5 },
	'distributor' => { 519 => 'distributor' },
	'distributorproductid' => { 518 => 'distributorProductID' },
	'dloon' => { 103 => '0x20706.0', 109 => 0xdc },
	'dlosetting' => { 103 => 0x20706, 109 => 0xdd },
	'dlosettingapplied' => { 102 => 0x4 },
	'dloshootingdistance' => { 109 => 0xde },
	'dloversion' => { 102 => 0x5 },
	'dmcomment' => { 529 => 'comment' },
	'dmdithermatrix' => { 138 => 0xc7a },
	'dmdithermatrixheight' => { 138 => 0xc7c },
	'dmdithermatrixwidth' => { 138 => 0xc7b },
	'dngadobedata' => { 119 => 0xc634 },
	'dngbackwardversion' => { 119 => 0xc613 },
	'dngignoresidecars' => { 500 => 'DNGIgnoreSidecars', 502 => 'DNGIgnoreSidecars' },
	'dnglensinfo' => { 119 => 0xc630 },
	'dngprivatedata' => { 119 => 0xc634 },
	'dngversion' => { 119 => 0xc612 },
	'document' => { 330 => 'Document' },
	'documentancestors' => { 517 => 'DocumentAncestors' },
	'documenthistory' => { 131 => 0xe7 },
	'documentid' => { 530 => 'DocumentID' },
	'documentname' => { 119 => 0x10d },
	'documentnotes' => { 131 => 0xe6 },
	'doi' => { 519 => 'doi' },
	'dopesheet' => { 514 => 'Dopesheet' },
	'dopesheetlink' => { 514 => 'DopesheetLink' },
	'dopesheetlinklink' => { 514 => [\'DopesheetLink','DopesheetLinkLink'] },
	'dopesheetlinklinkqualifier' => { 514 => [\'DopesheetLink','DopesheetLinkLinkQualifier'] },
	'doublingmicrovolts' => { 138 => 0xc82 },
	'dpp' => { 495 => 'dpp' },
	'dr4cameramodel' => { 104 => 0x3 },
	'drangepriority' => { 127 => 0x1443 },
	'drangepriorityauto' => { 127 => 0x1444 },
	'drangepriorityfixed' => { 127 => 0x1445 },
	'drivemode' => { 113 => 0x3103, 125 => '0.1', 181 => 0x6, 184 => 0x1e, 187 => 0xe, 191 => 0x64d0, 317 => 0x600, 375 => 0x34, 407 => 0x1002, 417 => 0x3, 427 => 0x4, 428 => 0x7e, 429 => 0x34 },
	'drivemode2' => { 184 => 0xa, 356 => 0x7, 438 => 0xe, 445 => 0x1 },
	'drivemodesetting' => { 429 => 0x4 },
	'drivespeed' => { 125 => '0.2' },
	'dspfirmwareversion' => { 375 => 0x27 },
	'duration' => { 67 => 0x6a, 155 => 'Duration', 169 => 'Duration', 521 => 'duration', 529 => 'duration' },
	'durationscale' => { 529 => [\'duration','durationScale'] },
	'durationvalue' => { 529 => [\'duration','durationValue'] },
	'dustremovaldata' => { 64 => 0x97 },
	'dxcropalert' => { 239 => 0x250, 240 => 0x23c, 241 => 0x250, 242 => 0x250 },
	'dynamicafarea' => { 297 => '1.4', 306 => '1.4' },
	'dynamicafareasize' => { 239 => 0x254, 240 => 0x240, 241 => 0x254, 242 => 0x254 },
	'dynamicareaafassist' => { 313 => 0x18, 314 => 0x18, 315 => 0x18 },
	'dynamicareaafdisplay' => { 298 => '46.1', 300 => '47.1', 301 => '47.1', 310 => '47.1', 311 => '47.1' },
	'dynamicrange' => { 127 => 0x1400 },
	'dynamicrangeboost' => { 340 => 0xee },
	'dynamicrangeexpansion' => { 375 => 0x69, 407 => 0x100e },
	'dynamicrangemax' => { 108 => 0x7c },
	'dynamicrangemin' => { 108 => 0x7a },
	'dynamicrangeoptimizer' => { 184 => 0x15, 440 => [0xb025,0xb04f], 449 => 0x1144, 450 => [0x1144,0x324], 451 => [0x1120,0x300], 452 => [0x119c,0x37c], 453 => [0x1178,0x328], 454 => [0x1030,0x50], 455 => [0x228,0x50], 456 => [0x228,0x50], 457 => [0x21b,0x4e] },
	'dynamicrangeoptimizerbracket' => { 438 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 427 => 0x19, 428 => 0x17, 429 => 0xd, 438 => 0x79, 445 => 0x5 },
	'dynamicrangeoptimizermode' => { 187 => 0x15, 427 => 0x18, 428 => 0x16, 438 => [0x77,0x15] },
	'dynamicrangeoptimizersetting' => { 184 => 0x27, 429 => 0xc, 445 => 0x4 },
	'dynamicrangesetting' => { 127 => 0x1402 },
	'e-dialinprogram' => { 356 => '1.3' },
	'earliestageorloweststage' => { 118 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 118 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 118 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 118 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 118 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'earthpos' => { 479 => 'EarthPos' },
	'earthposaltitude' => { 479 => [\'EarthPos','EarthPosAltitude'] },
	'earthposlatitude' => { 479 => [\'EarthPos','EarthPosLatitude'] },
	'earthposlongitude' => { 479 => [\'EarthPos','EarthPosLongitude'] },
	'earthposrotationw' => { 479 => [\'EarthPos','EarthPosRotationW'] },
	'earthposrotationx' => { 479 => [\'EarthPos','EarthPosRotationX'] },
	'earthposrotationy' => { 479 => [\'EarthPos','EarthPosRotationY'] },
	'earthposrotationz' => { 479 => [\'EarthPos','EarthPosRotationZ'] },
	'earthpostimestamp' => { 479 => [\'EarthPos','EarthPosTimestamp'] },
	'easyexposurecomp' => { 312 => '6.1' },
	'easyexposurecompensation' => { 297 => '6.4', 298 => '6.5', 300 => '6.3', 301 => '6.3', 305 => '5.1', 306 => '4.4', 307 => '5.2', 310 => '6.3', 311 => '6.3', 313 => 0x1d, 314 => 0x1d, 315 => 0x1d },
	'easymode' => { 34 => 0xb },
	'edgemapslope' => { 138 => 0x930 },
	'edgemapx1' => { 138 => 0x931 },
	'edgemapx2' => { 138 => 0x932 },
	'edgemapx3' => { 138 => 0x934 },
	'edgemapx4' => { 138 => 0x935 },
	'edgenoisereduction' => { 291 => 0x4, 476 => 0x8028 },
	'edit1' => { 400 => "\xa9ed1" },
	'edit2' => { 400 => "\xa9ed2" },
	'edit3' => { 400 => "\xa9ed3" },
	'edit4' => { 400 => "\xa9ed4" },
	'edit5' => { 400 => "\xa9ed5" },
	'edit6' => { 400 => "\xa9ed6" },
	'edit7' => { 400 => "\xa9ed7" },
	'edit8' => { 400 => "\xa9ed8" },
	'edit9' => { 400 => "\xa9ed9" },
	'edition' => { 519 => 'edition' },
	'editorialupdate' => { 131 => 0x8 },
	'editstatus' => { 131 => 0x7, 387 => 'EditStatus', 495 => 'EditStatus' },
	'editversionname' => { 290 => 0x3d136244 },
	'effectivelv' => { 375 => 0x2d },
	'effectivemaxaperture' => { 227 => 0x12, 228 => 0x13, 232 => 0x14 },
	'eissn' => { 519 => 'eIssn' },
	'electricalblackcolumns' => { 138 => 0x1810 },
	'electronicfront-curtainshutter' => { 300 => '5.2', 301 => '5.2', 310 => '5.3', 311 => '5.2' },
	'electronicfrontcurtainshutter' => { 440 => 0x201a },
	'elevation' => { 165 => 'Elevation' },
	'email' => { 157 => 'EMail' },
	'embargodate' => { 522 => 'embargoDate' },
	'embdencrightsexpr' => { 514 => 'EmbdEncRightsExpr' },
	'embeddedencodedrightsexpr' => { 514 => [\'EmbdEncRightsExpr','EmbdEncRightsExprEncRightsExpr'] },
	'embeddedencodedrightsexprlangid' => { 514 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprLangId'] },
	'embeddedencodedrightsexprtype' => { 514 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprEncType'] },
	'embeddedxmpdigest' => { 517 => 'EmbeddedXMPDigest' },
	'emissivity' => { 121 => 0x3 },
	'emptyslotrelease' => { 239 => 0x723, 240 => 0x625, 241 => 0x655, 242 => 0x6bd },
	'enablechromanoisereduction' => { 138 => 0xe6e },
	'enablesharpening' => { 138 => 0x92e },
	'encodedby' => { 179 => 'WM/EncodedBy', 392 => "\xa9enc" },
	'encodedwith' => { 394 => 'Encoded_With' },
	'encoder' => { 392 => "\xa9too", 400 => "\xa9too" },
	'encoderid' => { 400 => "\xa9enc" },
	'encodingtime' => { 179 => 'WM/EncodingTime' },
	'encryptionkey' => { 414 => 0xa020 },
	'endingpage' => { 519 => 'endingPage' },
	'enduser' => { 327 => 'EndUser' },
	'enduserid' => { 327 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 327 => [\'EndUser','EndUserEndUserName'] },
	'energysavingmode' => { 239 => 0x746, 240 => 0x648, 241 => 0x678, 242 => 0x6e0 },
	'engineer' => { 529 => 'engineer' },
	'enhancedarktones' => { 283 => 0x8 },
	'enhancedenoisealreadyapplied' => { 497 => 'EnhanceDenoiseAlreadyApplied' },
	'enhancedenoiselumaamount' => { 497 => 'EnhanceDenoiseLumaAmount' },
	'enhancedenoiseversion' => { 497 => 'EnhanceDenoiseVersion' },
	'enhancedetailsalreadyapplied' => { 497 => 'EnhanceDetailsAlreadyApplied' },
	'enhancedetailsversion' => { 497 => 'EnhanceDetailsVersion' },
	'enhancement' => { 112 => 0x16, 113 => 0x3016 },
	'enhanceparams' => { 119 => 0xc7ee },
	'enhancer' => { 321 => 0x300 },
	'enhancervalues' => { 321 => 0x301 },
	'enhancesuperresolutionalreadyapplied' => { 497 => 'EnhanceSuperResolutionAlreadyApplied' },
	'enhancesuperresolutionscale' => { 497 => 'EnhanceSuperResolutionScale' },
	'enhancesuperresolutionversion' => { 497 => 'EnhanceSuperResolutionVersion' },
	'envelopenumber' => { 132 => 0x28 },
	'envelopepriority' => { 132 => 0x3c },
	'enveloperecordversion' => { 132 => 0x0 },
	'episode' => { 514 => 'Episode' },
	'episodeglobaluniqueid' => { 392 => 'egid' },
	'episodeidentifier' => { 514 => [\'Episode','EpisodeIdentifier'] },
	'episodename' => { 514 => [\'Episode','EpisodeName'] },
	'episodenumber' => { 514 => [\'Episode','EpisodeNumber'] },
	'epsonimageheight' => { 322 => 0x20c },
	'epsonimagewidth' => { 322 => 0x20b },
	'epsonsoftware' => { 322 => 0x20d },
	'equipmentinstitution' => { 478 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 478 => 'EquipmentManufacturer' },
	'equipmentversion' => { 318 => 0x0 },
	'ettlii' => { 84 => 0x304, 85 => 0xd, 86 => 0xe, 87 => 0x7, 88 => 0x7, 89 => 0xe },
	'event' => { 481 => 'Event', 493 => 'Event', 514 => 'Event', 519 => 'event' },
	'eventalias' => { 518 => 'eventAlias' },
	'eventdate' => { 118 => [\'Event','EventEventDate'] },
	'eventday' => { 118 => [\'Event','EventDay'] },
	'eventearliestdate' => { 118 => [\'Event','EventEarliestDate'] },
	'eventend' => { 518 => 'eventEnd' },
	'eventenddayofyear' => { 118 => [\'Event','EventEndDayOfYear'] },
	'eventfieldnotes' => { 118 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 118 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 118 => [\'Event','EventHabitat'] },
	'eventid' => { 118 => [\'Event','EventEventID'], 514 => 'EventId' },
	'eventlatestdate' => { 118 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 118 => [\'Event','EventMonth'] },
	'eventnumber' => { 401 => 0x9, 402 => 0x37, 403 => 0x3a },
	'eventparenteventid' => { 118 => [\'Event','EventParentEventID'] },
	'eventremarks' => { 118 => [\'Event','EventEventRemarks'] },
	'eventsamplesizeunit' => { 118 => [\'Event','EventSampleSizeUnit'] },
	'eventsamplesizevalue' => { 118 => [\'Event','EventSampleSizeValue'] },
	'eventsamplingeffort' => { 118 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 118 => [\'Event','EventSamplingProtocol'] },
	'eventstart' => { 518 => 'eventStart' },
	'eventstartdayofyear' => { 118 => [\'Event','EventStartDayOfYear'] },
	'eventsubtype' => { 518 => 'eventSubtype' },
	'eventtime' => { 118 => [\'Event','EventEventTime'] },
	'eventtype' => { 518 => 'eventType' },
	'eventverbatimeventdate' => { 118 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 118 => [\'Event','EventYear'] },
	'evfgrid' => { 313 => 0x165, 314 => 0x165, 315 => 0x17d },
	'evfimageframe' => { 313 => 0x164, 314 => 0x164, 315 => 0x17c },
	'evfreleaseindicator' => { 313 => 0x24f, 314 => 0x24f, 315 => 0x267 },
	'evfwarmdisplaybrightness' => { 313 => 0x24d, 314 => 0x24d, 315 => 0x265 },
	'evfwarmdisplaymode' => { 313 => 0x24b, 314 => 0x24b, 315 => 0x263 },
	'evsteps' => { 356 => '1.2', 358 => 0x0 },
	'evstepsize' => { 302 => '5.1', 303 => '6.1', 304 => '6.1', 308 => '0.7' },
	'exclusivecoverage' => { 490 => 'ExclusiveCoverage' },
	'exclusivityenddate' => { 522 => 'exclusivityEndDate' },
	'excursiontolerance' => { 133 => 0x82 },
	'executiveproducer' => { 392 => "\xa9xpd" },
	'exif' => { 120 => 'EXIF' },
	'exifbyteorder' => { 120 => 'ExifByteOrder' },
	'exifcamerainfo' => { 131 => 0xe8 },
	'exifimageheight' => { 119 => 0xa003, 506 => 'PixelYDimension' },
	'exifimagewidth' => { 119 => 0xa002, 506 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 120 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 119 => 0x9000, 506 => 'ExifVersion' },
	'exitpupilposition' => { 227 => 0x4, 228 => 0x4, 232 => 0x4 },
	'expirationdate' => { 131 => 0x25, 522 => 'expirationDate' },
	'expirationtime' => { 131 => 0x26 },
	'exposure' => { 119 => 0xfe51, 500 => 'Exposure', 502 => 'Exposure' },
	'exposure2012' => { 500 => 'Exposure2012', 502 => 'Exposure2012' },
	'exposureadj' => { 288 => 0x0 },
	'exposureadj2' => { 288 => 0x12 },
	'exposureadjust' => { 417 => 0xc },
	'exposurebracketingindicatorlast' => { 184 => 0x52 },
	'exposurebracketshotnumber' => { 187 => 0x2d, 438 => 0x2f },
	'exposurebracketstepsize' => { 356 => 0x8 },
	'exposurebracketvalue' => { 234 => 0x19 },
	'exposurecompautocancel' => { 84 => 0x113 },
	'exposurecompensation' => { 77 => 0x6, 93 => 0x0, 119 => 0x9204, 140 => 0x24, 156 => 'ExposureComp', 176 => 'ExposureCompensation', 181 => 0xd, 182 => 0x53, 183 => 0x1e, 187 => 0x49c0, 322 => 0x1006, 375 => 0x16, 384 => 0x402, 414 => 0xa013, 417 => [0xc,0x35,0x4d], 449 => 0x114c, 450 => 0x114c, 451 => 0x1128, 453 => 0x1180, 454 => 0x1038, 455 => 0x230, 456 => 0x230, 457 => 0x223, 506 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 445 => [0x24,0x26,0x2a] },
	'exposurecompensationbutton' => { 242 => 0x794 },
	'exposurecompensationmode' => { 184 => 0x47, 187 => 0x2a },
	'exposurecompensationset' => { 427 => 0x3, 428 => 0x3, 429 => 0x3, 445 => 0x1e },
	'exposurecompensationsetting' => { 184 => 0x1 },
	'exposurecompstepsize' => { 297 => '6.3', 298 => '7.3', 300 => '7.3', 301 => '7.3', 306 => '4.3', 310 => '7.3', 311 => '7.3' },
	'exposurecontrolstep' => { 305 => '6.1', 307 => '6.1' },
	'exposurecontrolstepsize' => { 297 => '6.2', 298 => '7.1', 300 => '7.1', 301 => '7.1', 306 => '4.2', 310 => '7.1', 311 => '7.1', 312 => '7.1', 313 => 0x1b, 314 => 0x1b, 315 => 0x1b },
	'exposurecount' => { 127 => 0x1032 },
	'exposuredelay' => { 242 => 0x800 },
	'exposuredelaymode' => { 297 => '10.1', 298 => '11.1', 300 => '11.1', 301 => '11.1', 302 => '9.1', 303 => '10.1', 304 => '10.1', 306 => '10.4', 307 => '10.1', 308 => '6.4', 310 => '11.1', 311 => '11.1', 312 => '11.2' },
	'exposuredifference' => { 234 => 0xe },
	'exposuregaincustom' => { 138 => 0x89c },
	'exposuregaindaylight' => { 138 => 0x898 },
	'exposuregainflash' => { 138 => 0x89b },
	'exposuregainfluorescent' => { 138 => 0x89a },
	'exposuregaintungsten' => { 138 => 0x899 },
	'exposureindex' => { 119 => 0xa215, 506 => 'ExposureIndex' },
	'exposureindicator' => { 184 => 0x50 },
	'exposurelevelincrements' => { 82 => 0x6, 83 => 0x6, 84 => 0x101, 85 => 0x5, 86 => 0x6, 87 => 0x5, 88 => 0x5, 89 => 0x6, 90 => 0x4, 427 => 0x58, 428 => 0x58 },
	'exposurelockused' => { 488 => 'ExposureLockUsed' },
	'exposuremode' => { 119 => 0xa402, 156 => 'ExposureMode', 181 => 0x1, 182 => 0xa, 183 => 0x0, 184 => 0x0, 187 => 0x34, 317 => 0x200, 337 => 0x40d, 417 => 0x8, 440 => 0xb041, 506 => 'ExposureMode' },
	'exposuremodeinmanual' => { 84 => 0x10b },
	'exposureprogram' => { 119 => 0x8822, 407 => 0x1001, 420 => [0x17e,0x43], 427 => 0x3c, 428 => 0x3c, 429 => 0x5, 433 => 0x14, 438 => 0x3f, 445 => 0x2, 449 => 0x1175, 450 => 0x1179, 451 => 0x1155, 452 => 0x11d1, 453 => 0x11ad, 454 => 0x1065, 455 => 0x25d, 456 => 0x25d, 457 => 0x24c, 468 => 0xb, 469 => 0xc, 470 => 0xb, 472 => 0x48, 506 => 'ExposureProgram' },
	'exposureshift' => { 317 => 0x203 },
	'exposurestandardadjustment' => { 440 => 0x202d },
	'exposuretime' => { 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x4, 27 => 0x4, 28 => 0x4, 29 => 0x4, 30 => 0x6, 31 => 0x7, 77 => 0x16, 119 => 0x829a, 137 => 0xfd05, 140 => 0x20, 142 => 0xfa24, 144 => 0xf104, 147 => 0x12, 149 => 0x38, 151 => 0x14, 152 => 0x10, 154 => 0x10, 156 => 'ExposureTime', 181 => 0x9, 182 => 0x35, 183 => 0x48, 184 => 0x8, 187 => 0x49b8, 375 => 0x12, 414 => 0xa018, 417 => [0x32,0x4a], 427 => 0x0, 428 => 0x0, 445 => [0x21,0x23,0x27], 472 => 0x10, 506 => 'ExposureTime' },
	'exposuretime2' => { 417 => [0x33,0x4b] },
	'exposuretuning' => { 234 => 0x1c },
	'exposurevalue' => { 138 => 0x3 },
	'exposurewarning' => { 127 => 0x1302 },
	'exrauto' => { 127 => 0x1033 },
	'exrmode' => { 127 => 0x1034 },
	'extdescraccessibility' => { 513 => 'ExtDescrAccessibility' },
	'extendedmenubanks' => { 239 => 0x120, 240 => 0x114, 241 => 0x124, 242 => 0x124 },
	'extendedshutterspeeds' => { 313 => 0x102, 314 => 0x102, 315 => 0x118 },
	'extendedwbdetect' => { 317 => 0x902 },
	'extender' => { 318 => 0x301 },
	'extenderfirmwareversion' => { 318 => 0x304 },
	'extendermagnification' => { 158 => 'Magnification' },
	'extendermake' => { 158 => 'Make' },
	'extendermodel' => { 158 => 'Model', 318 => 0x303 },
	'extenderserialnumber' => { 158 => 'SerialNumber', 318 => 0x302 },
	'extenderstatus' => { 373 => 0x3 },
	'externalflash' => { 320 => 0x1201 },
	'externalflashae1' => { 322 => 0x101f },
	'externalflashae1_0' => { 322 => 0x101b },
	'externalflashae2' => { 322 => 0x1020 },
	'externalflashae2_0' => { 322 => 0x101c },
	'externalflashbounce' => { 320 => 0x1204, 322 => 0x1026, 363 => 0x1a },
	'externalflashcompensation' => { 214 => 0x1b },
	'externalflashexposurecomp' => { 234 => 0x17, 363 => 0x19 },
	'externalflashfirmware' => { 212 => 0x6, 213 => 0x6, 214 => 0x6, 215 => 0x6, 216 => 0x6, 217 => 0x6 },
	'externalflashflags' => { 212 => 0x8, 213 => 0x8, 214 => 0x8, 215 => 0x8, 217 => 0x8 },
	'externalflashguidenumber' => { 320 => 0x1203, 363 => '24.1' },
	'externalflashgvalue' => { 322 => 0x1025 },
	'externalflashmode' => { 322 => 0x1028, 363 => 0x2 },
	'externalflashreadystate' => { 216 => '9.1' },
	'externalflashstatus' => { 216 => '8.2' },
	'externalflashzoom' => { 320 => 0x1205, 322 => 0x1027 },
	'externalflashzoomoverride' => { 216 => '8.1' },
	'externalmetadatalink' => { 514 => 'ExternalMetadataLink' },
	'externalsensorbrightnessvalue' => { 335 => 0x311, 338 => 0x311, 339 => 0x311, 342 => 0x3408 },
	'extrainfoversion' => { 431 => 0x1a },
	'eyestartaf' => { 184 => 0x40 },
	'fac100per' => { 138 => 0xe94 },
	'fac170per' => { 138 => 0xe93 },
	'fac18per' => { 138 => 0xe92 },
	'face10position' => { 110 => 0x3f4, 111 => 0x1ec, 210 => 0x28, 360 => 0x12 },
	'face10size' => { 361 => 0x12 },
	'face11position' => { 210 => 0x2c, 360 => 0x14 },
	'face11size' => { 361 => 0x14 },
	'face12position' => { 210 => 0x30, 360 => 0x16 },
	'face12size' => { 361 => 0x16 },
	'face13position' => { 360 => 0x18 },
	'face13size' => { 361 => 0x18 },
	'face14position' => { 360 => 0x1a },
	'face14size' => { 361 => 0x1a },
	'face15position' => { 360 => 0x1c },
	'face15size' => { 361 => 0x1c },
	'face16position' => { 360 => 0x1e },
	'face16size' => { 361 => 0x1e },
	'face17position' => { 360 => 0x20 },
	'face17size' => { 361 => 0x20 },
	'face18position' => { 360 => 0x22 },
	'face18size' => { 361 => 0x22 },
	'face19position' => { 360 => 0x24 },
	'face19size' => { 361 => 0x24 },
	'face1position' => { 54 => 0x8, 110 => 0xd, 111 => 0x18, 210 => 0x4, 332 => 0x1, 360 => 0x0, 404 => 0xbc, 434 => 0x1, 435 => 0x0, 436 => 0x0, 437 => 0x5b },
	'face1size' => { 361 => 0x0 },
	'face20position' => { 360 => 0x26 },
	'face20size' => { 361 => 0x26 },
	'face21position' => { 360 => 0x28 },
	'face21size' => { 361 => 0x28 },
	'face22position' => { 360 => 0x2a },
	'face22size' => { 361 => 0x2a },
	'face23position' => { 360 => 0x2c },
	'face23size' => { 361 => 0x2c },
	'face24position' => { 360 => 0x2e },
	'face24size' => { 361 => 0x2e },
	'face25position' => { 360 => 0x30 },
	'face25size' => { 361 => 0x30 },
	'face26position' => { 360 => 0x32 },
	'face26size' => { 361 => 0x32 },
	'face27position' => { 360 => 0x34 },
	'face27size' => { 361 => 0x34 },
	'face28position' => { 360 => 0x36 },
	'face28size' => { 361 => 0x36 },
	'face29position' => { 360 => 0x38 },
	'face29size' => { 361 => 0x38 },
	'face2position' => { 54 => 0xa, 110 => 0x7c, 111 => 0x4c, 210 => 0x8, 332 => 0x5, 360 => 0x2, 404 => 0xc8, 434 => 0x6, 435 => 0x20, 436 => 0x25, 437 => 0x65 },
	'face2size' => { 361 => 0x2 },
	'face30position' => { 360 => 0x3a },
	'face30size' => { 361 => 0x3a },
	'face31position' => { 360 => 0x3c },
	'face31size' => { 361 => 0x3c },
	'face32position' => { 360 => 0x3e },
	'face32size' => { 361 => 0x3e },
	'face3position' => { 54 => 0xc, 110 => 0xeb, 111 => 0x80, 210 => 0xc, 332 => 0x9, 360 => 0x4, 404 => 0xd4, 434 => 0xb, 435 => 0x40, 436 => 0x4a, 437 => 0x6f },
	'face3size' => { 361 => 0x4 },
	'face4position' => { 54 => 0xe, 110 => 0x15a, 111 => 0xb4, 210 => 0x10, 332 => 0xd, 360 => 0x6, 404 => 0xe0, 434 => 0x10, 435 => 0x60, 436 => 0x6f, 437 => 0x79 },
	'face4size' => { 361 => 0x6 },
	'face5position' => { 54 => 0x10, 110 => 0x1c9, 111 => 0xe8, 210 => 0x14, 332 => 0x11, 360 => 0x8, 404 => 0xec, 434 => 0x15, 435 => 0x80, 436 => 0x94 },
	'face5size' => { 361 => 0x8 },
	'face6position' => { 54 => 0x12, 110 => 0x238, 111 => 0x11c, 210 => 0x18, 360 => 0xa, 404 => 0xf8, 434 => 0x1a, 435 => 0xa0, 436 => 0xb9 },
	'face6size' => { 361 => 0xa },
	'face7position' => { 54 => 0x14, 110 => 0x2a7, 111 => 0x150, 210 => 0x1c, 360 => 0xc, 404 => 0x104, 434 => 0x1f, 435 => 0xc0, 436 => 0xde },
	'face7size' => { 361 => 0xc },
	'face8position' => { 54 => 0x16, 110 => 0x316, 111 => 0x184, 210 => 0x20, 360 => 0xe, 404 => 0x110, 434 => 0x24, 435 => 0xe0, 436 => 0x103 },
	'face8size' => { 361 => 0xe },
	'face9position' => { 54 => 0x18, 110 => 0x385, 111 => 0x1b8, 210 => 0x24, 360 => 0x10 },
	'face9size' => { 361 => 0x10 },
	'facebalanceorigi' => { 494 => 'FaceBalanceOrigI' },
	'facebalanceorigq' => { 494 => 'FaceBalanceOrigQ' },
	'facebalancestrength' => { 494 => 'FaceBalanceStrength' },
	'facebalancewarmth' => { 494 => 'FaceBalanceWarmth' },
	'facedetect' => { 375 => 0x76, 414 => 0x100 },
	'facedetectarea' => { 321 => 0x1201 },
	'facedetectframecrop' => { 321 => 0x1207 },
	'facedetectframesize' => { 54 => 0x3, 110 => 0x1, 111 => 0x4, 210 => 0x1, 321 => 0x1203, 375 => 0x77, 404 => 0xb6 },
	'facedetection' => { 429 => 0x30, 445 => 0x19 },
	'faceelementpositions' => { 127 => 0x4203 },
	'faceelementselected' => { 127 => 0x4005 },
	'faceelementtypes' => { 127 => 0x4201 },
	'faceid' => { 496 => 'FaceID' },
	'faceinfounknown' => { 113 => 0x2089 },
	'facename' => { 414 => 0x123 },
	'faceorientation' => { 111 => 0x8 },
	'faceposition' => { 359 => 0x2, 415 => 0x4 },
	'facepositions' => { 127 => 0x4103 },
	'facerecognition' => { 414 => 0x120 },
	'facesdetected' => { 54 => 0x2, 55 => 0x2, 56 => 0x3, 110 => 0x0, 111 => 0x2, 113 => 0x211c, 127 => 0x4100, 210 => 0x3, 321 => 0x1200, 340 => 0x3f, 359 => 0x0, 404 => 0xb5, 415 => 0x0, 434 => 0x0, 437 => 0x3, 448 => 0x30 },
	'facesrecognized' => { 333 => 0x0 },
	'facewidth' => { 55 => 0x1 },
	'fade' => { 440 => 0x2034 },
	'faithfuloutputhighlightpoint' => { 109 => 0x38 },
	'faithfuloutputshadowpoint' => { 109 => 0x39 },
	'faithfulrawcolortone' => { 109 => 0x31 },
	'faithfulrawcontrast' => { 109 => 0x33 },
	'faithfulrawhighlight' => { 109 => 0x79 },
	'faithfulrawhighlightpoint' => { 109 => 0x36 },
	'faithfulrawlinear' => { 109 => 0x34 },
	'faithfulrawsaturation' => { 109 => 0x32 },
	'faithfulrawshadow' => { 109 => 0x82 },
	'faithfulrawshadowpoint' => { 109 => 0x37 },
	'faithfulrawsharpness' => { 109 => 0x35 },
	'faithfulunsharpmaskfineness' => { 109 => 0xac },
	'faithfulunsharpmaskstrength' => { 109 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 109 => 0xae },
	'far' => { 485 => 'Far' },
	'fastresetlinetime' => { 138 => 0x1860 },
	'feedidentifier' => { 514 => 'FeedIdentifier' },
	'femicroadjustment' => { 84 => 0x111 },
	'ffid' => { 504 => 'ffid' },
	'field' => { 518 => 'field' },
	'fieldcount' => { 322 => 0x103f },
	'fieldofview' => { 400 => "FOV\x00" },
	'fifoenonepixeldelay' => { 138 => 0x1901 },
	'filecreatedate' => { 120 => 'FileCreateDate' },
	'filedatarate' => { 529 => 'fileDataRate' },
	'fileformat' => { 95 => 0x0, 132 => 0x14, 417 => [0x22,0x26], 440 => 0xb000 },
	'filegroupid' => { 120 => 'FileGroupID' },
	'fileindex' => { 7 => 0x143, 9 => 0x2d0, 11 => 0x172, 13 => 0x22c, 14 => 0x133, 15 => 0x13f, 16 => 0x1d3, 17 => 0x19b, 18 => 0x1e4, 19 => 0xd0, 20 => 0x1bb, 21 => 0x28c, 22 => 0x1db, 23 => 0x1d9, 24 => [0x270,0x274], 25 => 0x2aa, 26 => 0x2b3, 28 => 0x1eb, 29 => 0x4ae, 341 => 0x0 },
	'fileindex2' => { 21 => 0x290 },
	'filemodifydate' => { 120 => 'FileModifyDate' },
	'filename' => { 120 => 'FileName' },
	'filenameasdelivered' => { 327 => 'FileNameAsDelivered' },
	'filenumber' => { 57 => 0x1, 64 => 0x8, 97 => 0x1817, 114 => 'Canon-FileNumber', 211 => 0x4, 403 => 0x10 },
	'filenumbermemory' => { 181 => 0x1a },
	'filenumbersequence' => { 297 => '12.2', 302 => '3.1', 303 => '4.1', 304 => '4.1', 306 => '11.1', 307 => '4.3', 312 => '5.2', 313 => 0x48, 314 => 0x48, 315 => 0x48 },
	'filepermissions' => { 120 => 'FilePermissions' },
	'filesource' => { 119 => 0xa300, 127 => 0x8000, 506 => 'FileSource' },
	'fileuserid' => { 120 => 'FileUserID' },
	'fileversion' => { 132 => 0x16 },
	'fillflashautoreduction' => { 82 => 0xe, 83 => 0xe, 90 => 0xa },
	'filllight' => { 500 => 'FillLight', 502 => 'FillLight' },
	'fillorder' => { 119 => 0x10a },
	'filmgraineffect' => { 317 => 0x538 },
	'filmmode' => { 127 => 0x1401, 337 => 0x412, 340 => 0x42 },
	'filmtype' => { 257 => 0x2 },
	'filtereffect' => { 57 => 0xe, 249 => 0x37, 250 => 0x3f, 251 => 0x47, 340 => 0xa1 },
	'filtereffectauto' => { 71 => 0xa0 },
	'filtereffectfaithful' => { 70 => 0x70, 71 => 0x70 },
	'filtereffectlandscape' => { 70 => 0x40, 71 => 0x40 },
	'filtereffectmonochrome' => { 19 => 0xff, 70 => 0x88, 71 => 0x88 },
	'filtereffectneutral' => { 70 => 0x58, 71 => 0x58 },
	'filtereffectportrait' => { 70 => 0x28, 71 => 0x28 },
	'filtereffectstandard' => { 70 => 0x10, 71 => 0x10 },
	'filtereffectuserdef1' => { 70 => 0xa0, 71 => 0xb8 },
	'filtereffectuserdef2' => { 70 => 0xb8, 71 => 0xd0 },
	'filtereffectuserdef3' => { 70 => 0xd0, 71 => 0xe8 },
	'finderdisplayduringexposure' => { 83 => 0x1 },
	'finesharpness' => { 375 => 0x70 },
	'finetuneoptcenterweighted' => { 297 => '7.2', 298 => '9.1', 300 => '9.1', 301 => '9.1', 305 => '8.1', 310 => '9.1', 311 => '9.1', 312 => '9.1', 313 => 0x23, 314 => 0x23, 315 => 0x23 },
	'finetuneopthighlightweighted' => { 300 => '46.1', 301 => '46.1', 310 => '46.1', 311 => '46.1', 313 => 0x27, 314 => 0x27, 315 => 0x27 },
	'finetuneoptmatrixmetering' => { 297 => '8.1', 298 => '8.2', 300 => '8.2', 301 => '8.2', 305 => '7.2', 306 => '6.1', 310 => '8.2', 311 => '8.2', 312 => '8.2', 313 => 0x21, 314 => 0x21, 315 => 0x21 },
	'finetuneoptspotmetering' => { 297 => '8.2', 298 => '9.2', 300 => '9.2', 301 => '9.2', 305 => '8.2', 306 => '6.2', 310 => '9.2', 311 => '9.2', 312 => '9.2', 313 => 0x25, 314 => 0x25, 315 => 0x25 },
	'finishexposure' => { 138 => 0xdbd },
	'finishfiletype' => { 138 => 0xdb8 },
	'finishlook' => { 138 => 0xdbc },
	'finishnoise' => { 138 => 0xdba },
	'finishresolution' => { 138 => 0xdb9 },
	'finishsharpening' => { 138 => 0xdbb },
	'firmware' => { 322 => 0x405, 417 => [0x8c,0x17,0x3b], 497 => 'Firmware' },
	'firmware2' => { 417 => 0x57 },
	'firmwaredate' => { 112 => 0x15, 113 => 0x2001, 401 => 0x4, 403 => 0x30 },
	'firmwareid' => { 188 => 0x0 },
	'firmwarename' => { 414 => 0xa001 },
	'firmwarerevision' => { 19 => 0xa4, 64 => 0x1e, 405 => 0x0 },
	'firmwarerevision2' => { 405 => 0xc },
	'firmwareversion' => { 7 => 0x10b, 11 => 0x136, 14 => 0xff, 15 => 0x107, 138 => [0x415,0xce5], 154 => 0x57, 156 => 'FirmwareVersion', 338 => 0x320, 340 => 0x2, 342 => 0x3109, 375 => 0x230, 400 => ['CNFV','FIRM'], 402 => 0x18, 403 => 0x2a, 407 => 0x2 },
	'firmwareversions' => { 384 => 0x301 },
	'firstphotodate' => { 488 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 327 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 131 => 0x16, 495 => 'FixtureIdentifier' },
	'flash' => { 114 => 'XMP-Flash', 119 => 0x9209, 152 => 0x22, 182 => 0x1f, 183 => 0x15, 403 => 0x5a, 506 => 'Flash' },
	'flashaction' => { 427 => 0x3e, 428 => 0x3e, 440 => 0x2017, 445 => [0x2a,0x2c,0x30] },
	'flashaction2' => { 427 => 0x4c, 428 => 0x4c, 445 => 0x77 },
	'flashactionexternal' => { 445 => [0x78,0x7c] },
	'flashactivity' => { 34 => 0x1c },
	'flashbatterylevel' => { 44 => 0x249 },
	'flashbias' => { 340 => 0x24 },
	'flashbits' => { 34 => 0x1d },
	'flashburstpriority' => { 313 => 0x111, 314 => 0x111, 315 => 0x129 },
	'flashbuttonfunction' => { 84 => 0x70e },
	'flashchargelevel' => { 322 => 0x1010 },
	'flashcolorfilter' => { 214 => 0x10, 215 => 0x10, 217 => 0x10 },
	'flashcommandermode' => { 212 => '9.1', 213 => '9.1', 214 => '9.1', 215 => '9.1', 217 => '9.1' },
	'flashcompensation' => { 138 => 0x3f3, 212 => 0xa, 213 => 0xa, 214 => 0xa, 215 => 0x27, 216 => 0xa, 217 => 0xa, 497 => 'FlashCompensation' },
	'flashcontrol' => { 427 => 0x23, 428 => 0x1f, 429 => 0x21 },
	'flashcontrolbuilt-in' => { 306 => '16.1', 307 => '23.1', 309 => '23.1', 310 => '24.1' },
	'flashcontrolmode' => { 212 => '9.2', 213 => '9.2', 214 => '9.2', 215 => '9.2', 217 => '9.2', 223 => 0x214, 238 => 0x148, 239 => 0x1b8, 240 => 0x1a8, 241 => 0x1bc, 242 => 0x1bc, 317 => 0x404 },
	'flashcurtain' => { 340 => 0x48 },
	'flashdefault' => { 184 => 0x42 },
	'flashdevice' => { 322 => 0x1005 },
	'flashdistance' => { 113 => 0x2034 },
	'flashenergy' => { 119 => 0xa20b, 506 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 234 => 0x18 },
	'flashexposurecomp' => { 77 => 0xf, 127 => 0x1011, 159 => 'ExposureComp', 181 => 0x23, 186 => 0x104, 187 => 0x49c1, 234 => 0x12, 317 => 0x401, 322 => 0x1023, 375 => 0x4d, 407 => 0x100b, 417 => [0x3a,0x56], 440 => 0x104 },
	'flashexposurecomp2' => { 278 => 0x4d2 },
	'flashexposurecomp3' => { 214 => 0x1d },
	'flashexposurecomp4' => { 214 => 0x27 },
	'flashexposurecomparea' => { 298 => '38.4', 300 => '38.4', 301 => '38.4', 310 => '38.4', 311 => '38.4', 313 => 0x59, 314 => 0x59, 315 => 0x59 },
	'flashexposurecompset' => { 184 => 0x10, 348 => 0xe, 427 => 0x14, 428 => 0x12, 429 => 0x23, 445 => 0x1f },
	'flashexposurecompset2' => { 445 => [0x26,0x2c] },
	'flashexposureindicator' => { 184 => 0x54 },
	'flashexposureindicatorlast' => { 184 => 0x56 },
	'flashexposureindicatornext' => { 184 => 0x55 },
	'flashexposurelock' => { 57 => 0x19 },
	'flashfired' => { 140 => 0x5d, 159 => 'Fired', 181 => 0x14, 277 => '590.3', 506 => [\'Flash','FlashFired'] },
	'flashfiring' => { 84 => 0x306, 85 => 0x6, 86 => 0x7, 89 => 0x7 },
	'flashfirmwareversion' => { 318 => 0x1002 },
	'flashfocallength' => { 212 => 0xb, 213 => 0xc, 214 => 0xc, 215 => 0xc, 216 => 0xc, 217 => 0x26 },
	'flashfunction' => { 187 => 0x31, 506 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 212 => 0xe, 213 => 0xf, 214 => 0xf, 215 => 0xf, 216 => 0xf, 217 => 0xf, 223 => 0x21a, 238 => 0x14e, 240 => 0x1ae, 241 => 0x1c2, 242 => 0x1c2 },
	'flashgroupacompensation' => { 212 => 0x11, 213 => 0x12, 214 => 0x13, 215 => 0x28, 216 => 0x28, 217 => 0x28 },
	'flashgroupacontrolmode' => { 212 => 0xf, 213 => '16.1', 214 => '17.1', 215 => '17.1', 216 => '17.1', 217 => '17.1' },
	'flashgroupaoutput' => { 212 => 0x11, 213 => 0x12, 214 => 0x13, 215 => 0x28, 216 => 0x28, 217 => 0x28 },
	'flashgroupbcompensation' => { 212 => 0x12, 213 => 0x13, 214 => 0x14, 215 => 0x29, 216 => 0x29, 217 => 0x29 },
	'flashgroupbcontrolmode' => { 212 => 0x10, 213 => '17.1', 214 => '18.1', 215 => '18.1', 216 => '18.1', 217 => '18.1' },
	'flashgroupboutput' => { 212 => 0x12, 213 => 0x13, 214 => 0x14, 215 => 0x29, 216 => 0x29, 217 => 0x29 },
	'flashgroupccompensation' => { 213 => 0x14, 214 => 0x15, 215 => 0x2a, 216 => 0x2a, 217 => 0x2a },
	'flashgroupccontrolmode' => { 213 => '17.2', 214 => '18.2', 215 => '18.2', 216 => '18.2', 217 => '18.2' },
	'flashgroupcoutput' => { 213 => 0x14, 214 => 0x15, 215 => 0x2a, 216 => 0x2a, 217 => 0x2a },
	'flashguidenumber' => { 77 => 0xd, 94 => 0x0, 159 => 'GuideNumber' },
	'flashilluminationpattern' => { 217 => 0x25 },
	'flashintensity' => { 112 => [0x19,0x5], 317 => 0x405 },
	'flashlevel' => { 299 => 0x9, 440 => 0xb048 },
	'flashmake' => { 159 => 'Make' },
	'flashmanufacturer' => { 178 => 'FlashManufacturer' },
	'flashmastercompensation' => { 223 => 0x22e, 238 => 0x162, 240 => 0x1aa, 241 => 0x1be, 242 => 0x1be },
	'flashmastercontrolmode' => { 223 => 0x22c, 238 => 0x160 },
	'flashmasteroutput' => { 223 => 0x232, 238 => 0x166 },
	'flashmetering' => { 181 => 0x3f, 184 => 0x1c },
	'flashmeteringmode' => { 7 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 17 => 0x15, 18 => 0x15, 20 => 0x15, 22 => 0x15, 28 => 0x15 },
	'flashmeteringsegments' => { 375 => 0x20a },
	'flashmode' => { 112 => 0x4, 138 => 0x3f2, 140 => 0x5c, 151 => 0x27, 159 => 'Mode', 181 => 0x2, 182 => 0x20, 183 => 0x16, 184 => 0xf, 234 => 0x87, 317 => 0x400, 322 => 0x1004, 375 => 0xc, 382 => 0x4, 406 => 0x20, 407 => 0x100a, 416 => 0x225, 427 => 0x13, 428 => 0x7f, 429 => 0x20, 445 => 0x10, 449 => 0x1138, 450 => 0x1138, 451 => 0x1114, 452 => 0x1190, 453 => 0x116c, 454 => 0x1024, 455 => 0x21c, 456 => 0x21c, 457 => 0x211, 506 => [\'Flash','FlashMode'] },
	'flashmodebutton' => { 242 => 0x80e },
	'flashmodebuttonplaybackmode' => { 242 => 0x818 },
	'flashmodel' => { 159 => 'Model', 178 => 'FlashModel', 318 => 0x1001 },
	'flashoptions' => { 356 => 0x2 },
	'flashoptions2' => { 356 => 0x10 },
	'flashoutput' => { 44 => 0x248, 77 => 0x21, 212 => 0xa, 213 => 0xa, 214 => 0xa, 215 => 0x27, 217 => 0x21, 223 => 0x21e, 238 => 0x152, 240 => 0x1b2, 241 => 0x1c6, 242 => 0x1c6 },
	'flashpixversion' => { 119 => 0xa000, 506 => 'FlashpixVersion' },
	'flashredeyemode' => { 506 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 223 => 0x228, 238 => 0x15c, 240 => 0x1bc, 317 => 0x403 },
	'flashreturn' => { 506 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 159 => 'SerialNumber', 318 => 0x1003 },
	'flashsetting' => { 234 => 0x8 },
	'flashshutterspeed' => { 297 => '20.2', 298 => '23.2', 300 => '23.2', 301 => '23.2', 306 => '15.2', 307 => '22.2', 308 => '7.2', 309 => '22.2', 310 => '23.2', 311 => '23.2', 312 => '23.1', 313 => 0x57, 314 => 0x57, 315 => 0x57 },
	'flashsource' => { 212 => 0x4, 213 => 0x4, 214 => 0x4, 215 => 0x4, 216 => 0x4, 217 => 0x4 },
	'flashstatus' => { 363 => 0x0, 445 => [0x82,0x86], 459 => 0x31, 460 => 0x39, 461 => 0x39 },
	'flashstatusbuilt-in' => { 429 => [0x87,0x287] },
	'flashstatusexternal' => { 429 => [0x88,0x288] },
	'flashsyncspeed' => { 297 => '20.1', 298 => '23.1', 300 => '23.1', 301 => '23.1', 306 => '15.1', 307 => '22.1', 309 => '22.1', 310 => '23.1', 311 => '23.1', 313 => 0x53, 314 => 0x53, 315 => 0x53 },
	'flashsyncspeedav' => { 82 => 0x3, 84 => 0x10f, 85 => 0x2, 86 => 0x3, 87 => 0x2, 88 => 0x2, 89 => 0x3, 90 => 0x6 },
	'flashthreshold' => { 94 => 0x1 },
	'flashtype' => { 159 => 'Type', 184 => 0x59, 234 => 0x9, 318 => 0x1000 },
	'flashwarning' => { 307 => '30.1', 308 => '7.1', 312 => '31.1', 340 => 0x62 },
	'flashwirelessoption' => { 223 => 0x234, 238 => 0x15a, 240 => 0x1c8 },
	'flexiblespotposition' => { 440 => 0x201d },
	'flickadvancedirection' => { 313 => 0x25f, 314 => 0x25f, 315 => 0x277 },
	'flickerreduce' => { 416 => 0x218 },
	'flickerreduction' => { 127 => 0x1446, 261 => 0x7 },
	'flickerreductionindicator' => { 256 => 0x532 },
	'flickerreductionshooting' => { 239 => 0x1b4, 240 => 0x1a4, 241 => 0x1b8, 242 => 0x1b8 },
	'flightpitchdegree' => { 116 => 'FlightPitchDegree' },
	'flightrolldegree' => { 116 => 'FlightRollDegree' },
	'flightxspeed' => { 116 => 'FlightXSpeed' },
	'flightyawdegree' => { 116 => 'FlightYawDegree' },
	'flightyspeed' => { 116 => 'FlightYSpeed' },
	'flightzspeed' => { 116 => 'FlightZSpeed' },
	'fliphorizontal' => { 290 => 0x76a43206 },
	'fnumber' => { 7 => 0x3, 9 => 0x3, 11 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x3, 27 => 0x3, 28 => 0x3, 29 => 0x3, 30 => 0x5, 31 => 0x6, 77 => 0x15, 119 => 0x829d, 137 => 0xfd04, 140 => 0x1e, 142 => 0xfa23, 144 => 0xf103, 147 => 0x13, 149 => 0x3c, 151 => 0x1c, 152 => 0x18, 154 => 0xc, 163 => 'FNumber', 181 => 0xa, 182 => 0x36, 183 => 0x47, 184 => 0x9, 187 => 0x49c7, 232 => 0x38, 339 => 0x35a, 375 => 0x13, 414 => 0xa019, 417 => [0x31,0x49], 427 => 0x1, 428 => 0x1, 445 => [0x20,0x22,0x26], 506 => 'FNumber' },
	'focaldistance' => { 486 => 'FocalDistance' },
	'focallength' => { 7 => 0x1d, 8 => 0xa, 9 => 0x23, 10 => 0x9, 11 => 0x1d, 12 => 0x9, 13 => 0x1e, 14 => 0x1d, 15 => 0x1d, 16 => 0x1e, 17 => 0x1e, 18 => 0x1e, 19 => 0x28, 20 => 0x1e, 21 => 0x23, 22 => 0x1e, 23 => 0x1e, 24 => 0x23, 25 => 0x23, 26 => 0x23, 27 => 0x23, 28 => 0x1e, 29 => 0x23, 59 => 0x1, 113 => 0x1d, 119 => 0x920a, 147 => 0x1d, 163 => 'FocalLength', 181 => 0x12, 227 => 0xa, 228 => 0xb, 232 => [0xc,0x3c], 334 => 0x1, 375 => 0x1d, 384 => 0x403, 407 => 0x1500, 426 => 0xe, 453 => 0x1278, 454 => 0x1134, 455 => 0x32c, 456 => 0x32c, 457 => 0x30a, 506 => 'FocalLength' },
	'focallength2' => { 445 => [0x23,0x25,0x29] },
	'focallengthin35mmformat' => { 119 => 0xa405, 414 => 0xa01a, 506 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 426 => 0x10 },
	'focalplaneafpointarea' => { 458 => 0x2 },
	'focalplaneafpointlocation1' => { 458 => 0x6 },
	'focalplaneafpointlocation10' => { 458 => 0x2a },
	'focalplaneafpointlocation11' => { 458 => 0x2e },
	'focalplaneafpointlocation12' => { 458 => 0x32 },
	'focalplaneafpointlocation13' => { 458 => 0x36 },
	'focalplaneafpointlocation14' => { 458 => 0x3a },
	'focalplaneafpointlocation15' => { 458 => 0x3e },
	'focalplaneafpointlocation2' => { 458 => 0xa },
	'focalplaneafpointlocation3' => { 458 => 0xe },
	'focalplaneafpointlocation4' => { 458 => 0x12 },
	'focalplaneafpointlocation5' => { 458 => 0x16 },
	'focalplaneafpointlocation6' => { 458 => 0x1a },
	'focalplaneafpointlocation7' => { 458 => 0x1e },
	'focalplaneafpointlocation8' => { 458 => 0x22 },
	'focalplaneafpointlocation9' => { 458 => 0x26 },
	'focalplaneafpointsused' => { 458 => 0x1 },
	'focalplanediagonal' => { 318 => 0x103, 322 => 0x205 },
	'focalplaneresolutionunit' => { 119 => 0xa210, 506 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 119 => 0xa20e, 506 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 59 => 0x2 },
	'focalplanexunknown' => { 59 => 0x2 },
	'focalplaneyresolution' => { 119 => 0xa20f, 506 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 59 => 0x3 },
	'focalplaneyunknown' => { 59 => 0x3 },
	'focalpointx' => { 486 => 'FocalPointX' },
	'focalpointy' => { 486 => 'FocalPointY' },
	'focaltype' => { 10 => 0x2d, 59 => 0x0 },
	'focalunits' => { 34 => 0x19 },
	'focus' => { 280 => 0x8 },
	'focusarea' => { 181 => 0x31 },
	'focusareaselection' => { 308 => '15.2' },
	'focusbracket' => { 340 => 0xbd },
	'focusbracketstepsize' => { 317 => 0x308 },
	'focuscontinuous' => { 34 => 0x20 },
	'focusdisplayaiservoandmf' => { 84 => 0x515 },
	'focusdistance' => { 163 => 'FocusDistance', 181 => 0x13, 187 => 0x49bb, 227 => 0x9, 228 => 0xa, 232 => [0xb,0x4e], 320 => 0x305, 334 => 0x0, 338 => 0x304, 339 => 0x304 },
	'focusdistancelower' => { 7 => 0x45, 9 => 0x8e, 11 => 0x45, 13 => 0x56, 14 => 0x45, 15 => 0x45, 16 => 0x52, 17 => 0x52, 18 => 0x56, 20 => 0x52, 21 => 0x8e, 22 => 0x59, 23 => 0x57, 24 => 0x8e, 25 => 0x94, 26 => 0x95, 27 => 0xa7, 28 => 0x56, 29 => 0xa7, 57 => 0x15, 77 => 0x14 },
	'focusdistancerange' => { 1 => 0xc },
	'focusdistancerangewidth' => { 232 => 0x4c },
	'focusdistanceupper' => { 7 => 0x43, 9 => 0x8c, 11 => 0x43, 13 => 0x54, 14 => 0x43, 15 => 0x43, 16 => 0x50, 17 => 0x50, 18 => 0x54, 20 => 0x50, 21 => 0x8c, 22 => 0x57, 23 => 0x55, 24 => 0x8c, 25 => 0x92, 26 => 0x93, 27 => 0xa5, 28 => 0x54, 29 => 0xa5, 57 => 0x14, 77 => 0x13 },
	'focusholdbutton' => { 184 => 0x44 },
	'focusinfoversion' => { 320 => 0x0 },
	'focusingscreen' => { 83 => 0x0, 84 => 0x80b, 89 => 0x0 },
	'focuslocation' => { 440 => 0x2027 },
	'focuslocked' => { 180 => 0x14 },
	'focusmode' => { 34 => 0x7, 112 => 0x3, 113 => [0x3003,0xd], 127 => 0x1021, 138 => 0x3f5, 140 => 0x38, 156 => 'FocusMode', 181 => 0x30, 183 => 0xe, 184 => 0xc, 234 => 0x7, 317 => 0x301, 322 => 0x100b, 340 => 0x7, 375 => 0xd, 382 => 0x3, 407 => 0x1006, 420 => [0xb,0x5], 426 => [0x15,0x1d], 427 => 0x4d, 428 => 0x4d, 440 => [0xb042,0xb04e,0x201b], 445 => 0x13, 466 => 0x16 },
	'focusmode2' => { 126 => '0.1', 356 => '3.1', 445 => [0x2c,0x2e,0x32] },
	'focusmodesetting' => { 299 => '10.1', 424 => 0x14, 425 => 0x15, 427 => 0x10, 428 => 0xf, 429 => 0x6 },
	'focusmodeswitch' => { 184 => 0x58, 427 => 0x2e },
	'focuspeakingdisplay' => { 313 => 0x235, 314 => 0x235, 315 => 0x24d },
	'focuspeakinghighlightcolor' => { 313 => 0x4b, 314 => 0x4b, 315 => 0x4b },
	'focuspeakinglevel' => { 313 => 0x49, 314 => 0x49, 315 => 0x49 },
	'focuspixel' => { 127 => 0x1023 },
	'focuspointlock' => { 313 => 0x1d3, 314 => 0x1d3, 315 => 0x1eb },
	'focuspointpersistence' => { 313 => 0x105, 314 => 0x105, 315 => 0x11b },
	'focuspointwrap' => { 297 => '2.2', 298 => '2.2', 300 => '2.1', 301 => '2.1', 305 => '1.1', 306 => '2.2', 307 => '1.1', 310 => '2.2', 311 => '2.1', 312 => '2.5', 313 => 0x16, 314 => 0x16, 315 => 0x16 },
	'focusposition' => { 1 => 0x2f, 227 => 0x8, 228 => 0x8, 375 => 0x10, 438 => 0x9bb },
	'focusposition2' => { 445 => [0x29,0x2b,0x2f], 466 => 0x2d, 469 => 0x20 },
	'focuspositionhorizontal' => { 193 => 0x2f, 194 => 0x43 },
	'focuspositionvertical' => { 193 => 0x31, 194 => 0x45 },
	'focusprocess' => { 317 => 0x302 },
	'focusrange' => { 34 => 0x12, 322 => 0x100a },
	'focusrangeindex' => { 366 => '3.1' },
	'focusresult' => { 194 => 0x4a },
	'focusringrotation' => { 84 => 0x713 },
	'focussetting' => { 417 => 0x6 },
	'focusshiftautoreset' => { 241 => 0x6da, 242 => 0x748 },
	'focusshiftexposurelock' => { 223 => 0x1b4, 238 => 0xe8, 239 => 0x100, 240 => 0xf4, 241 => 0x104, 242 => 0x104 },
	'focusshiftinterval' => { 223 => 0x1b0, 238 => 0xe4, 239 => 0xfc, 240 => 0xf0, 241 => 0x100, 242 => 0x100 },
	'focusshiftnumbershots' => { 223 => 0x1a8, 238 => 0xdc, 239 => 0xf4, 240 => 0xe8, 241 => 0xf8, 242 => 0xf8 },
	'focusshiftshooting' => { 259 => 0x20 },
	'focusshiftstepwidth' => { 223 => 0x1ac, 238 => 0xe0, 239 => 0xf8, 240 => 0xec, 241 => 0xfc, 242 => 0xfc },
	'focusstatus' => { 426 => 0x19, 427 => 0x53, 428 => 0x53 },
	'focusstepcount' => { 320 => 0x301, 322 => 0x100e },
	'focusstepinfinity' => { 320 => 0x303, 322 => 0x103b },
	'focusstepnear' => { 320 => 0x304, 322 => 0x103c },
	'focusstepsfrominfinity' => { 232 => 0x58 },
	'focustrackinglockon' => { 297 => ['1.5','4.1'], 298 => '1.4', 305 => '0.4', 306 => '3.1', 307 => '0.4', 310 => '1.4' },
	'focuswarning' => { 127 => 0x1301 },
	'foldername' => { 181 => 0x27 },
	'foldernumber' => { 427 => 0x9a, 429 => [0x402,0x114,0x316] },
	'fontcomposite' => { 534 => [\'Fonts','FontsComposite'] },
	'fontface' => { 534 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 534 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 534 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 534 => [\'Fonts','FontsFontName'] },
	'fonts' => { 534 => 'Fonts' },
	'fonttype' => { 534 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 534 => [\'Fonts','FontsVersionString'] },
	'for' => { 391 => 'For' },
	'forcewrite' => { 120 => 'ForceWrite' },
	'format' => { 400 => "\xa9fmt", 485 => 'Format', 503 => 'format', 527 => 'Format' },
	'forwardlock' => { 524 => 'forwardlock' },
	'forwardmatrix1' => { 119 => 0xc714 },
	'forwardmatrix2' => { 119 => 0xc715 },
	'forwardmatrix3' => { 119 => 0xcd34 },
	'fossilspecimen' => { 118 => 'FossilSpecimen' },
	'fossilspecimenmaterialsampleid' => { 118 => [\'FossilSpecimen','FossilSpecimenMaterialSampleID'] },
	'framecount' => { 67 => [0x2,0x4] },
	'frameheight' => { 127 => 0x3822 },
	'framenum' => { 386 => 0xd7 },
	'framenumber' => { 127 => 0x8003, 187 => 0x3c, 375 => 0x29 },
	'framerate' => { 67 => [0x1,0x6], 119 => 0xc764, 127 => 0x3820 },
	'framereadouttime' => { 394 => 'camera.framereadouttimeinmicroseconds' },
	'framewidth' => { 127 => 0x3821 },
	'framing' => { 518 => 'framing' },
	'freebytes' => { 97 => 0x1 },
	'freememorycardimages' => { 182 => [0x37,0x54], 183 => [0x2d,0x4a], 184 => 0x32 },
	'frontfacingcamera' => { 1 => 0x45 },
	'fujiflashmode' => { 127 => 0x1010 },
	'fujimodel' => { 127 => 0x1447 },
	'fujimodel2' => { 127 => 0x1448 },
	'fullhdhighspeedrec' => { 127 => 0x3824 },
	'fullimagesize' => { 440 => 0xb02b },
	'fullpanoheightpixels' => { 488 => 'FullPanoHeightPixels', 489 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 488 => 'FullPanoWidthPixels', 489 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 407 => 0x100d },
	'fullsizeimage' => { 162 => 'data' },
	'fullsizeimagename' => { 162 => '1Name' },
	'fullsizeimagetype' => { 162 => '0Type' },
	'func1button' => { 300 => '14.1', 301 => '14.1', 311 => '14.1', 313 => 0x63, 314 => 0x63, 315 => 0x63 },
	'func1buttonplaybackmode' => { 313 => 0x1a5, 314 => 0x1a5, 315 => 0x1bd },
	'func1buttonplusdials' => { 300 => '42.1', 301 => '42.1', 311 => '42.1' },
	'func2button' => { 300 => '80.1', 301 => '80.1', 311 => '80.1', 313 => 0x73, 314 => 0x73, 315 => 0x73 },
	'func2buttonplaybackmode' => { 313 => 0x1a7, 314 => 0x1a7, 315 => 0x1bf },
	'func2buttonplusdials' => { 300 => '81.1' },
	'func3button' => { 300 => '83.1', 314 => 0x119, 315 => 0x131 },
	'func3buttonplaybackmode' => { 314 => 0x1a9, 315 => 0x1c1 },
	'func4button' => { 314 => 0x175, 315 => 0x18d },
	'func4buttonplaybackmode' => { 314 => 0x1af, 315 => 0x1c7 },
	'funcbutton' => { 297 => ['14.1','15.1'], 298 => '14.1', 306 => '28.1', 307 => '13.1', 310 => '14.1', 312 => '14.1' },
	'funcbuttonplusdials' => { 297 => ['14.2','15.2'], 298 => '14.2', 306 => '31.1', 310 => '42.1' },
	'functionbutton' => { 304 => '13.1', 308 => '5.2' },
	'gainbase' => { 321 => 0x610 },
	'gaincontrol' => { 119 => 0xa407, 506 => 'GainControl' },
	'gainmapmax' => { 511 => 'GainMapMax' },
	'gainmapmin' => { 511 => 'GainMapMin' },
	'gamma' => { 119 => 0xa500, 138 => 0x8fe, 328 => 'gAMA', 345 => 0x11c, 507 => 'Gamma', 511 => 'Gamma' },
	'gammablackpoint' => { 105 => 0xc },
	'gammacolortone' => { 105 => 0x3 },
	'gammacompensatedvalue' => { 133 => 0x91 },
	'gammacontrast' => { 105 => 0x2 },
	'gammacurveoutputrange' => { 105 => 0xf },
	'gammahighlight' => { 105 => 0xa },
	'gammalinear' => { 103 => 0x20200 },
	'gammamidpoint' => { 105 => 0xe },
	'gammasaturation' => { 105 => 0x4 },
	'gammashadow' => { 105 => 0x9 },
	'gammasharpnessstrength' => { 105 => 0x8 },
	'gammaunsharpmaskfineness' => { 105 => 0x6 },
	'gammaunsharpmaskstrength' => { 105 => 0x5 },
	'gammaunsharpmaskthreshold' => { 105 => 0x7 },
	'gammawhitepoint' => { 105 => 0xd },
	'garminsettings' => { 400 => 'pmcc' },
	'garminsoftware' => { 400 => 'uuid' },
	'gdalmetadata' => { 119 => 0xa480 },
	'gdalnodata' => { 119 => 0xa481 },
	'geimagesize' => { 127 => 0x1304 },
	'gemake' => { 129 => 0x300 },
	'gemodel' => { 129 => 0x207 },
	'genre' => { 392 => ['gnre',"\xa9gen"], 394 => 'genre', 400 => ['gnre',"\xa9gen"], 514 => 'Genre', 519 => 'genre', 529 => 'genre' },
	'genrecvid' => { 514 => [\'Genre','GenreCvId'] },
	'genrecvtermid' => { 514 => [\'Genre','GenreCvTermId'] },
	'genrecvtermname' => { 514 => [\'Genre','GenreCvTermName'] },
	'genrecvtermrefinedabout' => { 514 => [\'Genre','GenreCvTermRefinedAbout'] },
	'genreid' => { 392 => 'geID' },
	'geography' => { 520 => 'geography' },
	'geologicalcontext' => { 118 => 'GeologicalContext' },
	'geologicalcontextbed' => { 118 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 118 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 118 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 118 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 118 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 120 => 'Geosync' },
	'geotag' => { 120 => 'Geotag' },
	'geotiffasciiparams' => { 119 => 0x87b1 },
	'geotiffdirectory' => { 119 => 0x87af },
	'geotiffdoubleparams' => { 119 => 0x87b0 },
	'geotime' => { 120 => 'Geotime' },
	'giftftppriority' => { 490 => 'GIFTFtpPriority' },
	'gimbalpitchdegree' => { 116 => 'GimbalPitchDegree' },
	'gimbalreverse' => { 116 => 'GimbalReverse' },
	'gimbalrolldegree' => { 116 => 'GimbalRollDegree' },
	'gimbalyawdegree' => { 116 => 'GimbalYawDegree' },
	'globalaltitude' => { 389 => 0x419 },
	'globalangle' => { 389 => 0x40d },
	'good' => { 529 => 'good' },
	'googlehostheader' => { 392 => 'gshh' },
	'googlepingmessage' => { 392 => 'gspm' },
	'googlepingurl' => { 392 => 'gspu' },
	'googleplusuploadcode' => { 119 => 0x9009 },
	'googlesourcedata' => { 392 => 'gssd' },
	'googlestarttime' => { 392 => 'gsst' },
	'googletrackduration' => { 392 => 'gstd' },
	'goprotype' => { 400 => 'GoPr' },
	'gpsaltitude' => { 130 => 0x6, 160 => 'Altitude', 506 => 'GPSAltitude' },
	'gpsaltituderef' => { 130 => 0x5, 506 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 130 => 0x1c, 506 => 'GPSAreaInformation' },
	'gpscoordinates' => { 392 => "\xa9xyz", 394 => 'location.ISO6709', 400 => ['@xyz',"\xa9xyz"] },
	'gpsdatestamp' => { 130 => 0x1d },
	'gpsdatetime' => { 160 => 'DateTime', 506 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 130 => 0x18, 160 => 'Bearing', 506 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 130 => 0x17, 506 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 130 => 0x1a, 160 => 'Distance', 506 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 130 => 0x19, 506 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 130 => 0x14, 506 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 130 => 0x13 },
	'gpsdestlongitude' => { 130 => 0x16, 506 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 130 => 0x15 },
	'gpsdifferential' => { 130 => 0x1e, 160 => 'Differential', 506 => 'GPSDifferential' },
	'gpsdop' => { 130 => 0xb, 506 => 'GPSDOP' },
	'gpshpositioningerror' => { 130 => 0x1f, 506 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 130 => 0x11, 506 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 130 => 0x10, 506 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 114 => 'GPS-GPSLatitude', 116 => 'GpsLatitude', 130 => 0x2, 160 => 'Latitude', 506 => 'GPSLatitude' },
	'gpslatituderef' => { 130 => 0x1 },
	'gpslongitude' => { 114 => 'GPS-GPSLongitude', 116 => 'GpsLongitude', 130 => 0x4, 160 => 'Longitude', 506 => 'GPSLongitude' },
	'gpslongituderef' => { 130 => 0x3 },
	'gpslongtitude' => { 116 => 'GpsLongtitude' },
	'gpsmapdatum' => { 130 => 0x12, 160 => 'Datum', 506 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 130 => 0xa, 160 => 'MeasureMode', 506 => 'GPSMeasureMode' },
	'gpsposition' => { 114 => 'Exif-GPSPosition' },
	'gpsprocessingmethod' => { 130 => 0x1b, 506 => 'GPSProcessingMethod' },
	'gpssatellites' => { 130 => 0x8, 160 => 'Satellites', 506 => 'GPSSatellites' },
	'gpsspeed' => { 130 => 0xd, 160 => 'Speed', 506 => 'GPSSpeed' },
	'gpsspeedref' => { 130 => 0xc, 506 => 'GPSSpeedRef' },
	'gpsstatus' => { 130 => 0x9, 506 => 'GPSStatus' },
	'gpsstring' => { 138 => 0x402 },
	'gpstimestamp' => { 130 => 0x7 },
	'gpstrack' => { 130 => 0xf, 160 => 'Heading', 506 => 'GPSTrack' },
	'gpstrackref' => { 130 => 0xe, 506 => 'GPSTrackRef' },
	'gpsversionid' => { 130 => 0x0, 506 => 'GPSVersionID' },
	'gradation' => { 317 => 0x50f },
	'gradientbasedcorractive' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrblacks2012' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBlacks2012'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBlacks2012'] },
	'gradientbasedcorrbrightness' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrcorrectionname' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionName'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionName'] },
	'gradientbasedcorrcorrectionsyncid' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionSyncID'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionSyncID'] },
	'gradientbasedcorrdefringe' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrdehaze' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDehaze'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDehaze'] },
	'gradientbasedcorrections' => { 500 => 'GradientBasedCorrections', 502 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHue'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHue'] },
	'gradientbasedcorrluminancenoise' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskinputdigest' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksInputDigest'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksInputDigest'] },
	'gradientbasedcorrmaskleft' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmaskactive' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskActive'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskActive'] },
	'gradientbasedcorrmaskmaskblendmode' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskBlendMode'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'gradientbasedcorrmaskmaskdigest' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskDigest'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskDigest'] },
	'gradientbasedcorrmaskmaskinverted' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskInverted'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskInverted'] },
	'gradientbasedcorrmaskmaskname' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskName'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskName'] },
	'gradientbasedcorrmaskmasks' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasks'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasks'] },
	'gradientbasedcorrmaskmasksalpha' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAlpha'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'gradientbasedcorrmaskmasksangle' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAngle'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAngle'] },
	'gradientbasedcorrmaskmasksbottom' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksBottom'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksBottom'] },
	'gradientbasedcorrmaskmaskscentervalue' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterValue'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'gradientbasedcorrmaskmaskscenterweight' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterWeight'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'gradientbasedcorrmaskmasksdabs' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksDabs'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksDabs'] },
	'gradientbasedcorrmaskmasksfeather' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFeather'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFeather'] },
	'gradientbasedcorrmaskmasksflipped' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlipped'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'gradientbasedcorrmaskmasksflow' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlow'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlow'] },
	'gradientbasedcorrmaskmasksfullx' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullX'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullX'] },
	'gradientbasedcorrmaskmasksfully' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullY'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullY'] },
	'gradientbasedcorrmaskmasksinputdigest' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksInputDigest'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'gradientbasedcorrmaskmasksleft' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksLeft'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksLeft'] },
	'gradientbasedcorrmaskmasksmaskactive' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskActive'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'gradientbasedcorrmaskmasksmaskblendmode' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'gradientbasedcorrmaskmasksmaskdigest' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskDigest'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'gradientbasedcorrmaskmasksmaskinverted' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskInverted'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'gradientbasedcorrmaskmasksmaskname' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskName'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'gradientbasedcorrmaskmasksmasksubtype' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSubType'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'gradientbasedcorrmaskmasksmasksyncid' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'gradientbasedcorrmaskmasksmaskversion' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskVersion'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'gradientbasedcorrmaskmasksmidpoint' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMidpoint'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'gradientbasedcorrmaskmasksorigin' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksOrigin'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'gradientbasedcorrmaskmasksperimetervalue' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'gradientbasedcorrmaskmasksradius' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRadius'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRadius'] },
	'gradientbasedcorrmaskmasksreferencepoint' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksReferencePoint'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'gradientbasedcorrmaskmasksright' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRight'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRight'] },
	'gradientbasedcorrmaskmasksroundness' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRoundness'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'gradientbasedcorrmaskmaskssizex' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeX'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'gradientbasedcorrmaskmaskssizey' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeY'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'gradientbasedcorrmaskmaskstop' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksTop'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksTop'] },
	'gradientbasedcorrmaskmasksubtype' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSubType'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSubType'] },
	'gradientbasedcorrmaskmasksvalue' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskValue'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'gradientbasedcorrmaskmasksversion' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksVersion'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksVersion'] },
	'gradientbasedcorrmaskmaskswhat' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWhat'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWhat'] },
	'gradientbasedcorrmaskmaskswholeimagearea' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'gradientbasedcorrmaskmasksx' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksX'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksX'] },
	'gradientbasedcorrmaskmasksy' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksY'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksY'] },
	'gradientbasedcorrmaskmasksyncid' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSyncID'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'gradientbasedcorrmaskmaskszerox' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroX'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'gradientbasedcorrmaskmaskszeroy' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroY'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'gradientbasedcorrmaskmaskversion' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskVersion'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskVersion'] },
	'gradientbasedcorrmaskmidpoint' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskorigin' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksOrigin'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksOrigin'] },
	'gradientbasedcorrmaskperimetervalue' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskrange' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'gradientbasedcorrmaskrangeareamodels' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'gradientbasedcorrmaskrangeareamodelscolorsampleinfo' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'gradientbasedcorrmaskrangeareamodelscomponents' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'gradientbasedcorrmaskrangecoloramount' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'gradientbasedcorrmaskrangedepthfeather' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'gradientbasedcorrmaskrangedepthmax' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'gradientbasedcorrmaskrangedepthmin' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'gradientbasedcorrmaskrangeinvert' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'gradientbasedcorrmaskrangelumfeather' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'gradientbasedcorrmaskrangeluminancedepthsampleinfo' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'gradientbasedcorrmaskrangelummax' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'gradientbasedcorrmaskrangelummin' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'gradientbasedcorrmaskrangelumrange' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'gradientbasedcorrmaskrangesampletype' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'gradientbasedcorrmaskrangetype' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'gradientbasedcorrmaskrangeversion' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'gradientbasedcorrmaskreferencepoint' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksReferencePoint'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksReferencePoint'] },
	'gradientbasedcorrmaskright' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskwholeimagearea' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWholeImageArea'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'gradientbasedcorrmaskx' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrrangemask' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMask'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMask'] },
	'gradientbasedcorrrangemaskareamodels' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModels'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'gradientbasedcorrrangemaskareamodelscolorsampleinfo' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'gradientbasedcorrrangemaskareamodelscomponents' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'gradientbasedcorrrangemaskcoloramount' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskColorAmount'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'gradientbasedcorrrangemaskdepthfeather' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthFeather'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'gradientbasedcorrrangemaskdepthmax' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMax'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'gradientbasedcorrrangemaskdepthmin' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMin'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'gradientbasedcorrrangemaskinvert' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskInvert'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskInvert'] },
	'gradientbasedcorrrangemasklumfeather' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumFeather'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'gradientbasedcorrrangemaskluminancedepthsampleinfo' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'gradientbasedcorrrangemasklummax' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMax'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'gradientbasedcorrrangemasklummin' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMin'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'gradientbasedcorrrangemasklumrange' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumRange'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'gradientbasedcorrrangemasksampletype' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskSampleType'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'gradientbasedcorrrangemasktype' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskType'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskType'] },
	'gradientbasedcorrrangemaskversion' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskVersion'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskVersion'] },
	'gradientbasedcorrsaturation' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation'] },
	'gradientbasedcorrshadows2012' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtexture' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTexture'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTexture'] },
	'gradientbasedcorrtint' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrtoninghue' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrtoningsaturation' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningSaturation'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrwhat' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'gradientbasedcorrwhites2012' => { 500 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalWhites2012'], 502 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalWhites2012'] },
	'grainamount' => { 500 => 'GrainAmount', 502 => 'GrainAmount' },
	'graineffectroughness' => { 127 => 0x1047 },
	'graineffectsize' => { 127 => 0x104c },
	'grainfrequency' => { 500 => 'GrainFrequency', 502 => 'GrainFrequency' },
	'grainseed' => { 500 => 'GrainSeed', 502 => 'GrainSeed' },
	'grainsize' => { 500 => 'GrainSize', 502 => 'GrainSize' },
	'graymixeraqua' => { 500 => 'GrayMixerAqua', 502 => 'GrayMixerAqua' },
	'graymixerblue' => { 500 => 'GrayMixerBlue', 502 => 'GrayMixerBlue' },
	'graymixergreen' => { 500 => 'GrayMixerGreen', 502 => 'GrayMixerGreen' },
	'graymixermagenta' => { 500 => 'GrayMixerMagenta', 502 => 'GrayMixerMagenta' },
	'graymixerorange' => { 500 => 'GrayMixerOrange', 502 => 'GrayMixerOrange' },
	'graymixerpurple' => { 500 => 'GrayMixerPurple', 502 => 'GrayMixerPurple' },
	'graymixerred' => { 500 => 'GrayMixerRed', 502 => 'GrayMixerRed' },
	'graymixeryellow' => { 500 => 'GrayMixerYellow', 502 => 'GrayMixerYellow' },
	'graypoint' => { 476 => 0x8021 },
	'grayresponseunit' => { 119 => 0x122 },
	'greencurvelimits' => { 108 => 0x1c4 },
	'greencurvepoints' => { 107 => 0x53, 108 => 0x19a },
	'greenghostmitigationstatus' => { 1 => 0x3f },
	'greenhsl' => { 103 => 0x20913 },
	'greenhue' => { 500 => 'GreenHue', 502 => 'GreenHue' },
	'greensaturation' => { 500 => 'GreenSaturation', 502 => 'GreenSaturation' },
	'griddisplay' => { 297 => '13.3', 298 => '4.3', 300 => '4.2', 301 => '4.2', 302 => '2.2', 306 => '10.5', 307 => '3.4', 308 => '6.1', 310 => '4.4', 311 => '4.2', 312 => '4.2' },
	'gripbatteryadload' => { 354 => 0x5 },
	'gripbatteryadnoload' => { 354 => 0x4 },
	'gripbatterystate' => { 354 => '1.2' },
	'group' => { 500 => 'Group', 502 => 'Group' },
	'groupareaafillumination' => { 298 => '46.4', 301 => '47.4', 310 => '47.4' },
	'grouping' => { 392 => ['grup',"\xa9grp"], 400 => "\xa9grp" },
	'guid' => { 392 => 'GUID' },
	'h2resetblackpixels' => { 138 => 0x18a6 },
	'h3resetblackcolumns' => { 138 => 0x18ce },
	'h3resetblackpixels' => { 138 => 0x18b0 },
	'halftonehints' => { 119 => 0x141 },
	'hardlink' => { 120 => 'HardLink' },
	'hasalternative' => { 519 => 'hasAlternative' },
	'hascorrection' => { 519 => 'hasCorrection' },
	'hascorrectiona-lang' => { 519 => [\'hasCorrection','hasCorrectionA-lang'] },
	'hascorrectiona-platform' => { 519 => [\'hasCorrection','hasCorrectionA-platform'] },
	'hascorrectiontext' => { 519 => [\'hasCorrection','hasCorrectionText'] },
	'hascrop' => { 500 => 'HasCrop', 502 => 'HasCrop' },
	'hasextendedxmp' => { 531 => 'HasExtendedXMP' },
	'hassettings' => { 500 => 'HasSettings', 502 => 'HasSettings' },
	'hastranslation' => { 519 => 'hasTranslation' },
	'hasvisibleoverprint' => { 534 => 'HasVisibleOverprint' },
	'hasvisibletransparency' => { 534 => 'HasVisibleTransparency' },
	'hdmioutputn-log' => { 238 => 0x35a },
	'hdmioutputresolution' => { 239 => 0x710, 240 => 0x610, 241 => 0x640, 242 => 0x6a8 },
	'hdmiviewassist' => { 314 => 0x20f, 315 => 0x227 },
	'hdr' => { 60 => 0x1, 219 => 0x4, 220 => 0x4, 239 => 0x23a, 242 => 0x23a, 340 => 0x9e, 375 => 0x85, 440 => 0x200a },
	'hdrcapacitymax' => { 511 => 'HDRCapacityMax' },
	'hdrcapacitymin' => { 511 => 'HDRCapacityMin' },
	'hdreditmode' => { 500 => 'HDREditMode', 502 => 'HDREditMode' },
	'hdreffect' => { 60 => 0x2 },
	'hdrgain' => { 1 => 0x30 },
	'hdrheadroom' => { 1 => 0x21 },
	'hdrimagetype' => { 1 => 0xa },
	'hdrlevel' => { 219 => 0x5, 220 => 0x5, 239 => 0x246, 242 => 0x246, 429 => 0x2e, 445 => 0x17 },
	'hdrlevel2' => { 219 => 0x7 },
	'hdrpmakernote' => { 483 => 'hdrp_makernote' },
	'hdrsetting' => { 429 => 0x2d, 445 => 0x16, 449 => 0x1148, 450 => 0x1148, 451 => 0x1124, 452 => 0x11a0, 453 => 0x117c, 454 => 0x1034, 455 => 0x22c, 456 => 0x22c, 457 => 0x21f },
	'hdrshot' => { 340 => 0x76 },
	'hdrsmoothing' => { 219 => 0x6 },
	'hdvideo' => { 392 => 'hdvd' },
	'headline' => { 131 => 0x69, 514 => 'Headline', 517 => 'Headline' },
	'hierarchicalkeywords' => { 171 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 171 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 171 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 171 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 171 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 171 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 171 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 492 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 118 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highframerate' => { 239 => 0x48, 241 => 0x48, 242 => 0x48 },
	'highfrequencyflickerreductionshooting' => { 239 => 0x27c, 241 => 0x27c, 242 => 0x27c },
	'highisomultiplierblue' => { 345 => 0x1a },
	'highisomultipliergreen' => { 345 => 0x19 },
	'highisomultiplierred' => { 345 => 0x18 },
	'highisonoisereduction' => { 16 => 0xbc, 17 => 0xbd, 20 => 0xbd, 28 => 0xc9, 62 => 0x5, 84 => 0x202, 234 => 0xb1, 375 => 0x71, 427 => 0x2c, 428 => 0x26, 429 => 0x26, 440 => 0x2009, 445 => 0x12, 472 => 0x42 },
	'highisonoisereduction2' => { 440 => 0xb050 },
	'highlight' => { 417 => 0xf },
	'highlight2012' => { 500 => 'Highlight2012', 502 => 'Highlight2012' },
	'highlightadj' => { 103 => 0x2030c },
	'highlightcolordistortreduct' => { 476 => 0x8026 },
	'highlightlinearitylimit' => { 414 => 0xa025 },
	'highlightprotection' => { 289 => 0x6 },
	'highlightrecovery' => { 500 => 'HighlightRecovery', 502 => 'HighlightRecovery' },
	'highlights' => { 440 => 0x2033, 494 => 'Highlights' },
	'highlights2012' => { 500 => 'Highlights2012', 502 => 'Highlights2012' },
	'highlightsadj' => { 476 => 0x9019 },
	'highlightshadow' => { 340 => 0xad },
	'highlighttone' => { 127 => 0x1041 },
	'highlighttonepriority' => { 13 => 0x7, 16 => 0x7, 17 => 0x7, 18 => 0x7, 20 => 0x7, 22 => 0x7, 28 => 0x7, 62 => 0x3, 84 => 0x203 },
	'highlightwarning' => { 340 => 0x8002 },
	'highlowkeyadj' => { 375 => 0x6c },
	'highspeedsync' => { 184 => 0x5, 313 => 0x55, 314 => 0x55, 315 => 0x55, 427 => 0x2, 428 => 0x2 },
	'hintversion' => { 400 => 'hinv' },
	'histogramxml' => { 290 => 0x83a1a25 },
	'history' => { 517 => 'History', 530 => 'History' },
	'historyaction' => { 530 => [\'History','HistoryAction'] },
	'historychanged' => { 530 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 530 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 530 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 530 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 530 => [\'History','HistoryWhen'] },
	'holefilldarkdeltathreshold' => { 138 => 0xc88 },
	'holefilldeltathreshold' => { 138 => 0xc7e },
	'hometowncity' => { 113 => 0x3006, 375 => 0x23, 381 => 0x2 },
	'hometowncitycode' => { 382 => 0x1000 },
	'hometowndst' => { 375 => 0x25, 381 => '0.2' },
	'hostcomputer' => { 119 => 0x13c },
	'hostsoftwarerendering' => { 138 => 0xce7 },
	'hue' => { 189 => 0x3b, 250 => 0x3d, 251 => 0x45, 375 => 0x67 },
	'hueadj' => { 293 => 0x2f, 476 => 0x8019 },
	'hueadjust' => { 407 => 0x1016 },
	'hueadjustment' => { 182 => 0x4a, 183 => 0x40, 234 => 0x92, 249 => 0x36 },
	'hueadjustmentaqua' => { 500 => 'HueAdjustmentAqua', 502 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 500 => 'HueAdjustmentBlue', 502 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 500 => 'HueAdjustmentGreen', 502 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 500 => 'HueAdjustmentMagenta', 502 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 500 => 'HueAdjustmentOrange', 502 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 500 => 'HueAdjustmentPurple', 502 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 500 => 'HueAdjustmentRed', 502 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 500 => 'HueAdjustmentYellow', 502 => 'HueAdjustmentYellow' },
	'huesetting' => { 325 => 0x1011 },
	'humanobservation' => { 118 => 'HumanObservation' },
	'humanobservationday' => { 118 => [\'HumanObservation','HumanObservationDay'] },
	'humanobservationearliestdate' => { 118 => [\'HumanObservation','HumanObservationEarliestDate'] },
	'humanobservationenddayofyear' => { 118 => [\'HumanObservation','HumanObservationEndDayOfYear'] },
	'humanobservationeventdate' => { 118 => [\'HumanObservation','HumanObservationEventDate'] },
	'humanobservationeventid' => { 118 => [\'HumanObservation','HumanObservationEventID'] },
	'humanobservationeventremarks' => { 118 => [\'HumanObservation','HumanObservationEventRemarks'] },
	'humanobservationeventtime' => { 118 => [\'HumanObservation','HumanObservationEventTime'] },
	'humanobservationfieldnotes' => { 118 => [\'HumanObservation','HumanObservationFieldNotes'] },
	'humanobservationfieldnumber' => { 118 => [\'HumanObservation','HumanObservationFieldNumber'] },
	'humanobservationhabitat' => { 118 => [\'HumanObservation','HumanObservationHabitat'] },
	'humanobservationlatestdate' => { 118 => [\'HumanObservation','HumanObservationLatestDate'] },
	'humanobservationmonth' => { 118 => [\'HumanObservation','HumanObservationMonth'] },
	'humanobservationparenteventid' => { 118 => [\'HumanObservation','HumanObservationParentEventID'] },
	'humanobservationsamplesizeunit' => { 118 => [\'HumanObservation','HumanObservationSampleSizeUnit'] },
	'humanobservationsamplesizevalue' => { 118 => [\'HumanObservation','HumanObservationSampleSizeValue'] },
	'humanobservationsamplingeffort' => { 118 => [\'HumanObservation','HumanObservationSamplingEffort'] },
	'humanobservationsamplingprotocol' => { 118 => [\'HumanObservation','HumanObservationSamplingProtocol'] },
	'humanobservationstartdayofyear' => { 118 => [\'HumanObservation','HumanObservationStartDayOfYear'] },
	'humanobservationverbatimeventdate' => { 118 => [\'HumanObservation','HumanObservationVerbatimEventDate'] },
	'humanobservationyear' => { 118 => [\'HumanObservation','HumanObservationYear'] },
	'humidity' => { 119 => 0x9401, 507 => 'Humidity' },
	'icc_profile' => { 120 => 'ICC_Profile' },
	'iccprofilename' => { 517 => 'ICCProfile' },
	'iconuri' => { 400 => 'icnu' },
	'idccreativestyle' => { 476 => 0x8000 },
	'idcpreviewlength' => { 476 => 0x202 },
	'idcpreviewstart' => { 476 => 0x201 },
	'identification' => { 118 => 'Identification' },
	'identificationid' => { 118 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 118 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 118 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 118 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 118 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 118 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifiedbyid' => { 118 => [\'Identification','IdentificationIdentifiedByID'] },
	'identifier' => { 503 => 'identifier', 527 => 'Identifier' },
	'ifcameramodel' => { 138 => 0x9c8 },
	'illuminantdata1' => { 119 => 0xcd35 },
	'illuminantdata2' => { 119 => 0xcd36 },
	'illuminantdata3' => { 119 => 0xcd37 },
	'illumination' => { 308 => '0.5', 402 => 0x48 },
	'imageabsolutex' => { 138 => 0x3fe },
	'imageabsolutey' => { 138 => 0x3ff },
	'imageadjustment' => { 234 => 0x80, 280 => 0x5 },
	'imagealterationconstraints' => { 327 => 'ImageAlterationConstraints' },
	'imagearea' => { 266 => 0x10, 269 => 0x10 },
	'imageareaoffset' => { 375 => 0x38 },
	'imageauthentication' => { 234 => 0x20 },
	'imageboundary' => { 234 => 0x16 },
	'imagecapturerequestid' => { 1 => 0x20 },
	'imagecapturetype' => { 1 => 0x14 },
	'imagecount' => { 127 => 0x1438, 234 => 0xa5, 443 => 0x11b },
	'imagecreator' => { 327 => 'ImageCreator' },
	'imagecreatorid' => { 327 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 327 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 327 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagecropx' => { 138 => 0x41f },
	'imagecropy' => { 138 => 0x420 },
	'imagedata' => { 487 => 'Data' },
	'imagedatasize' => { 234 => 0xa2 },
	'imagedescription' => { 119 => 0x10e, 525 => 'ImageDescription' },
	'imageduplicationconstraints' => { 327 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 290 => 0xfe443a45 },
	'imageeditcount' => { 375 => 0x41 },
	'imageediting' => { 375 => 0x32 },
	'imageeditingsoftware' => { 119 => 0xa43b },
	'imageeditor' => { 119 => 0xa438 },
	'imageeffects' => { 407 => 0x1010 },
	'imagefileconstraints' => { 327 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 327 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 327 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 127 => 0x1436 },
	'imageheight' => { 119 => 0x101, 188 => 0xc, 384 => 0x10d, 485 => 'ImageHeight', 525 => 'ImageLength' },
	'imagehistory' => { 119 => 0x9213, 505 => 'ImageHistory' },
	'imageidnumber' => { 335 => 0x340 },
	'imagemimetype' => { 487 => 'Mime' },
	'imagenumber' => { 119 => 0x9211, 156 => 'ImageNumber', 182 => 0xae, 183 => 0x5e, 384 => 0x113, 427 => 0x9b, 429 => [0x400,'276.1',0x314], 497 => 'ImageNumber' },
	'imagenumber2' => { 183 => 0x62 },
	'imageoptimization' => { 234 => 0xa9 },
	'imageorientation' => { 131 => 0x83 },
	'imageprocessing' => { 234 => 0x1a },
	'imageprocessingfiledatecreated' => { 138 => 0xc81 },
	'imageprocessingfiletagsversionnumber' => { 138 => 0xc80 },
	'imageprocessingflags' => { 1 => 0x19 },
	'imageprocessingversion' => { 321 => 0x0 },
	'imagequality' => { 156 => 'ImageQuality', 268 => '723.2', 269 => '732.2', 277 => '708.1', 340 => 0x1 },
	'imagequality2' => { 317 => 0x603 },
	'imagerank' => { 490 => 'ImageRank' },
	'imagerbiassettlingdelaymsec' => { 138 => 0x600 },
	'imagerboardversion' => { 138 => 0x439 },
	'imagercols' => { 138 => 0x17d4 },
	'imageref' => { 512 => 'ImageRef' },
	'imageregion' => { 514 => 'ImageRegion' },
	'imageregionboundary' => { 514 => [\'ImageRegion','ImageRegionRegionBoundary'] },
	'imageregionboundaryh' => { 514 => [\'ImageRegion','ImageRegionRegionBoundaryRbH'] },
	'imageregionboundaryrx' => { 514 => [\'ImageRegion','ImageRegionRegionBoundaryRbRx'] },
	'imageregionboundaryshape' => { 514 => [\'ImageRegion','ImageRegionRegionBoundaryRbShape'] },
	'imageregionboundaryunit' => { 514 => [\'ImageRegion','ImageRegionRegionBoundaryRbUnit'] },
	'imageregionboundaryvertices' => { 514 => [\'ImageRegion','ImageRegionRegionBoundaryRbVertices'] },
	'imageregionboundaryverticesx' => { 514 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbX'] },
	'imageregionboundaryverticesy' => { 514 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbY'] },
	'imageregionboundaryw' => { 514 => [\'ImageRegion','ImageRegionRegionBoundaryRbW'] },
	'imageregionboundaryx' => { 514 => [\'ImageRegion','ImageRegionRegionBoundaryRbX'] },
	'imageregionboundaryy' => { 514 => [\'ImageRegion','ImageRegionRegionBoundaryRbY'] },
	'imageregionctype' => { 514 => [\'ImageRegion','ImageRegionRCtype'] },
	'imageregionctypeidentifier' => { 514 => [\'ImageRegion','ImageRegionRCtypeIdentifier'] },
	'imageregionctypename' => { 514 => [\'ImageRegion','ImageRegionRCtypeName'] },
	'imageregionid' => { 514 => [\'ImageRegion','ImageRegionRId'] },
	'imageregionname' => { 514 => [\'ImageRegion','ImageRegionName'] },
	'imageregionrole' => { 514 => [\'ImageRegion','ImageRegionRRole'] },
	'imageregionroleidentifier' => { 514 => [\'ImageRegion','ImageRegionRRoleIdentifier'] },
	'imageregionrolename' => { 514 => [\'ImageRegion','ImageRegionRRoleName'] },
	'imageresolution' => { 138 => 0x944 },
	'imageresolutionjpg' => { 138 => 0x945 },
	'imagereview' => { 299 => '0.4', 308 => '0.4' },
	'imagereviewmonitorofftime' => { 298 => '21.1', 300 => '21.1', 301 => '21.1', 305 => '20.1', 310 => '21.1', 311 => '21.1', 313 => 0x39, 314 => 0x39, 315 => 0x39 },
	'imagereviewtime' => { 297 => '25.1', 299 => '2.1', 302 => '19.1', 303 => '20.1', 304 => '20.1', 306 => '9.2', 307 => '20.1', 312 => '21.2' },
	'imagerfiledatecreated' => { 138 => 0x9c5 },
	'imagerfileproductionlevel' => { 138 => 0x9c4 },
	'imagerfiletagsversionstandard' => { 138 => 0x9c7 },
	'imagerotated' => { 151 => 0x2a },
	'imagerpowerondelaymsec' => { 138 => 0x5fd },
	'imagerrows' => { 138 => 0x17de },
	'imagesegmentlines' => { 138 => 0x184d },
	'imagesegmentstartline' => { 138 => 0x184c },
	'imagesize' => { 162 => 'ImageSize' },
	'imagesizeraw' => { 234 => 0x3e },
	'imagesizerestriction' => { 522 => 'imageSizeRestriction' },
	'imagesourcedata' => { 119 => 0x935c },
	'imagespace' => { 138 => 0x909 },
	'imagestabilization' => { 34 => 0x22, 113 => 0x3020, 127 => 0x1422, 156 => 'ImageStabilization', 182 => 0xbd, 183 => 0x71, 184 => 0x57, 185 => 0x0, 186 => [0x18,0x107,0x113], 187 => 0x49c2, 234 => 0xac, 317 => 0x604, 320 => 0x1600, 340 => 0x1a, 432 => 0x12, 433 => 0x11, 440 => 0xb026 },
	'imagestabilization2' => { 431 => 0xa },
	'imagestabilizationsetting' => { 187 => 0x14, 427 => 0x3d, 428 => 0x3d, 438 => 0x14 },
	'imagestyle' => { 427 => 0x2d, 428 => 0x27 },
	'imagesupplier' => { 327 => 'ImageSupplier' },
	'imagesupplierid' => { 327 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 327 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 327 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 121 => 0x1 },
	'imagetemperaturemin' => { 121 => 0x2 },
	'imagetone' => { 375 => 0x4f },
	'imagetype' => { 131 => 0x82, 327 => 'ImageType' },
	'imageuniqueid' => { 1 => 0x15, 64 => 0x28, 119 => 0xa420, 505 => 'ImageUniqueID', 506 => 'ImageUniqueID' },
	'imagewidth' => { 119 => 0x100, 188 => 0xe, 384 => 0x10c, 485 => 'ImageWidth', 525 => 'ImageWidth' },
	'inclinationangle' => { 476 => 0x900f },
	'inclinationcorrection' => { 476 => 0x900e },
	'incrementaltemperature' => { 500 => 'IncrementalTemperature', 502 => 'IncrementalTemperature' },
	'incrementaltint' => { 500 => 'IncrementalTint', 502 => 'IncrementalTint' },
	'industry' => { 519 => 'industry', 520 => 'industry' },
	'infobuttonwhenshooting' => { 84 => 0x409 },
	'information' => { 394 => 'information', 400 => "\xa9inf" },
	'infourl' => { 400 => 'infu' },
	'infraredilluminator' => { 401 => 0x28 },
	'ingredientexclusion' => { 521 => 'ingredientExclusion' },
	'ingredients' => { 530 => 'Ingredients' },
	'ingredientsalternatepaths' => { 530 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 530 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 530 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 530 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 530 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 530 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientslasturl' => { 530 => [\'Ingredients','IngredientsLastURL'] },
	'ingredientslinkcategory' => { 530 => [\'Ingredients','IngredientsLinkCategory'] },
	'ingredientslinkform' => { 530 => [\'Ingredients','IngredientsLinkForm'] },
	'ingredientsmanager' => { 530 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 530 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 530 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 530 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 530 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 530 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 530 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsplacedresolutionunit' => { 530 => [\'Ingredients','IngredientsPlacedResolutionUnit'] },
	'ingredientsplacedxresolution' => { 530 => [\'Ingredients','IngredientsPlacedXResolution'] },
	'ingredientsplacedyresolution' => { 530 => [\'Ingredients','IngredientsPlacedYResolution'] },
	'ingredientsrenditionclass' => { 530 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 530 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 530 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 530 => [\'Ingredients','IngredientsVersionID'] },
	'initialafpointaiservoaf' => { 84 => 0x51e },
	'initialafpointinservo' => { 2 => 0x13 },
	'initialcameradolly' => { 488 => 'InitialCameraDolly' },
	'initialhorizontalfovdegrees' => { 488 => 'InitialHorizontalFOVDegrees' },
	'initialkey' => { 179 => 'WM/InitialKey' },
	'initialverticalfovdegrees' => { 488 => 'InitialVerticalFOVDegrees' },
	'initialviewheadingdegrees' => { 488 => 'InitialViewHeadingDegrees', 489 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 488 => 'InitialViewPitchDegrees', 489 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 488 => 'InitialViewRollDegrees', 489 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 297 => '4.4' },
	'initialzoomsetting' => { 297 => '9.3', 306 => '27.3' },
	'inkset' => { 119 => 0x14c },
	'inputprofile' => { 138 => 0x1389 },
	'instanceid' => { 530 => 'InstanceID' },
	'instantplaybacksetup' => { 184 => 0x3e },
	'instantplaybacktime' => { 184 => 0x3d },
	'instructions' => { 517 => 'Instructions' },
	'instrument' => { 529 => 'instrument' },
	'integrationtime' => { 138 => 0x423 },
	'intellectualgenre' => { 513 => 'IntellectualGenre' },
	'intelligentauto' => { 440 => 0xb052, 468 => 0xd, 469 => 0xe, 470 => 0xd },
	'intelligentcontrast' => { 52 => 0x4 },
	'intelligentd-range' => { 340 => 0x79 },
	'intelligentexposure' => { 340 => 0x5d },
	'intelligentresolution' => { 340 => 0x70 },
	'interchangecolorspace' => { 133 => 0x40 },
	'intergraphmatrix' => { 119 => 0x8480 },
	'internalflash' => { 181 => 0x2b, 297 => '23.1', 299 => '8.1', 302 => '22.1', 304 => '23.1', 308 => '8.1', 312 => '24.1', 320 => 0x1208 },
	'internalflashae1' => { 322 => 0x1021 },
	'internalflashae1_0' => { 322 => 0x101d },
	'internalflashae2' => { 322 => 0x1022 },
	'internalflashae2_0' => { 322 => 0x101e },
	'internalflashmode' => { 363 => 0x1 },
	'internalflashstrength' => { 363 => 0x3 },
	'internalflashtable' => { 322 => 0x1024 },
	'internallensserialnumber' => { 414 => 0xa005 },
	'internalndfilter' => { 340 => 0x9d },
	'internalserialnumber' => { 64 => 0x96, 76 => 0x9, 127 => 0x10, 187 => 0x49dc, 316 => 0x18, 318 => 0x102, 337 => 0x500, 340 => 0x25, 355 => 0x4, 407 => 0x5, 459 => [0x7c,0xf0], 460 => 0x88, 461 => [0x88,0x8a], 462 => 0x38 },
	'interopindex' => { 119 => 0x1, 507 => 'InteroperabilityIndex' },
	'interopversion' => { 119 => 0x2 },
	'interval' => { 256 => 0x20 },
	'intervaldurationhours' => { 238 => 0xa0, 239 => 0xb8 },
	'intervaldurationminutes' => { 238 => 0xa4, 239 => 0xbc },
	'intervaldurationseconds' => { 238 => 0xa8, 239 => 0xc0 },
	'intervalexposuresmoothing' => { 223 => 0x184, 238 => 0xb8, 239 => 0xd0 },
	'intervalframe' => { 256 => 0x24 },
	'intervallength' => { 181 => 0x10 },
	'intervalmode' => { 181 => 0x26 },
	'intervalnumber' => { 181 => 0x11 },
	'intervalpriority' => { 223 => 0x186, 238 => 0xba, 239 => 0xd2 },
	'intervals' => { 223 => 0x17c, 238 => 0xb0, 239 => 0xc8, 240 => 0xbc, 241 => 0xcc, 242 => 0xcc },
	'intervalshooting' => { 224 => 0x24, 258 => 0x24, 259 => 0x28, 375 => 0x92 },
	'introtime' => { 529 => 'introTime' },
	'introtimescale' => { 529 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 529 => [\'introTime','introTimeValue'] },
	'ipaversion' => { 138 => 0xdae },
	'ipfcameramodel' => { 138 => 0xe4d },
	'iptc' => { 120 => 'IPTC' },
	'iptc-naa' => { 119 => 0x83bb, 345 => 0x83bb },
	'iptcbitspersample' => { 133 => 0x56 },
	'iptcdigest' => { 389 => 0x425 },
	'iptcimageheight' => { 133 => 0x1e },
	'iptcimagerotation' => { 133 => 0x66 },
	'iptcimagewidth' => { 133 => 0x14 },
	'iptclastedited' => { 514 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 133 => 0xa },
	'iptcpixelheight' => { 133 => 0x32 },
	'iptcpixelwidth' => { 133 => 0x28 },
	'isalternativeof' => { 519 => 'isAlternativeOf' },
	'isbn' => { 519 => 'isbn' },
	'iscorrectionof' => { 519 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 109 => 0x3 },
	'ismergedhdr' => { 497 => 'IsMergedHDR' },
	'ismergedpanorama' => { 497 => 'IsMergedPanorama' },
	'iso' => { 7 => 0x6, 9 => 0x6, 10 => 0x75, 11 => 0x6, 12 => 0x79, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x6, 27 => 0x6, 28 => 0x6, 29 => 0x6, 30 => 0x0, 31 => 0x1, 112 => 0x14, 113 => [0x3014,0x14], 119 => 0x8827, 137 => 0xfd06, 138 => 0x1784, 140 => 0x60, 142 => [0xfa2e,0xfa46], 143 => [0x27,0x28], 144 => 0xf105, 147 => 0x14, 149 => 0x4e, 151 => 0x1e, 152 => 0x1a, 154 => 0x34, 156 => 'ISO', 181 => 0x8, 187 => 0x49ba, 222 => 0x0, 234 => 0x2, 340 => 0xd1, 345 => 0x17, 375 => [0x8b,0x14], 382 => 0x14, 384 => 0x105, 414 => 0xa014, 417 => 0x86, 438 => 0x6f, 445 => [0x1f,0x21,0x25], 506 => 'ISOSpeedRatings' },
	'iso2' => { 222 => 0x6, 263 => 0x265, 264 => 0x25c, 265 => 0x265, 266 => 0x221, 267 => 0x25d, 268 => 0x256, 269 => 0x25d, 272 => 0x2b5, 275 => 0x265, 279 => 0x2b5 },
	'isoauto' => { 356 => '14.4' },
	'isoautoflashlimit' => { 239 => 0x156, 240 => 0x146, 241 => 0x15a, 242 => 0x15a },
	'isoautohilimit' => { 221 => 0x5, 239 => 0x154, 240 => 0x144, 241 => 0x158, 242 => 0x158, 261 => 0x5, 271 => 0x18eb },
	'isoautomax' => { 439 => 0x4 },
	'isoautomin' => { 439 => 0x2 },
	'isoautoparameters' => { 375 => 0x7a },
	'isoautoshuttertime' => { 221 => 0x4, 239 => 0x15e, 240 => 0x14e, 241 => 0x162, 242 => 0x162, 261 => 0x4, 271 => 0x18ea },
	'isobutton' => { 242 => 0x796 },
	'isocalibrationgain' => { 138 => 0x89f },
	'isodisplay' => { 300 => '4.1', 301 => '4.1', 302 => '2.3', 303 => '3.3', 304 => '3.3', 307 => '3.3', 310 => '4.3', 311 => '4.1', 312 => '4.3' },
	'isoexpansion' => { 84 => 0x103, 85 => 0x7, 86 => 0x8, 89 => 0x8, 222 => 0x4 },
	'isoexpansion2' => { 222 => 0xa },
	'isofloor' => { 356 => 0x6 },
	'isoselected' => { 339 => 0x359 },
	'isoselection' => { 234 => 0xf },
	'isosensitivitystep' => { 305 => '6.2', 307 => '6.2' },
	'isosetting' => { 140 => 0x5e, 152 => 0x14, 156 => 'ISOSetting', 181 => 0x24, 182 => 0x26, 183 => 0x1c, 184 => 0x13, 189 => 0x6, 234 => 0x13, 356 => '17.3', 406 => 0x27, 427 => 0x16, 428 => 0x14, 429 => 0x2, 438 => 0x6d, 439 => 0x0 },
	'isospeed' => { 119 => 0x8833, 507 => 'ISOSpeed' },
	'isospeedexpansion' => { 83 => 0x3 },
	'isospeedincrements' => { 84 => 0x102 },
	'isospeedlatitudeyyy' => { 119 => 0x8834, 507 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 119 => 0x8835, 507 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 84 => 0x103 },
	'isostepsize' => { 297 => '6.1', 298 => '7.2', 300 => '7.2', 301 => '7.2', 306 => '4.1', 310 => '7.2', 311 => '7.2', 313 => 0x15d, 314 => 0x15d, 315 => 0x175 },
	'isovalue' => { 322 => 0x1001 },
	'isrccode' => { 400 => "\xa9isr" },
	'issn' => { 519 => 'issn' },
	'issueidentifier' => { 519 => 'issueIdentifier' },
	'issuename' => { 519 => 'issueName' },
	'issueteaser' => { 519 => 'issueTeaser' },
	'issuetype' => { 519 => 'issueType' },
	'istranslationof' => { 519 => 'isTranslationOf' },
	'itemsubtype' => { 178 => 'ItemSubType' },
	'itunesu' => { 392 => 'itnu' },
	'jobid' => { 131 => 0xb8 },
	'jobname' => { 508 => 'JobName' },
	'jobref' => { 528 => 'JobRef' },
	'jobrefid' => { 528 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 528 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 528 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 508 => 'JobStatus' },
	'jpeg-heifswitch' => { 440 => 0x2039 },
	'jpeghandling' => { 500 => 'JPEGHandling', 502 => 'JPEGHandling' },
	'jpegquality' => { 10 => 0x66, 340 => 0x43, 342 => 0x3034, 440 => 0xb047 },
	'jpegsize' => { 342 => 0x303a },
	'jpgcompression' => { 225 => 0x24 },
	'jpgfromraw' => { 97 => 0x2007, 114 => 'Exif-JpgFromRaw', 345 => 0x2e },
	'jpgfromrawlength' => { 119 => [0x117,0x202] },
	'jpgfromrawstart' => { 119 => [0x111,0x201] },
	'jpgrecordedpixels' => { 356 => '14.1' },
	'jurisdiction' => { 498 => 'jurisdiction' },
	'keepexposure' => { 313 => 0x237, 314 => 0x237, 315 => 0x24f },
	'kelvinwb_01' => { 364 => 0x5 },
	'kelvinwb_02' => { 364 => 0x9 },
	'kelvinwb_03' => { 364 => 0xd },
	'kelvinwb_04' => { 364 => 0x11 },
	'kelvinwb_05' => { 364 => 0x15 },
	'kelvinwb_06' => { 364 => 0x19 },
	'kelvinwb_07' => { 364 => 0x1d },
	'kelvinwb_08' => { 364 => 0x21 },
	'kelvinwb_09' => { 364 => 0x25 },
	'kelvinwb_10' => { 364 => 0x29 },
	'kelvinwb_11' => { 364 => 0x2d },
	'kelvinwb_12' => { 364 => 0x31 },
	'kelvinwb_13' => { 364 => 0x35 },
	'kelvinwb_14' => { 364 => 0x39 },
	'kelvinwb_15' => { 364 => 0x3d },
	'kelvinwb_16' => { 364 => 0x41 },
	'kelvinwb_daylight' => { 364 => 0x1 },
	'kerneldenominators' => { 138 => 0x933 },
	'key' => { 529 => 'key' },
	'keystonecompensation' => { 321 => 0x1900 },
	'keystonedirection' => { 321 => 0x1901 },
	'keystonevalue' => { 321 => 0x1906 },
	'keyword' => { 392 => 'keyw', 519 => 'keyword' },
	'keywordinfo' => { 171 => 'Keywords' },
	'keywords' => { 131 => 0x19, 157 => 'Keywords', 326 => 'Keywords', 391 => 'Keywords', 394 => 'keywords', 495 => 'keywords', 516 => 'Keywords', 527 => 'Keywords' },
	'killdate' => { 519 => 'killDate' },
	'killdatea-platform' => { 519 => [\'killDate','killDateA-platform'] },
	'killdatedate' => { 519 => [\'killDate','killDateDate'] },
	'kodakimageheight' => { 137 => 0xf908, 140 => 0xe, 142 => [0xfa1e,0xfa52], 148 => 0x70 },
	'kodakimagewidth' => { 137 => 0xf907, 140 => 0xc, 142 => [0xfa1d,0xfa51], 148 => 0x6c },
	'kodakinfotype' => { 137 => 0xfa00 },
	'kodaklook' => { 138 => 0xe4c },
	'kodaklookprofile' => { 138 => 0x138a },
	'kodakmaker' => { 148 => 0x8 },
	'kodakmodel' => { 140 => 0x0, 148 => 0x28 },
	'kodaktag' => { 138 => 0x3ea },
	'kodakversion' => { 138 => 0x0 },
	'label' => { 330 => 'Label', 527 => 'Label' },
	'labelname1' => { 512 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 512 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 512 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 512 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 512 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 512 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 340 => 0x6f },
	'landscapeoutputhighlightpoint' => { 109 => 0x26 },
	'landscapeoutputshadowpoint' => { 109 => 0x27 },
	'landscaperawcolortone' => { 109 => 0x1f },
	'landscaperawcontrast' => { 109 => 0x21 },
	'landscaperawhighlight' => { 109 => 0x77 },
	'landscaperawhighlightpoint' => { 109 => 0x24 },
	'landscaperawlinear' => { 109 => 0x22 },
	'landscaperawsaturation' => { 109 => 0x20 },
	'landscaperawshadow' => { 109 => 0x80 },
	'landscaperawshadowpoint' => { 109 => 0x25 },
	'landscaperawsharpness' => { 109 => 0x23 },
	'landscapeunsharpmaskfineness' => { 109 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 109 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 109 => 0xa2 },
	'language' => { 239 => 0x692, 240 => 0x592, 241 => 0x5c2, 242 => 0x5da, 503 => 'language' },
	'languageidentifier' => { 131 => 0x87 },
	'largestvalidinteriorrectheight' => { 488 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 488 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 488 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 488 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 181 => 0x1b },
	'lastkeywordiptc' => { 178 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 178 => 'LastKeywordXMP' },
	'lastphotodate' => { 488 => 'LastPhotoDate' },
	'lasturl' => { 530 => 'LastURL' },
	'lateralchromaticaberration' => { 440 => 0x2012 },
	'lateralchromaticaberrationcorrectionalreadyapplied' => { 497 => 'LateralChromaticAberrationCorrectionAlreadyApplied' },
	'latestageorhigheststage' => { 118 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 118 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 118 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 118 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 118 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'latitude' => { 116 => 'Latitude' },
	'lc1' => { 366 => 0x2 },
	'lc10' => { 366 => 0xb },
	'lc11' => { 366 => 0xc },
	'lc12' => { 366 => 0xd },
	'lc14' => { 366 => 0xf },
	'lc15' => { 366 => 0x10 },
	'lc3' => { 366 => 0x4 },
	'lc4' => { 366 => 0x5 },
	'lc5' => { 366 => 0x6 },
	'lc6' => { 366 => 0x7 },
	'lc7' => { 366 => 0x8 },
	'lc8' => { 366 => 0x9 },
	'lcddisplayatpoweron' => { 84 => 0x811, 88 => 0xa },
	'lcddisplayreturntoshoot' => { 89 => 0x12 },
	'lcdillumination' => { 297 => '17.5', 298 => '5.2', 300 => '5.1', 301 => '5.1', 306 => '10.3', 307 => '4.2', 310 => '5.2', 311 => '5.1', 312 => '5.4', 313 => 0x101, 314 => 0x101, 315 => 0x117 },
	'lcdilluminationduringbulb' => { 84 => 0x408 },
	'lcdmatrix' => { 138 => 0xe74 },
	'lcdmatrixchickfix' => { 138 => 0xe75 },
	'lcdmatrixmarvin' => { 138 => 0xe76 },
	'lcdpanels' => { 83 => 0x8 },
	'lcheditor' => { 290 => 0x8ae85e },
	'legacyiptcdigest' => { 517 => 'LegacyIPTCDigest' },
	'legalcode' => { 498 => 'legalcode' },
	'lens' => { 119 => 0xfdea, 234 => 0x84, 497 => 'Lens' },
	'lensafstopbutton' => { 82 => 0x11, 83 => 0x13, 84 => 0x506, 85 => 0x10, 86 => 0x12, 89 => 0x13, 90 => 0x9 },
	'lensaperturerange' => { 417 => [0x30,0x48] },
	'lenscontrolring' => { 313 => 0xad, 314 => 0xad, 315 => 0xad },
	'lenscorrectionsettings' => { 505 => 'LensCorrectionSettings' },
	'lensdistortinfo' => { 497 => 'LensDistortInfo' },
	'lensdistortionparams' => { 322 => 0x206 },
	'lensdriveend' => { 232 => 0x56 },
	'lensdrivenoaf' => { 84 => 0x505 },
	'lensdrivewhenafimpossible' => { 2 => 0xb },
	'lense-mountversion' => { 429 => 0x3f0, 475 => 0xd },
	'lensfirmware' => { 408 => 0x20, 414 => 0xa004 },
	'lensfirmwareversion' => { 318 => 0x204, 340 => 0x60, 429 => 0x3f3, 475 => 0x14 },
	'lensfocallength' => { 103 => 0xf0512, 366 => 0x9 },
	'lensfocalrange' => { 417 => [0xa,0x2a] },
	'lensfocusfunctionbuttons' => { 298 => '55.1', 300 => '52.1', 301 => '52.1', 310 => '52.1', 311 => '52.1' },
	'lensformat' => { 453 => 0x1891, 455 => 0x18bd, 456 => 0x18ed, 457 => 0x17f1, 459 => 0x106, 460 => 0x106, 471 => 0x603, 472 => 0x5d },
	'lensfstops' => { 226 => 0x7, 227 => 0xc, 228 => 0xd, 232 => 0xe, 234 => 0x8b, 366 => '0.3' },
	'lensfunc1button' => { 313 => 0x9f, 314 => 0x9f, 315 => 0x9f },
	'lensfunc1buttonplaybackmode' => { 242 => 0x810 },
	'lensfunc2button' => { 313 => 0xa7, 314 => 0xa7, 315 => 0xa7 },
	'lensfunc2buttonplaybackmode' => { 242 => 0x812 },
	'lensid' => { 232 => 0x30, 497 => 'LensID' },
	'lensidnumber' => { 226 => 0x6, 227 => 0xb, 228 => 0xc, 232 => 0xd },
	'lensinfo' => { 119 => 0xa432, 372 => 0x2a, 497 => 'LensInfo', 507 => 'LensSpecification' },
	'lenskind' => { 366 => 0x1 },
	'lensmake' => { 119 => 0xa433, 163 => 'Make', 507 => 'LensMake' },
	'lensmanualdistortionamount' => { 500 => 'LensManualDistortionAmount', 502 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 178 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 417 => 0x2b },
	'lensmodel' => { 7 => 0x937, 14 => 0x92b, 15 => 0x933, 64 => 0x95, 119 => 0xa434, 163 => 'Model', 178 => 'LensModel', 229 => 0x18a, 230 => 0x18b, 231 => 0x2ac, 318 => 0x203, 372 => 0xc, 384 => 0x412, 507 => 'LensModel' },
	'lensmodulationoptimizer' => { 127 => 0x1045 },
	'lensmount' => { 429 => 0x99, 453 => 0x1892, 455 => 0x18be, 456 => 0x18ee, 457 => 0x17f2, 459 => 0x105, 460 => 0x105, 471 => 0x604, 472 => 0x5e },
	'lensmount2' => { 475 => 0x8 },
	'lensmounttype' => { 232 => 0x35 },
	'lenspositionabsolute' => { 232 => 0x5a },
	'lensprofilechromaticaberrationscale' => { 500 => 'LensProfileChromaticAberrationScale', 502 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 500 => 'LensProfileDigest', 502 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 500 => 'LensProfileDistortionScale', 502 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 500 => 'LensProfileEnable', 502 => 'LensProfileEnable' },
	'lensprofilefilename' => { 500 => 'LensProfileFilename', 502 => 'LensProfileFilename' },
	'lensprofileisembedded' => { 500 => 'LensProfileIsEmbedded', 502 => 'LensProfileIsEmbedded' },
	'lensprofilematchkeycameramodelname' => { 500 => 'LensProfileMatchKeyCameraModelName', 502 => 'LensProfileMatchKeyCameraModelName' },
	'lensprofilematchkeyexifmake' => { 500 => 'LensProfileMatchKeyExifMake', 502 => 'LensProfileMatchKeyExifMake' },
	'lensprofilematchkeyexifmodel' => { 500 => 'LensProfileMatchKeyExifModel', 502 => 'LensProfileMatchKeyExifModel' },
	'lensprofilematchkeyisraw' => { 500 => 'LensProfileMatchKeyIsRaw', 502 => 'LensProfileMatchKeyIsRaw' },
	'lensprofilematchkeylensid' => { 500 => 'LensProfileMatchKeyLensID', 502 => 'LensProfileMatchKeyLensID' },
	'lensprofilematchkeylensinfo' => { 500 => 'LensProfileMatchKeyLensInfo', 502 => 'LensProfileMatchKeyLensInfo' },
	'lensprofilematchkeylensname' => { 500 => 'LensProfileMatchKeyLensName', 502 => 'LensProfileMatchKeyLensName' },
	'lensprofilematchkeysensorformatfactor' => { 500 => 'LensProfileMatchKeySensorFormatFactor', 502 => 'LensProfileMatchKeySensorFormatFactor' },
	'lensprofilename' => { 500 => 'LensProfileName', 502 => 'LensProfileName' },
	'lensprofilesetup' => { 500 => 'LensProfileSetup', 502 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 500 => 'LensProfileVignettingScale', 502 => 'LensProfileVignettingScale' },
	'lensproperties' => { 318 => 0x20b },
	'lensserialnumber' => { 21 => 0x164, 32 => 0x16b, 61 => 0x0, 119 => 0xa435, 163 => 'SerialNumber', 318 => 0x202, 338 => 0x321, 340 => 0x52, 400 => 'LENS', 408 => 0x30, 497 => 'LensSerialNumber', 507 => 'LensSerialNumber' },
	'lensshutterlock' => { 184 => 0x4a },
	'lensspec' => { 424 => 0x0, 425 => 0x0, 426 => 0x0, 440 => 0xb02a },
	'lensspecfeatures' => { 459 => [0x115,0x116], 460 => [0x116,0x1ed,0x1f0,0x21c,0x21e] },
	'lenstemperature' => { 322 => 0x1008 },
	'lenstype' => { 7 => 0xe2, 8 => 0xd, 9 => 0x1a7, 10 => 0xc, 11 => 0x111, 12 => 0xc, 13 => 0x14f, 14 => 0xd6, 15 => 0xde, 16 => 0xf6, 17 => 0xea, 18 => 0xff, 19 => [0xc,0x97], 20 => 0xe6, 21 => 0x153, 22 => 0xea, 23 => 0xe8, 24 => 0x127, 25 => 0x161, 26 => 0x166, 27 => 0x184, 28 => 0x112, 29 => 0x189, 34 => 0x16, 186 => 0x10c, 187 => 0x49bd, 234 => 0x83, 318 => 0x201, 331 => 0x16, 335 => 0x310, 337 => 0x303, 338 => 0x303, 340 => 0x51, 342 => 0x3405, 367 => 0x0, 368 => 0x0, 369 => 0x1, 370 => 0x1, 371 => 0x1, 373 => 0x0, 414 => 0xa003, 417 => 0x27, 440 => 0xb027, 453 => 0x1896, 455 => 0x18c2, 456 => 0x18f2, 457 => 0x17f6, 459 => 0x109, 460 => 0x109, 471 => 0x608, 472 => 0x62 },
	'lenstype2' => { 429 => 0x3f7, 453 => 0x1893, 455 => 0x18bf, 456 => 0x18ef, 457 => 0x17f3, 459 => 0x107, 460 => 0x107, 471 => 0x605, 472 => 0x60 },
	'lenstype3' => { 475 => 0x9 },
	'lenstypemake' => { 340 => 0xc4 },
	'lenstypemodel' => { 340 => [0xc5,0xe4] },
	'lenszoomposition' => { 468 => 0x19, 469 => 0x1e, 472 => [0x342,0x34e,0x35a] },
	'levelindicator' => { 348 => 0x15 },
	'levelmeter' => { 400 => ['Lvlm','lvlm'] },
	'levelorientation' => { 374 => 0x0 },
	'license' => { 498 => 'license' },
	'licensee' => { 327 => 'Licensee' },
	'licenseeid' => { 327 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 327 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 327 => 'LicenseeImageNotes' },
	'licenseename' => { 327 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 327 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 327 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 327 => 'LicenseeTransactionID' },
	'licenseid' => { 327 => 'LicenseID' },
	'licensestartdate' => { 327 => 'LicenseStartDate' },
	'licensetransactiondate' => { 327 => 'LicenseTransactionDate' },
	'licensetype' => { 504 => 'licensetype' },
	'licensor' => { 327 => 'Licensor' },
	'licensorcity' => { 327 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 327 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 327 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 327 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 327 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 327 => 'LicensorImageID' },
	'licensorname' => { 327 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 327 => 'LicensorNotes' },
	'licensorpostalcode' => { 327 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 327 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 327 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 327 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 327 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 327 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 327 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 327 => 'LicensorTransactionID' },
	'licensorurl' => { 327 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 322 => 0x1009 },
	'lightingmode' => { 113 => 0x302a },
	'lightreading' => { 375 => 0x15 },
	'lightsource' => { 119 => 0x9208, 234 => 0x90, 325 => 0x1000, 506 => 'LightSource' },
	'lightsourcespecial' => { 416 => 0x21d },
	'lightswitch' => { 310 => '0.1', 312 => '0.1' },
	'lightvaluecenter' => { 322 => 0x103d },
	'lightvalueperiphery' => { 322 => 0x103e },
	'limitaf-areamodesel3dtracking' => { 313 => 0x153, 314 => 0x153, 315 => 0x16b },
	'limitaf-areamodeseldynamic_l' => { 313 => 0x151, 314 => 0x151, 315 => 0x169 },
	'limitaf-areamodeseldynamic_m' => { 313 => 0x150, 314 => 0x150, 315 => 0x168 },
	'limitaf-areamodeseldynamic_s' => { 313 => 0x14f, 314 => 0x14f, 315 => 0x167 },
	'limitaf-areamodeselpinpoint' => { 313 => 0x11, 314 => 0x11, 315 => 0x11 },
	'limitaf-areamodeselwideaf_l' => { 313 => 0x14, 314 => 0x14, 315 => 0x14 },
	'limitaf-areamodeselwideaf_s' => { 313 => 0x13, 314 => 0x13, 315 => 0x13 },
	'limitafareamodeselauto' => { 313 => 0x15, 314 => 0x15, 315 => 0x15 },
	'limitafareamodeselection' => { 298 => '51.1', 300 => '49.1', 301 => '49.1', 310 => '49.1', 311 => '49.1' },
	'limitreleasemodeselc120' => { 314 => '269.4', 315 => '293.4' },
	'limitreleasemodeselc30' => { 314 => '269.3', 315 => '293.3' },
	'limitreleasemodeselch' => { 314 => '269.2', 315 => '293.2' },
	'limitreleasemodeselcl' => { 314 => '269.1', 315 => '293.1' },
	'limitreleasemodeselself' => { 314 => '269.5', 315 => '293.5' },
	'limitselectableimagearea16to9' => { 313 => 0x47, 314 => 0x47, 315 => 0x47 },
	'limitselectableimagearea1to1' => { 313 => 0x46, 314 => 0x46, 315 => 0x46 },
	'limitselectableimageareadx' => { 313 => 0x45, 314 => 0x45, 315 => 0x45 },
	'linearitylimitblue' => { 345 => 0x10 },
	'linearitylimitgreen' => { 345 => 0xf },
	'linearitylimitred' => { 345 => 0xe },
	'linearityuppermargin' => { 41 => 0x32c, 42 => 0x282, 45 => [0x2ba,0x2d1,0x2d5], 47 => 0x1e5, 48 => [0x1fe,0x2de], 49 => [0x232,0x310], 50 => 0x31e },
	'linearizationtable' => { 119 => 0xc618 },
	'linearresponselimit' => { 119 => 0xc62e },
	'link' => { 519 => 'link' },
	'linkaetoafpoint' => { 356 => '14.2' },
	'linkedencodedrightsexpr' => { 514 => [\'LinkedEncRightsExpr','LinkedEncRightsExprLinkedRightsExpr'] },
	'linkedencodedrightsexprlangid' => { 514 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprLangId'] },
	'linkedencodedrightsexprtype' => { 514 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprEncType'] },
	'linkedencrightsexpr' => { 514 => 'LinkedEncRightsExpr' },
	'linlogcoring' => { 138 => 0x904 },
	'lithostratigraphicterms' => { 118 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'livephotoauto' => { 394 => 'live-photo.auto' },
	'livephotovideoindex' => { 1 => 0x17 },
	'livephotovitalityscore' => { 394 => 'live-photo.vitality-score' },
	'livephotovitalityscoringversion' => { 394 => 'live-photo.vitality-scoring-version' },
	'liveviewaf' => { 302 => '32.1', 312 => '34.1' },
	'liveviewafareamode' => { 307 => '34.1' },
	'liveviewafmethod' => { 445 => 0x20 },
	'liveviewafmode' => { 307 => '34.2' },
	'liveviewafsetting' => { 429 => 0x36 },
	'liveviewbuttonoptions' => { 298 => '50.2', 300 => '48.2', 301 => '48.2', 310 => '48.2', 311 => '48.2' },
	'liveviewexposuresimulation' => { 84 => 0x810 },
	'liveviewfocusmode' => { 429 => [0x8b,0x28b] },
	'liveviewmetering' => { 429 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 298 => '21.2', 300 => '21.2', 301 => '21.2', 303 => '20.2', 304 => '20.2', 305 => '20.2', 307 => '20.2', 310 => '21.2', 311 => '21.2' },
	'liveviewshooting' => { 57 => 0x13 },
	'livingspecimen' => { 118 => 'LivingSpecimen' },
	'livingspecimenmaterialsampleid' => { 118 => [\'LivingSpecimen','LivingSpecimenMaterialSampleID'] },
	'localcaption' => { 131 => 0x79 },
	'localizedcameramodel' => { 119 => 0xc615 },
	'locallocationname' => { 414 => 0x30 },
	'location' => { 233 => 0x9, 340 => 0x67, 493 => 'Location', 513 => 'Location', 518 => 'location', 519 => 'location' },
	'locationaccuracyhorizontal' => { 394 => 'location.accuracy.horizontal' },
	'locationareacode' => { 499 => 'lac' },
	'locationbody' => { 394 => 'location.body' },
	'locationcreated' => { 514 => 'LocationCreated' },
	'locationcreatedcity' => { 514 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 514 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 514 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedgpsaltitude' => { 514 => [\'LocationCreated','LocationCreatedGPSAltitude'] },
	'locationcreatedgpslatitude' => { 514 => [\'LocationCreated','LocationCreatedGPSLatitude'] },
	'locationcreatedgpslongitude' => { 514 => [\'LocationCreated','LocationCreatedGPSLongitude'] },
	'locationcreatedidentifier' => { 514 => [\'LocationCreated','LocationCreatedIdentifier'] },
	'locationcreatedlocationid' => { 514 => [\'LocationCreated','LocationCreatedLocationId'] },
	'locationcreatedlocationname' => { 514 => [\'LocationCreated','LocationCreatedLocationName'] },
	'locationcreatedprovincestate' => { 514 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 514 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 514 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationdate' => { 394 => 'location.date' },
	'locationinformation' => { 400 => 'loci' },
	'locationinfoversion' => { 233 => 0x0 },
	'locationname' => { 394 => 'location.name', 414 => 0x31 },
	'locationnote' => { 394 => 'location.note' },
	'locationrole' => { 394 => 'location.role' },
	'locationshown' => { 514 => 'LocationShown' },
	'locationshowncity' => { 514 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 514 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 514 => [\'LocationShown','LocationShownCountryName'] },
	'locationshowngpsaltitude' => { 514 => [\'LocationShown','LocationShownGPSAltitude'] },
	'locationshowngpslatitude' => { 514 => [\'LocationShown','LocationShownGPSLatitude'] },
	'locationshowngpslongitude' => { 514 => [\'LocationShown','LocationShownGPSLongitude'] },
	'locationshownidentifier' => { 514 => [\'LocationShown','LocationShownIdentifier'] },
	'locationshownlocationid' => { 514 => [\'LocationShown','LocationShownLocationId'] },
	'locationshownlocationname' => { 514 => [\'LocationShown','LocationShownLocationName'] },
	'locationshownprovincestate' => { 514 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 514 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 514 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 84 => 0x709 },
	'logcomment' => { 529 => 'logComment' },
	'logscale' => { 138 => 0x902 },
	'longdescription' => { 392 => 'ldes' },
	'longexposurenoisereduction' => { 62 => 0x4, 84 => 0x201, 85 => 0x1, 86 => 0x2, 87 => 0x1, 88 => 0x1, 89 => 0x2, 90 => 0x1, 340 => 0x49, 427 => 0x2b, 428 => 0x25, 429 => 0x25, 440 => 0x2008, 445 => 0x11, 472 => 0x44 },
	'longexposurenoisereduction2' => { 57 => 0x8 },
	'longexposurenrused' => { 340 => 0xbe },
	'longitude' => { 116 => 'Longitude' },
	'look' => { 500 => 'Look', 502 => 'Look' },
	'lookamount' => { 500 => [\'Look','LookAmount'], 502 => [\'Look','LookAmount'] },
	'lookcluster' => { 500 => [\'Look','LookCluster'], 502 => [\'Look','LookCluster'] },
	'lookcopyright' => { 500 => [\'Look','LookCopyright'], 502 => [\'Look','LookCopyright'] },
	'lookgroup' => { 500 => [\'Look','LookGroup'], 502 => [\'Look','LookGroup'] },
	'lookname' => { 500 => 'LookName', 502 => 'LookName' },
	'lookparameters' => { 500 => [\'Look','LookParameters'], 502 => [\'Look','LookParameters'] },
	'lookparameterscameraprofile' => { 500 => [\'Look','LookParametersCameraProfile'], 502 => [\'Look','LookParametersCameraProfile'] },
	'lookparametersclarity2012' => { 500 => [\'Look','LookParametersClarity2012'], 502 => [\'Look','LookParametersClarity2012'] },
	'lookparametersconverttograyscale' => { 500 => [\'Look','LookParametersConvertToGrayscale'], 502 => [\'Look','LookParametersConvertToGrayscale'] },
	'lookparameterslooktable' => { 500 => [\'Look','LookParametersLookTable'], 502 => [\'Look','LookParametersLookTable'] },
	'lookparametersprocessversion' => { 500 => [\'Look','LookParametersProcessVersion'], 502 => [\'Look','LookParametersProcessVersion'] },
	'lookparameterstonecurvepv2012' => { 500 => [\'Look','LookParametersToneCurvePV2012'], 502 => [\'Look','LookParametersToneCurvePV2012'] },
	'lookparameterstonecurvepv2012blue' => { 500 => [\'Look','LookParametersToneCurvePV2012Blue'], 502 => [\'Look','LookParametersToneCurvePV2012Blue'] },
	'lookparameterstonecurvepv2012green' => { 500 => [\'Look','LookParametersToneCurvePV2012Green'], 502 => [\'Look','LookParametersToneCurvePV2012Green'] },
	'lookparameterstonecurvepv2012red' => { 500 => [\'Look','LookParametersToneCurvePV2012Red'], 502 => [\'Look','LookParametersToneCurvePV2012Red'] },
	'lookparametersversion' => { 500 => [\'Look','LookParametersVersion'], 502 => [\'Look','LookParametersVersion'] },
	'looksupportsamount' => { 500 => [\'Look','LookSupportsAmount'], 502 => [\'Look','LookSupportsAmount'] },
	'looksupportsmonochrome' => { 500 => [\'Look','LookSupportsMonochrome'], 502 => [\'Look','LookSupportsMonochrome'] },
	'looksupportsoutputreferred' => { 500 => [\'Look','LookSupportsOutputReferred'], 502 => [\'Look','LookSupportsOutputReferred'] },
	'lookuuid' => { 500 => [\'Look','LookUUID'], 502 => [\'Look','LookUUID'] },
	'loop' => { 529 => 'loop' },
	'loopstyle' => { 400 => 'LOOP' },
	'lowestbiostratigraphiczone' => { 118 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 500 => 'LuminanceAdjustmentAqua', 502 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 500 => 'LuminanceAdjustmentBlue', 502 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 500 => 'LuminanceAdjustmentGreen', 502 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 500 => 'LuminanceAdjustmentMagenta', 502 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 500 => 'LuminanceAdjustmentOrange', 502 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 500 => 'LuminanceAdjustmentPurple', 502 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 500 => 'LuminanceAdjustmentRed', 502 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 500 => 'LuminanceAdjustmentYellow', 502 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 108 => 0x150 },
	'luminancecurvepoints' => { 108 => 0x126 },
	'luminancenoiseamplitude' => { 1 => 0x1d },
	'luminancenoisereduction' => { 103 => 0x20600, 109 => 0x5f, 417 => 0x1b },
	'luminancenoisereductioncontrast' => { 500 => 'LuminanceNoiseReductionContrast', 502 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 500 => 'LuminanceNoiseReductionDetail', 502 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 109 => 0x6d },
	'luminancesmoothing' => { 500 => 'LuminanceSmoothing', 502 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 84 => [0x40b,0x40c] },
	'lyrics' => { 392 => "\xa9lyr", 400 => "\xa9lyr", 529 => 'lyrics' },
	'lyricsuri' => { 400 => 'lrcu' },
	'm16cversion' => { 335 => 0x333 },
	'macatom' => { 501 => 'macAtom' },
	'macatomapplicationcode' => { 501 => [\'macAtom','macAtomApplicationCode'] },
	'macatominvocationappleevent' => { 501 => [\'macAtom','macAtomInvocationAppleEvent'] },
	'macatomposixprojectpath' => { 501 => [\'macAtom','macAtomPosixProjectPath'] },
	'machineobservation' => { 118 => 'MachineObservation' },
	'machineobservationday' => { 118 => [\'MachineObservation','MachineObservationDay'] },
	'machineobservationearliestdate' => { 118 => [\'MachineObservation','MachineObservationEarliestDate'] },
	'machineobservationenddayofyear' => { 118 => [\'MachineObservation','MachineObservationEndDayOfYear'] },
	'machineobservationeventdate' => { 118 => [\'MachineObservation','MachineObservationEventDate'] },
	'machineobservationeventid' => { 118 => [\'MachineObservation','MachineObservationEventID'] },
	'machineobservationeventremarks' => { 118 => [\'MachineObservation','MachineObservationEventRemarks'] },
	'machineobservationeventtime' => { 118 => [\'MachineObservation','MachineObservationEventTime'] },
	'machineobservationfieldnotes' => { 118 => [\'MachineObservation','MachineObservationFieldNotes'] },
	'machineobservationfieldnumber' => { 118 => [\'MachineObservation','MachineObservationFieldNumber'] },
	'machineobservationhabitat' => { 118 => [\'MachineObservation','MachineObservationHabitat'] },
	'machineobservationlatestdate' => { 118 => [\'MachineObservation','MachineObservationLatestDate'] },
	'machineobservationmonth' => { 118 => [\'MachineObservation','MachineObservationMonth'] },
	'machineobservationparenteventid' => { 118 => [\'MachineObservation','MachineObservationParentEventID'] },
	'machineobservationsamplesizeunit' => { 118 => [\'MachineObservation','MachineObservationSampleSizeUnit'] },
	'machineobservationsamplesizevalue' => { 118 => [\'MachineObservation','MachineObservationSampleSizeValue'] },
	'machineobservationsamplingeffort' => { 118 => [\'MachineObservation','MachineObservationSamplingEffort'] },
	'machineobservationsamplingprotocol' => { 118 => [\'MachineObservation','MachineObservationSamplingProtocol'] },
	'machineobservationstartdayofyear' => { 118 => [\'MachineObservation','MachineObservationStartDayOfYear'] },
	'machineobservationverbatimeventdate' => { 118 => [\'MachineObservation','MachineObservationVerbatimEventDate'] },
	'machineobservationyear' => { 118 => [\'MachineObservation','MachineObservationYear'] },
	'macro' => { 127 => 0x1020, 129 => 0x202, 151 => 0x2b, 322 => 0x202, 406 => 0x21, 416 => 0x202, 440 => 0xb040 },
	'macroled' => { 320 => 0x120a },
	'macromagnification' => { 7 => 0x1b, 11 => 0x1b, 14 => 0x1b, 15 => 0x1b, 19 => 0x1b, 20 => 0x1b, 57 => 0x10 },
	'macromode' => { 34 => 0x1, 181 => 0xb, 317 => 0x300, 340 => 0x1c, 407 => 0x1009 },
	'magentahsl' => { 103 => 0x20917 },
	'magicfilter' => { 317 => 0x52c },
	'magnifiedview' => { 86 => 0x11, 88 => 0x9 },
	'mainboardversion' => { 138 => 0x438 },
	'maindialexposurecomp' => { 308 => '0.6' },
	'mainingredient' => { 521 => 'mainIngredient' },
	'majorversion' => { 491 => 'MajorVersion' },
	'make' => { 98 => 0x0, 115 => 0x1, 119 => 0x10f, 156 => 'Make', 330 => 'Make', 345 => 0x10f, 394 => 'make', 400 => ['@mak',"\xa9mak"], 518 => 'make', 525 => 'Make' },
	'makernote' => { 506 => 'MakerNote' },
	'makernoteapple' => { 117 => 'MakN', 119 => 0x927c },
	'makernotecanon' => { 117 => 'MakN', 119 => 0x927c },
	'makernotecasio' => { 117 => 'MakN', 119 => 0x927c },
	'makernotecasio2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotedji' => { 117 => 'MakN', 119 => 0x927c },
	'makernotedjiinfo' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteflir' => { 117 => 'MakN', 119 => 0x927c },
	'makernotefujifilm' => { 117 => 'MakN', 119 => 0x927c },
	'makernotege' => { 117 => 'MakN', 119 => 0x927c },
	'makernotege2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotehasselblad' => { 117 => 'MakN', 119 => 0x927c },
	'makernotehp' => { 117 => 'MakN', 119 => 0x927c },
	'makernotehp2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotehp4' => { 117 => 'MakN', 119 => 0x927c },
	'makernotehp6' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteisl' => { 117 => 'MakN', 119 => 0x927c },
	'makernotejvc' => { 117 => 'MakN', 119 => 0x927c },
	'makernotejvctext' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak10' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak11' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak12' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak1a' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak1b' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak3' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak4' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak5' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak6a' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak6b' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak7' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak8a' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak8b' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak8c' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodak9' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekodakunknown' => { 117 => 'MakN', 119 => 0x927c },
	'makernotekyocera' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica10' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica2' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica3' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica4' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica5' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica6' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica7' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica8' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteleica9' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteminolta' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteminolta2' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteminolta3' => { 117 => 'MakN', 119 => 0x927c },
	'makernotemotorola' => { 117 => 'MakN', 119 => 0x927c },
	'makernotenikon' => { 117 => 'MakN', 119 => 0x927c },
	'makernotenikon2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotenikon3' => { 117 => 'MakN', 119 => 0x927c },
	'makernotenintendo' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteoffset' => { 416 => 0xff },
	'makernoteolympus' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteolympus2' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteolympus3' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepanasonic' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepanasonic2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepanasonic3' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepentax' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepentax2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepentax3' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepentax4' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepentax5' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepentax6' => { 117 => 'MakN', 119 => 0x927c },
	'makernotepentaxunknown' => { 400 => 'PXMN' },
	'makernotephaseone' => { 117 => 'MakN', 119 => 0x927c },
	'makernotereconyx' => { 117 => 'MakN', 119 => 0x927c },
	'makernotereconyx2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotereconyx3' => { 117 => 'MakN', 119 => 0x927c },
	'makernotericoh' => { 117 => 'MakN', 119 => 0x927c },
	'makernotericoh2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotericohpentax' => { 117 => 'MakN', 119 => 0x927c },
	'makernotericohtext' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesafety' => { 119 => 0xc635 },
	'makernotesamsung1a' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesamsung1b' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesamsung2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesanyo' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesanyoc4' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesanyopatch' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesigma' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesony' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesony2' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesony3' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesony4' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesony5' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesonyericsson' => { 117 => 'MakN', 119 => 0x927c },
	'makernotesonysrf' => { 117 => 'MakN', 119 => 0x927c },
	'makernotetype' => { 407 => 0x1 },
	'makernoteunknown' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteunknownbinary' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteunknowntext' => { 117 => 'MakN', 119 => 0x927c },
	'makernoteversion' => { 1 => 0x1, 186 => 0x0, 234 => 0x1, 322 => 0x0, 340 => 0x8000, 411 => 0x0, 414 => 0x1, 417 => [0x1d,0x1f], 430 => 0x2000 },
	'makerurl' => { 400 => "\xa9mal" },
	'managedfrom' => { 530 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 530 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 530 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 530 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 530 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 530 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 530 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfromlasturl' => { 530 => [\'ManagedFrom','ManagedFromLastURL'] },
	'managedfromlinkcategory' => { 530 => [\'ManagedFrom','ManagedFromLinkCategory'] },
	'managedfromlinkform' => { 530 => [\'ManagedFrom','ManagedFromLinkForm'] },
	'managedfrommanager' => { 530 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 530 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 530 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 530 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 530 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 530 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 530 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromplacedresolutionunit' => { 530 => [\'ManagedFrom','ManagedFromPlacedResolutionUnit'] },
	'managedfromplacedxresolution' => { 530 => [\'ManagedFrom','ManagedFromPlacedXResolution'] },
	'managedfromplacedyresolution' => { 530 => [\'ManagedFrom','ManagedFromPlacedYResolution'] },
	'managedfromrenditionclass' => { 530 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 530 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 530 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 530 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 530 => 'Manager' },
	'managervariant' => { 530 => 'ManagerVariant' },
	'manageto' => { 530 => 'ManageTo' },
	'manageui' => { 530 => 'ManageUI' },
	'manifest' => { 530 => 'Manifest' },
	'manifestlinkform' => { 530 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 530 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 530 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 530 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 530 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 530 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 530 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 530 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 530 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 530 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 530 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencelasturl' => { 530 => [\'Manifest','ManifestReferenceLastURL'] },
	'manifestreferencelinkcategory' => { 530 => [\'Manifest','ManifestReferenceLinkCategory'] },
	'manifestreferencelinkform' => { 530 => [\'Manifest','ManifestReferenceLinkForm'] },
	'manifestreferencemanager' => { 530 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 530 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 530 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 530 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 530 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 530 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 530 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferenceplacedresolutionunit' => { 530 => [\'Manifest','ManifestReferencePlacedResolutionUnit'] },
	'manifestreferenceplacedxresolution' => { 530 => [\'Manifest','ManifestReferencePlacedXResolution'] },
	'manifestreferenceplacedyresolution' => { 530 => [\'Manifest','ManifestReferencePlacedYResolution'] },
	'manifestreferencerenditionclass' => { 530 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 530 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 530 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 530 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 317 => 0x900, 340 => 0x86 },
	'manometerreading' => { 317 => 0x901 },
	'manualafpointselectpattern' => { 84 => 0x513 },
	'manualafpointselpattern' => { 2 => 0xf },
	'manualflash' => { 320 => 0x1209 },
	'manualflashoutput' => { 34 => 0x29, 299 => '8.2', 302 => '22.2', 303 => '23.1', 304 => '23.2', 306 => '16.2', 307 => '23.2', 308 => '8.2', 309 => '23.2', 312 => '24.2', 407 => 0x100c },
	'manualflashstrength' => { 317 => 0x406 },
	'manualfocusdistance' => { 234 => 0x85, 322 => 0x100c, 416 => 0x223 },
	'manualfocuspointillumination' => { 313 => 0x17, 314 => 0x17, 315 => 0x17 },
	'manualfocusringinafmode' => { 313 => 0x1a, 314 => 0x1a, 315 => 0x1a },
	'manualtv' => { 83 => 0x5, 84 => 0x705 },
	'manufacturedate' => { 191 => 0x6705, 355 => 0x1 },
	'manufacturedate1' => { 409 => 0x4 },
	'manufacturedate2' => { 409 => 0x5 },
	'manufacturer' => { 485 => 'Manufacturer', 518 => 'manufacturer' },
	'mariahchromablursize' => { 138 => 0xf0d },
	'mariahmaphithreshold' => { 138 => 0xf0c },
	'mariahmaplothreshold' => { 138 => 0xf0b },
	'mariahsigmathreshold' => { 138 => 0xf0e },
	'mariahtexturethreshold' => { 138 => 0xf0a },
	'marked' => { 516 => 'Marked', 533 => 'Marked' },
	'markers' => { 529 => 'markers' },
	'markerscomment' => { 529 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 529 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 529 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 529 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 529 => [\'markers','markersCuePointType'] },
	'markersduration' => { 529 => [\'markers','markersDuration'] },
	'markerslocation' => { 529 => [\'markers','markersLocation'] },
	'markersname' => { 529 => [\'markers','markersName'] },
	'markersprobability' => { 529 => [\'markers','markersProbability'] },
	'markersspeaker' => { 529 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 529 => [\'markers','markersStartTime'] },
	'markerstarget' => { 529 => [\'markers','markersTarget'] },
	'markerstype' => { 529 => [\'markers','markersType'] },
	'maskedareas' => { 119 => 0xc68e },
	'maskgroupbasedcorractive' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionActive'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionActive'] },
	'maskgroupbasedcorramount' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionAmount'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionAmount'] },
	'maskgroupbasedcorrblacks2012' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBlacks2012'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBlacks2012'] },
	'maskgroupbasedcorrbrightness' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBrightness'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBrightness'] },
	'maskgroupbasedcorrclarity' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity'] },
	'maskgroupbasedcorrclarity2012' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity2012'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity2012'] },
	'maskgroupbasedcorrcontrast' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast'] },
	'maskgroupbasedcorrcontrast2012' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast2012'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast2012'] },
	'maskgroupbasedcorrcorrectionname' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionName'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionName'] },
	'maskgroupbasedcorrcorrectionsyncid' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionSyncID'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionSyncID'] },
	'maskgroupbasedcorrdefringe' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDefringe'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDefringe'] },
	'maskgroupbasedcorrdehaze' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDehaze'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDehaze'] },
	'maskgroupbasedcorrections' => { 500 => 'MaskGroupBasedCorrections', 502 => 'MaskGroupBasedCorrections' },
	'maskgroupbasedcorrexposure' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure'] },
	'maskgroupbasedcorrexposure2012' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure2012'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure2012'] },
	'maskgroupbasedcorrhighlights2012' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHighlights2012'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHighlights2012'] },
	'maskgroupbasedcorrhue' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHue'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHue'] },
	'maskgroupbasedcorrluminancenoise' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalLuminanceNoise'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalLuminanceNoise'] },
	'maskgroupbasedcorrmask' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasks'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasks'] },
	'maskgroupbasedcorrmaskalpha' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAlpha'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAlpha'] },
	'maskgroupbasedcorrmaskangle' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAngle'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAngle'] },
	'maskgroupbasedcorrmaskbottom' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksBottom'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksBottom'] },
	'maskgroupbasedcorrmaskcentervalue' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterValue'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterValue'] },
	'maskgroupbasedcorrmaskcenterweight' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterWeight'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterWeight'] },
	'maskgroupbasedcorrmaskdabs' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksDabs'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksDabs'] },
	'maskgroupbasedcorrmaskfeather' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFeather'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFeather'] },
	'maskgroupbasedcorrmaskflipped' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlipped'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlipped'] },
	'maskgroupbasedcorrmaskflow' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlow'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlow'] },
	'maskgroupbasedcorrmaskfullx' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullX'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullX'] },
	'maskgroupbasedcorrmaskfully' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullY'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullY'] },
	'maskgroupbasedcorrmaskinputdigest' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksInputDigest'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksInputDigest'] },
	'maskgroupbasedcorrmaskleft' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksLeft'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksLeft'] },
	'maskgroupbasedcorrmaskmaskactive' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskActive'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskActive'] },
	'maskgroupbasedcorrmaskmaskblendmode' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskBlendMode'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'maskgroupbasedcorrmaskmaskdigest' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskDigest'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskDigest'] },
	'maskgroupbasedcorrmaskmaskinverted' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskInverted'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskInverted'] },
	'maskgroupbasedcorrmaskmaskname' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskName'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskName'] },
	'maskgroupbasedcorrmaskmasks' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasks'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasks'] },
	'maskgroupbasedcorrmaskmasksalpha' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAlpha'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'maskgroupbasedcorrmaskmasksangle' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAngle'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAngle'] },
	'maskgroupbasedcorrmaskmasksbottom' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksBottom'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksBottom'] },
	'maskgroupbasedcorrmaskmaskscentervalue' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterValue'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'maskgroupbasedcorrmaskmaskscenterweight' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterWeight'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'maskgroupbasedcorrmaskmasksdabs' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksDabs'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksDabs'] },
	'maskgroupbasedcorrmaskmasksfeather' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFeather'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFeather'] },
	'maskgroupbasedcorrmaskmasksflipped' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlipped'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'maskgroupbasedcorrmaskmasksflow' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlow'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlow'] },
	'maskgroupbasedcorrmaskmasksfullx' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullX'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullX'] },
	'maskgroupbasedcorrmaskmasksfully' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullY'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullY'] },
	'maskgroupbasedcorrmaskmasksinputdigest' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksInputDigest'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'maskgroupbasedcorrmaskmasksleft' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksLeft'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksLeft'] },
	'maskgroupbasedcorrmaskmasksmaskactive' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskActive'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'maskgroupbasedcorrmaskmasksmaskblendmode' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'maskgroupbasedcorrmaskmasksmaskdigest' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskDigest'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'maskgroupbasedcorrmaskmasksmaskinverted' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskInverted'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'maskgroupbasedcorrmaskmasksmaskname' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskName'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'maskgroupbasedcorrmaskmasksmasksubtype' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSubType'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'maskgroupbasedcorrmaskmasksmasksyncid' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'maskgroupbasedcorrmaskmasksmaskversion' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskVersion'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'maskgroupbasedcorrmaskmasksmidpoint' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMidpoint'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'maskgroupbasedcorrmaskmasksorigin' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksOrigin'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'maskgroupbasedcorrmaskmasksperimetervalue' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'maskgroupbasedcorrmaskmasksradius' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRadius'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRadius'] },
	'maskgroupbasedcorrmaskmasksreferencepoint' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksReferencePoint'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'maskgroupbasedcorrmaskmasksright' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRight'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRight'] },
	'maskgroupbasedcorrmaskmasksroundness' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRoundness'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'maskgroupbasedcorrmaskmaskssizex' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeX'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'maskgroupbasedcorrmaskmaskssizey' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeY'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'maskgroupbasedcorrmaskmaskstop' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksTop'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksTop'] },
	'maskgroupbasedcorrmaskmasksubtype' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSubType'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSubType'] },
	'maskgroupbasedcorrmaskmasksvalue' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskValue'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'maskgroupbasedcorrmaskmasksversion' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksVersion'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksVersion'] },
	'maskgroupbasedcorrmaskmaskswhat' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWhat'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWhat'] },
	'maskgroupbasedcorrmaskmaskswholeimagearea' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'maskgroupbasedcorrmaskmasksx' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksX'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksX'] },
	'maskgroupbasedcorrmaskmasksy' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksY'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksY'] },
	'maskgroupbasedcorrmaskmasksyncid' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSyncID'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'maskgroupbasedcorrmaskmaskszerox' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroX'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'maskgroupbasedcorrmaskmaskszeroy' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroY'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'maskgroupbasedcorrmaskmaskversion' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskVersion'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskVersion'] },
	'maskgroupbasedcorrmaskmidpoint' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMidpoint'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMidpoint'] },
	'maskgroupbasedcorrmaskorigin' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksOrigin'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksOrigin'] },
	'maskgroupbasedcorrmaskperimetervalue' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksPerimeterValue'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'maskgroupbasedcorrmaskradius' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRadius'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRadius'] },
	'maskgroupbasedcorrmaskrange' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'maskgroupbasedcorrmaskrangeareamodels' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'maskgroupbasedcorrmaskrangeareamodelscolorsampleinfo' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'maskgroupbasedcorrmaskrangeareamodelscomponents' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'maskgroupbasedcorrmaskrangecoloramount' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'maskgroupbasedcorrmaskrangedepthfeather' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'maskgroupbasedcorrmaskrangedepthmax' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'maskgroupbasedcorrmaskrangedepthmin' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'maskgroupbasedcorrmaskrangeinvert' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'maskgroupbasedcorrmaskrangelumfeather' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'maskgroupbasedcorrmaskrangeluminancedepthsampleinfo' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'maskgroupbasedcorrmaskrangelummax' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'maskgroupbasedcorrmaskrangelummin' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'maskgroupbasedcorrmaskrangelumrange' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'maskgroupbasedcorrmaskrangesampletype' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'maskgroupbasedcorrmaskrangetype' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'maskgroupbasedcorrmaskrangeversion' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'maskgroupbasedcorrmaskreferencepoint' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksReferencePoint'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksReferencePoint'] },
	'maskgroupbasedcorrmaskright' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRight'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRight'] },
	'maskgroupbasedcorrmaskroundness' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRoundness'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRoundness'] },
	'maskgroupbasedcorrmasksizex' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeX'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeX'] },
	'maskgroupbasedcorrmasksizey' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeY'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeY'] },
	'maskgroupbasedcorrmasktop' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksTop'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksTop'] },
	'maskgroupbasedcorrmaskvalue' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskValue'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskValue'] },
	'maskgroupbasedcorrmaskversion' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksVersion'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksVersion'] },
	'maskgroupbasedcorrmaskwhat' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWhat'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWhat'] },
	'maskgroupbasedcorrmaskwholeimagearea' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWholeImageArea'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'maskgroupbasedcorrmaskx' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksX'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksX'] },
	'maskgroupbasedcorrmasky' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksY'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksY'] },
	'maskgroupbasedcorrmaskzerox' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroX'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroX'] },
	'maskgroupbasedcorrmaskzeroy' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroY'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroY'] },
	'maskgroupbasedcorrmoire' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalMoire'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalMoire'] },
	'maskgroupbasedcorrrangemask' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMask'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMask'] },
	'maskgroupbasedcorrrangemaskareamodels' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModels'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'maskgroupbasedcorrrangemaskareamodelscolorsampleinfo' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'maskgroupbasedcorrrangemaskareamodelscomponents' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'maskgroupbasedcorrrangemaskcoloramount' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskColorAmount'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'maskgroupbasedcorrrangemaskdepthfeather' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthFeather'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'maskgroupbasedcorrrangemaskdepthmax' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMax'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'maskgroupbasedcorrrangemaskdepthmin' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMin'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'maskgroupbasedcorrrangemaskinvert' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskInvert'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskInvert'] },
	'maskgroupbasedcorrrangemasklumfeather' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumFeather'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'maskgroupbasedcorrrangemaskluminancedepthsampleinfo' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'maskgroupbasedcorrrangemasklummax' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMax'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'maskgroupbasedcorrrangemasklummin' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMin'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'maskgroupbasedcorrrangemasklumrange' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumRange'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'maskgroupbasedcorrrangemasksampletype' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskSampleType'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'maskgroupbasedcorrrangemasktype' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskType'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskType'] },
	'maskgroupbasedcorrrangemaskversion' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskVersion'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskVersion'] },
	'maskgroupbasedcorrsaturation' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSaturation'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSaturation'] },
	'maskgroupbasedcorrshadows2012' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalShadows2012'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalShadows2012'] },
	'maskgroupbasedcorrsharpness' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSharpness'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSharpness'] },
	'maskgroupbasedcorrtemperature' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTemperature'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTemperature'] },
	'maskgroupbasedcorrtexture' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTexture'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTexture'] },
	'maskgroupbasedcorrtint' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTint'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTint'] },
	'maskgroupbasedcorrtoninghue' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningHue'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningHue'] },
	'maskgroupbasedcorrtoningsaturation' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningSaturation'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningSaturation'] },
	'maskgroupbasedcorrwhat' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsWhat'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsWhat'] },
	'maskgroupbasedcorrwhites2012' => { 500 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalWhites2012'], 502 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalWhites2012'] },
	'masterdocumentid' => { 131 => 0xb9 },
	'mastergain' => { 257 => 0x50 },
	'materialsample' => { 118 => 'MaterialSample' },
	'materialsampleid' => { 118 => [\'MaterialSample','MaterialSampleMaterialSampleID'] },
	'matrixmetering' => { 298 => '50.1', 300 => '48.1', 301 => '48.1', 310 => '48.1', 311 => '48.1', 313 => 0x233, 314 => 0x233, 315 => 0x24b },
	'matrixselectk' => { 138 => 0x91b },
	'matrixselectthreshold' => { 138 => 0x91a },
	'matrixselectthreshold1' => { 138 => 0x91e },
	'matrixselectthreshold2' => { 138 => 0x91f },
	'matrixstructure' => { 399 => 0xa },
	'maxaperture' => { 34 => 0x1a, 138 => 0x3f9, 144 => 0x6103, 163 => 'MaxAperture', 181 => 0x17, 187 => 0x49c5, 232 => 0x36, 318 => 0x20a, 366 => '14.1' },
	'maxapertureatmaxfocal' => { 127 => 0x1407, 163 => 'MaxApertureAtMaxFocal', 226 => 0xb, 227 => 0x10, 228 => 0x11, 232 => 0x12, 318 => 0x206 },
	'maxapertureatminfocal' => { 127 => 0x1406, 226 => 0xa, 227 => 0xf, 228 => 0x10, 232 => 0x11, 318 => 0x205 },
	'maxaperturevalue' => { 119 => 0x9205, 384 => 0x414, 506 => 'MaxApertureValue' },
	'maxavailheight' => { 514 => 'MaxAvailHeight' },
	'maxavailwidth' => { 514 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 297 => 0xb, 298 => 0xc, 300 => '12.1', 301 => '12.1', 306 => 0xc, 307 => 0xb, 310 => '12.1', 311 => '12.1', 313 => 0x3d, 314 => 0x3d, 315 => 0x3d },
	'maxfaces' => { 321 => 0x1202 },
	'maxfocallength' => { 7 => 0xe6, 8 => 0x10, 9 => 0x1ab, 10 => 0x13, 11 => 0x115, 12 => 0x13, 13 => 0x153, 14 => 0xda, 16 => 0xfa, 17 => 0xee, 18 => 0x103, 19 => 0x95, 20 => 0xea, 21 => 0x157, 22 => 0xee, 23 => 0xec, 24 => 0x12b, 25 => 0x165, 26 => 0x16a, 27 => 0x188, 28 => 0x116, 29 => 0x18d, 34 => 0x17, 127 => 0x1405, 163 => 'MaxFocalLength', 226 => 0x9, 227 => 0xe, 228 => 0xf, 232 => 0x10, 318 => 0x208, 453 => 0x127c, 454 => 0x1138, 455 => 0x330, 456 => 0x330, 457 => 0x30e },
	'maximumdensityrange' => { 133 => 0x8c },
	'maxpagesize' => { 534 => 'MaxPageSize' },
	'maxpagesizeh' => { 534 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 534 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 534 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxpixelvaluethreshold' => { 138 => 0xc7d },
	'maxsamplevalue' => { 119 => 0x119 },
	'maxstorage' => { 524 => 'maxstorage' },
	'mb-d10batteries' => { 297 => '12.6' },
	'mb-d10batterytype' => { 306 => '13.3' },
	'mb-d11batterytype' => { 307 => '2.3' },
	'mb-d12batterytype' => { 310 => '3.2' },
	'mb-d80batteries' => { 308 => '6.5' },
	'mb-d80batterytype' => { 312 => '3.2' },
	'mcuversion' => { 226 => 0xc, 227 => 0x11, 228 => 0x12, 232 => 0x13 },
	'md5digest' => { 164 => 'zmd5' },
	'mditemfindercomment' => { 173 => 'MDItemFinderComment' },
	'mditemfscreationdate' => { 173 => 'MDItemFSCreationDate' },
	'mditemfslabel' => { 173 => 'MDItemFSLabel' },
	'mditemusertags' => { 173 => 'MDItemUserTags' },
	'meal' => { 521 => 'meal' },
	'measuredev' => { 28 => 0x9, 77 => 0x3, 97 => 0x1814, 156 => 'MeasuredEV' },
	'measuredev2' => { 13 => 0x8, 28 => 0x8, 77 => 0x17 },
	'measuredev3' => { 13 => 0x9 },
	'measuredlv' => { 187 => 0x690, 335 => 0x312, 338 => 0x312, 339 => 0x312, 342 => 0x3407 },
	'measuredrggb' => { 65 => 0x1 },
	'measuredrggbdata' => { 44 => 0x287 },
	'measurementaccuracy' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 118 => 'MeasurementOrFact' },
	'measurementremarks' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 118 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'measuretype' => { 485 => 'MeasureType' },
	'mechanicalshuttercount' => { 234 => 0x37 },
	'mediaclassprimaryid' => { 179 => 'WM/MediaClassPrimaryID' },
	'mediaclasssecondaryid' => { 179 => 'WM/MediaClassSecondaryID' },
	'mediaconstraints' => { 327 => 'MediaConstraints' },
	'mediacreatedate' => { 396 => 0x1 },
	'mediaeventiddate' => { 490 => 'MediaEventIdDate' },
	'mediamodifydate' => { 396 => 0x2 },
	'mediasummarycode' => { 327 => 'MediaSummaryCode' },
	'mediatype' => { 392 => 'stik' },
	'memoaudioquality' => { 84 => 0x812 },
	'memorycardconfiguration' => { 433 => 0x16 },
	'memorycardnumber' => { 211 => 0x2 },
	'menubuttondisplayposition' => { 82 => 0xb, 85 => 0xa, 86 => 0xb, 89 => 0xb },
	'menubuttonreturn' => { 90 => 0xb },
	'menumonitorofftime' => { 297 => '26.1', 298 => '22.1', 300 => '22.1', 301 => '22.1', 305 => '21.1', 306 => '8.2', 307 => '21.1', 310 => '22.1', 311 => '22.1', 312 => '22.1', 313 => 0x35, 314 => 0x35, 315 => 0x35 },
	'metadataauthority' => { 514 => 'metadataAuthority' },
	'metadataauthorityidentifier' => { 514 => [\'metadataAuthority','metadataAuthorityIdentifier'] },
	'metadataauthorityname' => { 514 => [\'metadataAuthority','metadataAuthorityName'] },
	'metadatadate' => { 527 => 'MetadataDate' },
	'metadataeditingsoftware' => { 119 => 0xa43c },
	'metadatalastedited' => { 514 => 'metadataLastEdited' },
	'metadatalasteditor' => { 514 => 'metadataLastEditor' },
	'metadatalasteditoridentifier' => { 514 => [\'metadataLastEditor','metadataLastEditorIdentifier'] },
	'metadatalasteditorname' => { 514 => [\'metadataLastEditor','metadataLastEditorName'] },
	'metadatamoddate' => { 529 => 'metadataModDate' },
	'metaversion' => { 448 => 0x34 },
	'meterinfo1row1' => { 441 => 0x0, 442 => 0x0 },
	'meterinfo1row2' => { 441 => 0x6c, 442 => 0x5a },
	'meterinfo1row3' => { 441 => 0xd8, 442 => 0xb4 },
	'meterinfo1row4' => { 441 => 0x144, 442 => 0x10e },
	'meterinfo1row5' => { 441 => 0x1b0, 442 => 0x168 },
	'meterinfo1row6' => { 441 => 0x21c, 442 => 0x1c2 },
	'meterinfo1row7' => { 441 => 0x288, 442 => 0x21c },
	'meterinfo2row1' => { 441 => 0x2f4, 442 => 0x276 },
	'meterinfo2row2' => { 441 => 0x378, 442 => 0x2e4 },
	'meterinfo2row3' => { 441 => 0x3fc, 442 => 0x352 },
	'meterinfo2row4' => { 441 => 0x480, 442 => 0x3c0 },
	'meterinfo2row5' => { 441 => 0x504, 442 => 0x42e },
	'meterinfo2row6' => { 441 => 0x588, 442 => 0x49c },
	'meterinfo2row7' => { 441 => 0x60c, 442 => 0x50a },
	'meterinfo2row8' => { 441 => 0x690, 442 => 0x578 },
	'meterinfo2row9' => { 441 => 0x714, 442 => 0x5e6 },
	'metering' => { 299 => '6.1' },
	'meteringmode' => { 34 => 0x11, 119 => 0x9207, 140 => 0x1c, 181 => 0x7, 182 => 0x25, 184 => 0x12, 317 => 0x202, 375 => 0x17, 417 => 0x9, 427 => 0x15, 428 => 0x13, 429 => 0x7, 445 => 0x3, 449 => 0x1174, 450 => 0x1178, 451 => 0x1154, 452 => 0x11d0, 453 => 0x11ac, 454 => 0x1064, 455 => 0x25c, 456 => 0x25c, 457 => 0x24b, 506 => 'MeteringMode' },
	'meteringmode2' => { 356 => '2.1', 440 => 0x202c },
	'meteringmode3' => { 356 => '16.1' },
	'meteringoffscaleindicator' => { 184 => 0x53 },
	'meteringtime' => { 297 => '22.2', 299 => '3.2', 302 => '17.1', 303 => '18.1', 306 => '7.3', 307 => '18.1', 308 => '3.2', 312 => '19.1' },
	'micro1version' => { 402 => 0x1f },
	'micro2version' => { 402 => 0x2d },
	'microphoneattenuator' => { 239 => 0x34e, 240 => 0x2d2, 241 => 0x2fa, 242 => 0x2fa },
	'microphonefrequencyresponse' => { 239 => 0x350, 240 => 0x2d4, 241 => 0x2fc, 242 => 0x2fc },
	'microphonejackpower' => { 239 => 0x376, 240 => 0x2fa, 241 => 0x322, 242 => 0x322 },
	'microphonesensitivity' => { 239 => 0x34c, 240 => 0x2d0, 241 => 0x2f8, 242 => 0x2f8 },
	'microvideo' => { 483 => 'MicroVideo' },
	'microvideooffset' => { 483 => 'MicroVideoOffset' },
	'microvideopresentationtimestampus' => { 483 => 'MicroVideoPresentationTimestampUs' },
	'microvideoversion' => { 483 => 'MicroVideoVersion' },
	'midrangesharpness' => { 251 => 0x3b },
	'mieversion' => { 164 => '0Vers' },
	'mime' => { 485 => 'Mime' },
	'minaperture' => { 34 => 0x1b, 138 => 0x3f8, 163 => 'MinAperture', 366 => '0.2' },
	'minaperturevalue' => { 384 => 0x415 },
	'minfocallength' => { 7 => 0xe4, 8 => 0xe, 9 => 0x1a9, 10 => 0x11, 11 => 0x113, 12 => 0x11, 13 => 0x151, 14 => 0xd8, 16 => 0xf8, 17 => 0xec, 18 => 0x101, 19 => 0x93, 20 => 0xe8, 21 => 0x155, 22 => 0xec, 23 => 0xea, 24 => 0x129, 25 => 0x163, 26 => 0x168, 27 => 0x186, 28 => 0x114, 29 => 0x18b, 34 => 0x18, 127 => 0x1404, 163 => 'MinFocalLength', 226 => 0x8, 227 => 0xd, 228 => 0xe, 232 => 0xf, 318 => 0x207, 453 => 0x127a, 454 => 0x1136, 455 => 0x32e, 456 => 0x32e, 457 => 0x30c },
	'minfocusdistance' => { 366 => 0x3 },
	'minimumiso' => { 340 => 0xe8 },
	'minintegrationrows' => { 138 => 0x1874 },
	'minoltadate' => { 181 => 0x15 },
	'minoltaimagesize' => { 181 => 0x4, 182 => 0xc, 183 => 0x2, 186 => 0x103 },
	'minoltamodelid' => { 181 => 0x25 },
	'minoltaquality' => { 181 => 0x5, 182 => 0xd, 183 => 0x3, 186 => [0x102,0x103] },
	'minoltatime' => { 181 => 0x16 },
	'minormodelagedisclosure' => { 327 => 'MinorModelAgeDisclosure' },
	'minorversion' => { 491 => 'MinorVersion' },
	'minsamplevalue' => { 119 => 0x118 },
	'mirrorlockup' => { 82 => 0xc, 83 => 0xc, 84 => 0x60f, 85 => 0xb, 86 => 0xc, 87 => 0x6, 88 => 0x6, 89 => 0xc, 90 => 0x3 },
	'mobilecountrycode' => { 499 => 'mcc' },
	'mobilenetworkcode' => { 499 => 'mnc' },
	'moddate' => { 330 => 'modify-date', 516 => 'ModDate' },
	'modedialposition' => { 433 => 0x14 },
	'model' => { 98 => 0x6, 119 => 0x110, 156 => 'Model', 330 => 'Model', 345 => 0x110, 375 => 0x23f, 394 => 'model', 400 => ['@mod','CNMN','cmnm',"\xa9mdl","\xa9mod"], 417 => 0x84, 485 => 'Model', 518 => 'model', 525 => 'Model' },
	'modelage' => { 514 => 'ModelAge' },
	'modelid' => { 316 => 0x0 },
	'modelingflash' => { 297 => '21.4', 298 => '31.1', 300 => '31.1', 301 => '31.1', 306 => '26.4', 307 => '30.2', 308 => '7.4', 309 => '30.1', 310 => '31.1', 311 => '31.1', 312 => '31.3', 313 => 0x5d, 314 => 0x5d, 315 => 0x5d },
	'modelreleaseid' => { 327 => 'ModelReleaseID' },
	'modelreleasestatus' => { 327 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 463 => 0x52, 464 => 0x46, 465 => 0x53 },
	'modeltiepoint' => { 119 => 0x8482 },
	'modeltransform' => { 119 => 0x85d8 },
	'modelyear' => { 518 => 'modelYear' },
	'modificationdate' => { 519 => 'modificationDate' },
	'modifiedcolortemp' => { 66 => 0x9 },
	'modifieddigitalgain' => { 66 => 0xb },
	'modifiedparamflag' => { 58 => 0x1 },
	'modifiedpicturestyle' => { 66 => 0xa },
	'modifiedsaturation' => { 317 => 0x504 },
	'modifiedsensorbluelevel' => { 66 => 0x5 },
	'modifiedsensorredlevel' => { 66 => 0x4 },
	'modifiedsharpness' => { 66 => 0x2 },
	'modifiedsharpnessfreq' => { 66 => 0x3 },
	'modifiedtonecurve' => { 66 => 0x1 },
	'modifiedwhitebalance' => { 66 => 0x8 },
	'modifiedwhitebalanceblue' => { 66 => 0x7 },
	'modifiedwhitebalancered' => { 66 => 0x6 },
	'modifydate' => { 119 => 0x132, 157 => 'ModifyDate', 326 => 'ModDate', 328 => 'tIME', 391 => 'ModDate', 397 => 0x2, 527 => 'ModifyDate' },
	'moirefilter' => { 119 => 0xfe58, 500 => 'MoireFilter', 502 => 'MoireFilter' },
	'monitorbrightness' => { 239 => 0x69a, 240 => 0x59a, 241 => 0x5ca, 242 => 0x5e2 },
	'monitordisplayoff' => { 184 => 0x4c },
	'monitormatrix' => { 138 => 0x8fc },
	'monitorofftime' => { 297 => '18.2', 299 => '3.1', 308 => '3.1' },
	'monochromecolor' => { 317 => 0x53b },
	'monochromecontrast' => { 109 => 0x3c },
	'monochromefiltereffect' => { 103 => 0x20307, 109 => 0x3a, 340 => 0xac, 375 => 0x73 },
	'monochromegraineffect' => { 340 => 0xd2 },
	'monochromelinear' => { 109 => 0x3d },
	'monochromeoutputhighlightpoint' => { 109 => 0x41 },
	'monochromeoutputshadowpoint' => { 109 => 0x42 },
	'monochromeprofilesettings' => { 317 => 0x537 },
	'monochromerawhighlight' => { 109 => 0x7a },
	'monochromerawhighlightpoint' => { 109 => 0x3f },
	'monochromerawshadow' => { 109 => 0x83 },
	'monochromerawshadowpoint' => { 109 => 0x40 },
	'monochromesharpness' => { 109 => 0x3e },
	'monochrometoning' => { 375 => 0x74 },
	'monochrometoningeffect' => { 103 => 0x20306, 109 => 0x3b },
	'monochromeunsharpmaskfineness' => { 109 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 109 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 109 => 0xb4 },
	'monochromevignetting' => { 317 => 0x53a },
	'monthdaycreated' => { 140 => 0x12, 149 => 0xe },
	'mood' => { 179 => 'WM/Mood' },
	'moonphase' => { 401 => 0x12, 402 => 0x43, 403 => 0x4c },
	'morepermissions' => { 498 => 'morePermissions' },
	'motionphotovideo' => { 395 => 'mpvd' },
	'motionsensitivity' => { 401 => 0x29, 403 => 0x60 },
	'movementcount' => { 392 => "\xa9mvc" },
	'movementname' => { 392 => "\xa9mvn" },
	'movementnumber' => { 392 => "\xa9mvi" },
	'movieactived-lighting' => { 238 => 0x238, 239 => 0x334, 240 => 0x2b8, 241 => 0x2e0, 242 => 0x2e0 },
	'movieaelockbuttonassignment' => { 310 => '40.1' },
	'movieaf-onbutton' => { 313 => 0xcb, 314 => 0xcb, 315 => 0xcb },
	'movieafareamode' => { 239 => 0x342, 240 => 0x2c6, 241 => 0x2ee, 242 => 0x2ee, 313 => 0x203, 314 => 0x203, 315 => 0x21b },
	'movieafspeed' => { 313 => 0xdd, 314 => 0xdd, 315 => 0xdd },
	'movieafspeedapply' => { 313 => 0xdf, 314 => 0xdf, 315 => 0xdf },
	'movieaftrackingsensitivity' => { 313 => 0xe1, 314 => 0xe1, 315 => 0xe1 },
	'movieaperturelock' => { 313 => 0x259, 314 => 0x259, 315 => 0x271 },
	'movieautodistortioncontrol' => { 238 => 0x242 },
	'moviediffractioncompensation' => { 238 => 0x241 },
	'moviedxcropalert' => { 239 => 0x377, 240 => 0x2fb, 241 => 0x323, 242 => 0x323 },
	'movieelectronicvr' => { 239 => 0x348, 240 => 0x2cc, 241 => 0x2f4, 242 => 0x2f4 },
	'movieevfgrid' => { 313 => 0x21d, 314 => 0x21d, 315 => 0x235 },
	'movieflickerreduction' => { 239 => 0x33c, 240 => 0x2c0, 241 => 0x2e8, 242 => 0x2e8 },
	'moviefocusmode' => { 238 => 0x248, 239 => 0x340, 240 => 0x2c4, 241 => 0x2ec, 242 => 0x2ec },
	'moviefocuspointlock' => { 313 => 0x226, 314 => 0x226, 315 => 0x23e },
	'movieframerate' => { 238 => 0x1f8, 239 => 0x374, 240 => 0x2f4, 241 => 0x31c, 242 => 0x31c },
	'movieframesize' => { 238 => 0x1f6, 239 => 0x372, 240 => 0x2f2, 241 => 0x31a, 242 => 0x31a },
	'moviefunc1button' => { 300 => '41.1', 301 => '41.1', 311 => '41.1', 313 => 0xc3, 314 => 0xc3, 315 => 0xc3 },
	'moviefunc2button' => { 313 => 0xc7, 314 => 0xc7, 315 => 0xc7 },
	'moviefunc3button' => { 314 => 0x127, 315 => 0x13f },
	'moviefunctionbutton' => { 298 => '41.1', 310 => '41.1' },
	'moviefunctionbuttonplusdials' => { 298 => '52.1' },
	'moviehighisonoisereduction' => { 238 => 0x23c, 239 => 0x336, 240 => 0x2ba, 241 => 0x2e2, 242 => 0x2e2 },
	'moviehighlightdisplaythreshold' => { 313 => 0x215, 314 => 0x215, 315 => 0x22d },
	'moviehighreszoom' => { 239 => 0x380, 241 => 0x32c, 242 => 0x32c },
	'movieimagearea' => { 239 => 0x2da, 240 => 0x25c, 241 => 0x286, 242 => 0x286 },
	'movieisoautocontrolmanualmode' => { 239 => 0x2e8, 240 => 0x26a, 241 => 0x294, 242 => 0x294 },
	'movieisoautohilimit' => { 239 => 0x2e6, 240 => 0x268, 241 => 0x292, 242 => 0x292 },
	'movieisoautomanualmode' => { 238 => 0x204, 239 => 0x2ea, 240 => 0x26c, 241 => 0x296, 242 => 0x296 },
	'movielenscontrolring' => { 313 => 0xd7, 314 => 0xd7, 315 => 0xd7 },
	'moviemeteringmode' => { 239 => 0x33e, 240 => 0x2c2, 241 => 0x2ea, 242 => 0x2ea },
	'moviemidtonedisplayrange' => { 313 => 0x219, 314 => 0x219, 315 => 0x231 },
	'moviemidtonedisplayvalue' => { 313 => 0x217, 314 => 0x217, 315 => 0x22f },
	'moviemultiselector' => { 313 => 0xd9, 314 => 0xcf, 315 => 0xcf },
	'moviepreviewbutton' => { 298 => '41.2', 300 => '41.2', 301 => '41.2', 310 => '41.2', 311 => '41.2' },
	'moviepreviewbuttonplusdials' => { 298 => '52.2' },
	'movierecordbuttonplaybackmode' => { 313 => 0x1b5, 314 => 0x1b5, 315 => 0x1cd },
	'movieshutterbutton' => { 298 => '38.3', 300 => '38.3', 301 => '38.3', 310 => '38.3', 311 => '38.3' },
	'movieshutterspeedlock' => { 313 => 0x225, 314 => 0x225, 315 => 0x23d },
	'movieslowmotion' => { 238 => 0x1fa },
	'moviesoundrecording' => { 239 => 0x34a, 240 => 0x2ce, 241 => 0x2f6, 242 => 0x2f6 },
	'moviesubjectdetection' => { 239 => 0x378, 240 => 0x2fc, 241 => 0x324, 242 => 0x324 },
	'moviesubselectorassignment' => { 298 => '48.2' },
	'moviesubselectorassignmentplusdials' => { 298 => '53.1' },
	'movietonemap' => { 240 => 0x2ec, 241 => 0x314, 242 => 0x314 },
	'movietype' => { 223 => 0x2ca, 238 => 0x1fe, 239 => 0x2e4, 240 => 0x266, 241 => 0x290, 242 => 0x290 },
	'movievibrationreduction' => { 238 => 0x24e },
	'movievibrationreductionsameasphoto' => { 238 => 0x24f },
	'movievignettecontrol' => { 238 => 0x23e, 239 => 0x1b0, 240 => 0x1a0, 241 => 0x1b4, 242 => 0x1b4 },
	'movievignettecontrolsameasphoto' => { 238 => 0x240 },
	'movievrmode' => { 239 => 0x344, 240 => 0x2c8, 241 => 0x2f0, 242 => 0x2f0 },
	'moviezebrapattern' => { 313 => 0x213, 314 => 0x213, 315 => 0x22b },
	'multiburstimageheight' => { 440 => 0x1002 },
	'multiburstimagewidth' => { 440 => 0x1001 },
	'multiburstmode' => { 440 => 0x1000 },
	'multicontrollerwhilemetering' => { 84 => 0x517 },
	'multiexposure' => { 68 => 0x1, 340 => 0xb4 },
	'multiexposureautogain' => { 244 => 0x3 },
	'multiexposurecontrol' => { 68 => 0x2 },
	'multiexposuremode' => { 244 => 0x1, 245 => 0x1 },
	'multiexposureoverlaymode' => { 245 => 0x3 },
	'multiexposureshots' => { 68 => 0x3, 239 => 0x9a, 240 => 0x8e, 241 => 0x9c, 242 => 0x9c, 244 => 0x2, 245 => 0x2 },
	'multiframenoisereduction' => { 429 => 0x35, 440 => 0x200b, 445 => 0x15 },
	'multiframenreffect' => { 440 => 0x2023 },
	'multifunctionlock' => { 84 => 0x70f },
	'multipleexposuremode' => { 239 => 0x98, 240 => 0x8c, 241 => 0x9a, 242 => 0x9a, 321 => 0x101c },
	'multipleexposureset' => { 356 => '10.1' },
	'multisample' => { 257 => 0x40 },
	'multiselector' => { 297 => '9.4', 298 => '10.3', 300 => '10.3', 301 => '10.3', 306 => '27.4', 310 => '10.3', 311 => '10.3' },
	'multiselectorliveview' => { 297 => '4.3', 300 => '37.1', 301 => '37.1', 310 => '37.1', 311 => '37.1' },
	'multiselectorliveviewmode' => { 271 => 0x18c2 },
	'multiselectorplaybackmode' => { 297 => ['13.5','9.2'], 298 => '10.2', 301 => '10.2', 306 => '27.2', 310 => '10.2', 311 => '10.2', 313 => 0xb3, 314 => 0xb3, 315 => 0xb3 },
	'multiselectorshootmode' => { 297 => '9.1', 298 => '10.1', 300 => '10.1', 301 => '10.1', 306 => '27.1', 310 => '10.1', 311 => '10.1', 313 => 0xaf, 314 => 0xaf, 315 => 0xaf },
	'multishot' => { 345 => 0x121 },
	'mute' => { 394 => 'player.movie.audio.mute' },
	'mycolormode' => { 69 => 0x2 },
	'name' => { 400 => 'name', 500 => 'Name', 502 => 'Name' },
	'narrator' => { 392 => "\xa9nrt" },
	'nationalcatalognumber' => { 519 => 'nationalCatalogNumber' },
	'nativedigest' => { 506 => 'NativeDigest', 525 => 'NativeDigest' },
	'ndfilter' => { 77 => 0x1c, 317 => 0x204, 407 => 0x1019 },
	'near' => { 485 => 'Near' },
	'nefbitdepth' => { 234 => 0xe22 },
	'nefcompression' => { 234 => 0x93, 235 => 0xa },
	'neflinearizationtable' => { 234 => 0x96 },
	'negativecachelargepreviewsize' => { 500 => 'NegativeCacheLargePreviewSize', 502 => 'NegativeCacheLargePreviewSize' },
	'negativecachemaximumsize' => { 500 => 'NegativeCacheMaximumSize', 502 => 'NegativeCacheMaximumSize' },
	'negativecachepath' => { 500 => 'NegativeCachePath', 502 => 'NegativeCachePath' },
	'neutraldensityfactor' => { 497 => 'NeutralDensityFactor' },
	'neutraldensityfilter' => { 375 => 0x88 },
	'neutraloutputhighlightpoint' => { 109 => 0x2f },
	'neutraloutputshadowpoint' => { 109 => 0x30 },
	'neutralrawcolortone' => { 109 => 0x28 },
	'neutralrawcontrast' => { 109 => 0x2a },
	'neutralrawhighlight' => { 109 => 0x78 },
	'neutralrawhighlightpoint' => { 109 => 0x2d },
	'neutralrawlinear' => { 109 => 0x2b },
	'neutralrawsaturation' => { 109 => 0x29 },
	'neutralrawshadow' => { 109 => 0x81 },
	'neutralrawshadowpoint' => { 109 => 0x2e },
	'neutralrawsharpness' => { 109 => 0x2c },
	'neutralunsharpmaskfineness' => { 109 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 109 => 0xa8 },
	'neutraunsharpmaskstrength' => { 109 => 0xa4 },
	'newlensdata' => { 232 => 0x2f },
	'newrawimagedigest' => { 119 => 0xc7a7 },
	'newsphotoversion' => { 133 => 0x0 },
	'nickname' => { 527 => 'Nickname' },
	'nikoncapturedata' => { 234 => 0xe01 },
	'nikoncaptureeditversions' => { 234 => 0xe13 },
	'nikoncaptureoffsets' => { 234 => 0xe0e },
	'nikoncaptureoutput' => { 234 => 0xe1e },
	'nikoncaptureversion' => { 234 => 0xe09 },
	'nikoniccprofile' => { 234 => 0xe1d },
	'nikonimagesize' => { 268 => '723.1', 269 => '732.1', 277 => 0x2c4 },
	'nikonmeteringmode' => { 199 => 0x17, 238 => 0x146, 248 => 0x214 },
	'nikonsettings' => { 234 => 0x4e },
	'noisefilter' => { 317 => 0x527 },
	'noiseprofile' => { 119 => 0xc761 },
	'noisereduction' => { 127 => [0x100b,0x100e], 182 => 0xb0, 183 => 0x60, 184 => 0x3f, 234 => 0x95, 290 => 0x753dcbc0, 291 => 0x17, 317 => 0x50a, 322 => 0x103a, 340 => 0x2d, 375 => 0x49, 407 => 0x100f, 409 => 0x2a },
	'noisereduction2' => { 321 => 0x1010 },
	'noisereductionapplied' => { 119 => 0xc6f7 },
	'noisereductionintensity' => { 291 => 0x9 },
	'noisereductionmethod' => { 291 => 0x11 },
	'noisereductionmode' => { 476 => 0x801e },
	'noisereductionparametersatcapture' => { 138 => 0xe73 },
	'noisereductionparameterscamera' => { 138 => 0xe72 },
	'noisereductionparametershost3mp' => { 138 => 0xe71 },
	'noisereductionparametershost6mp' => { 138 => 0xe70 },
	'noisereductionparametershostrgb' => { 138 => 0xe6f },
	'noisereductionparameterskhufu3mp' => { 138 => 0xe65 },
	'noisereductionparameterskhufu6mp' => { 138 => 0xe64 },
	'noisereductionparameterskhufurgb' => { 138 => 0xe63 },
	'noisereductionparams' => { 345 => 0x1b },
	'noisereductionsharpness' => { 291 => 0xd },
	'noisereductionstrength' => { 340 => 0xd6 },
	'noisereductionvalue' => { 476 => 0x8027 },
	'nomemorycard' => { 297 => '22.1', 298 => '4.2', 299 => '0.3', 302 => '2.4', 303 => '3.2', 304 => '3.2', 306 => '33.7', 307 => '3.2', 308 => '0.3', 310 => '4.2', 312 => '4.5' },
	'nominalmaxaperture' => { 366 => 0xa },
	'nominalminaperture' => { 366 => '10.1' },
	'noncpulens10focallength' => { 239 => 0x6c6, 242 => 0x620 },
	'noncpulens10maxaperture' => { 239 => 0x6ee, 242 => 0x670 },
	'noncpulens11focallength' => { 239 => 0x6c8, 242 => 0x624 },
	'noncpulens11maxaperture' => { 239 => 0x6f0, 242 => 0x674 },
	'noncpulens12focallength' => { 239 => 0x6ca, 242 => 0x628 },
	'noncpulens12maxaperture' => { 239 => 0x6f2, 242 => 0x678 },
	'noncpulens13focallength' => { 239 => 0x6cc, 242 => 0x62c },
	'noncpulens13maxaperture' => { 239 => 0x6f4, 242 => 0x67c },
	'noncpulens14focallength' => { 239 => 0x6ce, 242 => 0x630 },
	'noncpulens14maxaperture' => { 239 => 0x6f6, 242 => 0x680 },
	'noncpulens15focallength' => { 239 => 0x6d0, 242 => 0x634 },
	'noncpulens15maxaperture' => { 239 => 0x6f8, 242 => 0x684 },
	'noncpulens16focallength' => { 239 => 0x6d2, 242 => 0x638 },
	'noncpulens16maxaperture' => { 239 => 0x6fa, 242 => 0x688 },
	'noncpulens17focallength' => { 239 => 0x6d4, 242 => 0x63c },
	'noncpulens17maxaperture' => { 239 => 0x6fc, 242 => 0x68c },
	'noncpulens18focallength' => { 239 => 0x6d6, 242 => 0x640 },
	'noncpulens18maxaperture' => { 239 => 0x6fe, 242 => 0x690 },
	'noncpulens19focallength' => { 239 => 0x6d8, 242 => 0x644 },
	'noncpulens19maxaperture' => { 239 => 0x700, 242 => 0x694 },
	'noncpulens1focallength' => { 239 => 0x6b4, 242 => 0x5fc },
	'noncpulens1maxaperture' => { 239 => 0x6dc, 242 => 0x64c },
	'noncpulens20focallength' => { 239 => 0x6da, 242 => 0x648 },
	'noncpulens20maxaperture' => { 239 => 0x702, 242 => 0x698 },
	'noncpulens2focallength' => { 239 => 0x6b6, 242 => 0x600 },
	'noncpulens2maxaperture' => { 239 => 0x6de, 242 => 0x650 },
	'noncpulens3focallength' => { 239 => 0x6b8, 242 => 0x604 },
	'noncpulens3maxaperture' => { 239 => 0x6e0, 242 => 0x654 },
	'noncpulens4focallength' => { 239 => 0x6ba, 242 => 0x608 },
	'noncpulens4maxaperture' => { 239 => 0x6e2, 242 => 0x658 },
	'noncpulens5focallength' => { 239 => 0x6bc, 242 => 0x60c },
	'noncpulens5maxaperture' => { 239 => 0x6e4, 242 => 0x65c },
	'noncpulens6focallength' => { 239 => 0x6be, 242 => 0x610 },
	'noncpulens6maxaperture' => { 239 => 0x6e6, 242 => 0x660 },
	'noncpulens7focallength' => { 239 => 0x6c0, 242 => 0x614 },
	'noncpulens7maxaperture' => { 239 => 0x6e8, 242 => 0x664 },
	'noncpulens8focallength' => { 239 => 0x6c2, 242 => 0x618 },
	'noncpulens8maxaperture' => { 239 => 0x6ea, 242 => 0x668 },
	'noncpulens9focallength' => { 239 => 0x6c4, 242 => 0x61c },
	'noncpulens9maxaperture' => { 239 => 0x6ec, 242 => 0x66c },
	'normallinetime' => { 138 => 0x186a },
	'normalwhitelevel' => { 41 => 0x32a, 42 => 0x280, 45 => [0x2b8,0x2cf,0x2d3], 46 => 0x569, 47 => 0x1e3, 48 => [0x1fc,0x2dc], 49 => [0x230,0x30e], 50 => 0x31c },
	'notes' => { 477 => 'Notes', 495 => 'notes' },
	'npages' => { 534 => 'NPages' },
	'nullrecord' => { 97 => 0x0 },
	'numafpoints' => { 352 => 0x2 },
	'number' => { 519 => 'number' },
	'numberofbeats' => { 529 => 'numberOfBeats' },
	'numberoffocuspoints' => { 300 => '1.3', 301 => '1.3', 304 => '0.2', 305 => '0.3', 307 => '0.3' },
	'numfaceelements' => { 127 => 0x4200 },
	'numfacepositions' => { 332 => 0x0 },
	'numindexentries' => { 133 => 0x54 },
	'numwbentries' => { 346 => 0x0, 347 => 0x0 },
	'object' => { 519 => 'object' },
	'objectattributereference' => { 131 => 0x4 },
	'objectcycle' => { 131 => 0x4b, 495 => 'ObjectCycle' },
	'objectdescription' => { 518 => 'objectDescription' },
	'objectdistance' => { 112 => 0x6, 113 => 0x2022 },
	'objectname' => { 131 => 0x5 },
	'objectpreviewdata' => { 131 => 0xca },
	'objectpreviewfileformat' => { 131 => 0xc8 },
	'objectpreviewfileversion' => { 131 => 0xc9 },
	'objectsubtype' => { 518 => 'objectSubtype' },
	'objecttype' => { 518 => 'objectType' },
	'objecttypereference' => { 131 => 0x3 },
	'occurrence' => { 118 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 118 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 118 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 118 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 118 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 118 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 118 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecatalognumber' => { 118 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedegreeofestablishment' => { 118 => [\'Occurrence','OccurrenceDegreeOfEstablishment'] },
	'occurrencedetails' => { 118 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 118 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 118 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrencegeoreferenceverificationstatus' => { 118 => [\'Occurrence','OccurrenceGeoreferenceVerificationStatus'] },
	'occurrenceid' => { 118 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 118 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 118 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 118 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceorganismquantity' => { 118 => [\'Occurrence','OccurrenceOrganismQuantity'] },
	'occurrenceorganismquantitytype' => { 118 => [\'Occurrence','OccurrenceOrganismQuantityType'] },
	'occurrenceothercatalognumbers' => { 118 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepathway' => { 118 => [\'Occurrence','OccurrencePathway'] },
	'occurrencepreparations' => { 118 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 118 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 118 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordedbyid' => { 118 => [\'Occurrence','OccurrenceRecordedByID'] },
	'occurrencerecordnumber' => { 118 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 118 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 118 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 118 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 118 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'oecfcolumns' => { 506 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 506 => [\'OECF','OECFNames'] },
	'oecfrows' => { 506 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 506 => [\'OECF','OECFValues'] },
	'offsaledate' => { 519 => 'offSaleDate' },
	'offsaledatea-platform' => { 519 => [\'offSaleDate','offSaleDateA-platform'] },
	'offsaledatedate' => { 519 => [\'offSaleDate','offSaleDateDate'] },
	'offsetdacvalue' => { 138 => 0x190a },
	'offsethdr' => { 511 => 'OffsetHDR' },
	'offsetschema' => { 119 => 0xea1d },
	'offsetsdr' => { 511 => 'OffsetSDR' },
	'offsettime' => { 119 => 0x9010 },
	'offsettimedigitized' => { 119 => 0x9012 },
	'offsettimeoriginal' => { 119 => 0x9011 },
	'oismode' => { 1 => 0xf },
	'okbutton' => { 307 => '15.1', 312 => '16.1' },
	'oldsubfiletype' => { 119 => 0xff },
	'olympusimageheight' => { 322 => 0x102f },
	'olympusimagewidth' => { 322 => 0x102e },
	'omenatcapturestrength' => { 138 => 0xa60 },
	'omenautostrength' => { 138 => 0xa5f },
	'omenearlystrength' => { 138 => 0xa5e },
	'omenfocallengthlimit' => { 138 => 0xa62 },
	'omeninitialipfstrength' => { 138 => 0xa5d },
	'omensurfaceindex' => { 138 => 0xa64 },
	'oneshotafrelease' => { 2 => 0x9 },
	'onetouchwb' => { 322 => 0x302 },
	'onsaledate' => { 519 => 'onSaleDate' },
	'onsaledatea-platform' => { 519 => [\'onSaleDate','onSaleDateA-platform'] },
	'onsaledatedate' => { 519 => [\'onSaleDate','onSaleDateDate'] },
	'onsaleday' => { 519 => 'onSaleDay' },
	'onsaledaya-platform' => { 519 => [\'onSaleDay','onSaleDayA-platform'] },
	'onsaledayday' => { 519 => [\'onSaleDay','onSaleDayDay'] },
	'opcodelist1' => { 119 => 0xc740 },
	'opcodelist2' => { 119 => 0xc741 },
	'opcodelist3' => { 119 => 0xc74e },
	'opticalzoom' => { 142 => 0xfa3d, 144 => [0x6006,0xf006], 145 => 0x1000, 146 => 0xf, 149 => 0x1e, 151 => 0x20, 152 => 0x1c, 163 => 'OpticalZoom' },
	'opticalzoomcode' => { 77 => 0xa },
	'opticalzoommode' => { 340 => 0x34 },
	'opticalzoomon' => { 416 => 0x219 },
	'optionenddate' => { 522 => 'optionEndDate' },
	'opto-electricconvfactor' => { 506 => 'OECF' },
	'orangehsl' => { 103 => 0x20911 },
	'ordernumber' => { 127 => 0x8002 },
	'organisationinimagecode' => { 514 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 514 => 'OrganisationInImageName' },
	'organism' => { 118 => 'Organism' },
	'organismassociatedoccurrences' => { 118 => [\'Organism','OrganismAssociatedOccurrences'] },
	'organismassociatedorganisms' => { 118 => [\'Organism','OrganismAssociatedOrganisms'] },
	'organismid' => { 118 => [\'Organism','OrganismOrganismID'] },
	'organismname' => { 118 => [\'Organism','OrganismOrganismName'] },
	'organismpreviousidentifications' => { 118 => [\'Organism','OrganismPreviousIdentifications'] },
	'organismremarks' => { 118 => [\'Organism','OrganismOrganismRemarks'] },
	'organismscope' => { 118 => [\'Organism','OrganismOrganismScope'] },
	'organization' => { 519 => 'organization' },
	'orientation' => { 119 => 0x112, 345 => 0x112, 518 => 'orientation', 525 => 'Orientation' },
	'orientation2' => { 445 => [0x28,0x2e] },
	'orientationlinkedaf' => { 2 => 0xe },
	'orientationlinkedafpoint' => { 84 => 0x516 },
	'originalalbumtitle' => { 179 => 'WM/OriginalAlbumTitle' },
	'originalartist' => { 179 => 'WM/OriginalArtist', 392 => "\xa9ope" },
	'originalbestqualitysize' => { 119 => 0xc792 },
	'originalcreatedatetime' => { 490 => 'OriginalCreateDateTime' },
	'originaldecisiondata' => { 114 => 'Canon-OriginalDecisionData' },
	'originaldecisiondataoffset' => { 64 => 0x83 },
	'originaldefaultcropsize' => { 119 => 0xc793 },
	'originaldefaultfinalsize' => { 119 => 0xc791 },
	'originaldirectory' => { 337 => 0x408 },
	'originaldocumentid' => { 530 => 'OriginalDocumentID' },
	'originalfilename' => { 97 => 0x816, 138 => 0x3e9, 150 => 0x20, 337 => 0x407, 490 => 'OriginalFilename' },
	'originalimagehash' => { 480 => 'OriginalImageHash' },
	'originalimagehashtype' => { 480 => 'OriginalImageHashType' },
	'originalimageheight' => { 79 => 0xc, 123 => 0x1 },
	'originalimagemd5' => { 480 => 'OriginalImageMD5' },
	'originalimagesize' => { 162 => 'OriginalImageSize' },
	'originalimagewidth' => { 79 => 0xb, 123 => 0x0 },
	'originallyricist' => { 179 => 'WM/OriginalLyricist' },
	'originalrawfiledata' => { 119 => 0xc68c },
	'originalrawfiledigest' => { 119 => 0xc71d },
	'originalrawfilename' => { 119 => 0xc68b },
	'originaltransmissionreference' => { 131 => 0x67 },
	'originatingprogram' => { 131 => 0x41, 495 => 'OriginatingProgram' },
	'originplatform' => { 519 => 'originPlatform' },
	'os' => { 504 => 'os' },
	'otherconditions' => { 327 => 'OtherConditions' },
	'otherconstraints' => { 327 => 'OtherConstraints' },
	'otherimage' => { 114 => 'Exif-OtherImage' },
	'otherimageinfo' => { 327 => 'OtherImageInfo' },
	'otherimagelength' => { 119 => 0x202 },
	'otherimagestart' => { 119 => 0x201 },
	'otherlicensedocuments' => { 327 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 327 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 327 => 'OtherLicenseRequirements' },
	'outcue' => { 529 => 'outCue' },
	'outcuescale' => { 529 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 529 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 200 => 0x3 },
	'outputimagewidth' => { 200 => 0x2 },
	'outputlut' => { 340 => 0xa7 },
	'outputprofile' => { 138 => 0x138b },
	'outputresolution' => { 200 => 0x4 },
	'overclockcols' => { 138 => 0x189c },
	'overclockrows' => { 138 => 0x18c4 },
	'overridelookvignette' => { 500 => 'OverrideLookVignette', 502 => 'OverrideLookVignette' },
	'owner' => { 533 => 'Owner' },
	'ownerid' => { 131 => 0xbc },
	'ownername' => { 15 => 0x10f, 64 => 0x9, 97 => 0x810, 119 => [0xa430,0xfde8], 156 => 'OwnerName', 497 => 'OwnerName', 507 => 'CameraOwnerName' },
	'padding' => { 119 => 0xea1c },
	'pagecount' => { 519 => 'pageCount' },
	'pageimage' => { 527 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 527 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 527 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 527 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 527 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 527 => 'PageInfo' },
	'pagename' => { 119 => 0x11d },
	'pagenumber' => { 119 => 0x129 },
	'pageprogressiondirection' => { 519 => 'pageProgressionDirection' },
	'pagerange' => { 519 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 500 => 'PaintBasedCorrections', 502 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionblacks2012' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBlacks2012'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBlacks2012'] },
	'paintcorrectionbrightness' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectioncorrectionname' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionName'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionName'] },
	'paintcorrectioncorrectionsyncid' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionSyncID'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionSyncID'] },
	'paintcorrectiondefringe' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectiondehaze' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDehaze'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDehaze'] },
	'paintcorrectionexposure' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHue'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHue'] },
	'paintcorrectionluminancenoise' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskinputdigest' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksInputDigest'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksInputDigest'] },
	'paintcorrectionmaskleft' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmaskactive' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskActive'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskActive'] },
	'paintcorrectionmaskmaskblendmode' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskBlendMode'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'paintcorrectionmaskmaskdigest' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskDigest'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskDigest'] },
	'paintcorrectionmaskmaskinverted' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskInverted'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskInverted'] },
	'paintcorrectionmaskmaskname' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskName'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskName'] },
	'paintcorrectionmaskmasks' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasks'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasks'] },
	'paintcorrectionmaskmasksalpha' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAlpha'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'paintcorrectionmaskmasksangle' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAngle'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAngle'] },
	'paintcorrectionmaskmasksbottom' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksBottom'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksBottom'] },
	'paintcorrectionmaskmaskscentervalue' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterValue'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'paintcorrectionmaskmaskscenterweight' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterWeight'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'paintcorrectionmaskmasksdabs' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksDabs'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksDabs'] },
	'paintcorrectionmaskmasksfeather' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFeather'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFeather'] },
	'paintcorrectionmaskmasksflipped' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlipped'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'paintcorrectionmaskmasksflow' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlow'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlow'] },
	'paintcorrectionmaskmasksfullx' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullX'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullX'] },
	'paintcorrectionmaskmasksfully' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullY'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullY'] },
	'paintcorrectionmaskmasksinputdigest' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksInputDigest'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'paintcorrectionmaskmasksleft' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksLeft'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksLeft'] },
	'paintcorrectionmaskmasksmaskactive' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskActive'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'paintcorrectionmaskmasksmaskblendmode' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'paintcorrectionmaskmasksmaskdigest' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskDigest'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'paintcorrectionmaskmasksmaskinverted' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskInverted'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'paintcorrectionmaskmasksmaskname' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskName'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'paintcorrectionmaskmasksmasksubtype' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSubType'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'paintcorrectionmaskmasksmasksyncid' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'paintcorrectionmaskmasksmaskversion' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskVersion'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'paintcorrectionmaskmasksmidpoint' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMidpoint'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'paintcorrectionmaskmasksorigin' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksOrigin'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'paintcorrectionmaskmasksperimetervalue' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'paintcorrectionmaskmasksradius' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRadius'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRadius'] },
	'paintcorrectionmaskmasksreferencepoint' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksReferencePoint'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'paintcorrectionmaskmasksright' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRight'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRight'] },
	'paintcorrectionmaskmasksroundness' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRoundness'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'paintcorrectionmaskmaskssizex' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeX'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'paintcorrectionmaskmaskssizey' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeY'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'paintcorrectionmaskmaskstop' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksTop'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksTop'] },
	'paintcorrectionmaskmasksubtype' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSubType'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSubType'] },
	'paintcorrectionmaskmasksvalue' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskValue'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'paintcorrectionmaskmasksversion' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksVersion'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksVersion'] },
	'paintcorrectionmaskmaskswhat' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWhat'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWhat'] },
	'paintcorrectionmaskmaskswholeimagearea' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'paintcorrectionmaskmasksx' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksX'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksX'] },
	'paintcorrectionmaskmasksy' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksY'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksY'] },
	'paintcorrectionmaskmasksyncid' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSyncID'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'paintcorrectionmaskmaskszerox' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroX'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'paintcorrectionmaskmaskszeroy' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroY'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'paintcorrectionmaskmaskversion' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskVersion'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskVersion'] },
	'paintcorrectionmaskmidpoint' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskorigin' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksOrigin'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksOrigin'] },
	'paintcorrectionmaskperimetervalue' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskrange' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'paintcorrectionmaskrangeareamodels' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'paintcorrectionmaskrangeareamodelscolorsampleinfo' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'paintcorrectionmaskrangeareamodelscomponents' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'paintcorrectionmaskrangecoloramount' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'paintcorrectionmaskrangedepthfeather' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'paintcorrectionmaskrangedepthmax' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'paintcorrectionmaskrangedepthmin' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'paintcorrectionmaskrangeinvert' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'paintcorrectionmaskrangelumfeather' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'paintcorrectionmaskrangeluminancedepthsampleinfo' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'paintcorrectionmaskrangelummax' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'paintcorrectionmaskrangelummin' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'paintcorrectionmaskrangelumrange' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'paintcorrectionmaskrangesampletype' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'paintcorrectionmaskrangetype' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'paintcorrectionmaskrangeversion' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'paintcorrectionmaskreferencepoint' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksReferencePoint'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksReferencePoint'] },
	'paintcorrectionmaskright' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskwholeimagearea' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWholeImageArea'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'paintcorrectionmaskx' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionrangemask' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMask'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMask'] },
	'paintcorrectionrangemaskareamodels' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModels'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'paintcorrectionrangemaskareamodelscolorsampleinfo' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'paintcorrectionrangemaskareamodelscomponents' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'paintcorrectionrangemaskcoloramount' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskColorAmount'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'paintcorrectionrangemaskdepthfeather' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthFeather'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'paintcorrectionrangemaskdepthmax' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMax'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'paintcorrectionrangemaskdepthmin' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMin'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'paintcorrectionrangemaskinvert' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskInvert'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskInvert'] },
	'paintcorrectionrangemasklumfeather' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumFeather'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'paintcorrectionrangemaskluminancedepthsampleinfo' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'paintcorrectionrangemasklummax' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMax'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'paintcorrectionrangemasklummin' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMin'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'paintcorrectionrangemasklumrange' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumRange'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'paintcorrectionrangemasksampletype' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskSampleType'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'paintcorrectionrangemasktype' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskType'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskType'] },
	'paintcorrectionrangemaskversion' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskVersion'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskVersion'] },
	'paintcorrectionsaturation' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation'] },
	'paintcorrectionshadows2012' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontexture' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTexture'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTexture'] },
	'paintcorrectiontint' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectiontoninghue' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectiontoningsaturation' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningSaturation'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionwhat' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'paintcorrectionwhites2012' => { 500 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalWhites2012'], 502 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalWhites2012'] },
	'panasonicdatetime' => { 343 => 0x0 },
	'panasonicexifversion' => { 340 => 0x26 },
	'panasonicimageheight' => { 340 => 0x4c },
	'panasonicimagewidth' => { 340 => 0x4b },
	'panasonicrawversion' => { 345 => 0x1 },
	'panasonictitle' => { 119 => 0xc6d2 },
	'panasonictitle2' => { 119 => 0xc6d3 },
	'panoramaangle' => { 127 => 0x1153 },
	'panoramacropbottom' => { 446 => 0x7 },
	'panoramacropleft' => { 446 => 0x4 },
	'panoramacropright' => { 446 => 0x6 },
	'panoramacroptop' => { 446 => 0x5 },
	'panoramadirection' => { 72 => 0x5, 127 => 0x1154, 446 => 0x3 },
	'panoramaframeheight' => { 446 => 0x9 },
	'panoramaframenumber' => { 72 => 0x2 },
	'panoramaframewidth' => { 446 => 0x8 },
	'panoramafullheight' => { 446 => 0x2 },
	'panoramafullwidth' => { 446 => 0x1 },
	'panoramamode' => { 140 => 0x3c, 317 => 0x601 },
	'panoramasize3d' => { 429 => 0x38 },
	'panoramasourceheight' => { 446 => 0xb },
	'panoramasourcewidth' => { 446 => 0xa },
	'panoramicstitchcameramotion' => { 176 => 'PanoramicStitchCameraMotion', 177 => 0x1 },
	'panoramicstitchmaptype' => { 176 => 'PanoramicStitchMapType', 177 => 0x2 },
	'panoramicstitchphi0' => { 176 => 'PanoramicStitchPhi0', 177 => 0x5 },
	'panoramicstitchphi1' => { 176 => 'PanoramicStitchPhi1', 177 => 0x6 },
	'panoramicstitchtheta0' => { 176 => 'PanoramicStitchTheta0', 177 => 0x3 },
	'panoramicstitchtheta1' => { 176 => 'PanoramicStitchTheta1', 177 => 0x4 },
	'panoramicstitchversion' => { 177 => 0x0 },
	'pantry' => { 530 => 'Pantry' },
	'pantryinstanceid' => { 530 => [\'Pantry','PantryInstanceID'] },
	'parallax' => { 127 => 0xb211, 316 => 0x28 },
	'parametricdarks' => { 500 => 'ParametricDarks', 502 => 'ParametricDarks' },
	'parametrichighlights' => { 500 => 'ParametricHighlights', 502 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 500 => 'ParametricHighlightSplit', 502 => 'ParametricHighlightSplit' },
	'parametriclights' => { 500 => 'ParametricLights', 502 => 'ParametricLights' },
	'parametricmidtonesplit' => { 500 => 'ParametricMidtoneSplit', 502 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 500 => 'ParametricShadows', 502 => 'ParametricShadows' },
	'parametricshadowsplit' => { 500 => 'ParametricShadowSplit', 502 => 'ParametricShadowSplit' },
	'parentalrating' => { 179 => 'WM/ParentalRating' },
	'parentid' => { 514 => 'parentId' },
	'parentmediaeventid' => { 490 => 'ParentMediaEventID' },
	'parentmeid' => { 490 => 'ParentMEID' },
	'parentproductid' => { 392 => '@ppi' },
	'parentreference1' => { 512 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 512 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 512 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 512 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 512 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 512 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentshorttitle' => { 392 => '@PST' },
	'parenttitle' => { 392 => '@pti' },
	'partialactivecols1' => { 138 => 0x17e8 },
	'partialactivecols2' => { 138 => 0x17f2 },
	'partialactiverows1' => { 138 => 0x17fc },
	'partialactiverows2' => { 138 => 0x1806 },
	'partofcompilation' => { 529 => 'partOfCompilation' },
	'patientbirthdate' => { 478 => 'PatientDOB' },
	'patientid' => { 478 => 'PatientID' },
	'patientname' => { 478 => 'PatientName' },
	'patientsex' => { 478 => 'PatientSex' },
	'patternareaheight' => { 138 => 0x963 },
	'patternareawidth' => { 138 => 0x962 },
	'patterncorrectionfactorscale' => { 138 => 0x969 },
	'patterncropcols1' => { 138 => 0x96c },
	'patterncropcols2' => { 138 => 0x96d },
	'patterncroprows1' => { 138 => 0x96a },
	'patterncroprows2' => { 138 => 0x96b },
	'patternimagerheight' => { 138 => 0x961 },
	'patternimagerwidth' => { 138 => 0x960 },
	'patternx' => { 138 => 0x966 },
	'patterny' => { 138 => 0x967 },
	'pdfversion' => { 516 => 'PDFVersion' },
	'pentaximagesize' => { 375 => 0x9 },
	'pentaxmodelid' => { 355 => 0x0, 375 => 0x5 },
	'pentaxmodeltype' => { 375 => 0x1 },
	'pentaxversion' => { 375 => 0x0 },
	'people' => { 481 => 'People', 493 => 'People' },
	'perchannelblacklevel' => { 41 => 0x157, 42 => 0x16b, 44 => 0xc4, 45 => [0x2b4,0x2cb,0x2cf], 46 => [0x108,0x14d], 47 => 0x1df, 48 => [0x1f8,0x2d8], 49 => [0x22c,0x30a], 50 => 0x149 },
	'performer' => { 392 => 'perf', 400 => 'perf' },
	'performerkeywords' => { 400 => "\xa9prk" },
	'performers' => { 400 => "\xa9prf" },
	'performerurl' => { 400 => "\xa9prl" },
	'period' => { 179 => 'WM/Period' },
	'peripheralillumcentralradius' => { 476 => 0x8030 },
	'peripheralillumcentralvalue' => { 476 => 0x8031 },
	'peripheralillumination' => { 103 => 0x20702, 109 => 0x68 },
	'peripheralilluminationcorr' => { 62 => 0x1, 365 => 0x2 },
	'peripheralilluminationon' => { 103 => '0x20702.0', 109 => 0x64 },
	'peripheralillumperiphvalue' => { 476 => 0x8032 },
	'peripherallighting' => { 79 => 0x2, 127 => 0x3804 },
	'peripherallightingsetting' => { 80 => 0x5 },
	'peripherallightingvalue' => { 79 => 0x6 },
	'permissions' => { 522 => 'permissions' },
	'permits' => { 498 => 'permits' },
	'person' => { 519 => 'person' },
	'personality' => { 490 => 'Personality' },
	'personheard' => { 514 => 'PersonHeard' },
	'personheardidentifier' => { 514 => [\'PersonHeard','PersonHeardIdentifier'] },
	'personheardname' => { 514 => [\'PersonHeard','PersonHeardName'] },
	'personinimage' => { 514 => 'PersonInImage' },
	'personinimagecharacteristic' => { 514 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristic'] },
	'personinimagecvtermcvid' => { 514 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvId'] },
	'personinimagecvtermid' => { 514 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermId'] },
	'personinimagecvtermname' => { 514 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermName'] },
	'personinimagecvtermrefinedabout' => { 514 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermRefinedAbout'] },
	'personinimagedescription' => { 514 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonDescription'] },
	'personinimageid' => { 514 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonId'] },
	'personinimagename' => { 514 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonName'] },
	'personinimagewdetails' => { 514 => 'PersonInImageWDetails' },
	'perspectiveaspect' => { 500 => 'PerspectiveAspect', 502 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 500 => 'PerspectiveHorizontal', 502 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 500 => 'PerspectiveRotate', 502 => 'PerspectiveRotate' },
	'perspectivescale' => { 500 => 'PerspectiveScale', 502 => 'PerspectiveScale' },
	'perspectiveupright' => { 500 => 'PerspectiveUpright', 502 => 'PerspectiveUpright' },
	'perspectivevertical' => { 500 => 'PerspectiveVertical', 502 => 'PerspectiveVertical' },
	'perspectivex' => { 500 => 'PerspectiveX', 502 => 'PerspectiveX' },
	'perspectivey' => { 500 => 'PerspectiveY', 502 => 'PerspectiveY' },
	'pf0customfuncregistration' => { 92 => 0x1 },
	'pf10retainprogramshift' => { 92 => 0xb },
	'pf13drivepriority' => { 92 => 0xe },
	'pf14disablefocussearch' => { 92 => 0xf },
	'pf15disableafassistbeam' => { 92 => 0x10 },
	'pf16autofocuspointshoot' => { 92 => 0x11 },
	'pf17disableafpointsel' => { 92 => 0x12 },
	'pf18enableautoafpointsel' => { 92 => 0x13 },
	'pf19continuousshootspeed' => { 92 => 0x14 },
	'pf19shootingspeedhigh' => { 91 => 0xa },
	'pf19shootingspeedlow' => { 91 => 0x9 },
	'pf1disableshootingmodes' => { 92 => 0x2 },
	'pf1value' => { 91 => 0x1 },
	'pf20limitcontinousshots' => { 92 => 0x15 },
	'pf20maxcontinousshots' => { 91 => 0xb },
	'pf21enablequietoperation' => { 92 => 0x16 },
	'pf23felocktime' => { 91 => 0xd },
	'pf23postreleasetime' => { 91 => 0xe },
	'pf23settimerlengths' => { 92 => 0x18 },
	'pf23shutterbuttontime' => { 91 => 0xc },
	'pf24lightlcdduringbulb' => { 92 => 0x19 },
	'pf25aemode' => { 91 => 0xf },
	'pf25afmode' => { 91 => 0x12 },
	'pf25afpointsel' => { 91 => 0x13 },
	'pf25colormatrix' => { 91 => 0x17 },
	'pf25defaultclearsettings' => { 92 => 0x1a },
	'pf25drivemode' => { 91 => 0x11 },
	'pf25imagesize' => { 91 => 0x14 },
	'pf25meteringmode' => { 91 => 0x10 },
	'pf25parameters' => { 91 => 0x16 },
	'pf25wbmode' => { 91 => 0x15 },
	'pf26shortenreleaselag' => { 92 => 0x1b },
	'pf27reversedialrotation' => { 92 => 0x1c },
	'pf27value' => { 91 => 0x18 },
	'pf28noquickdialexpcomp' => { 92 => 0x1d },
	'pf29quickdialswitchoff' => { 92 => 0x1e },
	'pf2disablemeteringmodes' => { 92 => 0x3 },
	'pf2value' => { 91 => 0x2 },
	'pf30enlargementmode' => { 92 => 0x1f },
	'pf31originaldecisiondata' => { 92 => 0x20 },
	'pf3manualexposuremetering' => { 92 => 0x4 },
	'pf3value' => { 91 => 0x3 },
	'pf4exposuretimelimits' => { 92 => 0x5 },
	'pf4exposuretimemax' => { 91 => 0x5 },
	'pf4exposuretimemin' => { 91 => 0x4 },
	'pf5aperturelimits' => { 92 => 0x6 },
	'pf5aperturemax' => { 91 => 0x7 },
	'pf5aperturemin' => { 91 => 0x6 },
	'pf6presetshootingmodes' => { 92 => 0x7 },
	'pf7bracketcontinuousshoot' => { 92 => 0x8 },
	'pf8bracketshots' => { 91 => 0x8 },
	'pf8setbracketshots' => { 92 => 0x9 },
	'pf9changebracketsequence' => { 92 => 0xa },
	'phasedetectaf' => { 193 => 0x6 },
	'phonenumber' => { 157 => 'Phone' },
	'photoeffect' => { 34 => 0x28 },
	'photoeffecthistoryxml' => { 290 => 0xe9651831 },
	'photoeffects' => { 290 => 0xab5eca5e },
	'photoeffectsblue' => { 292 => 0x8 },
	'photoeffectsgreen' => { 292 => 0x6 },
	'photoeffectsred' => { 292 => 0x4 },
	'photoeffectstype' => { 292 => 0x0 },
	'photographer' => { 119 => 0xa437 },
	'photographicsensitivity' => { 507 => 'PhotographicSensitivity' },
	'photoidentifier' => { 1 => 0x2b },
	'photoinfoplayback' => { 297 => '17.6', 306 => '33.6' },
	'photometricinterpretation' => { 119 => 0x106, 525 => 'PhotometricInterpretation' },
	'photoshootingmenubank' => { 239 => 0x11e, 240 => 0x112, 241 => 0x122, 242 => 0x122, 243 => 0x24, 261 => 0x0 },
	'photoshootingmenubankimagearea' => { 237 => 0x6dd, 239 => 0x144, 240 => 0x134, 241 => 0x148, 242 => 0x148, 261 => '7.1' },
	'photoshopbgrthumbnail' => { 389 => 0x409 },
	'photoshopquality' => { 388 => 0x0 },
	'photoshopthumbnail' => { 389 => 0x40c },
	'photostyle' => { 340 => 0x89 },
	'picasawebgphotoid' => { 505 => 'picasawebGPhotoId' },
	'picklabel' => { 505 => 'PickLabel' },
	'pictinfo' => { 416 => 0x208 },
	'picturecontrol' => { 290 => 0xe2173c47 },
	'picturecontrolactive' => { 293 => 0x0 },
	'picturecontroladjust' => { 249 => 0x30, 250 => 0x30, 251 => 0x36 },
	'picturecontrolbase' => { 249 => 0x18, 250 => 0x18, 251 => 0x1c },
	'picturecontroldata' => { 234 => [0xbd,0x23] },
	'picturecontrolmode' => { 293 => 0x13 },
	'picturecontrolname' => { 249 => 0x4, 250 => 0x4, 251 => 0x8 },
	'picturecontrolquickadjust' => { 249 => 0x31, 250 => 0x31, 251 => 0x37 },
	'pictureeffect' => { 440 => 0x200e },
	'pictureeffect2' => { 449 => 0x1163, 450 => 0x1167, 451 => 0x1143, 452 => 0x11bf, 453 => 0x119b, 454 => 0x1053, 455 => 0x24b, 456 => 0x24b, 457 => 0x23c, 472 => 0x46 },
	'picturefinish' => { 182 => 0x71 },
	'picturemode' => { 127 => 0x1031, 317 => 0x520, 375 => [0xb,0x33], 417 => 0x3d },
	'picturemode2' => { 356 => 0x0 },
	'picturemodebwfilter' => { 317 => 0x525 },
	'picturemodecontrast' => { 317 => 0x523 },
	'picturemodeeffect' => { 317 => 0x52d },
	'picturemodehue' => { 317 => 0x522 },
	'picturemodesaturation' => { 317 => 0x521 },
	'picturemodesharpness' => { 317 => 0x524 },
	'picturemodetone' => { 317 => 0x526 },
	'pictureprofile' => { 449 => [0x115e,0x115f], 450 => [0x1162,0x1163], 451 => [0x113e,0x113f], 452 => [0x11ba,0x11bb], 453 => [0x1196,0x1197], 454 => [0x104e,0x104f], 455 => [0x246,0x247], 456 => [0x246,0x247], 457 => [0x237,0x238] },
	'picturestyle' => { 8 => [0x4b,0x51], 9 => 0xf4, 10 => 0x6c, 11 => 0x86, 12 => 0x73, 16 => 0xab, 17 => 0xa7, 18 => 0xb0, 19 => 0x6c, 20 => 0xa7, 21 => 0xf4, 22 => 0xb3, 24 => 0xf4, 25 => 0xfa, 27 => 0x169, 74 => 0xa, 103 => 0x20301, 109 => 0x2 },
	'picturestylepc' => { 64 => 0x4009 },
	'picturestyleuserdef' => { 64 => 0x4008 },
	'picturewizard' => { 414 => 0x21 },
	'picturewizardcolor' => { 413 => 0x1 },
	'picturewizardcontrast' => { 413 => 0x4 },
	'picturewizardmode' => { 413 => 0x0 },
	'picturewizardsaturation' => { 413 => 0x2 },
	'picturewizardsharpness' => { 413 => 0x3 },
	'pipelineversion' => { 176 => 'PipelineVersion' },
	'pitch' => { 115 => 0x6, 298 => '4.1', 310 => '4.1', 400 => ['ptch',"\xa9fpt"] },
	'pitchangle' => { 247 => 0x4, 317 => 0x904, 340 => 0x91, 374 => 0x2, 412 => 0x1 },
	'pitchshift' => { 394 => 'player.movie.audio.pitchshift' },
	'pixelaspectratio' => { 393 => 'pasp' },
	'pixelclockfrequency' => { 138 => 0x40b },
	'pixelcorrectionoffset' => { 138 => 0x972 },
	'pixelcorrectionscale' => { 138 => 0x971 },
	'pixelscale' => { 119 => 0x830e },
	'pixelshiftinfo' => { 440 => 0x202f },
	'pixelshiftoffset' => { 127 => 0x1106 },
	'pixelshiftresolution' => { 376 => 0x0 },
	'pixelshiftshots' => { 127 => 0x1105 },
	'pixelsperunitx' => { 329 => 0x0 },
	'pixelsperunity' => { 329 => 0x4 },
	'pixelunits' => { 329 => 0x8 },
	'planarconfiguration' => { 119 => 0x11c, 525 => 'PlanarConfiguration' },
	'plane' => { 479 => [\'Planes','PlanesPlane'] },
	'planeboundary' => { 479 => [\'Planes','PlanesPlaneBoundary'] },
	'planeboundaryvertexcount' => { 479 => [\'Planes','PlanesPlaneBoundaryVertexCount'] },
	'planeextentx' => { 479 => [\'Planes','PlanesPlaneExtentX'] },
	'planeextentz' => { 479 => [\'Planes','PlanesPlaneExtentZ'] },
	'planepose' => { 479 => [\'Planes','PlanesPlanePose'] },
	'planeposepositionx' => { 479 => [\'Planes','PlanesPlanePosePositionX'] },
	'planeposepositiony' => { 479 => [\'Planes','PlanesPlanePosePositionY'] },
	'planeposepositionz' => { 479 => [\'Planes','PlanesPlanePosePositionZ'] },
	'planeposerotationw' => { 479 => [\'Planes','PlanesPlanePoseRotationW'] },
	'planeposerotationx' => { 479 => [\'Planes','PlanesPlanePoseRotationX'] },
	'planeposerotationy' => { 479 => [\'Planes','PlanesPlanePoseRotationY'] },
	'planeposerotationz' => { 479 => [\'Planes','PlanesPlanePoseRotationZ'] },
	'planeposetimestamp' => { 479 => [\'Planes','PlanesPlanePoseTimestamp'] },
	'planes' => { 479 => 'Planes' },
	'planningref' => { 514 => 'PlanningRef' },
	'planningrefidentifier' => { 514 => [\'PlanningRef','PlanningRefIdentifier'] },
	'planningrefname' => { 514 => [\'PlanningRef','PlanningRefName'] },
	'planningrefrole' => { 514 => [\'PlanningRef','PlanningRefRole'] },
	'platenames' => { 534 => 'PlateNames' },
	'platform' => { 519 => 'platform' },
	'playallframes' => { 400 => 'AllF' },
	'playbackbutton' => { 242 => 0x808 },
	'playbackbuttonplaybackmode' => { 242 => 0x814 },
	'playbackflickdown' => { 313 => 0x159, 314 => 0x159, 315 => 0x171 },
	'playbackflickup' => { 313 => 0x155, 314 => 0x155, 315 => 0x16d },
	'playbackmenustime' => { 302 => '20.1', 303 => '21.1', 304 => '21.1' },
	'playbackmonitorofftime' => { 297 => '25.2', 298 => '36.1', 300 => '36.1', 301 => '36.1', 305 => '35.1', 306 => '8.1', 307 => '35.1', 310 => '36.1', 311 => '36.1', 312 => '21.1', 313 => 0x33, 314 => 0x33, 315 => 0x33 },
	'playbackzoom' => { 298 => '37.1' },
	'playdisplay' => { 184 => 0x4e },
	'playerversion' => { 394 => 'player.version' },
	'playgap' => { 392 => 'pgap' },
	'playmode' => { 400 => 'SDLN' },
	'playselection' => { 400 => 'SelO' },
	'plusversion' => { 327 => 'Version' },
	'pmversion' => { 387 => 'PMVersion' },
	'pngwarning' => { 330 => 'Warning' },
	'podcast' => { 392 => 'pcst' },
	'podcasturl' => { 392 => 'purl' },
	'poilevel' => { 233 => 0x8 },
	'portraitimpressionbalance' => { 239 => 0x26e, 252 => 0xa0 },
	'portraitnote' => { 483 => 'PortraitNote' },
	'portraitoutputhighlightpoint' => { 109 => 0x1d },
	'portraitoutputshadowpoint' => { 109 => 0x1e },
	'portraitrawcolortone' => { 109 => 0x16 },
	'portraitrawcontrast' => { 109 => 0x18 },
	'portraitrawhighlight' => { 109 => 0x76 },
	'portraitrawhighlightpoint' => { 109 => 0x1b },
	'portraitrawlinear' => { 109 => 0x19 },
	'portraitrawsaturation' => { 109 => 0x17 },
	'portraitrawshadow' => { 109 => 0x7f },
	'portraitrawshadowpoint' => { 109 => 0x1c },
	'portraitrawsharpness' => { 109 => 0x1a },
	'portraitrefiner' => { 113 => 0x302b },
	'portraitrequest' => { 483 => 'PortraitRequest' },
	'portraitunsharpmaskfineness' => { 109 => 0x9a },
	'portraitunsharpmaskstrength' => { 109 => 0x98 },
	'portraitunsharpmaskthreshold' => { 109 => 0x9c },
	'portraitversion' => { 483 => 'PortraitVersion' },
	'pose' => { 479 => 'Pose' },
	'poseheadingdegrees' => { 488 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 488 => 'PosePitchDegrees' },
	'posepositionx' => { 479 => [\'Pose','PosePositionX'] },
	'posepositiony' => { 479 => [\'Pose','PosePositionY'] },
	'posepositionz' => { 479 => [\'Pose','PosePositionZ'] },
	'poserolldegrees' => { 488 => 'PoseRollDegrees' },
	'poserotationw' => { 479 => [\'Pose','PoseRotationW'] },
	'poserotationx' => { 479 => [\'Pose','PoseRotationX'] },
	'poserotationy' => { 479 => [\'Pose','PoseRotationY'] },
	'poserotationz' => { 479 => [\'Pose','PoseRotationZ'] },
	'posetimestamp' => { 479 => [\'Pose','PoseTimestamp'] },
	'positiondescriptor' => { 518 => 'positionDescriptor' },
	'postalcode' => { 161 => 'PostalCode' },
	'postcropvignetteamount' => { 500 => 'PostCropVignetteAmount', 502 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 500 => 'PostCropVignetteFeather', 502 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 500 => 'PostCropVignetteHighlightContrast', 502 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 500 => 'PostCropVignetteMidpoint', 502 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 500 => 'PostCropVignetteRoundness', 502 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 500 => 'PostCropVignetteStyle', 502 => 'PostCropVignetteStyle' },
	'postfocusmerging' => { 340 => 0xbf },
	'postreleaseburstlength' => { 241 => 0x714, 242 => 0x784, 313 => 0x289 },
	'potentialface1position' => { 437 => 0xb },
	'potentialface2position' => { 437 => 0x15 },
	'potentialface3position' => { 437 => 0x1f },
	'potentialface4position' => { 437 => 0x29 },
	'potentialface5position' => { 437 => 0x33 },
	'potentialface6position' => { 437 => 0x3d },
	'potentialface7position' => { 437 => 0x47 },
	'potentialface8position' => { 437 => 0x51 },
	'powersource' => { 354 => '0.1' },
	'poweruptime' => { 234 => 0xb6 },
	'preaf' => { 126 => '0.2' },
	'precaptureframes' => { 322 => 0x300 },
	'predictor' => { 119 => 0x13d },
	'preflashreturnstrength' => { 269 => 0x28a },
	'prefs' => { 131 => 0xdd, 387 => 'Prefs' },
	'prereadfastresetcount' => { 138 => 0x187e },
	'prereleaseburstlength' => { 241 => 0x712, 242 => 0x782, 313 => 0x287 },
	'preservedfilename' => { 530 => 'PreservedFileName' },
	'preservedspecimen' => { 118 => 'PreservedSpecimen' },
	'preservedspecimenmaterialsampleid' => { 118 => [\'PreservedSpecimen','PreservedSpecimenMaterialSampleID'] },
	'presettype' => { 500 => 'PresetType', 502 => 'PresetType' },
	'presetwhitebalance' => { 184 => 0x24, 476 => 0x8002 },
	'presetwhitebalanceadj' => { 476 => 0x8014 },
	'pressure' => { 119 => 0x9402, 507 => 'Pressure' },
	'previewapplicationname' => { 119 => 0xc716 },
	'previewapplicationversion' => { 119 => 0xc717 },
	'previewbutton' => { 297 => ['14.1','15.1'], 298 => '15.1', 300 => '15.1', 301 => '15.1', 306 => '29.1', 307 => '14.1', 310 => '15.1', 311 => '15.1' },
	'previewbuttonplusdials' => { 297 => ['14.2','15.2'], 298 => '15.2', 300 => '43.1', 301 => '43.1', 306 => '31.2', 310 => '43.1', 311 => '43.1' },
	'previewcolorspace' => { 119 => 0xc71a },
	'previewcropbottom' => { 386 => 0xef },
	'previewcropleft' => { 386 => 0xec },
	'previewcropright' => { 386 => 0xee },
	'previewcroptop' => { 386 => 0xed },
	'previewdate' => { 398 => 0x0 },
	'previewdatetime' => { 119 => 0xc71b },
	'previewimage' => { 113 => 0x2000, 114 => 'Exif-PreviewImage', 120 => 'PreviewImage', 122 => 0x4, 166 => 'data', 186 => 0x81, 322 => 0x280, 338 => 0x300, 400 => 'mcvr', 440 => 0x2001 },
	'previewimageborders' => { 375 => 0x3e },
	'previewimageheight' => { 73 => 0x4, 142 => 0xfa58 },
	'previewimagelength' => { 73 => 0x2, 113 => 0x3, 119 => [0x117,0x202], 186 => 0x89, 253 => 0x202, 317 => 0x102, 322 => 0x1037, 375 => 0x3, 406 => 0x1e, 411 => 0x3, 417 => [0x1b,0x1d], 430 => 0x202 },
	'previewimagename' => { 166 => '1Name' },
	'previewimagesize' => { 113 => 0x2, 147 => 0x2, 166 => 'ImageSize', 375 => 0x2, 417 => [0x1c,0x1e], 440 => 0xb02c, 476 => 0x9012 },
	'previewimagestart' => { 73 => 0x5, 113 => 0x4, 119 => [0x111,0x201], 186 => 0x88, 253 => 0x201, 317 => 0x101, 322 => 0x1036, 375 => 0x4, 406 => 0x1c, 411 => 0x2, 417 => [0x1a,0x1c], 430 => 0x201 },
	'previewimagetype' => { 166 => '0Type' },
	'previewimagevalid' => { 317 => 0x100, 322 => 0x1035 },
	'previewimagewidth' => { 73 => 0x3, 142 => 0xfa57 },
	'previewquality' => { 73 => 0x1 },
	'previewsettingsdigest' => { 119 => 0xc719 },
	'previewsettingsname' => { 119 => 0xc718 },
	'primaryafpoint' => { 193 => [0x38,0x44,0x7,0x8] },
	'primarychromaticities' => { 119 => 0x13f, 525 => 'PrimaryChromaticities' },
	'primaryftp' => { 490 => 'PrimaryFTP' },
	'primaryslot' => { 243 => 0x25, 261 => 0x2 },
	'printim' => { 119 => 0xc4a5 },
	'prioritysetinawb' => { 440 => 0x202b },
	'prioritysetupshutterrelease' => { 184 => 0x1d, 427 => 0x28 },
	'privatertkinfo' => { 492 => 'privateRTKInfo' },
	'processbordercolsleft' => { 138 => 0xc61 },
	'processbordercolsright' => { 138 => 0xc62 },
	'processborderrowsbottom' => { 138 => 0xc64 },
	'processborderrowstop' => { 138 => 0xc63 },
	'processingsoftware' => { 119 => 0xb },
	'processversion' => { 500 => 'ProcessVersion', 502 => 'ProcessVersion' },
	'producer' => { 179 => 'WM/Producer', 326 => 'Producer', 392 => "\xa9prd", 394 => 'producer', 400 => "\xa9prd", 516 => 'Producer' },
	'producerkeywords' => { 400 => "\xa9pdk" },
	'productcode' => { 519 => 'productCode' },
	'productid' => { 132 => 0x32, 392 => 'prID', 518 => 'productID' },
	'productidtype' => { 518 => 'productIDType' },
	'productinimage' => { 514 => 'ProductInImage' },
	'productinimagedescription' => { 514 => [\'ProductInImage','ProductInImageProductDescription'] },
	'productinimagegtin' => { 514 => [\'ProductInImage','ProductInImageProductGTIN'] },
	'productinimagename' => { 514 => [\'ProductInImage','ProductInImageProductName'] },
	'productinimageproductid' => { 514 => [\'ProductInImage','ProductInImageProductId'] },
	'productioncode' => { 355 => 0x2 },
	'productorserviceconstraints' => { 327 => 'ProductOrServiceConstraints' },
	'productversion' => { 392 => 'VERS' },
	'profession' => { 519 => 'profession' },
	'profile' => { 479 => [\'Profiles','ProfilesProfile'] },
	'profilecalibrationsig' => { 119 => 0xc6f4 },
	'profilecameraindices' => { 479 => [\'Profiles','ProfilesProfileCameraIndices'] },
	'profilecopyright' => { 119 => 0xc6fe },
	'profileembedpolicy' => { 119 => 0xc6fd },
	'profilegaintablemap' => { 119 => 0xcd2d },
	'profilehuesatmapdata1' => { 119 => 0xc6fa },
	'profilehuesatmapdata2' => { 119 => 0xc6fb },
	'profilehuesatmapdata3' => { 119 => 0xcd39 },
	'profilehuesatmapdims' => { 119 => 0xc6f9 },
	'profilehuesatmapencoding' => { 119 => 0xc7a3 },
	'profilelooktabledata' => { 119 => 0xc726 },
	'profilelooktabledims' => { 119 => 0xc725 },
	'profilelooktableencoding' => { 119 => 0xc7a4 },
	'profilename' => { 119 => 0xc6f8, 328 => 'iCCP-name' },
	'profiles' => { 479 => 'Profiles' },
	'profiletonecurve' => { 119 => 0xc6fc },
	'profiletype' => { 479 => [\'Profiles','ProfilesProfileType'] },
	'programiso' => { 340 => 0x3c },
	'programline' => { 356 => '1.1' },
	'programmode' => { 189 => 0x5 },
	'programshift' => { 234 => 0xd },
	'programversion' => { 131 => 0x46 },
	'prohibits' => { 498 => 'prohibits' },
	'projectiontype' => { 488 => 'ProjectionType', 489 => 'ProjectionType' },
	'projectname' => { 529 => 'projectName' },
	'projectref' => { 529 => 'projectRef' },
	'projectrefpath' => { 529 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 529 => [\'projectRef','projectRefType'] },
	'promotionurl' => { 179 => 'WM/PromotionURL' },
	'propertyreleaseid' => { 327 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 327 => 'PropertyReleaseStatus' },
	'provider' => { 179 => 'WM/Provider' },
	'province-state' => { 131 => 0x5f },
	'publicationdate' => { 519 => 'publicationDate' },
	'publicationdatea-platform' => { 519 => [\'publicationDate','publicationDateA-platform'] },
	'publicationdatedate' => { 519 => [\'publicationDate','publicationDateDate'] },
	'publicationdisplaydate' => { 519 => 'publicationDisplayDate' },
	'publicationdisplaydatea-platform' => { 519 => [\'publicationDisplayDate','publicationDisplayDateA-platform'] },
	'publicationdisplaydatedate' => { 519 => [\'publicationDisplayDate','publicationDisplayDateDate'] },
	'publicationevent' => { 514 => 'PublicationEvent' },
	'publicationeventdate' => { 514 => [\'PublicationEvent','PublicationEventDate'] },
	'publicationeventidentifier' => { 514 => [\'PublicationEvent','PublicationEventIdentifier'] },
	'publicationeventname' => { 514 => [\'PublicationEvent','PublicationEventName'] },
	'publicationname' => { 519 => 'publicationName' },
	'publisher' => { 179 => 'WM/Publisher', 392 => "\xa9pub", 394 => 'publisher', 503 => 'publisher' },
	'publishingfrequency' => { 519 => 'publishingFrequency' },
	'pulldown' => { 529 => 'pullDown' },
	'purchasedate' => { 392 => 'purd' },
	'purplehsl' => { 103 => 0x20916 },
	'pxshiftperiphedgenr' => { 476 => 0x9013 },
	'pxshiftperiphedgenrvalue' => { 476 => 0x9014 },
	'quality' => { 0 => 0x1, 34 => 0x3, 112 => 0x2, 113 => 0x3002, 127 => 0x1000, 140 => 0x9, 234 => 0x4, 280 => 0x3, 322 => 0x201, 335 => 0x300, 375 => 0x8, 382 => 0x2, 417 => 0x16, 427 => 0x56, 428 => 0x56, 429 => 0xb, 440 => [0x102,0x202e] },
	'quality2' => { 449 => 0x1170, 450 => 0x1174, 451 => 0x1150, 453 => 0x11a8, 454 => 0x1060, 455 => 0x258, 456 => 0x258, 457 => 0x247, 463 => 0x29, 464 => 0x25, 465 => 0x2a },
	'qualitybutton' => { 314 => 0x17d, 315 => 0x195 },
	'qualitybuttonplaybackmode' => { 314 => 0x1bf, 315 => 0x1d7 },
	'qualityhint' => { 1 => 0x1a },
	'qualitymode' => { 113 => 0x8 },
	'quantizationmethod' => { 133 => 0x78 },
	'quickadjust' => { 293 => 0x2a },
	'quickcontroldialinmeter' => { 84 => 0x703 },
	'quickfix' => { 290 => 0x416391c6 },
	'quickshot' => { 416 => 0x213 },
	'quiettime' => { 138 => 0x188a },
	'rads' => { 400 => 'rads' },
	'rangefinder' => { 302 => '4.1', 303 => '5.1', 304 => '5.1' },
	'rangemask' => { 500 => 'RangeMaskMapInfo', 502 => 'RangeMaskMapInfo' },
	'rangemaskmapinfo' => { 500 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfo'], 502 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfo'] },
	'rangemaskmapinfolabmax' => { 500 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMax'], 502 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMax'] },
	'rangemaskmapinfolabmin' => { 500 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMin'], 502 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMin'] },
	'rangemaskmapinfolumeq' => { 500 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLumEq'], 502 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLumEq'] },
	'rangemaskmapinforgbmax' => { 500 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMax'], 502 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMax'] },
	'rangemaskmapinforgbmin' => { 500 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMin'], 502 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMin'] },
	'rasterizedcaption' => { 131 => 0x7d },
	'rating' => { 119 => 0x4746, 127 => 0x1431, 386 => 0xdf, 392 => 'rtng', 400 => 'rtng', 440 => 0x2002, 495 => 'rating', 504 => 'rating', 514 => 'Rating', 519 => 'rating', 527 => 'Rating' },
	'ratingpercent' => { 119 => 0x4749, 178 => 'Rating', 392 => 'rate', 527 => 'RatingPercent' },
	'ratingregion' => { 514 => [\'Rating','RatingRatingRegion'] },
	'ratingregioncity' => { 514 => [\'Rating','RatingRatingRegionCity'] },
	'ratingregioncountrycode' => { 514 => [\'Rating','RatingRatingRegionCountryCode'] },
	'ratingregioncountryname' => { 514 => [\'Rating','RatingRatingRegionCountryName'] },
	'ratingregiongpsaltitude' => { 514 => [\'Rating','RatingRatingRegionGPSAltitude'] },
	'ratingregiongpslatitude' => { 514 => [\'Rating','RatingRatingRegionGPSLatitude'] },
	'ratingregiongpslongitude' => { 514 => [\'Rating','RatingRatingRegionGPSLongitude'] },
	'ratingregionidentifier' => { 514 => [\'Rating','RatingRatingRegionIdentifier'] },
	'ratingregionlocationid' => { 514 => [\'Rating','RatingRatingRegionLocationId'] },
	'ratingregionlocationname' => { 514 => [\'Rating','RatingRatingRegionLocationName'] },
	'ratingregionprovincestate' => { 514 => [\'Rating','RatingRatingRegionProvinceState'] },
	'ratingregionsublocation' => { 514 => [\'Rating','RatingRatingRegionSublocation'] },
	'ratingregionworldregion' => { 514 => [\'Rating','RatingRatingRegionWorldRegion'] },
	'ratingscalemaxvalue' => { 514 => [\'Rating','RatingRatingScaleMaxValue'] },
	'ratingscaleminvalue' => { 514 => [\'Rating','RatingRatingScaleMinValue'] },
	'ratingsourcelink' => { 514 => [\'Rating','RatingRatingSourceLink'] },
	'ratingvalue' => { 514 => [\'Rating','RatingRatingValue'] },
	'ratingvaluelogolink' => { 514 => [\'Rating','RatingRatingValueLogoLink'] },
	'rawandjpgrecording' => { 82 => 0x8, 186 => 0x109, 356 => 0xd },
	'rawbrightnessadj' => { 103 => 0x20001, 108 => 0x38 },
	'rawburstimagecount' => { 75 => 0x2 },
	'rawburstimagenum' => { 75 => 0x1 },
	'rawcoloradj' => { 108 => 0x2e },
	'rawcropbottom' => { 386 => 0xd4 },
	'rawcropleft' => { 386 => 0xd1 },
	'rawcropright' => { 386 => 0xd3 },
	'rawcroptop' => { 386 => 0xd2 },
	'rawcustomsaturation' => { 108 => 0x30 },
	'rawcustomtone' => { 108 => 0x34 },
	'rawdata' => { 414 => 0xa048 },
	'rawdatabyteorder' => { 414 => 0x40 },
	'rawdatacfapattern' => { 414 => 0x50 },
	'rawdatauniqueid' => { 119 => 0xc65d },
	'rawdepth' => { 188 => 0x10 },
	'rawdevartfilter' => { 324 => 0x121 },
	'rawdevautogradation' => { 324 => 0x119 },
	'rawdevcolorspace' => { 323 => 0x108, 324 => 0x109 },
	'rawdevcontrastvalue' => { 323 => 0x106, 324 => 0x105 },
	'rawdeveditstatus' => { 323 => 0x10b },
	'rawdevelopingsoftware' => { 119 => 0xa43a },
	'rawdevelopmentprocess' => { 375 => 0x62 },
	'rawdevengine' => { 323 => 0x109, 324 => 0x10b },
	'rawdevexposurebiasvalue' => { 323 => 0x100, 324 => 0x100 },
	'rawdevgradation' => { 324 => 0x112 },
	'rawdevgraypoint' => { 323 => 0x103, 324 => 0x104 },
	'rawdevmemorycoloremphasis' => { 323 => 0x105, 324 => 0x108 },
	'rawdevnoisereduction' => { 323 => 0x10a, 324 => 0x10a },
	'rawdevpicturemode' => { 324 => 0x10c },
	'rawdevpm_bwfilter' => { 324 => 0x110 },
	'rawdevpmcontrast' => { 324 => 0x10e },
	'rawdevpmnoisefilter' => { 324 => 0x120 },
	'rawdevpmpicturetone' => { 324 => 0x111 },
	'rawdevpmsaturation' => { 324 => 0x10d },
	'rawdevpmsharpness' => { 324 => 0x10f },
	'rawdevsaturation3' => { 324 => 0x113 },
	'rawdevsaturationemphasis' => { 323 => 0x104, 324 => 0x107 },
	'rawdevsettings' => { 323 => 0x10c },
	'rawdevsharpnessvalue' => { 323 => 0x107, 324 => 0x106 },
	'rawdevversion' => { 323 => 0x0, 324 => 0x0 },
	'rawdevwbfineadjustment' => { 323 => 0x102, 324 => 0x103 },
	'rawdevwhitebalance' => { 324 => 0x101 },
	'rawdevwhitebalancevalue' => { 323 => 0x101, 324 => 0x102 },
	'rawfile' => { 119 => 0xfe4c },
	'rawfilename' => { 500 => 'RawFileName', 502 => 'RawFileName' },
	'rawfiletype' => { 440 => 0x2029 },
	'rawformat' => { 345 => 0x2d, 384 => 0x10e },
	'rawimagecenter' => { 234 => 0x99 },
	'rawimagedigest' => { 119 => 0xc71c },
	'rawimagesize' => { 375 => 0x39 },
	'rawinfoversion' => { 325 => 0x0 },
	'rawjpgheight' => { 99 => 0x4 },
	'rawjpgquality' => { 57 => 0x6, 99 => 0x1 },
	'rawjpgsize' => { 57 => 0x7, 99 => 0x2 },
	'rawjpgwidth' => { 99 => 0x3 },
	'rawmeasuredrggb' => { 43 => 0x26a, 45 => 0x280, 47 => 0x194, 48 => [0x1ad,0x26b] },
	'rawrppused' => { 495 => 'rawrppused' },
	'rawtopreviewgain' => { 119 => 0xc7a8 },
	'readouttypeactual' => { 138 => 0x1903 },
	'readouttyperequested' => { 138 => 0x1902 },
	'reardisplay' => { 297 => '12.3', 298 => '6.2' },
	'recdevice' => { 514 => 'RecDevice' },
	'recdeviceattlensdescription' => { 514 => [\'RecDevice','RecDeviceAttLensDescription'] },
	'recdevicemanufacturer' => { 514 => [\'RecDevice','RecDeviceManufacturer'] },
	'recdevicemodelname' => { 514 => [\'RecDevice','RecDeviceModelName'] },
	'recdeviceownersdeviceid' => { 514 => [\'RecDevice','RecDeviceOwnersDeviceId'] },
	'recdeviceserialnumber' => { 514 => [\'RecDevice','RecDeviceSerialNumber'] },
	'recipeendingpage' => { 521 => 'recipeEndingPage' },
	'recipepagerange' => { 521 => 'recipePageRange' },
	'recipesource' => { 521 => 'recipeSource' },
	'recipestartingpage' => { 521 => 'recipeStartingPage' },
	'recipetitle' => { 521 => 'recipeTitle' },
	'recognizedface1age' => { 333 => 0x20 },
	'recognizedface1name' => { 333 => 0x4 },
	'recognizedface1position' => { 333 => 0x18 },
	'recognizedface2age' => { 333 => 0x50 },
	'recognizedface2name' => { 333 => 0x34 },
	'recognizedface2position' => { 333 => 0x48 },
	'recognizedface3age' => { 333 => 0x80 },
	'recognizedface3name' => { 333 => 0x64 },
	'recognizedface3position' => { 333 => 0x78 },
	'recognizedfaceflags' => { 340 => 0x63 },
	'recommendedexposureindex' => { 119 => 0x8832, 507 => 'RecommendedExposureIndex' },
	'record' => { 118 => 'Record' },
	'recordbasisofrecord' => { 118 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 118 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 118 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 118 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 118 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 118 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 184 => 0x4d },
	'recorddynamicproperties' => { 118 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 97 => 0x1804 },
	'recordinformationwithheld' => { 118 => [\'Record','RecordInformationWithheld'] },
	'recordingcopyright' => { 400 => "\xa9phg" },
	'recordingformat' => { 407 => 0x1000 },
	'recordingmode' => { 112 => 0x1, 382 => 0x1 },
	'recordinstitutioncode' => { 118 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 118 => [\'Record','RecordInstitutionID'] },
	'recordlabelname' => { 400 => "\xa9lab" },
	'recordlabelurl' => { 400 => "\xa9lal" },
	'recordlocationdata' => { 240 => 0x660, 241 => 0x690, 242 => 0x6f8 },
	'recordmode' => { 34 => 0x9, 113 => 0x3000 },
	'recordownerinstitutioncode' => { 118 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 416 => 0x217 },
	'redbalance' => { 322 => 0x1017, 345 => 0x11, 375 => 0x1c },
	'redcurvelimits' => { 108 => 0x18a },
	'redcurvepoints' => { 107 => 0x2d, 108 => 0x160 },
	'redeyecorrection' => { 294 => 0x0 },
	'redeyeinfo' => { 500 => 'RedEyeInfo', 502 => 'RedEyeInfo' },
	'redeyereduction' => { 184 => 0x41, 427 => 0x6a, 429 => 0x28 },
	'redeyeremoval' => { 340 => 0xb9 },
	'redhsl' => { 103 => 0x20910 },
	'redhue' => { 500 => 'RedHue', 502 => 'RedHue' },
	'redsaturation' => { 500 => 'RedSaturation', 502 => 'RedSaturation' },
	'reductionmatrix1' => { 119 => 0xc625 },
	'reductionmatrix2' => { 119 => 0xc626 },
	'reductionmatrix3' => { 119 => 0xcd3a },
	'reelname' => { 119 => 0xc789, 400 => 'reel' },
	'reference1' => { 512 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 512 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 512 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 512 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 512 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 512 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 119 => 0x214, 525 => 'ReferenceBlackWhite' },
	'referencedate' => { 131 => 0x2f },
	'referencenumber' => { 131 => 0x32 },
	'references' => { 157 => 'References' },
	'referenceservice' => { 131 => 0x2d },
	'regionappliedtodimensions' => { 172 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 172 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 172 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 172 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 172 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 172 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 172 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 172 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 172 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 172 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 172 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 172 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 327 => 'RegionConstraints' },
	'regiondescription' => { 172 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 172 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 172 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 172 => 'Regions' },
	'regioninfodateregionsvalid' => { 175 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 175 => 'RegionInfo' },
	'regioninforegions' => { 175 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 172 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 172 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 175 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 175 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 175 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 175 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 175 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionrotation' => { 172 => [\'Regions','RegionsRegionListRotation'] },
	'regionseealso' => { 172 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 172 => [\'Regions','RegionsRegionListType'] },
	'registryentryrole' => { 514 => [\'RegistryId','RegistryIdRegEntryRole'] },
	'registryid' => { 514 => 'RegistryId' },
	'registryitemid' => { 514 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 514 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 155 => 'data' },
	'relatedaudiofilename' => { 155 => '1Name' },
	'relatedaudiofiletype' => { 155 => '0Type' },
	'relatedimagefileformat' => { 119 => 0x1000 },
	'relatedimageheight' => { 119 => 0x1002 },
	'relatedimagewidth' => { 119 => 0x1001 },
	'relatedresourceid' => { 118 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 119 => 0xa004, 506 => 'RelatedSoundFile' },
	'relatedvideofile' => { 169 => 'data' },
	'relatedvideofilename' => { 169 => '1Name' },
	'relatedvideofiletype' => { 169 => '0Type' },
	'relation' => { 503 => 'relation' },
	'relationshipaccordingto' => { 118 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 118 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 118 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipofresourceid' => { 118 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResourceID'] },
	'relationshipremarks' => { 118 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativealtitude' => { 116 => 'RelativeAltitude' },
	'relativepeakaudiofilepath' => { 529 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 529 => 'relativeTimestamp' },
	'relativetimestampscale' => { 529 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 529 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 297 => '17.8', 298 => '18.5', 300 => '18.4', 301 => '18.4', 306 => '33.8', 307 => '17.6', 310 => '18.5', 311 => '18.4' },
	'releasedate' => { 131 => 0x1e, 392 => 'rldt', 495 => 'ReleaseDate', 529 => 'releaseDate' },
	'releasemode' => { 113 => 0x3001, 238 => 0x5c, 271 => 0x184d, 440 => 0xb049 },
	'releasemode2' => { 449 => 0x112c, 450 => [0x112c,0x8], 451 => [0x1108,0x8], 452 => [0x1184,0x8], 453 => [0x1160,0x8], 454 => [0x4,0x1018], 455 => [0x4,0x210], 456 => [0x4,0x210], 457 => [0x4,0x208], 459 => [0x67,0x3f], 460 => [0x6b,0x6d,0x73,0x4b], 461 => [0x6b,0x4b], 462 => 0x1f, 463 => 0x10, 464 => 0x10, 465 => 0x9, 472 => 0x34 },
	'releasemode3' => { 449 => 0x1128, 450 => 0x1128, 451 => 0x1104, 452 => 0x1180, 453 => 0x115c, 454 => 0x1014, 455 => 0x20c, 456 => 0x20c, 457 => 0x204 },
	'releaseready' => { 514 => 'ReleaseReady' },
	'releasesetting' => { 97 => 0x1016 },
	'releasetime' => { 131 => 0x23, 495 => 'ReleaseTime' },
	'remoteonduration' => { 299 => '3.4', 302 => '17.2', 303 => '18.2', 304 => '18.2', 305 => '18.2', 307 => '18.2', 308 => '4.3', 312 => '19.2' },
	'renditionclass' => { 530 => 'RenditionClass' },
	'renditionof' => { 530 => 'RenditionOf' },
	'renditionofalternatepaths' => { 530 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 530 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 530 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 530 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 530 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 530 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionoflasturl' => { 530 => [\'RenditionOf','RenditionOfLastURL'] },
	'renditionoflinkcategory' => { 530 => [\'RenditionOf','RenditionOfLinkCategory'] },
	'renditionoflinkform' => { 530 => [\'RenditionOf','RenditionOfLinkForm'] },
	'renditionofmanager' => { 530 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 530 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 530 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 530 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 530 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 530 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 530 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofplacedresolutionunit' => { 530 => [\'RenditionOf','RenditionOfPlacedResolutionUnit'] },
	'renditionofplacedxresolution' => { 530 => [\'RenditionOf','RenditionOfPlacedXResolution'] },
	'renditionofplacedyresolution' => { 530 => [\'RenditionOf','RenditionOfPlacedYResolution'] },
	'renditionofrenditionclass' => { 530 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 530 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 530 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 530 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 530 => 'RenditionParams' },
	'repeatingflashcount' => { 212 => 0xd, 213 => 0xe, 214 => 0xe, 215 => 0xe, 216 => 0xe, 217 => 0xe, 306 => '17.2', 307 => '24.2', 308 => '9.2', 309 => '24.2', 312 => '25.2' },
	'repeatingflashcountbuilt-in' => { 278 => 0x4db },
	'repeatingflashcountexternal' => { 278 => 0x4c3 },
	'repeatingflashoutput' => { 306 => '17.1', 307 => '24.1', 308 => '9.1', 309 => '24.1', 312 => '25.1' },
	'repeatingflashoutputexternal' => { 278 => 0x4c0 },
	'repeatingflashrate' => { 212 => 0xc, 213 => 0xd, 214 => 0xd, 215 => 0xd, 216 => 0xd, 217 => 0xd, 306 => '18.1', 307 => '25.1', 308 => '10.1', 309 => '25.1', 312 => '26.1' },
	'repeatingflashratebuilt-in' => { 278 => 0x4da },
	'repeatingflashrateexternal' => { 278 => 0x4c2 },
	'requirements' => { 400 => "\xa9req" },
	'requires' => { 498 => 'requires' },
	'resampleparams' => { 529 => 'resampleParams' },
	'resampleparamsquality' => { 529 => [\'resampleParams','resampleParamsQuality'] },
	'resamplingkerneldenominators050' => { 138 => 0xe50 },
	'resamplingkerneldenominators067' => { 138 => 0xe4f },
	'resamplingkerneldenominators100' => { 138 => 0xe51 },
	'resaved' => { 416 => 0x21e },
	'resetblacksegrows' => { 138 => 0x181a },
	'resolution' => { 162 => 'Resolution' },
	'resolutionmode' => { 417 => [0x87,0x4] },
	'resolutionunit' => { 119 => 0x128, 134 => 0x2, 525 => 'ResolutionUnit' },
	'resourceid' => { 118 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 118 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 118 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictdrivemodes' => { 84 => 0x612 },
	'restrictions' => { 522 => 'restrictions' },
	'retouchareafeather' => { 500 => [\'RetouchAreas','RetouchAreasFeather'], 502 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 500 => [\'RetouchAreas','RetouchAreasMasksAlpha'], 502 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 500 => [\'RetouchAreas','RetouchAreasMasksAngle'], 502 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 500 => [\'RetouchAreas','RetouchAreasMasksBottom'], 502 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 500 => [\'RetouchAreas','RetouchAreasMasksCenterValue'], 502 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 500 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'], 502 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 500 => [\'RetouchAreas','RetouchAreasMasksDabs'], 502 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 500 => [\'RetouchAreas','RetouchAreasMasksFeather'], 502 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 500 => [\'RetouchAreas','RetouchAreasMasksFlipped'], 502 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 500 => [\'RetouchAreas','RetouchAreasMasksFlow'], 502 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 500 => [\'RetouchAreas','RetouchAreasMasksFullX'], 502 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 500 => [\'RetouchAreas','RetouchAreasMasksFullY'], 502 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskinputdigest' => { 500 => [\'RetouchAreas','RetouchAreasMasksInputDigest'], 502 => [\'RetouchAreas','RetouchAreasMasksInputDigest'] },
	'retouchareamaskleft' => { 500 => [\'RetouchAreas','RetouchAreasMasksLeft'], 502 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmaskactive' => { 500 => [\'RetouchAreas','RetouchAreasMasksMaskActive'], 502 => [\'RetouchAreas','RetouchAreasMasksMaskActive'] },
	'retouchareamaskmaskblendmode' => { 500 => [\'RetouchAreas','RetouchAreasMasksMaskBlendMode'], 502 => [\'RetouchAreas','RetouchAreasMasksMaskBlendMode'] },
	'retouchareamaskmaskdigest' => { 500 => [\'RetouchAreas','RetouchAreasMasksMaskDigest'], 502 => [\'RetouchAreas','RetouchAreasMasksMaskDigest'] },
	'retouchareamaskmaskinverted' => { 500 => [\'RetouchAreas','RetouchAreasMasksMaskInverted'], 502 => [\'RetouchAreas','RetouchAreasMasksMaskInverted'] },
	'retouchareamaskmaskname' => { 500 => [\'RetouchAreas','RetouchAreasMasksMaskName'], 502 => [\'RetouchAreas','RetouchAreasMasksMaskName'] },
	'retouchareamaskmasks' => { 500 => [\'RetouchAreas','RetouchAreasMasksMasks'], 502 => [\'RetouchAreas','RetouchAreasMasksMasks'] },
	'retouchareamaskmasksalpha' => { 500 => [\'RetouchAreas','RetouchAreasMasksMasksAlpha'], 502 => [\'RetouchAreas','RetouchAreasMasksMasksAlpha'] },
	'retouchareamaskmasksangle' => { 500 => [\'RetouchAreas','RetouchAreasMasksMasksAngle'], 502 => [\'RetouchAreas','RetouchAreasMasksMasksAngle'] },
	'retouchareamaskmasksbottom' => { 500 => [\'RetouchAreas','RetouchAreasMasksMasksBottom'], 502 => [\'RetouchAreas','RetouchAreasMasksMasksBottom'] },
	'retouchareamaskmaskscentervalue' => { 500 => [\'RetouchAreas','RetouchAreasMasksMasksCenterValue'], 502 => [\'RetouchAreas','RetouchAreasMasksMasksCenterValue'] },
	'retouchareamaskmaskscenterweight' => { 500 => [\'RetouchAreas','RetouchAreasMasksMasksCenterWeight'], 502 => [\'RetouchAreas','RetouchAreasMasksMasksCenterWeight'] },
	'retouchareamaskmasksdabs' => { 500 => [\'RetouchAreas','RetouchAreasMasksMasksDabs'], 502 => [\'RetouchAreas','RetouchAreasMasksMasksDabs'] },
	'retouchareamaskmasksfeather' => { 500 => [\'RetouchAreas','RetouchAreasMasksMasksFeather'], 502 => [\'RetouchAreas','RetouchAreasMasksMasksFeather'] },
	'retouchareamaskmasksflipped' => { 500 => [\'RetouchAreas','RetouchAreasMasksMasksFlipped'], 502 => [\'RetouchAreas','RetouchAreasMasksMasksFlipped'] },
	'retouchareamaskmasksflow' => { 500 => [\'RetouchAreas','RetouchAreasMasksMasksFlow'], 502 => [\'RetouchAreas','RetouchAreasMasksMasksFlow'] },
	'retouchareamaskmasksfullx' => { 500 => [\'RetouchAreas','RetouchAreasMasksMasksFullX'], 502 => [\'RetouchAreas','RetouchAreasMasksMasksFullX'] },
	'retouchareamaskmasksfully' => { 500 => [\'RetouchAreas','RetouchAreasMasksMasksFullY'], 502 => [\'RetouchAreas','RetouchAreasMasksMasksFullY'] },
	'retouchareamaskmasksinputdigest' => { 500 => [\'RetouchAreas','RetouchAreasMasksMasksInputDigest'], 502 => [\'RetouchAreas','RetouchAreasMasksMasksInputDigest'] },
	'retouchareamaskmasksleft' => { 500 => [\'RetouchAreas','RetouchAreasMasksMasksLeft'], 502 => [\'RetouchAreas','RetouchAreasMasksMasksLeft'] },
	'retouchareamaskmasksmaskactive' => { 500 => [\'RetouchAreas','RetouchAreasMasksMasksMaskActive'], 502 => [\'RetouchAreas','RetouchAreasMasksMasksMaskActive'] },
	'retouchareamaskmasksmaskblendmode' => { 500 => [\'RetouchAreas','RetouchAreasMasksMasksMaskBlendMode'], 502 => [\'RetouchAreas','RetouchAreasMasksMasksMaskBlendMode'] },
	'retouchareamaskmasksmaskdigest' => { 500 => [\'RetouchAreas','RetouchAreasMasksMasksMaskDigest'], 502 => [\'RetouchAreas','RetouchAreasMasksMasksMaskDigest'] },
	'retouchareamaskmasksmaskinverted' => { 500 => [\'RetouchAreas','RetouchAreasMasksMasksMaskInverted'], 502 => [\'RetouchAreas','RetouchAreasMasksMasksMaskInverted'] },
	'retouchareamaskmasksmaskname' => { 500 => [\'RetouchAreas','RetouchAreasMasksMasksMaskName'], 502 => [\'RetouchAreas','RetouchAreasMasksMasksMaskName'] },
	'retouchareamaskmasksmasksubtype' => { 500 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSubType'], 502 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSubType'] },
	'retouchareamaskmasksmasksyncid' => { 500 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSyncID'], 502 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSyncID'] },
	'retouchareamaskmasksmaskversion' => { 500 => [\'RetouchAreas','RetouchAreasMasksMasksMaskVersion'], 502 => [\'RetouchAreas','RetouchAreasMasksMasksMaskVersion'] },
	'retouchareamaskmasksmidpoint' => { 500 => [\'RetouchAreas','RetouchAreasMasksMasksMidpoint'], 502 => [\'RetouchAreas','RetouchAreasMasksMasksMidpoint'] },
	'retouchareamaskmasksorigin' => { 500 => [\'RetouchAreas','RetouchAreasMasksMasksOrigin'], 502 => [\'RetouchAreas','RetouchAreasMasksMasksOrigin'] },
	'retouchareamaskmasksperimetervalue' => { 500 => [\'RetouchAreas','RetouchAreasMasksMasksPerimeterValue'], 502 => [\'RetouchAreas','RetouchAreasMasksMasksPerimeterValue'] },
	'retouchareamaskmasksradius' => { 500 => [\'RetouchAreas','RetouchAreasMasksMasksRadius'], 502 => [\'RetouchAreas','RetouchAreasMasksMasksRadius'] },
	'retouchareamaskmasksreferencepoint' => { 500 => [\'RetouchAreas','RetouchAreasMasksMasksReferencePoint'], 502 => [\'RetouchAreas','RetouchAreasMasksMasksReferencePoint'] },
	'retouchareamaskmasksright' => { 500 => [\'RetouchAreas','RetouchAreasMasksMasksRight'], 502 => [\'RetouchAreas','RetouchAreasMasksMasksRight'] },
	'retouchareamaskmasksroundness' => { 500 => [\'RetouchAreas','RetouchAreasMasksMasksRoundness'], 502 => [\'RetouchAreas','RetouchAreasMasksMasksRoundness'] },
	'retouchareamaskmaskssizex' => { 500 => [\'RetouchAreas','RetouchAreasMasksMasksSizeX'], 502 => [\'RetouchAreas','RetouchAreasMasksMasksSizeX'] },
	'retouchareamaskmaskssizey' => { 500 => [\'RetouchAreas','RetouchAreasMasksMasksSizeY'], 502 => [\'RetouchAreas','RetouchAreasMasksMasksSizeY'] },
	'retouchareamaskmaskstop' => { 500 => [\'RetouchAreas','RetouchAreasMasksMasksTop'], 502 => [\'RetouchAreas','RetouchAreasMasksMasksTop'] },
	'retouchareamaskmasksubtype' => { 500 => [\'RetouchAreas','RetouchAreasMasksMaskSubType'], 502 => [\'RetouchAreas','RetouchAreasMasksMaskSubType'] },
	'retouchareamaskmasksvalue' => { 500 => [\'RetouchAreas','RetouchAreasMasksMasksMaskValue'], 502 => [\'RetouchAreas','RetouchAreasMasksMasksMaskValue'] },
	'retouchareamaskmasksversion' => { 500 => [\'RetouchAreas','RetouchAreasMasksMasksVersion'], 502 => [\'RetouchAreas','RetouchAreasMasksMasksVersion'] },
	'retouchareamaskmaskswhat' => { 500 => [\'RetouchAreas','RetouchAreasMasksMasksWhat'], 502 => [\'RetouchAreas','RetouchAreasMasksMasksWhat'] },
	'retouchareamaskmaskswholeimagearea' => { 500 => [\'RetouchAreas','RetouchAreasMasksMasksWholeImageArea'], 502 => [\'RetouchAreas','RetouchAreasMasksMasksWholeImageArea'] },
	'retouchareamaskmasksx' => { 500 => [\'RetouchAreas','RetouchAreasMasksMasksX'], 502 => [\'RetouchAreas','RetouchAreasMasksMasksX'] },
	'retouchareamaskmasksy' => { 500 => [\'RetouchAreas','RetouchAreasMasksMasksY'], 502 => [\'RetouchAreas','RetouchAreasMasksMasksY'] },
	'retouchareamaskmasksyncid' => { 500 => [\'RetouchAreas','RetouchAreasMasksMaskSyncID'], 502 => [\'RetouchAreas','RetouchAreasMasksMaskSyncID'] },
	'retouchareamaskmaskszerox' => { 500 => [\'RetouchAreas','RetouchAreasMasksMasksZeroX'], 502 => [\'RetouchAreas','RetouchAreasMasksMasksZeroX'] },
	'retouchareamaskmaskszeroy' => { 500 => [\'RetouchAreas','RetouchAreasMasksMasksZeroY'], 502 => [\'RetouchAreas','RetouchAreasMasksMasksZeroY'] },
	'retouchareamaskmaskversion' => { 500 => [\'RetouchAreas','RetouchAreasMasksMaskVersion'], 502 => [\'RetouchAreas','RetouchAreasMasksMaskVersion'] },
	'retouchareamaskmidpoint' => { 500 => [\'RetouchAreas','RetouchAreasMasksMidpoint'], 502 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskorigin' => { 500 => [\'RetouchAreas','RetouchAreasMasksOrigin'], 502 => [\'RetouchAreas','RetouchAreasMasksOrigin'] },
	'retouchareamaskperimetervalue' => { 500 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'], 502 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 500 => [\'RetouchAreas','RetouchAreasMasksRadius'], 502 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskrange' => { 500 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMask'], 502 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMask'] },
	'retouchareamaskrangeareamodels' => { 500 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModels'], 502 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModels'] },
	'retouchareamaskrangeareamodelscolorsampleinfo' => { 500 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 502 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'retouchareamaskrangeareamodelscomponents' => { 500 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsAreaComponents'], 502 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'retouchareamaskrangecoloramount' => { 500 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskColorAmount'], 502 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskColorAmount'] },
	'retouchareamaskrangedepthfeather' => { 500 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthFeather'], 502 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthFeather'] },
	'retouchareamaskrangedepthmax' => { 500 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMax'], 502 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMax'] },
	'retouchareamaskrangedepthmin' => { 500 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMin'], 502 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMin'] },
	'retouchareamaskrangeinvert' => { 500 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskInvert'], 502 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskInvert'] },
	'retouchareamaskrangelumfeather' => { 500 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumFeather'], 502 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumFeather'] },
	'retouchareamaskrangeluminancedepthsampleinfo' => { 500 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 502 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'retouchareamaskrangelummax' => { 500 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMax'], 502 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMax'] },
	'retouchareamaskrangelummin' => { 500 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMin'], 502 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMin'] },
	'retouchareamaskrangelumrange' => { 500 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumRange'], 502 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumRange'] },
	'retouchareamaskrangesampletype' => { 500 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskSampleType'], 502 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskSampleType'] },
	'retouchareamaskrangetype' => { 500 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskType'], 502 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskType'] },
	'retouchareamaskrangeversion' => { 500 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskVersion'], 502 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskVersion'] },
	'retouchareamaskreferencepoint' => { 500 => [\'RetouchAreas','RetouchAreasMasksReferencePoint'], 502 => [\'RetouchAreas','RetouchAreasMasksReferencePoint'] },
	'retouchareamaskright' => { 500 => [\'RetouchAreas','RetouchAreasMasksRight'], 502 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 500 => [\'RetouchAreas','RetouchAreasMasksRoundness'], 502 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 500 => [\'RetouchAreas','RetouchAreasMasks'], 502 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 500 => [\'RetouchAreas','RetouchAreasMasksSizeX'], 502 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 500 => [\'RetouchAreas','RetouchAreasMasksSizeY'], 502 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 500 => [\'RetouchAreas','RetouchAreasMasksTop'], 502 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 500 => [\'RetouchAreas','RetouchAreasMasksMaskValue'], 502 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 500 => [\'RetouchAreas','RetouchAreasMasksVersion'], 502 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 500 => [\'RetouchAreas','RetouchAreasMasksWhat'], 502 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskwholeimagearea' => { 500 => [\'RetouchAreas','RetouchAreasMasksWholeImageArea'], 502 => [\'RetouchAreas','RetouchAreasMasksWholeImageArea'] },
	'retouchareamaskx' => { 500 => [\'RetouchAreas','RetouchAreasMasksX'], 502 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 500 => [\'RetouchAreas','RetouchAreasMasksY'], 502 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 500 => [\'RetouchAreas','RetouchAreasMasksZeroX'], 502 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 500 => [\'RetouchAreas','RetouchAreasMasksZeroY'], 502 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 500 => [\'RetouchAreas','RetouchAreasMethod'], 502 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 500 => [\'RetouchAreas','RetouchAreasOffsetY'], 502 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 500 => [\'RetouchAreas','RetouchAreasOpacity'], 502 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 500 => 'RetouchAreas', 502 => 'RetouchAreas' },
	'retouchareaseed' => { 500 => [\'RetouchAreas','RetouchAreasSeed'], 502 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 500 => [\'RetouchAreas','RetouchAreasSourceState'], 502 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 500 => [\'RetouchAreas','RetouchAreasSourceX'], 502 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 500 => [\'RetouchAreas','RetouchAreasSpotType'], 502 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 234 => 0x9e },
	'retouchinfo' => { 500 => 'RetouchInfo', 502 => 'RetouchInfo' },
	'retouchnefprocessing' => { 255 => 0x5 },
	'retractlensonpoweroff' => { 84 => 0x814 },
	'reuse' => { 327 => 'Reuse' },
	'reuseallowed' => { 532 => 'ReuseAllowed' },
	'reuseprohibited' => { 522 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 304 => '5.2' },
	'reversefocusring' => { 313 => 0x163, 314 => 0x163, 315 => 0x17b },
	'reverseindicators' => { 297 => '12.1', 298 => '6.1', 300 => '6.1', 301 => '6.1', 302 => '4.3', 303 => '5.2', 304 => '5.4', 306 => '33.5', 307 => '5.1', 310 => '6.1', 311 => '6.1', 312 => '6.2', 313 => 0xc1, 314 => 0xc1, 315 => 0xc1 },
	'reverseshutterspeedaperture' => { 304 => '5.3' },
	'revision' => { 504 => 'revision' },
	'rflensmffocusringsensitivity' => { 84 => 0x714 },
	'rflenstype' => { 57 => 0x3d },
	'rgbcurvelimits' => { 108 => 0x238 },
	'rgbcurvepoints' => { 107 => 0x7, 108 => 0x20e },
	'rgbtables' => { 119 => 0xcd3b },
	'richtextcomment' => { 509 => 'RichTextComment' },
	'ricohdate' => { 406 => 0x6 },
	'ricohimageheight' => { 406 => 0x2 },
	'ricohimagewidth' => { 406 => 0x0 },
	'rightalbedo' => { 491 => 'RightAlbedo' },
	'rightascension' => { 165 => 'RightAscension' },
	'rights' => { 503 => 'rights' },
	'rightsagent' => { 522 => 'rightsAgent' },
	'rightsowner' => { 522 => 'rightsOwner' },
	'roll' => { 115 => 0x8, 400 => ['roll',"\xa9frl"] },
	'rollangle' => { 127 => 0x144d, 247 => 0x0, 317 => 0x903, 340 => 0x90, 374 => 0x1, 412 => 0x2 },
	'romoperationmode' => { 97 => 0x80d },
	'rotation' => { 30 => 0x17, 31 => 0x18, 96 => 0x3, 103 => 0x10002, 108 => 0x26e, 114 => 'QuickTime-Rotation', 123 => 0x4, 165 => 'Rotation', 182 => [0x65,0x50], 183 => 0x46, 184 => 0x5a, 187 => 0x10, 256 => 0x1a, 271 => 0x3693, 277 => '590.1', 290 => 0x76a43207, 340 => 0x30, 356 => '17.2', 386 => 0xd8, 393 => 'irot', 427 => 0x3f, 428 => 0x3f, 438 => 0x10 },
	'routedto' => { 508 => 'RoutedTo' },
	'routing' => { 391 => 'Routing' },
	'routingdestinations' => { 490 => 'RoutingDestinations' },
	'routingexclusions' => { 490 => 'RoutingExclusions' },
	'routingnotes' => { 508 => 'RoutingNotes' },
	'rowsperstrip' => { 119 => 0x116 },
	'rpp' => { 495 => 'rpp' },
	'rtkflag' => { 116 => 'RtkFlag' },
	'rtkstdhgt' => { 116 => 'RtkStdHgt' },
	'rtkstdlat' => { 116 => 'RtkStdLat' },
	'rtkstdlon' => { 116 => 'RtkStdLon' },
	'safetyshift' => { 84 => 0x108 },
	'safetyshiftinavortv' => { 82 => 0x10, 83 => 0x10, 85 => 0xf, 86 => 0x10, 89 => 0x10 },
	'sameexposurefornewaperture' => { 84 => 0x112 },
	'samplebits' => { 155 => 'SampleBits' },
	'samplepagerange' => { 519 => 'samplePageRange' },
	'samplerate' => { 155 => 'SampleRate' },
	'samplesperpixel' => { 119 => 0x115, 345 => 0x8, 525 => 'SamplesPerPixel' },
	'samplestructure' => { 133 => 0x5a },
	'samsungmodelid' => { 414 => 0x3 },
	'sanyoquality' => { 416 => 0x201 },
	'sanyothumbnail' => { 416 => 0x100 },
	'saturation' => { 10 => 0x6e, 12 => 0x76, 34 => 0xe, 51 => 0x1, 63 => 0x7, 112 => 0xd, 113 => [0x3013,0x1f], 119 => [0xa409,0xfe55], 127 => 0x1003, 156 => 'Saturation', 181 => 0x1f, 182 => 0x32, 183 => 0x28, 184 => 0x1a, 189 => 0x1, 234 => 0xaa, 249 => 0x35, 250 => 0x3b, 251 => 0x43, 340 => 0x40, 342 => 0x300d, 375 => 0x1f, 382 => 0xd, 401 => 0x27, 403 => 0x58, 406 => 0x28, 407 => 0x1013, 417 => 0x10, 427 => 0x1e, 428 => 0x1b, 440 => 0x2005, 500 => 'Saturation', 502 => 'Saturation', 506 => 'Saturation' },
	'saturationadj' => { 103 => 0x20901, 108 => 0x116, 234 => 0x94, 289 => 0x1, 293 => 0x2e, 476 => 0x8016 },
	'saturationadjustmentaqua' => { 500 => 'SaturationAdjustmentAqua', 502 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 500 => 'SaturationAdjustmentBlue', 502 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 500 => 'SaturationAdjustmentGreen', 502 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 500 => 'SaturationAdjustmentMagenta', 502 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 500 => 'SaturationAdjustmentOrange', 502 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 500 => 'SaturationAdjustmentPurple', 502 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 500 => 'SaturationAdjustmentRed', 502 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 500 => 'SaturationAdjustmentYellow', 502 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 71 => 0x98 },
	'saturationfaithful' => { 19 => 0xfe, 70 => 0x68, 71 => 0x68 },
	'saturationlandscape' => { 19 => 0xfc, 70 => 0x38, 71 => 0x38 },
	'saturationmonochrome' => { 70 => 0x80, 71 => 0x80 },
	'saturationneutral' => { 19 => 0xfd, 70 => 0x50, 71 => 0x50 },
	'saturationportrait' => { 19 => 0xfb, 70 => 0x20, 71 => 0x20 },
	'saturationsetting' => { 325 => 0x1010, 429 => 0x11, 445 => 0x9 },
	'saturationstandard' => { 19 => 0xfa, 70 => 0x8, 71 => 0x8 },
	'saturationuserdef1' => { 19 => 0x100, 70 => 0x98, 71 => 0xb0 },
	'saturationuserdef2' => { 19 => 0x101, 70 => 0xb0, 71 => 0xc8 },
	'saturationuserdef3' => { 19 => 0x102, 70 => 0xc8, 71 => 0xe0 },
	'saveid' => { 530 => 'SaveID' },
	'sbaanalysiscomplete' => { 138 => 0xc35 },
	'sbablack' => { 138 => 0xc25 },
	'sbagmoffset' => { 138 => 0xc4a },
	'sbagray' => { 138 => 0xc26 },
	'sbagreenmagentabal' => { 138 => 0xc33 },
	'sbahighgray' => { 138 => 0xc46 },
	'sbailloffset' => { 138 => 0xc49 },
	'sbailluminantbal' => { 138 => 0xc34 },
	'sbalowgray' => { 138 => 0xc47 },
	'sbaneutralbal' => { 138 => 0xc32 },
	'sbawhite' => { 138 => 0xc27 },
	'scaletype' => { 529 => 'scaleType' },
	'scanimageenhancer' => { 257 => 0x60 },
	'scanningdirection' => { 133 => 0x64 },
	'scene' => { 400 => 'scen', 513 => 'Scene', 529 => 'scene' },
	'scenearea' => { 320 => 0x211, 322 => 0x1031 },
	'sceneassist' => { 234 => 0x9c },
	'scenecapturetype' => { 119 => 0xa406, 506 => 'SceneCaptureType' },
	'scenedetect' => { 320 => 0x210, 322 => 0x1030 },
	'scenedetectdata' => { 320 => 0x212, 322 => 0x1033 },
	'sceneflags' => { 1 => 0x25 },
	'scenemode' => { 142 => 0xfa02, 186 => 0x100, 234 => 0x8f, 317 => 0x509, 322 => 0x403, 340 => 0x8001, 349 => 0xf, 440 => 0xb023 },
	'scenemodeused' => { 144 => [0x6002,0xf002] },
	'scenerecognition' => { 127 => 0x1425 },
	'scenereferred' => { 510 => 'scene_referred' },
	'sceneselect' => { 416 => 0x21f },
	'scenetype' => { 119 => 0xa301, 506 => 'SceneType' },
	'screentips' => { 297 => '12.7', 298 => '5.3', 306 => '13.1', 307 => '4.4', 310 => '5.4', 312 => '5.1' },
	'scriptversion' => { 138 => 0x1770 },
	'sdrblend' => { 500 => 'SDRBlend', 502 => 'SDRBlend' },
	'sdrbrightness' => { 500 => 'SDRBrightness', 502 => 'SDRBrightness' },
	'sdrcontrast' => { 500 => 'SDRContrast', 502 => 'SDRContrast' },
	'sdrhighlights' => { 500 => 'SDRHighlights', 502 => 'SDRHighlights' },
	'sdrshadows' => { 500 => 'SDRShadows', 502 => 'SDRShadows' },
	'sdrwhites' => { 500 => 'SDRWhites', 502 => 'SDRWhites' },
	'season' => { 514 => 'Season', 518 => 'season' },
	'seasonidentifier' => { 514 => [\'Season','SeasonIdentifier'] },
	'seasonname' => { 514 => [\'Season','SeasonName'] },
	'seasonnumber' => { 514 => [\'Season','SeasonNumber'] },
	'secondaryftp' => { 490 => 'SecondaryFTP' },
	'secondaryslotfunction' => { 239 => 0x240, 240 => 0x22c, 241 => 0x240, 242 => 0x240, 260 => 0x13c, 271 => 0x1d0 },
	'section' => { 519 => 'section' },
	'securityclassification' => { 119 => 0x9212 },
	'selectableafpoint' => { 84 => 0x509 },
	'selectafareaselectionmode' => { 2 => 0xc },
	'selectafareaselectmode' => { 84 => 0x512 },
	'selfdata' => { 116 => 'SelfData' },
	'selftimer' => { 34 => 0x2, 340 => 0x2e, 416 => 0x214, 449 => 0x1134, 450 => 0x1134, 451 => 0x1110, 452 => 0x118c, 453 => 0x1168, 454 => 0x1020, 455 => 0x218, 456 => 0x218, 457 => 0x210 },
	'selftimer2' => { 77 => 0x1d },
	'selftimerinterval' => { 307 => '19.2' },
	'selftimermode' => { 119 => 0x882b },
	'selftimershotcount' => { 298 => '20.2', 300 => '20.3', 301 => '20.3', 302 => '18.2', 303 => '19.2', 304 => '19.2', 305 => '19.3', 307 => '19.3', 310 => '20.3', 311 => '20.3', 312 => '20.2', 313 => 0x2d, 314 => 0x2d, 315 => 0x2d },
	'selftimershotinterval' => { 298 => '20.3', 300 => '20.2', 301 => '20.2', 305 => '19.2', 310 => '20.2', 311 => '20.2', 313 => 0x31, 314 => 0x31, 315 => 0x31 },
	'selftimertime' => { 97 => 0x1806, 184 => 0x1f, 297 => '18.1', 298 => '20.1', 299 => '3.3', 300 => '20.1', 301 => '20.1', 302 => '18.1', 303 => '19.1', 304 => '19.1', 305 => '19.1', 306 => '7.2', 307 => '19.1', 308 => '3.3', 310 => '20.1', 311 => '20.1', 312 => '20.1', 313 => 0x2b, 314 => 0x2b, 315 => 0x2b },
	'sellingagency' => { 519 => 'sellingAgency' },
	'semanticstyle' => { 1 => 0x40 },
	'semanticstylepreset' => { 1 => 0x42 },
	'semanticstylerenderingver' => { 1 => 0x41 },
	'seminfo' => { 119 => 0x8546 },
	'sensingmethod' => { 119 => 0xa217, 506 => 'SensingMethod' },
	'sensitivityadjust' => { 375 => 0x40 },
	'sensitivitysteps' => { 356 => ['14.3','17.4'], 358 => 0x1 },
	'sensitivitytype' => { 119 => 0x8830, 507 => 'SensitivityType' },
	'sensor' => { 191 => 0x665e },
	'sensorarea' => { 322 => 0x400 },
	'sensorareas' => { 414 => 0xa010 },
	'sensorbitdepth' => { 342 => 0x312d },
	'sensorbluelevel' => { 74 => 0x5 },
	'sensorcalibration' => { 321 => 0x805 },
	'sensorcleaning' => { 90 => 0xd },
	'sensorfullheight' => { 137 => 0xf904 },
	'sensorfullwidth' => { 137 => 0xf903 },
	'sensorheight' => { 137 => 0xf901, 142 => 0xfa21, 188 => 0x8, 342 => 0x312c, 384 => 0x109, 407 => 0x1602 },
	'sensorimageheight' => { 138 => 0x3ee },
	'sensorimagewidth' => { 138 => 0x3ed },
	'sensorleftborder' => { 138 => 0x3eb },
	'sensorleftmargin' => { 384 => 0x10a },
	'sensorpixelsize' => { 234 => 0x9a },
	'sensorredlevel' => { 74 => 0x4 },
	'sensorserialnumber' => { 138 => 0x9ce },
	'sensorshield' => { 239 => 0x76b, 240 => 0x66d, 241 => 0x69d, 242 => 0x705 },
	'sensorsize' => { 156 => 'SensorSize', 375 => 0x35 },
	'sensortemperature' => { 320 => 0x1500, 322 => 0x1007, 380 => 0xc, 384 => 0x210, 417 => [0x39,0x55] },
	'sensortemperature2' => { 380 => 0xe, 384 => 0x211 },
	'sensortopborder' => { 138 => 0x3ec },
	'sensortopmargin' => { 384 => 0x10b },
	'sensortype' => { 340 => 0xca },
	'sensorwidth' => { 137 => 0xf900, 142 => 0xfa20, 188 => 0xa, 342 => 0x312b, 384 => 0x108, 407 => 0x1601 },
	'sequence' => { 401 => 0x7, 402 => 0x35, 403 => 0x36 },
	'sequencefilenumber' => { 450 => 0x4, 451 => 0x4, 452 => 0x4, 453 => 0x4, 463 => 0xc, 464 => 0xc, 465 => 0x1a },
	'sequenceimagenumber' => { 450 => 0x0, 451 => 0x0, 452 => 0x0, 453 => 0x0, 463 => 0x8, 464 => 0x8, 465 => 0x12, 472 => 0x24 },
	'sequencelength' => { 463 => 0x22, 464 => 0x1e, 465 => [0x16,0x1e] },
	'sequencename' => { 518 => 'sequenceName' },
	'sequencenumber' => { 77 => 0x9, 113 => 0x301c, 127 => 0x1101, 140 => 0x1d, 278 => 0x51c, 340 => 0x2b, 429 => [0x10c,0x30c], 440 => 0xb04a, 518 => 'sequenceNumber' },
	'sequenceshotinterval' => { 416 => 0x224 },
	'sequencetotalnumber' => { 518 => 'sequenceTotalNumber' },
	'sequentialshot' => { 416 => 0x20e },
	'serialnumber' => { 64 => 0xc, 97 => 0x180b, 119 => [0xa431,0xfde9], 137 => 0xfa04, 139 => 0xfa00, 141 => 0xc354, 142 => 0xfa19, 153 => 0x0, 156 => 'SerialNumber', 191 => 0x5501, 234 => [0xa0,0x1d], 318 => 0x101, 322 => [0x404,0x101a], 335 => 0x303, 337 => 0x305, 342 => 0x3103, 375 => 0x229, 384 => 0x102, 385 => 0x407, 400 => ['SNum','slno'], 401 => 0x15, 402 => 0x4b, 403 => 0x7e, 407 => 0x5, 414 => 0xa002, 417 => 0x2, 440 => 0x2031, 497 => 'SerialNumber', 507 => 'BodySerialNumber' },
	'serialnumberformat' => { 64 => 0x15, 97 => 0x183b },
	'serialnumberhash' => { 400 => 'CAME' },
	'series' => { 514 => 'Series' },
	'seriesdatetime' => { 478 => 'SeriesDateTime' },
	'seriesdescription' => { 478 => 'SeriesDescription' },
	'seriesidentifier' => { 514 => [\'Series','SeriesIdentifier'] },
	'seriesmodality' => { 478 => 'SeriesModality' },
	'seriesname' => { 514 => [\'Series','SeriesName'] },
	'seriesnumber' => { 478 => 'SeriesNumber', 519 => 'seriesNumber' },
	'seriestitle' => { 519 => 'seriesTitle' },
	'serviceidentifier' => { 132 => 0x1e },
	'servingsize' => { 521 => 'servingSize' },
	'setbuttoncrosskeysfunc' => { 87 => 0x0, 88 => 0x0 },
	'setbuttonwhenshooting' => { 82 => 0x1, 84 => 0x704, 90 => 0xc },
	'setclockfromlocationdata' => { 240 => 0x61d, 241 => 0x64d, 242 => 0x6b5 },
	'setfunctionwhenshooting' => { 85 => 0x0, 86 => 0x1, 89 => 0x1 },
	'setting' => { 518 => 'setting' },
	'shadingcompensation' => { 317 => 0x50c, 340 => 0x8a },
	'shadingcompensation2' => { 321 => 0x1012 },
	'shadow' => { 417 => 0xe },
	'shadowadj' => { 103 => 0x2030b },
	'shadowcorrection' => { 375 => 0x79 },
	'shadowprotection' => { 289 => 0x0 },
	'shadows' => { 119 => 0xfe52, 440 => 0x2032, 494 => 'Shadows', 500 => 'Shadows', 502 => 'Shadows' },
	'shadows2012' => { 500 => 'Shadows2012', 502 => 'Shadows2012' },
	'shadowsadj' => { 476 => 0x901a },
	'shadowscale' => { 119 => 0xc633 },
	'shadowtint' => { 500 => 'ShadowTint', 502 => 'ShadowTint' },
	'shadowtone' => { 127 => 0x1040 },
	'shakereduction' => { 377 => 0x1, 378 => 0x1 },
	'shareduserrating' => { 179 => 'WM/SharedUserRating' },
	'sharpendetail' => { 500 => 'SharpenDetail', 502 => 'SharpenDetail' },
	'sharpenedgemasking' => { 500 => 'SharpenEdgeMasking', 502 => 'SharpenEdgeMasking' },
	'sharpening' => { 342 => 0x300b },
	'sharpeningadj' => { 293 => 0x2b },
	'sharpeningkernel' => { 138 => 0x92f },
	'sharpenradius' => { 500 => 'SharpenRadius', 502 => 'SharpenRadius' },
	'sharpness' => { 8 => [0x42,0x48], 10 => 0x72, 12 => 0x74, 34 => 0xf, 63 => 0x6, 74 => 0x2, 112 => 0xb, 113 => [0x3011,0x21], 119 => [0xa40a,0xfe56], 127 => 0x1001, 140 => 0x6b, 149 => 0x37, 156 => 'Sharpness', 181 => 0x21, 182 => 0x30, 183 => 0x26, 184 => 0x18, 189 => 0x3, 234 => 0x6, 249 => 0x32, 250 => 0x33, 251 => 0x39, 322 => 0x100f, 340 => 0x41, 375 => 0x21, 382 => 0xb, 401 => 0x26, 403 => 0x56, 406 => 0x22, 407 => [0x1003,0x1014], 417 => 0x11, 427 => 0x1c, 428 => 0x19, 440 => 0x2006, 472 => 0x52, 500 => 'Sharpness', 502 => 'Sharpness', 506 => 'Sharpness' },
	'sharpnessadj' => { 103 => 0x20310, 108 => 0x25a, 476 => 0x801a },
	'sharpnessadjon' => { 103 => '0x20310.0' },
	'sharpnessauto' => { 71 => 0x94 },
	'sharpnessfactor' => { 322 => 0x102a },
	'sharpnessfaithful' => { 19 => 0xf5, 70 => 0x64, 71 => 0x64 },
	'sharpnessfrequency' => { 8 => [0x41,0x47], 74 => 0x3 },
	'sharpnesslandscape' => { 19 => 0xf3, 70 => 0x34, 71 => 0x34 },
	'sharpnessmonochrome' => { 19 => 0xf6, 70 => 0x7c, 71 => 0x7c },
	'sharpnessneutral' => { 19 => 0xf4, 70 => 0x4c, 71 => 0x4c },
	'sharpnessovershoot' => { 476 => 0x801b },
	'sharpnessportrait' => { 19 => 0xf2, 70 => 0x1c, 71 => 0x1c },
	'sharpnessrange' => { 440 => 0x2035 },
	'sharpnesssetting' => { 317 => 0x506, 325 => 0x1013, 429 => 0x12, 445 => 0xa },
	'sharpnessstandard' => { 19 => 0xf1, 70 => 0x4, 71 => 0x4 },
	'sharpnessstrength' => { 103 => 0x20311 },
	'sharpnessthreshold' => { 476 => 0x801d },
	'sharpnessundershoot' => { 476 => 0x801c },
	'sharpnessuserdef1' => { 19 => 0xf7, 70 => 0x94, 71 => 0xac },
	'sharpnessuserdef2' => { 19 => 0xf8, 70 => 0xac, 71 => 0xc4 },
	'sharpnessuserdef3' => { 19 => 0xf9, 70 => 0xc4, 71 => 0xdc },
	'shiftcols' => { 138 => 0xc70 },
	'shootid' => { 518 => 'shootID' },
	'shootingdistance' => { 103 => 0x20701 },
	'shootinginfodisplay' => { 297 => '13.2', 298 => '5.1', 306 => '10.2', 307 => '4.1', 310 => '5.1', 312 => '5.3' },
	'shootinginfomonitorofftime' => { 297 => '26.2', 298 => '22.2', 300 => '22.2', 301 => '22.2', 305 => '21.2', 306 => '9.1', 307 => '21.2', 310 => '22.2', 311 => '22.2', 312 => '22.2', 313 => 0x37, 314 => 0x37, 315 => 0x37 },
	'shootingmode' => { 156 => 'ShootingMode', 234 => 0x89, 340 => 0x1f },
	'shootingmodesetting' => { 299 => '5.1' },
	'shortdescription' => { 504 => 'shortdescription' },
	'shortdocumentid' => { 131 => 0xba },
	'shortname' => { 500 => 'ShortName', 502 => 'ShortName' },
	'shortownername' => { 19 => 0xac },
	'shortreleasetimelag' => { 84 => 0x80d },
	'shorttitle' => { 392 => '@sti' },
	'shotdate' => { 529 => 'shotDate' },
	'shotday' => { 529 => 'shotDay' },
	'shotlocation' => { 529 => 'shotLocation' },
	'shotlogdata' => { 483 => 'shot_log_data' },
	'shotname' => { 400 => 'shot', 529 => 'shotName' },
	'shotnumber' => { 529 => 'shotNumber' },
	'shotnumbersincepowerup' => { 444 => 0x44e, 463 => 0x1a, 464 => 0x16, 465 => 0xa },
	'shotnumbersincepowerup2' => { 429 => 0x200 },
	'shotsize' => { 529 => 'shotSize' },
	'shotsperinterval' => { 223 => 0x180, 238 => 0xb4, 239 => 0xcc, 240 => 0xc0, 241 => 0xd0, 242 => 0xd0 },
	'showmovement' => { 392 => 'shwm' },
	'shownevent' => { 514 => 'EventExt' },
	'showneventidentifier' => { 514 => [\'EventExt','EventExtIdentifier'] },
	'showneventname' => { 514 => [\'EventExt','EventExtName'] },
	'shutter' => { 459 => 0x20, 460 => 0x26, 461 => 0x26 },
	'shutter-aelock' => { 82 => 0x4, 84 => 0x701, 85 => 0x3, 86 => 0x4, 87 => 0x3, 88 => 0x3, 89 => 0x4, 90 => 0x2 },
	'shutteraelbutton' => { 83 => 0x4 },
	'shutterbuttonafonbutton' => { 84 => 0x701 },
	'shuttercount' => { 11 => 0x176, 57 => 0x1, 234 => 0xa7, 262 => [0x6a,0x157,0x24d], 263 => 0x286, 264 => 0x279, 265 => 0x284, 266 => 0x242, 267 => 0x280, 268 => 0x276, 269 => [0x27d,0x27f], 270 => 0x246, 272 => 0x2d6, 273 => 0x321, 274 => 0xbd8, 275 => 0x287, 276 => 0x320, 277 => 0x24a, 278 => 0x5fb, 279 => 0x2d5, 375 => 0x5d, 438 => 0x846, 443 => [0x125,0x14a], 459 => 0x32, 460 => 0x3a, 461 => 0x3a, 462 => 0xa },
	'shuttercount2' => { 459 => 0x4c, 460 => [0x50,0x52,0x58], 461 => 0x50 },
	'shuttercount3' => { 459 => [0x1a0,0x1aa,0x1bd], 460 => [0x19f,0x1cb,0x1cd] },
	'shuttercurtainsync' => { 82 => 0xf, 83 => 0xf, 84 => 0x305, 85 => 0xe, 86 => 0xf, 87 => 0x8, 88 => 0x8, 89 => 0xf, 90 => 0x8 },
	'shuttermode' => { 57 => 0x17, 140 => 0x1b, 234 => 0x34 },
	'shutterreleasebuttonae-l' => { 297 => '17.7', 298 => '18.4', 300 => '78.4', 301 => '78.4', 302 => '16.1', 303 => '17.1', 304 => '17.1', 305 => '17.1', 306 => '7.1', 307 => '17.5', 310 => '18.4', 311 => '78.4', 312 => '18.2', 313 => 0x29, 314 => 0x29, 315 => 0x29 },
	'shutterreleasemethod' => { 97 => 0x1010 },
	'shutterreleasenocfcard' => { 82 => 0x2, 83 => 0x2, 90 => 0xf },
	'shutterreleasetiming' => { 97 => 0x1011 },
	'shutterreleasewithoutlens' => { 84 => 0x711 },
	'shutterspeedlock' => { 298 => '38.1', 300 => '38.1', 301 => '38.1', 310 => '38.1', 311 => '38.1', 313 => 0xb7, 314 => 0xb7, 315 => 0xb7 },
	'shutterspeedrange' => { 84 => 0x10c },
	'shutterspeedsetting' => { 184 => 0x6, 427 => 0x2f, 428 => 0x28, 429 => 0x0 },
	'shutterspeedvalue' => { 93 => 0x1, 119 => 0x9201, 322 => 0x1000, 384 => 0x400, 506 => 'ShutterSpeedValue' },
	'shuttertype' => { 127 => 0x1050, 340 => 0x9f, 375 => 0x87, 465 => [0x133,0x139,0x13f] },
	'sidecarforextension' => { 517 => 'SidecarForExtension' },
	'sigmaimpulseparameters' => { 138 => 0xe0d },
	'sigmascalingfactorcamera' => { 138 => 0xe0c },
	'sigmascalingfactorlowres' => { 138 => 0xe0b },
	'sigmasizetable' => { 138 => 0xe0f },
	'signaltonoiseratio' => { 1 => 0x27 },
	'signaltonoiseratiotype' => { 1 => 0x26 },
	'silentphotography' => { 234 => 0xbf },
	'similarityindex' => { 131 => 0xe4 },
	'singleframebracketing' => { 184 => 0x21 },
	'skilllevel' => { 521 => 'skillLevel' },
	'skintonecorrection' => { 375 => 0x95 },
	'skiplinetime' => { 138 => 0x184e },
	'slaveflashmeteringsegments' => { 375 => 0x20b },
	'slideshowname' => { 518 => 'slideshowName' },
	'slideshownumber' => { 518 => 'slideshowNumber' },
	'slideshowtotalnumber' => { 518 => 'slideshowTotalNumber' },
	'slot2jpgsize' => { 239 => 0x24a, 242 => 0x24a },
	'slowshutter' => { 77 => 0x8 },
	'slowsync' => { 127 => 0x1030 },
	'smartalbumcolor' => { 414 => 0x20 },
	'smartrange' => { 414 => 0xa012 },
	'smileshutter' => { 429 => 0x31 },
	'smileshuttermode' => { 429 => 0x27 },
	'smoothness' => { 119 => 0xfe57, 500 => 'Smoothness', 502 => 'Smoothness' },
	'snapshot' => { 514 => 'SnapshotLink' },
	'snapshotformat' => { 514 => [\'SnapshotLink','SnapshotLinkFormat'] },
	'snapshotheightpixels' => { 514 => [\'SnapshotLink','SnapshotLinkHeightPixels'] },
	'snapshotimagerole' => { 514 => [\'SnapshotLink','SnapshotLinkImageRole'] },
	'snapshotlink' => { 514 => [\'SnapshotLink','SnapshotLinkLink'] },
	'snapshotlinkqualifier' => { 514 => [\'SnapshotLink','SnapshotLinkLinkQualifier'] },
	'snapshots' => { 495 => 'Snapshots' },
	'snapshotusedvideoframe' => { 514 => [\'SnapshotLink','SnapshotLinkUsedVideoFrame'] },
	'snapshotusedvideoframetimeformat' => { 514 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeFormat'] },
	'snapshotusedvideoframetimevalue' => { 514 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeValue'] },
	'snapshotusedvideoframevalue' => { 514 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameValue'] },
	'snapshotwidthpixels' => { 514 => [\'SnapshotLink','SnapshotLinkWidthPixels'] },
	'softskineffect' => { 440 => 0x200f },
	'software' => { 119 => 0x131, 157 => 'Software', 330 => 'Software', 384 => 0x203, 394 => 'software', 417 => 0x18, 485 => 'Software', 525 => 'Software' },
	'softwareversion' => { 400 => ['@swr',"\xa9swr"], 416 => 0x207 },
	'soloist' => { 392 => "\xa9sol" },
	'songwriter' => { 400 => "\xa9swf" },
	'songwriterkeywords' => { 400 => "\xa9swk" },
	'sonycropsize' => { 119 => 0x74c8 },
	'sonycroptopleft' => { 119 => 0x74c7 },
	'sonydatetime' => { 448 => 0x6, 450 => 0x1b6, 451 => 0x210, 452 => 0x1fe, 453 => 0x22c },
	'sonydatetime2' => { 459 => 0x51 },
	'sonyexposuretime' => { 459 => 0x3a, 460 => 0x46, 461 => [0x66,0x46], 462 => 0x1a },
	'sonyexposuretime2' => { 472 => 0xe },
	'sonyfnumber' => { 459 => 0x3c, 460 => 0x48, 461 => [0x68,0x48], 462 => 0x1c, 472 => 0x14 },
	'sonyimageheight' => { 448 => 0x1a, 463 => 0x44, 464 => 0x3f, 465 => 0x47 },
	'sonyimageheightmax' => { 472 => 0x40 },
	'sonyimagesize' => { 184 => 0x3b, 427 => 0x54, 428 => 0x54, 429 => 0x9 },
	'sonyimagewidth' => { 448 => 0x1c },
	'sonyimagewidthmax' => { 472 => 0x3e },
	'sonyiso' => { 450 => 0x1218, 451 => 0x11f4, 452 => 0x1270, 453 => [0x1254,0x1258,0x1280], 454 => 0x113c, 455 => 0x344, 456 => 0x346, 457 => 0x320, 472 => 0x4 },
	'sonymaxaperture' => { 459 => 0x0, 460 => 0x0 },
	'sonymaxaperturevalue' => { 472 => 0x16 },
	'sonyminaperture' => { 459 => 0x1, 460 => 0x1 },
	'sonymodelid' => { 440 => 0xb001 },
	'sonyquality' => { 184 => 0x3c },
	'sonyrawimagesize' => { 119 => 0x7038 },
	'sonytimeminsec' => { 460 => 0x61 },
	'sortalbum' => { 392 => 'soal' },
	'sortalbumartist' => { 392 => 'soaa' },
	'sortartist' => { 392 => 'soar' },
	'sortcomposer' => { 392 => 'soco' },
	'sortname' => { 392 => 'sonm', 500 => 'SortName', 502 => 'SortName' },
	'sortshow' => { 392 => 'sosn' },
	'soundengineer' => { 392 => "\xa9sne" },
	'source' => { 131 => 0x73, 330 => 'Source', 503 => 'source', 504 => 'source', 517 => 'Source' },
	'sourcecount' => { 489 => 'SourceCount' },
	'sourcecredits' => { 400 => "\xa9src" },
	'sourcedirectoryindex' => { 362 => 0x0 },
	'sourcefileindex' => { 362 => 0x2 },
	'sourcephotoscount' => { 488 => 'SourcePhotosCount' },
	'sourceprofileprefix' => { 138 => 0x1390 },
	'spatialfrequencyresponse' => { 506 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 506 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 506 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 506 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 506 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 529 => 'speakerPlacement' },
	'specialeffectlevel' => { 113 => 0x3030 },
	'specialeffectmode' => { 113 => 0x2076 },
	'specialeffectsetting' => { 113 => 0x3031 },
	'specialinstructions' => { 131 => 0x28 },
	'specialmode' => { 322 => 0x200, 416 => 0x200 },
	'specialoccasion' => { 521 => 'specialOccasion' },
	'specialtypeid' => { 483 => 'SpecialTypeID' },
	'spectralsensitivity' => { 119 => 0x8824, 506 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 41 => 0x32b, 42 => 0x281, 45 => [0x2b9,0x2d0,0x2d4], 46 => 0x56a, 47 => 0x1e4, 48 => [0x1fd,0x2dd], 49 => [0x231,0x30f], 50 => 0x31d },
	'speedx' => { 115 => 0x3, 400 => "\xa9xsp" },
	'speedy' => { 115 => 0x4, 400 => "\xa9ysp" },
	'speedz' => { 115 => 0x5, 400 => "\xa9zsp" },
	'spherical' => { 489 => 'Spherical' },
	'sphericalvideoxml' => { 120 => 'SphericalVideoXML' },
	'splitcolumn' => { 384 => 0x222 },
	'splittoningbalance' => { 500 => 'SplitToningBalance', 502 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 500 => 'SplitToningHighlightHue', 502 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 500 => 'SplitToningHighlightSaturation', 502 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 500 => 'SplitToningShadowHue', 502 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 500 => 'SplitToningShadowSaturation', 502 => 'SplitToningShadowSaturation' },
	'sport' => { 519 => 'sport' },
	'spotfocuspointx' => { 181 => 0x2d },
	'spotfocuspointy' => { 181 => 0x2e },
	'spotmeteringmode' => { 34 => 0x27 },
	'spotmeterlinktoafpoint' => { 84 => 0x107 },
	'sractive' => { 356 => '17.1' },
	'srawquality' => { 34 => 0x2e },
	'srfocallength' => { 377 => 0x3 },
	'srgbrendering' => { 328 => 'sRGB' },
	'srhalfpresstime' => { 377 => 0x2 },
	'srresult' => { 377 => 0x0, 378 => 0x0 },
	'stackedimage' => { 317 => 0x804 },
	'standardmatrixcustom' => { 138 => 0x7d4 },
	'standardmatrixdaylight' => { 138 => 0x7d0 },
	'standardmatrixflash' => { 138 => 0x7d3 },
	'standardmatrixfluorescent' => { 138 => 0x7d2 },
	'standardmatrixtungsten' => { 138 => 0x7d1 },
	'standardoutputhighlightpoint' => { 109 => 0x14 },
	'standardoutputsensitivity' => { 119 => 0x8831, 507 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 109 => 0x15 },
	'standardrawcolortone' => { 109 => 0xd },
	'standardrawcontrast' => { 109 => 0xf },
	'standardrawhighlight' => { 109 => 0x75 },
	'standardrawhighlightpoint' => { 109 => 0x12 },
	'standardrawlinear' => { 109 => 0x10 },
	'standardrawsaturation' => { 109 => 0xe },
	'standardrawshadow' => { 109 => 0x7e },
	'standardrawshadowpoint' => { 109 => 0x13 },
	'standardrawsharpness' => { 109 => 0x11 },
	'standardunsharpmaskfineness' => { 109 => 0x94 },
	'standardunsharpmaskstrength' => { 109 => 0x92 },
	'standardunsharpmaskthreshold' => { 109 => 0x96 },
	'standardwhitecustom' => { 138 => 0x838 },
	'standardwhitedaylight' => { 138 => 0x834 },
	'standardwhiteflash' => { 138 => 0x837 },
	'standardwhitefluorescent' => { 138 => 0x836 },
	'standardwhitetungsten' => { 138 => 0x835 },
	'standbytimer' => { 298 => '19.1', 300 => '19.1', 301 => '19.1', 304 => '18.1', 305 => '18.1', 310 => '19.1', 311 => '19.1' },
	'starlightview' => { 313 => 0x249, 314 => 0x249, 315 => 0x261 },
	'startingpage' => { 519 => 'startingPage' },
	'startmovieshooting' => { 84 => 0x70d },
	'starttimecode' => { 400 => "\xa9TIM", 529 => 'startTimecode' },
	'starttimecodetimeformat' => { 529 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 529 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 529 => [\'startTimecode','startTimecodeValue'] },
	'starttimesamplesize' => { 400 => "\xa9TSZ", 529 => 'startTimeSampleSize' },
	'starttimescale' => { 400 => "\xa9TSC", 529 => 'startTimeScale' },
	'state' => { 161 => 'State', 340 => 0x6b, 517 => 'State' },
	'status' => { 481 => 'Status', 493 => 'Status' },
	'stereomode' => { 489 => 'StereoMode' },
	'stitched' => { 489 => 'Stitched' },
	'stitchingsoftware' => { 488 => 'StitchingSoftware', 489 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 449 => 0x113e, 450 => 0x113e, 451 => 0x111a, 452 => 0x1196, 453 => 0x1172, 454 => 0x102a, 455 => 0x222, 456 => 0x222, 457 => 0x217, 472 => 0xa },
	'storagemethod' => { 188 => 0x12 },
	'storebyorientation' => { 298 => '46.3', 300 => '47.3', 301 => '47.3', 310 => '47.3', 311 => '47.3', 313 => 0xd, 314 => 0xd, 315 => 0xd },
	'storedescription' => { 392 => 'sdes' },
	'storylineidentifier' => { 514 => 'StorylineIdentifier' },
	'straightenangle' => { 290 => 0x2fc08431 },
	'streamready' => { 514 => 'StreamReady' },
	'streamtype' => { 176 => 'StreamType' },
	'stretchmode' => { 529 => 'stretchMode' },
	'studydatetime' => { 478 => 'StudyDateTime' },
	'studydescription' => { 478 => 'StudyDescription' },
	'studyid' => { 478 => 'StudyID' },
	'studyphysician' => { 478 => 'StudyPhysician' },
	'styleperiod' => { 514 => 'StylePeriod' },
	'sub-location' => { 131 => 0x5c },
	'subcommanddialplaybackmode' => { 313 => 0x1cf, 314 => 0x1cf, 315 => 0x1e7 },
	'subfiledata' => { 164 => 'data' },
	'subfiledirectory' => { 164 => '1Directory' },
	'subfilemimetype' => { 164 => '2MIME' },
	'subfilename' => { 164 => '1Name' },
	'subfileresource' => { 164 => 'rsrc' },
	'subfiletype' => { 119 => 0xfe, 164 => '0Type' },
	'subject' => { 326 => 'Subject', 391 => 'Subject', 503 => 'subject', 516 => 'Subject', 530 => 'subject' },
	'subjectarea' => { 119 => 0x9214, 506 => 'SubjectArea' },
	'subjectcode' => { 513 => 'SubjectCode' },
	'subjectdetection' => { 239 => 0x252, 240 => 0x23e, 241 => 0x252, 242 => 0x252 },
	'subjectdistance' => { 119 => 0x9206, 140 => 0x3e, 506 => 'SubjectDistance' },
	'subjectdistancerange' => { 119 => 0xa40c, 506 => 'SubjectDistanceRange' },
	'subjectlocation' => { 119 => 0xa214, 506 => 'SubjectLocation' },
	'subjectmotion' => { 300 => '78.2', 301 => '78.2', 311 => '78.2', 313 => 0x103, 314 => 0x103, 315 => 0x119 },
	'subjectprogram' => { 181 => 0x22 },
	'subjectreference' => { 131 => 0xc },
	'sublabels1' => { 512 => [\'TagStructure','TagStructureSubLabels'] },
	'sublabels2' => { 512 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublabels3' => { 512 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'sublabels4' => { 512 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 512 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'subseccreatedate' => { 114 => 'Exif-SubSecCreateDate' },
	'subsecdatetimeoriginal' => { 114 => 'Exif-SubSecDateTimeOriginal' },
	'subsecmodifydate' => { 114 => 'Exif-SubSecModifyDate' },
	'subsectime' => { 119 => 0x9290 },
	'subsectimedigitized' => { 119 => 0x9292 },
	'subsectimeoriginal' => { 119 => 0x9291 },
	'subsection1' => { 519 => 'subsection1' },
	'subsection2' => { 519 => 'subsection2' },
	'subsection3' => { 519 => 'subsection3' },
	'subsection4' => { 519 => 'subsection4' },
	'subselector' => { 298 => '49.1', 300 => '71.1', 301 => '71.1', 311 => '71.1', 313 => 0x8f, 314 => 0x8f, 315 => 0x8f },
	'subselectorassignment' => { 298 => '48.1' },
	'subselectorcenter' => { 300 => '72.1', 301 => '72.1', 311 => '72.1' },
	'subselectorplusdials' => { 298 => '49.2', 300 => '73.1', 301 => '73.1', 311 => '73.1' },
	'subtitle' => { 179 => 'WM/SubTitle', 392 => "\xa9st3", 400 => "\xa9snm", 519 => 'subtitle' },
	'subtitlekeywords' => { 400 => "\xa9snk" },
	'subversionfilename' => { 512 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 512 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 512 => 'SubVersions' },
	'superimposeddisplay' => { 82 => 0xa, 84 => 0x510, 85 => 0x9, 86 => 0xa, 89 => 0xa, 90 => 0xe },
	'supermacro' => { 64 => 0x1a },
	'supplementalcategories' => { 131 => 0x14, 517 => 'SupplementalCategories' },
	'supplementaltype' => { 133 => 0x37 },
	'supplementdisplayid' => { 519 => 'supplementDisplayID' },
	'supplementstartingpage' => { 519 => 'supplementStartingPage' },
	'supplementtitle' => { 519 => 'supplementTitle' },
	'supplychainsource' => { 514 => 'SupplyChainSource' },
	'supplychainsourceidentifier' => { 514 => [\'SupplyChainSource','SupplyChainSourceIdentifier'] },
	'supplychainsourcename' => { 514 => [\'SupplyChainSource','SupplyChainSourceName'] },
	'supportsamount' => { 500 => 'SupportsAmount', 502 => 'SupportsAmount' },
	'supportscolor' => { 500 => 'SupportsColor', 502 => 'SupportsColor' },
	'supportshighdynamicrange' => { 500 => 'SupportsHighDynamicRange', 502 => 'SupportsHighDynamicRange' },
	'supportsmonochrome' => { 500 => 'SupportsMonochrome', 502 => 'SupportsMonochrome' },
	'supportsnormaldynamicrange' => { 500 => 'SupportsNormalDynamicRange', 502 => 'SupportsNormalDynamicRange' },
	'supportsoutputreferred' => { 500 => 'SupportsOutputReferred', 502 => 'SupportsOutputReferred' },
	'supportsscenereferred' => { 500 => 'SupportsSceneReferred', 502 => 'SupportsSceneReferred' },
	'svisosetting' => { 356 => 0x14 },
	'swatchcoloranta' => { 534 => [\'SwatchGroups','SwatchGroupsColorantsA'] },
	'swatchcolorantb' => { 534 => [\'SwatchGroups','SwatchGroupsColorantsB'] },
	'swatchcolorantblack' => { 534 => [\'SwatchGroups','SwatchGroupsColorantsBlack'] },
	'swatchcolorantblue' => { 534 => [\'SwatchGroups','SwatchGroupsColorantsBlue'] },
	'swatchcolorantcyan' => { 534 => [\'SwatchGroups','SwatchGroupsColorantsCyan'] },
	'swatchcolorantgray' => { 534 => [\'SwatchGroups','SwatchGroupsColorantsGray'] },
	'swatchcolorantgreen' => { 534 => [\'SwatchGroups','SwatchGroupsColorantsGreen'] },
	'swatchcolorantl' => { 534 => [\'SwatchGroups','SwatchGroupsColorantsL'] },
	'swatchcolorantmagenta' => { 534 => [\'SwatchGroups','SwatchGroupsColorantsMagenta'] },
	'swatchcolorantmode' => { 534 => [\'SwatchGroups','SwatchGroupsColorantsMode'] },
	'swatchcolorantred' => { 534 => [\'SwatchGroups','SwatchGroupsColorantsRed'] },
	'swatchcolorantswatchname' => { 534 => [\'SwatchGroups','SwatchGroupsColorantsSwatchName'] },
	'swatchcoloranttint' => { 534 => [\'SwatchGroups','SwatchGroupsColorantsTint'] },
	'swatchcoloranttype' => { 534 => [\'SwatchGroups','SwatchGroupsColorantsType'] },
	'swatchcolorantyellow' => { 534 => [\'SwatchGroups','SwatchGroupsColorantsYellow'] },
	'swatchgroupname' => { 534 => [\'SwatchGroups','SwatchGroupsGroupName'] },
	'swatchgroups' => { 534 => 'SwatchGroups' },
	'swatchgroupscolorants' => { 534 => [\'SwatchGroups','SwatchGroupsColorants'] },
	'swatchgrouptype' => { 534 => [\'SwatchGroups','SwatchGroupsGroupType'] },
	'sweeppanoramadirection' => { 340 => 0x93, 429 => 0x33 },
	'sweeppanoramafieldofview' => { 340 => 0x94 },
	'sweeppanoramasize' => { 429 => 0x32 },
	'switchtoregisteredafpoint' => { 83 => 0x12, 84 => 0x50a },
	'symlink' => { 120 => 'SymLink' },
	'syncreleasemode' => { 300 => '77.1', 301 => '77.1', 311 => '77.1', 313 => 0x41, 314 => 0x41, 315 => 0x41 },
	'system' => { 384 => 0x204 },
	'tagged' => { 386 => 0xdd, 387 => 'Tagged', 495 => 'tagged' },
	'tagslist' => { 505 => 'TagsList' },
	'tagstructure' => { 512 => 'TagStructure' },
	'takenumber' => { 529 => 'takeNumber' },
	'tapename' => { 529 => 'tapeName' },
	'targetaperture' => { 77 => 0x4 },
	'targetcompressionratio' => { 95 => 0x1 },
	'targetdistancesetting' => { 97 => 0x1807 },
	'targetexposuretime' => { 77 => 0x5 },
	'targetimagetype' => { 97 => 0x100a },
	'targetprinter' => { 119 => 0x151 },
	'taxon' => { 118 => 'Taxon' },
	'taxonacceptednameusage' => { 118 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 118 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 118 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 118 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxoncultivarepithet' => { 118 => [\'Taxon','TaxonCultivarEpithet'] },
	'taxonfamily' => { 118 => [\'Taxon','TaxonFamily'] },
	'taxongenus' => { 118 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 118 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 118 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfraspecificepithet' => { 118 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 118 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 118 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 118 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 118 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 118 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 118 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 118 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 118 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 118 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 118 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 118 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 118 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 118 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 118 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 118 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 118 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 118 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 118 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 118 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 118 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubgenus' => { 118 => [\'Taxon','TaxonSubgenus'] },
	'taxontaxonomicstatus' => { 118 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxonverbatimtaxonrank' => { 118 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 118 => [\'Taxon','TaxonVernacularName'] },
	'tda1bandwidth' => { 138 => 0x196f },
	'tda1edgepolarity' => { 138 => 0x1971 },
	'tda1gain' => { 138 => 0x1970 },
	'tda1offset' => { 138 => 0x196e },
	'tda2bandwidth' => { 138 => 0x1979 },
	'tda2edgepolarity' => { 138 => 0x197b },
	'tda2gain' => { 138 => 0x197a },
	'tda2offset' => { 138 => 0x1978 },
	'tda3bandwidth' => { 138 => 0x1983 },
	'tda3edgepolarity' => { 138 => 0x1985 },
	'tda3gain' => { 138 => 0x1984 },
	'tda3offset' => { 138 => 0x1982 },
	'tda4bandwidth' => { 138 => 0x198d },
	'tda4edgepolarity' => { 138 => 0x198f },
	'tda4gain' => { 138 => 0x198e },
	'tda4offset' => { 138 => 0x198c },
	'teaser' => { 519 => 'teaser' },
	'teleconverter' => { 186 => 0x105, 440 => 0x105 },
	'tempampgainx100' => { 138 => 0x1914 },
	'tempo' => { 529 => 'tempo' },
	'temporalcoverage' => { 514 => 'TemporalCoverage' },
	'temporalcoveragefrom' => { 514 => [\'TemporalCoverage','TemporalCoverageTempCoverageFrom'] },
	'temporalcoverageto' => { 514 => [\'TemporalCoverage','TemporalCoverageTempCoverageTo'] },
	'termsandconditionstext' => { 327 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 327 => 'TermsAndConditionsURL' },
	'testname' => { 120 => 'TestName' },
	'textencoding' => { 233 => 0x4 },
	'textlayername' => { 517 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 517 => 'TextLayers' },
	'textlayertext' => { 517 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 340 => [0x8008,0x8009,0x3b,0x3e] },
	'texture' => { 500 => 'Texture', 502 => 'Texture' },
	'three-dtrackingfacedetection' => { 300 => '1.4', 301 => '1.4', 311 => '1.4' },
	'three-dtrackingwatcharea' => { 300 => '78.1', 301 => '78.1', 311 => '78.1' },
	'thresholding' => { 119 => 0x107 },
	'thumbnailfilename' => { 97 => 0x817 },
	'thumbnailformat' => { 527 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 142 => 0xfa55, 527 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 6 => 'CNDA', 97 => 0x2008, 114 => 'Exif-ThumbnailImage', 122 => 0x3, 167 => 'data', 322 => 0x100, 400 => 'thmb', 527 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 167 => '1Name' },
	'thumbnailimagesize' => { 167 => 'ImageSize' },
	'thumbnailimagetype' => { 167 => '0Type' },
	'thumbnailimagevalidarea' => { 64 => 0x13 },
	'thumbnaillength' => { 119 => 0x202 },
	'thumbnailoffset' => { 119 => 0x201 },
	'thumbnailpng' => { 400 => 'thmb' },
	'thumbnails' => { 527 => 'Thumbnails' },
	'thumbnailwidth' => { 142 => 0xfa54, 527 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 519 => 'ticker' },
	'tiffhandling' => { 500 => 'TIFFHandling', 502 => 'TIFFHandling' },
	'tiffmeteringimage' => { 187 => 0x104c, 438 => 0x1110 },
	'tilelength' => { 119 => 0x143 },
	'tilewidth' => { 119 => 0x142 },
	'time' => { 138 => 0x401, 375 => 0x7 },
	'timecodes' => { 119 => 0xc763 },
	'timecreated' => { 131 => 0x3c, 140 => 0x14, 149 => 0x10, 387 => 'TimeCreated' },
	'timelapseshotnumber' => { 343 => 0x10 },
	'timeperiod' => { 519 => 'timePeriod' },
	'timerfunctionbutton' => { 299 => '5.2', 302 => '12.1', 303 => '13.1' },
	'timerlength' => { 84 => 0x80c },
	'timerrecording' => { 340 => 0x96 },
	'timescaleparams' => { 529 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 529 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 529 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 529 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 132 => 0x50 },
	'timeshot' => { 490 => 'TimeShot' },
	'timesignature' => { 529 => 'timeSignature' },
	'timesincepoweron' => { 340 => 0x29 },
	'timestamp' => { 11 => 0x45e, 19 => 0x11c, 316 => 0x8, 330 => 'TimeStamp', 340 => 0xaf, 489 => 'Timestamp', 496 => 'Timestamp', 512 => 'TimeStamp' },
	'timestamp1' => { 11 => 0x45a },
	'timezone' => { 78 => 0x1, 239 => 0x694, 240 => 0x594, 241 => 0x5c4, 242 => 0x5dc, 282 => 0x0, 410 => 0xa },
	'timezonecity' => { 78 => 0x2 },
	'timezonecode' => { 100 => 0x1 },
	'timezoneinfo' => { 100 => 0x2 },
	'timezoneoffset' => { 119 => 0x882a },
	'tint' => { 394 => 'player.movie.visual.tint', 500 => 'Tint', 502 => 'Tint' },
	'title' => { 119 => 0xa436, 157 => 'Title', 326 => 'Title', 330 => 'Title', 340 => 0x65, 391 => 'Title', 392 => ['titl',"\xa9nam"], 394 => 'title', 400 => ['titl',"\xa9nam"], 503 => 'title', 516 => 'Title', 527 => 'Title' },
	'togglestyleamount' => { 500 => 'ToggleStyleAmount', 502 => 'ToggleStyleAmount' },
	'togglestyledigest' => { 500 => 'ToggleStyleDigest', 502 => 'ToggleStyleDigest' },
	'tonecomp' => { 234 => 0x81 },
	'tonecurve' => { 74 => 0x1, 375 => 0x402, 500 => 'ToneCurve', 502 => 'ToneCurve' },
	'tonecurveactive' => { 108 => 0x110 },
	'tonecurveadobergb' => { 414 => 0xa043 },
	'tonecurveadobergbdefault' => { 414 => 0xa041 },
	'tonecurveblue' => { 500 => 'ToneCurveBlue', 502 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 476 => 0x9003 },
	'tonecurvebluey' => { 476 => 0x9007 },
	'tonecurvebrightness' => { 103 => 0x20410 },
	'tonecurvebrightnessx' => { 476 => 0x9000 },
	'tonecurvebrightnessy' => { 476 => 0x9004 },
	'tonecurvecolorspace' => { 107 => 0x0 },
	'tonecurvecontrast' => { 103 => 0x20411 },
	'tonecurvegreen' => { 500 => 'ToneCurveGreen', 502 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 476 => 0x9002 },
	'tonecurvegreeny' => { 476 => 0x9006 },
	'tonecurveinputrange' => { 107 => 0x3 },
	'tonecurveinterpolation' => { 108 => 0x159 },
	'tonecurvemode' => { 108 => 0x113 },
	'tonecurvename' => { 500 => 'ToneCurveName', 502 => 'ToneCurveName' },
	'tonecurvename2012' => { 500 => 'ToneCurveName2012', 502 => 'ToneCurveName2012' },
	'tonecurveoriginal' => { 103 => '0x20400.1' },
	'tonecurveoutputrange' => { 107 => 0x5 },
	'tonecurveprofilename' => { 138 => 0x1391 },
	'tonecurveproperty' => { 108 => 0x3c },
	'tonecurvepv2012' => { 500 => 'ToneCurvePV2012', 502 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 500 => 'ToneCurvePV2012Blue', 502 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 500 => 'ToneCurvePV2012Green', 502 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 500 => 'ToneCurvePV2012Red', 502 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 500 => 'ToneCurveRed', 502 => 'ToneCurveRed' },
	'tonecurveredx' => { 476 => 0x9001 },
	'tonecurveredy' => { 476 => 0x9005 },
	'tonecurves' => { 375 => 0x403 },
	'tonecurveshape' => { 107 => 0x1 },
	'tonecurvesrgb' => { 414 => 0xa042 },
	'tonecurvesrgbdefault' => { 414 => 0xa040 },
	'tonecurvex' => { 107 => 0xa },
	'tonecurvey' => { 107 => 0xb },
	'tonelevel' => { 317 => 0x52e },
	'tonemap' => { 239 => 0x26a },
	'tonemapstrength' => { 500 => 'ToneMapStrength', 502 => 'ToneMapStrength' },
	'toningeffect' => { 57 => 0xf, 234 => 0xb3, 249 => 0x38, 250 => 0x40, 251 => 0x48, 407 => 0x1015 },
	'toningeffectauto' => { 71 => 0xa4 },
	'toningeffectfaithful' => { 70 => 0x74, 71 => 0x74 },
	'toningeffectlandscape' => { 70 => 0x44, 71 => 0x44 },
	'toningeffectmonochrome' => { 19 => 0x108, 70 => 0x8c, 71 => 0x8c },
	'toningeffectneutral' => { 70 => 0x5c, 71 => 0x5c },
	'toningeffectportrait' => { 70 => 0x2c, 71 => 0x2c },
	'toningeffectstandard' => { 70 => 0x14, 71 => 0x14 },
	'toningeffectuserdef1' => { 70 => 0xa4, 71 => 0xbc },
	'toningeffectuserdef2' => { 70 => 0xbc, 71 => 0xd4 },
	'toningeffectuserdef3' => { 70 => 0xd4, 71 => 0xec },
	'toningsaturation' => { 249 => 0x39, 250 => 0x41, 251 => 0x49 },
	'totalzoom' => { 140 => 0x62 },
	'touchae' => { 340 => 0xab },
	'track' => { 392 => "\xa9trk", 400 => "\xa9trk" },
	'trackcreatedate' => { 399 => 0x1 },
	'trackmodifydate' => { 399 => 0x2 },
	'tracknumber' => { 392 => 'trkn', 529 => 'trackNumber' },
	'tracks' => { 529 => 'Tracks' },
	'tracksframerate' => { 529 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 529 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 529 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 529 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 529 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 529 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 529 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 529 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 529 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 529 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 529 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 529 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 529 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 529 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 529 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 529 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 529 => [\'Tracks','TracksTrackType'] },
	'tracktype' => { 400 => 'kgtt' },
	'trailer' => { 120 => 'Trailer' },
	'trailersignature' => { 164 => 'zmie' },
	'transcript' => { 514 => 'Transcript' },
	'transcriptlink' => { 514 => 'TranscriptLink' },
	'transcriptlinklink' => { 514 => [\'TranscriptLink','TranscriptLinkLink'] },
	'transcriptlinklinkqualifier' => { 514 => [\'TranscriptLink','TranscriptLinkLinkQualifier'] },
	'transferfunction' => { 119 => 0x12d, 525 => 'TransferFunction' },
	'transfertimenormal' => { 138 => 0x1888 },
	'transfertimetest' => { 138 => 0x1889 },
	'transform' => { 340 => [0x8012,0x59] },
	'transformation' => { 515 => 'Transformation' },
	'transmissionreference' => { 517 => 'TransmissionReference' },
	'trapped' => { 326 => 'Trapped', 516 => 'Trapped' },
	'trashbuttonfunction' => { 84 => 0x710 },
	'travelday' => { 340 => 0x36 },
	'treble' => { 394 => 'player.movie.audio.treble' },
	'triggermode' => { 401 => 0x6, 402 => 0x34, 403 => 0x34 },
	'tstop' => { 119 => 0xc772 },
	'ttl_da_adown' => { 363 => 0x5 },
	'ttl_da_aup' => { 363 => 0x4 },
	'ttl_da_bdown' => { 363 => 0x7 },
	'ttl_da_bup' => { 363 => 0x6 },
	'tungstenawb' => { 353 => 0x1 },
	'tvepisode' => { 392 => 'tves' },
	'tvepisodeid' => { 392 => 'tven' },
	'tvexposuretimesetting' => { 356 => 0x12 },
	'tvnetworkname' => { 392 => 'tvnn' },
	'tvseason' => { 392 => 'tvsn' },
	'tvshow' => { 392 => 'tvsh' },
	'type' => { 484 => 'Type', 503 => 'type', 524 => 'type' },
	'typestatus' => { 118 => [\'Identification','IdentificationTypeStatus'] },
	'uniquecameramodel' => { 119 => 0xc614 },
	'uniquedocumentid' => { 131 => 0xbb },
	'uniquematrixauto' => { 138 => 0x7e9 },
	'uniquematrixcustom' => { 138 => 0x7e8 },
	'uniquematrixdaylight' => { 138 => 0x7e4 },
	'uniquematrixflash' => { 138 => 0x7e7 },
	'uniquematrixfluorescent' => { 138 => 0x7e6 },
	'uniquematrixtungsten' => { 138 => 0x7e5 },
	'uniqueobjectname' => { 132 => 0x64 },
	'units' => { 485 => 'Units' },
	'unknown_aacr' => { 392 => 'AACR' },
	'unknown_cdek' => { 392 => 'CDEK' },
	'unknown_cdet' => { 392 => 'CDET' },
	'unknownblock' => { 375 => 0x405 },
	'unknownblock1' => { 321 => 0x635 },
	'unknownblock2' => { 321 => 0x636 },
	'unknownblock3' => { 321 => 0x1103 },
	'unknownblock4' => { 321 => 0x1104 },
	'unknowncontrast' => { 109 => 0x45 },
	'unknowndate' => { 384 => 0x212 },
	'unknownev' => { 138 => 0x1 },
	'unknownlinear' => { 109 => 0x46 },
	'unknownnumber' => { 97 => 0x180b },
	'unknownoutputhighlightpoint' => { 109 => 0x4a },
	'unknownoutputshadowpoint' => { 109 => 0x4b },
	'unknownrawhighlight' => { 109 => 0x7b },
	'unknownrawhighlightpoint' => { 109 => 0x48 },
	'unknownrawshadow' => { 109 => 0x84 },
	'unknownrawshadowpoint' => { 109 => 0x49 },
	'unknownsharpness' => { 109 => 0x47 },
	'unknowntags' => { 400 => 'TAGS' },
	'unknowntemperature' => { 121 => 0x4 },
	'unknownthumbnail' => { 400 => 'thmb' },
	'unsharp1color' => { 295 => 0x13 },
	'unsharp1halowidth' => { 295 => 0x19 },
	'unsharp1intensity' => { 295 => 0x17 },
	'unsharp1threshold' => { 295 => 0x1b },
	'unsharp2color' => { 295 => 0x2e },
	'unsharp2halowidth' => { 295 => 0x34 },
	'unsharp2intensity' => { 295 => 0x32 },
	'unsharp2threshold' => { 295 => 0x36 },
	'unsharp3color' => { 295 => 0x49 },
	'unsharp3halowidth' => { 295 => 0x4f },
	'unsharp3intensity' => { 295 => 0x4d },
	'unsharp3threshold' => { 295 => 0x51 },
	'unsharp4color' => { 295 => 0x64 },
	'unsharp4halowidth' => { 295 => 0x6a },
	'unsharp4intensity' => { 295 => 0x68 },
	'unsharp4threshold' => { 295 => 0x6c },
	'unsharpcount' => { 295 => 0x0 },
	'unsharpmask' => { 109 => 0x90, 290 => 0x76a43200 },
	'unsharpmaskfineness' => { 103 => 0x20309 },
	'unsharpmaskstrength' => { 103 => 0x20308 },
	'unsharpmaskthreshold' => { 103 => 0x2030a },
	'uprightcentermode' => { 500 => 'UprightCenterMode', 502 => 'UprightCenterMode' },
	'uprightcenternormx' => { 500 => 'UprightCenterNormX', 502 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 500 => 'UprightCenterNormY', 502 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 500 => 'UprightDependentDigest', 502 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 500 => 'UprightFocalLength35mm', 502 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 500 => 'UprightFocalMode', 502 => 'UprightFocalMode' },
	'uprightfoursegments_0' => { 500 => 'UprightFourSegments_0', 502 => 'UprightFourSegments_0' },
	'uprightfoursegments_1' => { 500 => 'UprightFourSegments_1', 502 => 'UprightFourSegments_1' },
	'uprightfoursegments_2' => { 500 => 'UprightFourSegments_2', 502 => 'UprightFourSegments_2' },
	'uprightfoursegments_3' => { 500 => 'UprightFourSegments_3', 502 => 'UprightFourSegments_3' },
	'uprightfoursegmentscount' => { 500 => 'UprightFourSegmentsCount', 502 => 'UprightFourSegmentsCount' },
	'uprightguideddependentdigest' => { 500 => 'UprightGuidedDependentDigest', 502 => 'UprightGuidedDependentDigest' },
	'uprightpreview' => { 500 => 'UprightPreview', 502 => 'UprightPreview' },
	'uprighttransform_0' => { 500 => 'UprightTransform_0', 502 => 'UprightTransform_0' },
	'uprighttransform_1' => { 500 => 'UprightTransform_1', 502 => 'UprightTransform_1' },
	'uprighttransform_2' => { 500 => 'UprightTransform_2', 502 => 'UprightTransform_2' },
	'uprighttransform_3' => { 500 => 'UprightTransform_3', 502 => 'UprightTransform_3' },
	'uprighttransform_4' => { 500 => 'UprightTransform_4', 502 => 'UprightTransform_4' },
	'uprighttransform_5' => { 500 => 'UprightTransform_5', 502 => 'UprightTransform_5' },
	'uprighttransformcount' => { 500 => 'UprightTransformCount', 502 => 'UprightTransformCount' },
	'uprightversion' => { 500 => 'UprightVersion', 502 => 'UprightVersion' },
	'urgency' => { 131 => 0xa, 517 => 'Urgency' },
	'url' => { 157 => 'URL', 330 => 'URL', 389 => 0x40b, 519 => 'url' },
	'url_list' => { 389 => 0x41e },
	'urla-platform' => { 519 => [\'url','urlA-platform'] },
	'urlurl' => { 519 => [\'url','urlUrl'] },
	'usablemeteringmodes' => { 84 => 0x10a },
	'usableshootingmodes' => { 84 => 0x109 },
	'usage' => { 520 => 'usage' },
	'usageterms' => { 533 => 'UsageTerms' },
	'usbpowerdelivery' => { 239 => 0x762, 240 => 0x664, 241 => 0x694, 242 => 0x6fc },
	'usedialwithouthold' => { 313 => 0xbf, 314 => 0xbf, 315 => 0xbf },
	'useguidelines' => { 498 => 'useGuidelines' },
	'usepanoramaviewer' => { 488 => 'UsePanoramaViewer' },
	'usercollection' => { 394 => 'collection.user' },
	'usercomment' => { 97 => 0x805, 119 => 0x9286, 506 => 'UserComment' },
	'userdef1picturestyle' => { 19 => 0x10c, 70 => 0xd8, 71 => 0xf0 },
	'userdef2picturestyle' => { 19 => 0x10e, 70 => 0xda, 71 => 0xf2 },
	'userdef3picturestyle' => { 19 => 0x110, 70 => 0xdc, 71 => 0xf4 },
	'userfields' => { 493 => 'UserFields' },
	'userlabel' => { 401 => 0x2b, 402 => 0x5a, 403 => 0x68 },
	'userprofile' => { 335 => 0x302, 339 => 0x34c, 342 => 0x3038 },
	'userrating' => { 394 => 'rating.user', 400 => 'urat' },
	'usmlenselectronicmf' => { 2 => 0x7, 83 => 0x7, 84 => 0x501 },
	'uspsnumber' => { 519 => 'uspsNumber' },
	'utmeasting' => { 168 => 'Easting' },
	'utmmapdatum' => { 168 => 'Datum' },
	'utmnorthing' => { 168 => 'Northing' },
	'utmzone' => { 168 => 'Zone' },
	'uuid' => { 500 => 'UUID', 502 => 'UUID' },
	'uv-irfiltercorrection' => { 335 => 0x325 },
	'validbits' => { 321 => 0x611, 322 => 0x102c },
	'validpixeldepth' => { 325 => 0x611 },
	'variablelowpassfilter' => { 440 => 0x2028 },
	'variousmodes' => { 140 => 0x26 },
	'variousmodes2' => { 140 => 0x3a },
	'variprogram' => { 234 => 0xab },
	'varraydacnominalvalues' => { 138 => 0x191e },
	'vendor' => { 400 => 'vndr' },
	'vendorinfo' => { 479 => 'VendorInfo' },
	'vendorinfomanufacturer' => { 479 => [\'VendorInfo','VendorInfoManufacturer'] },
	'vendorinfomodel' => { 479 => [\'VendorInfo','VendorInfoModel'] },
	'vendorinfonotes' => { 479 => [\'VendorInfo','VendorInfoNotes'] },
	'verbatimidentification' => { 118 => [\'Identification','IdentificationVerbatimIdentification'] },
	'version' => { 127 => 0x0, 391 => 'Version', 394 => 'version', 500 => 'Version', 502 => 'Version', 511 => 'Version' },
	'versioncreatedate' => { 476 => 0xd100 },
	'versionid' => { 530 => 'VersionID' },
	'versionidentifier' => { 519 => 'versionIdentifier' },
	'versionmodifydate' => { 476 => 0xd101 },
	'versions' => { 530 => 'Versions' },
	'versionscomments' => { 530 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 530 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 530 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 530 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 530 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 530 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 530 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 530 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 530 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 530 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 530 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 297 => '3.2', 298 => '47.2', 300 => '79.1', 314 => 0x11d, 315 => 0x135 },
	'verticalclockoverlaps' => { 138 => 0x412 },
	'verticalfuncbutton' => { 298 => '42.2', 300 => '67.1', 314 => 0x115, 315 => 0x12d },
	'verticalfuncbuttonplaybackmode' => { 314 => 0x1b7, 315 => 0x1cf },
	'verticalfuncbuttonplusdials' => { 298 => '43.1' },
	'verticalfuncplusdials' => { 300 => '68.1' },
	'verticalisobutton' => { 242 => 0x792 },
	'verticalmovieafonbutton' => { 314 => 0x1f9, 315 => 0x211 },
	'verticalmoviefuncbutton' => { 314 => 0x1e1, 315 => 0x1f9 },
	'verticalmultiselector' => { 298 => '42.1', 300 => '66.1', 301 => '66.1', 311 => '66.1', 314 => 0x18f, 315 => 0x1a7 },
	'verticalmultiselectorplaybackmode' => { 314 => 0x125, 315 => 0x13d },
	'vfdisplayillumination' => { 2 => 0x11, 84 => [0x510,0x51d] },
	'vibrance' => { 494 => 'Vibrance', 500 => 'Vibrance', 502 => 'Vibrance' },
	'vibrationreduction' => { 262 => [0x75,0x82,0x1ae], 270 => '586.1', 277 => '590.2', 281 => 0x4 },
	'videoalphamode' => { 529 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 529 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 529 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 529 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 529 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 529 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 529 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgray' => { 529 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGray'] },
	'videoalphapremultiplecolorgreen' => { 529 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 529 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 529 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 529 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 529 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 529 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 529 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 529 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 529 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 529 => 'videoAlphaUnityIsTransparent' },
	'videobitrate' => { 514 => 'videoBitRate' },
	'videobitratemode' => { 514 => 'videoBitRateMode' },
	'videoburstmode' => { 340 => 0xbb },
	'videoburstresolution' => { 340 => 0xb3 },
	'videocodec' => { 67 => 0x74 },
	'videocolorspace' => { 529 => 'videoColorSpace' },
	'videocompression' => { 127 => 0x3806 },
	'videocompressor' => { 529 => 'videoCompressor' },
	'videodisplayaspectratio' => { 514 => 'videoDisplayAspectRatio' },
	'videoencodingprofile' => { 514 => 'videoEncodingProfile' },
	'videofieldorder' => { 529 => 'videoFieldOrder' },
	'videoframerate' => { 340 => 0x27, 529 => 'videoFrameRate' },
	'videoframesize' => { 529 => 'videoFrameSize' },
	'videoframesizeh' => { 529 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 529 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 529 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 529 => 'videoModDate' },
	'videopixelaspectratio' => { 529 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 529 => 'videoPixelDepth' },
	'videopreburst' => { 340 => 0xc1 },
	'videoquality' => { 113 => 0x4003 },
	'videorecordingmode' => { 127 => 0x3803 },
	'videoshottype' => { 514 => 'VideoShotType' },
	'videoshottypeidentifier' => { 514 => [\'VideoShotType','VideoShotTypeIdentifier'] },
	'videoshottypename' => { 514 => [\'VideoShotType','VideoShotTypeName'] },
	'videostreamscount' => { 514 => 'videoStreamsCount' },
	'viewfinder' => { 384 => 0x455 },
	'viewfinderdisplay' => { 297 => '12.4', 298 => '6.3' },
	'viewfinderwarning' => { 297 => '13.4', 307 => '3.5', 308 => '6.2', 312 => '4.4' },
	'viewfinderwarnings' => { 84 => 0x40a },
	'viewinfoduringexposure' => { 84 => 0x407 },
	'viewingmode' => { 429 => 0x2f, 445 => 0x18 },
	'viewingmode2' => { 429 => [0x85,0x285] },
	'viewmodeshoweffectsofsettings' => { 242 => 0x7d2, 313 => 0x2a9 },
	'viewpoint' => { 518 => 'viewpoint' },
	'vignetteamount' => { 500 => 'VignetteAmount', 502 => 'VignetteAmount' },
	'vignettecontrol' => { 234 => 0x2a, 290 => 0x76a43205 },
	'vignettecontrolintensity' => { 290 => 0xac6bd5c0 },
	'vignettecorrectionalreadyapplied' => { 497 => 'VignetteCorrectionAlreadyApplied' },
	'vignettemidpoint' => { 500 => 'VignetteMidpoint', 502 => 'VignetteMidpoint' },
	'vignetting' => { 407 => 0x1011, 414 => 0xa052 },
	'vignettingcorrection' => { 119 => 0x7031, 414 => 0xa053, 440 => 0x2011 },
	'vignettingcorrparams' => { 119 => 0x7032, 471 => 0x64a, 472 => [0x34a,0x350,0x35c,0x368] },
	'vignettingsetting' => { 414 => 0xa054 },
	'virtualfocallength' => { 515 => 'VirtualFocalLength' },
	'virtualhorizonstyle' => { 313 => 0x167, 314 => 0x167, 315 => 0x17f },
	'virtualimagexcenter' => { 515 => 'VirtualImageXCenter' },
	'virtualimageycenter' => { 515 => 'VirtualImageYCenter' },
	'visualcolor' => { 514 => 'VisualColour' },
	'visualtechnique' => { 518 => 'visualTechnique' },
	'voicememo' => { 416 => 0x216 },
	'volume' => { 519 => 'volume' },
	'vr_0x66' => { 262 => 0x66 },
	'vrdoffset' => { 64 => 0xd0 },
	'vrmode' => { 239 => 0x226, 240 => 0x212, 241 => 0x226, 242 => 0x226, 281 => 0x6 },
	'vrtype' => { 281 => 0x8 },
	'waterdepth' => { 119 => 0x9403, 507 => 'WaterDepth' },
	'wb_bluelevel3500k' => { 187 => 0x19a },
	'wb_bluelevel6500k' => { 187 => 0x18a },
	'wb_bluelevelcustom' => { 187 => 0x18e },
	'wb_bluelevelscloudy' => { 187 => 0x106 },
	'wb_bluelevelsdaylight' => { 187 => 0xea },
	'wb_bluelevelsflash' => { 187 => 0x122 },
	'wb_bluelevelsfluorescent' => { 187 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 187 => 0x254 },
	'wb_bluelevelsshade' => { 187 => 0x176 },
	'wb_bluelevelstungsten' => { 187 => 0xce },
	'wb_gbrglevels' => { 187 => 0xae, 190 => 0x4 },
	'wb_glevel' => { 321 => 0x11f },
	'wb_glevel3000k' => { 321 => 0x113 },
	'wb_glevel3300k' => { 321 => 0x114 },
	'wb_glevel3600k' => { 321 => 0x115 },
	'wb_glevel3900k' => { 321 => 0x116 },
	'wb_glevel4000k' => { 321 => 0x117 },
	'wb_glevel4300k' => { 321 => 0x118 },
	'wb_glevel4500k' => { 321 => 0x119 },
	'wb_glevel4800k' => { 321 => 0x11a },
	'wb_glevel5300k' => { 321 => 0x11b },
	'wb_glevel6000k' => { 321 => 0x11c },
	'wb_glevel6600k' => { 321 => 0x11d },
	'wb_glevel7500k' => { 321 => 0x11e },
	'wb_grbglevels' => { 204 => 0x0, 447 => 0x7303 },
	'wb_grbglevelsauto' => { 81 => 0x2, 447 => 0x7302 },
	'wb_grbglevelscloudy' => { 81 => 0x12 },
	'wb_grbglevelscustom1' => { 81 => 0x42 },
	'wb_grbglevelscustom2' => { 81 => 0x4a },
	'wb_grbglevelsdaylight' => { 81 => 0xa },
	'wb_grbglevelsflash' => { 81 => 0x32 },
	'wb_grbglevelsfluorescent' => { 81 => 0x22 },
	'wb_grbglevelsfluorhigh' => { 81 => 0x2a },
	'wb_grbglevelstungsten' => { 81 => 0x1a },
	'wb_grbglevelsunderwater' => { 81 => 0x3a },
	'wb_rbgglevels' => { 201 => 0x0 },
	'wb_rblevels' => { 205 => 0x270, 234 => 0xc, 321 => 0x100 },
	'wb_rblevels1' => { 346 => 0x2 },
	'wb_rblevels2' => { 346 => 0x5 },
	'wb_rblevels3' => { 346 => 0x8 },
	'wb_rblevels3000k' => { 321 => 0x102 },
	'wb_rblevels3300k' => { 321 => 0x103 },
	'wb_rblevels3500k' => { 187 => 0x430 },
	'wb_rblevels3600k' => { 321 => 0x104 },
	'wb_rblevels3900k' => { 321 => 0x105 },
	'wb_rblevels4' => { 346 => 0xb },
	'wb_rblevels4000k' => { 321 => 0x106 },
	'wb_rblevels4300k' => { 321 => 0x107 },
	'wb_rblevels4500k' => { 321 => 0x108 },
	'wb_rblevels4800k' => { 321 => 0x109 },
	'wb_rblevels5' => { 346 => 0xe },
	'wb_rblevels5300k' => { 321 => 0x10a },
	'wb_rblevels6' => { 346 => 0x11 },
	'wb_rblevels6000k' => { 321 => 0x10b },
	'wb_rblevels6500k' => { 187 => 0x420 },
	'wb_rblevels6600k' => { 321 => 0x10c },
	'wb_rblevels7' => { 346 => 0x14 },
	'wb_rblevels7500k' => { 321 => 0x10d },
	'wb_rblevelsauto' => { 205 => 0x272, 325 => 0x110 },
	'wb_rblevelscloudy' => { 187 => 0x3f0, 189 => 0x10, 205 => 0x296, 325 => 0x121 },
	'wb_rblevelscoolwhitef' => { 187 => 0x308, 189 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 325 => 0x132 },
	'wb_rblevelscustom' => { 187 => 0x424, 189 => 0x1c },
	'wb_rblevelscwb1' => { 321 => 0x10e },
	'wb_rblevelscwb2' => { 321 => 0x10f },
	'wb_rblevelscwb3' => { 321 => 0x110 },
	'wb_rblevelscwb4' => { 321 => 0x111 },
	'wb_rblevelsdaylight' => { 187 => [0x3ec,0x528], 189 => 0xc, 205 => 0x274 },
	'wb_rblevelsdaylightf' => { 189 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 325 => 0x130 },
	'wb_rblevelsdaywhitef' => { 189 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 325 => 0x131 },
	'wb_rblevelseveningsunlight' => { 325 => 0x124 },
	'wb_rblevelsfineweather' => { 325 => 0x122 },
	'wb_rblevelsflash' => { 187 => [0x3f4,0x304], 189 => 0x18, 205 => 0x2a4 },
	'wb_rblevelsfluorescent' => { 205 => 0x290 },
	'wb_rblevelsincandescent' => { 205 => 0x282 },
	'wb_rblevelsshade' => { 187 => 0x418, 189 => 0x20, 205 => 0x2b2, 325 => 0x120 },
	'wb_rblevelstungsten' => { 187 => 0x3e8, 189 => 0x8, 325 => 0x123 },
	'wb_rblevelsused' => { 325 => 0x100 },
	'wb_rblevelswhitef' => { 189 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 325 => 0x133 },
	'wb_redlevel3500k' => { 187 => 0x198 },
	'wb_redlevel6500k' => { 187 => 0x188 },
	'wb_redlevelcustom' => { 187 => 0x18c },
	'wb_redlevelscloudy' => { 187 => 0xf8 },
	'wb_redlevelsdaylight' => { 187 => 0xdc },
	'wb_redlevelsflash' => { 187 => 0x114 },
	'wb_redlevelsfluorescent' => { 187 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 187 => 0x1be },
	'wb_redlevelsshade' => { 187 => 0x168 },
	'wb_redlevelstungsten' => { 187 => 0xc0 },
	'wb_rgbglevels' => { 203 => 0x0 },
	'wb_rgblevels' => { 187 => [0x546,0x96], 336 => 0xd, 337 => 0x413, 342 => 0x3036, 384 => 0x107, 449 => 0x117c, 450 => 0x1180, 451 => 0x115c, 452 => 0x11d8, 453 => 0x11b4, 454 => 0x106c, 455 => 0x264, 456 => 0x264, 457 => 0x252 },
	'wb_rgblevels1' => { 347 => 0x2 },
	'wb_rgblevels2' => { 347 => 0x6 },
	'wb_rgblevels2500k' => { 447 => 0x782d },
	'wb_rgblevels3' => { 347 => 0xa },
	'wb_rgblevels3200k' => { 447 => 0x782c },
	'wb_rgblevels4' => { 347 => 0xe },
	'wb_rgblevels4500k' => { 447 => [0x7484,0x7824] },
	'wb_rgblevels5' => { 347 => 0x12 },
	'wb_rgblevels6' => { 347 => 0x16 },
	'wb_rgblevels6000k' => { 447 => 0x782b },
	'wb_rgblevels7' => { 347 => 0x1a },
	'wb_rgblevels8500k' => { 447 => 0x782a },
	'wb_rgblevelsauto' => { 418 => 0x0 },
	'wb_rgblevelscloudy' => { 447 => [0x7481,0x7821] },
	'wb_rgblevelscustom1' => { 418 => 0x15 },
	'wb_rgblevelscustom2' => { 418 => 0x18 },
	'wb_rgblevelscustom3' => { 418 => 0x1b },
	'wb_rgblevelsdaylight' => { 418 => 0x3, 447 => [0x7480,0x7820] },
	'wb_rgblevelsflash' => { 418 => 0x12, 447 => [0x7483,0x7823] },
	'wb_rgblevelsfluorescent' => { 418 => 0xf, 447 => [0x7486,0x7826] },
	'wb_rgblevelsfluorescentm1' => { 447 => 0x7829 },
	'wb_rgblevelsfluorescentp1' => { 447 => 0x7827 },
	'wb_rgblevelsfluorescentp2' => { 447 => 0x7828 },
	'wb_rgblevelsincandescent' => { 418 => 0xc },
	'wb_rgblevelsovercast' => { 418 => 0x9 },
	'wb_rgblevelsshade' => { 418 => 0x6, 447 => 0x7825 },
	'wb_rgblevelstungsten' => { 447 => [0x7482,0x7822] },
	'wb_rgblevelsunknown0' => { 419 => 0x0 },
	'wb_rgblevelsunknown1' => { 419 => 0x3 },
	'wb_rgblevelsunknown2' => { 419 => 0x6 },
	'wb_rgblevelsunknown3' => { 419 => 0x9 },
	'wb_rgblevelsunknown4' => { 419 => 0xc },
	'wb_rgblevelsunknown5' => { 419 => 0xf },
	'wb_rgblevelsunknown6' => { 419 => 0x12 },
	'wb_rgblevelsunknown7' => { 419 => 0x15 },
	'wb_rgblevelsunknown8' => { 419 => 0x18 },
	'wb_rgblevelsunknown9' => { 419 => 0x1b },
	'wb_rgbmuldaylight' => { 138 => 0x852 },
	'wb_rgbmulflash' => { 138 => 0x855 },
	'wb_rgbmulfluorescent' => { 138 => 0x854 },
	'wb_rgbmultungsten' => { 138 => 0x853 },
	'wb_rggbblacklevels' => { 35 => 0x25 },
	'wb_rggblevels' => { 119 => 0x7313, 190 => 0x4, 202 => 0x0, 206 => 0x13e8, 207 => 0x38, 447 => 0x7313 },
	'wb_rggblevelsasshot' => { 38 => 0x0, 39 => 0x0, 40 => 0x19, 41 => 0x55, 42 => 0x69, 43 => 0x22, 44 => 0x3f, 47 => 0x3f, 48 => 0x3f, 49 => 0x3f, 50 => 0x47 },
	'wb_rggblevelsauto' => { 35 => 0x1, 38 => 0x5, 39 => 0x8, 40 => 0x1e, 41 => 0x5a, 42 => 0x6e, 43 => 0x18, 44 => 0x44, 47 => 0x44, 48 => 0x44, 49 => 0x44, 50 => 0x4c, 206 => 0x1478, 207 => 0x114, 414 => 0xa022, 447 => 0x7312 },
	'wb_rggblevelsblack' => { 414 => 0xa028 },
	'wb_rggblevelscloudy' => { 35 => 0xd, 38 => 0x1e, 39 => 0x30, 40 => 0x2d, 41 => 0xa0, 42 => 0xd7, 43 => 0x31, 44 => 0x58, 47 => 0x71, 48 => 0x8a, 49 => 0x8f, 50 => 0x92, 206 => 0x1408, 207 => 0x60, 375 => 0x20f, 383 => 0x14 },
	'wb_rggblevelscustom' => { 35 => 0x1d, 44 => 0x80, 206 => 0x1468, 207 => 0x100 },
	'wb_rggblevelscustom1' => { 40 => 0x41 },
	'wb_rggblevelscustom2' => { 40 => 0x46 },
	'wb_rggblevelsdaylight' => { 35 => 0x5, 38 => 0x14, 39 => 0x20, 40 => 0x23, 41 => 0x96, 42 => 0xcd, 43 => 0x27, 44 => 0x4e, 47 => 0x67, 48 => 0x80, 49 => 0x85, 50 => 0x88, 206 => 0x13f8, 207 => 0x4c, 375 => 0x20d, 383 => 0x2 },
	'wb_rggblevelsflash' => { 35 => 0x19, 38 => 0x32, 39 => 0x50, 40 => 0x3c, 41 => 0xb4, 42 => 0xeb, 43 => 0x45, 44 => 0x6c, 47 => 0x85, 48 => 0x9e, 49 => 0xa3, 50 => 0xa6, 206 => 0x1448, 375 => 0x214, 383 => 0x41 },
	'wb_rggblevelsfluorescent' => { 35 => 0x15, 38 => 0x28, 39 => 0x40, 40 => 0x37, 41 => 0xaa, 42 => 0xe1, 43 => 0x3b, 44 => 0x62, 47 => 0x7b, 48 => 0x94, 49 => 0x99, 50 => 0x9c },
	'wb_rggblevelsfluorescentd' => { 207 => 0xc4, 375 => 0x211, 383 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 383 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 207 => 0xb0, 375 => 0x212, 383 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 206 => 0x1438, 207 => 0x9c, 375 => 0x213, 383 => 0x38 },
	'wb_rggblevelshtmercury' => { 207 => 0xd8 },
	'wb_rggblevelsilluminator1' => { 414 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 414 => 0xa024 },
	'wb_rggblevelskelvin' => { 35 => 0x21, 38 => 0x2d, 39 => 0x48, 41 => 0xaf, 42 => 0xe6, 43 => 0x40, 44 => 0x67, 47 => 0x80, 48 => 0x99, 49 => 0x9e, 50 => 0xa1 },
	'wb_rggblevelsmeasured' => { 38 => 0xa, 39 => 0x10, 41 => 0x5f, 42 => 0x73, 44 => 0x49, 47 => 0x49, 48 => 0x49, 49 => 0x49, 50 => 0x51 },
	'wb_rggblevelspc1' => { 43 => 0x90, 44 => 0x71 },
	'wb_rggblevelspc2' => { 43 => 0x95, 44 => 0x76 },
	'wb_rggblevelspc3' => { 43 => 0x9a, 44 => 0x7b },
	'wb_rggblevelsshade' => { 35 => 0x9, 38 => 0x19, 39 => 0x28, 40 => 0x28, 41 => 0x9b, 42 => 0xd2, 43 => 0x2c, 44 => 0x53, 47 => 0x6c, 48 => 0x85, 49 => 0x8a, 50 => 0x8d, 207 => 0x74, 375 => 0x20e, 383 => 0xb },
	'wb_rggblevelstungsten' => { 35 => 0x11, 38 => 0x23, 39 => 0x38, 40 => 0x32, 41 => 0xa5, 42 => 0xdc, 43 => 0x36, 44 => 0x5d, 47 => 0x76, 48 => 0x8f, 49 => 0x94, 50 => 0x97, 206 => 0x1428, 207 => 0x88, 375 => 0x210, 383 => 0x1d },
	'wb_rggblevelsuncorrected' => { 414 => 0xa021 },
	'wb_rggblevelsunknown' => { 38 => 0xf, 39 => 0x18, 41 => 0x64, 42 => 0x78, 43 => 0x1d, 47 => 0x4e, 48 => 0x4e, 49 => 0x4e, 50 => 0x56, 383 => 0x53 },
	'wb_rggblevelsunknown10' => { 38 => 0x5f, 39 => 0x98, 41 => 0x91, 42 => 0xa5, 43 => 0x72, 47 => 0x9e, 48 => 0x7b, 49 => 0x7b, 50 => 0x83 },
	'wb_rggblevelsunknown11' => { 38 => 0x64, 39 => 0xa0, 41 => 0xb9, 42 => [0xaa,0xaf], 43 => 0x77, 47 => 0xa3, 48 => 0xa3, 49 => 0x80, 50 => 0xab },
	'wb_rggblevelsunknown12' => { 38 => 0x69, 39 => 0xa8, 41 => 0xbe, 42 => 0xb4, 43 => 0x7c, 47 => 0xa8, 48 => 0xa8, 49 => 0xa8, 50 => 0xb0 },
	'wb_rggblevelsunknown13' => { 38 => 0x6e, 39 => 0xb0, 41 => 0xc3, 42 => 0xb9, 43 => 0x81, 47 => 0xad, 48 => 0xad, 49 => 0xad, 50 => 0xb5 },
	'wb_rggblevelsunknown14' => { 41 => 0xc8, 42 => 0xbe, 43 => 0x86, 47 => 0xb2, 48 => 0xb2, 49 => 0xb2, 50 => 0xba },
	'wb_rggblevelsunknown15' => { 41 => 0xcd, 42 => 0xc3, 43 => 0x8b, 47 => 0xb7, 48 => 0xb7, 49 => 0xb7, 50 => 0xbf },
	'wb_rggblevelsunknown16' => { 41 => 0xd2, 42 => 0xc8, 43 => 0x9f, 48 => 0xbc, 49 => 0xbc, 50 => 0xc4 },
	'wb_rggblevelsunknown17' => { 41 => 0xd7, 42 => 0xf0, 48 => 0xc1, 49 => 0xc1, 50 => 0xc9 },
	'wb_rggblevelsunknown18' => { 41 => 0xdc, 42 => 0xf5, 48 => 0xc6, 49 => 0xc6, 50 => 0xce },
	'wb_rggblevelsunknown19' => { 41 => 0xe1, 42 => 0xfa, 48 => 0xcb, 49 => 0xcb, 50 => 0xd3 },
	'wb_rggblevelsunknown2' => { 38 => 0x37, 39 => 0x58, 41 => 0x69, 42 => 0x7d, 43 => 0x4a, 47 => 0x53, 48 => 0x53, 49 => 0x53, 50 => 0x5b },
	'wb_rggblevelsunknown20' => { 41 => 0xe6, 42 => 0xff, 48 => 0xd0, 49 => 0xd0, 50 => 0xd8 },
	'wb_rggblevelsunknown21' => { 41 => 0xeb, 42 => 0x104, 49 => 0xd5, 50 => 0xdd },
	'wb_rggblevelsunknown22' => { 41 => 0xf0, 42 => 0x109, 49 => 0xda, 50 => 0xe2 },
	'wb_rggblevelsunknown23' => { 41 => 0xf5, 42 => 0x10e, 49 => 0xdf, 50 => 0xe7 },
	'wb_rggblevelsunknown24' => { 41 => 0xfa, 42 => 0x113, 49 => 0xe4, 50 => 0xec },
	'wb_rggblevelsunknown25' => { 41 => 0xff, 42 => 0x118, 49 => 0xe9, 50 => 0xf1 },
	'wb_rggblevelsunknown26' => { 41 => 0x104, 42 => 0x11d, 49 => 0xee, 50 => 0xf6 },
	'wb_rggblevelsunknown27' => { 41 => 0x109, 42 => 0x122, 49 => 0xf3, 50 => 0xfb },
	'wb_rggblevelsunknown28' => { 41 => 0x10e, 49 => 0xf8, 50 => 0x100 },
	'wb_rggblevelsunknown29' => { 41 => 0x113, 49 => 0xfd, 50 => 0x105 },
	'wb_rggblevelsunknown3' => { 38 => 0x3c, 39 => 0x60, 41 => 0x6e, 42 => 0x82, 43 => 0x4f, 47 => 0x58, 48 => 0x58, 49 => 0x58, 50 => 0x60 },
	'wb_rggblevelsunknown30' => { 49 => 0x102 },
	'wb_rggblevelsunknown4' => { 38 => 0x41, 39 => 0x68, 41 => 0x73, 42 => 0x87, 43 => 0x54, 47 => 0x5d, 48 => 0x5d, 49 => 0x5d, 50 => 0x65 },
	'wb_rggblevelsunknown5' => { 38 => 0x46, 39 => 0x70, 41 => 0x78, 42 => 0x8c, 43 => 0x59, 47 => 0x62, 48 => 0x62, 49 => 0x62, 50 => 0x6a },
	'wb_rggblevelsunknown6' => { 38 => 0x4b, 39 => 0x78, 41 => 0x7d, 42 => 0x91, 43 => 0x5e, 47 => 0x8a, 48 => 0x67, 49 => 0x67, 50 => 0x6f },
	'wb_rggblevelsunknown7' => { 38 => 0x50, 39 => 0x80, 41 => 0x82, 42 => 0x96, 43 => 0x63, 47 => 0x8f, 48 => 0x6c, 49 => 0x6c, 50 => 0x74 },
	'wb_rggblevelsunknown8' => { 38 => 0x55, 39 => 0x88, 41 => 0x87, 42 => 0x9b, 43 => 0x68, 47 => 0x94, 48 => 0x71, 49 => 0x71, 50 => 0x79 },
	'wb_rggblevelsunknown9' => { 38 => 0x5a, 39 => 0x90, 41 => 0x8c, 42 => 0xa0, 43 => 0x6d, 47 => 0x99, 48 => 0x76, 49 => 0x76, 50 => 0x7e },
	'wb_rggblevelsuserselected' => { 383 => 0x5c },
	'wbadjblueamber' => { 103 => 0x20106 },
	'wbadjbluebalance' => { 296 => 0x8 },
	'wbadjcolortemp' => { 103 => 0x20102, 108 => 0x1a },
	'wbadjlighting' => { 296 => 0x14 },
	'wbadjmagentagreen' => { 103 => 0x20105 },
	'wbadjmode' => { 296 => 0x10 },
	'wbadjredbalance' => { 296 => 0x0 },
	'wbadjrggblevels' => { 103 => 0x20125, 108 => 0x6 },
	'wbadjtemperature' => { 296 => 0x18 },
	'wbadjtint' => { 296 => 0x25 },
	'wbbluelevel' => { 335 => 0x324, 340 => 0x8006, 345 => 0x26 },
	'wbbracketingsteps' => { 198 => 0x10, 199 => 0x10, 271 => 0x174d },
	'wbbracketmode' => { 57 => 0x9 },
	'wbbracketshotnumber' => { 187 => 0x2b, 407 => 0x101a },
	'wbbracketvalueab' => { 57 => 0xc },
	'wbbracketvaluegm' => { 57 => 0xd },
	'wbbutton' => { 242 => 0x80a },
	'wbfinetuneactive' => { 108 => 0x24 },
	'wbfinetunesaturation' => { 108 => 0x28 },
	'wbfinetunetone' => { 108 => 0x2c },
	'wbgreenlevel' => { 335 => 0x323, 340 => 0x8005, 345 => 0x25 },
	'wbmediaimagesizesetting' => { 84 => 0x708 },
	'wbmode' => { 189 => 0x4, 322 => 0x1015 },
	'wbredlevel' => { 335 => 0x322, 340 => 0x8004, 345 => 0x24 },
	'wbscale' => { 190 => 0x0 },
	'wbshiftab' => { 74 => 0xc, 340 => 0x46, 357 => 0x10 },
	'wbshiftab_gm' => { 440 => 0x2014 },
	'wbshiftab_gm_precise' => { 440 => 0x2026 },
	'wbshiftcreativecontrol' => { 340 => 0x92 },
	'wbshiftgm' => { 74 => 0xd, 340 => 0x47, 357 => 0x11 },
	'wbshiftintelligentauto' => { 340 => 0x8b },
	'wbtype1' => { 346 => 0x1, 347 => 0x1 },
	'wbtype2' => { 346 => 0x4, 347 => 0x5 },
	'wbtype3' => { 346 => 0x7, 347 => 0x9 },
	'wbtype4' => { 346 => 0xa, 347 => 0xd },
	'wbtype5' => { 346 => 0xd, 347 => 0x11 },
	'wbtype6' => { 346 => 0x10, 347 => 0x15 },
	'wbtype7' => { 346 => 0x13, 347 => 0x19 },
	'webstatement' => { 533 => 'WebStatement' },
	'weightedflatsubject' => { 492 => 'weightedFlatSubject' },
	'what' => { 500 => 'What', 502 => 'What' },
	'whitebalance' => { 7 => 0x6f, 8 => [0x44,0x4a], 9 => 0xbc, 10 => 0x36, 11 => 0x5e, 12 => 0x36, 13 => 0x78, 14 => 0x6f, 15 => 0x6f, 16 => 0x73, 17 => 0x6f, 18 => 0x78, 19 => 0x54, 20 => 0x6f, 21 => 0xbc, 22 => 0x7b, 24 => 0xbc, 25 => 0xc2, 27 => 0x131, 28 => 0x77, 74 => 0x8, 77 => 0x7, 112 => 0x7, 113 => [0x19,0x2012], 119 => [0xa403,0xfe4e], 127 => 0x1002, 138 => 0x3fc, 139 => 0xfa0d, 140 => 0x40, 151 => 0x1a, 181 => 0x3, 182 => 0xe, 183 => 0x4, 184 => 0xb, 186 => 0x115, 234 => 0x5, 280 => 0x7, 335 => 0x304, 340 => 0x3, 342 => 0x3033, 375 => 0x19, 382 => 0x7, 406 => 0x26, 407 => 0x1003, 417 => [0x88,0x3c,0x7,0x58], 427 => 0xf, 428 => 0xe, 440 => [0x115,0xb054], 500 => 'WhiteBalance', 502 => 'WhiteBalance', 506 => 'WhiteBalance' },
	'whitebalance0' => { 176 => 'WhiteBalance0' },
	'whitebalance1' => { 176 => 'WhiteBalance1' },
	'whitebalance2' => { 176 => 'WhiteBalance2', 317 => 0x500 },
	'whitebalanceadj' => { 103 => 0x20101, 108 => 0x18, 290 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 353 => 0x0 },
	'whitebalancebias' => { 113 => 0x2011, 322 => 0x304, 340 => 0x23 },
	'whitebalanceblue' => { 74 => 0x7 },
	'whitebalancebracket' => { 317 => 0x502, 322 => 0x303 },
	'whitebalancebracketing' => { 184 => 0x22, 187 => 0x2c, 438 => 0x2c },
	'whitebalancebuttonplaybackmode' => { 314 => 0x1c5, 315 => 0x1dd },
	'whitebalancecomp' => { 325 => 0x1001 },
	'whitebalancedetected' => { 138 => 0x3fb },
	'whitebalancefinetune' => { 127 => 0x100a, 184 => 0x38, 186 => 0x112, 234 => [0xb,0x3f], 407 => 0x1004, 427 => 0x6, 428 => 0x5, 440 => 0x112 },
	'whitebalancemode' => { 138 => 0x3fa, 375 => 0x1a },
	'whitebalancered' => { 74 => 0x6 },
	'whitebalanceset' => { 356 => 0xa },
	'whitebalancesetting' => { 184 => 0x23, 427 => 0x5, 428 => 0x4, 429 => 0x16, 445 => 0xd },
	'whitebalancesetup' => { 414 => 0x41 },
	'whitebalancetemperature' => { 317 => 0x501 },
	'whiteboard' => { 322 => 0x301 },
	'whitelevel' => { 119 => 0xc61d, 375 => 0x7e, 447 => 0x787f },
	'whitepoint' => { 119 => 0x13e, 339 => 0x35d, 375 => 0x201, 525 => 'WhitePoint' },
	'whites2012' => { 500 => 'Whites2012', 502 => 'Whites2012' },
	'whitesadj' => { 476 => 0x9017 },
	'wideadapter' => { 407 => 0x1017 },
	'widefocuszone' => { 181 => 0x2f },
	'widerange' => { 416 => 0x20f },
	'windmode' => { 138 => 0x3f4 },
	'windnoisereduction' => { 239 => 0x352, 240 => 0x2d6, 241 => 0x2fe, 242 => 0x2fe },
	'windowlocation' => { 400 => 'WLOC' },
	'windowsatom' => { 501 => 'windowsAtom' },
	'windowsatomextension' => { 501 => [\'windowsAtom','windowsAtomExtension'] },
	'windowsatominvocationflags' => { 501 => [\'windowsAtom','windowsAtomInvocationFlags'] },
	'windowsatomuncprojectpath' => { 501 => [\'windowsAtom','windowsAtomUncProjectPath'] },
	'wordcount' => { 519 => 'wordCount' },
	'work' => { 392 => "\xa9wrk" },
	'workcolorspace' => { 103 => 0x10200, 108 => 0x270 },
	'workflowtag' => { 514 => 'WorkflowTag' },
	'workflowtagcvid' => { 514 => [\'WorkflowTag','WorkflowTagCvId'] },
	'workflowtagcvtermid' => { 514 => [\'WorkflowTag','WorkflowTagCvTermId'] },
	'workflowtagcvtermname' => { 514 => [\'WorkflowTag','WorkflowTagCvTermName'] },
	'workflowtagcvtermrefinedabout' => { 514 => [\'WorkflowTag','WorkflowTagCvTermRefinedAbout'] },
	'worktodo' => { 508 => 'WorkToDo' },
	'worldtimelocation' => { 340 => 0x3a, 375 => 0x22, 381 => '0.1' },
	'writer' => { 179 => 'WM/Writer' },
	'writer-editor' => { 131 => 0x7a },
	'x3filllight' => { 417 => 0x12 },
	'xattrquarantine' => { 174 => 'com.apple.quarantine' },
	'xilinxversion' => { 138 => 0x414 },
	'xml' => { 136 => 'xml ' },
	'xmp' => { 106 => 0xffff00f6, 120 => 'XMP' },
	'xmptoolkit' => { 526 => 'xmptk' },
	'xpauthor' => { 119 => 0x9c9d },
	'xpcomment' => { 119 => 0x9c9c },
	'xpkeywords' => { 119 => 0x9c9e },
	'xposition' => { 119 => 0x11e },
	'xpsubject' => { 119 => 0x9c9f },
	'xptitle' => { 119 => 0x9c9b },
	'xresolution' => { 119 => 0x11a, 134 => 0x3, 390 => 0x0, 525 => 'XResolution' },
	'xyresolution' => { 123 => 0x3 },
	'yaw' => { 115 => 0x7, 400 => ['_yaw',"\xa9fyw"] },
	'yawangle' => { 247 => 0x8, 412 => 0x0 },
	'ycbcrcoefficients' => { 119 => 0x211, 525 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 119 => 0x213, 525 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 119 => 0x212, 525 => 'YCbCrSubSampling' },
	'year' => { 392 => 'yrrc', 394 => 'year', 400 => 'yrrc' },
	'yearcreated' => { 140 => 0x10, 149 => 0xc },
	'yellowhsl' => { 103 => 0x20912 },
	'yield' => { 521 => 'yield' },
	'yposition' => { 119 => 0x11f },
	'yresolution' => { 119 => 0x11b, 134 => 0x5, 390 => 0x4, 525 => 'YResolution' },
	'zebrapatterntonerange' => { 313 => 0x211, 314 => 0x211, 315 => 0x229 },
	'zoneidentifier' => { 120 => 'ZoneIdentifier' },
	'zonematching' => { 186 => 0x10a, 189 => [0x3a,0x4a], 440 => 0xb024 },
	'zonematchingmode' => { 184 => 0x14 },
	'zonematchingon' => { 183 => 0x75 },
	'zonematchingvalue' => { 427 => 0x1f },
	'zoomedpreviewlength' => { 322 => 0xf05 },
	'zoomedpreviewsize' => { 322 => 0xf06 },
	'zoomedpreviewstart' => { 322 => 0xf04 },
	'zoomsourcewidth' => { 34 => 0x24 },
	'zoomstepcount' => { 320 => 0x300, 322 => 0x100d },
	'zoomtargetwidth' => { 34 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_misb' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'abstractfilename' => 1,
	'accel360fly' => 1,
	'acceldata' => 1,
	'accelerometermatrix' => 1,
	'accelerometertime' => 1,
	'accelerometerunknown' => 1,
	'accelmode' => 1,
	'accelypr' => 1,
	'accessdate' => 1,
	'accompaniment' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acidizer' => 1,
	'acidizerflags' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'activebuf1cols' => 1,
	'activebuf1rows' => 1,
	'activebuf2cols' => 1,
	'activebuf2rows' => 1,
	'activecols' => 1,
	'activectemonitor1cols' => 1,
	'activectemonitor2cols' => 1,
	'activectemonitorrows' => 1,
	'activerows' => 1,
	'actor' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'actualsoftpostpadding' => 1,
	'actualsoftprepadding' => 1,
	'additionalinfo' => 1,
	'adjdebuginfo' => 1,
	'adjustedtbnimageheight' => 1,
	'adjustedtbnimagewidth' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'adult' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aedebuginfo' => 1,
	'aeflags' => 1,
	'aehistograminfo' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'aeliveviewhistograminfo' => 1,
	'aeliveviewlocalhistogram' => 1,
	'aelocalhistogram' => 1,
	'af-cprioritysel' => 1,
	'af-sprioritysel' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afconfig' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afcsettings' => 1,
	'afdebuginfo' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'affinetransformmat' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfo3' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointinfo' => 1,
	'afpointsinfocus1d' => 1,
	'afsp' => 1,
	'afstatus15' => 1,
	'afstatus19' => 1,
	'afstatus79' => 1,
	'aftune' => 1,
	'aibuildnumber' => 1,
	'aicolormodel' => 1,
	'aicolorusage' => 1,
	'aicreatorversion' => 1,
	'aifileformat' => 1,
	'aimetadata' => 1,
	'ainumlayers' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'airfieldbarometricpressure' => 1,
	'airfieldelevation' => 1,
	'airspeed' => 1,
	'airtemperature' => 1,
	'airulerunits' => 1,
	'aitargetresolution' => 1,
	'album2' => 1,
	'albumartistsortorder' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitlesortorder' => 1,
	'aliaslayermetadata' => 1,
	'alignment' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphamask' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alternatealtitude' => 1,
	'alternateduotonecolors' => 1,
	'alternateellipsoidheight' => 1,
	'alternateellipsoidheightextended' => 1,
	'alternateheading' => 1,
	'alternatelatitude' => 1,
	'alternatelongitude' => 1,
	'alternatename' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'altitudefromtakeoff' => 1,
	'ambienceinfo' => 1,
	'ambisonicchannelmap' => 1,
	'ambisonicchannelordering' => 1,
	'ambisonicchannels' => 1,
	'ambisonicnormalization' => 1,
	'ambisonicorder' => 1,
	'ambisonictype' => 1,
	'amendlocalset' => 1,
	'angleaxis' => 1,
	'angleofattack' => 1,
	'angularvelocity' => 1,
	'anim' => 1,
	'animation' => 1,
	'animationcontrol' => 1,
	'animationframes' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'animationplays' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anoiselines' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'appledataoffsets' => 1,
	'applemaildatereceived' => 1,
	'applemaildatesent' => 1,
	'applemailflagged' => 1,
	'applemailisremoteattachment' => 1,
	'applemailmessageid' => 1,
	'applemailpriority' => 1,
	'applemailread' => 1,
	'applemailrepliedto' => 1,
	'application' => 1,
	'application_riff' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationunknown' => 1,
	'applicationversion' => 1,
	'applysettingstoliveview' => 1,
	'appname' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'arcoreaccel' => 1,
	'arcorecustom' => 1,
	'arcoregyro' => 1,
	'arcorevideo' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artists' => 1,
	'artisturl' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'asin' => 1,
	'asin2' => 1,
	'aspectinfo' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantdirector' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'associateddatalist' => 1,
	'associatedimagefile' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'ast' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'atob3' => 1,
	'atom0' => 1,
	'atsccontent' => 1,
	'attachments' => 1,
	'attitude' => 1,
	'attitudetarget' => 1,
	'attr' => 1,
	'attributes' => 1,
	'audible_cvrx' => 1,
	'audible_meta' => 1,
	'audible_meta2' => 1,
	'audible_tags' => 1,
	'audible_tseg' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobytes' => 1,
	'audiochannellayout' => 1,
	'audiochanneltypes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosetting' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoridentifier' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorname' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'autoareaafstartingpoint' => 1,
	'autocaptureoffset' => 1,
	'autoisomin' => 1,
	'autolowlightduration' => 1,
	'automationanimation' => 1,
	'automationflags' => 1,
	'autorotation' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'auxiliaryimageref' => 1,
	'auxiliaryimagetype' => 1,
	'av1configuration' => 1,
	'av1configurationversion' => 1,
	'avcconfiguration' => 1,
	'averagebitrate' => 1,
	'averageframerate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbdebuginfo' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'axml' => 1,
	'b1' => 1,
	'b2' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barcodes' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'basename' => 1,
	'baseviewpointnum' => 1,
	'basicfileinfo' => 1,
	'basisobject' => 1,
	'battery' => 1,
	'batterycapacity' => 1,
	'batterycurrent' => 1,
	'batteryinfo' => 1,
	'batterystatus' => 1,
	'batterytime' => 1,
	'batteryvoltage3' => 1,
	'batteryvoltage4' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats' => 1,
	'beats-per-minute' => 1,
	'beautycolorlevel' => 1,
	'beautyretouchlevel' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'bibligraphicfilename' => 1,
	'bikebroaccel' => 1,
	'bikebrogps' => 1,
	'billinginformation' => 1,
	'binarydata' => 1,
	'binarydatatype' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'binning' => 1,
	'birthday' => 1,
	'bitdepthchroma' => 1,
	'bitdepthluma' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackadcountsperdacvolt' => 1,
	'blackclamp' => 1,
	'blackclampoffset' => 1,
	'blackcolsleft' => 1,
	'blackcolsright' => 1,
	'blackdacchannel' => 1,
	'blackdacsettlingmsec' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blackrowsbottom' => 1,
	'blackrowstop' => 1,
	'blacktarget' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blueadjust' => 1,
	'blueendpoint' => 1,
	'bluegain' => 1,
	'bluegrassscale1' => 1,
	'bluegrassscale2' => 1,
	'bluegrasstable' => 1,
	'bluemask' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'blurstrength' => 1,
	'bmpversion' => 1,
	'boardtemperature' => 1,
	'body' => 1,
	'bokehshape' => 1,
	'bookname' => 1,
	'booktitle' => 1,
	'booktype' => 1,
	'bookversion' => 1,
	'bootidentifier' => 1,
	'bootrecord' => 1,
	'bootsystem' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottomdarkrow1' => 1,
	'bottomdarkrow2' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bpm' => 1,
	'bps' => 1,
	'bracketingburstoptions' => 1,
	'bracketingcounter' => 1,
	'bracketingmode' => 1,
	'bracketingoffset' => 1,
	'bracketingstep' => 1,
	'bracketshot' => 1,
	'brain' => 1,
	'brandingimageid' => 1,
	'brandingname' => 1,
	'brdfatob0' => 1,
	'brdfatob1' => 1,
	'brdfatob2' => 1,
	'brdfatob3' => 1,
	'brdfbtoa0' => 1,
	'brdfbtoa1' => 1,
	'brdfbtoa2' => 1,
	'brdfbtoa3' => 1,
	'brdfbtod0' => 1,
	'brdfbtod1' => 1,
	'brdfbtod2' => 1,
	'brdfbtod3' => 1,
	'brdfcolorimetricparam0' => 1,
	'brdfcolorimetricparam1' => 1,
	'brdfcolorimetricparam2' => 1,
	'brdfcolorimetricparam3' => 1,
	'brdfdtob0' => 1,
	'brdfdtob1' => 1,
	'brdfdtob2' => 1,
	'brdfdtob3' => 1,
	'brdfmtob0' => 1,
	'brdfmtob1' => 1,
	'brdfmtob2' => 1,
	'brdfmtob3' => 1,
	'brdfmtos0' => 1,
	'brdfmtos1' => 1,
	'brdfmtos2' => 1,
	'brdfmtos3' => 1,
	'brdfspectralparam0' => 1,
	'brdfspectralparam1' => 1,
	'brdfspectralparam2' => 1,
	'brdfspectralparam3' => 1,
	'breakchar' => 1,
	'brightdefectintegrationms' => 1,
	'brightdefectisocode' => 1,
	'brightdefectthreshold' => 1,
	'brightnessdata' => 1,
	'brightrowstop' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'brotliexif' => 1,
	'brotlijumb' => 1,
	'brotlixmp' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btoa3' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwf_umid' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'byteordermark' => 1,
	'bytes' => 1,
	'bytesperline' => 1,
	'bytesperminute' => 1,
	'c2pasalthash' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'calibrationlog' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'callsign' => 1,
	'camcore' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameraifd' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfo3' => 1,
	'camerainfoa100' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraoperator' => 1,
	'camerapan' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'cameratemperaturemaxclip' => 1,
	'cameratemperaturemaxsaturated' => 1,
	'cameratemperaturemaxwarn' => 1,
	'cameratemperatureminclip' => 1,
	'cameratemperatureminsaturated' => 1,
	'cameratemperatureminwarn' => 1,
	'cameratilt' => 1,
	'camm0' => 1,
	'camm1' => 1,
	'camm2' => 1,
	'camm3' => 1,
	'camm4' => 1,
	'camm5' => 1,
	'camm6' => 1,
	'camm7' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1200d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo700d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo750d' => 1,
	'canoncamerainfo760d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfo80d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncctp' => 1,
	'canoncnop' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureheightresetblacksegnormal' => 1,
	'captureheightresetblacksegtest' => 1,
	'captureheighttest' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturewidthresetblacksegnormal' => 1,
	'capturewidthresetblacksegtest' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'car' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'catalognumber' => 1,
	'caveats' => 1,
	'cbordata' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdetype' => 1,
	'cdi1' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfagreenthreshold1' => 1,
	'cfagreenthreshold2' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channel0lagkernel' => 1,
	'channel1coordinates' => 1,
	'channel1flags' => 1,
	'channel1label' => 1,
	'channel1lagkernel' => 1,
	'channel2coordinates' => 1,
	'channel2flags' => 1,
	'channel2label' => 1,
	'channel2lagkernel' => 1,
	'channel3coordinates' => 1,
	'channel3flags' => 1,
	'channel3label' => 1,
	'channel3lagkernel' => 1,
	'channel4coordinates' => 1,
	'channel4flags' => 1,
	'channel4label' => 1,
	'channel5coordinates' => 1,
	'channel5flags' => 1,
	'channel5label' => 1,
	'channel6coordinates' => 1,
	'channel6flags' => 1,
	'channel6label' => 1,
	'channel7coordinates' => 1,
	'channel7flags' => 1,
	'channel7label' => 1,
	'channel8coordinates' => 1,
	'channel8flags' => 1,
	'channel8label' => 1,
	'channelcoarsegainadjust' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'channelusage' => 1,
	'chapter' => 1,
	'chaptercount' => 1,
	'chapterlisttrackid' => 1,
	'chaptername' => 1,
	'chapternum' => 1,
	'chapternumber' => 1,
	'character' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'chartcontourinterval' => 1,
	'chartcorrdate' => 1,
	'chartcountryorigin' => 1,
	'chartdepthunits' => 1,
	'chartformat' => 1,
	'chartmagvar' => 1,
	'chartmagvarannchange' => 1,
	'chartmagvaryear' => 1,
	'chartrasteredition' => 1,
	'chartsoundingdatum' => 1,
	'chartsource' => 1,
	'chartsourcedate' => 1,
	'chartsourceedition' => 1,
	'chartwgsnsshift' => 1,
	'checkedby' => 1,
	'checksum' => 1,
	'children' => 1,
	'chmversion' => 1,
	'choregrapher' => 1,
	'chromaformat' => 1,
	'chromasampleposition' => 1,
	'chromaticaberrationparams' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chunkcount' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'churchillnav' => 1,
	'cicodepoints' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classificationandmarkingsystem' => 1,
	'classificationcomments' => 1,
	'classificationreason' => 1,
	'classifiedby' => 1,
	'classifyingcountry' => 1,
	'classifyingcountrycodemethod' => 1,
	'classifyingcountrycodingmethoddate' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippinglimit' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cmddialsaperturesetting' => 1,
	'cmddialschangemainsub' => 1,
	'cmddialschangemainsubexposure' => 1,
	'cmddialsmenuandplayback' => 1,
	'cmddialsreverserotexposurecomp' => 1,
	'cmmflags' => 1,
	'cmp1' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantinfoout' => 1,
	'colorantorder' => 1,
	'colorantorderout' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown02' => 1,
	'colorbalanceunknown04' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalib2' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcoefs2' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata10' => 1,
	'colordata11' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordata8' => 1,
	'colordata9' => 1,
	'colordataunknown' => 1,
	'colorencodingparams' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetricspecification' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorpopstrength' => 1,
	'colorprimaries' => 1,
	'colorprofiles' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspacename' => 1,
	'colorspecification' => 1,
	'colortable' => 1,
	'colortemperatures' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'columncount' => 1,
	'columngainfactors' => 1,
	'columnresetoffsets' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentby' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'componenttable' => 1,
	'composernationality' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositeimaginglocalset' => 1,
	'compositinglayerheader' => 1,
	'compositionlocation' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'constantframerate' => 1,
	'constraintindicatorflags' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentdescribes' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributorduration' => 1,
	'contentdistributortype' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentlanguage' => 1,
	'contentlightlevel' => 1,
	'contentprotected' => 1,
	'contentprotectedpercent' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentstatus' => 1,
	'contentstyletype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'controller' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'coproducer' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'coringtablebest' => 1,
	'coringtablebetter' => 1,
	'coringtablegood' => 1,
	'cornerlatitude1' => 1,
	'cornerlatitude2' => 1,
	'cornerlatitude3' => 1,
	'cornerlatitude4' => 1,
	'cornerlongitude1' => 1,
	'cornerlongitude2' => 1,
	'cornerlongitude3' => 1,
	'cornerlongitude4' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverartmimetype' => 1,
	'coverarttype' => 1,
	'coyotesense' => 1,
	'coyotestatus' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'cr2cfapattern' => 1,
	'crc' => 1,
	'crcdevelparams' => 1,
	'crd' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorapp' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatoratom' => 1,
	'creatorbuildnumber' => 1,
	'creatorbuildnumber2' => 1,
	'creatorinfo' => 1,
	'creatormajorversion' => 1,
	'creatorminorversion' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'crgbtoerimm0spline' => 1,
	'crgbtoerimm1spline' => 1,
	'crgbtoerimm2spline' => 1,
	'crgbtoerimm3spline' => 1,
	'crgbtoerimm4spline' => 1,
	'crgbtoerimm5spline' => 1,
	'crgbtoerimm6spline' => 1,
	'crgbtoerimm7spline' => 1,
	'crgbtoerimm8spline' => 1,
	'crgbtoerimm9spline' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossbarenable' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs0' => 1,
	'cs1' => 1,
	'ctmd' => 1,
	'cubemapproj' => 1,
	'cuepoint' => 1,
	'cuepointlabel' => 1,
	'cuepointnote' => 1,
	'cuepoints' => 1,
	'cuesheet' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd4' => 1,
	'customsettingsd40' => 1,
	'customsettingsd4s' => 1,
	'customsettingsd5' => 1,
	'customsettingsd500' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd610' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd90' => 1,
	'customsettingsoffset' => 1,
	'customsettingsz8' => 1,
	'customsettingsz9' => 1,
	'customsettingsz9v4' => 1,
	'customtostandardpcc' => 1,
	'cxf' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'd2' => 1,
	'daccountspervolt' => 1,
	'dacgainscoarse' => 1,
	'dacgainscoarseadjpreif41' => 1,
	'dacgainsfine' => 1,
	'dacvoltages' => 1,
	'dacvoltagesflush' => 1,
	'darkcorrectiontype' => 1,
	'darkmapscale' => 1,
	'darkrefoffsetnormal' => 1,
	'darkrefoffsettest' => 1,
	'darkthreshold' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'databasename' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datapreparer' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datasize64' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateencoded' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datepurchased' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetagged' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'datewritten' => 1,
	'daymat0' => 1,
	'daymat1' => 1,
	'daymat2' => 1,
	'daymat3' => 1,
	'daymat4' => 1,
	'daymat5' => 1,
	'daymat6' => 1,
	'daymat7' => 1,
	'daymat8' => 1,
	'daymat9' => 1,
	'db' => 1,
	'dblcoldcacthres1' => 1,
	'dblcoldcacthres2' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dcs3xxprocessinginfo' => 1,
	'dcs3xxprocessinginfoifd' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'declassificationdate' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultcmyk' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defectconcealartcorrectthres' => 1,
	'defectconcealthrestable' => 1,
	'defectcount' => 1,
	'defectlist' => 1,
	'defectlistpacked' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'delaycols' => 1,
	'delaytime' => 1,
	'delimiter' => 1,
	'delta12to8spline' => 1,
	'delta8to12spline' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'densityaltitude' => 1,
	'densityaltitudeextended' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'depthhwheight' => 1,
	'depthhwwidth' => 1,
	'depthmapdata' => 1,
	'depthmapdata2' => 1,
	'depthmapheight' => 1,
	'depthmapname' => 1,
	'depthmaptiff' => 1,
	'depthmapwidth' => 1,
	'depthswheight' => 1,
	'depthswwidth' => 1,
	'derivedimageref' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detectedfacebounds' => 1,
	'detectedfaceid' => 1,
	'detectedfacerollangle' => 1,
	'detectedfaceyawangle' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicecontainer' => 1,
	'deviceid' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'deviceorientation' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dialect' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'dictionaryshortname' => 1,
	'differentialpressure' => 1,
	'difftilegains24t852822' => 1,
	'difftilegains602832' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalexposurebiases' => 1,
	'digitalexposuregains' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directionalatob0' => 1,
	'directionalatob1' => 1,
	'directionalatob2' => 1,
	'directionalatob3' => 1,
	'directionalbtoa0' => 1,
	'directionalbtoa1' => 1,
	'directionalbtoa2' => 1,
	'directionalbtoa3' => 1,
	'directionalbtod0' => 1,
	'directionalbtod1' => 1,
	'directionalbtod2' => 1,
	'directionalbtod3' => 1,
	'directionaldtob0' => 1,
	'directionaldtob1' => 1,
	'directionaldtob2' => 1,
	'directionaldtob3' => 1,
	'directorofphotography' => 1,
	'directors' => 1,
	'disableflagspresent' => 1,
	'discardobjects' => 1,
	'displayartist' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distance' => 1,
	'distancefromhome' => 1,
	'distortinfo' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'dji-dbg' => 1,
	'dji_dtat' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'dloinfo' => 1,
	'dmeroderadius' => 1,
	'dmfillrejthresh' => 1,
	'dmnoisescale' => 1,
	'dmnumpatches' => 1,
	'dmpixelthresholdfactor' => 1,
	'dmsmoothrejthresh' => 1,
	'dmtrimfraction' => 1,
	'dmwindowthresholdfactor' => 1,
	'docclass' => 1,
	'docflags' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'docversion' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dop' => 1,
	'dotrange' => 1,
	'dotsperinch' => 1,
	'downsampleby2hor' => 1,
	'downsampleby2hor3mpdcr' => 1,
	'downsampleby2ver' => 1,
	'downsampleby2ver3mpdcr' => 1,
	'downsampleby3hor' => 1,
	'downsampleby3ver' => 1,
	'downsampleby4hor' => 1,
	'downsampleby4ver' => 1,
	'downsampleby6hor' => 1,
	'downsampleby6ver' => 1,
	'dpxfilesize' => 1,
	'dr4' => 1,
	'dr4header' => 1,
	'driveserialnumber' => 1,
	'drivesettings' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_e-bookbaseid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmcommerceid' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'drmserverid' => 1,
	'drone-dji' => 1,
	'dronepitch' => 1,
	'dronequaternion' => 1,
	'droneroll' => 1,
	'droneyaw' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'dtvcontent' => 1,
	'dualcameraimage' => 1,
	'dualcameraimagename' => 1,
	'dualshotextra' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'dummycolsleft' => 1,
	'dummycolsright' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustdeleteapplied' => 1,
	'dustinfo' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'dynamicranger128' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'edgespline' => 1,
	'edgesplinehigh' => 1,
	'edgesplinelow' => 1,
	'edgesplinemed' => 1,
	'edit4data' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectstrength' => 1,
	'effectsvisible' => 1,
	'effecttype' => 1,
	'eighteenpercentpoint' => 1,
	'eighthlanguage' => 1,
	'electricalextendermagnification' => 1,
	'electronicimagestabilization' => 1,
	'electronicvr' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedaudiofilename' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimage2' => 1,
	'embeddedimageclass' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagename' => 1,
	'embeddedimagerectangle' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'embeddedjpg' => 1,
	'embeddedpng' => 1,
	'embeddedvideo' => 1,
	'embeddedvideofile' => 1,
	'embeddedvideotype' => 1,
	'emphasis' => 1,
	'empty' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encoderoptions' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encodetime' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encrypt' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endianness' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'equirectangularproj' => 1,
	'erimmnonlinearityspline' => 1,
	'erimmtocrgb0spline' => 1,
	'erimmtocrgb1spline' => 1,
	'erimmtocrgb2spline' => 1,
	'erimmtocrgb3spline' => 1,
	'erimmtocrgb4spline' => 1,
	'erimmtocrgb5spline' => 1,
	'erimmtocrgb6spline' => 1,
	'erimmtocrgb7spline' => 1,
	'erimmtocrgb8spline' => 1,
	'erimmtocrgb9spline' => 1,
	'erimmtonescale0spline' => 1,
	'erimmtonescale1spline' => 1,
	'erimmtonescale2spline' => 1,
	'erimmtonescale3spline' => 1,
	'erimmtonescale4spline' => 1,
	'erimmtonescale5spline' => 1,
	'erimmtonescale6spline' => 1,
	'erimmtonescale7spline' => 1,
	'erimmtonescale8spline' => 1,
	'erimmtonescale9spline' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escapestatus' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'et' => 1,
	'evalstate' => 1,
	'eventlogcapture' => 1,
	'eventlogprocess' => 1,
	'events' => 1,
	'eventstarttime' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exififd' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinfo7' => 1,
	'exifinfo8' => 1,
	'exifinfo9' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expirationspan' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureheadroomfactor' => 1,
	'exposureinfo' => 1,
	'exposurereferencegain' => 1,
	'exposurereferenceoffset' => 1,
	'exposuretimes' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedalbumname' => 1,
	'extendedartistname' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedtracktitle' => 1,
	'extendedxmp' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'extraticklocations' => 1,
	'f-stop' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetected' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'faceitem' => 1,
	'facenumbers' => 1,
	'facepos' => 1,
	'facerec' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'factorywhitegainsdaylight' => 1,
	'factorywhiteoffsetsdaylight' => 1,
	'farklewhitethreshold' => 1,
	'fastseek' => 1,
	'fax' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fdsc' => 1,
	'fedexedr' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'fileblockcount' => 1,
	'fileblocksize' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'filedeviceid' => 1,
	'filedevicenumber' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'fileguid' => 1,
	'filehardlinks' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'fileinodenumber' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepath' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'filetypeextension' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterparametersbinary' => 1,
	'filterparameterscustomcustomdata' => 1,
	'filterparametersexportexportdata' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'finalflushsequence' => 1,
	'finalframeblocks' => 1,
	'finetune' => 1,
	'finishedfileprocessingrequest' => 1,
	'finishipaversion' => 1,
	'finishipfversion' => 1,
	'firmwareinfo' => 1,
	'firmwareversion51' => 1,
	'firstchar' => 1,
	'firstflushsequence' => 1,
	'firstlanguage' => 1,
	'firstlines' => 1,
	'firstlinetransfertiming' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashattributes' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfo0106' => 1,
	'flashinfo0107' => 1,
	'flashinfo0300' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashmat0' => 1,
	'flashmat1' => 1,
	'flashmat2' => 1,
	'flashmat3' => 1,
	'flashmat4' => 1,
	'flashmat5' => 1,
	'flashmat6' => 1,
	'flashmat7' => 1,
	'flashmat8' => 1,
	'flashmat9' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashused' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flightdegree' => 1,
	'flightspeed' => 1,
	'flipstatus' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'flirdata' => 1,
	'fluormat0' => 1,
	'fluormat1' => 1,
	'fluormat2' => 1,
	'fluormat3' => 1,
	'fluormat4' => 1,
	'fluormat5' => 1,
	'fluormat6' => 1,
	'fluormat7' => 1,
	'fluormat8' => 1,
	'fluormat9' => 1,
	'flushtiming' => 1,
	'flyingstate' => 1,
	'focalinfo' => 1,
	'focallength35efl' => 1,
	'focallength35mm' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusdistance2' => 1,
	'focusedgemap' => 1,
	'focusframesize' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspointbrightness' => 1,
	'focuspointselectionspeed' => 1,
	'focuspos' => 1,
	'focussettings' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'follow-meanimation' => 1,
	'follow-memode' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fonttable' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fovcot' => 1,
	'fpfversion' => 1,
	'fps' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'framebaseview' => 1,
	'framecenterelevation' => 1,
	'framecenterheightaboveellipsoid' => 1,
	'framecenterlatitude' => 1,
	'framecenterlongitude' => 1,
	'frameexposuretime' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'frameview' => 1,
	'framinggriddisplay' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fuelremaining' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullangleofattack' => 1,
	'fullname' => 1,
	'fullpitchangle' => 1,
	'fullrollangle' => 1,
	'fullscreen' => 1,
	'fullsideslipangle' => 1,
	'fusion360fly' => 1,
	'fusionmode' => 1,
	'fusionypr' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gainmapimage' => 1,
	'gammablue' => 1,
	'gammagreen' => 1,
	'gammainfo' => 1,
	'gammared' => 1,
	'gammatable' => 1,
	'gamut' => 1,
	'gamutboundarydescription0' => 1,
	'gamutboundarydescription1' => 1,
	'gamutboundarydescription2' => 1,
	'gamutboundarydescription3' => 1,
	'gapless' => 1,
	'garmingps' => 1,
	'gaudio' => 1,
	'gaussianweights' => 1,
	'gcamera' => 1,
	'gcreations' => 1,
	'gdepth' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generallevelidc' => 1,
	'generalprofileidc' => 1,
	'generalprofilespace' => 1,
	'generaltierflag' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genericflagdata01' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genprofilecompatibilityflags' => 1,
	'genr' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geometricdistortionparams' => 1,
	'georegistrationlocalset' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gfocus' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gimage' => 1,
	'gimbaldegree' => 1,
	'gimbalpitch' => 1,
	'gimbalroll' => 1,
	'gimbalyaw' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'gopro' => 1,
	'goprogpmf' => 1,
	'gpano' => 1,
	'gpmd_fmas' => 1,
	'gpmd_gopro' => 1,
	'gpmd_kingslim' => 1,
	'gpmd_rove' => 1,
	'gps' => 1,
	'gps360fly' => 1,
	'gpsaltituderaw' => 1,
	'gpsdatalist' => 1,
	'gpsdatalist2' => 1,
	'gpsdatetimeraw' => 1,
	'gpsdestaltitude' => 1,
	'gpsframingaltitude' => 1,
	'gpsframinglatitude' => 1,
	'gpsframinglongitude' => 1,
	'gpshorizontalaccuracy' => 1,
	'gpsinfo' => 1,
	'gpslatituderaw' => 1,
	'gpslog' => 1,
	'gpslongituderaw' => 1,
	'gpsmode' => 1,
	'gpspos' => 1,
	'gpsraw' => 1,
	'gpsspeed3d' => 1,
	'gpsspeedaccuracy' => 1,
	'gpsspeedraw' => 1,
	'gpsspeedx' => 1,
	'gpsspeedy' => 1,
	'gpsspeedz' => 1,
	'gpstargetaltitude' => 1,
	'gpstargetlatitude' => 1,
	'gpstargetlongitude' => 1,
	'gpstrackraw' => 1,
	'gpsvalid' => 1,
	'gpsvelocitydown' => 1,
	'gpsvelocityeast' => 1,
	'gpsvelocitynorth' => 1,
	'gpsvelocityup' => 1,
	'gpsverticalaccuracy' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greenendpoint' => 1,
	'greengain' => 1,
	'greenmask' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'groundrange' => 1,
	'groupareac1' => 1,
	'groupcaption' => 1,
	'groupmutualexclusion' => 1,
	'groups' => 1,
	'gsensor' => 1,
	'gspherical' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'guano' => 1,
	'gyro360fly' => 1,
	'gyromode' => 1,
	'gyroscope' => 1,
	'gyroscopeunknown' => 1,
	'gyroypr' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hardpostpadding' => 1,
	'hardprepadding' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasrealmergeddata' => 1,
	'hasscript' => 1,
	'hasselbladexif' => 1,
	'hasselbladrawimage' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdcontent' => 1,
	'hdmibitdepth' => 1,
	'hdmiexternalrecorder' => 1,
	'hdmioutputhdr' => 1,
	'hdmioutputrange' => 1,
	'hdrgm' => 1,
	'hdrinfo' => 1,
	'hdrinfo2' => 1,
	'hdrinfoversion' => 1,
	'hdrl' => 1,
	'hdrtoninginfo' => 1,
	'header' => 1,
	'header4' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hevcconfiguration' => 1,
	'hevcconfigurationversion' => 1,
	'hiddenslides' => 1,
	'highbitdepth' => 1,
	'highisomode' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'highnote' => 1,
	'highvelocity' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'histogram' => 1,
	'historybuffersize' => 1,
	'hmaphandling' => 1,
	'hmcolrejthresh' => 1,
	'hmcolthresh' => 1,
	'hmpixthresh' => 1,
	'hmwsize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalfieldofview' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hostsoftwareexportversion' => 1,
	'hotkey' => 1,
	'hotspotx' => 1,
	'hotspoty' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'hrnoiselines' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huawei' => 1,
	'huffmantable' => 1,
	'huffmantablelength' => 1,
	'huffmantablevalue' => 1,
	'hyperfocaldistance' => 1,
	'hyperlapsdebuginfo' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'iad1' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'icingdetected' => 1,
	'icondir' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idlesequence' => 1,
	'idletiming' => 1,
	'idsbasevalue' => 1,
	'idstring' => 1,
	'ifd0' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illuminantdetectordata' => 1,
	'illuminantdetecttable' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagecompressiontable' => 1,
	'imagecoordinatesystem' => 1,
	'imagedatadiscard' => 1,
	'imagedatahash' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imageexpansiontable' => 1,
	'imagefields' => 1,
	'imagefilecharacteristics' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imagefullheight' => 1,
	'imagefullwidth' => 1,
	'imageheader' => 1,
	'imageheightinches' => 1,
	'imagehorizonpixelpack' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagelimitexposurebias' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imagemodulationexposurebias' => 1,
	'imageoffset' => 1,
	'imagepixeldepth' => 1,
	'imagepixelformat' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imagereferencepoints' => 1,
	'imageresources' => 1,
	'imagerinitialtimingcode' => 1,
	'imagerlogicprogram' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagertimingdata' => 1,
	'imagesensorgain' => 1,
	'imagesourceek' => 1,
	'imagespatialextent' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imagewidthinches' => 1,
	'imageworkstationmake' => 1,
	'imagingdata' => 1,
	'imdb' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'imprint' => 1,
	'inbandratingattributes' => 1,
	'inbandratinglevel' => 1,
	'inbandratingsystem' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolortablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'indicatedairspeed' => 1,
	'indications' => 1,
	'infirayfactory' => 1,
	'infirayisothermal' => 1,
	'infiraymixmode' => 1,
	'infirayopmode' => 1,
	'infiraypicture' => 1,
	'infiraysensor' => 1,
	'infirayversion' => 1,
	'info' => 1,
	'ingrreserved' => 1,
	'initialdelaysamples' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'inputheight' => 1,
	'inputorientation' => 1,
	'inputuniformity' => 1,
	'inputwidth' => 1,
	'insertmode' => 1,
	'insetnwpixelx' => 1,
	'insetnwpixely' => 1,
	'insta360' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'instruments' => 1,
	'insv' => 1,
	'integratetiming' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpolationcoefficients' => 1,
	'interpolationcoefficients3mp' => 1,
	'interpolationcoefficients6mp' => 1,
	'interpretedby' => 1,
	'intervaloffset' => 1,
	'inversemonitormatrix' => 1,
	'inverserimnonlinearity' => 1,
	'inversesbalog12transform' => 1,
	'inversesbalogtransform' => 1,
	'invnifnonlinearity' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isartbokeh' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isoautooffset' => 1,
	'isocalibrationgaintable' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isospeeds' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrc' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemdesignatorid' => 1,
	'itemid' => 1,
	'iteminfoentry' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemproperties' => 1,
	'itempropertyassociation' => 1,
	'itempropertycontainer' => 1,
	'itemprotection' => 1,
	'itemreference' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesmediatype' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'ixml' => 1,
	'jbigoptions' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg-likedata' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpegimagelength' => 1,
	'jpeginfo' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtablebest' => 1,
	'jpegqtablebetter' => 1,
	'jpegqtablegood' => 1,
	'jpegqtables' => 1,
	'jpegqualityestimate' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jpgfromraw2' => 1,
	'jpginfooffset' => 1,
	'jplcartoifd' => 1,
	'jps' => 1,
	'jpscomment' => 1,
	'jpsflags' => 1,
	'jpslayout' => 1,
	'jpsseparation' => 1,
	'jpstype' => 1,
	'jsondata' => 1,
	'jsonmetadata' => 1,
	'jumbf' => 1,
	'jumbfbox' => 1,
	'jumbfdescr' => 1,
	'jumdid' => 1,
	'jumdlabel' => 1,
	'jumdsignature' => 1,
	'jumdtoggles' => 1,
	'jumdtype' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'jxlcodestream' => 1,
	'k1' => 1,
	'k2' => 1,
	'k3' => 1,
	'k4' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'keepexposurewithteleconverter' => 1,
	'keepuntil' => 1,
	'kelvinwb' => 1,
	'kenwooddata' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'kf' => 1,
	'kf8coveruri' => 1,
	'khufui0thresholds' => 1,
	'khufui1thresholds' => 1,
	'khufui2thresholds' => 1,
	'khufui3thresholds' => 1,
	'khufui4thresholds' => 1,
	'khufui5thresholds' => 1,
	'khufulinearbluemixingcoefficient' => 1,
	'khufulineargreenmixingcoefficient' => 1,
	'khufulinearredmixingcoefficient' => 1,
	'khufusigmagaussianweights' => 1,
	'khufusigmascalingfactors14mp' => 1,
	'khufusigmascalingfactors3mp' => 1,
	'khufusigmascalingfactors6mp' => 1,
	'khufuuspacec2mixingcoefficient' => 1,
	'kids' => 1,
	'kilocalories' => 1,
	'kinds' => 1,
	'kj' => 1,
	'kk' => 1,
	'klut' => 1,
	'klut12tolin12' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodak_frea' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodakmake' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'labelcode' => 1,
	'labeledtext' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'laserprfcode' => 1,
	'lastauthor' => 1,
	'lastbackupdate' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lastsavedby' => 1,
	'lasttimestamp' => 1,
	'lastupdate' => 1,
	'lastupdatetime' => 1,
	'lawrating' => 1,
	'layerblendmodes' => 1,
	'layercolors' => 1,
	'layercomps' => 1,
	'layercount' => 1,
	'layergroupsenabledid' => 1,
	'layerids' => 1,
	'layermodifydates' => 1,
	'layernames' => 1,
	'layeropacities' => 1,
	'layerrectangles' => 1,
	'layers' => 1,
	'layersections' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layerunicodenames' => 1,
	'layervisible' => 1,
	'layout' => 1,
	'layoutflags' => 1,
	'lccn' => 1,
	'lcdedgemapslope' => 1,
	'lcdedgemapx1' => 1,
	'lcdedgemapx2' => 1,
	'lcdedgemapx3' => 1,
	'lcdedgemapx4' => 1,
	'lcdedgespline' => 1,
	'lcdgammatable' => 1,
	'lcdgammatablechickfix' => 1,
	'lcdgammatablemarvin' => 1,
	'lcdhistlut0' => 1,
	'lcdhistlut1' => 1,
	'lcdhistlut2' => 1,
	'lcdhistlut3' => 1,
	'lcdhistlut4' => 1,
	'lcdhistlut5' => 1,
	'lcdhistlut6' => 1,
	'lcdhistlut7' => 1,
	'lcdhistlut8' => 1,
	'lcdhistlut9' => 1,
	'lcdlinearclipvalue' => 1,
	'lcdsharpeningf1' => 1,
	'lcdsharpeningf2' => 1,
	'lcdsharpeningf3' => 1,
	'lcdsharpeningf4' => 1,
	'lcdstepyvalues' => 1,
	'lcdstepyvalueschickfix' => 1,
	'lcdstepyvaluesmarvin' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkcol1' => 1,
	'leftdarkcol2' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'leftmargin' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensattached' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdata0402' => 1,
	'lensdata0403' => 1,
	'lensdata0800' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensfacing' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lensnumber' => 1,
	'lenspartnumber' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'lenstableindex' => 1,
	'levelinfo' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'limage' => 1,
	'limitaf-areamodeselautoanimals' => 1,
	'limitaf-areamodeselautopeople' => 1,
	'limitaf-areamodeseldynamic' => 1,
	'limitaf-areamodeselwidelanimals' => 1,
	'limitaf-areamodeselwidelpeople' => 1,
	'limitafareamodesel3d' => 1,
	'limitafareamodeseld105' => 1,
	'limitafareamodeseld25' => 1,
	'limitafareamodeseld49' => 1,
	'limitafareamodeseld9' => 1,
	'limitafareamodeselgroup' => 1,
	'limitafareamodeselgroupc1' => 1,
	'limitafareamodeselgroupc2' => 1,
	'limitreleasemodeselmirror-up' => 1,
	'limitreleasemodeselq' => 1,
	'limitreleasemodeseltimer' => 1,
	'limitselectableimagearea5to4' => 1,
	'lin12toklut12' => 1,
	'lin12toklut8' => 1,
	'linearitysplinetags' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'linecount' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkedprofilename' => 1,
	'linkerversion' => 1,
	'linkgoodput' => 1,
	'linkinfo' => 1,
	'linkquality' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'linlogtable' => 1,
	'listtype' => 1,
	'lit' => 1,
	'livephotoinfo' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'localpositionned' => 1,
	'locationinfo' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'loginfo' => 1,
	'loglintable' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmat0' => 1,
	'lookmat1' => 1,
	'lookmat2' => 1,
	'lookmat3' => 1,
	'lookmat4' => 1,
	'lookmat5' => 1,
	'lookmat6' => 1,
	'lookmat7' => 1,
	'lookmat8' => 1,
	'lookmat9' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'lotus' => 1,
	'lowlightaf' => 1,
	'lownote' => 1,
	'lowvelocity' => 1,
	'lr' => 1,
	'lslv' => 1,
	'lucasjunk' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'mag360fly' => 1,
	'magmode' => 1,
	'magneticfield' => 1,
	'magneticheading' => 1,
	'magnetometer' => 1,
	'magnetometerxyz' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotepentax5c' => 1,
	'makernotes' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'mapscale' => 1,
	'mariahthresholds' => 1,
	'mariahthresholdslow' => 1,
	'mariahthresholdsnormal' => 1,
	'mariahthresholdsstrong' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'marl' => 1,
	'masksubarea' => 1,
	'masteredby' => 1,
	'mastergainadjustment' => 1,
	'matrixcoefficients' => 1,
	'matrixworldtocamera' => 1,
	'matrixworldtoscreen' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxcontentlightlevel' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumshutterangle' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxpicaveragelightlevel' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mccdata' => 1,
	'mcdi' => 1,
	'md5signature' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mditemaccounthandles' => 1,
	'mditemaccountidentifier' => 1,
	'mditemacquisitionmake' => 1,
	'mditemacquisitionmodel' => 1,
	'mditemaltitude' => 1,
	'mditemaperture' => 1,
	'mditemaudiobitrate' => 1,
	'mditemaudiochannelcount' => 1,
	'mditemauthoremailaddresses' => 1,
	'mditemauthors' => 1,
	'mditembitspersample' => 1,
	'mditembundleidentifier' => 1,
	'mditemcity' => 1,
	'mditemcodecs' => 1,
	'mditemcolorspace' => 1,
	'mditemcomment' => 1,
	'mditemcontentcreationdate' => 1,
	'mditemcontentcreationdate_ranking' => 1,
	'mditemcontentcreationdateranking' => 1,
	'mditemcontentmodificationdate' => 1,
	'mditemcontenttype' => 1,
	'mditemcontenttypetree' => 1,
	'mditemcontributors' => 1,
	'mditemcopyright' => 1,
	'mditemcountry' => 1,
	'mditemcreator' => 1,
	'mditemdateadded' => 1,
	'mditemdateadded_ranking' => 1,
	'mditemdescription' => 1,
	'mditemdisplayname' => 1,
	'mditemdownloadeddate' => 1,
	'mditemdurationseconds' => 1,
	'mditememailconversationid' => 1,
	'mditemencodingapplications' => 1,
	'mditemexifgpsversion' => 1,
	'mditemexifversion' => 1,
	'mditemexposuremode' => 1,
	'mditemexposureprogram' => 1,
	'mditemexposuretimeseconds' => 1,
	'mditemflashonoff' => 1,
	'mditemfnumber' => 1,
	'mditemfocallength' => 1,
	'mditemfscontentchangedate' => 1,
	'mditemfscreatorcode' => 1,
	'mditemfsfinderflags' => 1,
	'mditemfshascustomicon' => 1,
	'mditemfsinvisible' => 1,
	'mditemfsisextensionhidden' => 1,
	'mditemfsisstationery' => 1,
	'mditemfsname' => 1,
	'mditemfsnodecount' => 1,
	'mditemfsownergroupid' => 1,
	'mditemfsowneruserid' => 1,
	'mditemfssize' => 1,
	'mditemfstypecode' => 1,
	'mditemgpsdatestamp' => 1,
	'mditemgpsstatus' => 1,
	'mditemgpstrack' => 1,
	'mditemhasalphachannel' => 1,
	'mditemidentifier' => 1,
	'mditemimagedirection' => 1,
	'mditeminterestingdate_ranking' => 1,
	'mditeminterestingdateranking' => 1,
	'mditemisapplicationmanaged' => 1,
	'mditemisexistingthread' => 1,
	'mditemislikelyjunk' => 1,
	'mditemisospeed' => 1,
	'mditemkeywords' => 1,
	'mditemkind' => 1,
	'mditemlastuseddate' => 1,
	'mditemlastuseddate_ranking' => 1,
	'mditemlatitude' => 1,
	'mditemlensmodel' => 1,
	'mditemlogicalsize' => 1,
	'mditemlongitude' => 1,
	'mditemmailboxes' => 1,
	'mditemmaildatereceived_ranking' => 1,
	'mditemmediatypes' => 1,
	'mditemnumberofpages' => 1,
	'mditemorientation' => 1,
	'mditemoriginapplicationidentifier' => 1,
	'mditemoriginmessageid' => 1,
	'mditemoriginsenderdisplayname' => 1,
	'mditemoriginsenderhandle' => 1,
	'mditemoriginsubject' => 1,
	'mditempageheight' => 1,
	'mditempagewidth' => 1,
	'mditemphysicalsize' => 1,
	'mditempixelcount' => 1,
	'mditempixelheight' => 1,
	'mditempixelwidth' => 1,
	'mditemprimaryrecipientemailaddresses' => 1,
	'mditemprofilename' => 1,
	'mditemrecipients' => 1,
	'mditemredeyeonoff' => 1,
	'mditemresolutionheightdpi' => 1,
	'mditemresolutionwidthdpi' => 1,
	'mditemsecuritymethod' => 1,
	'mditemspeed' => 1,
	'mditemstateorprovince' => 1,
	'mditemstreamable' => 1,
	'mditemsubject' => 1,
	'mditemtimestamp' => 1,
	'mditemtitle' => 1,
	'mditemtotalbitrate' => 1,
	'mditemusecount' => 1,
	'mditemuseddates' => 1,
	'mditemuserdownloadeddate' => 1,
	'mditemuserdownloadeduserhandle' => 1,
	'mditemusersharedreceiveddate' => 1,
	'mditemusersharedreceivedrecipient' => 1,
	'mditemusersharedreceivedrecipienthandle' => 1,
	'mditemusersharedreceivedsender' => 1,
	'mditemusersharedreceivedsenderhandle' => 1,
	'mditemusersharedreceivedtransport' => 1,
	'mditemversion' => 1,
	'mditemvideobitrate' => 1,
	'mditemwherefroms' => 1,
	'mditemwhitebalance' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measure' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementinputinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'mebx' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediadataoffset' => 1,
	'mediadatasize' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaismovie' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaissport' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediaoriginalchannelsubnumber' => 1,
	'mediaoriginalruntime' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediathumbaspectratiox' => 1,
	'mediathumbaspectratioy' => 1,
	'mediathumbheight' => 1,
	'mediathumbratingattributes' => 1,
	'mediathumbratinglevel' => 1,
	'mediathumbratingsystem' => 1,
	'mediathumbret' => 1,
	'mediathumbstride' => 1,
	'mediathumbtimestamp' => 1,
	'mediathumbwidth' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediauniqueid' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'megapixels' => 1,
	'melodicpolyphony' => 1,
	'menuoffset' => 1,
	'menusettingsoffset' => 1,
	'menusettingsoffsetz7ii' => 1,
	'menusettingsoffsetz8' => 1,
	'menusettingsoffsetz9' => 1,
	'menusettingsoffsetz9v3' => 1,
	'menusettingsoffsetz9v4' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metadatasource' => 1,
	'metadataversion' => 1,
	'metaformat' => 1,
	'metaimagesize' => 1,
	'metarelation' => 1,
	'metasampledesc' => 1,
	'metatype' => 1,
	'metdata' => 1,
	'meter' => 1,
	'meterinfo' => 1,
	'meteringbutton' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'mett' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'midicontrol' => 1,
	'midicontrolversion' => 1,
	'midipitchfraction' => 1,
	'midisong' => 1,
	'midiunitynote' => 1,
	'mie' => 1,
	'miiscoreidentifier' => 1,
	'mileage' => 1,
	'mimeencoding' => 1,
	'mimetype' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minimumflushrows' => 1,
	'minimumversion' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minpacketsize' => 1,
	'minspatialsegmentationidc' => 1,
	'mintransmissiontime' => 1,
	'missionid' => 1,
	'mixedby' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'mobitype' => 1,
	'mobiversion' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationnumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'moiversion' => 1,
	'monomonitormatrix' => 1,
	'monostrength' => 1,
	'monotonescaletable' => 1,
	'monouniquematrix' => 1,
	'montage' => 1,
	'month' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'moresettingsoffset' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviefragment' => 1,
	'moviefragmentheader' => 1,
	'moviefragmentsequence' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'moviehighlightdisplaypattern' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'moviewhitebalancesameasphoto' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'mtoa0' => 1,
	'mtob0' => 1,
	'mtob1' => 1,
	'mtob2' => 1,
	'mtob3' => 1,
	'mtos0' => 1,
	'mtos1' => 1,
	'mtos2' => 1,
	'mtos3' => 1,
	'multiexp' => 1,
	'multiexposure2' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiplexdefaultvalues' => 1,
	'multiplextypearray' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multishoton' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nemoblurkernel' => 1,
	'nemodarklimit' => 1,
	'nemogainfactors' => 1,
	'nemohighlight12limit' => 1,
	'nemotilesize' => 1,
	'nestedsignalstream' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'newlines' => 1,
	'nexttrackid' => 1,
	'nifnonlinearity' => 1,
	'nifnonlinearity12bit' => 1,
	'nifnonlinearity12to16' => 1,
	'nifnonlinearity16bit' => 1,
	'nifnonlinearityext' => 1,
	'nikon' => 1,
	'nikonapp' => 1,
	'nikondata' => 1,
	'nikondatetime' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonnefinfo' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'nine' => 1,
	'nineedits' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'noisereductionkernel' => 1,
	'noisereductionparametershostlow' => 1,
	'noisereductionparametershostnormal' => 1,
	'noisereductionparametershoststrong' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'normallinetransfertiming' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nrwdata' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numberofsamples' => 1,
	'numberofsamples64' => 1,
	'numchanneldescriptions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numsampleloops' => 1,
	'numslices' => 1,
	'numstreams' => 1,
	'numtemporallayers' => 1,
	'objectcountrycodes' => 1,
	'objectcountrycodingmethod' => 1,
	'objectcountrycodingmethoddate' => 1,
	'objectfiletype' => 1,
	'objectflags' => 1,
	'objectid' => 1,
	'objectorientation' => 1,
	'objectsizeannounced' => 1,
	'observationdate' => 1,
	'observationdateend' => 1,
	'observationtime' => 1,
	'observationtimeend' => 1,
	'observer' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offset13' => 1,
	'offsetcornerlatitude1' => 1,
	'offsetcornerlatitude2' => 1,
	'offsetcornerlatitude3' => 1,
	'offsetcornerlatitude4' => 1,
	'offsetcornerlongitude1' => 1,
	'offsetcornerlongitude2' => 1,
	'offsetcornerlongitude3' => 1,
	'offsetcornerlongitude4' => 1,
	'offsetmaphorizontal' => 1,
	'offsetmapvertical' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusdss' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'omenatcapturemode' => 1,
	'omenearlygobcolumns' => 1,
	'omenearlygobrows' => 1,
	'omenearlygobsurface' => 1,
	'omengradientexclusionlimits' => 1,
	'omengradientkernel' => 1,
	'omengradientkerneltaps' => 1,
	'omengradientoffset' => 1,
	'omeninitialcolumns' => 1,
	'omeninitialrows' => 1,
	'omeninitialscaling' => 1,
	'omenmeantostrength' => 1,
	'omenpercenttorationallimitsblue' => 1,
	'omenpercenttorationallimitsgob' => 1,
	'omenpercenttorationallimitsgor' => 1,
	'omenpercenttorationallimitsred' => 1,
	'omenrangeweighting' => 1,
	'omenratioclipfactors' => 1,
	'omenratioexclusionfactors' => 1,
	'omenroicoefficients' => 1,
	'omenroicoordinates' => 1,
	'omensmoothingkernel' => 1,
	'on1_settingsdata' => 1,
	'on1_settingsmetadatacreated' => 1,
	'on1_settingsmetadatamodified' => 1,
	'on1_settingsmetadataname' => 1,
	'on1_settingsmetadatapluginid' => 1,
	'on1_settingsmetadatatimestamp' => 1,
	'on1_settingsmetadatausage' => 1,
	'on1_settingsmetadatavisibletouser' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationalmode' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'opticalvr' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'opus' => 1,
	'opusversion' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'orientationinfo' => 1,
	'orientationoffset' => 1,
	'orientoffset' => 1,
	'original' => 1,
	'originalalbum' => 1,
	'originaldate' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalframerate' => 1,
	'originalimagebroker' => 1,
	'originalmedia' => 1,
	'originalmediatype' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalsoftpostpadding' => 1,
	'originalsoftprepadding' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originalyear' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherdate1' => 1,
	'otherdate2' => 1,
	'otherdate3' => 1,
	'otherfirmware' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'othermeta' => 1,
	'othername' => 1,
	'otheroffset' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherserialnumber' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputdataobjectlist' => 1,
	'outputgain' => 1,
	'outputheight' => 1,
	'outputorientation' => 1,
	'outputresponse' => 1,
	'outputwidth' => 1,
	'overclockcolsright' => 1,
	'overclockrowsbottom' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'palmfiletype' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'parallelismtype' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parameters' => 1,
	'parasites' => 1,
	'parentalratingreason' => 1,
	'parrotautomation' => 1,
	'parrotfollowme' => 1,
	'parrottimestamp' => 1,
	'parrotv1' => 1,
	'parrotv2' => 1,
	'parrotv3' => 1,
	'part' => 1,
	'partialactivecolsleft' => 1,
	'partialactivecolsright' => 1,
	'partialactiverowsbottom' => 1,
	'partialactiverowstop' => 1,
	'partialjxlcodestream' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partoffset' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'pathtablelocation' => 1,
	'pathtablesize' => 1,
	'patternangle' => 1,
	'patterncorrectionfactors' => 1,
	'patterncorrectiongains' => 1,
	'patterncorrectionoffsets' => 1,
	'patterngainconversiontable' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peaklevelr128' => 1,
	'peaklevelsample' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxdata2' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'percussivepolyphony' => 1,
	'perfmode' => 1,
	'performersortorder' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'phone' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoresolution' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pilotingmode' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pitchrollyaw' => 1,
	'pittasoft' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelcorrectiongains' => 1,
	'pixelexposuretime' => 1,
	'pixelformat' => 1,
	'pixelinfo' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'playbackflickdownrating' => 1,
	'playbackflickuprating' => 1,
	'playbackframerate' => 1,
	'playcounter' => 1,
	'playlist' => 1,
	'playlistdelay' => 1,
	'playlistindex' => 1,
	'plus' => 1,
	'pmi' => 1,
	'pobox' => 1,
	'podcastcategory' => 1,
	'podcastdescription' => 1,
	'podcastid' => 1,
	'podcastkeywords' => 1,
	'pointsize' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'portraitmatrix' => 1,
	'portraitoffset' => 1,
	'portraittonescaletable' => 1,
	'poseyawdegrees' => 1,
	'position' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2crd3' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'prefersubselectorcenter' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimage1' => 1,
	'previewimage2' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpdf' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtiff' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'primarye-mail' => 1,
	'primaryfileguid' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'primaryvolume' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printposition' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printscaleinfo' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prioritysettings' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'prm' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingparameters' => 1,
	'processingtime' => 1,
	'processparametersv2' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productioncopyright' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversionnumber' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledataoffset' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profilesequenceinfo' => 1,
	'profilesize' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programid' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projectidcode' => 1,
	'projection' => 1,
	'projectionboundsbottom' => 1,
	'projectionboundsleft' => 1,
	'projectionboundsright' => 1,
	'projectionboundstop' => 1,
	'projectionheader' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'protune' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'ptrh' => 1,
	'publishdate' => 1,
	'publishdatestart' => 1,
	'publisherlimit' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasecurrency' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purchaseitem' => 1,
	'purchaseowner' => 1,
	'purchaseprice' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qtablelarge100pct' => 1,
	'qtablelarge25pct' => 1,
	'qtablelarge50pct' => 1,
	'qtablelarge67pct' => 1,
	'qtablemedium100pct' => 1,
	'qtablemedium25pct' => 1,
	'qtablemedium50pct' => 1,
	'qtablemedium67pct' => 1,
	'qtablesmall100pct' => 1,
	'qtablesmall25pct' => 1,
	'qtablesmall50pct' => 1,
	'qtablesmall67pct' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'quietshuttershootingspeed' => 1,
	'quoting' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rangeimagelocalset' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawburstmoderoll' => 1,
	'rawcfacomponentaverages' => 1,
	'rawcodecversion' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawexposurebias' => 1,
	'rawgsensor' => 1,
	'rawhistogram' => 1,
	'rawimageaspectratio' => 1,
	'rawimagecroppedsize' => 1,
	'rawimagecroptopleft' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawvaluerangemax' => 1,
	'rawvaluerangemin' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readername' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'rearcontropaneldisplay' => 1,
	'recallshootfuncaf-on' => 1,
	'recallshootfuncafareamode' => 1,
	'recallshootfuncaperture' => 1,
	'recallshootfuncexposurecomp' => 1,
	'recallshootfuncexposuremode' => 1,
	'recallshootfuncfocustracking' => 1,
	'recallshootfunciso' => 1,
	'recallshootfuncmeteringmode' => 1,
	'recallshootfuncshutterspeed' => 1,
	'recallshootfuncwhitebalance' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingdates' => 1,
	'recordinglocation' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'records' => 1,
	'recordsv2' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'red1header' => 1,
	'red2header' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redcodeversion' => 1,
	'redendpoint' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmask' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reelnumber' => 1,
	'reeltimecode' => 1,
	'reference' => 1,
	'referencename' => 1,
	'referencetemperature' => 1,
	'reflectedapparenttemperature' => 1,
	'reflectedtemperature' => 1,
	'reflection' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'regionxformtackpoint' => 1,
	'registerreadtiming' => 1,
	'relatedimagefile' => 1,
	'relationship' => 1,
	'relativeexposure' => 1,
	'relativehumidity' => 1,
	'relativelocation' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'releasinginstructions' => 1,
	'rembrandtconsumertonescale' => 1,
	'rembrandtportraittonescale' => 1,
	'rembrandttonescale' => 1,
	'remindertime' => 1,
	'remixedby' => 1,
	'remotefuncbutton' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'rentalexpirationdate' => 1,
	'rentalflag' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaingain' => 1,
	'replaygainpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replaytrackgain' => 1,
	'replaytrackpeak' => 1,
	'replayvolumelevel' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requestid' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'reserved5' => 1,
	'reservedblob2' => 1,
	'reservedblob3' => 1,
	'reservedblob4' => 1,
	'reservedblob5' => 1,
	'reservedblob6' => 1,
	'reservedblob7' => 1,
	'reservedblob8' => 1,
	'reservedblob9' => 1,
	'resolutioninfo' => 1,
	'resourcecount' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'retailprice' => 1,
	'retailpricecurrency' => 1,
	'retouchinfoversion' => 1,
	'review' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'rgbcurves' => 1,
	'rgbtoev0' => 1,
	'rgbtoev1' => 1,
	'rgbtoev2' => 1,
	'rgbtoev3' => 1,
	'rgbtoev4' => 1,
	'rgbtoev5' => 1,
	'rgbtoev6' => 1,
	'rgbtoev7' => 1,
	'rgbtoev8' => 1,
	'rgbtoev9' => 1,
	'rgtable' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohmake' => 1,
	'ricohmodel' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'riffsize64' => 1,
	'rightdarkcol1' => 1,
	'rightdarkcol2' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rimm13toerimm12spline' => 1,
	'rimmtocrgb0spline' => 1,
	'rimmtocrgb1spline' => 1,
	'rimmtocrgb2spline' => 1,
	'rimmtocrgb3spline' => 1,
	'rimmtocrgb4spline' => 1,
	'rimmtocrgb5spline' => 1,
	'rimmtocrgb6spline' => 1,
	'rimmtocrgb7spline' => 1,
	'rimmtocrgb8spline' => 1,
	'rimmtocrgb9spline' => 1,
	'rimnonlinearity' => 1,
	'rimtonifcolortransform' => 1,
	'rimtonifscalefactor' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'rnoiselines' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'rollingshutterskewtime' => 1,
	'root' => 1,
	'rootdirectorycreatedate' => 1,
	'rootnote' => 1,
	'rot360fly' => 1,
	'rotationangle' => 1,
	'rotationinfooffset' => 1,
	'rotationxyz' => 1,
	'rotmode' => 1,
	'roundtripversion' => 1,
	'rowcount' => 1,
	'rowinterleavefactor' => 1,
	'rsrc' => 1,
	'rtmd' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	'rvmi_grev' => 1,
	'rvmi_srev' => 1,
	'rvtlocalset' => 1,
	's2n' => 1,
	'sample' => 1,
	'sampleblacksequence' => 1,
	'sampledatetime' => 1,
	'sampledegradationpriority' => 1,
	'sampleduration' => 1,
	'sampleflag' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'sampleperiod' => 1,
	'sampler' => 1,
	'samplerate2' => 1,
	'samplerdata' => 1,
	'samplerdatalen' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletime' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsung' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungrawbyteorder' => 1,
	'samsungrawpointerslength' => 1,
	'samsungrawpointersoffset' => 1,
	'samsungrawunknown' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'samsungtrailer' => 1,
	'samsunguniqueid' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'sarmotionimagerydata' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'savefocus' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbabluebalancelut' => 1,
	'sbaexposurerecord' => 1,
	'sbagreenbalancelut' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'sbalog12transform' => 1,
	'sbalogtransform' => 1,
	'sbaredbalancelut' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scaledimu' => 1,
	'scaledpressure' => 1,
	'scalefactor' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'scav11cols' => 1,
	'scav12cols' => 1,
	'scav21cols' => 1,
	'scav22cols' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'scenecolorimetryestimates' => 1,
	'scheduleitemid' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screenheight' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenplayby' => 1,
	'screenwidth' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'script' => 1,
	'scriptcommand' => 1,
	'sdc' => 1,
	'sdcc-flp' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'securitylocalmetadataset' => 1,
	'securitysci-shiinformation' => 1,
	'securityversion' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'seektable' => 1,
	'segheight' => 1,
	'segmentlocalset' => 1,
	'segwidth' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'semanticinstanceid' => 1,
	'semanticname' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensitivityvalue' => 1,
	'sensorbottomborder' => 1,
	'sensordata' => 1,
	'sensordefects' => 1,
	'sensorellipsoidheight' => 1,
	'sensorellipsoidheightextended' => 1,
	'sensorfieldofviewname' => 1,
	'sensorid' => 1,
	'sensorinfo' => 1,
	'sensorname' => 1,
	'sensorreadouttime' => 1,
	'sensorrelativeazimuthangle' => 1,
	'sensorrelativeelevationangle' => 1,
	'sensorrelativerollangle' => 1,
	'sensorrightborder' => 1,
	'sensorvelocityeast' => 1,
	'sensorvelocitynorth' => 1,
	'seqlevelidx0' => 1,
	'seqprofile' => 1,
	'seqtier0' => 1,
	'sequenceframenumber' => 1,
	'sequencenumberrandomoffset' => 1,
	'sequenceoffset' => 1,
	'serialinfo' => 1,
	'seriesuid' => 1,
	'serviceid' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'settingsoffset' => 1,
	'seventhlanguage' => 1,
	'sfsboundary' => 1,
	'sglcoldcacthres1' => 1,
	'sglcoldcacthres2' => 1,
	'sglcoldcacthres3' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'sharedwith' => 1,
	'sharpenforthumbnail' => 1,
	'sharpeningon' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shifttiming' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingmenuoffset' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod4' => 1,
	'shotinfod40' => 1,
	'shotinfod4s' => 1,
	'shotinfod500' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod6' => 1,
	'shotinfod610' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod7500' => 1,
	'shotinfod780' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod810' => 1,
	'shotinfod850' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'shotinfoz7ii' => 1,
	'shotinfoz8' => 1,
	'shotinfoz9' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutterangle' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sidelightstrength' => 1,
	'sideslipangle' => 1,
	'sigma' => 1,
	'sigmanoisefiltercaltablev1' => 1,
	'sigmanoisefiltertablev1' => 1,
	'sigmanoisefiltertablev1version' => 1,
	'sigmanoisethreshtablev2' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signatureusagerights' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'singleshotdepthmap' => 1,
	'singleshotdepthmaptiff' => 1,
	'singleshotmeta' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'siunits' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'skipinfo' => 1,
	'slantrange' => 1,
	'slateinformation' => 1,
	'sliceinfo' => 1,
	'slicesgroupname' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'smpteformat' => 1,
	'smpteoffset' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'soctemperature' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwarerelease' => 1,
	'sony' => 1,
	'sony_0x9416' => 1,
	'sonyfnumber2' => 1,
	'sonyrawfiletype' => 1,
	'sonytonecurve' => 1,
	'sortwith' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecreatedate' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialaudio' => 1,
	'spatialaudioversion' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'spectralviewingconditions' => 1,
	'spectralwhitepoint' => 1,
	'speed' => 1,
	'sphericalvideo' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spinstrength' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srawtype' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'stampinfo' => 1,
	'stamptoolcount' => 1,
	'standardtocustompcc' => 1,
	'standbymonitorofftime' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startedgecode' => 1,
	'startofframe' => 1,
	'startreading' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'staticpressure' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereoimage' => 1,
	'stereoscopic3d' => 1,
	'stillimagetime' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchcolumns' => 1,
	'stitchinfo' => 1,
	'stitchrows' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'storageformatdate' => 1,
	'storageformattime' => 1,
	'storagemodel' => 1,
	'storageserialnumber' => 1,
	'storagetype' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streamid' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'structuretype' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdialframeadvance' => 1,
	'subdialframeadvancerating0' => 1,
	'subdialframeadvancerating1' => 1,
	'subdialframeadvancerating2' => 1,
	'subdialframeadvancerating3' => 1,
	'subdialframeadvancerating4' => 1,
	'subdialframeadvancerating5' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitledescription' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surfacemap' => 1,
	'surroundmode' => 1,
	'surroundshotvideo' => 1,
	'surroundshotvideoname' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	'synopsis' => 1,
	'systemtime' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag2010h' => 1,
	'tag2010i' => 1,
	'tag202a' => 1,
	'tag900b' => 1,
	'tag9050a' => 1,
	'tag9050b' => 1,
	'tag9050c' => 1,
	'tag9050d' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9401' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9404a' => 1,
	'tag9404b' => 1,
	'tag9404c' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'tag940e' => 1,
	'tag9416_0000' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'tailnumber' => 1,
	'take' => 1,
	'tamper-proofkeys' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targeterrorestimatece90' => 1,
	'targeterrorestimatele90' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetlocationcovariancematrix' => 1,
	'targetlocationelevation' => 1,
	'targetlocationlatitude' => 1,
	'targetlocationlongitude' => 1,
	'targettrackgateheight' => 1,
	'targettrackgatewidth' => 1,
	'targetwidth' => 1,
	'targetwidthextended' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tattoo' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'telescope' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporalidnested' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'testtransfertiming' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'texttospeech' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'textureformat' => 1,
	'thanksto' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thermalcalibration' => 1,
	'thermaldata' => 1,
	'thermalparams' => 1,
	'thermalparams2' => 1,
	'thermalparams3' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailbpg' => 1,
	'thumbnailclip' => 1,
	'thumbnailcompressiontable' => 1,
	'thumbnailexpansiontable' => 1,
	'thumbnailhash' => 1,
	'thumbnailref' => 1,
	'thumbnailresizeratio' => 1,
	'thumbnailtiff' => 1,
	'thumbnailurl' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimageheight' => 1,
	'tiffmeteringimagewidth' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tilegaindeterminationtable' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeinfo' => 1,
	'timelineinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timestamplist' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'tmdb' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tomtomad' => 1,
	'tomtomhl' => 1,
	'tomtomid' => 1,
	'tomtommetadata' => 1,
	'tomtomvd' => 1,
	'tomtomvi' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonescale0' => 1,
	'tonescale0spline' => 1,
	'tonescale1' => 1,
	'tonescale1spline' => 1,
	'tonescale2' => 1,
	'tonescale2spline' => 1,
	'tonescale3' => 1,
	'tonescale3spline' => 1,
	'tonescale4' => 1,
	'tonescale4spline' => 1,
	'tonescale5' => 1,
	'tonescale5spline' => 1,
	'tonescale6' => 1,
	'tonescale6spline' => 1,
	'tonescale7' => 1,
	'tonescale7spline' => 1,
	'tonescale8' => 1,
	'tonescale8spline' => 1,
	'tonescale9' => 1,
	'tonescale9spline' => 1,
	'tonespaceflow' => 1,
	'tonscaletable' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topdarkrow1' => 1,
	'topdarkrow2' => 1,
	'topmag' => 1,
	'topmargin' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalparts' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'trackaperture' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackduration' => 1,
	'trackerdata' => 1,
	'trackfragment' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transfercharacteristic' => 1,
	'transfercharacteristics' => 1,
	'transferrange' => 1,
	'transfersequence' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentcolor' => 1,
	'transparentindex' => 1,
	'transportstreamid' => 1,
	'trapindicator' => 1,
	'trashcolsright' => 1,
	'trashrowsbottom' => 1,
	'trim' => 1,
	'trueairspeed' => 1,
	'tty-ttdphone' => 1,
	'tungmat0' => 1,
	'tungmat1' => 1,
	'tungmat2' => 1,
	'tungmat3' => 1,
	'tungmat4' => 1,
	'tungmat5' => 1,
	'tungmat6' => 1,
	'tungmat7' => 1,
	'tungmat8' => 1,
	'tungmat9' => 1,
	'tuning' => 1,
	'tvdb' => 1,
	'twelvebit' => 1,
	'tx3g' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'uas_lsversionnumber' => 1,
	'uasdatalink' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'umid' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'uncompressedtextlength' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'uniqueid' => 1,
	'unknown' => 1,
	'unknown00' => 1,
	'unknown01' => 1,
	'unknown02' => 1,
	'unknown03' => 1,
	'unknown_cndb' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknownexif' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unsharpdata' => 1,
	'unshiftednote' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'unusedblackcolsleftin' => 1,
	'unusedblackcolsleftout' => 1,
	'unusedblackcolsrightin' => 1,
	'unusedblackcolsrightout' => 1,
	'unusedblackrowsbottomin' => 1,
	'unusedblackrowsbottomout' => 1,
	'unusedblackrowstopin' => 1,
	'unusedblackrowstopout' => 1,
	'updatedtitle' => 1,
	'ur3' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'usermetadata' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'usertext' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usmparametershigh' => 1,
	'usmparametershost' => 1,
	'usmparametershost3mp' => 1,
	'usmparametershost6mp' => 1,
	'usmparameterslow' => 1,
	'usmparametersmed' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-c2paclaimsignature' => 1,
	'uuid-canon' => 1,
	'uuid-canon2' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-exif_bad' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-signature' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'validate' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vddimdacnominalvalues' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version1' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalaf-onbutton' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalfieldofview' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalspeed' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videofullrangeflag' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoorientation' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotimestamp' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'vignettingcorrunknown1' => 1,
	'vignettingcorrunknown2' => 1,
	'vignettingcorrversion' => 1,
	'vignettingparams' => 1,
	'vintagestrength' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'visualflightruleshud' => 1,
	'vmaphandling' => 1,
	'vmcoldropthresh' => 1,
	'vmcolthresh' => 1,
	'vmnbands' => 1,
	'vmpatchreslimit' => 1,
	'vmpixthresh' => 1,
	'vmtidataset' => 1,
	'vmwsize' => 1,
	'volumeblockcount' => 1,
	'volumeblocksize' => 1,
	'volumecreatedate' => 1,
	'volumeeffectivedate' => 1,
	'volumeexpirationdate' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumelevelr128' => 1,
	'volumemodifydate' => 1,
	'volumename' => 1,
	'volumenormalization' => 1,
	'volumesetdiskcount' => 1,
	'volumesetdisknumber' => 1,
	'volumesetname' => 1,
	'volumesize' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'warpquadrilateral' => 1,
	'watched' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_bluelevelauto' => 1,
	'wb_cfa0_leveldaylight' => 1,
	'wb_cfa1_leveldaylight' => 1,
	'wb_cfa2_leveldaylight' => 1,
	'wb_cfa3_leveldaylight' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsauto' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_grgblevelsauto' => 1,
	'wb_grgblevelscloudy' => 1,
	'wb_grgblevelsdaylight' => 1,
	'wb_grgblevelsdaylightfluor' => 1,
	'wb_grgblevelsdaywhitefluor' => 1,
	'wb_grgblevelslivingroomwarmwhitefluor' => 1,
	'wb_grgblevelstungsten' => 1,
	'wb_grgblevelswarmwhitefluor' => 1,
	'wb_grgblevelswhitefluorescent' => 1,
	'wb_redlevelauto' => 1,
	'wb_rgbcoeffsdaylight' => 1,
	'wb_rgbcoeffsflash' => 1,
	'wb_rgbcoeffsfluorescent' => 1,
	'wb_rgbcoeffstungsten' => 1,
	'wb_rgblevelsasshot' => 1,
	'wb_rgblevelscustom' => 1,
	'wbadjdata' => 1,
	'wbblueasshot' => 1,
	'wbbluecloudy' => 1,
	'wbbluedaylight' => 1,
	'wbblueflash' => 1,
	'wbbluefluorescent' => 1,
	'wbbluetungsten' => 1,
	'wbgreenasshot' => 1,
	'wbgreencloudy' => 1,
	'wbgreendaylight' => 1,
	'wbgreenflash' => 1,
	'wbgreenfluorescent' => 1,
	'wbgreentungsten' => 1,
	'wbinfo' => 1,
	'wbinfo2' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wbredasshot' => 1,
	'wbredcloudy' => 1,
	'wbreddaylight' => 1,
	'wbredflash' => 1,
	'wbredfluorescent' => 1,
	'wbredtungsten' => 1,
	'wbsettings' => 1,
	'wbsettings2' => 1,
	'wcsprofiles' => 1,
	'weaponfired' => 1,
	'weaponload' => 1,
	'webp_flags' => 1,
	'webpage' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancergb' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'wifirssi' => 1,
	'winddirection' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'windspeed' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'word97' => 1,
	'worddocument' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wpgversion' => 1,
	'wrapmodes' => 1,
	'writername' => 1,
	'writers' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xattrapplemaildatereceived' => 1,
	'xattrapplemaildatesent' => 1,
	'xattrapplemailisremoteattachment' => 1,
	'xattrfinderinfo' => 1,
	'xattrlastuseddate' => 1,
	'xattrmditemdownloadeddate' => 1,
	'xattrmditemfindercomment' => 1,
	'xattrmditemwherefroms' => 1,
	'xattrmdlabel' => 1,
	'xattrresourcefork' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xidiri' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmlpackets' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtranslayout' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'ycrcbmatrix' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilecomment' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zisrawversion' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
	'zoomposition' => 1,
	'zoomstrength' => 1,
	'zxif' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'gpslatitude' => 'Image::ExifTool::GPS',
	'gpslongitude' => 'Image::ExifTool::GPS',
	'gpsposition' => 'Image::ExifTool::Exif',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'rotation' => 'Image::ExifTool::QuickTime',
	'subseccreatedate' => 'Image::ExifTool::Exif',
	'subsecdatetimeoriginal' => 'Image::ExifTool::Exif',
	'subsecmodifydate' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
    GROUPS      => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names to lookup corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level structure
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '${strName}'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $fieldInfo = $$strTable{$field};
        my $flatName;
        $flatName = $$fieldInfo{FlatName} if ref $fieldInfo eq 'HASH';
        $flatName or ($flatName = $field) =~ tr/-_a-zA-Z0-9//dc;    # remove illegal characters
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($flatName);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                my $lcFlat = $$newInfo{FlatName} ? lc($$newInfo{FlatName}) : $lcTag;
                AddFields($tagTablePtr, $tagID, $lcFlat, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (sort { $a <=> $b } keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    if ($writeProc) {
                        no strict 'refs';
                        $reload = 1 if &$writeProc();
                    }
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2023, Phil Harvey (philharvey66 at gmail.com)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
