# Frequently Asked Questions

* Table of contents
{:toc}

## Haml

### Why is my markup indented properly in development mode, but not in production?
{#q-indentation-in-production}

To improve performance, Haml defaults to {file:HAML_REFERENCE.md#ugly-option "ugly" mode} in Rails
apps running in production.


### How do I put a punctuation mark after an element, like "`I like <strong>cake</strong>!`"?
{#q-punctuation}

Expressing the structure of a document
and expressing inline formatting are two very different problems.
Haml is mostly designed for structure,
so the best way to deal with formatting is to leave it to other languages
that are designed for it.
You could use Textile:

    %p
      :textile
        I like *cake*!

or Markdown:

    %p
      :markdown
        I like **cake**!

or plain old XHTML:

    %p I like <strong>cake</strong>!

If you're inserting something that's generated by a helper, like a link,
then it's even easier:

    %p== I like #{link_to 'chocolate', 'http://franschocolates.com'}!

### How do I stop Haml from indenting the contents of my `pre` and `textarea` tags?
{#q-preserve}

Because Haml automatically indents the HTML source code,
the contents of whitespace-sensitive tags like `pre` and `textarea`
can get screwed up.
The solution is to replace the newlines inside these tags
with HTML newline entities (`&#x000A;`),
which Haml does using the {Haml::Helpers#preserve} and {Haml::Helpers#find_and_preserve} helpers.

Normally, Haml will do this for you automatically
when you're using a tag that needs it
(this can be customized using the {file:HAML_REFERENCE.md#preserve-option `:preserve`} option.
For example,

    %p
      %textarea= "Foo\nBar"

will be compiled to

    <p>
      <textarea>Foo&#x000A;Bar</textarea>
    </p>

However, if a helper is generating the tag,
Haml can't detect that and so you'll have to call {Haml::Helpers#find_and_preserve} yourself.
You can also use `~`, which is the same as `=`
except that it automatically runs `find_and_preserve` on its input.
For example:

    %p= find_and_preserve "<textarea>Foo\nBar</textarea>"

is the same as

    %p~ "<textarea>Foo\nBar</textarea>"

and renders

    <p><textarea>Foo&#x000A;Bar</textarea></p>

### How do I make my long lines of Ruby code look nicer in my Haml document?
{#q-multiline}

Put them in a helper or your model.

Haml purposefully makes it annoying to put lots of Ruby code into your templates,
because lots of code doesn't belong in the view.
If you take that huge `link_to_remote` call
and move it to a `update_sidebar_link` helper,
it'll make your view both easier to read and more semantic.

If you absolutely must put lots of code in your template,
Haml offers a somewhat awkward multiline-continuation tool.
Put a `|` (pipe character) at the end of each line you want to be merged into one
(including the last line!).
For example:

    %p= @this.is(way.too.much). |
        code("and I should").   |
        really_move.it.into(    |
          :a => @helper)        |

### `form_for` is printing the form tag twice!

Make sure you're calling it with `-`, not `=`.
Just like in ERB, you have to do

    <% form_for stuff do %>
      ...
    <% end %>

in Haml, you have to do

    - form_for stuff do
      ...

### I have Haml installed. Why is Rails (only looking for `.html.erb` files | rendering Haml files as plain text | rendering Haml files as blank pages)?
{#q-blank-page}

There are several reasons these things might be happening.
First of all, make sure `vendor/plugins/haml` really exists
and has an `init.rb` file in there.
Then try restarting Mongrel or WEBrick or whatever you might be using.

Finally, if none of these work,
chances are you've got some localization plugin like Globalize installed.
Such plugins often don't play nicely with Haml.
Luckily, there's usually an easy fix.
For Globalize, just edit `globalize/lib/globalize/rails/action_view.rb`
and change

    @@re_extension = /\.(rjs|rhtml|rxml)$/

to

    @@re_extension = /\.(rjs|rhtml|rxml|erb|builder|haml)$/

For other plugins, a little searching will probably turn up a way to fix them as well.

## Sass

### Can I use a variable from my controller in my Sass file?
{#q-ruby-code}

No. Sass files aren't views.
They're compiled once into static CSS files,
then left along until they're changed and need to be compiled again.
Not only don't you want to be running a full request cycle
every time someone requests a stylesheet,
but it's not a great idea to put much logic in there anyway
due to how browsers handle them.

If you really need some sort of dynamic CSS,
you can define your own {Sass::Script::Functions Sass functions} using Ruby
that can access the database or other configuration.
*Be aware when doing this that Sass files are by default only compiled once
and then served statically.*

If you really, really need to compile Sass on each request,
first make sure you have adequate caching set up.
Then you can use {Sass::Engine} to render the code,
using the {file:SASS_REFERENCE.md#custom-option `:custom` option}
to pass in data that {Sass::Script::Functions::EvaluationContext#options can be accessed}
from your Sass functions.

## You still haven't answered my question!

Sorry! Try looking at the Haml or Sass references,
in the doucmentation for the haml and Sass modules, respectively.
If you can't find an answer there,
feel free to ask in `#haml` on irc.freenode.net
or send an email to the [mailing list](http://groups.google.com/group/haml?hl=en).
