/**
 * GUI Commands
 * Copyright 2004 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: ResetVisitor.java,v 1.5 2005/06/15 23:43:01 pietschy Exp $
 */

package org.pietschy.command;


/**
 * This visitor is used to invoke {@link CommandGroup#reset()} on a group and optionally any child groups.
 *
 * @version $Revision: 1.5 $
 * @author andrewp
 */
public class
ResetVisitor
extends AbstractVisitor
{
   /**
    * Creates a new ResetVisitor that will traverse the group according to the specified mode.
    * @param mode the visit mode either {@link AbstractVisitor#DEEP} or {@link AbstractVisitor#SHALLOW}.
    */
   public ResetVisitor(VisitMode mode)
   {
      super(mode);
   }

   public void
   visit(ActionCommand command)
   {
   }

   public void
   visit(CommandGroup group)
   {
      group.reset();
      conditionallyVisitChildren(group);
   }

}
