/*******************************************************************************************************************************************
 ccheckbutton.h
 
 CClass					CClass
 |--CSerialized				|--CSerialized
    |--CMetaModule			   |--CMetaModule
       |--CObject			      |--CObjectListener
          |--CComponent			         |
	     |--CControl			 |
	        |--CWidget			 |--CWidgetListener
		   |--CContainer		    |
		      |--CButton		    |--CButtonListener
		         |--CToggleButton
			    |--CCheckButton

 Standard check button definition.
*******************************************************************************************************************************************/

#ifndef __CCHECKBUTTON_H__
#define __CCHECKBUTTON_H__

#include "ctogglebutton.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// CCheckButton class
//-----------------------------------------------------------------------------------------------------------------------------------------
class CCheckButton : public CToggleButton
{
	// instanciation section
	public :

		CCheckButton			(CContainer *inOwner=NULL, const CButtonListener *inListener=NULL);
		virtual ~CCheckButton		();

	// protected instanciation process definition
	protected :

		// specific gtk widget instanciation
		virtual GtkWidget *		PerformWidgetInstanciate	();

		// metaclass association
		SECTION_DYNAMIC_METACLASS;
};

// class tag and metaclass declaration
DECLARE_DYNAMIC_METACLASS ('cbtn', CCheckButton, CToggleButton);

#endif
