#!/usr/bin/env ruby
require 'gpgme'

ctx = GPGME::GpgmeCtx.new

passphrase_cb = proc do |h,d,r|
  if d
    STDERR.puts(d)
    begin
      system('stty -echo')
      gets.chomp
    ensure
      system('stty echo')
    end
  end
end
ctx.set_passphrase_cb(passphrase_cb)

begin
  pair = ctx.genkey(<<'EOF')
<GnupgKeyParms format="internal">
Key-Type: DSA
Key-Length: 1024
Subkey-Type: ELG-E
Subkey-Length: 1024
Name-Real: Joe Tester
Name-Comment: with stupid passphrase
Name-Email: joe@foo.bar
Passphrase: abcdabcdfs
Expire-Date: 2010-08-15
</GnupgKeyParms>
EOF
rescue GPGME::GpgmeError => err
  $stderr.puts(err.message)
  exit!
end

puts("Pubkey:\n#{pair[0].read}")
puts("Seckey:\n#{pair[1].read}")
