// MOLDYN.H : molecular dynamics classes.

// Copyright (C) 1998 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#ifndef MOLDYN_H
#define MOLDYN_H

//#include "libghemicalconfig2.h"

class moldyn_param;

class moldyn;
class moldyn_langevin;

class temperature_meter;
class pressure_meter;

/*################################################################################################*/

#include "engine.h"
#include "eng1_sf.h"

/*################################################################################################*/

class moldyn_param
{
	protected:
	
	bool confirm;
	
	friend class model;
	friend class moldyn_dialog;
	
	public:
	
	bool show_dialog;
	
	i32s nsteps_h;		// heat
	i32s nsteps_e;		// equilibration
	i32s nsteps_s;		// simulation
	f64 temperature;
	f64 timestep;
	bool constant_e;
	bool langevin;
	
	char filename[256];
	
	public:
	
	moldyn_param(setup * su)
	{
		confirm = false;
		show_dialog = true;
		
		nsteps_h = 5000;
		nsteps_e = 5000;
		nsteps_s = 10000;
		temperature = 300.0;
		timestep = 0.5;
		constant_e = false;
		langevin = false;
		
		strcpy(filename, "untitled.traj");
		
		setup1_sf * susf = dynamic_cast<setup1_sf *>(su);
		if (susf != NULL) timestep = 5.0;			// override...
	}
	
	~moldyn_param(void) { }
};

/*################################################################################################*/

/**	A molecular dynamics class.
	
	This is a "velocity-Verlet"-type integrator...
	Allen MP, Tildesley DJ : "##Computer Simulation of Liquids", Clarendon Press, 1987
	
	So far very long simulations have not been tested, so possile translation/rotation 
	problems are not solved... current solution is to start simulations from 0 K -> 
	no translation/rotation in the initial state -> conservation of linear and angular 
	momentum -> no need to worry at all... but for how long it will work???
*/

class moldyn
{
	protected:
	
	engine * eng;
	
	f64 * vel;
	f64 * acc;
	
	f64 * mass;
	
	char * locked;
	int num_locked;
	
	f64 tstep1;	// timestep
	f64 tstep2;	// timestep ^ 2
	
	f64 ekin;
	f64 epot;
	
	i32s step_counter;
	
	public:
	
	f64 temperature;
	
	f64 temperature_coupling;
	
	public:
	
	moldyn(engine *, f64);
	virtual ~moldyn(void);
	
	f64 GetEKin(void) { return ekin; }
	f64 GetEPot(void) { return epot; }
	
	virtual void TakeMDStep(bool);
	
	f64 KineticEnergy(void);
	
	f64 ConvTempEKin(f64);
	f64 ConvEKinTemp(f64);
	
	void SetEKin(f64);
};

/*################################################################################################*/

/**	A molecular dynamics class for Langevin dynamics.
	
	This is not any of the well-known LD integrators, just LD stuff added
	on top of a "velocity Verlet" MD integrator.
	
	TODO : convert this is into a "BBK"-type integrator???
*/

class moldyn_langevin : public moldyn
{
	protected:
	
	eng1_sf * engsf;
	
	public:
	
	f64 * langevin_r_forces;
	
	f64 langevin_frict_fc;
	f64 langevin_random_fc;
	
	f64 temperature_coupling;
	f64 langevin_coupling;
	
	f64 * langevin_weight;
	f64 * langevin_frict;
	
	public:
	
	moldyn_langevin(engine *, f64);
	virtual ~moldyn_langevin(void);
	
	void TakeMDStep(bool);		// virtual...
};

/*################################################################################################*/

/**	Estimates pressure in a cubic volume element.
*/

class temperature_meter
{
};

/**	Estimates pressure in a cubic volume element.
*/

class pressure_meter
{
};

/*################################################################################################*/

#endif	// MOLDYN_H

// eof
