// EXAMPLE2.CPP

// Copyright (C) 2004 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "example2.h"

#include "notice.h"

#include "eng1_mm_tripos52.h"
#include "eng1_mm_default.h"

#include "geomopt.h"
#include "moldyn.h"

/*################################################################################################*/

int main(int argc, char ** argv)
{
	print_lib_intro_notice(cout);
	print_copyright_notice(cout);
	cout << endl;
	
	// example #2: open a file, run a geometry optimization, and save a file.
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// check that we have got both file names from the command line.
	
	if (argc != 3)
	{
		cout << "usage : example2 infile.gpr outfile.gpr" << endl;
		exit(1);
	}
	
	char * infile_name = argv[1];
	char * outfile_name = argv[2];
	
	// create a model object, and read in a file.
	
	model * mdl = new model();
	
	cout << "trying to open a file " << infile_name << " ; ";
	
	ifstream ifile;
	ifile.open(infile_name, ios::in);
	
	if (ifile.fail())
	{
		cout << "failed!!!" << endl;
		
		ifile.close();
		delete mdl;
		
		return -1;
	}
	
	cout << "ok!!!" << endl;
	
	ReadGPR(* mdl, ifile, false, false);
	ifile.close();
	
	// if everything went fine, then create a computation engine object, initialize it,
	// and create a geometry optimizer object using the computation engine object.
	
	engine * eng = mdl->GetCurrentSetup()->CreateEngineByIDNumber(ENG1_MM_TRIPOS52);
//	engine * eng = mdl->GetCurrentSetup()->CreateEngineByIDNumber(ENG1_MM_DEFAULT);
	
	CopyCRD(mdl, eng, 0);
	
	geomopt * opt = new geomopt(eng, 100, 0.025, 10.0);
	
	// then take 100 geometry optimization steps, and print out some data about progess.
	
	for (int n1 = 0;n1 < 100;n1++)
	{
		opt->TakeCGStep(conjugate_gradient::Newton2An);
		
		cout << "step = " << (n1 + 1) << "   ";
		cout << "energy = " << opt->optval << "   ";
		cout << "step length = " << opt->optstp << endl;
	}
	
	// now copy the optimized coordinates back to the model object, and save the file.
	
	CopyCRD(eng, mdl, 0);
	
	delete opt; opt = NULL;
	delete eng; eng = NULL;
	
	cout << "now saving file " << outfile_name << endl;
	
	ofstream ofile;
	ofile.open(outfile_name, ios::out);
	
	WriteGPR(* mdl, ofile);
	ofile.close();
	
	// finally release all allocated memory and leave.
	
	delete mdl; mdl = NULL;
	
	return 0;
}

/*################################################################################################*/

// eof
