/* $Id: init.c,v 1.6 2005/09/05 12:46:15 cegger Exp $
******************************************************************************

   Graphics library for GGI.

   Copyright (C) 1999 Andreas Beck	[becka@ggi-project.org]
   Copyright (C) 2004 Peter Ekberg	[peda@lysator.liu.se]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include <stdio.h>

#include "config.h"
#include "pseudostubswmh.h"

static int GGIopen(ggi_visual *vis, struct ggi_dlhandle *dlh,
		   const char *args, void *argptr, uint32_t *dlret)
{
	wmhpriv *priv = LIBGGI_WMHEXT(vis);

	sscanf(args, "%p", &priv->priv);
	if(priv->priv == NULL)
		return GGI_EARGREQ;

	ggiWmhAttach(priv->priv);

	priv->move     = GGIwmh_pseudo_stubs_move;
	priv->resize   = GGIwmh_pseudo_stubs_resize;
	priv->getpos   = GGIwmh_pseudo_stubs_getpos;
	priv->getsize  = GGIwmh_pseudo_stubs_getsize;
	priv->settitle = GGIwmh_pseudo_stubs_settitle;
	priv->maximize = GGIwmh_pseudo_stubs_maximize;
	priv->zorder   = GGIwmh_pseudo_stubs_zorder;
	priv->iconify  = GGIwmh_pseudo_stubs_iconify;
	priv->moveicon = GGIwmh_pseudo_stubs_moveicon;
	priv->seticontitle = GGIwmh_pseudo_stubs_seticontitle;
	priv->allowresize  = GGIwmh_pseudo_stubs_allowresize;

	*dlret = GGI_DL_EXTENSION;
	return 0;
}

static int GGIexit(ggi_visual *vis, struct ggi_dlhandle *dlh)
{
	wmhpriv *priv = LIBGGI_WMHEXT(vis);

	if(priv != NULL && priv->priv != NULL) {
		ggiWmhDetach(priv->priv);
		priv->priv = NULL;
	}
	return 0;
}

EXPORTFUNC
int WMHdl_pseudo_stubs_wmh(int func, void **funcptr);

int WMHdl_pseudo_stubs_wmh(int func, void **funcptr)
{
	switch (func) {
	case GGIFUNC_open:
		*funcptr = GGIopen;
		return 0;
	case GGIFUNC_exit:
		*funcptr = GGIexit;
		return 0;
	case GGIFUNC_close:
		*funcptr = NULL;
		return 0;
	default:
		*funcptr = NULL;
	}

	return GGI_ENOTFOUND;
}

#include <ggi/internal/ggidlinit.h>
