#! /usr/bin/ruby
=begin
  string.rb - Extension for String.

  Copyright (C) 2005  Masao Mutoh
 
  You may redistribute it and/or modify it under the same
  license terms as Ruby.
=end

class String
  alias :_old_format_m :%
    
  def %(args)
    if args.kind_of?(Hash)
      ret = dup
      args.each {|key, value|
        ret.gsub!(/\%\{#{key}\}/, value.to_s)
      }
      ret
    else
      ret = gsub(/%\{/, '%%{')
      ret._old_format_m(args)
    end
  end
end
