#include "cobject.h"
#include "cxml.h"

class CMyObjectListener : public CObjectListener 
{
	public :
		CMyObjectListener ()
		{ }
		virtual ~CMyObjectListener ()
		{ }
	public :
		virtual void OnConstruct (CObject *inSender) 
		{
			printf ("CMyObject::OnConstruct %lx\n", inSender); 
		}
		virtual void OnDestruct (CObject *inSender) 
		{
			printf ("CMyObject::OnDestruct %lx\n", inSender); 
		}
	public :
		SECTION_DYNAMIC_METACLASS;
};
DECLARE_DYNAMIC_METACLASS ('_mbj', CMyObjectListener, CObjectListener);
RESOLVE_DYNAMIC_METACLASS (CMyObjectListener);

class CMyObject : public CObject
{
	public :
		CMyObject (const CMyObjectListener *inListener=NULL) : CObject (inListener)
		{ }
		virtual ~CMyObject ()
		{ }
	public :
		SECTION_DYNAMIC_METACLASS;
};
DECLARE_DYNAMIC_METACLASS ('mobj', CMyObject, CObject);
RESOLVE_DYNAMIC_METACLASS (CMyObject);

int main ()
{
	if (!CFile::Exists (CString("./demo-object.xml")))
        {
                CMyObject obj1 (new CMyObjectListener());
                CMyObject obj2;
                CMyObject obj3 (new CMyObjectListener());

                CXMLDocument XMLDocument (CString("./demo-object.xml"), XML_WRITE, CString("demo"));

                XMLDocument << obj1;
                XMLDocument << obj2;
                XMLDocument << obj3;
        }
        else
        {
                CXMLDocument XMLDocument (CString("./demo-object.xml"), XML_READ, CString("demo"));
                CXMLElementNode *inRoot = XMLDocument.GetRootElement ();

		NServices::TBuffer <CSerialized *> buf;

		for (size_t i=0; i<xml_node_get_children_number(inRoot); i++)
		{
	                CSerialized *szd = CSerialized::Instanciate (::xml_node_get_child (inRoot,i));

			if (szd != NULL)
			{
				printf ("allocated object %lx\n", szd);
				buf += szd;
			}
		}

		for (size_t i=0; i<buf.GetLength(); i++) delete *buf[i];

                delete inRoot;
        }

	return 0;
}
