/**
 * @file monitor.c Monitors Galago for changes.
 *
 * @Copyright (C) 2004-2005 Christian Hammond
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA  02111-1307  USA
 */
#include <glib.h>
#include <libgalago/galago.h>
#include <stdio.h>
#include <string.h>

static void
account_added_cb(GalagoService *service, const char *property,
				 GalagoAccount *account, void *user_data)
{
	printf("Account %s added to service %s\n",
		   galago_account_get_username(account),
		   galago_service_get_id(service));
}

static void
account_removed_cb(GalagoService *service, const char *property,
				   GalagoAccount *account, void *user_data)
{
	printf("Account %s removed from service %s\n",
		   galago_account_get_username(account),
		   galago_service_get_id(service));
}

int
main(int argc, char **argv)
{
	GMainLoop *loop;

	g_type_init();

	loop = g_main_loop_new(NULL, FALSE);

	if (!galago_glib_init("monitor", TRUE, NULL))
	{
		fprintf(stderr, "Unable to initialize Galago and connect "
				"to the server\n");
		exit(1);
	}

	galago_core_set_watch_all(TRUE);

	galago_signal_connect_class(GALAGO_CLASS_SERVICE, "account-added",
								GALAGO_CALLBACK(account_added_cb), NULL);
	galago_signal_connect_class(GALAGO_CLASS_SERVICE, "account-removed",
								GALAGO_CALLBACK(account_removed_cb), NULL);

	g_main_loop_run(loop);

	return 0;
}
