/**
 * @file libgalago/galago-utils.c Utility functions
 *
 * @Copyright (C) 2004-2005 Christian Hammond
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#include <libgalago/galago-utils.h>
#include <libgalago/galago-assert.h>
#include <ctype.h>
#include <string.h>

/**************************************************************************
 * String functions
 **************************************************************************/
char *
galago_str_lower(const char *str)
{
	char *new_str, *c;

	galago_return_val_if_fail(str != NULL, NULL);

	new_str = strdup(str);

	for (c = new_str; *c != '\0'; c++)
		*c = tolower(*c);

	return new_str;
}

char *
galago_str_upper(const char *str)
{
	char *new_str, *c;

	galago_return_val_if_fail(str != NULL, NULL);

	new_str = strdup(str);

	for (c = new_str; *c != '\0'; c++)
		*c = toupper(*c);

	return new_str;
}

/**************************************************************************
 * Memory allocation functions
 **************************************************************************/
void *
galago_malloc0(size_t bytes)
{
	void *ptr;

	galago_return_val_if_fail(bytes > 0, NULL);

	ptr = malloc(bytes);
	memset(ptr, 0, bytes);

	return ptr;
}

void *
galago_memdup(const void *ptr, size_t size)
{
	void *new_mem;

	galago_return_val_if_fail(ptr != NULL, NULL);
	galago_return_val_if_fail(size > 0,    NULL);

	new_mem = malloc(size);
	memcpy(new_mem, ptr, size);

	return new_mem;
}
