/**
 * @file libgalago/galago-image.h Galago Image API
 *
 * @Copyright (C) 2004-2005 Christian Hammond
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _GALAGO_IMAGE_H_
#define _GALAGO_IMAGE_H_

#include <stdlib.h>

typedef struct _GalagoImage        GalagoImage;
typedef struct _GalagoImageClass   GalagoImageClass;
typedef struct _GalagoImagePrivate GalagoImagePrivate;

#include <libgalago/galago-object.h>

/*
 * An abstract representation of an image.
 */
struct _GalagoImage
{
	GalagoObject parent_object;

	GalagoImagePrivate *priv;

	void (*reserved_1)(void);
	void (*reserved_2)(void);
	void (*reserved_3)(void);
	void (*reserved_4)(void);
};

/**
 * GalagoImage's class.
 */
struct _GalagoImageClass
{
	GalagoObjectClass parent_class;

	void (*reserved_1)(void);
	void (*reserved_2)(void);
	void (*reserved_3)(void);
	void (*reserved_4)(void);
};

#define GALAGO_CLASS_IMAGE (galago_image_get_class())

#define GALAGO_IMAGE(obj) \
	GALAGO_OBJECT_CAST((obj), GALAGO_CLASS_IMAGE, GalagoImage)
#define GALAGO_IS_IMAGE(obj) (GALAGO_IS_OBJECT(obj) && galago_object_check_cast((obj), GALAGO_CLASS_IMAGE))

#ifdef __cplusplus
extern "C" {
#endif

/**************************************************************************/
/** @name Image API                                                       */
/**************************************************************************/
/*@{*/

/**
 * Returns the class for a GalagoImage.
 *
 * @return The GalagoImage class.
 */
GalagoObjectClass *galago_image_get_class(void);

/**
 * Sets the image's image data.
 *
 * @param image  The image.
 * @param data   The image data.
 * @param len    The image data length.
 */
void galago_image_set_image_data(GalagoImage *image,
								 const unsigned char *data, size_t len);

/**
 * Returns an image's image data.
 *
 * @param image   The image.
 * @param ret_data The returned image data.
 * @param ret_len  The returned image data length.
 */
void galago_image_get_image_data(const GalagoImage *image,
								 unsigned char **ret_data,
								 size_t *ret_len);

/*@}*/

#ifdef __cplusplus
}
#endif


#endif /* _GALAGO_IMAGE_H_ */
