/**
 * @file libgalago-gtk/galago-gtk-contact-chooser.h
 *       Contact chooser interface
 *
 * @Copyright (C) 2005-2006 Christian Hammond.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _GALAGO_GTK_CONTACT_CHOOSER_H_
#define _GALAGO_GTK_CONTACT_CHOOSER_H_

typedef struct _GalagoGtkContactChooser      GalagoGtkContactChooser;
typedef struct _GalagoGtkContactChooserIface GalagoGtkContactChooserIface;

#include <libgalago/galago.h>
#include <libgalago-gtk/galago-gtk-service-list.h>

#define GALAGO_GTK_TYPE_CONTACT_CHOOSER (galago_gtk_contact_chooser_get_type())
#define GALAGO_GTK_CONTACT_CHOOSER(obj) \
		(G_TYPE_CHECK_INSTANCE_CAST((obj), GALAGO_GTK_TYPE_CONTACT_CHOOSER, GalagoGtkContactChooser))
#define GALAGO_GTK_CONTACT_CHOOSER_IFACE(klass) \
		(G_TYPE_CHECK_CLASS_CAST((klass), GALAGO_GTK_TYPE_CONTACT_CHOOSER, GalagoGtkContactChooserIface))
#define GALAGO_GTK_IS_CONTACT_CHOOSER(obj) \
		(G_TYPE_CHECK_INSTANCE_TYPE((obj), GALAGO_GTK_TYPE_CONTACT_CHOOSER))
#define GALAGO_GTK_CONTACT_CHOOSER_GET_IFACE(obj) \
		(G_TYPE_INSTANCE_GET_INTERFACE ((obj), GALAGO_GTK_TYPE_CONTACT_CHOOSER, GalagoGtkContactChooserIface))

typedef enum
{
	GALAGO_GTK_CONTACT_CHOOSER_SELECT_CONTACTS = 0x01,
	GALAGO_GTK_CONTACT_CHOOSER_SELECT_PEOPLE   = 0x02

} GalagoGtkContactChooserFlags;

struct _GalagoGtkContactChooserIface
{
	GTypeInterface base_iface;

	/* Methods */
	void (*set_service_type)(GalagoGtkContactChooser *chooser,
							 GalagoGtkServiceListItemType type);
	void (*set_service)(GalagoGtkContactChooser *chooser,
						GalagoService *service);
	void (*set_contact)(GalagoGtkContactChooser *chooser,
						GalagoAccount *contact);
	void (*set_person)(GalagoGtkContactChooser *chooser,
					   GalagoPerson *person);
	GalagoAccount *(*get_contact)(const GalagoGtkContactChooser *chooser);
	GalagoPerson *(*get_person)(const GalagoGtkContactChooser *chooser);

	/* Signals */
	void (*selection_changed)(GalagoGtkContactChooser *chooser);
	void (*activated)(GalagoGtkContactChooser *chooser);
};

G_BEGIN_DECLS

GType galago_gtk_contact_chooser_get_type(void);

void galago_gtk_contact_chooser_set_service_type(
	GalagoGtkContactChooser *chooser, GalagoGtkServiceListItemType type);
void galago_gtk_contact_chooser_set_service(GalagoGtkContactChooser *chooser,
											GalagoService *service);
void galago_gtk_contact_chooser_set_contact(GalagoGtkContactChooser *chooser,
											GalagoAccount *contact);
void galago_gtk_contact_chooser_set_person(GalagoGtkContactChooser *chooser,
										   GalagoPerson *person);

GalagoAccount *galago_gtk_contact_chooser_get_contact(
	const GalagoGtkContactChooser *chooser);
GalagoPerson *galago_gtk_contact_chooser_get_person(
	const GalagoGtkContactChooser *chooser);

G_END_DECLS

#endif /* _GALAGO_GTK_CONTACT_CHOOSER_H */
