/*
     This file is part of libextractor.
     (C) 2004 Christian Grothoff (and other contributing authors)

     libextractor is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     libextractor is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with libextractor; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

#include "extractor_util.h"
#include <fcntl.h>
#include <stdarg.h>

/**
 * Open a file
 **/
int OPEN(const char *filename, int oflag, ...)
{
  int mode;
  char *fn;

#ifdef MINGW
  char szFile[_MAX_PATH + 1];
  long lRet;
  
  if ((lRet = conv_to_win_path(filename, szFile)) != ERROR_SUCCESS)
  {
    errno = ENOENT;
    SetLastError(lRet);
    
    return -1;
  }
  fn = szFile;
#else
  fn = (char *) filename;
#endif
  
  if (oflag & O_CREAT)
  {
    va_list arg;
    va_start(arg, oflag);
    mode = va_arg(arg, int);
    va_end(arg);    
  }
  else
  {
    mode = 0;
  }
  
#ifdef MINGW
  /* Set binary mode */
  mode |= O_BINARY;
#endif
  
  return open(fn, oflag, mode);
}

/* end of io.c */
