/*
     This file is part of libextractor.
     (C) 2002, 2003, 2004 Vidyut Samanta and Christian Grothoff

     libextractor is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     libextractor is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with libextractor; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.

 */

#define DEBUG_EXTRACT_ID3v2 0

#include "platform.h"
#include "extractor.h"
#include <string.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdlib.h>
#include <fcntl.h>
#ifndef MINGW
  #include <sys/mman.h>
#endif

static struct EXTRACTOR_Keywords * addKeyword(EXTRACTOR_KeywordList *oldhead, 
					      char *phrase,
					      EXTRACTOR_KeywordType type) {
  EXTRACTOR_KeywordList * keyword;
  
  keyword = (EXTRACTOR_KeywordList*) malloc(sizeof(EXTRACTOR_KeywordList));
  keyword->next = oldhead;    
  keyword->keyword = phrase;
  keyword->keywordType = type;
  return keyword;
}

typedef struct {
  char * text;
  EXTRACTOR_KeywordType type;
} Matches;

static Matches tmap[] = {
  { "TAL", EXTRACTOR_TITLE },
  { "TT1", EXTRACTOR_GROUP },
  { "TT2", EXTRACTOR_TITLE },
  { "TT3", EXTRACTOR_TITLE },
  { "TXT", EXTRACTOR_DESCRIPTION },
  { "TPB", EXTRACTOR_PUBLISHER },
  { "WAF", EXTRACTOR_LOCATION },
  { "WAR", EXTRACTOR_LOCATION },
  { "WAS", EXTRACTOR_LOCATION },
  { "WCP", EXTRACTOR_COPYRIGHT },
  { "WAF", EXTRACTOR_LOCATION },
  { "WCM", EXTRACTOR_DISCLAIMER },
  { "TSS", EXTRACTOR_FORMAT },
  { "TYE", EXTRACTOR_DATE },
  { "TLA", EXTRACTOR_LANGUAGE },
  { "TP1", EXTRACTOR_ARTIST },
  { "TP2", EXTRACTOR_ARTIST },
  { "TP3", EXTRACTOR_CONDUCTOR },
  { "TP4", EXTRACTOR_INTERPRET },
  { "IPL", EXTRACTOR_CONTRIBUTOR },
  { "TOF", EXTRACTOR_FILENAME },
  { "TEN", EXTRACTOR_PRODUCER },
  { "TCO", EXTRACTOR_SUBJECT },
  { "TCR", EXTRACTOR_COPYRIGHT },
  { "SLT", EXTRACTOR_LYRICS },
  { "TOA", EXTRACTOR_ARTIST },
  { "TRC", EXTRACTOR_RESOURCE_IDENTIFIER },
  { "TCM", EXTRACTOR_CREATOR },
  { "TOT", EXTRACTOR_ALBUM },
  { "TOL", EXTRACTOR_AUTHOR },
  { "COM", EXTRACTOR_COMMENT },
  { "", EXTRACTOR_KEYWORDS },
  { NULL, 0},
};


/* mimetype = audio/mpeg */
struct EXTRACTOR_Keywords * libextractor_id3v2_extract(char * filename,
						       unsigned char * data,
						       size_t size,
						       struct EXTRACTOR_Keywords * prev) {
  int unsync;
  unsigned int tsize;
  unsigned int pos;

  if ( (size < 16) ||
       (data[0] != 0x49) ||
       (data[1] != 0x44) ||
       (data[2] != 0x33) ||
       (data[3] != 0x02) ||
       (data[4] != 0x00) )
    return prev;
  unsync = (data[5] & 0x80) > 0;
  tsize = ( ( (data[6] & 0x7F) << 21 ) |
	    ( (data[7] & 0x7F) << 14 ) |
	    ( (data[8] & 0x7F) << 07 ) |
	    ( (data[9] & 0x7F) << 00 ) );
  
  if (tsize + 10 > size)
    return prev;
  pos = 10;
  while (pos < tsize) {
    size_t csize;
    int i;

    if (pos + 6 > tsize)
      return prev;
    csize = (data[pos+3] << 16) + (data[pos+4] << 8) + data[pos+5];
    if ( (pos + 6 + csize > tsize) ||
	 (csize > tsize) ||
	 (csize == 0) )
      break;
    i = 0;
    while (tmap[i].text != NULL) {
      if (0 == strncmp(tmap[i].text,
		       &data[pos],
		       3)) {
	char * word;
	word = malloc(csize+1);
	if (data[pos+6] == '\0') {
	  pos++;
	  csize--;
	}
	memcpy(word,
	       &data[pos+6],
	       csize);
	word[csize] = '\0';
	if (strlen(word) > 0) {
	  prev = addKeyword(prev,
			    word,
			    tmap[i].type);	
	} else {
	  free(word);
	}
	break;
      }
      i++;
    }
    pos += 6 + csize;
  }
  return prev;
}


#define HAVE_MAIN 0
#if HAVE_MAIN
int main (int argc, char **argv) {
  int file;
  char * buffer;
  struct stat fstatbuf;
  size_t size;

  if (argc != 2) {
    fprintf(stderr, 
	    "Call with filename as argument\n");
    return -1;
  }  
  file = OPEN(argv[1], O_RDONLY);
  if (-1 == file) 
    return -1;
  if (-1 == FSTAT(file, &fstatbuf)) {
    close(file);
    return -1;
  }
  size = fstatbuf.st_size;
  buffer = mmap(NULL, size, PROT_READ, MAP_SHARED, file, 0);  
  close(file);

  EXTRACTOR_printKeywords(stdout,
			  libextractor_id3v2_extract(argv[1], 
						     buffer,
						     size,
						     NULL));
  munmap(buffer, size);
  return 0;
}
#endif


/* end of id3v2extractor.c */
