#include <glib.h>
#include "e-cookies.h"

typedef struct _ctest_data {
  const char * type_string;
  const char * cookie_header;
  const char * domain;
  const char * path;
} ctest_data;

ctest_data cookies_list[] = {
  { "Google PREF", "PREF=LD=xx-klingon:NR=10; expires=Sun, 03-Jun-2032 02:35:47 GMT;", ".google.com", "/" },
  { "SF Default", "default_mirror=unc; expires=Sun, 05-Jul-2008 05:43:57 GMT;", "prdownloads.sourceforge.net", "/" },
  { "Google PREF", "PREF=LD=xx-hacker:NR=10; expires=Sun, 03-Jun-2032 15:43:22 GMT;", ".google.com", "/" },
};

gint main (gint argc, gchar * argv[]) {
  ECookies * cookies;
  gchar * header;
  gint i;

  g_type_init ();

  cookies = e_cookies_new ();

  for (i = 0; i < G_N_ELEMENTS (cookies_list); i++) {
    if (e_cookies_add_cookie (cookies, cookies_list[i].cookie_header,
			      cookies_list[i].domain, cookies_list[i].path)) {
      g_print ("%s Passed: %s\n", cookies_list[i].type_string,
	       cookies_list[i].cookie_header);
    } else {
      g_print ("%s Failed: %s\n", cookies_list[i].type_string,
	       cookies_list[i].cookie_header);
    }
  }

  header = e_cookies_find_cookies (cookies, "images.google.com", "/foo.html");
  g_print ("Cookie: %s\n", header);
  g_free (header);

  e_cookies_save_cookies (cookies);
  g_object_unref (G_OBJECT (cookies));
  return 0;
}
