/*
 * Drizzle Client & Protocol Library
 *
 * Copyright (C) 2008 Eric Day (eday@oddments.org)
 * All rights reserved.
 *
 * Use and distribution licensed under the BSD license.  See
 * the COPYING file in this directory for full text.
 */

/**
 * @file
 * @brief drizzle_con_st tests
 */

#include "tests/common.h"

int main(void)
{
  drizzle_st *drizzle;
  drizzle_con_st *con;
  drizzle_con_st con_buffer;
  drizzle_con_st *clone;

  printf("# sizeof(drizzle_con_st) = %zu\n", sizeof(drizzle_con_st));

  if ((drizzle= drizzle_create(NULL)) == NULL)
    DRIZZLE_TEST_ERROR("drizzle_create");

  if ((con= drizzle_con_create(drizzle, &con_buffer)) == NULL)
    DRIZZLE_TEST_ERROR("drizzle_con_create");
  drizzle_con_free(con);

  if ((con= drizzle_con_create(drizzle, NULL)) == NULL)
    DRIZZLE_TEST_ERROR("drizzle_con_create");

  if ((clone= drizzle_con_clone(drizzle, NULL, con)) == NULL)
    DRIZZLE_TEST_ERROR("drizzle_con_clone");
  drizzle_con_free(clone);

  if (drizzle_con_options(con) != DRIZZLE_CON_ALLOCATED)
    DRIZZLE_TEST_ERROR("drizzle_con_options");

  drizzle_con_set_tcp(con, "test", 12345);

  if (strcmp(drizzle_con_host(con), "test"))
    DRIZZLE_TEST_ERROR("drizzle_con_host");

  if (drizzle_con_port(con) != 12345)
    DRIZZLE_TEST_ERROR("drizzle_con_port");

  drizzle_con_free(con);
  drizzle_free(drizzle);

  return 0;
}
