/*
 * Drizzle Client & Protocol Library
 *
 * Copyright (C) 2008 Eric Day (eday@oddments.org)
 * All rights reserved.
 *
 * Use and distribution licensed under the BSD license.  See
 * the COPYING file in this directory for full text.
 */

/**
 * @file
 * @brief drizzle_column_st tests
 */

#include "tests/common.h"

int main(void)
{
  drizzle_st *drizzle;
  drizzle_con_st *con;
  drizzle_result_st *result;
  drizzle_column_st *column;
  drizzle_column_st column_buffer;

  printf("# sizeof(drizzle_column_st) = %zu\n", sizeof(drizzle_column_st));

  if ((drizzle= drizzle_create(NULL)) == NULL)
    DRIZZLE_TEST_ERROR("drizzle_create");

  if ((con= drizzle_con_create(drizzle, NULL)) == NULL)
    DRIZZLE_TEST_ERROR("drizzle_con_create");

  if ((result= drizzle_result_create(con, NULL)) == NULL)
    DRIZZLE_TEST_ERROR("drizzle_result_create");

  if ((column= drizzle_column_create(result, &column_buffer)) == NULL)
    DRIZZLE_TEST_ERROR("drizzle_column_create");
  drizzle_column_free(column);

  if ((column= drizzle_column_create(result, NULL)) == NULL)
    DRIZZLE_TEST_ERROR("drizzle_column_create");

  drizzle_column_set_catalog(column, "simple test");

  if (strcmp(drizzle_column_catalog(column), "simple test"))
    DRIZZLE_TEST_ERROR("drizzle_column_catalog");

  drizzle_column_free(column);
  drizzle_result_free(result);
  drizzle_con_free(con);
  drizzle_free(drizzle);

  return 0;
}
