/*
 * Drizzle Client & Protocol Library
 *
 * Copyright (C) 2008 Eric Day (eday@oddments.org)
 * All rights reserved.
 *
 * Use and distribution licensed under the BSD license.  See
 * the COPYING file in this directory for full text.
 */

/**
 * @file
 * @brief UDS Connection definitions
 */

#include "common.h"

/*
 * Common definitions
 */

const char *drizzle_con_uds(drizzle_con_st *con)
{
  return con->uds_sockaddr.sun_path;
}

void drizzle_con_set_uds(drizzle_con_st *con, const char *uds)
{
  drizzle_con_reset_addrinfo(con);

  if (uds == NULL || uds[0] == 0)
    uds= DRIZZLE_DEFAULT_UDS;

  con->uds_sockaddr.sun_family= AF_UNIX;
  strncpy(con->uds_sockaddr.sun_path, uds, sizeof(con->uds_sockaddr.sun_path));
  con->uds_sockaddr.sun_path[sizeof(con->uds_sockaddr.sun_path) - 1]= 0;
  con->uds_addrinfo.ai_family= AF_UNIX;
  con->uds_addrinfo.ai_socktype= SOCK_STREAM;
  con->uds_addrinfo.ai_protocol= 0;
  con->uds_addrinfo.ai_addrlen= sizeof(struct sockaddr_un);
  con->uds_addrinfo.ai_addr= (struct sockaddr *)&(con->uds_sockaddr);
}

/*
 * Private definitions
 */

bool drizzle_con_uses_uds(drizzle_con_st *con)
{
  return con->uds_addrinfo.ai_addr != NULL;
}

void drizzle_con_clone_uds(drizzle_con_st *con, drizzle_con_st *from)
{
  memcpy(&(con->uds_addrinfo), &(from->uds_addrinfo),
         sizeof(struct addrinfo));
  memcpy(&(con->uds_sockaddr), &(from->uds_sockaddr),
         sizeof(struct sockaddr_un));
  con->uds_addrinfo.ai_addr= (struct sockaddr *)&(con->uds_sockaddr);
}
