/* test-desktop-entry.c generated by valac 0.10.4, the Vala compiler
 * generated from test-desktop-entry.vala, do not modify */

/*
 * Desktop Agnostic Library: Test for the desktop entry implementations.
 *
 * Copyright (C) 2009 Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 * Author : Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <libdesktop-agnostic/vfs.h>
#include <libdesktop-agnostic/fdo.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))



gint _vala_main (char** args, int args_length1);



gint _vala_main (char** args, int args_length1) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	gdk_init (&args_length1, &args);
	{
		desktop_agnostic_vfs_init (&_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		if (args_length1 > 1) {
			gboolean hit_first_arg;
			hit_first_arg = FALSE;
			{
				char** arg_collection;
				int arg_collection_length1;
				int arg_it;
				arg_collection = args;
				arg_collection_length1 = args_length1;
				for (arg_it = 0; arg_it < args_length1; arg_it = arg_it + 1) {
					const char* arg;
					arg = arg_collection[arg_it];
					{
						DesktopAgnosticVFSFile* file;
						DesktopAgnosticFDODesktopEntry* entry;
						char* _tmp0_;
						char* _tmp1_;
						if (!hit_first_arg) {
							hit_first_arg = TRUE;
							continue;
						}
						file = desktop_agnostic_vfs_file_new_for_path (arg, &_inner_error_);
						if (_inner_error_ != NULL) {
							goto __catch0_g_error;
						}
						entry = desktop_agnostic_fdo_desktop_entry_new_for_file (file, &_inner_error_);
						if (_inner_error_ != NULL) {
							_g_object_unref0 (file);
							goto __catch0_g_error;
						}
						g_message ("test-desktop-entry.vala:45: Entry: %s", _tmp0_ = desktop_agnostic_fdo_desktop_entry_get_name (entry));
						_g_free0 (_tmp0_);
						g_message ("test-desktop-entry.vala:46: Entry exec line: %s", _tmp1_ = desktop_agnostic_fdo_desktop_entry_get_string (entry, "Exec"));
						_g_free0 (_tmp1_);
						if (desktop_agnostic_fdo_desktop_entry_exists (entry)) {
							desktop_agnostic_fdo_desktop_entry_launch (entry, 0, NULL, &_inner_error_);
							if (_inner_error_ != NULL) {
								_g_object_unref0 (entry);
								_g_object_unref0 (file);
								goto __catch0_g_error;
							}
						} else {
							g_critical ("test-desktop-entry.vala:53: Entry does not exist.");
						}
						_g_object_unref0 (entry);
						_g_object_unref0 (file);
					}
				}
			}
		} else {
			DesktopAgnosticFDODesktopEntry* entry;
			DesktopAgnosticVFSFile* file;
			DesktopAgnosticFDODesktopEntry* _tmp2_;
			DesktopAgnosticFDODesktopEntry* _tmp3_;
			DesktopAgnosticVFSFile* _tmp4_;
			DesktopAgnosticVFSFile* _tmp5_;
			DesktopAgnosticFDODesktopEntry* _tmp6_;
			entry = NULL;
			file = NULL;
			_tmp2_ = desktop_agnostic_fdo_desktop_entry_new (&_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (file);
				_g_object_unref0 (entry);
				goto __catch0_g_error;
			}
			entry = (_tmp3_ = _tmp2_, _g_object_unref0 (entry), _tmp3_);
			desktop_agnostic_fdo_desktop_entry_set_name (entry, "hosts file");
			desktop_agnostic_fdo_desktop_entry_set_entry_type (entry, DESKTOP_AGNOSTIC_FDO_DESKTOP_ENTRY_TYPE_LINK);
			desktop_agnostic_fdo_desktop_entry_set_string (entry, "URL", "file:///etc/hosts");
			_tmp4_ = desktop_agnostic_vfs_file_new_for_path ("/tmp/desktop-agnostic-test.desktop", &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (file);
				_g_object_unref0 (entry);
				goto __catch0_g_error;
			}
			file = (_tmp5_ = _tmp4_, _g_object_unref0 (file), _tmp5_);
			desktop_agnostic_fdo_desktop_entry_save (entry, file, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (file);
				_g_object_unref0 (entry);
				goto __catch0_g_error;
			}
			entry = (_tmp6_ = NULL, _g_object_unref0 (entry), _tmp6_);
			_g_object_unref0 (file);
			_g_object_unref0 (entry);
		}
		desktop_agnostic_vfs_shutdown (&_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("test-desktop-entry.vala:74: Error: %s", err->message);
			_g_error_free0 (err);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}




