package com.tildemh.debbug;


/**
 * Type for bug listings. 
 *
 * <p>This is released under the terms of the GNU Lesser General Public License
 * (LGPL). See the COPYING file for details.
 *
 * @version $Id: ListingType.java,v 1.14 2004/01/17 10:46:48 mh Exp $
 * @author &copy; Mark Howard &lt;mh@debian.org&gt; 2002
 */
public class ListingType implements java.io.Serializable{

	private int value;		// integer representation
	private String info;	// prefix used by the bts cgi scripts.
	private String title;
	private boolean includeClosed = false;


	/** 
	 * Creates a new listing type. Note that this only works for basic types
	 * acceptable by the bts - other types must subclass this and override the
	 * makeURL method.
	 */
	private ListingType(int value, String info, String title){
		this.value = value;
		this.info = info;
		this.title = title;
	}

	public ListingType(int value, String info, String title, boolean includeClosed){
		this.value = value;
		this.info = info;
		this.title = title;
		this.includeClosed = includeClosed;
	}

	public static ListingType BINARY 	= new ListingType(0, "pkg=", "Binary");
	public static ListingType SOURCE 	= new ListingType(1, "src=", "Source");
	public static ListingType MAINT 	= new ListingType(2, "maint=", "Maintainer");
	public static ListingType SUBMITTER = new ListingType(3, "submitter=", "Submitter");
	public static ListingType BUG 		= new ListingType(4, "", "Bug");
	public static ListingType PSEUDO 	= new ListingType(5, "pkg=", "Pseudo");
	public static ListingType VIRTUAL 	= new ListingType(6, "", "Virtual");

	public String getTitle(){
		return title;
	}


	public boolean getIncludeClosed(){
		return includeClosed;
	}

	public void setIncludeClosed( boolean includeClosed ){
		this.includeClosed = includeClosed;
	}

	/**
	 * Constructs a url for a web page containing the authorative reference of
	 * the listing.
	 * <p>This method should be overridden for special types/
	 */
	public String makeURL( String name ){
		String url = null;
		try{
		url = "http://master.debian.org/~mh/machine-interface/machpkg.cgi?"
			+ (includeClosed ? "" : "pend-exc=done") 
			+ "&"+ info + java.net.URLEncoder.encode(name, "UTF-8") 
			+ "&show=lastmod&show=bug";
		}catch(Exception e){
			throw new RuntimeException(e.toString());
			// TODO
		}
		return url;
	}	

	/**
	 * @return true if two listing types are the same
	 */
	public boolean equals ( ListingType test ){
		return this.value == test.getValue();
	}
	
	/** 
	 * @return internal representation of listing type
	 */
	public int getValue(){
		return value;
	}

	public String getInfo(){
		return info;
	}

	public String toString(){
		return title + (includeClosed ? ",all ,":",open,") + info;
	}
}
