package com.tildemh.debbug;


/**
 * Debian Bug Tracking System interaction. This class is used to obtain bug
 * reports and listings. Methods will take simple package name or bug number
 * inputs and this class will determine whether to download the reports, or use
 * the versions in cache.
 *
 * <p>todo: get bugs/listings in background using a separate thread. 
 * 
 * <p>This is released under the terms of the GNU Lesser General Public License
 * (LGPL). See the COPYING file for details.
 *
 * @version $Id: BTS.java,v 1.33 2004/01/21 20:04:00 mh Exp $
 * @author &copy; Mark Howard &lt;mh@debian.org&gt; 2002
 */
public class BTS{

	private Cache cache;
	private static BTS instance = null;
	private static final boolean DEBUG = false;

	/**
	 * Creates a new BTS Object
	 */
	private BTS(){
		cache = Cache.getInstance();
	}
	public static BTS getInstance(){
		if (null == instance) instance = new BTS();
		return instance;
	}

	/**
	 * Returns a bug report, or a new report with no content (in which case
	 * bug.update() should be called).
	 */
	public Bug getBug( Integer bugNumber ){
		int number = bugNumber.intValue();
		Bug bug = null;
		try{ 
			bug = cache.getBug(number, true);
		}catch(CacheMiss e){
			if (DEBUG) System.out.println("DEBUG: cache miss "+number+"\n"+e);
		}catch(CacheError e){
			if (DEBUG) System.out.println("DEBUG: cache error "+number+"\n"+e);
		}
		if (bug == null){
			if (DEBUG) System.out.println("BTS.getBug() - making new bug");
			bug = Bug.makeBug( bugNumber );
		}

//		cache.store(bug); // store the bug for later.
		return bug;
	}

	/**
	 * Returns a bug report
	 * @param number The bug to be returned
	 * @param checkServer if true, the server will be checked for a newer
	 * version of the report than exists in cache.
	 * @param needComments If true, the bug will be returned including all its
	 * comments. If false, then it may just contain header information. 
	 * 
	 * @throws BugNotFound if the bug was not found on the webserver
	 * @throws ServerError if there was a problem connecting with the server
	 */
//	public Bug getBug(int number, boolean checkServer, boolean needComments) throws BugNotFound, ServerError{
//		Bug bug = null;
//		// first check the cache
//		try{
//			if ( !checkServer){  // we're done
///				bug = cache.getBug(number, needComments);
//				if (DEBUG)  System.out.println(System.currentTimeMillis() + " returning report from cache");
//				return bug;
//			}else{
//				// must get comments as we're going to do a checkmodified which
//				// writes the bug report back.
//				bug = cache.getBug(number, true);
//			}
//		}catch(CacheMiss e){
//			if (DEBUG) System.out.println("DEBUG: cache miss "+number+"\n"+e);
//		}catch(CacheError e){
//			if (DEBUG) System.out.println("DEBUG: cache error "+number+"\n"+e);
//		}
//		
//
//		try{
//			// see if it's been updated
//			if (bug != null && WWWBugParser.checkModified( bug) == false){
//				if (DEBUG) System.out.println("DEBUG: Returning cached report - already latest version");
//				return bug;
//			}
		
			// either we don't have it, or we have an old copy of it. Download.
//			bug = WWWBugParser.downloadBug(Integer.toString(number), bug);			
//		}catch( BugNotFound e){
//			throw new BugNotFound( "#" + number );
//		}catch(MalformedURLException e){
//			throw new ServerError(e + "");
//		}catch(IOException e){
//			throw new ServerError(e + "");
//		}

//		if ( bug == null ) throw new InternalError( " Bug is NULL!!! ");
		
//		try{
//			cache.store(bug); // store the bug for later.
//		}catch(CacheError e){
//			e.printStackTrace();
//			if (DEBUG) System.out.println("ERROR: Cache store failed: "+e);
//		}
//		return bug;
//	}

	/**
	 * Returns a bug listing. 
	 * @param type The type of the listing to retrieve
	 * @param name The full name of the listing, excluding prefix
	 * @param forceDownload Forces the system to download the report, ignoring
	 * cache entry.
	 * @param getBugs If true, a process will be started to download all
	 * (non-archived) bug reports for this package.
	 * @throws PackageNotFound if the package was not found
	 */
//	public Listing getListing( ListingType type,  String name, boolean forceDownload) throws ListingNotFound, ServerError{
//		boolean dlList = true; 		// The list  must be downloaded
//		Listing list = null;
//		if (!forceDownload || type.equals( ListingType.VIRTUAL ) )
//			try{
//				list = cache.getListing(type, name);
//				dlList = false;
//			}catch(CacheMiss e){
//				if (DEBUG) System.out.println("DEBUG: cache miss "+name+"\n"+e);
///				dlList = true;
//			}catch(CacheError e){
//				if (DEBUG) System.out.println("DEBUG: cache error "+name+"\n"+e);
//				dlList = true;
//			}
//		if (type.equals(ListingType.VIRTUAL) && dlList)
//			throw new ListingNotFound("Virtual package "+name+" not found");
//		if (forceDownload) dlList = true;
//		
//		// todo - more options for when to use cache. Mostly implemented by
//		// other methods.
//		if (dlList){
//			try{
///				list = WWWListingParser.downloadListing( name, type );
//			}catch(MalformedURLException e){
//				throw new ServerError("Malformed URL Exception: "+e);
//			}catch(IOException e){
//				throw new ServerError("IOException: "+e);
//			}
	
//			try{
//				cache.store(list); // store the bug for later.
//			}catch(CacheError e){
//				e.printStackTrace();
//				if (DEBUG) System.err.println("Cache error while storing list: "+e);
//			}
//		}
//		return list;
//	}
    /**
	 * Returns a listing, possibly an empty one;
	 */
	public Listing getListing( ListingType type, String name ){
		if (DEBUG) System.out.println("BTS.getListing()"+type+name);
		return getListing( new ListingStub(type,name) );
	}
	public Listing getListingIfCached( ListingStub stub ){		
		Listing list = null;
		ListingType type = stub.getType();
		String name = stub.getName();
		try{ 
			if (DEBUG) System.out.println("1");
			list = cache.getListing( stub );
			if (DEBUG) System.out.println("1");
		}catch(CacheMiss e){
			e.printStackTrace();
			list = null;
		}catch(CacheError e){
			e.printStackTrace();
			// TODO: handle better
			list = null;
		}
		return list;
	}
	public Listing getListing( ListingStub stub ){
		Listing list = getListingIfCached( stub );
		if (list == null){
			list = Listing.makeListing( stub );
			cache.store( list );
		}
		return list;
	}

}
