/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 51 "parse.y"

#include "sqliteInt.h"
#include "parse.h"

/*
** An instance of this structure holds information about the
** LIMIT clause of a SELECT statement.
*/
struct LimitVal {
  Expr *pLimit;    /* The LIMIT expression.  NULL if there is no limit */
  Expr *pOffset;   /* The OFFSET expression.  NULL if there is none */
};

/*
** An instance of this structure is used to store the LIKE,
** GLOB, NOT LIKE, and NOT GLOB operators.
*/
struct LikeOp {
  Token operator;  /* "like" or "glob" or "regexp" */
  int not;         /* True if the NOT keyword is present */
};

/*
** An instance of the following structure describes the event of a
** TRIGGER.  "a" is the event type, one of TK_UPDATE, TK_INSERT,
** TK_DELETE, or TK_INSTEAD.  If the event is of the form
**
**      UPDATE ON (a,b,c)
**
** Then the "b" IdList records the list "a,b,c".
*/
struct TrigEvent { int a; IdList * b; };

/*
** An instance of this structure holds the ATTACH key and the key type.
*/
struct AttachKey { int type;  Token key; };

#line 48 "parse.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqlite3ParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqlite3ParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.
**    sqlite3ParserARG_SDECL     A static variable declaration for the %extra_argument
**    sqlite3ParserARG_PDECL     A parameter declaration for the %extra_argument
**    sqlite3ParserARG_STORE     Code to store %extra_argument into yypParser
**    sqlite3ParserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 247
#define YYACTIONTYPE unsigned short int
#define sqlite3ParserTOKENTYPE Token
typedef union {
  sqlite3ParserTOKENTYPE yy0;
  struct TrigEvent yy30;
  Expr* yy62;
  SrcList* yy151;
  Token yy198;
  struct LimitVal yy220;
  struct LikeOp yy222;
  IdList* yy240;
  int yy280;
  struct {int value; int mask;} yy359;
  TriggerStep* yy360;
  struct AttachKey yy361;
  Select* yy375;
  ExprList* yy418;
  int yy493;
} YYMINORTYPE;
#define YYSTACKDEPTH 100
#define sqlite3ParserARG_SDECL Parse *pParse;
#define sqlite3ParserARG_PDECL ,Parse *pParse
#define sqlite3ParserARG_FETCH Parse *pParse = yypParser->pParse
#define sqlite3ParserARG_STORE yypParser->pParse = pParse
#define YYNSTATE 581
#define YYNRULE 311
#define YYERRORSYMBOL 146
#define YYERRSYMDT yy493
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   286,  113,  113,  140,  142,  138,  144,  707,  150,  152,
 /*    10 */   154,  156,  158,  160,  162,  164,  166,  168,  120,  122,
 /*    20 */   123,  170,  178,  150,  152,  154,  156,  158,  160,  162,
 /*    30 */   164,  166,  168,  158,  160,  162,  164,  166,  168,  135,
 /*    40 */    97,  171,  181,  186,  191,  180,  185,  146,  148,  140,
 /*    50 */   142,  138,  144,   51,  150,  152,  154,  156,  158,  160,
 /*    60 */   162,  164,  166,  168,  861,   72,  114,  114,  565,  248,
 /*    70 */   150,  152,  154,  156,  158,  160,  162,  164,  166,  168,
 /*    80 */   124,   37,  362,   40,   59,   67,   69,  326,  357,  170,
 /*    90 */   374,  126,  127,   95,  195,  359,  197,  198,  575,   33,
 /*   100 */   288,  176,   51,  187,  192,  555,  302,  135,   97,  171,
 /*   110 */   181,  186,  191,  180,  185,  146,  148,  140,  142,  138,
 /*   120 */   144,  324,  150,  152,  154,  156,  158,  160,  162,  164,
 /*   130 */   166,  168,   40,   59,   67,   69,  326,  357,  311,   80,
 /*   140 */   250,  316,   34,  170,  359,  132,  373,  115,  661,  818,
 /*   150 */   376,  303,  283,  318,  411,  176,  304,  187,  192,  614,
 /*   160 */   680,  135,   97,  171,  181,  186,  191,  180,  185,  146,
 /*   170 */   148,  140,  142,  138,  144,  170,  150,  152,  154,  156,
 /*   180 */   158,  160,  162,  164,  166,  168,  862,   80,  433,  162,
 /*   190 */   164,  166,  168,  135,   97,  171,  181,  186,  191,  180,
 /*   200 */   185,  146,  148,  140,  142,  138,  144,  296,  150,  152,
 /*   210 */   154,  156,  158,  160,  162,  164,  166,  168,  378,  212,
 /*   220 */   170,  380,  387,  392,  817,  437,  438,  374,  195,   39,
 /*   230 */   197,  198,   28,  395,  136,  409,   33,  356,  135,   97,
 /*   240 */   171,  181,  186,  191,  180,  185,  146,  148,  140,  142,
 /*   250 */   138,  144,  170,  150,  152,  154,  156,  158,  160,  162,
 /*   260 */   164,  166,  168,  195,  369,  197,  198,  219,   98,  231,
 /*   270 */   135,   97,  171,  181,  186,  191,  180,  185,  146,  148,
 /*   280 */   140,  142,  138,  144,  857,  150,  152,  154,  156,  158,
 /*   290 */   160,  162,  164,  166,  168,  170,  176,  246,  187,  192,
 /*   300 */    74,  104,  105,  106,   73,   13,  195,  864,  197,  198,
 /*   310 */    16,   17,   18,  135,   97,  171,  181,  186,  191,  180,
 /*   320 */   185,  146,  148,  140,  142,  138,  144,  170,  150,  152,
 /*   330 */   154,  156,  158,  160,  162,  164,  166,  168,  893,    1,
 /*   340 */   580,  740,  467,    4,  567,  135,   97,  171,  181,  186,
 /*   350 */   191,  180,  185,  146,  148,  140,  142,  138,  144,  478,
 /*   360 */   150,  152,  154,  156,  158,  160,  162,  164,  166,  168,
 /*   370 */    14,   15,  378,  581,  374,  380,  387,  392,  506,  366,
 /*   380 */   540,   48,   32,   33,    3,  577,  235,  395,   13,   99,
 /*   390 */    49,   99,  193,  501,  473,  463,   13,  542,  543,  196,
 /*   400 */   372,  170,  685,   50,   84,   46,  375,  408,  428,  363,
 /*   410 */    78,  260,   78,  200,  512,   47,  508,   91,  221,  135,
 /*   420 */    97,  171,  181,  186,  191,  180,  185,  146,  148,  140,
 /*   430 */   142,  138,  144,  837,  150,  152,  154,  156,  158,  160,
 /*   440 */   162,  164,  166,  168,  130,  128,  390,  568,  348,  252,
 /*   450 */   261,  170,  378,   14,   15,  380,  387,  392,  124,  269,
 /*   460 */   428,   14,   15,  399,  541,  348,  240,  395,  569,  135,
 /*   470 */    97,  171,  181,  186,  191,  180,  185,  146,  148,  140,
 /*   480 */   142,  138,  144,   99,  150,  152,  154,  156,  158,  160,
 /*   490 */   162,  164,  166,  168,  834,   99,  510,  572,   13,  507,
 /*   500 */   413,  170,  406,  330,   78,  200,    6,    5,   42,  405,
 /*   510 */   836,  364,   25,   13,  394,  258,   78,  260,  514,  135,
 /*   520 */    97,  171,  181,  186,  191,  180,  185,  146,  148,  140,
 /*   530 */   142,  138,  144,  606,  150,  152,  154,  156,  158,  160,
 /*   540 */   162,  164,  166,  168,  428,   99,  268,  391,  889,  883,
 /*   550 */   136,   80,   81,  112,  421,  841,  254,  538,  241,  176,
 /*   560 */    99,  187,  192,   14,   15,  682,   78,  317,   13,  331,
 /*   570 */   544,  367,  370,  449,  170,  867,  525,  460,   14,   15,
 /*   580 */   369,   78,  200,  430,   98,   80,  570,   80,  404,  877,
 /*   590 */   278,  819,  135,   97,  171,  181,  186,  191,  180,  185,
 /*   600 */   146,  148,  140,  142,  138,  144,   99,  150,  152,  154,
 /*   610 */   156,  158,  160,  162,  164,  166,  168,  104,  105,  106,
 /*   620 */   539,   13,  442,  319,  170,  333,  709,   78,  500,  553,
 /*   630 */   359,   36,  361,   14,   15,  241,  195,  592,  197,  198,
 /*   640 */   356,  271,  135,   97,  171,  181,  186,  191,  180,  185,
 /*   650 */   146,  148,  140,  142,  138,  144,   13,  150,  152,  154,
 /*   660 */   156,  158,  160,  162,  164,  166,  168,   99,  195,   99,
 /*   670 */   197,  198,  746,  496,  170,   13,  856,  243,  195,  315,
 /*   680 */   197,  198,  537,  334,  341,  343,   14,   15,   78,  500,
 /*   690 */    78,  206,  135,  189,  171,  181,  186,  191,  180,  185,
 /*   700 */   146,  148,  140,  142,  138,  144,  172,  150,  152,  154,
 /*   710 */   156,  158,  160,  162,  164,  166,  168,   99,  243,  301,
 /*   720 */    13,   14,   15,   13,  170,  439,  441,  440,  174,  175,
 /*   730 */   117,  122,  123,  272,  532,  132,  133,  115,   78,  234,
 /*   740 */    14,   15,  183,   97,  171,  181,  186,  191,  180,  185,
 /*   750 */   146,  148,  140,  142,  138,  144,  173,  150,  152,  154,
 /*   760 */   156,  158,  160,  162,  164,  166,  168,  280,  869,  709,
 /*   770 */   448,  885,  182,  462,  170,  195,  298,  197,  198,  199,
 /*   780 */   464,  288,  708,  243,  275,   14,   15,  428,   14,   15,
 /*   790 */    13,  321,  124,  352,  171,  181,  186,  191,  180,  185,
 /*   800 */   146,  148,  140,  142,  138,  144,   80,  150,  152,  154,
 /*   810 */   156,  158,  160,  162,  164,  166,  168,   99,   74,  289,
 /*   820 */    99,   79,   73,   99,  194,   71,  509,  346,  462,  591,
 /*   830 */   643,  486,  348,  109,   11,  443,   79,   99,   78,  200,
 /*   840 */    71,   78,  232,  674,   78,  214,  459,  472,  109,  428,
 /*   850 */   223,  277,  470,  571,   48,   14,   15,   80,   78,  208,
 /*   860 */   136,   80,   99,   49,  201,  223,  195,  709,  197,  198,
 /*   870 */   353,  195,  428,  197,  198,  136,   50,  276,  225,  201,
 /*   880 */   237,  207,  205,   78,   94,  352,  486,  827,  511,  203,
 /*   890 */    76,   77,  241,   86,   98,  215,  207,  205,  312,   99,
 /*   900 */   309,   99,  468,   99,  203,   76,   77,  470,   64,   98,
 /*   910 */   457,  513,  348,   84,   99,  576,   99,  352,  352,  383,
 /*   920 */    78,  161,   78,  145,   78,  222,  483,  104,  105,  106,
 /*   930 */   107,  108,  209,  213,   99,   78,  220,   78,  163,  533,
 /*   940 */   339,  497,  104,  105,  106,  107,  108,  209,  213,   99,
 /*   950 */   672,  389,  398,   99,   79,   78,  143,   99,   71,  493,
 /*   960 */   340,  445,  353,   99,  428,  444,  109,   99,  740,   79,
 /*   970 */    78,  165,  352,   71,   78,  167,  243,  446,   78,  393,
 /*   980 */    99,  109,  116,  223,   78,  141,  113,  887,   78,  169,
 /*   990 */   477,  275,   80,  136,  353,  353,   99,  201,  223,  465,
 /*  1000 */    45,   78,  323,  517,   99,  414,  456,  491,  136,  296,
 /*  1010 */    99,   84,  201,  336,  207,  205,   52,   78,  139,  573,
 /*  1020 */    44,   45,  203,   76,   77,   78,  137,   98,   54,  207,
 /*  1030 */   205,   78,  177,   99,  286,   99,  113,  203,   76,   77,
 /*  1040 */   298,  422,   98,  417,  428,   42,  499,   99,  497,  353,
 /*  1050 */   313,  114,   99,  835,   78,  147,   78,  151,  277,  428,
 /*  1060 */   104,  105,  106,  107,  108,  209,  213,  820,   78,  149,
 /*  1070 */    99,   78,  310,   78,  179,  104,  105,  106,  107,  108,
 /*  1080 */   209,  213,    8,  521,  276,   99,  269,   19,   21,   23,
 /*  1090 */   412,   78,  434,   99,    3,  577,   99,   65,  527,  490,
 /*  1100 */   563,  114,  547,   99,   66,   99,   78,  300,  483,  557,
 /*  1110 */    99,  574,  113,   99,   78,  153,   99,   78,  188,   99,
 /*  1120 */   535,  536,   99,  467,   78,  190,   78,  365,  534,   99,
 /*  1130 */   560,   78,  111,  566,   78,  270,  266,   78,  155,   99,
 /*  1140 */    78,  265,   99,   78,  481,   99,   84,   99,  888,   99,
 /*  1150 */    78,  249,   84,  529,  238,  211,  239,   99,  298,  494,
 /*  1160 */    78,  485,   99,   78,  157,  530,   78,  247,   78,  202,
 /*  1170 */    78,  498,  523,   99,  515,  519,  463,  114,   78,   96,
 /*  1180 */   505,   99,  288,   78,  204,   84,   80,   27,   80,  410,
 /*  1190 */   273,  283,  130,  128,   78,  159,  660,  118,   31,  119,
 /*  1200 */   331,  352,   78,  236,   57,   58,  295,    2,  296,  320,
 /*  1210 */     4,  239,  338,  337,  745,  578,  347,  294,  348,  210,
 /*  1220 */   306,  531,  579,   82,  224,   93,  528,   42,  227,   92,
 /*  1230 */   598,  226,   12,  489,  228,  229,   88,  230,  526,  742,
 /*  1240 */   524,  522,  520,  464,  739,  518,  269,  516,  875,  833,
 /*  1250 */   681,   87,  679,  168,  868,  504,  333,  503,  866,  502,
 /*  1260 */   495,  342,  245,   22,  492,  244,  100,  599,  101,  102,
 /*  1270 */   488,  487,   20,  484,  688,  865,  251,  593,  349,  253,
 /*  1280 */   479,   85,  480,  687,  257,  482,  255,  388,  103,  258,
 /*  1290 */   256,  259,  600,   24,  386,  584,  476,  475,  262,  263,
 /*  1300 */    26,  601,  686,  474,  344,  385,  863,  471,  267,  848,
 /*  1310 */   469,  239,   53,  466,  242,  748,  384,  110,  747,  461,
 /*  1320 */   826,  825,  458,   83,  453,  455,  279,  454,  281,  382,
 /*  1330 */    56,   55,  274,  282,  452,   29,  451,  381,  450,  447,
 /*  1340 */   290,  299,  377,  292,   30,  284,  291,  287,  293,    7,
 /*  1350 */   285,  407,   43,  121,  379,  855,  355,  605,   60,  184,
 /*  1360 */   854,  436,  131,  849,  297,  350,  616,  305,  435,  432,
 /*  1370 */   307,  431,  314,  429,  427,  308,   64,  425,   41,  358,
 /*  1380 */   351,  424,  423,  420,  419,  426,  125,  129,  322,  416,
 /*  1390 */    35,  418,   61,   62,  134,  415,   63,  371,  345,  368,
 /*  1400 */   327,    9,   70,  360,  325,  590,  332,   68,  615,   10,
 /*  1410 */   556,   54,  328,   38,  329,  400,  550,  840,  546,  397,
 /*  1420 */   401,  876,  264,  878,  879,  551,  330,  839,  545,  882,
 /*  1430 */   218,  233,  838,  396,  884,  559,  886,  549,  335,  403,
 /*  1440 */   559,   75,  554,  559,  402,  559,  559,  559,  561,  559,
 /*  1450 */   559,  559,  559,  562,  559,  559,  564,  559,  559,  559,
 /*  1460 */   559,  559,  559,  559,  559,  559,  559,  559,  559,  559,
 /*  1470 */   559,  559,  559,  559,  559,  559,  559,  559,  559,  354,
 /*  1480 */    89,  559,  559,  559,  559,  559,  559,  559,  559,  559,
 /*  1490 */   559,  559,  559,  559,  559,  559,  559,  559,  559,   90,
 /*  1500 */   559,  559,  559,  216,  559,  217,  559,  559,  559,  548,
 /*  1510 */   559,  559,  559,  559,  559,  552,  559,  559,  559,  558,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    28,   30,   30,   77,   78,   79,   80,   27,   82,   83,
 /*    10 */    84,   85,   86,   87,   88,   89,   90,   91,  171,  172,
 /*    20 */   173,   49,   81,   82,   83,   84,   85,   86,   87,   88,
 /*    30 */    89,   90,   91,   86,   87,   88,   89,   90,   91,   67,
 /*    40 */    68,   69,   70,   71,   72,   73,   74,   75,   76,   77,
 /*    50 */    78,   79,   80,   69,   82,   83,   84,   85,   86,   87,
 /*    60 */    88,   89,   90,   91,   15,   26,   95,   95,  159,   29,
 /*    70 */    82,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*    80 */   233,   97,   98,   99,  100,  101,  102,  103,  104,   49,
 /*    90 */   155,  132,  133,   53,  114,  111,  116,  117,  163,  164,
 /*   100 */   168,  223,   69,  225,  226,  134,  162,   67,   68,   69,
 /*   110 */    70,   71,   72,   73,   74,   75,   76,   77,   78,   79,
 /*   120 */    80,   27,   82,   83,   84,   85,   86,   87,   88,   89,
 /*   130 */    90,   91,   99,  100,  101,  102,  103,  104,  206,  195,
 /*   140 */   124,   27,  165,   49,  111,  168,  169,  170,   27,   21,
 /*   150 */    29,  207,  208,   27,  162,  223,  212,  225,  226,  120,
 /*   160 */    11,   67,   68,   69,   70,   71,   72,   73,   74,   75,
 /*   170 */    76,   77,   78,   79,   80,   49,   82,   83,   84,   85,
 /*   180 */    86,   87,   88,   89,   90,   91,   15,  195,  139,   88,
 /*   190 */    89,   90,   91,   67,   68,   69,   70,   71,   72,   73,
 /*   200 */    74,   75,   76,   77,   78,   79,   80,   29,   82,   83,
 /*   210 */    84,   85,   86,   87,   88,   89,   90,   91,   97,   27,
 /*   220 */    49,  100,  101,  102,   21,   58,   59,  155,  114,  175,
 /*   230 */   116,  117,  160,  112,   65,  163,  164,  183,   67,   68,
 /*   240 */    69,   70,   71,   72,   73,   74,   75,   76,   77,   78,
 /*   250 */    79,   80,   49,   82,   83,   84,   85,   86,   87,   88,
 /*   260 */    89,   90,   91,  114,   95,  116,  117,  139,   99,  141,
 /*   270 */    67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   280 */    77,   78,   79,   80,  106,   82,   83,   84,   85,   86,
 /*   290 */    87,   88,   89,   90,   91,   49,  223,  224,  225,  226,
 /*   300 */   115,  132,  133,  134,  119,   30,  114,   21,  116,  117,
 /*   310 */    17,   18,   19,   67,   68,   69,   70,   71,   72,   73,
 /*   320 */    74,   75,   76,   77,   78,   79,   80,   49,   82,   83,
 /*   330 */    84,   85,   86,   87,   88,   89,   90,   91,  147,  148,
 /*   340 */   149,   11,   56,  152,   24,   67,   68,   69,   70,   71,
 /*   350 */    72,   73,   74,   75,   76,   77,   78,   79,   80,   29,
 /*   360 */    82,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*   370 */    95,   96,   97,    0,  155,  100,  101,  102,   24,   27,
 /*   380 */   155,   22,  163,  164,   11,   12,  140,  112,   30,  155,
 /*   390 */    31,  155,   26,  107,  108,  109,   30,  172,  173,  115,
 /*   400 */   167,   49,  118,   44,  118,   46,  187,  188,  155,  176,
 /*   410 */   176,  177,  176,  177,   60,   56,   62,  203,  140,   67,
 /*   420 */    68,   69,   70,   71,   72,   73,   74,   75,   76,   77,
 /*   430 */    78,   79,   80,   11,   82,   83,   84,   85,   86,   87,
 /*   440 */    88,   89,   90,   91,   86,   87,   27,  194,   29,  215,
 /*   450 */   216,   49,   97,   95,   96,  100,  101,  102,  233,  129,
 /*   460 */   155,   95,   96,   27,  106,   29,  230,  112,   64,   67,
 /*   470 */    68,   69,   70,   71,   72,   73,   74,   75,   76,   77,
 /*   480 */    78,   79,   80,  155,   82,   83,   84,   85,   86,   87,
 /*   490 */    88,   89,   90,   91,   11,  155,  142,  244,   30,  194,
 /*   500 */   158,   49,  183,  184,  176,  177,  150,  151,  106,  190,
 /*   510 */    11,   26,  156,   30,  178,   30,  176,  177,  162,   67,
 /*   520 */    68,   69,   70,   71,   72,   73,   74,   75,   76,   77,
 /*   530 */    78,   79,   80,   11,   82,   83,   84,   85,   86,   87,
 /*   540 */    88,   89,   90,   91,  155,  155,  218,  178,  144,   11,
 /*   550 */    65,  195,  162,   28,  162,   11,  216,  159,  230,  223,
 /*   560 */   155,  225,  226,   95,   96,   11,  176,  177,   30,   50,
 /*   570 */    26,   86,   87,  231,   49,   11,  220,  235,   95,   96,
 /*   580 */    95,  176,  177,  194,   99,  195,  143,  195,   69,   11,
 /*   590 */   122,  139,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   600 */    75,   76,   77,   78,   79,   80,  155,   82,   83,   84,
 /*   610 */    85,   86,   87,   88,   89,   90,   91,  132,  133,  134,
 /*   620 */    76,   30,   52,  218,   49,  106,   28,  176,  177,   51,
 /*   630 */   111,  174,  175,   95,   96,  230,  114,   11,  116,  117,
 /*   640 */   183,   29,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   650 */    75,   76,   77,   78,   79,   80,   30,   82,   83,   84,
 /*   660 */    85,   86,   87,   88,   89,   90,   91,  155,  114,  155,
 /*   670 */   116,  117,   11,  222,   49,   30,  106,  120,  114,   88,
 /*   680 */   116,  117,  155,  107,  108,  109,   95,   96,  176,  177,
 /*   690 */   176,  177,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   700 */    75,   76,   77,   78,   79,   80,   49,   82,   83,   84,
 /*   710 */    85,   86,   87,   88,   89,   90,   91,  155,  120,   26,
 /*   720 */    30,   95,   96,   30,   49,  107,  108,  109,   71,   72,
 /*   730 */   171,  172,  173,  121,  222,  168,  169,  170,  176,  177,
 /*   740 */    95,   96,   69,   68,   69,   70,   71,   72,   73,   74,
 /*   750 */    75,   76,   77,   78,   79,   80,   99,   82,   83,   84,
 /*   760 */    85,   86,   87,   88,   89,   90,   91,  122,   11,  106,
 /*   770 */    25,   11,   99,  162,   49,  114,  155,  116,  117,   27,
 /*   780 */    67,  168,   27,  120,   29,   95,   96,  155,   95,   96,
 /*   790 */    30,   88,  233,  155,   69,   70,   71,   72,   73,   74,
 /*   800 */    75,   76,   77,   78,   79,   80,  195,   82,   83,   84,
 /*   810 */    85,   86,   87,   88,   89,   90,   91,  155,  115,  206,
 /*   820 */   155,   26,  119,  155,  162,   30,  194,  189,  162,   11,
 /*   830 */    27,  220,   29,   38,   16,  214,   26,  155,  176,  177,
 /*   840 */    30,  176,  177,  130,  176,  177,  101,  236,   38,  155,
 /*   850 */    55,   96,  241,  155,   22,   95,   96,  195,  176,  177,
 /*   860 */    65,  195,  155,   31,   69,   55,  114,   11,  116,  117,
 /*   870 */   232,  114,  155,  116,  117,   65,   44,  122,   46,   69,
 /*   880 */   218,   86,   87,  176,  177,  155,  220,  142,  194,   94,
 /*   890 */    95,   96,  230,  198,   99,  227,   86,   87,   88,  155,
 /*   900 */   205,  155,  236,  155,   94,   95,   96,  241,  105,   99,
 /*   910 */    27,  194,   29,  118,  155,  145,  155,  155,  155,  189,
 /*   920 */   176,  177,  176,  177,  176,  177,  155,  132,  133,  134,
 /*   930 */   135,  136,  137,  138,  155,  176,  177,  176,  177,   27,
 /*   940 */    37,   29,  132,  133,  134,  135,  136,  137,  138,  155,
 /*   950 */    11,  189,  189,  155,   26,  176,  177,  155,   30,  162,
 /*   960 */    57,   32,  232,  155,  155,   36,   38,  155,   11,   26,
 /*   970 */   176,  177,  155,   30,  176,  177,  120,   48,  176,  177,
 /*   980 */   155,   38,   26,   55,  176,  177,   30,   11,  176,  177,
 /*   990 */   219,   29,  195,   65,  232,  232,  155,   69,   55,  192,
 /*  1000 */   193,  176,  177,  194,  155,   24,  189,   27,   65,   29,
 /*  1010 */   155,  118,   69,  110,   86,   87,   99,  176,  177,  144,
 /*  1020 */   192,  193,   94,   95,   96,  176,  177,   99,  111,   86,
 /*  1030 */    87,  176,  177,  155,   28,  155,   30,   94,   95,   96,
 /*  1040 */   155,   60,   99,   62,  155,  106,   27,  155,   29,  232,
 /*  1050 */   155,   95,  155,   11,  176,  177,  176,  177,   96,  155,
 /*  1060 */   132,  133,  134,  135,  136,  137,  138,  139,  176,  177,
 /*  1070 */   155,  176,  177,  176,  177,  132,  133,  134,  135,  136,
 /*  1080 */   137,  138,   15,  194,  122,  155,  129,   20,   21,   22,
 /*  1090 */    23,  176,  177,  155,   11,   12,  155,   34,  194,  214,
 /*  1100 */    33,   95,   35,  155,   41,  155,  176,  177,  155,   42,
 /*  1110 */   155,  245,   30,  155,  176,  177,  155,  176,  177,  155,
 /*  1120 */   155,   54,  155,   56,  176,  177,  176,  177,   61,  155,
 /*  1130 */    63,  176,  177,   66,  176,  177,  126,  176,  177,  155,
 /*  1140 */   176,  177,  155,  176,  177,  155,  118,  155,   11,  155,
 /*  1150 */   176,  177,  118,  162,   27,  162,   29,  155,  155,  131,
 /*  1160 */   176,  177,  155,  176,  177,  131,  176,  177,  176,  177,
 /*  1170 */   176,  177,  219,  155,  107,  108,  109,   95,  176,  177,
 /*  1180 */   113,  155,  168,  176,  177,  118,  195,   26,  195,   28,
 /*  1190 */   207,  208,   86,   87,  176,  177,   27,   27,   29,   29,
 /*  1200 */    50,  155,  176,  177,   17,   18,   27,  149,   29,   27,
 /*  1210 */   152,   29,   98,   99,   11,   13,   27,  214,   29,   26,
 /*  1220 */   206,   26,   14,  196,   26,  128,  221,  106,  193,  204,
 /*  1230 */    11,   27,  155,   26,   29,  155,  200,   27,  130,   11,
 /*  1240 */   200,  110,  191,   67,   11,  200,  129,  121,   11,   11,
 /*  1250 */    11,  199,   11,   91,   11,  200,  106,  155,   11,  121,
 /*  1260 */    26,  185,  159,  154,  221,  155,  120,   11,  155,  120,
 /*  1270 */   155,  130,  154,   76,  118,   11,  125,   11,  232,   29,
 /*  1280 */   155,  197,   76,  118,  104,  200,  217,   26,  155,   30,
 /*  1290 */   179,  167,   11,  154,  178,   11,  110,  155,  217,  179,
 /*  1300 */   157,   11,  118,  191,  185,   27,   21,   11,  125,   11,
 /*  1310 */    21,   29,  178,  191,  155,  130,  180,   26,  130,   15,
 /*  1320 */   142,   11,  178,  195,  106,   26,  155,  155,  155,   26,
 /*  1330 */    47,  186,  209,  122,  159,  161,  155,   51,  142,   52,
 /*  1340 */   210,  106,  188,  123,   27,  155,  211,  155,   26,   11,
 /*  1350 */   159,  188,   39,   27,  155,  106,  179,   11,   51,   99,
 /*  1360 */   106,   43,  168,   15,  155,  217,  120,   27,   45,  240,
 /*  1370 */   210,  239,  120,  159,  106,  211,  105,  237,  178,  167,
 /*  1380 */   179,  159,  155,   28,  159,  238,  234,  234,   27,  159,
 /*  1390 */   166,  155,  179,  178,   27,  155,  180,  176,   26,  176,
 /*  1400 */   155,  153,   26,  186,  178,   11,  155,  178,  120,  154,
 /*  1410 */    40,  111,  181,  155,  182,  103,   28,   11,   27,   26,
 /*  1420 */   155,   11,  127,   11,   11,  155,  184,   11,  155,   11,
 /*  1430 */    21,  139,   11,   51,   11,  155,   11,  168,  185,  182,
 /*  1440 */   246,  197,  168,  246,  181,  246,  246,  246,  155,  246,
 /*  1450 */   246,  246,  246,  159,  246,  246,  155,  246,  246,  246,
 /*  1460 */   246,  246,  246,  246,  246,  246,  246,  246,  246,  246,
 /*  1470 */   246,  246,  246,  246,  246,  246,  246,  246,  246,  217,
 /*  1480 */   201,  246,  246,  246,  246,  246,  246,  246,  246,  246,
 /*  1490 */   246,  246,  246,  246,  246,  246,  246,  246,  246,  202,
 /*  1500 */   246,  246,  246,  228,  246,  229,  246,  246,  246,  242,
 /*  1510 */   246,  246,  246,  246,  246,  243,  246,  246,  246,  242,
};
#define YY_SHIFT_USE_DFLT (-75)
static const short yy_shift_ofst[] = {
 /*     0 */  1083,  373,  -75,  -75, 1067, 1284, 1338,  -75,  293,  818,
 /*    10 */  1394,  626, 1266,  -75,  -75,  -75,  -75,  -75,  -75,  818,
 /*    20 */  1219,  818, 1256,  818, 1281, 1161, 1290,  690, 1169, 1317,
 /*    30 */  1346,  275,  -75, 1082,  -75,  -16,  -75,  690,   33,  -75,
 /*    40 */  1121,  -75, 1313,  359,  -75,  -75,  -75,  -75,  -75,  -75,
 /*    50 */   -75,  917, 1121,  -75, 1283,  -75, 1187,  -75,  -75, 1307,
 /*    60 */  1063, 1121, 1271,  -75,  -75,  -75,  -75, 1121,  -75, 1376,
 /*    70 */   943,   39,  703,  -75,  -75,  943, 1288, 1246,  -75,  795,
 /*    80 */   -75,  114,  893,  -75,  185,  -75,  612, 1117, 1010, 1295,
 /*    90 */    16, 1097,  -75,  943,   40,  943,  575,  943,  -75, 1146,
 /*   100 */   690, 1149,  690,  -75,  -75,  -75,  -75,  -75,  -75, 1291,
 /*   110 */   943,  525, 1082,  -75,  -75,  956, 1106, 1170,  -75, 1106,
 /*   120 */  1326,  -75,  -75,  -75,  -41,  -75,  -75,  -75,  -41,  -75,
 /*   130 */   -75,  -75,  -75, 1367,  -75,  943,  -75,  675,  943,  -12,
 /*   140 */   943,  -12,  943,  -12,  943,  -12,  943,  -74,  943,  -74,
 /*   150 */   943,  -53,  943,  -53,  943,  -53,  943,  -53,  943,  101,
 /*   160 */   943,  101,  943, 1162,  943, 1162,  943, 1162,  943,  -75,
 /*   170 */   -75,  657,  -75,  -75,  -75,  -75,  943,  -59,  943,  -12,
 /*   180 */   -75,  673,  -75, 1260,  -75,  -75,  -75,  943,  625,  943,
 /*   190 */   -74,  -75,  366,  795,  752,  284, 1184, 1165, 1156,  -75,
 /*   200 */   575,  943,  725,  943,  -75,  943,  -75,  943,  -75, 1193,
 /*   210 */   893,  192,  -75,  928,  452, 1292,  128, 1409,  -75,  943,
 /*   220 */   278,  943,  575, 1198,  832, 1204,  -75, 1205,  690, 1210,
 /*   230 */   -75,  943,  203,  943,  246,  943,  575, 1127,  -75,  943,
 /*   240 */   -75,  -75,  557,  690,  -75,  -75,  -75,  725,  943,  575,
 /*   250 */  1151,  943, 1250,  943, 1180, 1063,  -75, 1259,  -75,  -75,
 /*   260 */   575, 1180, 1063,  -75,  943,  575, 1183,  943, 1282,  943,
 /*   270 */   575,  -75,  -75,  962,  -75,  -75,  -75,  468,  -75,  645,
 /*   280 */   -75, 1211,  -75,  693,  557, 1006,  690,  -75,  -75, 1235,
 /*   290 */  1220,  -75, 1322,  690, 1179,  -75,  690,  -75,  -75,  943,
 /*   300 */   575,  893,  -20,  755, 1340, 1006, 1235, 1220,  -75,  810,
 /*   310 */   -28,  -75,  -75, 1252,  591,  -75,  -75,  126,  -75, 1182,
 /*   320 */   -75, 1361,  -75,   94, 1121,  -75,  690, 1372,  -75, 1150,
 /*   330 */   -75,  690,  -75,  576,  903,  -75, 1114,  -75,  -75,  -75,
 /*   340 */   -75,  903,  -75,  903,  -75,  690, 1189,  -75,  690, 1180,
 /*   350 */  1063,  -75,  -75, 1180, 1063,  -75,  -75, 1259,  -75, 1283,
 /*   360 */   -75,  -75,  485,  -75,  943,  352,  -75,  169,  -75,  -75,
 /*   370 */   169,  -75,  -75,  -75,  -75,  121,  355,  -75,  690,  -75,
 /*   380 */  1286, 1303,  690,  803, 1278, 1121,  -75, 1261,  690,  419,
 /*   390 */  1121,  -75,  943,  402,  -75, 1382, 1393,  690,  436, 1312,
 /*   400 */   690, 1372,  -75,  519, 1300,  -75,  -75,  -75,  -75,  -75,
 /*   410 */   893,  522,  745,  981,  690,  557,  -75,  690,  598, 1355,
 /*   420 */   893,  149,  690,  557,  929,  618, 1268,  690,  557,  -75,
 /*   430 */  1323,   49, 1348,  943,  171, 1318,  167,  -75,  -75, 1254,
 /*   440 */  1249,  570,  690,  178,  -75,  -75, 1287,  -75,  -75, 1196,
 /*   450 */   690,  663, 1218,  690, 1299,  690,  883,  939, 1310, 1178,
 /*   460 */  1304,  286,  757,  713,  359,  -75, 1188, 1185, 1289, 1298,
 /*   470 */  1296,  286, 1285, 1176,  690, 1186,  690,  330,  690, 1206,
 /*   480 */   943,  575, 1264, 1197,  943,  575, 1141,  690, 1207,  690,
 /*   490 */   980,  -75, 1028,  564, 1234,  943, 1019,  943,  575, 1247,
 /*   500 */   575, 1138,  690,  957, 1243,  354,  690, 1241,  690, 1239,
 /*   510 */   690, 1238,  690, 1237,  554, 1126,  690,  957, 1233, 1176,
 /*   520 */   690, 1131,  690,  330, 1228, 1108,  690, 1207, 1034,  661,
 /*   530 */  1195,  943,  912, 1203,  483, 1042,  690,  557,  544,  358,
 /*   540 */   499,  422, 1421, 1416,  690, 1391, 1406, 1370, 1082, 1388,
 /*   550 */   690,  578, 1410,  -29, 1412, 1413,  -75, 1370,  690, 1418,
 /*   560 */   538,  856, 1423,  760,  856, 1425,  320,  690,  404,  443,
 /*   570 */   690,  976,  875,  770,  690, 1137,  -75, 1202, 1208,  -75,
 /*   580 */   -75,
};
#define YY_REDUCE_USE_DFLT (-154)
static const short yy_reduce_ofst[] = {
 /*     0 */   191, 1058, -154, -154,  356, -154, -154, -154, 1248, 1255,
 /*    10 */  -154, 1077, -154, -154, -154, -154, -154, -154, -154, 1118,
 /*    20 */  -154, 1109, -154, 1139, -154, 1143, -154,   72, 1174, -154,
 /*    30 */  -154,  219, -154,  -23, 1224,  457, -154, 1258,   54, -154,
 /*    40 */  1200, -154, -154,  828, -154, -154, -154, -154, -154, -154,
 /*    50 */  -154, -154, 1134, -154, 1145, -154, -154, -154, -154, -154,
 /*    60 */  1213, 1215, 1216, -154, -154, -154, -154, 1229, -154, -154,
 /*    70 */   825, -154, 1244, -154, -154,  405, -154, -154, -154,  390,
 /*    80 */  -154, 1027, 1128, -154, 1084,  695, 1052, 1036, 1279, 1297,
 /*    90 */   214, 1025, -154,  707, -122, 1002, -122,  990, -154, -154,
 /*   100 */  1113, -154, 1133, -154, -154, -154, -154, -154, -154, -154,
 /*   110 */   955, -122,  567, -154, -154, 1194,  559, -154, -154, -153,
 /*   120 */  -154, -154, -154, -154, 1152, -154, -154, -154, 1153, -154,
 /*   130 */  -154, -154, -154, -154, -154,  849, -154, -122,  841, -122,
 /*   140 */   808, -122,  779, -122,  746, -122,  878, -122,  892, -122,
 /*   150 */   880, -122,  938, -122,  961, -122,  987, -122, 1018, -122,
 /*   160 */   744, -122,  761, -122,  794, -122,  798, -122,  812, -122,
 /*   170 */  -154, -154, -154, -154, -154, -154,  855,   73,  897, -122,
 /*   180 */  -154, -154, -154, -154, -154, -154, -154,  941, -122,  948,
 /*   190 */  -122, -154, 1159,  662, 1027, -154, -154, -154, -154, -154,
 /*   200 */  -122,  992, -122, 1007, -122,  514, -122,  682, -122, -154,
 /*   210 */   993, 1027, -154,  668, -122, 1275, 1276, -154, -154,  759,
 /*   220 */  -122,  748, -122, -154, 1035, -154, -154, -154, 1080, -154,
 /*   230 */  -154,  665, -122,  562, -122, 1026, -122, -154, -154,  236,
 /*   240 */  -154, -154, 1103, 1110, -154, -154, -154, -122,  974, -122,
 /*   250 */  -154,  234, -154,  340, 1069, 1111, -154, 1124, -154, -154,
 /*   260 */  -122, 1081, 1120, -154,  964, -122, -154,  328, -154,  958,
 /*   270 */  -122, -154,  983, 1123, -154, -154, -154, 1171, -154, 1173,
 /*   280 */  -154, -154, -154, 1190, 1191,  613, 1192, -154, -154, 1130,
 /*   290 */  1135, -154, -154, 1003, -154, -154, 1209, -154, -154,  930,
 /*   300 */  -122,  -56, 1027, 1123, -154, 1014, 1160, 1164, -154,  895,
 /*   310 */   -68, -154, -154, -154, 1113, -154, -154, -122, -154, -154,
 /*   320 */  -154, -154, -154, -122, 1226, -154, 1245, 1231, 1232, 1242,
 /*   330 */  -154, 1251, -154, -154, 1253, -154, -154, -154, -154, -154,
 /*   340 */  -154, 1076, -154, 1119, -154,  638, -154, -154, 1046, 1148,
 /*   350 */  1201, -154, -154, 1262, 1177, -154, -154, 1212, -154, 1217,
 /*   360 */  -154, -154,  233, -154,  950, -122, -154, 1223, -154, -154,
 /*   370 */  1221, -154, -154, -154, -154, 1163, 1154, -154, 1199, -154,
 /*   380 */  -154, -154,  730, 1136, -154, 1116, -154, -154,  762, -154,
 /*   390 */   369, -154,  802,  336, -154, -154, -154,  763, -154, -154,
 /*   400 */  1265, 1263, 1257,  319, -154, -154, -154, -154, -154, -154,
 /*   410 */    -8, 1027,  342, -154, 1240, 1230, -154, 1236, 1225, -154,
 /*   420 */   392, 1027, 1227, 1222, 1140, 1147, -154,  389, 1214, -154,
 /*   430 */  1132, 1129, -154,  915, -122, -154, -154, -154, -154, -154,
 /*   440 */  -154, -154,  621, -154, -154, -154, -154, -154, -154, -154,
 /*   450 */  1181, 1175, -154, 1172, -154,  817, -154, 1144, -154, -154,
 /*   460 */  -154,  666, 1027, 1122,  807, -154, -154, -154, -154, -154,
 /*   470 */  -154,  611, -154, 1112, 1142, -154,  771, 1085, 1125, -154,
 /*   480 */   967, -122, -154, -154,  984, -122, -154, 1115, 1043,  885,
 /*   490 */  -154, -154,  797, 1027, -154,  451, -154,  994, -122, -154,
 /*   500 */  -122, -154, 1102, 1055, -154, -154,  305, -154,  632, -154,
 /*   510 */   694, -154,  717, -154, 1027, -154,  809, 1045, -154, 1051,
 /*   520 */   889, -154,  953, 1040, -154, -154,  904, 1005,  991, 1027,
 /*   530 */  -154,  512, -154, -154,  965, -154,  527,  398, -154,  225,
 /*   540 */  -154, -154, -154, -154, 1273, -154, -154, 1267, 1269, -154,
 /*   550 */  1270, 1272, -154, 1274, -154, -154, -154, 1277, 1280, -154,
 /*   560 */  1293, 1294, -154, 1301,  -91, -154, -154,  253, -154, -154,
 /*   570 */   698, -154, -154,  866,  -65, -154, -154, -154, -154, -154,
 /*   580 */  -154,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   587,  587,  582,  585,  892,  892,  892,  586,  594,  892,
 /*    10 */   892,  892,  892,  614,  615,  616,  595,  596,  597,  892,
 /*    20 */   892,  892,  892,  892,  892,  892,  892,  892,  892,  892,
 /*    30 */   892,  892,  607,  617,  627,  609,  626,  892,  892,  628,
 /*    40 */   672,  635,  892,  892,  673,  676,  677,  678,  872,  873,
 /*    50 */   874,  892,  672,  636,  657,  655,  892,  658,  659,  892,
 /*    60 */   728,  672,  643,  637,  644,  726,  727,  672,  638,  892,
 /*    70 */   892,  758,  692,  690,  691,  824,  764,  759,  755,  892,
 /*    80 */   683,  892,  892,  684,  692,  694,  701,  740,  731,  733,
 /*    90 */   721,  735,  689,  892,  736,  892,  737,  892,  757,  892,
 /*   100 */   892,  760,  892,  761,  762,  763,  765,  766,  767,  892,
 /*   110 */   892,  892,  892,  612,  613,  619,  847,  892,  620,  847,
 /*   120 */   892,  621,  624,  625,  892,  842,  844,  845,  892,  843,
 /*   130 */   846,  623,  622,  892,  768,  892,  771,  773,  892,  774,
 /*   140 */   892,  775,  892,  776,  892,  777,  892,  778,  892,  779,
 /*   150 */   892,  780,  892,  781,  892,  782,  892,  783,  892,  784,
 /*   160 */   892,  785,  892,  786,  892,  787,  892,  788,  892,  789,
 /*   170 */   790,  892,  791,  798,  805,  808,  892,  793,  892,  792,
 /*   180 */   795,  892,  796,  892,  799,  797,  804,  892,  892,  892,
 /*   190 */   806,  807,  892,  824,  892,  892,  892,  892,  892,  811,
 /*   200 */   823,  892,  800,  892,  801,  892,  802,  892,  803,  892,
 /*   210 */   892,  892,  813,  892,  892,  892,  892,  892,  814,  892,
 /*   220 */   892,  892,  815,  892,  892,  892,  870,  892,  892,  892,
 /*   230 */   871,  892,  892,  892,  892,  892,  816,  892,  809,  824,
 /*   240 */   821,  822,  709,  892,  710,  812,  794,  772,  892,  738,
 /*   250 */   892,  892,  722,  892,  729,  728,  723,  892,  611,  730,
 /*   260 */   725,  729,  728,  724,  892,  734,  892,  824,  732,  892,
 /*   270 */   741,  693,  704,  702,  703,  712,  713,  892,  714,  892,
 /*   280 */   715,  892,  716,  892,  709,  700,  892,  698,  699,  718,
 /*   290 */   720,  705,  892,  892,  892,  719,  892,  753,  754,  892,
 /*   300 */   717,  704,  892,  892,  892,  700,  718,  720,  706,  892,
 /*   310 */   700,  695,  696,  892,  892,  697,  810,  892,  756,  892,
 /*   320 */   769,  892,  770,  892,  672,  639,  892,  828,  645,  640,
 /*   330 */   646,  892,  647,  892,  892,  648,  892,  651,  652,  653,
 /*   340 */   654,  892,  649,  892,  650,  892,  892,  829,  892,  729,
 /*   350 */   728,  830,  832,  729,  728,  831,  641,  892,  642,  657,
 /*   360 */   656,  629,  892,  630,  892,  892,  631,  892,  632,  764,
 /*   370 */   892,  633,  634,  618,  610,  892,  892,  662,  892,  665,
 /*   380 */   892,  892,  892,  892,  892,  672,  666,  892,  892,  892,
 /*   390 */   672,  667,  892,  672,  668,  892,  892,  892,  892,  892,
 /*   400 */   892,  828,  645,  670,  892,  669,  671,  663,  664,  608,
 /*   410 */   892,  892,  604,  892,  892,  709,  602,  892,  892,  892,
 /*   420 */   892,  892,  892,  709,  853,  892,  892,  892,  709,  711,
 /*   430 */   858,  892,  892,  892,  892,  892,  892,  859,  860,  892,
 /*   440 */   892,  892,  892,  892,  850,  851,  892,  852,  603,  892,
 /*   450 */   892,  892,  892,  892,  892,  892,  892,  892,  892,  892,
 /*   460 */   892,  892,  892,  892,  892,  675,  892,  892,  892,  892,
 /*   470 */   892,  892,  892,  674,  892,  892,  892,  892,  892,  892,
 /*   480 */   892,  743,  892,  892,  892,  744,  892,  892,  751,  892,
 /*   490 */   892,  752,  892,  892,  892,  892,  892,  892,  749,  892,
 /*   500 */   750,  892,  892,  892,  892,  892,  892,  892,  892,  892,
 /*   510 */   892,  892,  892,  892,  892,  892,  892,  892,  892,  674,
 /*   520 */   892,  892,  892,  892,  892,  892,  892,  751,  892,  892,
 /*   530 */   892,  892,  892,  892,  892,  892,  892,  709,  892,  847,
 /*   540 */   892,  892,  892,  892,  892,  892,  892,  881,  892,  892,
 /*   550 */   892,  892,  892,  892,  892,  892,  880,  881,  892,  892,
 /*   560 */   892,  892,  892,  892,  892,  892,  892,  892,  892,  892,
 /*   570 */   892,  892,  892,  890,  892,  892,  891,  588,  892,  589,
 /*   580 */   583,
};
#define YY_SZ_ACTTAB (sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammer, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /* END_OF_FILE => nothing */
    0,  /*    ILLEGAL => nothing */
    0,  /*      SPACE => nothing */
    0,  /* UNCLOSED_STRING => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*     COLUMN => nothing */
    0,  /* AGG_FUNCTION => nothing */
    0,  /* AGG_COLUMN => nothing */
    0,  /* CONST_FUNC => nothing */
    0,  /*       SEMI => nothing */
   30,  /*    EXPLAIN => ID */
   30,  /*      QUERY => ID */
   30,  /*       PLAN => ID */
   30,  /*      BEGIN => ID */
    0,  /* TRANSACTION => nothing */
   30,  /*   DEFERRED => ID */
   30,  /*  IMMEDIATE => ID */
   30,  /*  EXCLUSIVE => ID */
    0,  /*     COMMIT => nothing */
   30,  /*        END => ID */
    0,  /*   ROLLBACK => nothing */
    0,  /*     CREATE => nothing */
    0,  /*      TABLE => nothing */
   30,  /*       TEMP => ID */
    0,  /*         LP => nothing */
    0,  /*         RP => nothing */
    0,  /*         AS => nothing */
    0,  /*      COMMA => nothing */
    0,  /*         ID => nothing */
   30,  /*      ABORT => ID */
   30,  /*      AFTER => ID */
   30,  /*    ANALYZE => ID */
   30,  /*        ASC => ID */
   30,  /*     ATTACH => ID */
   30,  /*     BEFORE => ID */
   30,  /*    CASCADE => ID */
   30,  /*       CAST => ID */
   30,  /*   CONFLICT => ID */
   30,  /*   DATABASE => ID */
   30,  /*       DESC => ID */
   30,  /*     DETACH => ID */
   30,  /*       EACH => ID */
   30,  /*       FAIL => ID */
   30,  /*        FOR => ID */
   30,  /*     IGNORE => ID */
   30,  /*  INITIALLY => ID */
   30,  /*    INSTEAD => ID */
   30,  /*    LIKE_KW => ID */
   30,  /*      MATCH => ID */
   30,  /*        KEY => ID */
   30,  /*         OF => ID */
   30,  /*     OFFSET => ID */
   30,  /*     PRAGMA => ID */
   30,  /*      RAISE => ID */
   30,  /*    REPLACE => ID */
   30,  /*   RESTRICT => ID */
   30,  /*        ROW => ID */
   30,  /*  STATEMENT => ID */
   30,  /*    TRIGGER => ID */
   30,  /*     VACUUM => ID */
   30,  /*       VIEW => ID */
   30,  /*    REINDEX => ID */
   30,  /*     RENAME => ID */
   30,  /*   CTIME_KW => ID */
   30,  /*      ALTER => ID */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*        NOT => nothing */
    0,  /*         IS => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IN => nothing */
    0,  /*     ISNULL => nothing */
    0,  /*    NOTNULL => nothing */
    0,  /*         NE => nothing */
    0,  /*         EQ => nothing */
    0,  /*         GT => nothing */
    0,  /*         LE => nothing */
    0,  /*         LT => nothing */
    0,  /*         GE => nothing */
    0,  /*     ESCAPE => nothing */
    0,  /*     BITAND => nothing */
    0,  /*      BITOR => nothing */
    0,  /*     LSHIFT => nothing */
    0,  /*     RSHIFT => nothing */
    0,  /*       PLUS => nothing */
    0,  /*      MINUS => nothing */
    0,  /*       STAR => nothing */
    0,  /*      SLASH => nothing */
    0,  /*        REM => nothing */
    0,  /*     CONCAT => nothing */
    0,  /*     UMINUS => nothing */
    0,  /*      UPLUS => nothing */
    0,  /*     BITNOT => nothing */
    0,  /*     STRING => nothing */
    0,  /*    JOIN_KW => nothing */
    0,  /* CONSTRAINT => nothing */
    0,  /*    DEFAULT => nothing */
    0,  /*       NULL => nothing */
    0,  /*    PRIMARY => nothing */
    0,  /*     UNIQUE => nothing */
    0,  /*      CHECK => nothing */
    0,  /* REFERENCES => nothing */
    0,  /*    COLLATE => nothing */
    0,  /*   AUTOINCR => nothing */
    0,  /*         ON => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*        SET => nothing */
    0,  /* DEFERRABLE => nothing */
    0,  /*    FOREIGN => nothing */
    0,  /*       DROP => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*        DOT => nothing */
    0,  /*       FROM => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      USING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*         BY => nothing */
    0,  /*      GROUP => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*       INTO => nothing */
    0,  /*     VALUES => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*       BLOB => nothing */
    0,  /*   REGISTER => nothing */
    0,  /*   VARIABLE => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*         TO => nothing */
    0,  /*        ADD => nothing */
    0,  /*   COLUMNKW => nothing */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqlite3ParserARG_SDECL                /* A place to hold %extra_argument */
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3ParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "END_OF_FILE",   "ILLEGAL",       "SPACE",       
  "UNCLOSED_STRING",  "COMMENT",       "FUNCTION",      "COLUMN",      
  "AGG_FUNCTION",  "AGG_COLUMN",    "CONST_FUNC",    "SEMI",        
  "EXPLAIN",       "QUERY",         "PLAN",          "BEGIN",       
  "TRANSACTION",   "DEFERRED",      "IMMEDIATE",     "EXCLUSIVE",   
  "COMMIT",        "END",           "ROLLBACK",      "CREATE",      
  "TABLE",         "TEMP",          "LP",            "RP",          
  "AS",            "COMMA",         "ID",            "ABORT",       
  "AFTER",         "ANALYZE",       "ASC",           "ATTACH",      
  "BEFORE",        "CASCADE",       "CAST",          "CONFLICT",    
  "DATABASE",      "DESC",          "DETACH",        "EACH",        
  "FAIL",          "FOR",           "IGNORE",        "INITIALLY",   
  "INSTEAD",       "LIKE_KW",       "MATCH",         "KEY",         
  "OF",            "OFFSET",        "PRAGMA",        "RAISE",       
  "REPLACE",       "RESTRICT",      "ROW",           "STATEMENT",   
  "TRIGGER",       "VACUUM",        "VIEW",          "REINDEX",     
  "RENAME",        "CTIME_KW",      "ALTER",         "OR",          
  "AND",           "NOT",           "IS",            "BETWEEN",     
  "IN",            "ISNULL",        "NOTNULL",       "NE",          
  "EQ",            "GT",            "LE",            "LT",          
  "GE",            "ESCAPE",        "BITAND",        "BITOR",       
  "LSHIFT",        "RSHIFT",        "PLUS",          "MINUS",       
  "STAR",          "SLASH",         "REM",           "CONCAT",      
  "UMINUS",        "UPLUS",         "BITNOT",        "STRING",      
  "JOIN_KW",       "CONSTRAINT",    "DEFAULT",       "NULL",        
  "PRIMARY",       "UNIQUE",        "CHECK",         "REFERENCES",  
  "COLLATE",       "AUTOINCR",      "ON",            "DELETE",      
  "UPDATE",        "INSERT",        "SET",           "DEFERRABLE",  
  "FOREIGN",       "DROP",          "UNION",         "ALL",         
  "INTERSECT",     "EXCEPT",        "SELECT",        "DISTINCT",    
  "DOT",           "FROM",          "JOIN",          "USING",       
  "ORDER",         "BY",            "GROUP",         "HAVING",      
  "LIMIT",         "WHERE",         "INTO",          "VALUES",      
  "INTEGER",       "FLOAT",         "BLOB",          "REGISTER",    
  "VARIABLE",      "EXISTS",        "CASE",          "WHEN",        
  "THEN",          "ELSE",          "INDEX",         "TO",          
  "ADD",           "COLUMNKW",      "error",         "input",       
  "cmdlist",       "ecmd",          "cmdx",          "cmd",         
  "explain",       "transtype",     "trans_opt",     "nm",          
  "create_table",  "create_table_args",  "temp",          "dbnm",        
  "columnlist",    "conslist_opt",  "select",        "column",      
  "columnid",      "type",          "carglist",      "id",          
  "ids",           "typetoken",     "typename",      "signed",      
  "plus_num",      "minus_num",     "carg",          "ccons",       
  "term",          "expr",          "onconf",        "sortorder",   
  "autoinc",       "idxlist_opt",   "refargs",       "defer_subclause",
  "refarg",        "refact",        "init_deferred_pred_opt",  "conslist",    
  "tcons",         "idxlist",       "defer_subclause_opt",  "orconf",      
  "resolvetype",   "raisetype",     "fullname",      "oneselect",   
  "multiselect_op",  "distinct",      "selcollist",    "from",        
  "where_opt",     "groupby_opt",   "having_opt",    "orderby_opt", 
  "limit_opt",     "sclp",          "as",            "seltablist",  
  "stl_prefix",    "joinop",        "on_opt",        "using_opt",   
  "seltablist_paren",  "joinop2",       "inscollist",    "sortlist",    
  "sortitem",      "collate",       "exprlist",      "setlist",     
  "insert_cmd",    "inscollist_opt",  "itemlist",      "likeop",      
  "escape",        "between_op",    "in_op",         "case_operand",
  "case_exprlist",  "case_else",     "expritem",      "uniqueflag",  
  "idxitem",       "plus_opt",      "number",        "trigger_decl",
  "trigger_cmd_list",  "trigger_time",  "trigger_event",  "foreach_clause",
  "when_clause",   "trigger_cmd",   "database_kw_opt",  "key_opt",     
  "add_column_fullname",  "kwcolumn_opt",
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "cmdx ::= cmd",
 /*   4 */ "ecmd ::= SEMI",
 /*   5 */ "ecmd ::= explain cmdx SEMI",
 /*   6 */ "explain ::=",
 /*   7 */ "explain ::= EXPLAIN",
 /*   8 */ "explain ::= EXPLAIN QUERY PLAN",
 /*   9 */ "cmd ::= BEGIN transtype trans_opt",
 /*  10 */ "trans_opt ::=",
 /*  11 */ "trans_opt ::= TRANSACTION",
 /*  12 */ "trans_opt ::= TRANSACTION nm",
 /*  13 */ "transtype ::=",
 /*  14 */ "transtype ::= DEFERRED",
 /*  15 */ "transtype ::= IMMEDIATE",
 /*  16 */ "transtype ::= EXCLUSIVE",
 /*  17 */ "cmd ::= COMMIT trans_opt",
 /*  18 */ "cmd ::= END trans_opt",
 /*  19 */ "cmd ::= ROLLBACK trans_opt",
 /*  20 */ "cmd ::= create_table create_table_args",
 /*  21 */ "create_table ::= CREATE temp TABLE nm dbnm",
 /*  22 */ "temp ::= TEMP",
 /*  23 */ "temp ::=",
 /*  24 */ "create_table_args ::= LP columnlist conslist_opt RP",
 /*  25 */ "create_table_args ::= AS select",
 /*  26 */ "columnlist ::= columnlist COMMA column",
 /*  27 */ "columnlist ::= column",
 /*  28 */ "column ::= columnid type carglist",
 /*  29 */ "columnid ::= nm",
 /*  30 */ "id ::= ID",
 /*  31 */ "ids ::= ID",
 /*  32 */ "ids ::= STRING",
 /*  33 */ "nm ::= ID",
 /*  34 */ "nm ::= STRING",
 /*  35 */ "nm ::= JOIN_KW",
 /*  36 */ "type ::=",
 /*  37 */ "type ::= typetoken",
 /*  38 */ "typetoken ::= typename",
 /*  39 */ "typetoken ::= typename LP signed RP",
 /*  40 */ "typetoken ::= typename LP signed COMMA signed RP",
 /*  41 */ "typename ::= ids",
 /*  42 */ "typename ::= typename ids",
 /*  43 */ "signed ::= plus_num",
 /*  44 */ "signed ::= minus_num",
 /*  45 */ "carglist ::= carglist carg",
 /*  46 */ "carglist ::=",
 /*  47 */ "carg ::= CONSTRAINT nm ccons",
 /*  48 */ "carg ::= ccons",
 /*  49 */ "carg ::= DEFAULT term",
 /*  50 */ "carg ::= DEFAULT LP expr RP",
 /*  51 */ "carg ::= DEFAULT PLUS term",
 /*  52 */ "carg ::= DEFAULT MINUS term",
 /*  53 */ "carg ::= DEFAULT id",
 /*  54 */ "ccons ::= NULL onconf",
 /*  55 */ "ccons ::= NOT NULL onconf",
 /*  56 */ "ccons ::= PRIMARY KEY sortorder onconf autoinc",
 /*  57 */ "ccons ::= UNIQUE onconf",
 /*  58 */ "ccons ::= CHECK LP expr RP onconf",
 /*  59 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  60 */ "ccons ::= defer_subclause",
 /*  61 */ "ccons ::= COLLATE id",
 /*  62 */ "autoinc ::=",
 /*  63 */ "autoinc ::= AUTOINCR",
 /*  64 */ "refargs ::=",
 /*  65 */ "refargs ::= refargs refarg",
 /*  66 */ "refarg ::= MATCH nm",
 /*  67 */ "refarg ::= ON DELETE refact",
 /*  68 */ "refarg ::= ON UPDATE refact",
 /*  69 */ "refarg ::= ON INSERT refact",
 /*  70 */ "refact ::= SET NULL",
 /*  71 */ "refact ::= SET DEFAULT",
 /*  72 */ "refact ::= CASCADE",
 /*  73 */ "refact ::= RESTRICT",
 /*  74 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /*  75 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /*  76 */ "init_deferred_pred_opt ::=",
 /*  77 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /*  78 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /*  79 */ "conslist_opt ::=",
 /*  80 */ "conslist_opt ::= COMMA conslist",
 /*  81 */ "conslist ::= conslist COMMA tcons",
 /*  82 */ "conslist ::= conslist tcons",
 /*  83 */ "conslist ::= tcons",
 /*  84 */ "tcons ::= CONSTRAINT nm",
 /*  85 */ "tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf",
 /*  86 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /*  87 */ "tcons ::= CHECK expr onconf",
 /*  88 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /*  89 */ "defer_subclause_opt ::=",
 /*  90 */ "defer_subclause_opt ::= defer_subclause",
 /*  91 */ "onconf ::=",
 /*  92 */ "onconf ::= ON CONFLICT resolvetype",
 /*  93 */ "orconf ::=",
 /*  94 */ "orconf ::= OR resolvetype",
 /*  95 */ "resolvetype ::= raisetype",
 /*  96 */ "resolvetype ::= IGNORE",
 /*  97 */ "resolvetype ::= REPLACE",
 /*  98 */ "cmd ::= DROP TABLE fullname",
 /*  99 */ "cmd ::= CREATE temp VIEW nm dbnm AS select",
 /* 100 */ "cmd ::= DROP VIEW fullname",
 /* 101 */ "cmd ::= select",
 /* 102 */ "select ::= oneselect",
 /* 103 */ "select ::= select multiselect_op oneselect",
 /* 104 */ "multiselect_op ::= UNION",
 /* 105 */ "multiselect_op ::= UNION ALL",
 /* 106 */ "multiselect_op ::= INTERSECT",
 /* 107 */ "multiselect_op ::= EXCEPT",
 /* 108 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 109 */ "distinct ::= DISTINCT",
 /* 110 */ "distinct ::= ALL",
 /* 111 */ "distinct ::=",
 /* 112 */ "sclp ::= selcollist COMMA",
 /* 113 */ "sclp ::=",
 /* 114 */ "selcollist ::= sclp expr as",
 /* 115 */ "selcollist ::= sclp STAR",
 /* 116 */ "selcollist ::= sclp nm DOT STAR",
 /* 117 */ "as ::= AS nm",
 /* 118 */ "as ::= ids",
 /* 119 */ "as ::=",
 /* 120 */ "from ::=",
 /* 121 */ "from ::= FROM seltablist",
 /* 122 */ "stl_prefix ::= seltablist joinop",
 /* 123 */ "stl_prefix ::=",
 /* 124 */ "seltablist ::= stl_prefix nm dbnm as on_opt using_opt",
 /* 125 */ "seltablist ::= stl_prefix LP seltablist_paren RP as on_opt using_opt",
 /* 126 */ "seltablist_paren ::= select",
 /* 127 */ "seltablist_paren ::= seltablist",
 /* 128 */ "dbnm ::=",
 /* 129 */ "dbnm ::= DOT nm",
 /* 130 */ "fullname ::= nm dbnm",
 /* 131 */ "joinop ::= COMMA",
 /* 132 */ "joinop ::= JOIN",
 /* 133 */ "joinop ::= JOIN_KW JOIN",
 /* 134 */ "joinop ::= JOIN_KW nm JOIN",
 /* 135 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 136 */ "on_opt ::= ON expr",
 /* 137 */ "on_opt ::=",
 /* 138 */ "using_opt ::= USING LP inscollist RP",
 /* 139 */ "using_opt ::=",
 /* 140 */ "orderby_opt ::=",
 /* 141 */ "orderby_opt ::= ORDER BY sortlist",
 /* 142 */ "sortlist ::= sortlist COMMA sortitem collate sortorder",
 /* 143 */ "sortlist ::= sortitem collate sortorder",
 /* 144 */ "sortitem ::= expr",
 /* 145 */ "sortorder ::= ASC",
 /* 146 */ "sortorder ::= DESC",
 /* 147 */ "sortorder ::=",
 /* 148 */ "collate ::=",
 /* 149 */ "collate ::= COLLATE id",
 /* 150 */ "groupby_opt ::=",
 /* 151 */ "groupby_opt ::= GROUP BY exprlist",
 /* 152 */ "having_opt ::=",
 /* 153 */ "having_opt ::= HAVING expr",
 /* 154 */ "limit_opt ::=",
 /* 155 */ "limit_opt ::= LIMIT expr",
 /* 156 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /* 157 */ "limit_opt ::= LIMIT expr COMMA expr",
 /* 158 */ "cmd ::= DELETE FROM fullname where_opt",
 /* 159 */ "where_opt ::=",
 /* 160 */ "where_opt ::= WHERE expr",
 /* 161 */ "cmd ::= UPDATE orconf fullname SET setlist where_opt",
 /* 162 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 163 */ "setlist ::= nm EQ expr",
 /* 164 */ "cmd ::= insert_cmd INTO fullname inscollist_opt VALUES LP itemlist RP",
 /* 165 */ "cmd ::= insert_cmd INTO fullname inscollist_opt select",
 /* 166 */ "insert_cmd ::= INSERT orconf",
 /* 167 */ "insert_cmd ::= REPLACE",
 /* 168 */ "itemlist ::= itemlist COMMA expr",
 /* 169 */ "itemlist ::= expr",
 /* 170 */ "inscollist_opt ::=",
 /* 171 */ "inscollist_opt ::= LP inscollist RP",
 /* 172 */ "inscollist ::= inscollist COMMA nm",
 /* 173 */ "inscollist ::= nm",
 /* 174 */ "expr ::= term",
 /* 175 */ "expr ::= LP expr RP",
 /* 176 */ "term ::= NULL",
 /* 177 */ "expr ::= ID",
 /* 178 */ "expr ::= JOIN_KW",
 /* 179 */ "expr ::= nm DOT nm",
 /* 180 */ "expr ::= nm DOT nm DOT nm",
 /* 181 */ "term ::= INTEGER",
 /* 182 */ "term ::= FLOAT",
 /* 183 */ "term ::= STRING",
 /* 184 */ "term ::= BLOB",
 /* 185 */ "expr ::= REGISTER",
 /* 186 */ "expr ::= VARIABLE",
 /* 187 */ "expr ::= CAST LP expr AS typetoken RP",
 /* 188 */ "expr ::= ID LP distinct exprlist RP",
 /* 189 */ "expr ::= ID LP STAR RP",
 /* 190 */ "term ::= CTIME_KW",
 /* 191 */ "expr ::= expr AND expr",
 /* 192 */ "expr ::= expr OR expr",
 /* 193 */ "expr ::= expr LT expr",
 /* 194 */ "expr ::= expr GT expr",
 /* 195 */ "expr ::= expr LE expr",
 /* 196 */ "expr ::= expr GE expr",
 /* 197 */ "expr ::= expr NE expr",
 /* 198 */ "expr ::= expr EQ expr",
 /* 199 */ "expr ::= expr BITAND expr",
 /* 200 */ "expr ::= expr BITOR expr",
 /* 201 */ "expr ::= expr LSHIFT expr",
 /* 202 */ "expr ::= expr RSHIFT expr",
 /* 203 */ "expr ::= expr PLUS expr",
 /* 204 */ "expr ::= expr MINUS expr",
 /* 205 */ "expr ::= expr STAR expr",
 /* 206 */ "expr ::= expr SLASH expr",
 /* 207 */ "expr ::= expr REM expr",
 /* 208 */ "expr ::= expr CONCAT expr",
 /* 209 */ "likeop ::= LIKE_KW",
 /* 210 */ "likeop ::= NOT LIKE_KW",
 /* 211 */ "escape ::= ESCAPE expr",
 /* 212 */ "escape ::=",
 /* 213 */ "expr ::= expr likeop expr escape",
 /* 214 */ "expr ::= expr ISNULL",
 /* 215 */ "expr ::= expr IS NULL",
 /* 216 */ "expr ::= expr NOTNULL",
 /* 217 */ "expr ::= expr NOT NULL",
 /* 218 */ "expr ::= expr IS NOT NULL",
 /* 219 */ "expr ::= NOT expr",
 /* 220 */ "expr ::= BITNOT expr",
 /* 221 */ "expr ::= MINUS expr",
 /* 222 */ "expr ::= PLUS expr",
 /* 223 */ "between_op ::= BETWEEN",
 /* 224 */ "between_op ::= NOT BETWEEN",
 /* 225 */ "expr ::= expr between_op expr AND expr",
 /* 226 */ "in_op ::= IN",
 /* 227 */ "in_op ::= NOT IN",
 /* 228 */ "expr ::= expr in_op LP exprlist RP",
 /* 229 */ "expr ::= LP select RP",
 /* 230 */ "expr ::= expr in_op LP select RP",
 /* 231 */ "expr ::= expr in_op nm dbnm",
 /* 232 */ "expr ::= EXISTS LP select RP",
 /* 233 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 234 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 235 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 236 */ "case_else ::= ELSE expr",
 /* 237 */ "case_else ::=",
 /* 238 */ "case_operand ::= expr",
 /* 239 */ "case_operand ::=",
 /* 240 */ "exprlist ::= exprlist COMMA expritem",
 /* 241 */ "exprlist ::= expritem",
 /* 242 */ "expritem ::= expr",
 /* 243 */ "expritem ::=",
 /* 244 */ "cmd ::= CREATE uniqueflag INDEX nm dbnm ON nm LP idxlist RP onconf",
 /* 245 */ "uniqueflag ::= UNIQUE",
 /* 246 */ "uniqueflag ::=",
 /* 247 */ "idxlist_opt ::=",
 /* 248 */ "idxlist_opt ::= LP idxlist RP",
 /* 249 */ "idxlist ::= idxlist COMMA idxitem collate sortorder",
 /* 250 */ "idxlist ::= idxitem collate sortorder",
 /* 251 */ "idxitem ::= nm",
 /* 252 */ "cmd ::= DROP INDEX fullname",
 /* 253 */ "cmd ::= VACUUM",
 /* 254 */ "cmd ::= VACUUM nm",
 /* 255 */ "cmd ::= PRAGMA nm dbnm EQ nm",
 /* 256 */ "cmd ::= PRAGMA nm dbnm EQ ON",
 /* 257 */ "cmd ::= PRAGMA nm dbnm EQ plus_num",
 /* 258 */ "cmd ::= PRAGMA nm dbnm EQ minus_num",
 /* 259 */ "cmd ::= PRAGMA nm dbnm LP nm RP",
 /* 260 */ "cmd ::= PRAGMA nm dbnm",
 /* 261 */ "plus_num ::= plus_opt number",
 /* 262 */ "minus_num ::= MINUS number",
 /* 263 */ "number ::= INTEGER",
 /* 264 */ "number ::= FLOAT",
 /* 265 */ "plus_opt ::= PLUS",
 /* 266 */ "plus_opt ::=",
 /* 267 */ "cmd ::= CREATE trigger_decl BEGIN trigger_cmd_list END",
 /* 268 */ "trigger_decl ::= temp TRIGGER nm dbnm trigger_time trigger_event ON fullname foreach_clause when_clause",
 /* 269 */ "trigger_time ::= BEFORE",
 /* 270 */ "trigger_time ::= AFTER",
 /* 271 */ "trigger_time ::= INSTEAD OF",
 /* 272 */ "trigger_time ::=",
 /* 273 */ "trigger_event ::= DELETE",
 /* 274 */ "trigger_event ::= INSERT",
 /* 275 */ "trigger_event ::= UPDATE",
 /* 276 */ "trigger_event ::= UPDATE OF inscollist",
 /* 277 */ "foreach_clause ::=",
 /* 278 */ "foreach_clause ::= FOR EACH ROW",
 /* 279 */ "foreach_clause ::= FOR EACH STATEMENT",
 /* 280 */ "when_clause ::=",
 /* 281 */ "when_clause ::= WHEN expr",
 /* 282 */ "trigger_cmd_list ::= trigger_cmd SEMI trigger_cmd_list",
 /* 283 */ "trigger_cmd_list ::=",
 /* 284 */ "trigger_cmd ::= UPDATE orconf nm SET setlist where_opt",
 /* 285 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP",
 /* 286 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt select",
 /* 287 */ "trigger_cmd ::= DELETE FROM nm where_opt",
 /* 288 */ "trigger_cmd ::= select",
 /* 289 */ "expr ::= RAISE LP IGNORE RP",
 /* 290 */ "expr ::= RAISE LP raisetype COMMA nm RP",
 /* 291 */ "raisetype ::= ROLLBACK",
 /* 292 */ "raisetype ::= ABORT",
 /* 293 */ "raisetype ::= FAIL",
 /* 294 */ "cmd ::= DROP TRIGGER fullname",
 /* 295 */ "cmd ::= ATTACH database_kw_opt ids AS nm key_opt",
 /* 296 */ "key_opt ::=",
 /* 297 */ "key_opt ::= KEY ids",
 /* 298 */ "key_opt ::= KEY BLOB",
 /* 299 */ "database_kw_opt ::= DATABASE",
 /* 300 */ "database_kw_opt ::=",
 /* 301 */ "cmd ::= DETACH database_kw_opt nm",
 /* 302 */ "cmd ::= REINDEX",
 /* 303 */ "cmd ::= REINDEX nm dbnm",
 /* 304 */ "cmd ::= ANALYZE",
 /* 305 */ "cmd ::= ANALYZE nm dbnm",
 /* 306 */ "cmd ::= ALTER TABLE fullname RENAME TO nm",
 /* 307 */ "cmd ::= ALTER TABLE add_column_fullname ADD kwcolumn_opt column",
 /* 308 */ "add_column_fullname ::= fullname",
 /* 309 */ "kwcolumn_opt ::=",
 /* 310 */ "kwcolumn_opt ::= COLUMNKW",
};
#endif /* NDEBUG */

/*
** This function returns the symbolic name associated with a token
** value.
*/
const char *sqlite3ParserTokenName(int tokenType){
#ifndef NDEBUG
  if( tokenType>0 && tokenType<(sizeof(yyTokenName)/sizeof(yyTokenName[0])) ){
    return yyTokenName[tokenType];
  }else{
    return "Unknown";
  }
#else
  return "";
#endif
}

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqlite3Parser and sqlite3ParserFree.
*/
void *sqlite3ParserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 162:
    case 195:
    case 212:
#line 370 "parse.y"
{sqlite3SelectDelete((yypminor->yy375));}
#line 1344 "parse.c"
      break;
    case 176:
    case 177:
    case 200:
    case 202:
    case 210:
    case 216:
    case 230:
#line 629 "parse.y"
{sqlite3ExprDelete((yypminor->yy62));}
#line 1355 "parse.c"
      break;
    case 181:
    case 189:
    case 198:
    case 201:
    case 203:
    case 205:
    case 215:
    case 218:
    case 219:
    case 222:
    case 228:
#line 876 "parse.y"
{sqlite3ExprListDelete((yypminor->yy418));}
#line 1370 "parse.c"
      break;
    case 194:
    case 199:
    case 207:
    case 208:
#line 499 "parse.y"
{sqlite3SrcListDelete((yypminor->yy151));}
#line 1378 "parse.c"
      break;
    case 204:
#line 561 "parse.y"
{
  sqlite3ExprDelete((yypminor->yy220).pLimit);
  sqlite3ExprDelete((yypminor->yy220).pOffset);
}
#line 1386 "parse.c"
      break;
    case 211:
    case 214:
    case 221:
#line 517 "parse.y"
{sqlite3IdListDelete((yypminor->yy240));}
#line 1393 "parse.c"
      break;
    case 236:
    case 241:
#line 969 "parse.y"
{sqlite3DeleteTriggerStep((yypminor->yy360));}
#line 1399 "parse.c"
      break;
    case 238:
#line 953 "parse.y"
{sqlite3IdListDelete((yypminor->yy30).b);}
#line 1404 "parse.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor( yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqlite3ParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqlite3ParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
  (*freeProc)((void*)pParser);
}

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  /* if( pParser->yyidx<0 ) return YY_NO_ACTION;  */
  i = yy_shift_ofst[stateno];
  if( i==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
    int iFallback;            /* Fallback token */
    if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
           && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
           yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
      }
#endif
      return yy_find_shift_action(pParser, iFallback);
    }
#endif
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  /* int stateno = pParser->yystack[pParser->yyidx].stateno; */
 
  i = yy_reduce_ofst[stateno];
  if( i==YY_REDUCE_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
  if( yypParser->yyidx>=YYSTACKDEPTH ){
     sqlite3ParserARG_FETCH;
     yypParser->yyidx--;
#ifndef NDEBUG
     if( yyTraceFILE ){
       fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
     }
#endif
     while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
     /* Here code is inserted which will execute if the parser
     ** stack every overflows */
     sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument var */
     return;
  }
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 147, 1 },
  { 148, 2 },
  { 148, 1 },
  { 150, 1 },
  { 149, 1 },
  { 149, 3 },
  { 152, 0 },
  { 152, 1 },
  { 152, 3 },
  { 151, 3 },
  { 154, 0 },
  { 154, 1 },
  { 154, 2 },
  { 153, 0 },
  { 153, 1 },
  { 153, 1 },
  { 153, 1 },
  { 151, 2 },
  { 151, 2 },
  { 151, 2 },
  { 151, 2 },
  { 156, 5 },
  { 158, 1 },
  { 158, 0 },
  { 157, 4 },
  { 157, 2 },
  { 160, 3 },
  { 160, 1 },
  { 163, 3 },
  { 164, 1 },
  { 167, 1 },
  { 168, 1 },
  { 168, 1 },
  { 155, 1 },
  { 155, 1 },
  { 155, 1 },
  { 165, 0 },
  { 165, 1 },
  { 169, 1 },
  { 169, 4 },
  { 169, 6 },
  { 170, 1 },
  { 170, 2 },
  { 171, 1 },
  { 171, 1 },
  { 166, 2 },
  { 166, 0 },
  { 174, 3 },
  { 174, 1 },
  { 174, 2 },
  { 174, 4 },
  { 174, 3 },
  { 174, 3 },
  { 174, 2 },
  { 175, 2 },
  { 175, 3 },
  { 175, 5 },
  { 175, 2 },
  { 175, 5 },
  { 175, 4 },
  { 175, 1 },
  { 175, 2 },
  { 180, 0 },
  { 180, 1 },
  { 182, 0 },
  { 182, 2 },
  { 184, 2 },
  { 184, 3 },
  { 184, 3 },
  { 184, 3 },
  { 185, 2 },
  { 185, 2 },
  { 185, 1 },
  { 185, 1 },
  { 183, 3 },
  { 183, 2 },
  { 186, 0 },
  { 186, 2 },
  { 186, 2 },
  { 161, 0 },
  { 161, 2 },
  { 187, 3 },
  { 187, 2 },
  { 187, 1 },
  { 188, 2 },
  { 188, 7 },
  { 188, 5 },
  { 188, 3 },
  { 188, 10 },
  { 190, 0 },
  { 190, 1 },
  { 178, 0 },
  { 178, 3 },
  { 191, 0 },
  { 191, 2 },
  { 192, 1 },
  { 192, 1 },
  { 192, 1 },
  { 151, 3 },
  { 151, 7 },
  { 151, 3 },
  { 151, 1 },
  { 162, 1 },
  { 162, 3 },
  { 196, 1 },
  { 196, 2 },
  { 196, 1 },
  { 196, 1 },
  { 195, 9 },
  { 197, 1 },
  { 197, 1 },
  { 197, 0 },
  { 205, 2 },
  { 205, 0 },
  { 198, 3 },
  { 198, 2 },
  { 198, 4 },
  { 206, 2 },
  { 206, 1 },
  { 206, 0 },
  { 199, 0 },
  { 199, 2 },
  { 208, 2 },
  { 208, 0 },
  { 207, 6 },
  { 207, 7 },
  { 212, 1 },
  { 212, 1 },
  { 159, 0 },
  { 159, 2 },
  { 194, 2 },
  { 209, 1 },
  { 209, 1 },
  { 209, 2 },
  { 209, 3 },
  { 209, 4 },
  { 210, 2 },
  { 210, 0 },
  { 211, 4 },
  { 211, 0 },
  { 203, 0 },
  { 203, 3 },
  { 215, 5 },
  { 215, 3 },
  { 216, 1 },
  { 179, 1 },
  { 179, 1 },
  { 179, 0 },
  { 217, 0 },
  { 217, 2 },
  { 201, 0 },
  { 201, 3 },
  { 202, 0 },
  { 202, 2 },
  { 204, 0 },
  { 204, 2 },
  { 204, 4 },
  { 204, 4 },
  { 151, 4 },
  { 200, 0 },
  { 200, 2 },
  { 151, 6 },
  { 219, 5 },
  { 219, 3 },
  { 151, 8 },
  { 151, 5 },
  { 220, 2 },
  { 220, 1 },
  { 222, 3 },
  { 222, 1 },
  { 221, 0 },
  { 221, 3 },
  { 214, 3 },
  { 214, 1 },
  { 177, 1 },
  { 177, 3 },
  { 176, 1 },
  { 177, 1 },
  { 177, 1 },
  { 177, 3 },
  { 177, 5 },
  { 176, 1 },
  { 176, 1 },
  { 176, 1 },
  { 176, 1 },
  { 177, 1 },
  { 177, 1 },
  { 177, 6 },
  { 177, 5 },
  { 177, 4 },
  { 176, 1 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 177, 3 },
  { 223, 1 },
  { 223, 2 },
  { 224, 2 },
  { 224, 0 },
  { 177, 4 },
  { 177, 2 },
  { 177, 3 },
  { 177, 2 },
  { 177, 3 },
  { 177, 4 },
  { 177, 2 },
  { 177, 2 },
  { 177, 2 },
  { 177, 2 },
  { 225, 1 },
  { 225, 2 },
  { 177, 5 },
  { 226, 1 },
  { 226, 2 },
  { 177, 5 },
  { 177, 3 },
  { 177, 5 },
  { 177, 4 },
  { 177, 4 },
  { 177, 5 },
  { 228, 5 },
  { 228, 4 },
  { 229, 2 },
  { 229, 0 },
  { 227, 1 },
  { 227, 0 },
  { 218, 3 },
  { 218, 1 },
  { 230, 1 },
  { 230, 0 },
  { 151, 11 },
  { 231, 1 },
  { 231, 0 },
  { 181, 0 },
  { 181, 3 },
  { 189, 5 },
  { 189, 3 },
  { 232, 1 },
  { 151, 3 },
  { 151, 1 },
  { 151, 2 },
  { 151, 5 },
  { 151, 5 },
  { 151, 5 },
  { 151, 5 },
  { 151, 6 },
  { 151, 3 },
  { 172, 2 },
  { 173, 2 },
  { 234, 1 },
  { 234, 1 },
  { 233, 1 },
  { 233, 0 },
  { 151, 5 },
  { 235, 10 },
  { 237, 1 },
  { 237, 1 },
  { 237, 2 },
  { 237, 0 },
  { 238, 1 },
  { 238, 1 },
  { 238, 1 },
  { 238, 3 },
  { 239, 0 },
  { 239, 3 },
  { 239, 3 },
  { 240, 0 },
  { 240, 2 },
  { 236, 3 },
  { 236, 0 },
  { 241, 6 },
  { 241, 8 },
  { 241, 5 },
  { 241, 4 },
  { 241, 1 },
  { 177, 4 },
  { 177, 6 },
  { 193, 1 },
  { 193, 1 },
  { 193, 1 },
  { 151, 3 },
  { 151, 6 },
  { 243, 0 },
  { 243, 2 },
  { 243, 2 },
  { 242, 1 },
  { 242, 0 },
  { 151, 3 },
  { 151, 1 },
  { 151, 3 },
  { 151, 1 },
  { 151, 3 },
  { 151, 6 },
  { 151, 6 },
  { 244, 1 },
  { 245, 0 },
  { 245, 1 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqlite3ParserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<sizeof(yyRuleName)/sizeof(yyRuleName[0]) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

#ifndef NDEBUG
  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  */
  memset(&yygotominor, 0, sizeof(yygotominor));
#endif

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 3:
#line 102 "parse.y"
{ sqlite3FinishCoding(pParse); }
#line 1942 "parse.c"
        break;
      case 6:
#line 105 "parse.y"
{ sqlite3BeginParse(pParse, 0); }
#line 1947 "parse.c"
        break;
      case 7:
#line 107 "parse.y"
{ sqlite3BeginParse(pParse, 1); }
#line 1952 "parse.c"
        break;
      case 8:
#line 108 "parse.y"
{ sqlite3BeginParse(pParse, 2); }
#line 1957 "parse.c"
        break;
      case 9:
#line 114 "parse.y"
{sqlite3BeginTransaction(pParse, yymsp[-1].minor.yy280);}
#line 1962 "parse.c"
        break;
      case 13:
#line 119 "parse.y"
{yygotominor.yy280 = TK_DEFERRED;}
#line 1967 "parse.c"
        break;
      case 14:
      case 15:
      case 16:
      case 104:
      case 106:
      case 107:
#line 120 "parse.y"
{yygotominor.yy280 = yymsp[0].major;}
#line 1977 "parse.c"
        break;
      case 17:
      case 18:
#line 123 "parse.y"
{sqlite3CommitTransaction(pParse);}
#line 1983 "parse.c"
        break;
      case 19:
#line 125 "parse.y"
{sqlite3RollbackTransaction(pParse);}
#line 1988 "parse.c"
        break;
      case 21:
#line 130 "parse.y"
{
   sqlite3StartTable(pParse,&yymsp[-4].minor.yy0,&yymsp[-1].minor.yy198,&yymsp[0].minor.yy198,yymsp[-3].minor.yy280,0);
}
#line 1995 "parse.c"
        break;
      case 22:
      case 63:
      case 77:
      case 109:
      case 224:
      case 227:
#line 135 "parse.y"
{yygotominor.yy280 = 1;}
#line 2005 "parse.c"
        break;
      case 23:
      case 62:
      case 76:
      case 78:
      case 89:
      case 110:
      case 111:
      case 223:
      case 226:
#line 137 "parse.y"
{yygotominor.yy280 = 0;}
#line 2018 "parse.c"
        break;
      case 24:
#line 138 "parse.y"
{
  sqlite3EndTable(pParse,&yymsp[-1].minor.yy198,&yymsp[0].minor.yy0,0);
}
#line 2025 "parse.c"
        break;
      case 25:
#line 141 "parse.y"
{
  sqlite3EndTable(pParse,0,0,yymsp[0].minor.yy375);
  sqlite3SelectDelete(yymsp[0].minor.yy375);
}
#line 2033 "parse.c"
        break;
      case 28:
#line 153 "parse.y"
{
  yygotominor.yy198.z = yymsp[-2].minor.yy198.z;
  yygotominor.yy198.n = (pParse->sLastToken.z-yymsp[-2].minor.yy198.z) + pParse->sLastToken.n;
}
#line 2041 "parse.c"
        break;
      case 29:
#line 157 "parse.y"
{
  sqlite3AddColumn(pParse,&yymsp[0].minor.yy198);
  yygotominor.yy198 = yymsp[0].minor.yy198;
}
#line 2049 "parse.c"
        break;
      case 30:
      case 31:
      case 32:
      case 33:
      case 34:
      case 35:
      case 263:
      case 264:
#line 167 "parse.y"
{yygotominor.yy198 = yymsp[0].minor.yy0;}
#line 2061 "parse.c"
        break;
      case 37:
#line 227 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[0].minor.yy198);}
#line 2066 "parse.c"
        break;
      case 38:
      case 41:
      case 117:
      case 118:
      case 129:
      case 149:
      case 251:
      case 261:
      case 262:
#line 228 "parse.y"
{yygotominor.yy198 = yymsp[0].minor.yy198;}
#line 2079 "parse.c"
        break;
      case 39:
#line 229 "parse.y"
{
  yygotominor.yy198.z = yymsp[-3].minor.yy198.z;
  yygotominor.yy198.n = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-3].minor.yy198.z;
}
#line 2087 "parse.c"
        break;
      case 40:
#line 233 "parse.y"
{
  yygotominor.yy198.z = yymsp[-5].minor.yy198.z;
  yygotominor.yy198.n = &yymsp[0].minor.yy0.z[yymsp[0].minor.yy0.n] - yymsp[-5].minor.yy198.z;
}
#line 2095 "parse.c"
        break;
      case 42:
#line 239 "parse.y"
{yygotominor.yy198.z=yymsp[-1].minor.yy198.z; yygotominor.yy198.n=yymsp[0].minor.yy198.n+(yymsp[0].minor.yy198.z-yymsp[-1].minor.yy198.z);}
#line 2100 "parse.c"
        break;
      case 43:
#line 241 "parse.y"
{ yygotominor.yy280 = atoi(yymsp[0].minor.yy198.z); }
#line 2105 "parse.c"
        break;
      case 44:
#line 242 "parse.y"
{ yygotominor.yy280 = -atoi(yymsp[0].minor.yy198.z); }
#line 2110 "parse.c"
        break;
      case 49:
      case 51:
#line 251 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[0].minor.yy62);}
#line 2116 "parse.c"
        break;
      case 50:
#line 252 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[-1].minor.yy62);}
#line 2121 "parse.c"
        break;
      case 52:
#line 254 "parse.y"
{
  Expr *p = sqlite3Expr(TK_UMINUS, yymsp[0].minor.yy62, 0, 0);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2129 "parse.c"
        break;
      case 53:
#line 258 "parse.y"
{
  Expr *p = sqlite3Expr(TK_STRING, 0, 0, &yymsp[0].minor.yy198);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2137 "parse.c"
        break;
      case 55:
#line 267 "parse.y"
{sqlite3AddNotNull(pParse, yymsp[0].minor.yy280);}
#line 2142 "parse.c"
        break;
      case 56:
#line 269 "parse.y"
{sqlite3AddPrimaryKey(pParse,0,yymsp[-1].minor.yy280,yymsp[0].minor.yy280);}
#line 2147 "parse.c"
        break;
      case 57:
#line 270 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,0,yymsp[0].minor.yy280,0,0);}
#line 2152 "parse.c"
        break;
      case 58:
#line 271 "parse.y"
{sqlite3ExprDelete(yymsp[-2].minor.yy62);}
#line 2157 "parse.c"
        break;
      case 59:
#line 273 "parse.y"
{sqlite3CreateForeignKey(pParse,0,&yymsp[-2].minor.yy198,yymsp[-1].minor.yy418,yymsp[0].minor.yy280);}
#line 2162 "parse.c"
        break;
      case 60:
#line 274 "parse.y"
{sqlite3DeferForeignKey(pParse,yymsp[0].minor.yy280);}
#line 2167 "parse.c"
        break;
      case 61:
#line 275 "parse.y"
{sqlite3AddCollateType(pParse, yymsp[0].minor.yy198.z, yymsp[0].minor.yy198.n);}
#line 2172 "parse.c"
        break;
      case 64:
#line 288 "parse.y"
{ yygotominor.yy280 = OE_Restrict * 0x010101; }
#line 2177 "parse.c"
        break;
      case 65:
#line 289 "parse.y"
{ yygotominor.yy280 = (yymsp[-1].minor.yy280 & yymsp[0].minor.yy359.mask) | yymsp[0].minor.yy359.value; }
#line 2182 "parse.c"
        break;
      case 66:
#line 291 "parse.y"
{ yygotominor.yy359.value = 0;     yygotominor.yy359.mask = 0x000000; }
#line 2187 "parse.c"
        break;
      case 67:
#line 292 "parse.y"
{ yygotominor.yy359.value = yymsp[0].minor.yy280;     yygotominor.yy359.mask = 0x0000ff; }
#line 2192 "parse.c"
        break;
      case 68:
#line 293 "parse.y"
{ yygotominor.yy359.value = yymsp[0].minor.yy280<<8;  yygotominor.yy359.mask = 0x00ff00; }
#line 2197 "parse.c"
        break;
      case 69:
#line 294 "parse.y"
{ yygotominor.yy359.value = yymsp[0].minor.yy280<<16; yygotominor.yy359.mask = 0xff0000; }
#line 2202 "parse.c"
        break;
      case 70:
#line 296 "parse.y"
{ yygotominor.yy280 = OE_SetNull; }
#line 2207 "parse.c"
        break;
      case 71:
#line 297 "parse.y"
{ yygotominor.yy280 = OE_SetDflt; }
#line 2212 "parse.c"
        break;
      case 72:
#line 298 "parse.y"
{ yygotominor.yy280 = OE_Cascade; }
#line 2217 "parse.c"
        break;
      case 73:
#line 299 "parse.y"
{ yygotominor.yy280 = OE_Restrict; }
#line 2222 "parse.c"
        break;
      case 74:
      case 75:
      case 90:
      case 92:
      case 94:
      case 95:
      case 166:
#line 301 "parse.y"
{yygotominor.yy280 = yymsp[0].minor.yy280;}
#line 2233 "parse.c"
        break;
      case 79:
#line 311 "parse.y"
{yygotominor.yy198.n = 0; yygotominor.yy198.z = 0;}
#line 2238 "parse.c"
        break;
      case 80:
#line 312 "parse.y"
{yygotominor.yy198 = yymsp[-1].minor.yy0;}
#line 2243 "parse.c"
        break;
      case 85:
#line 318 "parse.y"
{sqlite3AddPrimaryKey(pParse,yymsp[-3].minor.yy418,yymsp[0].minor.yy280,yymsp[-2].minor.yy280);}
#line 2248 "parse.c"
        break;
      case 86:
#line 320 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,yymsp[-2].minor.yy418,yymsp[0].minor.yy280,0,0);}
#line 2253 "parse.c"
        break;
      case 88:
#line 323 "parse.y"
{
    sqlite3CreateForeignKey(pParse, yymsp[-6].minor.yy418, &yymsp[-3].minor.yy198, yymsp[-2].minor.yy418, yymsp[-1].minor.yy280);
    sqlite3DeferForeignKey(pParse, yymsp[0].minor.yy280);
}
#line 2261 "parse.c"
        break;
      case 91:
      case 93:
#line 337 "parse.y"
{yygotominor.yy280 = OE_Default;}
#line 2267 "parse.c"
        break;
      case 96:
#line 342 "parse.y"
{yygotominor.yy280 = OE_Ignore;}
#line 2272 "parse.c"
        break;
      case 97:
      case 167:
#line 343 "parse.y"
{yygotominor.yy280 = OE_Replace;}
#line 2278 "parse.c"
        break;
      case 98:
#line 347 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy151, 0);
}
#line 2285 "parse.c"
        break;
      case 99:
#line 354 "parse.y"
{
  sqlite3CreateView(pParse, &yymsp[-6].minor.yy0, &yymsp[-3].minor.yy198, &yymsp[-2].minor.yy198, yymsp[0].minor.yy375, yymsp[-5].minor.yy280);
}
#line 2292 "parse.c"
        break;
      case 100:
#line 357 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy151, 1);
}
#line 2299 "parse.c"
        break;
      case 101:
#line 364 "parse.y"
{
  sqlite3Select(pParse, yymsp[0].minor.yy375, SRT_Callback, 0, 0, 0, 0, 0);
  sqlite3SelectDelete(yymsp[0].minor.yy375);
}
#line 2307 "parse.c"
        break;
      case 102:
      case 126:
#line 374 "parse.y"
{yygotominor.yy375 = yymsp[0].minor.yy375;}
#line 2313 "parse.c"
        break;
      case 103:
#line 376 "parse.y"
{
  if( yymsp[0].minor.yy375 ){
    yymsp[0].minor.yy375->op = yymsp[-1].minor.yy280;
    yymsp[0].minor.yy375->pPrior = yymsp[-2].minor.yy375;
  }
  yygotominor.yy375 = yymsp[0].minor.yy375;
}
#line 2324 "parse.c"
        break;
      case 105:
#line 385 "parse.y"
{yygotominor.yy280 = TK_ALL;}
#line 2329 "parse.c"
        break;
      case 108:
#line 390 "parse.y"
{
  yygotominor.yy375 = sqlite3SelectNew(yymsp[-6].minor.yy418,yymsp[-5].minor.yy151,yymsp[-4].minor.yy62,yymsp[-3].minor.yy418,yymsp[-2].minor.yy62,yymsp[-1].minor.yy418,yymsp[-7].minor.yy280,yymsp[0].minor.yy220.pLimit,yymsp[0].minor.yy220.pOffset);
}
#line 2336 "parse.c"
        break;
      case 112:
      case 248:
#line 411 "parse.y"
{yygotominor.yy418 = yymsp[-1].minor.yy418;}
#line 2342 "parse.c"
        break;
      case 113:
      case 140:
      case 150:
      case 247:
#line 412 "parse.y"
{yygotominor.yy418 = 0;}
#line 2350 "parse.c"
        break;
      case 114:
#line 413 "parse.y"
{
   yygotominor.yy418 = sqlite3ExprListAppend(yymsp[-2].minor.yy418,yymsp[-1].minor.yy62,yymsp[0].minor.yy198.n?&yymsp[0].minor.yy198:0);
}
#line 2357 "parse.c"
        break;
      case 115:
#line 416 "parse.y"
{
  yygotominor.yy418 = sqlite3ExprListAppend(yymsp[-1].minor.yy418, sqlite3Expr(TK_ALL, 0, 0, 0), 0);
}
#line 2364 "parse.c"
        break;
      case 116:
#line 419 "parse.y"
{
  Expr *pRight = sqlite3Expr(TK_ALL, 0, 0, 0);
  Expr *pLeft = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy198);
  yygotominor.yy418 = sqlite3ExprListAppend(yymsp[-3].minor.yy418, sqlite3Expr(TK_DOT, pLeft, pRight, 0), 0);
}
#line 2373 "parse.c"
        break;
      case 119:
#line 431 "parse.y"
{yygotominor.yy198.n = 0;}
#line 2378 "parse.c"
        break;
      case 120:
#line 443 "parse.y"
{yygotominor.yy151 = sqliteMalloc(sizeof(*yygotominor.yy151));}
#line 2383 "parse.c"
        break;
      case 121:
#line 444 "parse.y"
{yygotominor.yy151 = yymsp[0].minor.yy151;}
#line 2388 "parse.c"
        break;
      case 122:
#line 449 "parse.y"
{
   yygotominor.yy151 = yymsp[-1].minor.yy151;
   if( yygotominor.yy151 && yygotominor.yy151->nSrc>0 ) yygotominor.yy151->a[yygotominor.yy151->nSrc-1].jointype = yymsp[0].minor.yy280;
}
#line 2396 "parse.c"
        break;
      case 123:
#line 453 "parse.y"
{yygotominor.yy151 = 0;}
#line 2401 "parse.c"
        break;
      case 124:
#line 454 "parse.y"
{
  yygotominor.yy151 = sqlite3SrcListAppend(yymsp[-5].minor.yy151,&yymsp[-4].minor.yy198,&yymsp[-3].minor.yy198);
  if( yymsp[-2].minor.yy198.n ) sqlite3SrcListAddAlias(yygotominor.yy151,&yymsp[-2].minor.yy198);
  if( yymsp[-1].minor.yy62 ){
    if( yygotominor.yy151 && yygotominor.yy151->nSrc>1 ){ yygotominor.yy151->a[yygotominor.yy151->nSrc-2].pOn = yymsp[-1].minor.yy62; }
    else { sqlite3ExprDelete(yymsp[-1].minor.yy62); }
  }
  if( yymsp[0].minor.yy240 ){
    if( yygotominor.yy151 && yygotominor.yy151->nSrc>1 ){ yygotominor.yy151->a[yygotominor.yy151->nSrc-2].pUsing = yymsp[0].minor.yy240; }
    else { sqlite3IdListDelete(yymsp[0].minor.yy240); }
  }
}
#line 2417 "parse.c"
        break;
      case 125:
#line 468 "parse.y"
{
    yygotominor.yy151 = sqlite3SrcListAppend(yymsp[-6].minor.yy151,0,0);
    yygotominor.yy151->a[yygotominor.yy151->nSrc-1].pSelect = yymsp[-4].minor.yy375;
    if( yymsp[-2].minor.yy198.n ) sqlite3SrcListAddAlias(yygotominor.yy151,&yymsp[-2].minor.yy198);
    if( yymsp[-1].minor.yy62 ){
      if( yygotominor.yy151 && yygotominor.yy151->nSrc>1 ){ yygotominor.yy151->a[yygotominor.yy151->nSrc-2].pOn = yymsp[-1].minor.yy62; }
      else { sqlite3ExprDelete(yymsp[-1].minor.yy62); }
    }
    if( yymsp[0].minor.yy240 ){
      if( yygotominor.yy151 && yygotominor.yy151->nSrc>1 ){ yygotominor.yy151->a[yygotominor.yy151->nSrc-2].pUsing = yymsp[0].minor.yy240; }
      else { sqlite3IdListDelete(yymsp[0].minor.yy240); }
    }
  }
#line 2434 "parse.c"
        break;
      case 127:
#line 489 "parse.y"
{
     yygotominor.yy375 = sqlite3SelectNew(0,yymsp[0].minor.yy151,0,0,0,0,0,0,0);
  }
#line 2441 "parse.c"
        break;
      case 128:
#line 495 "parse.y"
{yygotominor.yy198.z=0; yygotominor.yy198.n=0;}
#line 2446 "parse.c"
        break;
      case 130:
#line 500 "parse.y"
{yygotominor.yy151 = sqlite3SrcListAppend(0,&yymsp[-1].minor.yy198,&yymsp[0].minor.yy198);}
#line 2451 "parse.c"
        break;
      case 131:
      case 132:
#line 504 "parse.y"
{ yygotominor.yy280 = JT_INNER; }
#line 2457 "parse.c"
        break;
      case 133:
#line 506 "parse.y"
{ yygotominor.yy280 = sqlite3JoinType(pParse,&yymsp[-1].minor.yy0,0,0); }
#line 2462 "parse.c"
        break;
      case 134:
#line 507 "parse.y"
{ yygotominor.yy280 = sqlite3JoinType(pParse,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy198,0); }
#line 2467 "parse.c"
        break;
      case 135:
#line 509 "parse.y"
{ yygotominor.yy280 = sqlite3JoinType(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy198,&yymsp[-1].minor.yy198); }
#line 2472 "parse.c"
        break;
      case 136:
      case 144:
      case 153:
      case 160:
      case 174:
      case 211:
      case 236:
      case 238:
      case 242:
#line 513 "parse.y"
{yygotominor.yy62 = yymsp[0].minor.yy62;}
#line 2485 "parse.c"
        break;
      case 137:
      case 152:
      case 159:
      case 212:
      case 237:
      case 239:
      case 243:
#line 514 "parse.y"
{yygotominor.yy62 = 0;}
#line 2496 "parse.c"
        break;
      case 138:
      case 171:
#line 518 "parse.y"
{yygotominor.yy240 = yymsp[-1].minor.yy240;}
#line 2502 "parse.c"
        break;
      case 139:
      case 170:
#line 519 "parse.y"
{yygotominor.yy240 = 0;}
#line 2508 "parse.c"
        break;
      case 141:
      case 151:
#line 530 "parse.y"
{yygotominor.yy418 = yymsp[0].minor.yy418;}
#line 2514 "parse.c"
        break;
      case 142:
#line 531 "parse.y"
{
  yygotominor.yy418 = sqlite3ExprListAppend(yymsp[-4].minor.yy418,yymsp[-2].minor.yy62,yymsp[-1].minor.yy198.n>0?&yymsp[-1].minor.yy198:0);
  if( yygotominor.yy418 ) yygotominor.yy418->a[yygotominor.yy418->nExpr-1].sortOrder = yymsp[0].minor.yy280;
}
#line 2522 "parse.c"
        break;
      case 143:
#line 535 "parse.y"
{
  yygotominor.yy418 = sqlite3ExprListAppend(0,yymsp[-2].minor.yy62,yymsp[-1].minor.yy198.n>0?&yymsp[-1].minor.yy198:0);
  if( yygotominor.yy418 && yygotominor.yy418->a ) yygotominor.yy418->a[0].sortOrder = yymsp[0].minor.yy280;
}
#line 2530 "parse.c"
        break;
      case 145:
      case 147:
#line 544 "parse.y"
{yygotominor.yy280 = SQLITE_SO_ASC;}
#line 2536 "parse.c"
        break;
      case 146:
#line 545 "parse.y"
{yygotominor.yy280 = SQLITE_SO_DESC;}
#line 2541 "parse.c"
        break;
      case 148:
#line 547 "parse.y"
{yygotominor.yy198.z = 0; yygotominor.yy198.n = 0;}
#line 2546 "parse.c"
        break;
      case 154:
#line 565 "parse.y"
{yygotominor.yy220.pLimit = 0; yygotominor.yy220.pOffset = 0;}
#line 2551 "parse.c"
        break;
      case 155:
#line 566 "parse.y"
{yygotominor.yy220.pLimit = yymsp[0].minor.yy62; yygotominor.yy220.pOffset = 0;}
#line 2556 "parse.c"
        break;
      case 156:
#line 568 "parse.y"
{yygotominor.yy220.pLimit = yymsp[-2].minor.yy62; yygotominor.yy220.pOffset = yymsp[0].minor.yy62;}
#line 2561 "parse.c"
        break;
      case 157:
#line 570 "parse.y"
{yygotominor.yy220.pOffset = yymsp[-2].minor.yy62; yygotominor.yy220.pLimit = yymsp[0].minor.yy62;}
#line 2566 "parse.c"
        break;
      case 158:
#line 574 "parse.y"
{sqlite3DeleteFrom(pParse,yymsp[-1].minor.yy151,yymsp[0].minor.yy62);}
#line 2571 "parse.c"
        break;
      case 161:
#line 585 "parse.y"
{sqlite3Update(pParse,yymsp[-3].minor.yy151,yymsp[-1].minor.yy418,yymsp[0].minor.yy62,yymsp[-4].minor.yy280);}
#line 2576 "parse.c"
        break;
      case 162:
#line 591 "parse.y"
{yygotominor.yy418 = sqlite3ExprListAppend(yymsp[-4].minor.yy418,yymsp[0].minor.yy62,&yymsp[-2].minor.yy198);}
#line 2581 "parse.c"
        break;
      case 163:
#line 592 "parse.y"
{yygotominor.yy418 = sqlite3ExprListAppend(0,yymsp[0].minor.yy62,&yymsp[-2].minor.yy198);}
#line 2586 "parse.c"
        break;
      case 164:
#line 598 "parse.y"
{sqlite3Insert(pParse, yymsp[-5].minor.yy151, yymsp[-1].minor.yy418, 0, yymsp[-4].minor.yy240, yymsp[-7].minor.yy280);}
#line 2591 "parse.c"
        break;
      case 165:
#line 600 "parse.y"
{sqlite3Insert(pParse, yymsp[-2].minor.yy151, 0, yymsp[0].minor.yy375, yymsp[-1].minor.yy240, yymsp[-4].minor.yy280);}
#line 2596 "parse.c"
        break;
      case 168:
      case 240:
#line 610 "parse.y"
{yygotominor.yy418 = sqlite3ExprListAppend(yymsp[-2].minor.yy418,yymsp[0].minor.yy62,0);}
#line 2602 "parse.c"
        break;
      case 169:
      case 241:
#line 611 "parse.y"
{yygotominor.yy418 = sqlite3ExprListAppend(0,yymsp[0].minor.yy62,0);}
#line 2608 "parse.c"
        break;
      case 172:
#line 620 "parse.y"
{yygotominor.yy240 = sqlite3IdListAppend(yymsp[-2].minor.yy240,&yymsp[0].minor.yy198);}
#line 2613 "parse.c"
        break;
      case 173:
#line 621 "parse.y"
{yygotominor.yy240 = sqlite3IdListAppend(0,&yymsp[0].minor.yy198);}
#line 2618 "parse.c"
        break;
      case 175:
#line 632 "parse.y"
{yygotominor.yy62 = yymsp[-1].minor.yy62; sqlite3ExprSpan(yygotominor.yy62,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0); }
#line 2623 "parse.c"
        break;
      case 176:
      case 181:
      case 182:
      case 183:
      case 184:
#line 633 "parse.y"
{yygotominor.yy62 = sqlite3Expr(yymsp[0].major, 0, 0, &yymsp[0].minor.yy0);}
#line 2632 "parse.c"
        break;
      case 177:
      case 178:
#line 634 "parse.y"
{yygotominor.yy62 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 2638 "parse.c"
        break;
      case 179:
#line 636 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy198);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy198);
  yygotominor.yy62 = sqlite3Expr(TK_DOT, temp1, temp2, 0);
}
#line 2647 "parse.c"
        break;
      case 180:
#line 641 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-4].minor.yy198);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy198);
  Expr *temp3 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy198);
  Expr *temp4 = sqlite3Expr(TK_DOT, temp2, temp3, 0);
  yygotominor.yy62 = sqlite3Expr(TK_DOT, temp1, temp4, 0);
}
#line 2658 "parse.c"
        break;
      case 185:
#line 652 "parse.y"
{yygotominor.yy62 = sqlite3RegisterExpr(pParse, &yymsp[0].minor.yy0);}
#line 2663 "parse.c"
        break;
      case 186:
#line 653 "parse.y"
{
  Token *pToken = &yymsp[0].minor.yy0;
  Expr *pExpr = yygotominor.yy62 = sqlite3Expr(TK_VARIABLE, 0, 0, pToken);
  sqlite3ExprAssignVarNumber(pParse, pExpr);
}
#line 2672 "parse.c"
        break;
      case 187:
#line 659 "parse.y"
{
  yygotominor.yy62 = sqlite3Expr(TK_CAST, yymsp[-3].minor.yy62, 0, &yymsp[-1].minor.yy198);
  sqlite3ExprSpan(yygotominor.yy62,&yymsp[-5].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2680 "parse.c"
        break;
      case 188:
#line 664 "parse.y"
{
  yygotominor.yy62 = sqlite3ExprFunction(yymsp[-1].minor.yy418, &yymsp[-4].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy62,&yymsp[-4].minor.yy0,&yymsp[0].minor.yy0);
  if( yymsp[-2].minor.yy280 ){
    yygotominor.yy62->flags |= EP_Distinct;
  }
}
#line 2691 "parse.c"
        break;
      case 189:
#line 671 "parse.y"
{
  yygotominor.yy62 = sqlite3ExprFunction(0, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy62,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2699 "parse.c"
        break;
      case 190:
#line 675 "parse.y"
{
  /* The CURRENT_TIME, CURRENT_DATE, and CURRENT_TIMESTAMP values are
  ** treated as functions that return constants */
  yygotominor.yy62 = sqlite3ExprFunction(0,&yymsp[0].minor.yy0);
  if( yygotominor.yy62 ) yygotominor.yy62->op = TK_CONST_FUNC;  
}
#line 2709 "parse.c"
        break;
      case 191:
      case 192:
      case 193:
      case 194:
      case 195:
      case 196:
      case 197:
      case 198:
      case 199:
      case 200:
      case 201:
      case 202:
      case 203:
      case 204:
      case 205:
      case 206:
      case 207:
      case 208:
#line 681 "parse.y"
{yygotominor.yy62 = sqlite3Expr(yymsp[-1].major, yymsp[-2].minor.yy62, yymsp[0].minor.yy62, 0);}
#line 2731 "parse.c"
        break;
      case 209:
#line 700 "parse.y"
{yygotominor.yy222.operator = yymsp[0].minor.yy0; yygotominor.yy222.not = 0;}
#line 2736 "parse.c"
        break;
      case 210:
#line 701 "parse.y"
{yygotominor.yy222.operator = yymsp[0].minor.yy0; yygotominor.yy222.not = 1;}
#line 2741 "parse.c"
        break;
      case 213:
#line 705 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(0, yymsp[-1].minor.yy62, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[-3].minor.yy62, 0);
  if( yymsp[0].minor.yy62 ){
    pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy62, 0);
  }
  yygotominor.yy62 = sqlite3ExprFunction(pList, &yymsp[-2].minor.yy222.operator);
  if( yymsp[-2].minor.yy222.not ) yygotominor.yy62 = sqlite3Expr(TK_NOT, yygotominor.yy62, 0, 0);
  sqlite3ExprSpan(yygotominor.yy62, &yymsp[-3].minor.yy62->span, &yymsp[-1].minor.yy62->span);
}
#line 2755 "parse.c"
        break;
      case 214:
#line 716 "parse.y"
{
  yygotominor.yy62 = sqlite3Expr(TK_ISNULL, yymsp[-1].minor.yy62, 0, 0);
  sqlite3ExprSpan(yygotominor.yy62,&yymsp[-1].minor.yy62->span,&yymsp[0].minor.yy0);
}
#line 2763 "parse.c"
        break;
      case 215:
#line 720 "parse.y"
{
  yygotominor.yy62 = sqlite3Expr(TK_ISNULL, yymsp[-2].minor.yy62, 0, 0);
  sqlite3ExprSpan(yygotominor.yy62,&yymsp[-2].minor.yy62->span,&yymsp[0].minor.yy0);
}
#line 2771 "parse.c"
        break;
      case 216:
#line 724 "parse.y"
{
  yygotominor.yy62 = sqlite3Expr(TK_NOTNULL, yymsp[-1].minor.yy62, 0, 0);
  sqlite3ExprSpan(yygotominor.yy62,&yymsp[-1].minor.yy62->span,&yymsp[0].minor.yy0);
}
#line 2779 "parse.c"
        break;
      case 217:
#line 728 "parse.y"
{
  yygotominor.yy62 = sqlite3Expr(TK_NOTNULL, yymsp[-2].minor.yy62, 0, 0);
  sqlite3ExprSpan(yygotominor.yy62,&yymsp[-2].minor.yy62->span,&yymsp[0].minor.yy0);
}
#line 2787 "parse.c"
        break;
      case 218:
#line 732 "parse.y"
{
  yygotominor.yy62 = sqlite3Expr(TK_NOTNULL, yymsp[-3].minor.yy62, 0, 0);
  sqlite3ExprSpan(yygotominor.yy62,&yymsp[-3].minor.yy62->span,&yymsp[0].minor.yy0);
}
#line 2795 "parse.c"
        break;
      case 219:
      case 220:
#line 736 "parse.y"
{
  yygotominor.yy62 = sqlite3Expr(yymsp[-1].major, yymsp[0].minor.yy62, 0, 0);
  sqlite3ExprSpan(yygotominor.yy62,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy62->span);
}
#line 2804 "parse.c"
        break;
      case 221:
#line 744 "parse.y"
{
  yygotominor.yy62 = sqlite3Expr(TK_UMINUS, yymsp[0].minor.yy62, 0, 0);
  sqlite3ExprSpan(yygotominor.yy62,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy62->span);
}
#line 2812 "parse.c"
        break;
      case 222:
#line 748 "parse.y"
{
  yygotominor.yy62 = sqlite3Expr(TK_UPLUS, yymsp[0].minor.yy62, 0, 0);
  sqlite3ExprSpan(yygotominor.yy62,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy62->span);
}
#line 2820 "parse.c"
        break;
      case 225:
#line 755 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(0, yymsp[-2].minor.yy62, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy62, 0);
  yygotominor.yy62 = sqlite3Expr(TK_BETWEEN, yymsp[-4].minor.yy62, 0, 0);
  if( yygotominor.yy62 ){
    yygotominor.yy62->pList = pList;
  }else{
    sqlite3ExprListDelete(pList);
  } 
  if( yymsp[-3].minor.yy280 ) yygotominor.yy62 = sqlite3Expr(TK_NOT, yygotominor.yy62, 0, 0);
  sqlite3ExprSpan(yygotominor.yy62,&yymsp[-4].minor.yy62->span,&yymsp[0].minor.yy62->span);
}
#line 2836 "parse.c"
        break;
      case 228:
#line 771 "parse.y"
{
    yygotominor.yy62 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy62, 0, 0);
    if( yygotominor.yy62 ){
      yygotominor.yy62->pList = yymsp[-1].minor.yy418;
    }else{
      sqlite3ExprListDelete(yymsp[-1].minor.yy418);
    }
    if( yymsp[-3].minor.yy280 ) yygotominor.yy62 = sqlite3Expr(TK_NOT, yygotominor.yy62, 0, 0);
    sqlite3ExprSpan(yygotominor.yy62,&yymsp[-4].minor.yy62->span,&yymsp[0].minor.yy0);
  }
#line 2850 "parse.c"
        break;
      case 229:
#line 781 "parse.y"
{
    yygotominor.yy62 = sqlite3Expr(TK_SELECT, 0, 0, 0);
    if( yygotominor.yy62 ){
      yygotominor.yy62->pSelect = yymsp[-1].minor.yy375;
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy375);
    }
    sqlite3ExprSpan(yygotominor.yy62,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0);
  }
#line 2863 "parse.c"
        break;
      case 230:
#line 790 "parse.y"
{
    yygotominor.yy62 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy62, 0, 0);
    if( yygotominor.yy62 ){
      yygotominor.yy62->pSelect = yymsp[-1].minor.yy375;
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy375);
    }
    if( yymsp[-3].minor.yy280 ) yygotominor.yy62 = sqlite3Expr(TK_NOT, yygotominor.yy62, 0, 0);
    sqlite3ExprSpan(yygotominor.yy62,&yymsp[-4].minor.yy62->span,&yymsp[0].minor.yy0);
  }
#line 2877 "parse.c"
        break;
      case 231:
#line 800 "parse.y"
{
    SrcList *pSrc = sqlite3SrcListAppend(0,&yymsp[-1].minor.yy198,&yymsp[0].minor.yy198);
    yygotominor.yy62 = sqlite3Expr(TK_IN, yymsp[-3].minor.yy62, 0, 0);
    if( yygotominor.yy62 ){
      yygotominor.yy62->pSelect = sqlite3SelectNew(0,pSrc,0,0,0,0,0,0,0);
    }else{
      sqlite3SrcListDelete(pSrc);
    }
    if( yymsp[-2].minor.yy280 ) yygotominor.yy62 = sqlite3Expr(TK_NOT, yygotominor.yy62, 0, 0);
    sqlite3ExprSpan(yygotominor.yy62,&yymsp[-3].minor.yy62->span,yymsp[0].minor.yy198.z?&yymsp[0].minor.yy198:&yymsp[-1].minor.yy198);
  }
#line 2892 "parse.c"
        break;
      case 232:
#line 811 "parse.y"
{
    Expr *p = yygotominor.yy62 = sqlite3Expr(TK_EXISTS, 0, 0, 0);
    if( p ){
      p->pSelect = yymsp[-1].minor.yy375;
      sqlite3ExprSpan(p,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
    }else{
      sqlite3SelectDelete(yymsp[-1].minor.yy375);
    }
  }
#line 2905 "parse.c"
        break;
      case 233:
#line 823 "parse.y"
{
  yygotominor.yy62 = sqlite3Expr(TK_CASE, yymsp[-3].minor.yy62, yymsp[-1].minor.yy62, 0);
  if( yygotominor.yy62 ){
    yygotominor.yy62->pList = yymsp[-2].minor.yy418;
  }else{
    sqlite3ExprListDelete(yymsp[-2].minor.yy418);
  }
  sqlite3ExprSpan(yygotominor.yy62, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0);
}
#line 2918 "parse.c"
        break;
      case 234:
#line 834 "parse.y"
{
  yygotominor.yy418 = sqlite3ExprListAppend(yymsp[-4].minor.yy418, yymsp[-2].minor.yy62, 0);
  yygotominor.yy418 = sqlite3ExprListAppend(yygotominor.yy418, yymsp[0].minor.yy62, 0);
}
#line 2926 "parse.c"
        break;
      case 235:
#line 838 "parse.y"
{
  yygotominor.yy418 = sqlite3ExprListAppend(0, yymsp[-2].minor.yy62, 0);
  yygotominor.yy418 = sqlite3ExprListAppend(yygotominor.yy418, yymsp[0].minor.yy62, 0);
}
#line 2934 "parse.c"
        break;
      case 244:
#line 863 "parse.y"
{
  if( yymsp[-9].minor.yy280!=OE_None ) yymsp[-9].minor.yy280 = yymsp[0].minor.yy280;
  if( yymsp[-9].minor.yy280==OE_Default) yymsp[-9].minor.yy280 = OE_Abort;
  sqlite3CreateIndex(pParse, &yymsp[-7].minor.yy198, &yymsp[-6].minor.yy198, sqlite3SrcListAppend(0,&yymsp[-4].minor.yy198,0),yymsp[-2].minor.yy418,yymsp[-9].minor.yy280, &yymsp[-10].minor.yy0, &yymsp[-1].minor.yy0);
}
#line 2943 "parse.c"
        break;
      case 245:
      case 292:
#line 870 "parse.y"
{yygotominor.yy280 = OE_Abort;}
#line 2949 "parse.c"
        break;
      case 246:
#line 871 "parse.y"
{yygotominor.yy280 = OE_None;}
#line 2954 "parse.c"
        break;
      case 249:
#line 881 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy198.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, yymsp[-1].minor.yy198.z, yymsp[-1].minor.yy198.n);
  }
  yygotominor.yy418 = sqlite3ExprListAppend(yymsp[-4].minor.yy418, p, &yymsp[-2].minor.yy198);
}
#line 2966 "parse.c"
        break;
      case 250:
#line 889 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy198.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, yymsp[-1].minor.yy198.z, yymsp[-1].minor.yy198.n);
  }
  yygotominor.yy418 = sqlite3ExprListAppend(0, p, &yymsp[-2].minor.yy198);
}
#line 2978 "parse.c"
        break;
      case 252:
#line 902 "parse.y"
{sqlite3DropIndex(pParse, yymsp[0].minor.yy151);}
#line 2983 "parse.c"
        break;
      case 253:
      case 254:
#line 906 "parse.y"
{sqlite3Vacuum(pParse,0);}
#line 2989 "parse.c"
        break;
      case 255:
      case 257:
#line 912 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy198,&yymsp[-2].minor.yy198,&yymsp[0].minor.yy198,0);}
#line 2995 "parse.c"
        break;
      case 256:
#line 913 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy198,&yymsp[-2].minor.yy198,&yymsp[0].minor.yy0,0);}
#line 3000 "parse.c"
        break;
      case 258:
#line 915 "parse.y"
{
  sqlite3Pragma(pParse,&yymsp[-3].minor.yy198,&yymsp[-2].minor.yy198,&yymsp[0].minor.yy198,1);
}
#line 3007 "parse.c"
        break;
      case 259:
#line 918 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-4].minor.yy198,&yymsp[-3].minor.yy198,&yymsp[-1].minor.yy198,0);}
#line 3012 "parse.c"
        break;
      case 260:
#line 919 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-1].minor.yy198,&yymsp[0].minor.yy198,0,0);}
#line 3017 "parse.c"
        break;
      case 267:
#line 932 "parse.y"
{
  Token all;
  all.z = yymsp[-3].minor.yy198.z;
  all.n = (yymsp[0].minor.yy0.z - yymsp[-3].minor.yy198.z) + yymsp[0].minor.yy0.n;
  sqlite3FinishTrigger(pParse, yymsp[-1].minor.yy360, &all);
}
#line 3027 "parse.c"
        break;
      case 268:
#line 941 "parse.y"
{
  sqlite3BeginTrigger(pParse, &yymsp[-7].minor.yy198, &yymsp[-6].minor.yy198, yymsp[-5].minor.yy280, yymsp[-4].minor.yy30.a, yymsp[-4].minor.yy30.b, yymsp[-2].minor.yy151, yymsp[-1].minor.yy280, yymsp[0].minor.yy62, yymsp[-9].minor.yy280);
  yygotominor.yy198 = (yymsp[-6].minor.yy198.n==0?yymsp[-7].minor.yy198:yymsp[-6].minor.yy198);
}
#line 3035 "parse.c"
        break;
      case 269:
      case 272:
#line 947 "parse.y"
{ yygotominor.yy280 = TK_BEFORE; }
#line 3041 "parse.c"
        break;
      case 270:
#line 948 "parse.y"
{ yygotominor.yy280 = TK_AFTER;  }
#line 3046 "parse.c"
        break;
      case 271:
#line 949 "parse.y"
{ yygotominor.yy280 = TK_INSTEAD;}
#line 3051 "parse.c"
        break;
      case 273:
      case 274:
      case 275:
#line 954 "parse.y"
{yygotominor.yy30.a = yymsp[0].major; yygotominor.yy30.b = 0;}
#line 3058 "parse.c"
        break;
      case 276:
#line 957 "parse.y"
{yygotominor.yy30.a = TK_UPDATE; yygotominor.yy30.b = yymsp[0].minor.yy240;}
#line 3063 "parse.c"
        break;
      case 277:
      case 278:
#line 960 "parse.y"
{ yygotominor.yy280 = TK_ROW; }
#line 3069 "parse.c"
        break;
      case 279:
#line 962 "parse.y"
{ yygotominor.yy280 = TK_STATEMENT; }
#line 3074 "parse.c"
        break;
      case 280:
#line 965 "parse.y"
{ yygotominor.yy62 = 0; }
#line 3079 "parse.c"
        break;
      case 281:
#line 966 "parse.y"
{ yygotominor.yy62 = yymsp[0].minor.yy62; }
#line 3084 "parse.c"
        break;
      case 282:
#line 970 "parse.y"
{
  yymsp[-2].minor.yy360->pNext = yymsp[0].minor.yy360;
  yygotominor.yy360 = yymsp[-2].minor.yy360;
}
#line 3092 "parse.c"
        break;
      case 283:
#line 974 "parse.y"
{ yygotominor.yy360 = 0; }
#line 3097 "parse.c"
        break;
      case 284:
#line 980 "parse.y"
{ yygotominor.yy360 = sqlite3TriggerUpdateStep(&yymsp[-3].minor.yy198, yymsp[-1].minor.yy418, yymsp[0].minor.yy62, yymsp[-4].minor.yy280); }
#line 3102 "parse.c"
        break;
      case 285:
#line 985 "parse.y"
{yygotominor.yy360 = sqlite3TriggerInsertStep(&yymsp[-5].minor.yy198, yymsp[-4].minor.yy240, yymsp[-1].minor.yy418, 0, yymsp[-7].minor.yy280);}
#line 3107 "parse.c"
        break;
      case 286:
#line 988 "parse.y"
{yygotominor.yy360 = sqlite3TriggerInsertStep(&yymsp[-2].minor.yy198, yymsp[-1].minor.yy240, 0, yymsp[0].minor.yy375, yymsp[-4].minor.yy280);}
#line 3112 "parse.c"
        break;
      case 287:
#line 992 "parse.y"
{yygotominor.yy360 = sqlite3TriggerDeleteStep(&yymsp[-1].minor.yy198, yymsp[0].minor.yy62);}
#line 3117 "parse.c"
        break;
      case 288:
#line 995 "parse.y"
{yygotominor.yy360 = sqlite3TriggerSelectStep(yymsp[0].minor.yy375); }
#line 3122 "parse.c"
        break;
      case 289:
#line 998 "parse.y"
{
  yygotominor.yy62 = sqlite3Expr(TK_RAISE, 0, 0, 0); 
  yygotominor.yy62->iColumn = OE_Ignore;
  sqlite3ExprSpan(yygotominor.yy62, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3131 "parse.c"
        break;
      case 290:
#line 1003 "parse.y"
{
  yygotominor.yy62 = sqlite3Expr(TK_RAISE, 0, 0, &yymsp[-1].minor.yy198); 
  yygotominor.yy62->iColumn = yymsp[-3].minor.yy280;
  sqlite3ExprSpan(yygotominor.yy62, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3140 "parse.c"
        break;
      case 291:
#line 1011 "parse.y"
{yygotominor.yy280 = OE_Rollback;}
#line 3145 "parse.c"
        break;
      case 293:
#line 1013 "parse.y"
{yygotominor.yy280 = OE_Fail;}
#line 3150 "parse.c"
        break;
      case 294:
#line 1018 "parse.y"
{
  sqlite3DropTrigger(pParse,yymsp[0].minor.yy151);
}
#line 3157 "parse.c"
        break;
      case 295:
#line 1024 "parse.y"
{
  sqlite3Attach(pParse, &yymsp[-3].minor.yy198, &yymsp[-1].minor.yy198, yymsp[0].minor.yy361.type, &yymsp[0].minor.yy361.key);
}
#line 3164 "parse.c"
        break;
      case 296:
#line 1028 "parse.y"
{ yygotominor.yy361.type = 0; }
#line 3169 "parse.c"
        break;
      case 297:
#line 1029 "parse.y"
{ yygotominor.yy361.type=1; yygotominor.yy361.key = yymsp[0].minor.yy198; }
#line 3174 "parse.c"
        break;
      case 298:
#line 1030 "parse.y"
{ yygotominor.yy361.type=2; yygotominor.yy361.key = yymsp[0].minor.yy0; }
#line 3179 "parse.c"
        break;
      case 301:
#line 1036 "parse.y"
{
  sqlite3Detach(pParse, &yymsp[0].minor.yy198);
}
#line 3186 "parse.c"
        break;
      case 302:
#line 1042 "parse.y"
{sqlite3Reindex(pParse, 0, 0);}
#line 3191 "parse.c"
        break;
      case 303:
#line 1043 "parse.y"
{sqlite3Reindex(pParse, &yymsp[-1].minor.yy198, &yymsp[0].minor.yy198);}
#line 3196 "parse.c"
        break;
      case 304:
#line 1048 "parse.y"
{sqlite3Analyze(pParse, 0, 0);}
#line 3201 "parse.c"
        break;
      case 305:
#line 1049 "parse.y"
{sqlite3Analyze(pParse, &yymsp[-1].minor.yy198, &yymsp[0].minor.yy198);}
#line 3206 "parse.c"
        break;
      case 306:
#line 1054 "parse.y"
{
  sqlite3AlterRenameTable(pParse,yymsp[-3].minor.yy151,&yymsp[0].minor.yy198);
}
#line 3213 "parse.c"
        break;
      case 307:
#line 1057 "parse.y"
{
  sqlite3AlterFinishAddColumn(pParse, &yymsp[0].minor.yy198);
}
#line 3220 "parse.c"
        break;
      case 308:
#line 1060 "parse.y"
{
  sqlite3AlterBeginAddColumn(pParse, yymsp[0].minor.yy151);
}
#line 3227 "parse.c"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = yyact;
      yymsp->major = yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqlite3ParserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 34 "parse.y"

  if( pParse->zErrMsg==0 ){
    if( TOKEN.z[0] ){
      sqlite3ErrorMsg(pParse, "near \"%T\": syntax error", &TOKEN);
    }else{
      sqlite3ErrorMsg(pParse, "incomplete SQL statement");
    }
  }
#line 3294 "parse.c"
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqlite3ParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3Parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqlite3ParserTOKENTYPE yyminor       /* The value for the token */
  sqlite3ParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
    /* if( yymajor==0 ) return; // not sure why this was here... */
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  sqlite3ParserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      if( yyendofinput && yypParser->yyidx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else if( yyact == YY_ERROR_ACTION ){
      int yymx;
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_shift_action(yypParser,YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
