/* 
 * $Id: ctksize.c,v 1.62 2000/07/12 00:44:10 cbond Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

/* Sizing Alogorithms
 * 
 * CtkTypeBox
 * 
 *    - Allocate proper space and position each child according
 *      to the Box attributes and child attributes.
 * 
 *    BOX Attributes:
 * 
 *       homogeneous - All children will receive the same amount of
 *                     in side the box.
 *       spacing     - the amount of characters between each child.
 * 
 *    Child Attributes:
 * 
 *       expand      - allocate more space for the child.  The extra
 *                     space will be divided up between all widgets
 *                     that use this command.
 *       fill        - file the child into the space allocated with
 *                     the expand command.  fill is ignored if expand
 *                     is turned off.
 *       padding     - the number of characters on each side of the
 *                     widget.  This space is added ontop of the box
 *                     spacing.
 *
 */

#include <stdio.h>
#include <glib.h>
#include <string.h>

#include "ctk.h"
#include "ctklist.h"

/* Get Option Menu Minimum Size */
static gboolean ctk_size_set_minimum_helper(GNode* node, gpointer data)
{
	CtkWidget* widget = CTK_WIDGET(node->data);
	
	if (widget->show)
	{
		(*widget->set_min_size)(widget); /* Call the sizing function */
	}
	else
	{
		widget->min_width  = 0;
		widget->min_height = 0;
	}
	
	return FALSE;
}

/* Give each widget a minimum size */
void ctk_size_set_minimum(CtkWidget *widget)
{
	g_node_traverse(widget->node,
			G_POST_ORDER,
			G_TRAVERSE_ALL,
			-1,
			ctk_size_set_minimum_helper,
			NULL);

}

static gboolean ctk_size_set_real_helper(GNode* node, gpointer data)
{
	CtkWidget* widget = CTK_WIDGET(node->data);
	
	if (widget->show && 
	    widget->width  >= widget->min_width && 
	    widget->height >= widget->min_height)
	{
		(*widget->set_real_size)(widget);
	}
	else
	{
		widget->row    = 0;
		widget->col    = 0;
		widget->width  = 0;
		widget->height = 0;
	}
	
	return FALSE;
}

/* Set the real size according to the window size! */
void ctk_size_set_real(CtkWidget *widget)
{
	g_node_traverse(widget->node,
			G_LEVEL_ORDER,
			G_TRAVERSE_ALL,
			-1,
			ctk_size_set_real_helper,
			NULL);
}

void ctk_size_mark_changed(CtkWidget* widget)
{
	while (!widget->changed)
	{
		widget->changed = TRUE;
		
		if (!widget->node || !widget->node->parent)
			break;
			
		widget = CTK_WIDGET(widget->node->parent->data);
	}
	
	ctk_screen_dirty = TRUE;
}
