/*--------------------------------------------------------------------------+
$Id: MethodNameComparator.java 26283 2010-02-18 11:18:57Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.reflect;

import java.lang.reflect.Method;

import edu.tum.cs.commons.collections.IdentifierBasedComparatorBase;

/**
 * This comparator compares methods by their name.
 * 
 * @author deissenb
 * @author $Author: juergens $
 * @version $Rev: 26283 $
 * @levd.rating GREEN Hash: 6DF480EAA650ED041BC73D1FAB8CD972
 */
public class MethodNameComparator extends
		IdentifierBasedComparatorBase<String, Method> {

	/** Instance of this comparator. */
	public static final MethodNameComparator INSTANCE = new MethodNameComparator();

	/** Returns method name. */
	@Override
	protected String obtainIdentifier(Method method) {
		return method.getName();
	}

}