use Data::Dumper;
use IO::File;
use File::HomeDir ;

$conf_file_name = "some-patch";

$conf_dir       = 'debian/patches';
$model_to_test  = "Dpkg::Patch";

@tests = (
    {
        name => 'libperl5i' ,
        backend_arg => $conf_file_name,
        log4perl_load_warnings => [[
            'User',
            warn => "Warning in 'Bug-Debian:0' value 'http://bugs.debian.org/655329': https protocol should be used instead of http",
            warn => "Warning in 'Bug-Debian:1' value '#124567': This field should contain an URL to Debian BTS and not just a bug number",
            warn => "Warning in 'Bug-Debian:1' value '#124567': https protocol should be used instead of http",
            warn => "Warning in 'Bug-Debian:1' value '#124567': Unknown host or protocol for Debian BTS",
            warn => "Warning in 'Bug-Debian:2' value '#215476': This field should contain an URL to Debian BTS and not just a bug number",
            warn => "Warning in 'Bug-Debian:2' value '#215476': https protocol should be used instead of http",
            warn => "Warning in 'Bug-Debian:2' value '#215476': Unknown host or protocol for Debian BTS",
        ]],
        apply_fix => 1 ,
        check => {
            'Synopsis' => qr/test TODO/,
            'Subject' => qr/utf8/,
            'Subject' => qr/879/,
            'Subject' => qr/2012/,
            'Bug:0' => 'https://github.com/schwern/perl5i/issues/218',
            'Bug:1' => 'https://github.com/schwern/perl5i/issues/219',
            'Origin' => 'https://github.com/doherty/perl5i',
            'Bug-Debian:0' => 'https://bugs.debian.org/655329',

        },
        # file_check_sub => $del_home,
    },
    {
        name => 'moarvm' ,
        backend_arg => $conf_file_name,
        check => {
            'Synopsis' => qr/Configure.pl/,
        },
        # check that subject stays first field
        file_contents_like => {
            "$conf_dir/$conf_file_name" => [ qr/^Subject/ ] ,
        }
    },
    {
        name => 'by-git',
        backend_arg => $conf_file_name,
        dump_warnings => [ qr/Empty/ ],
        check => {
            Description => qr/enhance/,
            diff => qr/@@ -7,7/
        },
        # check that description is first field
        file_contents_like => {
            "$conf_dir/$conf_file_name" => [ qr/^Description/ ] ,
        }

    },
);


1;
