use Data::Dumper;
use IO::File;
use File::HomeDir ;

$conf_file_name = "some-patch";

$conf_dir       = 'debian/patches';
$model_to_test  = "Dpkg::Patch";

eval { require AptPkg::Config; };
$skip = ( $@ or not -r '/etc/debian_version' ) ? 1 : 0;

@tests = (
    {
        name => 'libperl5i' ,
        config_file => $conf_file_name,
        load_warnings => [ qr/https protocol should/  ],
        apply_fix => 1 ,
        check => {
            'Synopsis' => qr/test TODO/,
            'Subject' => qr/utf8/,
            'Subject' => qr/879/,
            'Subject' => qr/2012/,
            'Bug:0' => 'https://github.com/schwern/perl5i/issues/218',
            'Bug:1' => 'https://github.com/schwern/perl5i/issues/219',
            'Origin' => 'https://github.com/doherty/perl5i',
            'Bug-Debian:0' => 'https://bugs.debian.org/655329',

        },
        # file_check_sub => $del_home,
    },
    {
        name => 'moarvm' ,
        config_file => $conf_file_name,
        check => {
            'Synopsis' => qr/Configure.pl/,
        }
    },
);


1;
