#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <glib/garray.h>
#include <getopt.h>
#include <libintl.h>
#include "complearn/complearn.h"

#define _(O) gettext(O)

static void print_anydecompress_help_and_exit(void) {
    fprintf(stderr, "%s",
_("Usage: anydecompress [options] <infile> [<outfile>]\n"
"\n"
"OPTIONS:                                                              \n"
"  -h, --help                  print this help message                 \n"
"  -L, --list                  list compressors                        \n"
"  -v, --verbose               print extra detailed information        \n"
"\n")
);
    exit(0);
  }

int main(int argc, char **argv)
{
  GError *error = NULL;
  LabeledMatrix *m;
  GSList *a, *b;
  g_type_init ();
  complearn_environment_handle_log_domain(G_LOG_DOMAIN);
  CompLearnEnvironment *clb =COMPLEARN_ENVIRONMENT(complearn_environment_new());
  CompLearnNcd *ncd = complearn_ncd_top();
  complearn_ncd_set_filelist_mode();

  optind = 1;
  int option_index = 0, c;
  struct option long_options[] = {
    {"help", 0, 0, 'h'},
    {"verbose", 0, 0, 'v'},
    {"list", 0, 0, 'L'},
    { 0, 0, 0, 0 } };
  while (1) {
    c = getopt_long(argc, (char **) argv, "hvL", long_options, &option_index);
    if (c == -1)
      break;
    switch (c) {
      case 'h': print_anydecompress_help_and_exit(); break;
      case 'v': complearn_environment_set_verbose_mode(); break;
      case 'L': complearn_ncd_print_compressor_list(); break;
      case '?': exit(1);
      default:
        g_error(_("Unrecognized option '%c'"), c); break;
    }
  }
  CompLearnRealCompressor *rc = complearn_ncd_load_compressor(
    complearn_ncd_get_compressor(complearn_ncd_top()));
  FILE *inFile = NULL, *outFile = NULL;
  if (optind >= argc) {
    inFile = stdin;
    outFile = stdout;
  }
  char *in_filename, *out_filename;
  if (inFile == NULL) {
    if (optind + 1 == argc) {
      in_filename = g_strdup(argv[optind]);
      if (strstr(in_filename, ".")) {
        out_filename = g_strdup(in_filename);
        strtok(out_filename, ".");
      } else 
        out_filename = g_strconcat(in_filename, ".out", NULL);
    } else {
      if (optind + 2 == argc)
        out_filename = g_strdup(argv[optind+1]);
      else
        g_error(_("Don't know what to do with extra arguments."));
    }
    g_message(_("Opening output file %s"), out_filename);
    inFile = fopen(in_filename, "rb");
    outFile = fopen(out_filename, "wb");
  }
  GString *compblock = complearn_read_whole_file_ptr(inFile);
  int i;
  char **compnames = complearn_environment_compressor_list();
  for (i = 0; compnames[i]; i += 1) {
    rc = complearn_ncd_load_compressor(compnames[i]);
  if (!real_compressor_is_just_size(rc) && real_compressor_is_decompressible(rc, compblock)) {
      g_message(_("Found matching compressor %s"),real_compressor_name(rc)->str);
      GString *outblock = real_compressor_decompress(rc, compblock);
      fwrite(outblock->str, 1, outblock->len, outFile);
      exit(0);
    }
  }
  g_error(_("Cannot find matching decompressor."));
  return 1;
}



