#include <glib.h>
#include <GL/gl.h>
#include "node.h"
#include "stacker.h"

static void stacker_compute_extents (CmNode  *node,
				     Extents *extents);
static void stacker_render          (CmNode  *node);

G_DEFINE_TYPE (CmStacker, cm_stacker, CM_TYPE_NODE);

static void
cm_stacker_finalize (GObject *object)
{
    G_OBJECT_CLASS (cm_stacker_parent_class)->finalize (object);
}

static void
cm_stacker_class_init (CmStackerClass *class)
{
    GObjectClass *object_class = G_OBJECT_CLASS (class);
    CmNodeClass *node_class = CM_NODE_CLASS (class);
    
    object_class->finalize = cm_stacker_finalize;
    
    node_class->render = stacker_render;
    node_class->compute_extents = stacker_compute_extents;
}

static void
cm_stacker_init (CmStacker *stacker)
{

}

static void
stacker_compute_extents (CmNode *node,
			 Extents *extents)
{
    extents->x = 0.0;
    extents->y = 0.0;
    extents->z = 0.0;
    extents->width = 1.0;
    extents->height = 1.0;
    extents->depth = 1.0;
}

static void
stacker_render (CmNode *node)
{
    CmStacker *stacker = (CmStacker *)node;
    GList *list;
#if 0
    GLboolean depth_mask;
    gdouble depth;
#endif
    
    glPushMatrix();

    /* First draw everything without updating the depth buffer.
     * This ensures that children in the same plane will
     * overdraw each other, but still get clipped by existing
     * depth buffered drawing.
     *
     * This won't work if the stacker contains 3D children, so we
     * assume it doesn't.
     */

    glEnable (GL_BLEND);
    glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
#if 0
    glDisable (GL_DEPTH_TEST);
#endif

    for (list = g_list_last (stacker->children); list; list = list->prev)
#if 0
    for (list = stacker->children; list; list = list->next)
#endif
    {
	CmNode *child = list->data;

	/* crack, but we probably can't rely on
	 * depth buffering working.
	 *
	 * The right way to do this is with glPolygonOffset(). See
	 * the Technical FAQ.
	 */
	
#if 0
	glTranslatef (0.0, 0.0, 0.0001);
#endif
	
	cm_node_render (child);
    }
    
    glPopMatrix();
}

#if 0
for (list = g_list_last (stacker->children); list != NULL; list = list->prev)
#endif

CmStacker *
cm_stacker_new (void)
{
    CmStacker *stacker = g_object_new (CM_TYPE_STACKER, NULL);

    return stacker;
}

void
cm_stacker_add_child (CmStacker *stacker,
		   CmNode *child)
{
    stacker->children = g_list_prepend (stacker->children, child);
}

void
cm_stacker_remove_child (CmStacker *stacker,
		      CmNode *child)
{
    stacker->children = g_list_remove (stacker->children, child);
}
