#include "node.h"

#define CM_TYPE_ROTATION            (cm_rotation_get_type ())
#define CM_ROTATION(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), CM_TYPE_ROTATION, CmRotation))
#define CM_ROTATION_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  CM_TYPE_ROTATION, CmRotationClass))
#define CM_IS_ROTATION(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CM_TYPE_ROTATION))
#define CM_IS_ROTATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  CM_TYPE_ROTATION))
#define CM_ROTATION_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  CM_TYPE_ROTATION, CmRotationClass))

typedef struct _CmRotation CmRotation;
typedef struct _CmRotationClass CmRotationClass;

struct _CmRotation
{
    CmNode parent_instance;
    
    CmNode *	child;
    
    gdouble	angle;
    gdouble	x;
    gdouble	y;
    gdouble	z;}
;

struct _CmRotationClass
{
    CmNodeClass parent_class;
};

GType cm_rotation_get_type (void);

CmRotation *cm_rotation_new (CmNode *child);
void	    cm_rotation_set_rotation (CmRotation *rotation,
				     gdouble	 angle,
				     gdouble	 x,
				     gdouble	 y,
				     gdouble     z);
