#include "node.h"

#define CM_TYPE_CLIP_NODE            (cm_clip_node_get_type ())
#define CM_CLIP_NODE(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), CM_TYPE_CLIP_NODE, CmClipNode))
#define CM_CLIP_NODE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  CM_TYPE_CLIP_NODE, CmClipNodeClass))
#define CM_IS_CLIP_NODE(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CM_TYPE_CLIP_NODE))
#define CM_IS_CLIP_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  CM_TYPE_CLIP_NODE))
#define CM_CLIP_NODE_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  CM_TYPE_CLIP_NODE, CmClipNodeClass))

typedef struct _CmClipNode CmClipNode;
typedef struct _CmClipNodeClass CmClipNodeClass;

struct _CmClipNode
{
    CmNode parent_instance;

    double x, y, w, h;

    CmNode *child;
};

struct _CmClipNodeClass
{
    CmNodeClass parent_class;
};

GType cm_clip_node_get_type (void);

CmClipNode *cm_clip_node_new (double x,
			      double y,
			      double width,
			      double height,
			      CmNode *child);
