class MainPage < CKComponent
	LOGFILE = 'log.txt'
	MAXSIZE = 2000

	def init
		@log = CKLog.new application.log_options
	end

	def raise_error
		nil + nil
	end

	def max_file_size
		MAXSIZE
	end

	def content_log_file
		File.new(LOGFILE).read
	end

	def debug
		begin
			@log.debug "debug level message."
		rescue CKLog::FileSizeError
			_clear
		end
	end

	def info
		begin
			@log.info "info level message."
		rescue CKLog::FileSizeError
			_clear
		end
	end

	def warn
		begin
			@log.warn "warn level message."
		rescue CKLog::FileSizeError
			_clear
		end
	end

	def error
		begin
			@log.error "error level message."
		rescue CKLog::FileSizeError
			_clear
		end
	end

	def fatal
		begin
			@log.fatal "fatal level message."
		rescue CKLog::FileSizeError
			_clear
		end
	end

	def _clear
		File.new(LOGFILE, 'w').close
		@log.info "clear logs."
	end
end


