/*
 * Mail program interface
 *
 * Copyright (C) 2004  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include "MailProgram.h"
#include "buffy/Exception.h"

#include <sys/types.h>  // stat, opendir, readdir, utimes
#include <sys/stat.h>   // stat
#include <dirent.h>		// opendir, readdir
#include <sys/time.h>	// utimes

//#include <glibmm/spawn.h>

#include <errno.h>

using namespace std;
using namespace buffy;

/*
void MailProgramImpl::on_exit()
{
	fprintf(stderr, "USITO\n");
}
*/

void MailProgramImpl::run(const MailFolder& folder)
	throw (SystemException, ConsistencyCheckException)
{
	string cmd = _command;
    string::size_type p;
	while ((p = cmd.find("%p")) != string::npos)
		cmd.replace(p, 2, folder.path());

	// TODO: use '~' as working directory
	vector<string> argv;
	argv.push_back("/bin/sh");
	//argv.push_back("/bin/sh");
	argv.push_back("-c");
	argv.push_back(cmd);

	// I wonder what this does, as it's undocumented
//	Glib::spawn_async(".", argv, Glib::SpawnFlags(0), sigc::mem_fun(*this, &MailProgramImpl::on_exit));

	
	pid_t child = fork();
	if (child == -1)
		throw SystemException(errno, "trying to fork a child process");
	
	if (child == 0)
	{
		// Child code path
		try {
			execl("/bin/sh", "/bin/sh", "-c", cmd.c_str(), 0);
			throw SystemException(errno, "trying to fork a child process");
		} catch (Exception& e) {
			fprintf(stderr, "%s: %.*s\n", e.type(), PFSTR(e.desc()));
		}
		_exit(0);
	}
}

// vim:set ts=4 sw=4:
