/**
 * @file test-utils.h
 * @author Peter Rockai (mornfall) <mornfall@danill.sk>
 * @brief Utility functions for the unit tests
 */
#include <tut.h>

#include <string>
#include <tagcoll/TaggedCollection.h>
#include <tagcoll/Patches.h>
#include <tagcoll/stringf.h>
/*
#include <apt-front/cache.h>
#include <apt-pkg/configuration.h>
#include <apt-pkg/error.h>
#include <apt-pkg/pkgsystem.h>
#include <apt-pkg/init.h>
#include <iostream>
*/

namespace tut {
using namespace std;
using namespace stringf;
using namespace Tagcoll;

inline static std::string __ensure_errmsg(std::string f, int l, std::string msg)
{
    char buf[64];
    snprintf(buf, 63, "%d", l);
    buf[63] = 0;
    std::string ln = buf;
    f.append(":");
    f.append(ln);
    f.append(": '");
    f.append(msg);
    f.append("'");
    return f;
}
#define gen_ensure(x) ensure (__ensure_errmsg(__FILE__, __LINE__, #x).c_str(), (x))

inline static std::string __tc_ensure_errmsg(std::string f, int l, std::string f1, int l1, std::string msg)
{
    return f + ":" + fmt(l) + ": '" + f1 + ":" + fmt(l1) + ": " + msg + "'";
}

inline static void __test_tagged_collection(std::string f, int l, TaggedCollection<string, string>& tc)
{
#define ttc_ensure(x) ensure (__tc_ensure_errmsg(f, l, __FILE__, __LINE__, #x).c_str(), (x))
	// Test handling of untagged items
	tc.consume("untagged");
	ttc_ensure(tc.hasItem("untagged"));
	OpSet<string> itemset = tc.getUntaggedItems();
	ttc_ensure(itemset.contains("untagged"));
	ttc_ensure(tc.getTags("untagged").empty());
	
	// Test handling of tagged items
	OpSet<string> tagset;
	tagset += "tag1"; tagset += "tag2";
	tc.consume("tagged", tagset);
	ttc_ensure(tc.hasItem("tagged"));
	//ttc_ensure(tc.hasTag("tag1"));
	//ttc_ensure(tc.hasTag("tag2"));
	itemset = tc.getUntaggedItems();
	ttc_ensure(!itemset.contains("tagged"));
	tagset = tc.getTags("tagged");
	ttc_ensure(tagset.contains("tag1"));
	ttc_ensure(tagset.contains("tag2"));
	itemset = tc.getItems("tag1");
	ttc_ensure(itemset.contains("tagged"));
	itemset = tc.getItems("tag2");
	ttc_ensure(itemset.contains("tagged"));
	tagset = tc.getAllTags();
	ttc_ensure(tagset.contains("tag1"));
	ttc_ensure(tagset.contains("tag2"));
	tagset.clear();
	tagset += "tag1";
	tagset = tc.getCompanionTags(tagset);
	ttc_ensure(!tagset.contains("tag1"));
	ttc_ensure(tagset.contains("tag2"));

	// Test handling of changes
	PatchList<string, string> change;
	Patch<string, string> p("tagged");
	tagset.clear();
	p.remove("tag1");
	p.remove("tag2");
	change.addPatch(p);

	tc.applyChange(change);
	
	// "tagged" should now be untagged
	ttc_ensure(tc.hasItem("tagged"));
	itemset = tc.getUntaggedItems();
	ttc_ensure(itemset.contains("tagged"));
	ttc_ensure(tc.getTags("tagged").empty());

	tc.applyChange(change.getReverse());

	// "tagged" should now be as before
	ttc_ensure(tc.hasItem("tagged"));
	//ttc_ensure(tc.hasTag("tag1"));
	//ttc_ensure(tc.hasTag("tag2"));
	itemset = tc.getUntaggedItems();
	ttc_ensure(!itemset.contains("tagged"));
	tagset = tc.getTags("tagged");
	ttc_ensure(tagset.contains("tag1"));
	ttc_ensure(tagset.contains("tag2"));
	itemset = tc.getItems("tag1");
	ttc_ensure(itemset.contains("tagged"));
	itemset = tc.getItems("tag2");
	ttc_ensure(itemset.contains("tagged"));
	tagset = tc.getAllTags();
	ttc_ensure(tagset.contains("tag1"));
	ttc_ensure(tagset.contains("tag2"));
	tagset.clear();
	tagset += "tag1";
	tagset = tc.getCompanionTags(tagset);
	ttc_ensure(!tagset.contains("tag1"));
	ttc_ensure(tagset.contains("tag2"));

	// Try a patch that adds a tag
	change = PatchList<string, string>();
	p = Patch<string, string>("tagged");
	p.add("tag3");
	change.addPatch(p);
	tc.applyChange(change);

	ttc_ensure(tc.hasItem("tagged"));
	//ttc_ensure(tc.hasTag("tag1"));
	//ttc_ensure(tc.hasTag("tag2"));
	//ttc_ensure(tc.hasTag("tag3"));
	itemset = tc.getUntaggedItems();
	ttc_ensure(!itemset.contains("tagged"));
	tagset = tc.getTags("tagged");
	ttc_ensure(tagset.contains("tag1"));
	ttc_ensure(tagset.contains("tag2"));
	ttc_ensure(tagset.contains("tag3"));
	itemset = tc.getItems("tag1");
	ttc_ensure(itemset.contains("tagged"));
	itemset = tc.getItems("tag2");
	ttc_ensure(itemset.contains("tagged"));
	itemset = tc.getItems("tag3");
	ttc_ensure(itemset.contains("tagged"));
	tagset = tc.getAllTags();
	ttc_ensure(tagset.contains("tag1"));
	ttc_ensure(tagset.contains("tag2"));
	ttc_ensure(tagset.contains("tag3"));
	tagset.clear();
	tagset += "tag1";
	tagset = tc.getCompanionTags(tagset);
	ttc_ensure(!tagset.contains("tag1"));
	ttc_ensure(tagset.contains("tag2"));
	ttc_ensure(tagset.contains("tag3"));

	// Try a patch that adds some items
	change = PatchList<string, string>();
	p = Patch<string, string>("tagged1");
	p.add("tag1");
	p.add("tag2");
	p.add("tag4");
	change.addPatch(p);
	tc.applyChange(change);

	ttc_ensure(tc.hasItem("tagged1"));
	itemset = tc.getUntaggedItems();
	ttc_ensure(!itemset.contains("tagged1"));
	tagset = tc.getTags("tagged1");
	ttc_ensure(tagset.contains("tag1"));
	ttc_ensure(tagset.contains("tag2"));
	ttc_ensure(!tagset.contains("tag3"));
	ttc_ensure(tagset.contains("tag4"));
	itemset = tc.getItems("tag1");
	ttc_ensure(itemset.contains("tagged1"));
	itemset = tc.getItems("tag2");
	ttc_ensure(itemset.contains("tagged1"));
	itemset = tc.getItems("tag3");
	ttc_ensure(!itemset.contains("tagged1"));
	itemset = tc.getItems("tag4");
	ttc_ensure(!itemset.contains("tagged"));
	ttc_ensure(itemset.contains("tagged1"));
	tagset = tc.getAllTags();
	ttc_ensure(tagset.contains("tag1"));
	ttc_ensure(tagset.contains("tag2"));
	ttc_ensure(tagset.contains("tag3"));
	ttc_ensure(tagset.contains("tag4"));
	tagset.clear();
	tagset += "tag1";
	tagset = tc.getCompanionTags(tagset);
	ttc_ensure(!tagset.contains("tag1"));
	ttc_ensure(tagset.contains("tag2"));
	ttc_ensure(tagset.contains("tag3"));
	ttc_ensure(tagset.contains("tag4"));

	// And reverse it
	tc.applyChange(change.getReverse());

	ttc_ensure(tc.hasItem("tagged1"));
	itemset = tc.getUntaggedItems();
	ttc_ensure(itemset.contains("tagged1"));
	itemset = tc.getItems("tag1");
	ttc_ensure(!itemset.contains("tagged1"));
	itemset = tc.getItems("tag2");
	ttc_ensure(!itemset.contains("tagged1"));
	itemset = tc.getItems("tag3");
	ttc_ensure(!itemset.contains("tagged1"));
	ttc_ensure(tc.getItems("tag4") == OpSet<string>());
	tagset = tc.getAllTags();
	ttc_ensure(tagset.contains("tag1"));
	ttc_ensure(tagset.contains("tag2"));
	ttc_ensure(tagset.contains("tag3"));
	ttc_ensure(!tagset.contains("tag4"));
	tagset.clear();
	tagset += "tag1";
	tagset = tc.getCompanionTags(tagset);
	ttc_ensure(!tagset.contains("tag1"));
	ttc_ensure(tagset.contains("tag2"));
	ttc_ensure(tagset.contains("tag3"));
	ttc_ensure(!tagset.contains("tag4"));
#undef ttc_ensure
}
}

#define test_tagged_collection(x) (__test_tagged_collection(__FILE__, __LINE__, (x)))

/*
namespace tut {
    static void aptInit () {
        pkgInitConfig (*_config);
        _config->Set("Dir", CACHE_DIR);
        _config->Set("Dir::Cache", "cache");
        _config->Set("Dir::State", "state");
        _config->Set("Dir::Etc", "etc");
        _config->Set("Dir::State::status", CACHE_DIR "dpkg-status");
        pkgInitSystem (*_config, _system);
        // _config -> Set ("Capture::Cache::UseExtState", extstate);
    }
}
*/
