
--  wsdl2aws SOAP Generator v1.0
--
--  AWS 1.4 - SOAP 1.2
--  This file was generated on Sunday 09 November 2003 at 10:15:59
--
--  $ wsdl2aws -q -f -doc -noskel interoplab_main.wsdl

pragma Warnings (Off);

with Ada.Exceptions;

with SOAP.Client;
with SOAP.Message.Payload;
with SOAP.Message.Response;
with SOAP.Parameters;
with SOAP.Types;
with SOAP.Utils;

package body interopLab.Client is

   use SOAP.Types;
   use type SOAP.Parameters.List;

   pragma Style_Checks (Off);

   --------------
   -- echoVoid --
   --------------

   procedure echoVoid is
      P_Set   : SOAP.Parameters.List;
      Payload : SOAP.Message.Payload.Object;
   begin
      --  Set parameters
      Payload := SOAP.Message.Payload.Build
        ("echoVoid", P_Set, "http://soapinterop.org/");

      declare
         Response : constant SOAP.Message.Response.Object'Class
           := SOAP.Client.Call
                ("http://soap.4s4c.com/ilab/soap.asp",
                 Payload,
                 "http://soapinterop.org/#echoVoid");
         R_Param  : constant SOAP.Parameters.List
           := SOAP.Message.Parameters (Response);
      begin
         if SOAP.Message.Response.Is_Error (Response) then
            Ada.Exceptions.Raise_Exception
              (SOAP.SOAP_Error'Identity,
               SOAP.Parameters.Get (R_Param, "faultstring"));
         end if;
      end;
   end echoVoid;

   ----------------
   -- echoString --
   ----------------

   function echoString
     (inputString : in String)
      return String
   is
      P_Set   : SOAP.Parameters.List;
      Payload : SOAP.Message.Payload.Object;
   begin
      --  Set parameters
      P_Set := +SOAP.Types.S (inputString, "inputString");
      Payload := SOAP.Message.Payload.Build
        ("echoString", P_Set, "http://soapinterop.org/");

      declare
         Response : constant SOAP.Message.Response.Object'Class
           := SOAP.Client.Call
                ("http://soap.4s4c.com/ilab/soap.asp",
                 Payload,
                 "http://soapinterop.org/#echoString");
         R_Param  : constant SOAP.Parameters.List
           := SOAP.Message.Parameters (Response);
      begin
         if SOAP.Message.Response.Is_Error (Response) then
            Ada.Exceptions.Raise_Exception
              (SOAP.SOAP_Error'Identity,
               SOAP.Parameters.Get (R_Param, "faultstring"));
         else
            declare
               Result : constant String
                 := SOAP.Parameters.Get (R_Param, "outputString");
            begin
               return Result;
            end;
         end if;
      end;
   end echoString;

   ---------------------
   -- echoStringArray --
   ---------------------

   function echoStringArray
     (inputStringArray : in ArrayOfstring)
      return echoStringArray_Result
   is
      P_Set   : SOAP.Parameters.List;
      Payload : SOAP.Message.Payload.Object;
   begin
      --  Set parameters
      P_Set := +A (To_Object_Set (inputStringArray), "inputStringArray");
      Payload := SOAP.Message.Payload.Build
        ("echoStringArray", P_Set, "http://soapinterop.org/");

      declare
         Response : constant SOAP.Message.Response.Object'Class
           := SOAP.Client.Call
                ("http://soap.4s4c.com/ilab/soap.asp",
                 Payload,
                 "http://soapinterop.org/");
         R_Param  : constant SOAP.Parameters.List
           := SOAP.Message.Parameters (Response);
      begin
         if SOAP.Message.Response.Is_Error (Response) then
            Ada.Exceptions.Raise_Exception
              (SOAP.SOAP_Error'Identity,
               SOAP.Parameters.Get (R_Param, "faultstring"));
         else
            declare
               Result : constant echoStringArray_Result
                 := To_ArrayOfstring
                 (V (SOAP_Array'(SOAP.Parameters.Get (R_Param, "outputStringArray"))));
            begin
               return Result;
            end;
         end if;
      end;
   end echoStringArray;

   -----------------
   -- echoInteger --
   -----------------

   function echoInteger
     (inputInteger : in Integer)
      return Integer
   is
      P_Set   : SOAP.Parameters.List;
      Payload : SOAP.Message.Payload.Object;
   begin
      --  Set parameters
      P_Set := +SOAP.Types.I (inputInteger, "inputInteger");
      Payload := SOAP.Message.Payload.Build
        ("echoInteger", P_Set, "http://soapinterop.org/");

      declare
         Response : constant SOAP.Message.Response.Object'Class
           := SOAP.Client.Call
                ("http://soap.4s4c.com/ilab/soap.asp",
                 Payload,
                 "http://soapinterop.org/");
         R_Param  : constant SOAP.Parameters.List
           := SOAP.Message.Parameters (Response);
      begin
         if SOAP.Message.Response.Is_Error (Response) then
            Ada.Exceptions.Raise_Exception
              (SOAP.SOAP_Error'Identity,
               SOAP.Parameters.Get (R_Param, "faultstring"));
         else
            declare
               Result : constant Integer
                 := SOAP.Parameters.Get (R_Param, "outputInteger");
            begin
               return Result;
            end;
         end if;
      end;
   end echoInteger;

   ----------------------
   -- echoIntegerArray --
   ----------------------

   function echoIntegerArray
     (inputIntegerArray : in ArrayOfint)
      return echoIntegerArray_Result
   is
      P_Set   : SOAP.Parameters.List;
      Payload : SOAP.Message.Payload.Object;
   begin
      --  Set parameters
      P_Set := +A (To_Object_Set (inputIntegerArray), "inputIntegerArray");
      Payload := SOAP.Message.Payload.Build
        ("echoIntegerArray", P_Set, "http://soapinterop.org/");

      declare
         Response : constant SOAP.Message.Response.Object'Class
           := SOAP.Client.Call
                ("http://soap.4s4c.com/ilab/soap.asp",
                 Payload,
                 "http://soapinterop.org/");
         R_Param  : constant SOAP.Parameters.List
           := SOAP.Message.Parameters (Response);
      begin
         if SOAP.Message.Response.Is_Error (Response) then
            Ada.Exceptions.Raise_Exception
              (SOAP.SOAP_Error'Identity,
               SOAP.Parameters.Get (R_Param, "faultstring"));
         else
            declare
               Result : constant echoIntegerArray_Result
                 := To_ArrayOfint
                 (V (SOAP_Array'(SOAP.Parameters.Get (R_Param, "outputIntegerArray"))));
            begin
               return Result;
            end;
         end if;
      end;
   end echoIntegerArray;

   ---------------
   -- echoFloat --
   ---------------

   function echoFloat
     (inputFloat : in Long_Float)
      return Long_Float
   is
      P_Set   : SOAP.Parameters.List;
      Payload : SOAP.Message.Payload.Object;
   begin
      --  Set parameters
      P_Set := +SOAP.Types.F (inputFloat, "inputFloat");
      Payload := SOAP.Message.Payload.Build
        ("echoFloat", P_Set, "http://soapinterop.org/");

      declare
         Response : constant SOAP.Message.Response.Object'Class
           := SOAP.Client.Call
                ("http://soap.4s4c.com/ilab/soap.asp",
                 Payload,
                 "http://soapinterop.org/");
         R_Param  : constant SOAP.Parameters.List
           := SOAP.Message.Parameters (Response);
      begin
         if SOAP.Message.Response.Is_Error (Response) then
            Ada.Exceptions.Raise_Exception
              (SOAP.SOAP_Error'Identity,
               SOAP.Parameters.Get (R_Param, "faultstring"));
         else
            declare
               Result : constant Long_Float
                 := SOAP.Parameters.Get (R_Param, "outputFloat");
            begin
               return Result;
            end;
         end if;
      end;
   end echoFloat;

   --------------------
   -- echoFloatArray --
   --------------------

   function echoFloatArray
     (inputFloatArray : in ArrayOffloat)
      return echoFloatArray_Result
   is
      P_Set   : SOAP.Parameters.List;
      Payload : SOAP.Message.Payload.Object;
   begin
      --  Set parameters
      P_Set := +A (To_Object_Set (inputFloatArray), "inputFloatArray");
      Payload := SOAP.Message.Payload.Build
        ("echoFloatArray", P_Set, "http://soapinterop.org/");

      declare
         Response : constant SOAP.Message.Response.Object'Class
           := SOAP.Client.Call
                ("http://soap.4s4c.com/ilab/soap.asp",
                 Payload,
                 "http://soapinterop.org/");
         R_Param  : constant SOAP.Parameters.List
           := SOAP.Message.Parameters (Response);
      begin
         if SOAP.Message.Response.Is_Error (Response) then
            Ada.Exceptions.Raise_Exception
              (SOAP.SOAP_Error'Identity,
               SOAP.Parameters.Get (R_Param, "faultstring"));
         else
            declare
               Result : constant echoFloatArray_Result
                 := To_ArrayOffloat
                 (V (SOAP_Array'(SOAP.Parameters.Get (R_Param, "outputFloatArray"))));
            begin
               return Result;
            end;
         end if;
      end;
   end echoFloatArray;

   ----------------
   -- echoStruct --
   ----------------

   function echoStruct
     (inputStruct : in SOAPStruct_Type)
      return echoStruct_Result
   is
      P_Set   : SOAP.Parameters.List;
      Payload : SOAP.Message.Payload.Object;
   begin
      --  Set parameters
      P_Set := +R ((+SOAP.Types.I (inputStruct.varInt, "varInt"),
         +SOAP.Types.F (inputStruct.varFloat, "varFloat"),
            +SOAP.Utils.US (inputStruct.varString, "varString")), "inputStruct");
      Payload := SOAP.Message.Payload.Build
        ("echoStruct", P_Set, "http://soapinterop.org/");

      declare
         Response : constant SOAP.Message.Response.Object'Class
           := SOAP.Client.Call
                ("http://soap.4s4c.com/ilab/soap.asp",
                 Payload,
                 "http://soapinterop.org/");
         R_Param  : constant SOAP.Parameters.List
           := SOAP.Message.Parameters (Response);
      begin
         if SOAP.Message.Response.Is_Error (Response) then
            Ada.Exceptions.Raise_Exception
              (SOAP.SOAP_Error'Identity,
               SOAP.Parameters.Get (R_Param, "faultstring"));
         else
            declare
               Result : constant echoStruct_Result
                 := To_SOAPStruct_Type
                 (SOAP_Record'(SOAP.Parameters.Get (R_Param, "outputStruct")));
            begin
               return Result;
            end;
         end if;
      end;
   end echoStruct;

   ---------------------
   -- echoStructArray --
   ---------------------

   function echoStructArray
     (inputStructArray : in ArrayOfSOAPStruct)
      return echoStructArray_Result
   is
      P_Set   : SOAP.Parameters.List;
      Payload : SOAP.Message.Payload.Object;
   begin
      --  Set parameters
      P_Set := +A (To_Object_Set (inputStructArray), "inputStructArray");
      Payload := SOAP.Message.Payload.Build
        ("echoStructArray", P_Set, "http://soapinterop.org/");

      declare
         Response : constant SOAP.Message.Response.Object'Class
           := SOAP.Client.Call
                ("http://soap.4s4c.com/ilab/soap.asp",
                 Payload,
                 "http://soapinterop.org/");
         R_Param  : constant SOAP.Parameters.List
           := SOAP.Message.Parameters (Response);
      begin
         if SOAP.Message.Response.Is_Error (Response) then
            Ada.Exceptions.Raise_Exception
              (SOAP.SOAP_Error'Identity,
               SOAP.Parameters.Get (R_Param, "faultstring"));
         else
            declare
               Result : constant echoStructArray_Result
                 := To_ArrayOfSOAPStruct
                 (V (SOAP_Array'(SOAP.Parameters.Get (R_Param, "outputStructArray"))));
            begin
               return Result;
            end;
         end if;
      end;
   end echoStructArray;

   --------------
   -- echoDate --
   --------------

   function echoDate
     (inputDate : in Ada.Calendar.Time)
      return Ada.Calendar.Time
   is
      P_Set   : SOAP.Parameters.List;
      Payload : SOAP.Message.Payload.Object;
   begin
      --  Set parameters
      P_Set := +SOAP.Types.T (inputDate, "inputDate");
      Payload := SOAP.Message.Payload.Build
        ("echoDate", P_Set, "http://soapinterop.org/");

      declare
         Response : constant SOAP.Message.Response.Object'Class
           := SOAP.Client.Call
                ("http://soap.4s4c.com/ilab/soap.asp",
                 Payload,
                 "http://soapinterop.org/");
         R_Param  : constant SOAP.Parameters.List
           := SOAP.Message.Parameters (Response);
      begin
         if SOAP.Message.Response.Is_Error (Response) then
            Ada.Exceptions.Raise_Exception
              (SOAP.SOAP_Error'Identity,
               SOAP.Parameters.Get (R_Param, "faultstring"));
         else
            declare
               Result : constant Ada.Calendar.Time
                 := SOAP.Parameters.Get (R_Param, "outputDate");
            begin
               return Result;
            end;
         end if;
      end;
   end echoDate;

   ----------------
   -- echoBase64 --
   ----------------

   function echoBase64
     (inputBase64 : in String)
      return String
   is
      P_Set   : SOAP.Parameters.List;
      Payload : SOAP.Message.Payload.Object;
   begin
      --  Set parameters
      P_Set := +SOAP.Types.B64 (inputBase64, "inputBase64");
      Payload := SOAP.Message.Payload.Build
        ("echoBase64", P_Set, "http://soapinterop.org/");

      declare
         Response : constant SOAP.Message.Response.Object'Class
           := SOAP.Client.Call
                ("http://soap.4s4c.com/ilab/soap.asp",
                 Payload,
                 "http://soapinterop.org/");
         R_Param  : constant SOAP.Parameters.List
           := SOAP.Message.Parameters (Response);
      begin
         if SOAP.Message.Response.Is_Error (Response) then
            Ada.Exceptions.Raise_Exception
              (SOAP.SOAP_Error'Identity,
               SOAP.Parameters.Get (R_Param, "faultstring"));
         else
            declare
               Result : constant String
                 := V (SOAP_Base64'(SOAP.Parameters.Get (R_Param, "outputBase64")));
            begin
               return Result;
            end;
         end if;
      end;
   end echoBase64;

   -----------------
   -- echoBoolean --
   -----------------

   function echoBoolean
     (inputBoolean : in Boolean)
      return Boolean
   is
      P_Set   : SOAP.Parameters.List;
      Payload : SOAP.Message.Payload.Object;
   begin
      --  Set parameters
      P_Set := +SOAP.Types.B (inputBoolean, "inputBoolean");
      Payload := SOAP.Message.Payload.Build
        ("echoBoolean", P_Set, "http://soapinterop.org/");

      declare
         Response : constant SOAP.Message.Response.Object'Class
           := SOAP.Client.Call
                ("http://soap.4s4c.com/ilab/soap.asp",
                 Payload,
                 "http://soapinterop.org/");
         R_Param  : constant SOAP.Parameters.List
           := SOAP.Message.Parameters (Response);
      begin
         if SOAP.Message.Response.Is_Error (Response) then
            Ada.Exceptions.Raise_Exception
              (SOAP.SOAP_Error'Identity,
               SOAP.Parameters.Get (R_Param, "faultstring"));
         else
            declare
               Result : constant Boolean
                 := SOAP.Parameters.Get (R_Param, "return");
            begin
               return Result;
            end;
         end if;
      end;
   end echoBoolean;

end interopLab.Client;
