/***************************************************************************
 $RCSfile: pageuserdata.cpp,v $
 -------------------
 cvs         : $Id: pageuserdata.cpp,v 1.20 2005/04/14 04:32:09 aquamaniac Exp $
 begin       : Mon Mar 01 2004
 copyright   : (C) 2004 by Martin Preuss
 email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "wizard.h"
#include "kbanking.h"
#include "selectbank.h"
#include "selectcontext.h"
#include <qradiobutton.h>
#include <qpushbutton.h>
#include <qwizard.h>
#include <qcombobox.h>
#include <qtextbrowser.h>
#include <qlabel.h>

#include <qlineedit.h>
#include <qmessagebox.h>
#include <qfiledialog.h>
#include <qpalette.h>
#include <qbrush.h>
#include <qpainter.h>
#include <qpaintdevicemetrics.h>
#include <qprinter.h>
#include <qsimplerichtext.h>
#include <qtextview.h>


#include <gwenhywfar/debug.h>

#include <aqhbci/mediumrdh.h>



bool Wizard::initUserDataPage() {
  slotSettingsChanged("");
  QObject::connect((QObject*)(userIdEdit),
                   SIGNAL(textChanged(const QString &)),
                   this,
                   SLOT(slotSettingsChanged(const QString &)));
  QObject::connect((QObject*)(customerIdEdit),
                   SIGNAL(textChanged(const QString &)),
                   this,
                   SLOT(slotSettingsChanged(const QString &)));
  QObject::connect((QObject*)(bankCodeEdit),
                   SIGNAL(textChanged(const QString &)),
                   this,
                   SLOT(slotSettingsChanged(const QString &)));
  QObject::connect((QObject*)(serverEdit),
                   SIGNAL(textChanged(const QString &)),
                   this,
                   SLOT(slotSettingsChanged(const QString &)));
  QObject::connect((QObject*)(nameEdit),
                   SIGNAL(textChanged(const QString &)),
                   this,
                   SLOT(slotSettingsChanged(const QString &)));
  QObject::connect((QObject*)(descriptionEdit),
                   SIGNAL(textChanged(const QString &)),
                   this,
                   SLOT(slotSettingsChanged(const QString &)));
  QObject::connect((QObject*)(fromMediumButton),
                   SIGNAL(clicked()),
                   this,
                   SLOT(slotFromMedium()));
  QObject::connect((QObject*)(bankCodeButton),
		   SIGNAL(clicked()),
                   this,
		   SLOT(slotUserDataBankCodeClicked()));
  QObject::connect((QObject*)(bankCodeEdit),
		   SIGNAL(lostFocus()),
		   this,
		   SLOT(slotUserDataBankCodeLostFocus()));
  QObject::connect((QObject*)(bankCodeEdit),
                   SIGNAL(textChanged(const QString&)),
                   this,
		   SLOT(slotUserDataBankCodeChanged(const QString&)));

  return true;
}



void Wizard::slotFromMedium(){
  SelectContext *sc;
  std::string instcode;
  std::string userid;
  std::string server;
  bool rv;

  sc=new SelectContext(_hbci, _medium);
  rv=sc->selectContext(instcode,
                       userid,
                       server);
  delete sc;
  if (!rv)
    return;

  // otherwise set the text
  bankCodeEdit->setText(instcode.c_str());
  userIdEdit->setText(userid.c_str());
  serverEdit->setText(server.c_str());
  slotSettingsChanged("");
}



QString Wizard::getServerAddr() const {
  QString entered = serverEdit->text();
  const char * stripthis[] = { "http://", "https://", 0 };
  for (const char **a = stripthis ; *a != 0; a++) {
    if (entered.startsWith(*a))
      return entered.mid(strlen(*a));
  }
  serverEdit->setText(entered);
  return entered;
}



bool Wizard::doUserDataPage(QWidget *p){
  const char *cuid;
  GWEN_INETADDRESS *addr;
  GWEN_ERRORCODE err;
  QString qs;
  int i;
  int idx=-1;

  /* do user data page, we have to create the medium etc */
  if (bankCodeEdit->text().length()<8) {
    QMessageBox::critical(0,
                          tr("Invalid Input"),
                          tr("<qt>"
                             "<p>"
                             "The bank code needs at least 8 digits."
                             "</p>"
                             "<p>"
                             "Please correct your entry."
                             "</p>"),
                          tr("Dismiss"),0,0,0);
    return false;
  }

  if (!_bankInfo) {
    std::string s;

    s=KBanking::QStringToUtf8String(bankCodeEdit->text());
    if (!s.empty()) {
      AB_BANKINFO *bi;

      bi=AB_Banking_GetBankInfo(_app->getCInterface(),
                                "de", 0, s.c_str());
      AB_BankInfo_free(_bankInfo);
      _bankInfo=bi;
    }
    else {
      AB_BankInfo_free(_bankInfo);
      _bankInfo=0;
    }
  }

  if (!_bankInfo) {
    if (QMessageBox::critical(0,
                              tr("Unknown Bank"),
                              tr("<qt>"
                                 "<p>"
                                 "The bank you selected is unknown."
                                 "</p>"
                                 "<p>"
                                 "Do you want to use it anyway?"
                                 "</p>"),
                              tr("Yes"),tr("No, let me edit"),0,0)!=0)
      return false;
  }


  _hasAllKeys=false;
  if (customerIdEdit->text().isEmpty()) {
    if (QMessageBox::warning(0,
                             tr("No customer id found"),
                             tr("<qt>"
                                "<p>"
                                "You did not enter a customer id."
                                "</p>"
                                "<p>Many banks do not need an explicit customer id. But some other "
				"banks absolutey require a customer id. Please double-check the "
				"information provided to you by your bank.</p>"
                                "<p>"
                                "Are you sure you want to leave the customer "
                                "id empty?"
                                "</p>"
                                "</qt>"
                               ),
                             tr("Yes"),
                             tr("No"),0,0)!=0) {
      customerIdEdit->setFocus();
      return false;
    }
  }

  if (_mediumCreated) {
    idx=AH_Medium_CreateContext(_medium, 280,
                                bankCodeEdit->text().latin1(),
                                userIdEdit->text().latin1());
    if (idx<0) {
      DBG_ERROR(0, "Could not create user on medium");
      QMessageBox::critical(0,
                            tr("Medium error"),
                            tr("Could not create user on the medium.\n"
                               "Please check the console logs."),
                            tr("Dismiss"),0,0,0);
      return false;
    }
    _mediumUserCreated=true;

    /* try to select the newly created context */
    idx=AH_Medium_FindContext(_medium,
                              280,
                              bankCodeEdit->text().latin1(),
                              userIdEdit->text().latin1());
    if (idx<0) {
      DBG_ERROR(0, "Context does not exist on medium");
      QMessageBox::critical(0,
                            tr("Medium error"),
                            tr("<qt><p>After creating the user on the medium "
                               "it still does not exist. Either this is a program error, or the medium "
                               "type is not supported, or the medium has errors.</p></qt>"),
                            tr("Dismiss"),0 , 0, 0);
      return false;
    }
  } // if mediumCreated
  else {
    int rv;

    if (!AH_Medium_IsMounted(_medium)) {
      rv=AH_Medium_Mount(_medium);
      if (rv) {
        DBG_ERROR(0, "Could not mount medium (%d)", rv);
        QMessageBox::critical(0,
                              tr("Medium error"),
                              tr("Could not mount the medium.\n"
                                 "Please check the console logs."),
                              tr("Dismiss"),0,0,0);
        return false;
      }
    }

    idx=AH_Medium_FindContext(_medium,
                              280,
                              bankCodeEdit->text().latin1(),
                              userIdEdit->text().latin1());
    if (idx==-1) {
      DBG_ERROR(AQHBCI_LOGDOMAIN,
                "Context for \"%d:%s/%s\" not found on this medium",
                280,
                bankCodeEdit->text().latin1(),
                userIdEdit->text().latin1());
      if (QMessageBox::warning(0,
                               tr("Missing user"),
                               tr("<qt><p>This user does not exist on the medium. "
                                  "I can try to add it automatically but not all media "
                                  "support this feature."
                                  "</p><p>"
                                  "However, if you misspelled any part of the user information then "
                                  "please answer \"Abort\", go back and revise your input.</p>"
                                  "<p>"
                                  "Do you want me to create this user on the medium?</p></qt>"),
                               tr("Yes"),tr("Abort"),0,0)!=0) {
        DBG_INFO(0, "User aborted");
        return false;
      }
      // try to create the context
      DBG_INFO(0, "Creating context on medium");
      idx=AH_Medium_CreateContext(_medium,
                                  280,
                                  bankCodeEdit->text().latin1(),
                                  userIdEdit->text().latin1());
      if (idx<0) {
        DBG_ERROR(0, "Could not create user on medium");
        QMessageBox::critical(0,
                              tr("Medium error"),
                              tr("<qt><p>Could not create user on the medium."
                                 "</p><p>"
                                 "Maybe this feature is not supported by "
                                 "the medium."
                                 "</p><p>"
                                 "In that case please report this to the "
                                 "author of that security medium (or to "
                                 "  martin@aquamaniac.de).</p></qt>"
                                ),
                              tr("Dismiss"),0,0,0);
        return false;
      }

      /* try to select the newly created context */
      rv=AH_Medium_SelectContext(_medium, idx);
      if (rv) {
        DBG_ERROR(0, "Context does not exist on medium");
        QMessageBox::critical(0,
                              tr("Medium error"),
                              tr("<qt><p>After creating the user on the medium "
                                 "it still does not exist. Either this is a program error, or the medium "
                                 "type is not supported, or the medium has errors.</p></qt>"),
                              tr("Dismiss"),0 , 0, 0);
        return false;
      }

      _mediumUserCreated=true;
    } /* if user not found */
    else {
      /* user existed, not created */
      _mediumUserCreated=false;
    }
  } /* if !_mediumCreated */

  /* now the correct user is selected */
  if (AH_Medium_GetMediumType(_medium)==AH_MediumTypeRDH) {
    GWEN_CRYPTKEY *key1, *key2;

    key1=AH_MediumRDH_GetLocalPubSignKey(_medium);
    key2=AH_MediumRDH_GetLocalPubCryptKey(_medium);
    GWEN_CryptKey_free(key2);
    GWEN_CryptKey_free(key1);
    if (key1 && key2) {
      _hasAllKeys=true;
      DBG_NOTICE(0, "All user keys exist");
    }
  }

  /* We just store the data on the medium for the convenience of the next
   * importing user. E.g. if another HBCI library wants to import our data
   * it is easier to provide some usefull information here.
   * AqHBCI itself does not use the address/port/system id from the medium.
   * Another reason to store this data here is that some media - most
   * importantly DDV cards - provide this data, too.
   */
  qs=getServerAddr();
  i=qs.find('/');
  if (i)
    qs.truncate(i);
  addr=GWEN_InetAddr_new(GWEN_AddressFamilyIP);
  err=GWEN_InetAddr_SetAddress(addr, qs.latin1());
  if (!GWEN_Error_IsOk(err)) {
    GWEN_TYPE_UINT32 wid;

    wid=AB_Banking_ShowBox(_app->getCInterface(),
                           0,
                           QWidget::tr("Please Wait").latin1(),
                           QWidget::tr("Resolving host address...").latin1());
    DBG_INFO(0, "Resolving hostname \"%s\"",
             qs.latin1());
    err=GWEN_InetAddr_SetName(addr, qs.latin1());
    if (wid)
      AB_Banking_HideBox(_app->getCInterface(), wid);
    if (!GWEN_Error_IsOk(err)) {
      DBG_ERROR(0,
                "Error resolving hostname \"%s\":",
                qs.latin1());
      DBG_ERROR_ERR(0, err);
      QMessageBox::critical(0,
			    QWidget::tr("Network Error"),
			    QWidget::tr("Could not resolve the address %1.\n"
                                        "Maybe there is a typo?")
                            .arg(qs),
			    QWidget::tr("Dismiss"),0,0,0);
      GWEN_InetAddr_free(addr);
      return false;
    }
  }
  GWEN_InetAddr_free(addr);

  AH_Medium_SetPeerAddr(_medium, qs.latin1());
  if (AH_Medium_GetMediumType(_medium)==AH_MediumTypePINTAN)
    AH_Medium_SetPeerPort(_medium, 443);
  else
    AH_Medium_SetPeerPort(_medium, 3000);

  /* select or create bank */
  _bank=AH_HBCI_FindBank(_hbci, 280, bankCodeEdit->text().latin1());
  if (!_bank) {
    /* create bank */
    DBG_INFO(0, "Creating bank");
    _bank=AH_Bank_new(_hbci, 280, bankCodeEdit->text().latin1());
    AH_HBCI_AddBank(_hbci, _bank);
    _bankCreated=true;
  }
  else {
    _bankCreated=false;
  }

  /* select or create user */
  _user=AH_Bank_FindUser(_bank, userIdEdit->text().latin1());
  if (!_user) {
    AH_BPD_ADDR *ba;

    DBG_INFO(0, "Creating user");
    _user=AH_User_new(_bank, userIdEdit->text().latin1(), _medium);
    assert(_user);
    ba=AH_BpdAddr_new();
    assert(ba);
    AH_BpdAddr_SetAddr(ba, getServerAddr().latin1());
    if (AH_Medium_GetMediumType(_medium)==AH_MediumTypePINTAN) {
      AH_BpdAddr_SetType(ba, AH_BPD_AddrTypeSSL);
      AH_BpdAddr_SetSuffix(ba, "443");
    }
    else {
      AH_BpdAddr_SetType(ba, AH_BPD_AddrTypeTCP);
      AH_BpdAddr_SetSuffix(ba, "3000");
    }
    AH_User_SetAddress(_user, ba);
    AH_BpdAddr_free(ba);

    AH_Bank_AddUser(_bank, _user);
    _userCreated=true;
  }
  else {
    QMessageBox::critical(0,
                          tr("User Exists"),
                          tr("<qt>"
                             "<p>"
                             "The user already exists."
                             "</p>"
                             "<p>"
                             "This setup is not necessary for users "
                             "which have already been set up."
                             "</p>"
                             "<p>"
                             "Please press <i>cancel</i> after dismissing "
                             "this message."
                             "</p>"
                             "</qt>"
                            ),
                          tr("Dismiss"),0,0,0);
    _user=0;
    _userCreated=false;
    return false;
  }
  AH_User_SetContextIdx(_user, idx);

  /* select or create customer */
  if (!customerIdEdit->text().isEmpty())
    cuid=customerIdEdit->text().latin1();
  else
    cuid=userIdEdit->text().latin1();
  /* always create customer since we just created the user which starts with
   * an empty list of customers. So the customer we are about to create
   * *can* not exist. */
  _customer=AH_Customer_new(_user, cuid);
  AH_Customer_SetFullName(_customer, nameEdit->text().latin1());

  /* Set a descriptiveName in the medium. */
  if (!descriptionEdit->text().isEmpty())
    AH_Medium_SetDescriptiveName(_medium, descriptionEdit->text().utf8());

  if (AH_Medium_GetMediumType(_medium)==AH_MediumTypePINTAN) {
    /* PIN/TAN only works with HBCI version 2.20. It might work with
     * other versions as well but this is not defined in the specs. */
    AH_Customer_SetHbciVersion(_customer, 220);
    _enableServerTest=false;
    setAppropriate(serverTestPage, false);
  }
  else {
    _enableServerTest=true;
    if (_bankInfo) {
      AB_BANKINFO_SERVICE *sv;

      sv=AB_BankInfoService_List_First(AB_BankInfo_GetServices(_bankInfo));
      while (sv) {
        const char *s;

        s=AB_BankInfoService_GetType(sv);
        if (s && strcasecmp(s, "HBCI")==0) {
          s=AB_BankInfoService_GetMode(sv);
          if (s && strcasecmp(s, "PINTAN")!=0) {
            s=AB_BankInfoService_GetPversion(sv);
            if (s) {
              int set=1;

              if (strcmp(s, "2.01")==0)
                AH_Customer_SetHbciVersion(_customer, 201);
              else if (strcmp(s, "2.10")==0)
                AH_Customer_SetHbciVersion(_customer, 210);
              else if (strcmp(s, "2.20")==0)
                AH_Customer_SetHbciVersion(_customer, 220);
              else
                set=0;
              if (set) {
                _enableServerTest=false;
                setAppropriate(serverTestPage, false);
              }
            }
          }

        }
        sv=AB_BankInfoService_List_Next(sv);
      }
    }
  }

  AH_User_AddCustomer(_user, _customer);
  _customerCreated=true;

  setAppropriate(initModePage, false);
  _firstInitMode=true;

  if (_importMode) {
    if (AH_Medium_GetMediumType(_medium)==AH_MediumTypeRDH) {
      if (_hasAllKeys) {
        DBG_NOTICE(0, "All user keys exist, asking for first init");
      }
      setAppropriate(initModePage, _hasAllKeys);
    } // if RDH mode
  } /* if not import mode */
  else {
    // not in import mode
    setAppropriate(initModePage, false);
  }

  return true;
}



bool Wizard::undoUserDataPage(QWidget *p){
  // handle bank, user, customer
  if (_bank) {
    if (_bankCreated) {
      /* bank created, so by removing the bank we also remove all other
       * objects below it */
      DBG_INFO(0, "Removing bank and all subordinate objects");
      AH_HBCI_RemoveBank(_hbci, _bank);
      AH_Bank_free(_bank);
    } // if bank created
    else {
      if (_user) {
        if (_userCreated) {
          /* user created, so by removing the user we also remove all other
           * objects below it */
          DBG_INFO(0, "Removing user and all subordinate objects");
          AH_Bank_RemoveUser(_bank, _user);
          AH_User_free(_user);
        } // if _userCreated
        else {
          if (_customer) {
            if (_customerCreated) {
              DBG_INFO(0, "Removing customer");
              AH_User_RemoveCustomer(_user, _customer);
              AH_Customer_free(_customer);
            } // if customer created
          } // if customer
        } // if user not created
      } // if user
    } // if bank not created
  } // if bank
  _customer=0;
  _user=0;
  _bank=0;
  _bankCreated=_userCreated=_customerCreated=false;
  _enableServerTest=true;

  /* reset medium if we created it... */
  if (_medium && _mediumUserCreated) {
    DBG_INFO(0, "Removing user from medium");
    if (AH_Medium_RemoveContext(_medium, AH_User_GetContextIdx(_user))){
      DBG_ERROR(0, "Could not remove user from medium");
      QMessageBox::critical(0,
                            tr("Warning"),
                            tr("The medium does not support removing of\n"
                               "users we added before.\n"
                               "\n"
                               "This means that the user created before\n"
                               "will remain on the medium.\n"
                               "\n"
                               "However, this may present a problem later\n"
                               "in the setup. In that case please send\n"
                               "a message to the manufacturer of that medium\n"
                               "and ask them to implement that feature."
                              ),
                            tr("Dismiss"),0,0,0);
    } // if we could not remove the user
  } // if user on medium created

  return true;
}



void Wizard::slotUserDataBankCodeLostFocus() {
  std::string s;

  s=KBanking::QStringToUtf8String(bankCodeEdit->text());
  AB_BankInfo_free(_bankInfo);
  _bankInfo=0;
  if (!s.empty()) {
    AB_BANKINFO *bi;

    bi=AB_Banking_GetBankInfo(_app->getCInterface(),
                              "de", 0, s.c_str());
    if (bi) {
      const char *p;

      p=AB_BankInfo_GetBankName(bi);
      if (p)
        bankNameLabel->setText(QString::fromUtf8(p));
    }
    AB_BankInfo_free(_bankInfo);
    _bankInfo=bi;
  }
}



void Wizard::slotUserDataBankCodeChanged(const QString&) {
  if (_bankInfo) {
    DBG_ERROR(0, "Deleting current bank info");
    AB_BankInfo_free(_bankInfo);
    _bankInfo=0;
  }
}



void Wizard::slotUserDataBankCodeClicked() {
  AB_BANKINFO *bi;

  AB_BankInfo_free(_bankInfo);
  _bankInfo=0;
  bi=SelectBank::selectBank(_app,
                            0,
                            tr("Select a Bank"),
                            bankCodeEdit->text());
  if (bi) {
    const char *s;
    AB_BANKINFO_SERVICE *sv;
    bool isPinTan;

    s=AB_BankInfo_GetBankId(bi);
    if (s)
      bankCodeEdit->setText(QString::fromUtf8(s));

    sv=AB_BankInfoService_List_First(AB_BankInfo_GetServices(bi));
    isPinTan=(AH_Medium_GetMediumType(_medium)==AH_MediumTypePINTAN);

    while(sv) {
      s=AB_BankInfoService_GetType(sv);
      if (s && strcasecmp(s, "HBCI")==0) {
        s=AB_BankInfoService_GetMode(sv);
        if (s) {
          if (!((strcasecmp(s, "PINTAN")==0) ^ isPinTan)) {
            s=AB_BankInfoService_GetAddress(sv);
            serverEdit->setText(QString::fromUtf8(s));
            _bankInfo=bi;
            break;
          }
        }
      }
      sv=AB_BankInfoService_List_Next(sv);
    }
  }
}


























