#!/usr/bin/perl -w
#
#  Test that DropParamValue works as expected
#
# $Id: drop-param-value.t,v 1.5 2006/07/18 14:24:23 steve Exp $
#

use Test::More qw( no_plan );

#
#  Utility functions for adding a test snippet to Apaches configuration tree.
#
require 'tests/apache.utils';


cleanConf();

    my $conf = <<EOF;
DropAction status=403
DropParamValue foo bar
DropParamValue steve kemp status=500
EOF

writeConf( $conf );
restart();


#
#  Get a random path, so we can be sure we'll get a 404 code.
#
my $path = join ( '', map {('a'..'z')[rand 26]} 0..7 );


#
#  Now we make some requests.
#
is( makeGETRequest( "/$path" ),
    404, "/$path allowed as expected" );

is( makeGETRequest( "/?foo=x" ),
    200, "foo parameter allowed as expected: GET" );
is( makeHEADRequest( "/?foo=x" ),
    200, "foo parameter allowed as expected: HEAD" );
is( makePOSTRequest( "/?foo=x" ),
    200, "foo parameter allowed as expected: POST" );


is( makeGETRequest( "/?foo=bar" ),
    403, "foo paramater matched as expected: GET" );
is( makeHEADRequest( "/?foo=bar" ),
    403, "foo parameter matched as expected: HEAD" );
is( makePOSTRequest( "/?foo=bar" ),
    403, "foo parameter matched as expected: POST" );



is( makeGETRequest( "/?steve=kemp" ),
    500, "Custom rule matched as expected: GET" );
is( makeHEADRequest( "/?steve=kemp" ),
    500, "Custom rule matched as expected: HEAD" );
is( makePOSTRequest( "/?steve=kemp" ),
    500, "Custom rule matched as expected: POST" );


#
#  Cleanup
#
cleanConf();
restart();
