=begin

= mod_ruby Class Reference Manual

[((<Index|URL:index.en.html>))
|((<RD format|URL:classes.en.rd>))]

* ((<Apache>))
* ((<Apache::Request>))
* ((<Apache::Table>))
* ((<Apache::Server>))
* ((<Apache::Connection>))

== Apache

A module to provide Apache functions.

=== Module Functions

--- add_version_component
      Add a token to Apache's version string.

--- chdir_file(str)
      Change the server's current working directory to the directory part of the
      specified filename.

--- request
      Returns the current ((<Apache::Request>)) object.

--- server_root
      Returns the server's root directory (ie., the one set by the
      ((|ServerRoot|)) directive).

--- server_built
      Returns the server built date string.

--- server_version
      Returns the server version string.

--- unescape_url(str)
      Decodes a URL-encoded string.


=== Constants
--- Handler status return codes
      OK,
      DECLINED,
      DONE

--- HTTP response codes
      AUTH_REQUIRED, 
      BAD_GATEWAY, 
      BAD_REQUEST, 
      DOCUMENT_FOLLOWS, 
      FORBIDDEN, 
      HTTP_ACCEPTED, 
      HTTP_BAD_GATEWAY, 
      HTTP_BAD_REQUEST, 
      HTTP_CONFLICT, 
      HTTP_CONTINUE, 
      HTTP_CREATED, 
      HTTP_EXPECTATION_FAILED, 
      HTTP_FAILED_DEPENDENCY((-if implemented-)), 
      HTTP_FORBIDDEN, 
      HTTP_GATEWAY_TIME_OUT, 
      HTTP_GONE, 
      HTTP_INSUFFICIENT_STORAGE((-if implemented-)),
      HTTP_INTERNAL_SERVER_ERROR, 
      HTTP_LENGTH_REQUIRED, 
      HTTP_LOCKED, 
      HTTP_METHOD_NOT_ALLOWED, 
      HTTP_MOVED_PERMANENTLY, 
      HTTP_MOVED_TEMPORARILY, 
      HTTP_MULTIPLE_CHOICES, 
      HTTP_MULTI_STATUS, 
      HTTP_NON_AUTHORITATIVE, 
      HTTP_NOT_ACCEPTABLE, 
      HTTP_NOT_EXTENDED, 
      HTTP_NOT_FOUND, 
      HTTP_NOT_IMPLEMENTED, 
      HTTP_NOT_MODIFIED, 
      HTTP_NO_CONTENT, 
      HTTP_OK, 
      HTTP_PARTIAL_CONTENT, 
      HTTP_PAYMENT_REQUIRED, 
      HTTP_PRECONDITION_FAILED, 
      HTTP_PROCESSING, 
      HTTP_PROXY_AUTHENTICATION_REQUIRED, 
      HTTP_RANGE_NOT_SATISFIABLE, 
      HTTP_REQUEST_ENTITY_TOO_LARGE, 
      HTTP_REQUEST_TIME_OUT, 
      HTTP_REQUEST_URI_TOO_LARGE, 
      HTTP_RESET_CONTENT, 
      HTTP_SEE_OTHER, 
      HTTP_SERVICE_UNAVAILABLE, 
      HTTP_SWITCHING_PROTOCOLS, 
      HTTP_TEMPORARY_REDIRECT, 
      HTTP_UNAUTHORIZED, 
      HTTP_UNPROCESSABLE_ENTITY, 
      HTTP_UNSUPPORTED_MEDIA_TYPE, 
      HTTP_USE_PROXY, 
      HTTP_VARIANT_ALSO_VARIES, 
      HTTP_VERSION_NOT_SUPPORTED, 
      LENGTH_REQUIRED, 
      METHOD_NOT_ALLOWED, 
      MOVED, 
      MULTIPLE_CHOICES, 
      NOT_ACCEPTABLE, 
      NOT_FOUND, 
      NOT_IMPLEMENTED, 
      PARTIAL_CONTENT, 
      PRECONDITION_FAILED, 
      REDIRECT, 
      SERVER_ERROR, 
      USE_LOCAL_COPY, 
      VARIANT_ALSO_VARIES

--- Request method constants
      For testing against the return value of
      ((<Apache::Request#method_number|method_number>)).

      M_CONNECT, 
      M_COPY, 
      M_DELETE, 
      M_GET, 
      M_INVALID, 
      M_LOCK, 
      M_MKCOL, 
      M_MOVE, 
      M_OPTIONS, 
      M_PATCH, 
      M_POST, 
      M_PROPFIND, 
      M_PROPPATCH, 
      M_PUT, 
      M_TRACE, 
      M_UNLOCK, 
      METHODS

--- Options bitmask constants
      Constants for testing for enabled options via
      ((<Apache::Request#allow_options|allow_options>)).

      OPT_ALL,
      OPT_EXECCGI, 
      OPT_INCLUDES, 
      OPT_INCNOEXEC, 
      OPT_INDEXES, 
      OPT_MULTI, 
      OPT_NONE, 
      OPT_SYM_LINKS, 
      OPT_SYM_OWNER, 
      OPT_UNSET

--- Satisfy constants
      Constants for testing the return value of the
      ((<Apache::Request#satisfies|satisfies>)) method.

      SATISFY_ALL,
      SATISFY_ANY, 
      SATISFY_NOSPEC

--- Remotehost constants
      Constants which can be (optionally) passed to
      ((<Apache::Request#remote_host|remote_host>)) to affect what type of
      lookup is performed.

      REMOTE_DOUBLE_REV,
      REMOTE_HOST, 
      REMOTE_NAME, 
      REMOTE_NOLOOKUP



[((<Back to Index|mod_ruby Class Reference Manual>))]

== Apache::Request

A class to wrap (({request_rec})) data type.

=== Superclass

Object

=== Included Modules

Enumerable

=== Methods

--- hostname
      Returns the hostname, as set by full URI or Host:.

--- unparsed_uri
      Returns the uri without any parsing performed.

--- uri
--- uri= str
      Returns/sets the path portion of the URI.

--- filename
--- filename=
      Returns/sets the translated physical pathname of the document as
      determined during the URI translation phase.

--- path_info
--- path_info= str
      Returns/sets the additional path information that remains after the URI
      has been translated into a file path.

--- status
--- status=
      Returns/sets the numeric status code of the transaction.

--- status_line
--- status_line= str
      Returns/sets the full text of the status line returned from Apache to the
      remote browser (eg., (({200 OK}))).

--- request_time
      Returns the time when the request started.

--- request_method
      Returns the request method as a string (eg., "GET", "HEAD", "POST").

--- method_number
      Returns the request method as a (({Integer})). You can compare them to the
      ((<request method constants|Request method constants>)) above. 

--- header_only?
      Returns (({true})) if the request is a head-only request (ie.,
      (({req.request_method == 'HEAD'})).

--- allowed
--- allowed= int
      Returns/sets the bitvector (an (({Integer}))) of the request methods that
      the handler can accommodate. You can set bits in this field using one or
      more ((<request method constants|Request method constants>)).

      Example:

        include Apache
        Apache::request.allowed |= (1 << M_GET)
        Apache::request.allowed |= (1 << M_POST)

--- the_request
      Returns the first line of the request as a (({String})), for logging
      purposes.

--- args
      Returns the quest string for CGI GET requests, and corresponds to the
      portion of the URI following the (({?})).

--- headers_in
      Returns the ((<Apache::Table>)) object for the request header.

--- read([len])
      Read ((|len|)) bytes from the client.

--- gets([rs])
      Reads the next "line" from the I/O stream; lines are separated by the
      separator string ((|rs|)), which is (({$/})) by default. A separator of
      nil reads the entire contents, and a zero-length separator reads the
      input a paragraph at a time (two successive newlines in the input
      separate paragraphs). The line read in will be returned and also assigned
      to $_. Returns nil if called at end of file.

--- readline([rs])
      Reads a line as with ((<Apache::Request#gets|gets>)) , but raises an
      (({EOFError})) on end of file.

--- readlines([rs])
      Reads all of the lines from the client, and returns them in an
      (({Array})). Lines are separated by the optional separator string
      ((|rs|)).

--- each([rs]) {|line|...}
      Executes the block for every ((|line|)), where lines are separated by the
      separator string ((|rs|)) ((({$/})) by default).

--- each_line([rs]) {|line|...}
      Synonym for ((<Apache::Request#each|each>)).

--- each_byte {|ch|...}
      Calls the given block once for each byte (0..255) in the input from the
      client, passing the byte as an argument.

--- getc
      Returns the next 8-bit byte (0..255) from the data from the
      client. Returns nil if called at end of file.

--- readchar
      Reads a character as with ((<Apache::Request#getc|getc>)) , but raises an
      (({EOFError})) on end of file.

--- ungetc(ch)
      Pushes back one character onto the date stream from the client, such that
      a subsequent buffered read will return it. Only one character may be
      pushed back before a subsequent read operation (that is, you will be able
      to read only the last of several characters that have been pushed
      back).

--- tell
      Synonym for ((<Apache::Request#pos|pos>)).

--- seek(offset, [whence])
      Seeks to a given offset ((|offset|)) in the stream according to the value
      of ((|whence|)):

      :(({IO::SEEK_CUR}))
        Seeks to ((|offset|)) plus current position.
      :(({IO::SEEK_END}))
        Seeks to anInteger plus end of stream (you probably want a negative
        value for ((|offset|))).
      :(({IO::SEEK_SET})) (the default)
        Seeks to the absolute location given by ((|offset|)).

--- rewind
      Positions the client data stream to the beginning of input, resetting
      (({lineno})) to zero.

--- pos
      Returns the current offset (in bytes) of the client input data stream.

--- pos= n
      Seeks to the given position ((|n|)) (in bytes) in the client input data
      stream.

--- eof
      Returns (({true})) if the client input data stream is at end of file.

--- eof?
      Synonym for ((<Apache::Request#eof|eof>)).

--- binmode
      Puts the client input data stream into binary mode. This is useful only in
      MS-DOS/Windows environments. Once a stream is in binary mode, it cannot be
      reset to nonbinary mode.

--- setup_client_block([policy])
--- should_client_block
--- should_client_block?
--- get_client_block(bufsiz)
      Interface to Apache's internal request-reading functions. Note that the
      constants necessary to form the call to (({setup_client_block})) are not
      provided. You may wish to do so yourself; eg.,

        # These may be found in your Apache's httpd.h
        REQUEST_NO_BODY          = 0
        REQUEST_CHUNKED_ERROR    = 1
        REQUEST_CHUNKED_DECHUNK  = 2
        REQUEST_CHUNKED_PASS     = 3

--- sync_header
--- sync_header= 
      Returns/sets the status of header IO synchronization. If (({sync_header}))
      is (({true})), headers will be sent immediately as they are written, and
      remaining content will be buffered until the end of the request.

--- sync_output
--- sync_output=
      Returns/sets the status of the synchronization of IO for the response
      body. If (({sync_output})) is (({true})), all output will be sent
      immediately instead of buffering it until the end of the request.

--- sync=
      Set the synchronization of both headers and response body IO.

--- headers_out
      Returns the ((<Apache::Table>)) object for the response header.

--- err_headers_out
      Returns the ((<Apache::Table>)) object for the headers which will be sent
      even when an error occurs, and which persist across internal redirects.

--- content_type= str
      Set the (({Content-Type})) header of the response.

--- content_type
      Returns the MIME content type of the response, as set by the MIME-checking
      phase of the transaction.

--- content_length
      Returns the length of the incoming content as specified by the
      (({Content-Length})) header. ((*Deprecated*)): Use
      (({req.headers_in['Content-Length']})) instead.

--- content_encoding= str
      Set the MIME (({Content-Encoding})) header of the response.

--- content_encoding
      Returns the MIME encoding type of the response, as set by the
      MIME-checking phase of the transaction.

--- content_languages= str
      Specifies Content-Languages of the response header.

--- content_languages
      Returns the value of the (({Content-Languages})) of the response. This is
      typically set by the MIME-checking phase of the transaction.

--- send_http_header
      Sends the HTTP response header. If you call this method more than once,
      only the first call will actually send it.

--- sent_http_header?
      Returns (({true})) if the header has been sent already.

--- write(str)
      Writes the given string ((|str|)) to the output buffer. If the argument is
      not a string, it will be converted to a string using (({to_s})). Returns
      the number of bytes written.

--- putc(ch)
       Writes the given character ((|ch|)) (taken from a String or a Fixnum) to
       the output buffer.

--- print(arg...)
      Writes the given ((|arg|)) object(s) to the output buffer. If the output
      record separator ($\) is not nil, it will be appended to the output. If no
      arguments are given, prints $_. Objects that aren't strings will be
      converted by calling their (({to_s})) method. Returns (({nil})).

--- printf(fmt, arg...)
       Formats and writes to the output buffer, converting parameters under
       control of the ((|fmt|)) string.

--- puts(arg...)
      Writes the given ((|arg|)) objects to the output buffer as with
      ((<Apache::Request#print|print>)) . Writes a record separator (typically a
      newline) after any that do not already end with a newline sequence. If
      called with an array argument, writes each element on a new line. If
      called without arguments, outputs a single record separator.

--- << obj
      String Output---Writes ((|obj|)) to the client output buffer. ((|obj|))
      will be converted to a string using (({to_s})).

--- replace(str)
      Replaces the output buffer with ((|str|)).

--- output_buffer
      Returns the output buffer (({String})) currently associated with the request.

--- cancel
      Clears the output buffer.

--- escape_html(str)
      Returns the specified string with any '(({&}))', '(({"}))', '(({<}))', or
      '(({>}))' characters escaped to their HTML entity equivalents.

--- connection
      Returns the ((<Apache::Connection>)) object associated with the request.

--- server
      Returns the ((<Apache::Server>)) object associated with the request.

--- next
      Returns the ((<Apache::Request>)) object for the next (newer) subrequest
      or internal redirect, if any. Returns (({nil})) if no such request exists.

--- prev
      Returns the ((<Apache::Request>)) object for the previous (older)
      subrequest or internal redirect.

--- last
      Return the final ((<Apache::Request>)) object for the current chain or
      internal redirects or subrequests.

--- main
      Returns the main ((<Apache::Request>)) object, or (({nil})) if the
      receiver is the main request.

--- main?
      Returns (({true})) if the receiver is the initial request object or an
      internal redirect (ie., not a subrequest).

--- initial?
      Returns (({true})) if the request is the initial request (ie., not an
      internal redirect or a subrequest).

--- protocol
      Returns the name and version number of the protocol requested by the
      browser (eg., (({"HTTP/1.1"}))).

--- subprocess_env
      Returns the ((<Apache::Table>)) object containing environment variables
      which should be passed to subprocesses.

--- notes
      Returns the ((<Apache::Table>)) object which can be used to pass "notes"
      from one handler module to another.

--- finfo
      Returns the (({File::Stat})) object associated with the translated
      filename of the request, if any. If no physical file is associated with
      the transaction, the File::Stat object will be the same as that returned
      from testing a non-existant file.

--- [str]
      Returns the value of the specified request header. ((*Deprecated*)): Use
      ((<#headers_in|headers_in>)) instead.

--- []=
      Sets the value of the specified response header. ((*Deprecated*)): Use
      ((<#headers_out|headers_out>)) instead.

--- each_header {|hdr,val|...}
      Iterates over the headers in the request, calling the specified
      ((|block|)) with each header name and value. ((*Deprecated*)): Use
      ((<#headers_in|headers_in>)) instead.

--- each_key {|hdr|...}
      Iterates over the names of each header in the request, calling the
      specified ((|block|)) once with each one. ((*Deprecated*)): Use
      ((<#headers_in|headers_in>)) instead.

--- each_value {|val|...}
      Iterates over the values of each header in the request, calling the
      specified ((|block|)) once with each one. ((*Deprecated*)): Use
      ((<#headers_in|headers_in>)) instead.

--- allow_options
      Returns the bitmap with specifies which options are enabled for the
      directory to which the request has been mapped. You can use the Apache
      module's ((<options bitmask constants|Options bitmask constants>)) to test
      for desired values.

      For example:
        include Apache

        # Make sure that ExecCGI and Indexes are turned on for the Location
        # being served:
        unless req.allow_options & (OPT_EXECCGI|OPT_INDEXES)
            req.log_reason( "ExecCGI and/or Indexes are off in this directory",
                            req.filename )
            return FORBIDDEN
        end

--- allow_overrides
      Returns an Integer (?).

--- default_type
      Returns the value of the (({DefaultType})) directive, or
      (({"text/plain"})) if not configured.

--- remote_host([type])
      Returns the remote client's DNS hostname, or its IP address if the
      hostname cannot be looked up. The optional argument specifies what type of
      lookup should be performed. The ((<remotehost constants|Remotehost
      constants>)) can be used for the ((|type|)) argument.

--- remote_logname
      Returns the login name of the remote user if the host is running the
      ((*identd*)) service (RFC1413), or (({nil})) if the name could not be
      looked up. This method also depends on the server having the
      (({IdentityCheck})) configuration directive turned on, which it is not by
      default.

--- construct_url(uri)
      Returns a fully-qualified URI (({String})) from the path specified by
      ((|uri|)) using the request object's server name and port.

--- server_name
      Returns the server's public name as a (({String})) suitable for inclusion
      in self-referential URLs.

--- server_port
      Returns the port the request was sent to as an (({Integer})) suitable for
      inclusion in self-referential URLs.

--- satisfies
      Returns an (({Integer})) that can be compared with one of the Apache
      module's ((<satisfy constants|Satisfy constants>)) to test the type of
      access control that applies to the request.

--- requires
      Returns an associative (({Array})) of the (({require})) directives that
      apply to the current request. Each entry is of the form:

        [ method_mask, requirement ]

      where ((|method_mask|)) is a bitmap of the HTTP request methods that the
      requirement applies to, and ((|requirement|)) is the contents of the
      (({require})) directive (ie., everything after the space).

      For example, given a config section like this:

        <Limit GET POST>
          require valid-user
        </Limit>
        <Limit PUT DELETE>
          require group Admin
        </Limit>

      the (({requires})) method would return something like:

        [
          [ 5, "valid-user" ],
          [ 10, "group Admin" ]
        ]

      The bitmask can be tested by left-shifting the mask by the method number,
      eg.,

        get_mask  = 1 << Apache::M_GET
        post_mask = 1 << Apache::M_POST

--- signature
      Returns the server's signature footer line if the server's
      (({ServerSignature})) has been turned on.

--- hard_timeout(msg)
--- soft_timeout(msg)
--- kill_timeout
--- reset_timeout
      Apache timeout interface methods. These methods are only available under
      Apache 1.x.

      (({#hard_timeout})) initiates a "hard" timeout. If an IO operation takes
      longer than the time specified by the (({Timeout})) directive, the current
      handler will be aborted and Apache will immediately enter the logging
      phase.

      (({#soft_timeout})) does not abort the current handler, but returns
      control to it when the timer expires after no-oping all input and output
      methods. After this occurs, ((<Apache::Connection#aborted?|aborted?>))
      will return (({true})).

      (({#reset_timeout})) is used to reset the timer back to zero between
      reads or writes.

      (({#kill_timeout})) cancels the timeout currently in effect when the IO
      operations it governs are finished.

      Example:
        input = ''
        req.hard_timeout( "#{caller(0)[0]}: Reading request." )
        req.each_line {|line|
          input << line
          req.reset_timeout
        }
        req.kill_timeout

        req.sync = true
        req.soft_timeout( "#{caller(0)[0]: Sending response headers." )
        req.send_http_header
        req.kill_timeout

        req.soft_timeout( "#{caller(0)[0]: Sending response data." )
        until output_data.empty?
          bytes = req.write( output_data )
          if bytes.nonzero?
            req.reset_timeout
            output_data.slice!(0,bytes)
          end
        end
        req.kill_timeout
          
--- internal_redirect(uri)
      Redirect the current request internally to the specified (absolute)
      ((|uri|)).

      Example:
        if req.headers_in['user-agent'] !~ /mozilla/i
          req.internal_redirect( "/unsupported-browser.html" )
        end

--- custom_response(status,uri)
      Set the error document for the given ((|status|)) to the given
      ((|uri|)). The status is a (({Fixnum})) status code like those in the
      Apache module's ((<HTTP response codes>)).

      Example:
        include Apache

        unless req.notes['username']
          req.custom_response( HTTP_UNAUTHORIZED, "/noauth.html" )
          return HTTP_UNAUTHORIZED
        end

--- note_auth_failure
      Set up the current request's response to indicate a failure to
      authenticate (ie., will send an "Authentication Required" message to the
      browser). It will call either ((<note_basic_auth_failure>)) or
      ((<note_digest_auth_failure>)), depending on which kind of authentication
      is configured for the current directory.

--- note_basic_auth_failure
      Set up the current request's response to indicate a failure to
      authenticate via HTTP Basic Authentication.

--- note_digest_auth_failure
      Set up the current request's response to indicate a failure to
      authenticate via HTTP Digest Authentication.

--- get_basic_auth_pw
      Returns the plaintext password entered by the user as a String. If there
      was any error fetching the password, a (({SystemExit})) exception is
      raised with its status code set to the status code returned by the call.

--- add_cgi_vars
      Add the variables required by the CGI/1.1 protocol to the
      ((<subprocess_env>)) table.

--- add_common_vars
      Add other Apache CGI variables to the ((<subprocess_env>)) table.

--- setup_cgi_env
      Clear the current environment and add CGI and common variables to the
      ((<subprocess_env>)) table.  Then export the ((<subprocess_env>)) table,
      the variables defined in the server and directory configurations for the
      current request, and the (({MOD_RUBY})) and (({GATEWAY_INTERFACE}))
      variables into the environment shared with subprocesses.

--- log_reason(msg,file)
      Output a file-processing log message that looks like:
        access to #{file} failed for #{req.get_remote_host},
          reason: #{msg}

--- error_message
      Returns the error message set by mod_ruby's internal exception-handler, if
      any.

--- exception
      Returns the (({Exception})) object set by mod_ruby's internal
      exception-handler, if any.

--- user
--- user= str
      Portably set the authenticated username for the current request. For
      Apache 1.x, calling either of these methods just calls the equivalent
      method of the connection object, but since Apache 2.x moved the username
      into the main request object, this way of setting the username will work
      for either version.

--- auth_type
--- auth_type= str
      Returns/sets the authentication type for the receiving request. Usually
      one of (({"Basic"})) or (({"Digest"})).

--- auth_name
--- auth_name= str
      Returns/sets the authentication realm for the receiving request.

--- default_charset
      Returns the name of the default character set, as defined by the
      (({AddDefaultCharset})) directive.

--- bytes_sent
      Returns the number of bytes sent by the server to the client, excluding
      the HTTP headers. It is only useful after ((<send_http_header>)) has been
      called.

--- send_fd(io)
      Send the contents of the specified (({IO})) object to the client. Eg.,

        BannerFile = "/www/htdocs/banner.html"

        begin
          File::open( BannerFile, File::O_RDONLY ) {|ofh|
            req.send_fd(ofh)
          }
        rescue IOError => err
          req.log_reason( err.message, BannerFile )
          return Apache::NOT_FOUND
        end
      
--- proxy?
      Returns (({true})) if the request is for a proxy URI.

--- proxy_pass?
      Returns (({true})) if the request is for a pass-through-proxied URL.

--- dispatch_handler
--- dispatch_handler= str
      Allows one to get/set the Ruby code which returns the dispatch handler for
      requests. This makes it possible to write your own dispatch handler.

--- cache_resp
--- cache_resp= val
      Returns/sets the flag that controls whether the response will have
      cache-control headers put into its response. If (({cache_resp})) is set to
      to (({true})), the response will have the following headers added:

        Pragma: no-cache
        Cache-control: no-cache

      If set to (({false})), the (({Pragma})) and (({Cache-control})) headers
      will be removed completely from the response headers, regardless of their
      content.

--- lookup_uri(uri)
--- lookup_file(file)
      Will perform a sub-request to lookup a given ((|uri|)) or ((|file|)),
      respectively.  The data will not be strongly verified (won't go through
      most of the request cycle), but it will return a new request object that
      you can use to play with and perform operations on.

      For example:
        subr = r.lookup_uri('/non/existent/file.html?asdf=asdf&asdf=asdf')
        subr.status   >> 200
        subr.filename >> '/usr/local/www/data/non'
        subr = r.lookup_file('/etc/foo/bar/baz/non/existent/file.html?asdf=asdf&asdf=asdf')
        subr.status   >> 200
        subr.filename >> '/etc/foo/bar/baz/non/existent/file.html'

      The moral of the story is that you have to be careful and perform your own
      data verification with a lookup.  If you use (({lookup_file()})), then
      Apache assumes that the filename specified is authoritative.


[((<Back to Index|mod_ruby Class Reference Manual>))]

== Apache::Table

A class to wrap (({table})) data type.

=== Superclass

Object

=== Included Classes

Enumerable

=== Methods

--- clear
      Clears contents of the table.

--- self[name]
--- get(name)
      Returns the value of ((|name|)).

--- self[name]= val
--- set(name, val)
--- setn(name, val)
--- merge(name, val)
--- mergen(name, val)
--- add(name, val)
--- addn(name, val)
      Sets the value of ((|name|)) to ((|val|)).

--- unset(name)
      Unsets the value of ((|name|)).

--- each {|key,val|...}
--- each_key {|key|...}
--- each_value {|val|...}
      Iterates over each element.

[((<Back to Index|mod_ruby Class Reference Manual>))]


== Apache::Server

A class to wrap global and virtual server configuration and utility methods. Can
be fetched via ((<Apache::Request#server|server>)).

=== Superclass

Object

=== Methods

--- defn_name
      Returns a description of where the configuration came from.

--- defn_line_number
      Returns the line number of the file that the configuration came from.

--- srm_confname
      Returns the full location of the srm.conf configuration file (if
      any). ((*Not implemented*))

--- access_confname
      Returns the full location of the access.conf configuration file (if
      any). ((*Not implemented*))

--- admin
      Returns the email address of the server's administrator as set by the
      ServerAdmin directive.

--- hostname
      Returns the (virtual) name of the server host.

--- port
      Return the port number that the (virtual) server is listening on.

--- error_fname
      Return the name of the server's error log, either absolute or server-root
      relative.

--- loglevel
      Returns the log level of the server as an (({Integer})) between 1 and 8; 1
      being the least verbose (emerg) and 8 being the most verbose (debug).

--- is_virtual
--- virtual?
      Returns (({true})) if the server is a virtual host.

--- timeout
--- keep_alive_timeout
--- keep_alive_max
--- keep_alive
--- keep_alive?
      Returns the values corresponding to the (({Timeout})),
      (({KeepAliveTimeout})), (({MaxKeepAliveRequests})), and the
      (({KeepAlive})) directives.

--- send_buffer_size
      Returns the size of the TCP send buffer in bytes.

--- path
      Returns the legacy URL pathname for a host, for use with name-based
      virtual hosts. Set with the (({ServerPath})) directive.

--- names
      Returns an Array of server names for the host, starting with the canonical
      name, plus any aliases set with the (({ServerAlias})) directive.

--- wild_names
      Returns an Array of server names for the host that contain wildcards.

--- uid
      Returns the effective server uid.

--- gid
      Returns the effective server gid.

--- limit_req_line
      Returns the limit on the number of characters that may be in an HTTP
      request line.

--- limit_req_fieldsize
      Returns the limit on the size of any request header field.

--- limit_req_fields
      Returns the limit on the number of request header fields.

--- log_emerg(fmt,*args)
--- log_alert(fmt,*args)
--- log_crit(fmt,*args)
--- log_error(fmt,*args)
--- log_warn(fmt,*args)
--- log_notice(fmt,*args)
--- log_info(fmt,*args)
--- log_debug(fmt,*args)
      Write a message to the server's log if the server's (({LogLevel})) is the
      specified level or above. The ((|fmt|)) and ((|args|)) are used the same
      way as the arguments to (({printf})).

--- document_root
      Returns the server's document root, as configured with the
      (({DocumentRoot})) directive.


== Apache::Connection

A class to wrap client socket connection records; may be fetched via
((<Apache::Request#connection|connection>)).

=== Superclass

Object

=== Methods

--- aborted?
      Returns (({true})) if a timeout set by
      ((<Apache::Request#soft_timeout|soft_timeout>)) occurs while reading or
      writing to the client.

--- remote_ip
      Returns the dotted Internet address of the client as a (({String})).

--- remote_host
      Returns the DNS name of the client, if it is set, else the IP address.

--- remote_port
      Returns the port number of the socket on the client side of the
      connection.

--- remote_logname
      Returns the username obtained via RFC1413 lookup if the server is doing
      them.

--- user
--- user= str
      Returns/sets the name of the authenticated user, if any. These methods are
      only implemented when running under Apache 1.x, so if you wish to write
      code that works under either version, you should use the
      ((<equivalent methods|user>)) in the ((<Apache::Request>)) object.

--- auth_type
--- auth_type= str
      Returns/sets the type of authentication used, if any, as a (({String})).
      These methods are only implemented when running under Apache 1.x.

--- local_ip
      Returns the dotted Internet address of the local side of the socket
      connection.

--- local_host
      Returns the DNS name of the IP address of the local side of the socket
      connection.

--- local_port
      Returns the port number of the local side of the socket connection.


=end


