/*
 *  Dynamic Virtual Hosting ( mod_dynvhost.c ) 
 *   
 *  An apache module from !@funkcity.com ( http://funkcity.com/0101 )
 *
 *  Now with help from SGI ;-)
 *
*/

#include "httpd.h"
#include "http_config.h"
#include "http_conf_globals.h"
#include "http_main.h"
#include "http_core.h"	
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>

#define MODULE_VERSION 0.9.8

module dynvhost_module;

/* The section for the Configure script:
 * MODULE-DEFINITION-START
 * Name: dynvhost_module
 * ConfigStart
   echo "        mod_dynvhost is getting compiled in! ( !@funkcity.com )"
 * ConfigEnd
 * MODULE-DEFINITION-END
*/

typedef struct {
	array_header *aliases;
} dynvhost_config_rec;

typedef struct {
	char	*dir;
	char	*homedir;
	int	minuid;
	int	mingid;
} dynvhost_alias_rec;

static const char begin_dynvhost_section[] = "<DynamicVirtualHost";
static const char end_dynvhost_section[] = "</DynamicVirtualHost>";

static void *dynvhost_create_config(pool *p, server_rec * s)
{
    dynvhost_config_rec *rc;

    rc = ( dynvhost_config_rec *) ap_pcalloc(p, sizeof( dynvhost_config_rec ) );
    rc->aliases = ap_make_array(p, 10, sizeof(dynvhost_alias_rec));
    return rc;
}

static void dynvhost_init (server_rec *s, pool *p) {
	//fprintf(stderr,"Dynamic Virtual Hosting initializing\n");
}

static int dynvhost_handler (request_rec *r) {
}

static char *unclosed_directive(cmd_parms *cmd)
{
    return ap_pstrcat(cmd->pool, cmd->cmd->name,
                      "> directive missing closing '>'", NULL);
}

static const char *missing_endsection(cmd_parms *cmd, int nest)
{
    if (nest < 2) {
        return ap_psprintf(cmd->pool, "Missing %s directive at end-of-file",
                           cmd->end_token);
    }
    return ap_psprintf(cmd->pool, "%d missing %s directives at end-of-file",
                       nest, cmd->end_token);
}

static const char *dynvhost_dirvirthost(cmd_parms *cmd, void *dummy, char *arg ) {

	char				*endp = strrchr( arg, '>' );
        struct stat                     file_info;
	char				l[80];
	int				nest = 1, not = 0;
        dynvhost_config_rec        	*rc;
        dynvhost_alias_rec         	*ra;

	// Are we missing a </DynamicVirtualHost> ? 
	if ( endp == NULL ) { 
		return unclosed_directive(cmd); 
	}
	*endp = '\0';

        if(stat(arg, &file_info) == -1) {
                return ap_pstrcat(cmd->pool,"\"",arg,"\" does not exist", NULL);
        }
	
        rc = ap_get_module_config(cmd->server->module_config, &dynvhost_module);
        ra = (dynvhost_alias_rec *) ap_push_array(rc->aliases);

	//This _is_ dodgy ( mist fix )
        ra->dir = ap_pstrcat(cmd->pool, arg, NULL );

        /*Do we need to add a trailing slash ?
        if(endp[strlen(endp)-1] == '/') {
                ra->dir = ap_pstrcat(cmd->pool, endp, NULL );
        } else {
                ra->dir = ap_pstrcat(cmd->pool, endp, "/", NULL);
        } */

	//fprintf(stderr, "Config -\t[%s]\n", arg);

        while (nest && !(ap_cfg_getline(l, 80, cmd->config_file))) {
        	if (!strncasecmp(l, begin_dynvhost_section, 9)) {
            		nest++;
        	}
	
		//fprintf(stderr, "Config -\t[%s]\n", l);
	
		if ( !strncmp ( l, "HomeDir ", 8) ) {
			ra->homedir = l+8;
			ra->homedir = ap_pstrcat (cmd->pool, ra->homedir, NULL );

        		if ( ra->homedir[strlen(ra->homedir)] == '/' ) {
                		ra->homedir[strlen(ra->homedir)] == '\0';
        		}
		}

		if ( !strncmp (l , "MinUID ", 7) ) {
			ra->minuid = atoi(l+7);
		}

                if ( !strncmp (l , "MinGID ", 7) ) {
                        ra->mingid = atoi(l+7);
                }

		if (!strcasecmp(l, end_dynvhost_section ) ) {
            		nest--;
        	}
    	}

    	if (nest) {
        	cmd->end_token = end_dynvhost_section;
        	return missing_endsection(cmd, nest);
    	}

	//Sanity Checking
	if ( ra->minuid == 0 ) { ra->minuid=500; }
	if ( ra->mingid == 0 ) { ra->mingid=500; }

	//More Debugging
	//fprintf(stderr, "Dir - [%s]  HomeDir - [%s] MUID [%d] MGID [%d]\n", ra->dir, ra->homedir, ra->minuid, ra->mingid);
	return NULL;
}

static const char *end_nested_section(cmd_parms *cmd, void *dummy)
{
    return NULL;
}

static int dynvhost_trans_uri(request_rec *r)
{
	dynvhost_config_rec	*rc;
	dynvhost_alias_rec	*aliases;
	//core_server_config	*conf;
        struct stat             file_info;

	int 			i, l, ret;

	char			*file,*user,*tmpstr;	
	char			*doc_root;
	char			*icon_dir;


	//conf = (core_server_config *)ap_pcalloc(a, sizeof(core_server_config));
	rc = ap_get_module_config(r->server->module_config, &dynvhost_module);
	aliases = (dynvhost_alias_rec *) rc->aliases->elts;

	//No Hostname came to us, hmm, in that case we
	//fall through and let apache do it's thang.
	//It's most likely the main apache root
	if ( r->hostname == NULL ) {
		fprintf(stderr, "No Hostname recieved by DynvHost\n");
		return DECLINED;
	}

        //Set stuff that is pretty static based on hostname only.

        //Set ServerAdmin for this V.Host
	//fprintf(stderr, "Setting ServerAdmin\n");
        r->server->server_admin = ap_pstrcat (  r->pool,
                                                "webmaster@",
                                                r->hostname, NULL );
        //Set our new Hostname ( ServerName )
	//fprintf(stderr, "Setting ServerName\n");
        r->server->server_hostname = ap_pstrcat(r->pool, r->hostname, NULL );

        // Set the document root according to our config
	//fprintf(stderr, "Setting doc_root - ");
        doc_root=ap_pstrcat( r->pool, aliases->dir, "/", r->hostname, NULL );
	//fprintf(stderr, doc_root);

	//We don't have a directory for that hostname ?
	//Ok, again we fall through to let the other mods try.
	//This let's the other VirtualHost directives pick it up.
	//If we do own this site excellent, let's set the 'user'
	//and 'group' based on the UID/GID of the directory.
        if( stat( doc_root, &file_info ) == -1) {
		fprintf(stderr, "No directory (%s) for Hostname %s\n", doc_root, r->hostname);
                return DECLINED;
        } else
	{
		//Here we get the UID / GID for suexec and file creation
		r->server->server_uid = file_info.st_uid;	
		r->server->server_gid = file_info.st_gid;
	}

	//Now we have the HOSTNAME & Directory to serve from let's check the other conditions
	//in sequence - HomeDir / CGI-BIN / icon dir 

	//Do we have a tilde ?
	//If so we set modify the parsed URI to kill the ~ character and return the correct path
	//to a fake user dir under our Virtual root
	if ( !strncmp( r->uri, "/~", 2) ) {
		r->parsed_uri.path=ap_pstrcat (r->pool,aliases->homedir,"/",r->parsed_uri.path+2,NULL );
	}

	// Handle CGI's
	if ( !strncmp ( r->uri, "/cgi-bin/", 9 ) ) {
		//if ( (r->server->server_uid < aliases->minuid ) || (r->server->server_gid < aliases->mingid) ) {
			//fprintf(stderr, "cgi-bin forbidden due to UID/GID restrictions\n" );
			//return HTTP_FORBIDDEN;	
		//}
		// Pulled from 'mod_vhost'
		r->handler = "cgi-script";
		ap_table_setn ( r->notes, "alias-forced-type", r->handler );
	}

        //Handle Icons 
        if ( !strncmp( r->uri, "/icons/", 7 ) ) {
		icon_dir=ap_pstrcat(r->pool,doc_root,"/icons/", NULL);
                if ( stat( icon_dir, &file_info ) != -1 ) {
			r->filename=ap_pstrcat( r->pool,
					doc_root,
					r->parsed_uri.path,
					NULL);
			return DECLINED;
                } else {
			r->filename=ap_pstrcat( r->pool,
					ap_server_root,
					r->uri,
					NULL);
			
			return DECLINED;
			}	
        } 


	// It all comes down to this line 

	r->filename = ap_pstrcat( r->pool,doc_root,
				  r->parsed_uri.path,NULL);

	/* Debug Info if needed, get's written to apache error_log 
        fprintf(stderr,"--------------After mod------------------\n");
        fprintf(stderr,"URI.hostname [%s]\n",r->parsed_uri.hostname);
        fprintf(stderr,"URI.hostinfo [%s]\n",r->parsed_uri.hostinfo);
        fprintf(stderr,"URI.path [%s]\n",r->parsed_uri.path);
        fprintf(stderr,"Server Admin [%s]\n",r->server->server_admin);
        fprintf(stderr,"Server Name [%s]\n",r->server->server_hostname);
	*/

	return OK;
}

static const handler_rec dynvhost_handlers[] =
{
    {"dynvhost-handler", dynvhost_handler},
    { NULL }
};

static const command_rec dynvhost_cmds[] = {
{ begin_dynvhost_section, dynvhost_dirvirthost, NULL, RSRC_CONF, RAW_ARGS,
  "Container for Dynamic Virtual Host directives, take a directory name "
  "that points at VirtualHost root" },
{ end_dynvhost_section, end_nested_section, NULL, RSRC_CONF, NO_ARGS, 
  "Marks end of <DynamicVirtualHost>" },
{ NULL }
};

module dynvhost_module = 
{
	STANDARD_MODULE_STUFF,
	NULL,				/* initializer */
	NULL,				/* dir config creater */
	NULL,				/* dir merger default is to override */
	dynvhost_create_config,		/* server config */
	NULL,				/* merge server config */
	dynvhost_cmds,			/* command table */
	dynvhost_handlers,		/* handlers */
	dynvhost_trans_uri,		/* filename translation */
	NULL,				/* check_user_id */
	NULL,				/* check auth */
	NULL,				/* check access */
	NULL,				/* type_checker */
    	NULL,                       	/* fixups */
    	NULL,                       	/* logger */
    	NULL,                       	/* header parser */
    	NULL,                       	/* child_init */
    	NULL,                       	/* child_exit */
    	NULL                        	/* post read-request */
};
