// 
// Copyright (c) 2006-2008 Ben Motmans
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
//
// Author(s):
//    Ben Motmans <ben.motmans@gmail.com>
//

using System;
using System.Collections.Generic;

namespace Anculus.Core
{
	public class IndexOfSearchAlgorithm : AbstractSearchAlgorithm
	{
		public override int[] SearchAll (string text, int start, int count, string keyword)
		{
			CheckArguments (text, start, count, keyword);

			List<int> results = new List<int> (count != int.MaxValue ? count : 4);
			int index = text.IndexOf (keyword, start);
			while (index >= 0) {
				results.Add (index);
				if (results.Count == count)
					break;
				
				index = text.IndexOf (keyword, index + keyword.Length);
			}
			
			return results.ToArray ();
		}

		public override int SearchFirst (string text, int start, string keyword)
		{
			CheckArguments (text, start, int.MaxValue, keyword);
			
			return text.IndexOf (keyword, start);
		}
	}
}