// 
// Copyright (c) 2006-2008 Ben Motmans
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
//
// Author(s):
//    Ben Motmans <ben.motmans@gmail.com>
//

using System;

namespace Anculus.Core.Extended
{
	public class ColoredConsoleLogBackend : ILogBackend, IEquatable<ColoredConsoleLogBackend>
	{
		private object _sync = new object ();
		
		public void Log (string timestamp, LogLevel level, string logger, object message, Exception ex)
		{
			lock (_sync) {
				string levelString = null;
				switch (level)
				{
					case LogLevel.Debug:
						Console.ForegroundColor = ConsoleColor.White;
						levelString = " [DEBUG] ";
						break;
					case LogLevel.Info:
						Console.ForegroundColor = ConsoleColor.Green;
						levelString = " [INFO] ";
						break;
					case LogLevel.Warning:
						Console.ForegroundColor = ConsoleColor.Yellow;
						levelString = " [WARNING] ";
						break;
					case LogLevel.Error:
						Console.ForegroundColor = ConsoleColor.Red;
						levelString = " [ERROR] ";
						break;
					case LogLevel.Fatal:
						Console.ForegroundColor = ConsoleColor.DarkRed;
						levelString = " [FATAL] ";
						break;
				}
				
				Console.Write (timestamp);
				Console.Write (levelString);
				
				if (logger != null) {
					Console.Write ("[");
					Console.Write (logger);
					Console.Write ("] ");
				}
				
				Console.ForegroundColor = ConsoleColor.White;
	
				if (message != null)
					Console.WriteLine (message.ToString ());
				else
					Console.WriteLine ();
	
				if (ex != null)
				{
					Console.WriteLine (ex.Message);
					Console.WriteLine (ex.StackTrace);
	
					if (ex.InnerException != null) {
						Console.WriteLine (ex.InnerException.Message);
						Console.WriteLine (ex.InnerException.StackTrace);
					}
				}
			}
		}
		
		public override bool Equals (object obj)
		{
			if (obj == null)
				return false;
			
			return obj is ColoredConsoleLogBackend;
		}
		
		public bool Equals (ColoredConsoleLogBackend other)
		{
			return true;
		}
		
		public override int GetHashCode ()
		{
			return typeof (ColoredConsoleLogBackend).GetHashCode ();
		}
	}
}