--***********************************************************************
--									*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that the above copyright notice and this paragraph are	*
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************

-- modified for use with Adabindx 10.8.1997
-- Hans-Frieder Vogt (vogt@ilaws6.luftfahrt.uni-stuttgart.de)

with Ada.Text_Io, Ada.Integer_Text_Io;

separate(GRAPHICS_WINDOW_MANAGER)
    procedure FILL_CONVEX_POLYGON(
	COLOR : COLORS.COLOR;
	POINTS: POINTS_TYPE
	)
    is
	V : Point_Array (POINTS'range);	-- translated points
    begin
	-- Translate the points into window coordinates
	for I in POINTS'range loop
	    V(I).X := Position (FLOAT(GW.WIDTH) * FLOAT(POINTS(I).X));
	    V(I).Y := Position (FLOAT(GW.HEIGHT) * FLOAT(POINTS(I).Y));
	end loop;

	-- Print out what we are doing
	if DEBUGGING then
	    declare
		use Ada.Text_Io, Ada.Integer_Text_Io;
	    begin
		PUT_LINE("FILL_CONVEX_POLYGON(");
		PUT_LINE("    COLOR => " & COLORS.COLOR'image(COLOR) & ",");
		PUT     ("    POINTS=>(");
		for I in POINTS'range loop
		    PUT("("); PUT(INTEGER(V(I).X), WIDTH=>3);
		    PUT(","); PUT(INTEGER(V(I).Y), WIDTH=>3);
		    PUT(")");
		    if I /= POINTS'last then PUT(", "); end if;
		end loop;
		PUT_LINE("));");
	    end;
	end if;

	-- Draw the filled polygon
	X_Fill_Polygon (Display => Display,
                        D       => GW.PIXMAP,
                        GC      => GW.GCs(COLOR),
                        Points  => V,
                        Shape   => Convex,
                        Mode    => Origin);

    end;
