with Ada.Calendar,
     Ada.Text_Io,
     Interfaces.C;
with Ada.Numerics.Generic_Elementary_Functions;
with Motif_Graphics;
with Common;

use  Ada.Text_Io,
     Interfaces.C;

package body Image_Global is

   type Real is digits 6;

   package Real_Functions is
      new Ada.Numerics.Generic_Elementary_Functions (Real);
   use Real_Functions;

   Last_X: constant Integer := Integer (Motif_Graphics.A_X_Point'Last);
   Last_Y: constant Integer := Integer (Motif_Graphics.A_Y_Point'Last);

   T     : Integer := 1;

   Argl  : X_Toolkit.Arg_List := X_Toolkit.Null_Arg_List;

   procedure Redraw_Image (W: in X_Toolkit.Widget) is
      X: Motif_Graphics.A_X_Point;
      Y: Motif_Graphics.A_Y_Point;
      J: Integer;
   begin
      Common.Window := X_Toolkit.Xt_Window (W);
      X_Lib.X_Clear_Window (Common.Display, Common.Window);

      for I in 1 .. Motif_Graphics.Wide-2 loop
         J := Integer (
                 abs (Sin ((Real (I + T) / 100.0) * Ada.Numerics.PI)) * 199.0);
         X := Motif_Graphics.A_X_Point (I);
         Y := Motif_Graphics.A_Y_Point (J);

         -- Draw the line.
         Motif_Graphics.Draw_Line ((X, 0), (X, Y), Common.Blue);

         -- Blank out the rest.
         if    J = Last_Y - 1 then
            Motif_Graphics.Put_Pixel (I, Last_Y, Common.White);
         elsif J < Last_Y - 1 then
            Motif_Graphics.Draw_Line ((X, Motif_Graphics.A_Y_Point (J + 1)),
                                      (X, Motif_Graphics.A_Y_Point'Last),
                                       Common.White);
        end if;
      end loop;

      -- draw box
      Motif_Graphics.Draw_Box;

      Motif_Graphics.Show_CRT;

      T := T + 1;

   end Redraw_Image;


   procedure Resize_Image (W: in X_Toolkit.Widget) is
      Width, Height: X_Lib.Dimension;
   use XM_Widgets;
   begin
      Argl := X_Toolkit.Null_Arg_List;
      X_Toolkit.Append_Get (Argl, Xm_N_Width, Width);
      X_Toolkit.Append_Get (Argl, Xm_N_Height, Height);
      X_Toolkit.Xt_Get_Values (W, Argl);

      Put_Line ("new size: " & X_Lib.Dimension'Image (Width) & " x" &
                               X_Lib.Dimension'Image (Height));

      if Integer (Width) > Last_X then
           Common.Origin_X := Short_Integer (Width  - Motif_Graphics.Wide) / 2;
      else Common.Origin_X := 0; end if;
      if Integer (Height) > Last_Y then
           Common.Origin_Y := Short_Integer (Height - Motif_Graphics.High) / 2;
      else Common.Origin_Y := 0; end if;
      
   end Resize_Image;


   procedure Expose_Image_CB (W         : in X_Toolkit.Widget;
                              Closure   : in X_Toolkit.Xt_Pointer;
                              Call_Data : in X_Toolkit.Xt_Pointer) is
   begin
      Put_Line ("Expose_Image_CB called");
      Redraw_Image (W);
   end Expose_Image_CB;


   procedure Resize_Image_CB (W         : in X_Toolkit.Widget;
                              Closure   : in X_Toolkit.Xt_Pointer;
                              Call_Data : in X_Toolkit.Xt_Pointer) is
   begin
      Put_Line ("Resize_Image_CB called");
      Resize_Image (W);
   end Resize_Image_CB;


   procedure Timeout_CB (Client_Data : in     X_Toolkit.Xt_Pointer;
                         ID          : in out X_Toolkit.Interval_ID) is
      use Ada.Calendar;
   begin
   
      Common.Timer_ID := X_Toolkit.Xt_App_Add_Time_Out
            (Common.App_Con, 1000, Timeout_CB'Access, Client_Data);

      Redraw_Image (Common.The_Draw);

      ID := Common.Timer_ID;

   end Timeout_CB;


end Image_Global;
