/* $Id: gentypes.h,v 1.4 2001/02/08 07:35:59 linus Exp $ */
/* gentypes.h
 * This file contains "templates" for some simple generic types.
 * You could say that this is the authors way of compensating for the absence
 * of templates, especially STL, in C and trying to emulate them using macros.
 *
 * Copyright (C) 2000	Lysator Computer Club,
 *			Linkoping University,  Sweden
 *
 * Everyone is granted permission to copy, modify and redistribute
 * this code, provided the people they give it to can.
 *
 *
 * Author:	Linus Tolke
 *		Lysator Computer Club
 *		Linkoping University
 *		Sweden
 *
 * email:	linus@lysator.liu.se
 *
 *
 * Any opinions expressed in this code are the author's personal opinions,
 * and does not represent any official standpoint of Lysator, even if so
 * stated.
 */
#ifndef GENTYPES_H
#define GENTYPES_H
#include <config.h>

#if MALLOC_H
#include <malloc.h>
#endif
#if HAVE_STDLIB_H
#include <stdlib.h>
#endif

/*
 * Linked list
 * The linked list macros work on types.
 */
#define LINKED_LIST_TYPE(type) struct type ## _linked_list
#define LINKED_LIST_TYPE_DEFINITION(type, empty)	\
LINKED_LIST_TYPE(type) {				\
    type			data;			\
    LINKED_LIST_TYPE(type) *	next;			\
};							\
static type type ## _empty = empty;

/*
 * Functions for linked list.
 */
#define LINKED_LIST_FIRST_ELEMENT_FUNCTION(type)			\
static inline								\
type									\
linked_list_ ## type ## _first_element(LINKED_LIST_TYPE(type)* list)	\
{									\
    if (list != NULL)							\
    {									\
	return list->data;						\
    }									\
    return type ## _empty;						\
}

#define LINKED_LIST_INSERT_FIRST_FUNCTION(type)				   \
static inline								   \
void									   \
linked_list_ ## type ## _insert_first(LINKED_LIST_TYPE(type) **pp, type d) \
{									   \
    LINKED_LIST_TYPE(type) * new_elem =					   \
	(LINKED_LIST_TYPE(type) *) malloc(sizeof(LINKED_LIST_TYPE(type))); \
									   \
    new_elem->data = d; /* The type needs to be copyable */		   \
    new_elem->next = *pp;						   \
    *pp = new_elem;							   \
}


#define LINKED_LIST_REMOVE_FIRST_FUNCTION(type)				\
static inline								\
void									\
linked_list_ ## type ## _remove_first(LINKED_LIST_TYPE(type)** pp)	\
{									\
    LINKED_LIST_TYPE(type) * old_elem = *pp;				\
									\
    *pp = old_elem->next;						\
    free(old_elem);							\
}

#define LINKED_LIST_REMOVE_ALL_FUNCTION(type)				\
static inline								\
void									\
linked_list_ ## type ## _remove_all(LINKED_LIST_TYPE(type)** pp)	\
{									\
    while (*pp != NULL)							\
    {									\
	linked_list_ ## type ## _remove_first(pp);			\
    }									\
}

#define LINKED_LIST_CLEAN_FROM_FUNCTION(type)				 \
static									 \
void									 \
linked_list_ ## type ## _clean_from(LINKED_LIST_TYPE(type)** pp, type d) \
{									 \
    while (*pp)								 \
    {									 \
	if ((*pp)->data == d)						 \
	{								 \
	    linked_list_ ## type ## _remove_first(pp);			 \
	}								 \
	else								 \
	{								 \
      	    pp = &((*pp)->next);					 \
	}								 \
    }									 \
}

#define LINKED_LIST_CLEAN_FROM_SORTED_FUNCTION(type)			\
static									\
void									\
linked_list_ ## type ## _clean_from_sorted(LINKED_LIST_TYPE(type)** pp,	\
					   type d)			\
{									\
    while (*pp								\
	   && !(d < (*pp)->data))					\
    {									\
	if ((*pp)->data == d)						\
	{								\
	    linked_list_ ## type ## _remove_first(pp);			\
	}								\
	else								\
	{								\
      	    pp = &((*pp)->next);					\
	}								\
    }									\
}

#define LINKED_LIST_COUNT_ELEMENTS_FUNCTION(type)			\
static inline								\
unsigned int								\
linked_list_ ## type ## _count_elements(LINKED_LIST_TYPE(type) * p)	\
{									\
    int i;								\
									\
    for(i = 0; p != NULL; p = p->next, i++);				\
    return i;								\
}

#define LINKED_LIST_SORTED_INSERT_LT_FUNCTION(type)			\
static									\
void									\
linked_list_ ## type ## _sorted_insert_lt(LINKED_LIST_TYPE(type) ** pp,	\
					  type d)			\
{									\
    if (*pp								\
	&& !(d < (*pp)->data))						\
    {									\
	linked_list_ ## type ## _insert_first(pp, d);			\
    }									\
    else								\
    {									\
	linked_list_ ## type ## _sorted_insert_lt(&((*pp)->next), d);	\
    }									\
}


/*
 * A Stack
 * The stack has both a type and a name.
 * From the linked list above, we make a stack template.
 *
 * Requires:
 * LINKED_LIST_TYPE_DEFINITION(type, empty);
 * LINKED_LIST_FIRST_ELEMENT_FUNCTION(type);
 * LINKED_LIST_INSERT_FIRST_FUNCTION(type);
 * LINKED_LIST_REMOVE_FIRST_FUNCTION(type);
 */
#define A_STACK(type, name, empty)					\
static LINKED_LIST_TYPE(type) * name ## _stack = empty;			\
									\
static inline								\
void									\
push_ ## name(type d)							\
{									\
    linked_list_ ## type ## _insert_first(&name ## _stack, d);		\
}									\
									\
static inline								\
type									\
pop_ ## name(void)							\
{									\
    if (name ## _stack != NULL)						\
    {									\
	type ret;							\
									\
	ret = name ## _stack->data;					\
	linked_list_ ## type ## _remove_first(&name ## _stack);		\
	return ret;							\
    }									\
    return type ## _empty;						\
}									\
									\
static inline								\
type									\
peek_ ## name(void)							\
{									\
    return linked_list_ ## type ## _first_element(name ## _stack);	\
}

/*
 * clean_NAME_stack_from
 *
 * Requires:
 * LINKED_LIST_CLEAN_FROM_FUNCTION(type)
 */
#define A_STACK_CLEAN_FROM_FUNCTION(type, name)			\
static inline							\
void								\
clean_ ## name ## _stack_from(type d)				\
{								\
    linked_list_ ## type ## _clean_from(&name ## _stack, d);	\
}

/*
 * NAME_remove_all
 *
 * Requires:
 * LINKED_LIST_REMOVE_FIRST_FUNCTION(type)
 * LINKED_LIST_REMOVE_ALL_FUNCTION(type)
 */
#define A_STACK_REMOVE_ALL_FUNCTION(type, name)			\
static inline							\
void								\
name ## _remove_all(void)					\
{								\
    linked_list_ ## type ## _remove_all(&name ## _stack);	\
} 

/*
 * NAME_contains
 *
 * Requires:
 * LINKED_LIST_TYPE
 */
#define A_STACK_CONTAINS_FUNCTION(type, name)		\
static inline						\
int							\
name ## _contains(type t)				\
{							\
    LINKED_LIST_TYPE(type) * p = name ## _stack;	\
							\
    while (p)						\
    {							\
	if (p->data == t)				\
	    return TRUE;				\
	p = p->next;					\
    }							\
    return FALSE;					\
}


#endif
