/*
 * Luola - 2D multiplayer cavern-flying game
 * Copyright (C) 2003 Calle Laakkonen
 *
 * File        : sweapon.c
 * Description : Special weapon specific code
 * Author(s)   : Calle Laakkonen
 *
 * Luola is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Luola is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <math.h>
#include <stdlib.h>
#include <string.h>

#include "defines.h"
#include "console.h"
#include "sweapon.h"
#include "player.h"
#include "particle.h"
#include "level.h"
#include "weather.h"

/* Homing missile. Seeks players */
void missile_movement(Projectile *proj) {
  int p,i1,i2;
  double f0,f1;
  addParticle(make_particle(proj->x,proj->y,5));
  p=find_nearest_player(proj->x,proj->y,proj->owner,&f0);
  if(p==-1) return;
  i1=players[p].ship->x-proj->x;
  i2=players[p].ship->y-proj->y;
  f1=atan2(i1,i2);
  if((players[p].ship->visible==0 && players[p].ship->tagged==0) && f0<130) f1=proj->angle;
  if(proj->angle<0 && f1>0) {
    if( (f1-proj->angle) > (fabs(-M_PI-proj->angle)+M_PI-f1) ) proj->angle-=0.2; else proj->angle+=0.2;
  } else if(proj->angle>0 && f1<0) {
    if( (proj->angle-f1) > (fabs(-M_PI-f1)+M_PI-proj->angle) ) proj->angle+=0.2; else proj->angle-=0.2;
  } else if (proj->angle<f1 ) proj->angle+=0.2; else if(proj->angle!=f1) proj->angle-=0.2;
  if(proj->angle<-M_PI) proj->angle=M_PI;
  else if(proj->angle>M_PI) proj->angle=-M_PI;
  if(players[p].ship->shieldup && f0 < 70) { if(proj->angle>f1) proj->angle+=1; else proj->angle-=1; }
  proj->vector=makeVector(sin(proj->angle)*-8.0,cos(proj->angle)*-8.0);
}

void magmine_movement(Projectile *proj) {
  Ship *ship;
  double f1;
  ship=find_nearest_ship(proj->x,proj->y,NULL,&f1);
  if(f1<60) {
    proj->vector.x=(-(ship->x-proj->x)/4.0);
    proj->vector.y=(-(ship->y-proj->y)/4.0);
  } else { proj->vector.x=0; proj->vector.y=0; }
}

void dividingmine_movement(Projectile *proj,struct Projectile_list *others) {
  int crowd=0;
  double d;
  while(others) {
    /* Tip. Comment out the second haalf of this if clause for extra fun... ;) */
    if(others->projectile!=proj && others->projectile->type==DividingMine) {
      d=hypot(others->projectile->x-proj->x,others->projectile->y-proj->y);
      if(d<55.0) {
        crowd++;
        if(d<25.0) {
           proj->vector.x+=((others->projectile->x-proj->x)/(abs(others->projectile->x-proj->x)+0.1))/1.3;
           proj->vector.y+=((others->projectile->y-proj->y)/(abs(others->projectile->y-proj->y)+0.1))/1.3;
        }
      }
    }
    others=others->next;
  }
  if(crowd>6) proj->var1=0;
  else if(proj->var1==0) proj->var1=DIVIDINGMINE_INTERVAL+DIVIDINGMINE_RAND/2-rand()%DIVIDINGMINE_RAND;
  proj->vector.x/=1.1;
  proj->vector.y/=1.1;
  /* Divide */
  if(proj->var1==1) {
    Projectile *newmine;
    proj->var1=DIVIDINGMINE_INTERVAL+DIVIDINGMINE_RAND/2-rand()%DIVIDINGMINE_RAND;
    proj->primed=5;
    newmine=(Projectile*)malloc(sizeof(Projectile));
    memcpy(newmine,proj,sizeof(Projectile));
    d=(rand()%360)/360.0*(2.0*M_PI);
    newmine->vector.x=sin(d)*1.0;
    newmine->vector.y=cos(d)*1.0;
    add_projectile(newmine);
  } else if(proj->var1>1) proj->var1--;
}

void mine_movement(Projectile *proj) {
  int p;
  double f1;
  p=find_nearest_player(proj->x,proj->y,-1,&f1);
  if(f1<40) proj->color=col_gray; else proj->color=0;
}

void rocket_movement(Projectile *proj) {
  if(proj->primed==0) addParticle(make_particle(proj->x,proj->y,5));
}

void mirv_movement(Projectile *proj) {
  if(proj->primed==0) addParticle(make_particle(proj->x,proj->y,5));
  if(proj->life==1) {
	Projectile *mirv2;
	int p;
	proj->var1--;
	if(proj->var1>0) proj->life=MIRV_LIFE; else proj->life=-1;
    for(p=-1;p<2;p+=2) {
      mirv2=make_projectile(proj->x,proj->y,proj->vector);
	  mirv2->gravity=proj->gravity;
	  mirv2->color=proj->color;
	  mirv2->angle=proj->angle-((double)p)/4.0;
	  mirv2->vector.x=sin(mirv2->angle)*-3.0;
      mirv2->vector.y=cos(mirv2->angle)*-3.0;
      mirv2->type=Mirv;
      mirv2->var1=proj->var1;
	  mirv2->life=proj->life;
      add_projectile(mirv2);
    }
	proj->vector.x=sin(proj->angle)*-3.0;
	proj->vector.y=cos(proj->angle)*-3.0;
  }
}

void spear_movement(Projectile *proj) {
  proj->angle=atan2(proj->vector.x,proj->vector.y);
}

void energy_movement(Projectile *proj) {
  Particle *part;
  float p;
  for(p=1;p<=3;p++) {
    part=make_particle(proj->x-round(proj->vector.x/p),proj->y-round(proj->vector.y/p),30);
    part->color[0]=255; part->color[1]=255; part->color[2]=0;
#if !HAVE_LIBSDL_GFX
    part->rd=-8; part->gd=-8; part->bd=0;
#else
    part->rd=0; part->gd=0; part->bd=0;
#endif
    part->vector.x=0; part->vector.y=0;
    addParticle(part);
  }
}

void magwave_movement(Projectile *proj) {
  Particle *part;
  double r;
  char c;
  for(r=-M_PI;r<M_PI;r+=0.6) {
    c=rand()%128;
    part=make_particle(proj->x,proj->y,4);
    part->color[0]=c; part->color[1]=c; part->color[2]=255;
#if !HAVE_LIBSDL_GFX
    part->rd=-c>>3; part->gd=-c>>3; part->bd=-255>>3;
#else
    part->rd=0; part->gd=0; part->bd=0; part->ad=-255>>3;
#endif
    part->vector.x=sin(r)*3.0; part->vector.y=cos(r)*3.0;
    addParticle(part);
  }
}

void tag_movement(Projectile *proj) {
  Particle *part;
  part=make_particle(proj->x,proj->y,30);
  part->color[0]=255; part->color[1]=110; part->color[2]=180;
  part->rd=0; part->gd=0; part->bd=0;
  part->x+=(rand()%8-4);
  part->vector.x=(rand()%4-2)/2.0-weather_wind_vector;
  part->vector.y=2;
  addParticle(part);
  proj->var1++;
  if(proj->color==col_red) {
    if(proj->var1>4) { proj->var1=0; proj->color=col_white; }
  } else {
    if(proj->var1>2) { proj->var1=0; proj->color=col_red; }
  }
}

void acid_movement(Projectile *proj) {
  Particle *part;
  Ship *hp;
  part=make_particle(proj->x,proj->y,15);
  part->color[0]=255; part->color[1]=255; part->color[2]=255; part->ad=-17;
  part->rd=0; part->gd=0; part->bd=0;
  part->vector.x=(rand()%4-2)/2.0-weather_wind_vector;
  part->vector.y=2;
  addParticle(part);
  hp=hit_ship(proj->x,proj->y,proj->owner,15);
  if(hp) {
    proj->x=hp->x;
    proj->y=hp->y;
    ship_damage(hp,proj);
  }
}

void water_movement(Projectile *proj) {
  Particle *part;
  part=make_particle(proj->x,proj->y,2);
  part->color[0]=lev_watercolrgb[0];
  part->color[1]=lev_watercolrgb[1];
  part->color[2]=lev_watercolrgb[2];
  part->color[3]=255;
  part->rd=0;part->gd=0;part->bd=0;part->ad=-128;
  part->vector.x=0; part->vector.y=0;
  addParticle(part);
}

void ember_movement(Projectile *proj) {
  int dx,dy,p;
  for(p=0;p<2+proj->var1;p++) {
    dx=3-rand()%6;
    dy=3-rand()%6;
    start_burning(proj->x+dx,proj->y+dy);
  }
  proj->color=burncolor[rand()%FIRE_FRAMES];
  if(proj->life==1) {
    Projectile *ember2;
    proj->var1--;
    if(proj->var1==1) proj->life=EMBER_LIFE; else proj->life=-1;
    proj->vector.y/=3.0;
    spawn_clusters(proj->x,proj->y,16,-1,FireStarter);
    for(p=-1;p<3;p++) {
      ember2=make_projectile(proj->x,proj->y,proj->vector);
      ember2->gravity=proj->gravity;
      ember2->vector.x=proj->vector.x-(double)p;
      ember2->vector.y=proj->vector.y;
      ember2->type=Ember;
      ember2->var1=proj->var1;
      ember2->life=proj->life;
      add_projectile(ember2);
    }
    proj->vector.x+=2.0;
  }
}
void napalm_movement(Projectile *proj) {
  Ship *hp;
  char r;
  start_burning(proj->x,proj->y);
  hp=hit_ship(proj->x,proj->y,proj->owner,15);
  if(hp) {
    proj->x=hp->x;
    proj->y=hp->y;
    ship_damage(hp,proj);
    for(r=0;r<3;r++)
      start_burning(proj->x+(5-rand()%10),proj->y+(5-rand()%10));
  }
}

void boomerang_movement(Projectile *proj) {
  double f1;
  if(proj->var1<=10) proj->var1++;
  if(proj->var1>10) {
    f1=atan2(players[proj->owner].ship->x-proj->x,players[proj->owner].ship->y-proj->y);
    if(proj->angle<0 && f1>0) {
      if( (f1-proj->angle) > (fabs(-M_PI-proj->angle)+M_PI-f1) ) proj->angle-=0.3; else proj->angle+=0.3;
    } else if(proj->angle>0 && f1<0) {
      if( (proj->angle-f1) > (fabs(-M_PI-f1)+M_PI-proj->angle) ) proj->angle+=0.3; else proj->angle-=0.3;
    } else if (proj->angle<f1 ) proj->angle+=0.3; else if(proj->angle!=f1) proj->angle-=0.3;
    if(proj->angle<-M_PI) proj->angle=M_PI;
    else if(proj->angle>M_PI) proj->angle=-M_PI;
    proj->vector=makeVector(sin(proj->angle)*-6.0,cos(proj->angle)*-6.0);
  }
}

void mush_movement(Projectile *proj) {
  if(fabs(proj->vector.x)>0.5) {
    if(proj->var1==2) {
      add_projectile(make_projectile(proj->x,proj->y,makeVector(0,0)));
      proj->var1=0;
    } else proj->var1++;
  }
}


