/* ---------------------------------- manage.cpp ---------------------------------------------------------------------------
 Class to display the manage backups dialog

===============================================================================================================================
===============================================================================================================================
     This file is part of "luckyBackup" project
     Copyright 2008-2010, Loukas Avgeriou
     luckyBackup is distributed under the terms of the GNU General Public License
     luckyBackup is free software: you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation, either version 3 of the License, or
     (at your option) any later version.
 
     luckyBackup is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
 
     You should have received a copy of the GNU General Public License
     along with luckyBackup.  If not, see <http://www.gnu.org/licenses/>.

 project version	: Please see "main.cpp" for project version

 developer 		: luckyb 
 last modified 		: 08 Jun 2010
===============================================================================================================================
===============================================================================================================================
*/
#include "manage.h"
#include "logDialog.cpp"
#include "manageWizard.cpp"

// class manageDialog Constructor=================================================================================================
// Displays the manage backups of a task dialog
manageDialog::manageDialog (QDialog *parent) : QDialog (parent)
{
	// initialize variables
	CurrentSnapshotString = "";
	CurrentSnapshotDirectory = "";
	CurrentSnapshotNo = 0;
	
	//first set string variables source, dest
	QStringList arguments = Operation[currentOperation] -> GetArgs();
	source = arguments[arguments.size()-2];
	dest = arguments[arguments.size()-1];
	sourceLast = "";

	//fix source and dest
	if (!source.endsWith("/"))	// this means task is of type "backup dir by name"
	{
		sourceLast = source;
		if (sourceLast.contains(":"))	// this is normal for a remote directory
			sourceLast = sourceLast.right(source.size()-sourceLast.lastIndexOf(":")-1);	//this is the remote source dir without the remote pc
		if (source.contains("/"))	// this is normal for a directory unless it is remote
			sourceLast = sourceLast.right(source.size()-sourceLast.lastIndexOf("/")-1);	//this is the lowest dir of source
		
		sourceLast.append("/");
		source.append("/");
		dest.append(sourceLast);
	}

	uiG.setupUi(this);

	//connect pushButton SLOTs ----------------
	connect ( uiG.pushButton_cancel, SIGNAL( clicked() ), this, SLOT( cancel() ) );
	connect ( uiG.pushButton_viewLog, SIGNAL( clicked() ), this, SLOT( logView() ) );
	connect ( uiG.pushButton_restore, SIGNAL( clicked() ), this, SLOT( restoreBackup() ) );
	connect ( uiG.pushButton_delete, SIGNAL( clicked() ), this, SLOT( deleteBackup() ) );
	connect ( uiG.checkBox_viewSource, SIGNAL( clicked() ), this, SLOT( hideSourceStuff() ) );
	connect ( uiG.listWidget_dates, SIGNAL( itemSelectionChanged() ), this, SLOT( SnapshotsListSelected() ) );
	connect ( uiG.pushButton_calculate_diffs, SIGNAL ( clicked() ), this, SLOT ( calculateDifferences() ) );
	

	//____________________Initial gui changes (these will remain the same for as long as the gui is visible)_______________
	
	// set the text to labels profile & task
	uiG.label_profile -> setText (tr("profile")+ ": <font color = blue><b>" +profileName + "</b></font>");
	uiG.label_task -> setText (tr("task") + ": <font color = blue><b>" + Operation[currentOperation] -> GetName() + "</b></font>");
	
	//resize the treeview headers
	uiG.treeView_browser -> header() -> resizeSection(0,230);
	uiG.treeView_source -> header() -> resizeSection(0,230);
	uiG.treeView_browser -> header() -> resizeSection(1,80);
	uiG.treeView_source -> header() -> resizeSection(1,80);
	uiG.treeView_browser -> header() -> resizeSection(2,60);
	uiG.treeView_source -> header() -> resizeSection(2,60);
	uiG.treeView_browser -> header() -> resizeSection(3,100);
	uiG.treeView_source -> header() -> resizeSection(3,100);

	// Set the lineEdits source & dest with real paths
	uiG.lineEdit_destination -> setText(dest);
	uiG.lineEdit_source	-> setText(source);
	
	updateSnapshots();	// update the snapshots listWidget
	SnapshotsListSelected(); //set currentSnapshotString & No. Will also call fixGui()
}
// SLOTS-------------------------------------------------------------------------------------
// --------------------------------cancel pressed------------------------------------------------
void manageDialog::cancel()
{
	close();
}

// SLOT logView =====================================================================================================================
// Display the logfile
void manageDialog::logView()
{
	QUrl logURL;
	logURL.setScheme("file");
	logURL.setUrl("Does_not_exist");

	//extract the logfilename from the dates listwidget
	logfilename = CurrentSnapshotString;
	logfilename.prepend(logDir + profileName + "-" + Operation[currentOperation] -> GetName() + "-");
	logfilename.append(".log");	
	
	logfile.setFileName(logfilename); // this is the logfile of the item selected
	if (logfile.exists())	//if the logfile exists
		logURL.setUrl(logfilename);

	logDialog logdialog (logURL);
	logdialog.exec();
}

// SLOT restoreBackup =====================================================================================================================
// launch the restore wizard
void manageDialog::restoreBackup()
{
	manageWizard restoreWizard("restoreBackup", source, dest, CurrentSnapshotNo);	//pass the number of the current row
	restoreWizard.exec();
	
	fixGui();	// update the gui with new dirs data
}

// SLOT deleteBackup =====================================================================================================================
// Launch the delete backup wizard
void manageDialog::deleteBackup()
{
	
	// launch the delete backup wizard
	manageWizard deleteWizard("deleteBackup", source, dest, CurrentSnapshotNo);
	deleteWizard.exec();

	updateSnapshots();	// update the snapshots listwidget
	SnapshotsListSelected(); // set a new currentSnapshot and update the gui
}

// fixGui  =====================================================================================================================
// makes some changes to the gui according to various stuff to make it prettier !!
// also update treebrowsers with new snapshot data
void manageDialog::fixGui()
{
	// these will become false if dest or source treebrowsers are to be hidden
	bool destVisible = TRUE;
	sourceVisible = TRUE;

	//Thesw will become false if relevant pushButtons have to be disabled
	bool viewLogVisible = TRUE;
	bool deleteVisible = TRUE;
	bool restoreVisible = TRUE;
	
	syncTYPE = FALSE;	// This will become true if it is a sync task
	
	// Destination - Do all things needed to display the current snapshot only.
	QDir CurrentSnapshotDir(CurrentSnapshotDirectory);
	
	// set the model of the treebrowsers (source & destination) sort by name & refresh to use new source & dest
	//destination
	QDirModel *d_model = new QDirModel;
	d_model -> setFilter(QDir::AllDirs | QDir::NoDotAndDotDot | QDir::AllEntries | QDir::Hidden);
	d_model -> setSorting(QDir::Name | QDir::DirsFirst | QDir::IgnoreCase | QDir::LocaleAware);

	uiG.treeView_browser -> setModel(d_model);
	uiG.treeView_browser -> sortByColumn (0, Qt::AscendingOrder);
	//if (CurrentSnapshotDir.exists())
	//	uiG.treeView_browser -> setRootIndex(d_model->index(CurrentSnapshotDirectory));
	//else
		uiG.treeView_browser -> setRootIndex(d_model->index(dest));
	
	//source
	QDirModel *s_model = new QDirModel;
	s_model -> setFilter(QDir::AllDirs | QDir::NoDotAndDotDot | QDir::AllEntries | QDir::Hidden);
	s_model -> setSorting(QDir::Name | QDir::DirsFirst | QDir::IgnoreCase | QDir::LocaleAware);
	uiG.treeView_source	-> setModel(s_model);
	uiG.treeView_source 	-> sortByColumn (0, Qt::AscendingOrder);
	uiG.treeView_source	-> setRootIndex(s_model->index(source));
	
	// if a snapshot is not selected 
	if (CurrentSnapshotString == "")
	{
		viewLogVisible = FALSE;
		deleteVisible = FALSE;
		restoreVisible = FALSE;

		if (!Operation[currentOperation] -> GetTypeSync())
		{
			destVisible = FALSE;
			uiG.label_destError -> setText("<font color=magenta>" + tr("Please select a snapshot from the list",
										   "Information message") + "</font>");
		}
	}
	
	// if "not available" is selected
	if (CurrentSnapshotString == "not available")
		viewLogVisible = FALSE;	//disable the "view log" button

	// _______________________________ source & destination directories checks ____________________________________________
	// ___________________________________________________________________________________________________________________
	// check if source & destination exist or have read/enter permissions or are remote ----------------------------------
	QFileInfo destFile(dest);
	QFileInfo sourceFile(source);
	bool sourceRemote = (Operation[currentOperation] -> GetRemote()) && (Operation[currentOperation] -> GetRemoteSource());
	bool destRemote = (Operation[currentOperation] -> GetRemote()) && (Operation[currentOperation] -> GetRemoteDestination());
	
	if (sourceRemote)		// If remote is used for source
	{
		sourceVisible = FALSE;
		uiG.label_sourceError -> setText("<font color=magenta>" + tr("Display of remote places is not supported",
										   "Information message") + "</font>");
	}
	if (destRemote)			// If remote is used for destination
	{
		destVisible = FALSE;
		
// ********************** WARNING - Change this when you figure out a way to display/delete remote places *************************************
		uiG.label_destError -> setText("<font color=magenta>" + tr("Display of remote places is not supported",
										   "Information message") + "</font>");
		deleteVisible = FALSE;		//disable the delete button
	}
	// If source does not exist (and is not remote)
	if ((!sourceFile.exists()) && (!sourceRemote))
	{
		sourceVisible = FALSE;
		uiG.label_sourceError -> setText("<font color=red>" + tr("This directory does not exist") + "</font>");
	}
	// If destination does not exist
	if ((!destFile.exists()) && !(destRemote))
	{
		destVisible = FALSE;
		uiG.label_destError -> setText("<font color=red>" + tr("This directory does not exist",
										   "Information message") + "</font>");
		if (CurrentSnapshotString == "not available")
			deleteVisible = FALSE;	//disable the delete button
		restoreVisible = FALSE;	//disable the restore button
	}
	// If source does not have read/enter permissions
	if (((!sourceFile.isReadable()) || (!sourceFile.isExecutable())) && (!sourceRemote) && (sourceFile.exists()))
	{
		sourceVisible = FALSE;
		uiG.label_sourceError -> setText("<font color=red>" + tr("I do not have sufficient permissions to read this directory",
										   "Information message") + "</font>");
		restoreVisible = FALSE;	//disable the restore button
	}
	// If destination does not have read/enter permissions
	if (((!destFile.isReadable()) || (!destFile.isExecutable())) && (!destRemote) && (destFile.exists()))
	{
		destVisible = FALSE;
		uiG.label_destError -> setText("<font color=red>" + tr("I do not have sufficient permissions to read this directory",
										   "Information message") + "</font>");
		deleteVisible = FALSE;		//disable the delete button
		restoreVisible = FALSE;	//disable the restore button
	}

	// _______________________________ source & destination directories checks END____________________________________________
	// ___________________________________________________________________________________________________________________
	
	//if this is a "sync" task
	if (Operation[currentOperation] -> GetTypeSync())
	{
		syncTYPE = TRUE;
		uiG.label_destination -> setText (tr("sync dir A","full phrase: sync dir a: <DIRECTORY_A>")+ ": ");
		uiG.label_source -> setText (tr("sync dir B","full phrase: sync dir a: <DIRECTORY_b>")+ ": ");
		uiG.pushButton_viewLog -> setToolTip(tr("View the logfile of the selected sync task","'view log' pushbutton tooltip"));
		deleteVisible = FALSE;
		restoreVisible = FALSE;
		uiG.checkBox_viewSource -> setVisible(FALSE);
	}

	// hide or show the treebrowsers - textbrowser
	uiG.textBrowser_snapshot -> setVisible (FALSE);
	uiG.treeView_browser -> setVisible (destVisible);
	uiG.label_destError -> setVisible (!destVisible);
	hideSourceStuff();
	
	//enable/disable the pushbuttons
	uiG.pushButton_viewLog -> setEnabled(viewLogVisible);
	uiG.pushButton_calculate_diffs -> setEnabled(destVisible);

	// Enable the delete button only for the first snapshot in list
	if (CurrentSnapshotNo > 0)
		deleteVisible = FALSE;
	
	uiG.pushButton_delete -> setEnabled(deleteVisible);
	uiG.pushButton_restore -> setEnabled(restoreVisible);
}

// hideSourceStuff  =====================================================================================================================
// hides/shows the source treebrowser & label
void manageDialog::hideSourceStuff()
{
	// Check the state of the "hide source" checkbox
	bool boxState = uiG.checkBox_viewSource -> isChecked();
	
	if (boxState)
	{
		uiG.label_source -> setVisible(FALSE);
		uiG.lineEdit_source -> setVisible(FALSE);
		uiG.label_sourceError -> setVisible (FALSE);
		uiG.treeView_source -> setVisible (FALSE);
	}
	else
	{
		uiG.label_source -> setVisible(TRUE);
		uiG.lineEdit_source -> setVisible(TRUE);
		uiG.treeView_source -> setVisible (sourceVisible);
		uiG.label_sourceError -> setVisible (!sourceVisible);
	}
}

// SnapshotsListSelected  =====================================================================================================================
// disables pushbuttons when nothing is selected at snapshots listwidget
// Also sets QString CurrentSnapshotString at current snapshot, format YYYY
void manageDialog::SnapshotsListSelected()
{
	CurrentSnapshotNo = uiG.listWidget_dates -> currentRow();
	// if a snapshot is not selected 
	if (CurrentSnapshotNo < 0)
	{
		CurrentSnapshotString = "";
		CurrentSnapshotDirectory = "";
	}
	else
	{
		CurrentSnapshotString = Operation[currentOperation] -> GetSnapshotsListItem (CurrentSnapshotNo);
		CurrentSnapshotDirectory = dest + snapDefaultDir + CurrentSnapshotString + "/" + sourceLast;
		if (CurrentSnapshotString == "")	// if there is no execution time of the current snapshot
			CurrentSnapshotString = "not available";
	}

	fixGui();	// update the gui
}

// calculateDifferences() ========================================================================================
// calculate differences between source and snapshot
// Calls readDirEntries()
void manageDialog::calculateDifferences()
{	
	if (!snapCalculated.at(CurrentSnapshotNo))	// if the differences have not been calculated yet
	{
		// first ask the user if he/she wants to go on
		QString boxMessage = tr("WARNING: The application might seem frozen for a long time if the amount of data to take into consideration is huge.") + 
					"\n" + tr("Are you sure you wish to continue ??");
		textDialog textdialogQ ("QtQuestion", boxMessage, this);
		textdialogQ.exec();

		if (textdialogQ.getGoOn() == 0)		//if user answers yes
			return;
		
		// Update the textBrowser_snapshot with differences data
		calculatedDifferences.replace(CurrentSnapshotNo, readDirEntries(dest) );
		snapCalculated.replace(CurrentSnapshotNo, TRUE );
	}
	
	// hide stuff and show the calculated diffs
	if (syncTYPE)
	{
		uiG.label_source -> setVisible(FALSE);
		uiG.lineEdit_source -> setVisible(FALSE);
		uiG.treeView_source -> setVisible (FALSE);
	}
	//uiG.pushButton_calculate_diffs -> setEnabled(destVisible);
	uiG.textBrowser_snapshot -> setVisible (TRUE);
	uiG.treeView_browser -> setVisible (FALSE);
	uiG.textBrowser_snapshot -> setText (calculatedDifferences.at(CurrentSnapshotNo));
}
		
// FUNCTIONS-------------------------------------------------------------------------------------

// updateSnapshots  =====================================================================================================================
// update the snapshots date & times listwidget
void manageDialog::updateSnapshots()
{
	//clear the listWidget
	uiG.listWidget_dates -> clear();
	calculatedDifferences.clear();		// this holds the calculated differences text for each snapshot
	snapCalculated.clear();
	
	//initialize snapshot variables
	currentSnaps = Operation[currentOperation] -> GetSnapshotsListSize();	// this is the current number of snapshots
	bool emptySnapList = Operation[currentOperation] -> SnapshotsListIsEmpty();	// Is the list empty ??
	
	// first check if there is a last execution time available but no snapshots are declared
	// and add a new snapshot with the last execution date-time
	time = ( Operation[currentOperation] -> GetLastExecutionTime() ).toString("yyyyMMddhhmmss");
	if ( !(time == "") && (emptySnapList) )
	{
		Operation[currentOperation] -> AddSnapshotsListItem (time);
		currentSnaps = Operation[currentOperation] -> GetSnapshotsListSize();	// this is the current number of snapshots
		emptySnapList = Operation[currentOperation] -> SnapshotsListIsEmpty();	// Is the list empty ??
	}
	
	//update the listwidget with times from snapshots
	count=0;
	while (count < currentSnaps)
	{
		QDateTime currentSnapTime = QDateTime::fromString(Operation[currentOperation]-> GetSnapshotsListItem(count),"yyyyMMddhhmmss");
		if ((Operation[currentOperation]-> GetSnapshotsListItem(count)) == "")	// if there is no snapshot time for a reason
			uiG.listWidget_dates -> addItem (tr("not available","refers to a date-time"));
		else
			uiG.listWidget_dates -> addItem (currentSnapTime.toString("yyyy/MM/dd - hh:mm:ss"));
		
		calculatedDifferences.append("");
		snapCalculated.append(FALSE);
		
		count++;
	}
	
	if (emptySnapList)
		uiG.listWidget_dates -> addItem (tr("not available","refers to a date-time"));

	// select the latest snapshot
	uiG.listWidget_dates	-> setCurrentRow(uiG.listWidget_dates -> count() - 1);
}

// readDirEntries =====================================================================================================================
// Read all entries of a directory except stuff we do not want to
QString manageDialog::readDirEntries(QString dirToReadString)
{
	QFileInfoList readRecursive(QString);
	QString returnString = "";
	//uiG.textBrowser_snapshot -> append ("<br><br>" + tr("Reading destination... "));
	QFileInfoList returnDirContents = readRecursive(dirToReadString);		//this is the destination as a Qfileinfo list
	
	int countDirEntries=0, countReturnEntries=0;

	// Remove the "luckybackup snapshots root" directory from the returnDirContents list
	countReturnEntries = 0;
	while ( (countReturnEntries < returnDirContents.size())  && (!syncTYPE) )
	{
		QFileInfo localFileInfo = returnDirContents.at(countReturnEntries);
		if ( (localFileInfo.filePath()+"/").contains((dest + snapDefaultDir)) )
			returnDirContents.removeAt(countReturnEntries);
		else
			countReturnEntries++;
	}

	
	// Remove files/dirs listed at changes.file from the QFileInfo list (destination)
	QStringList removedFiles;
	removedFiles.clear();
	count = CurrentSnapshotNo+1;
	while ( (count < currentSnaps)  && (!syncTYPE) )
	{
		snapchangesfilename = snapChangesDir + profileName + "-" + Operation[currentOperation] -> GetName() + "-" +
					(Operation[currentOperation] -> GetSnapshotsListItem(count)) + ".changes.log";
		snapfile.setFileName(snapchangesfilename);
		snapfile.open(QIODevice::ReadOnly | QIODevice::Text);
		QTextStream in(&snapfile);
		while (!in.atEnd())
			removedFiles.append(in.readLine());
			
		snapfile.close();
		
		count++;
	}
	countReturnEntries = 0;
	
	while ( (countReturnEntries < returnDirContents.size())  && (!syncTYPE) )
	{
		QFileInfo localFileInfo = returnDirContents.at(countReturnEntries);
		QString destFile = localFileInfo.filePath();
		destFile.remove(dest, Qt::CaseSensitive);
		
		countDirEntries = 0;
		bool removed = FALSE;
		while (countDirEntries < removedFiles.size())
		{
			if (destFile == removedFiles.at(countDirEntries))
			{
				removed = TRUE;
				returnDirContents.removeAt(countReturnEntries);
			}
			countDirEntries++;
		}
		if (removed)
			removed = FALSE;
		else
			countReturnEntries++;
	}

	// Replace destination directory data with snapshot data - NOT in sync mode
	QDir currentsnapdir(CurrentSnapshotDirectory);
	if ( (currentsnapdir.exists()) && (!syncTYPE) )
	{
		QFileInfoList currentsnapdirContents = readRecursive(CurrentSnapshotDirectory); // this is the snapshots directory as a QFileInfo list
		countDirEntries = 0;
		
		while (countDirEntries < currentsnapdirContents.size())
		{
			//strip off beginning of snapshot file path
			QFileInfo snapFileInfo = currentsnapdirContents.at(countDirEntries);
			QString snapFile = snapFileInfo.filePath();
			snapFile.remove(dest + snapDefaultDir + CurrentSnapshotString + "/" + sourceLast, Qt::CaseSensitive);
			
			countReturnEntries = 0;
			bool replaced = FALSE;
			while (countReturnEntries < returnDirContents.size())
			{
				QFileInfo localFileInfo = returnDirContents.at(countReturnEntries);
				QString destFile = localFileInfo.filePath();
				destFile.remove(dest, Qt::CaseSensitive);
				if (snapFile == destFile)
				{
					returnDirContents.removeAt(countReturnEntries);
					returnDirContents.insert(countReturnEntries,snapFileInfo);
					replaced = TRUE;
				}
				countReturnEntries++;
			}
			if (!replaced)
				returnDirContents.append(snapFileInfo);
			countDirEntries++;
		}
	}
	
	// Calculate differences between snapshot and source
	QFileInfoList changedFiles, existingSource, existingSnap;
	QString changedfiles="", existingsource = "", existingsnap = "";
	QList<bool> snapMatchesSource;

	QFileInfoList sourceDirAsList = readRecursive(source);	// This is source as a QFileInfo list
	countDirEntries = 0;
	while (countDirEntries < sourceDirAsList.size())
	{
		bool foundMatchSourceToSnap = FALSE;	// If a file with some filename exists at the source and the snapshot
		// strip off beginning of source file path
		QFileInfo sourceFileInfo = sourceDirAsList.at(countDirEntries);
		QString sourceFile = sourceFileInfo.filePath();
		if (sourceFile.startsWith(source))
			sourceFile.remove(source, Qt::CaseSensitive);
	
		// compare with every file in snapshot
		countReturnEntries = 0;
		while (countReturnEntries < returnDirContents.size())
		{
			if (countDirEntries == 0)
				snapMatchesSource.append(FALSE); // build a <bool> list

			//strip off beginning of snapshot file path
			QFileInfo snapFileInfo = returnDirContents.at(countReturnEntries);
			QString snapFile = snapFileInfo.filePath();
			if (snapFile.startsWith(dest + snapDefaultDir + CurrentSnapshotString) )
				snapFile.remove(dest + snapDefaultDir + CurrentSnapshotString + "/" + sourceLast, Qt::CaseSensitive);
			if (snapFile.startsWith(dest))
				snapFile.remove(dest, Qt::CaseSensitive);
			
			// 1. Data that have changed at source.
			//	The snapshot data will replace the relevant source data, at RESTORE
			if (snapFile == sourceFile)
			{
				snapMatchesSource.replace(countReturnEntries, TRUE);
				foundMatchSourceToSnap = TRUE;
				if ((snapFileInfo.lastModified() != sourceFileInfo.lastModified()) ||
				(snapFileInfo.size() != sourceFileInfo.size()))
				{
					changedFiles.append(snapFileInfo);
					if (snapFileInfo.isDir())
						snapFile.append("/");
					if (changedfiles.size() < 10000)
						changedfiles.append("* <b>" + snapFile + "</b> - " + snapFileInfo.lastModified().toString("yyyy MMM dd - hh:mm:ss") + "<br>");
					
					//else
					//	break;
				}
			}
			
			countReturnEntries++;
		}
		// 2. Data that exist at the source but not at the snapshot
		//	These will be deleted at RESTORE if "delete existing source data that do not exist at the backup" is checked
		if (!foundMatchSourceToSnap)
		{
			existingSource.append(sourceFileInfo);
			if (sourceFileInfo.isDir())
				sourceFile.append("/");
			if (existingsource.size() < 10000)
				existingsource.append("* <b>" + sourceFile + "</b> - " + sourceFileInfo.lastModified().toString("yyyy MMM dd - hh:mm:ss") + "<br>");
		}
		
		countDirEntries++;
	}

	// 3. Data that exist at the snapshot but not at the source.
	// 	These will be transfered over at RESTORE
	countReturnEntries = 0;
	while (countReturnEntries < snapMatchesSource.size())
	{
		if (!snapMatchesSource.at(countReturnEntries))
		{
			QFileInfo snapFileInfo = returnDirContents.at(countReturnEntries);
			QString snapFile = snapFileInfo.filePath();
			if (snapFile.startsWith(dest + snapDefaultDir + CurrentSnapshotString) )
				snapFile.remove(dest + snapDefaultDir + CurrentSnapshotString + "/" + sourceLast, Qt::CaseSensitive);
			if (snapFile.startsWith(dest))
				snapFile.remove(dest, Qt::CaseSensitive);
			if (snapFileInfo.isDir())
				snapFile.append("/");
			
			existingSnap.append(snapFileInfo);
			if (existingsnap.size() < 10000)
				existingsnap.append("* <b>" + snapFile + "</b> - " + snapFileInfo.lastModified().toString("yyyy MMM dd - hh:mm:ss") + "<br>");
		}
		countReturnEntries++;
	}

	returnString.append("<font color=red><p align=\"center\">");
	if (syncTYPE)
		returnString.append("		<b>" + tr("Sync dir A & B differences") + "</b><br>");
	else
		returnString.append("		<b>" + tr("Snapshot and source differences") + "</b><br>");
	returnString.append("_______________________________________________________</p>");
	if (changedfiles != "")
	{
		returnString.append("</font><font color=blue><p align=\"center\">");
		if (syncTYPE)
			returnString.append(" " + tr("Sync dir B data that also exists at sync dir A and is different") + "</p>");
		else
		{
			returnString.append(" " + tr("Snapshot data that also exists at the source and is different") + "<br>");
			returnString.append(" " + tr("The snapshot data will replace the source data during RESTORE") + "</p>");
		}
		returnString.append(changedfiles);
		if (changedfiles.size() > 9900)
			returnString.append(" <br>" + tr("Data amount is huge. Displaying only first entries") + "<br>");
		returnString.append("_______________________________________________________<br>");
	}
	if (existingsnap != "")
	{
		returnString.append("</font><font color=green><p align=\"center\">");
		if (syncTYPE)
			returnString.append(" " + tr("Sync dir B data that do NOT exist at sync dir A") + "</p>");
		else
		{
			returnString.append(" " + tr("Snapshot data that do NOT exist at the source") + "<br>");
			returnString.append(" " + tr("These will be transfered over at the source during RESTORE") + "</p>");
		}
		returnString.append(existingsnap);
		if (existingsnap.size() > 9900)
			returnString.append(" <br>" + tr("Data amount is huge. Displaying only first entries") + "<br>");
		returnString.append("_______________________________________________________<br>");
	}
	if (existingsource != "")
	{
		returnString.append("</font><font color=magenta><p align=\"center\">");
		if (syncTYPE)
			returnString.append(" " + tr("Sync dir A data that do NOT exist at sync dir B") + "</p>");
		else
		{
			returnString.append(" " + tr("Source data that do NOT exist at the snapshot") + "<br>");
			returnString.append(" " + tr("These will be deleted during RESTORE only if you enable the option:") + "<br>");
			returnString.append(" \"<b>" + tr("delete existing source data that do not exist at the backup") + "</b>\"</p>");
		}
		returnString.append(existingsource);
		if (existingsource.size() > 9900)
			returnString.append(" <br>" + tr("Data amount is huge. Displaying only first entries") + "<br>");
		returnString.append("_________________________________________________________________<br>");
	}
	returnString.append("</font>");

	return returnString ;
}

// readRecursive ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Extract a QFileInfoList from a directory's path
QFileInfoList readRecursive(QString dirToReadString)
{
	QFileInfoList readRecursive(QString);	
	
	QDir dirToRead(dirToReadString);
	dirToRead.setFilter(QDir::AllDirs | QDir::NoDotAndDotDot | QDir::AllEntries | QDir::Hidden);
	dirToRead.setSorting(QDir::Name | QDir::DirsFirst | QDir::IgnoreCase | QDir::LocaleAware);
	
	QFileInfoList DirContentsStart = dirToRead.entryInfoList();
	QFileInfoList returnDirContentsFinal;


	QStack<QDir> dirStack;
	dirStack.push(dirToRead);
	
	while( !dirStack.empty() )
	{
		QDir lastDir = dirStack.last();
		lastDir.setFilter(QDir::AllDirs | QDir::NoDotAndDotDot | QDir::AllEntries | QDir::Hidden);
		lastDir.setSorting(QDir::Name | QDir::DirsFirst | QDir::IgnoreCase | QDir::LocaleAware);
		QFileInfoList flist = lastDir.entryInfoList( );
		dirStack.pop();

		foreach (QFileInfo localFileInfo, flist)
		{
			returnDirContentsFinal.append(localFileInfo);
			if (localFileInfo.isDir())
			{
				QDir dirent( localFileInfo.absoluteFilePath() );
				dirStack.push( dirent );
			}
		}
	}


	// old way to do stuff. Delete it if the "stack" way proves to be ok
/*	foreach (QFileInfo localFileInfo, DirContentsStart)
	{
		returnDirContentsFinal.append(localFileInfo);
		if (localFileInfo.isDir())
			returnDirContentsFinal.append(readRecursive(localFileInfo.filePath()));
	}
*/
	return returnDirContentsFinal;
}


// end of manage.cpp ---------------------------------------------------------------------------

